/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java.adapter;

import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.java.adapter.JavaAdapterClassLoader;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public final class JavaAdapterServices {
    private static final MethodType VALUE_EXECUTE_METHOD_TYPE = MethodType.methodType(Value.class, Object[].class);
    private static final MethodType VALUE_EXECUTE_VOID_METHOD_TYPE = MethodType.methodType(Void.TYPE, Object[].class);
    private static final MethodType VALUE_INVOKE_MEMBER_METHOD_TYPE = MethodType.methodType(Value.class, String.class, Object[].class);
    private static final MethodType VALUE_AS_METHOD_TYPE = MethodType.methodType(Object.class, Class.class);
    private static final MethodType CONCAT_ARRAYS_METHOD_TYPE = MethodType.methodType(Object[].class, Object[].class, Object.class);
    private static final Source HAS_OWN_PROPERTY_SOURCE = Source.newBuilder((String)"js", (CharSequence)"(function(obj, name){return Object.prototype.hasOwnProperty.call(obj, name);})", (String)"hasOwnProperty").buildLiteral();
    static final int BOOTSTRAP_VALUE_INVOKE_MEMBER = 1;
    static final int BOOTSTRAP_VALUE_EXECUTE = 2;
    static final int BOOTSTRAP_VARARGS = 4;

    private JavaAdapterServices() {
        assert (!JSConfig.SubstrateVM);
    }

    public static Value getClassOverrides(ClassLoader classLoader) {
        Value overrides = JavaAdapterClassLoader.getClassOverrides(classLoader);
        assert (overrides != null);
        return overrides;
    }

    public static boolean hasMethod(Value obj, String name) {
        return obj.canInvokeMember(name);
    }

    public static boolean hasOwnProperty(Value obj, String name) {
        Value hasOwnProperty = obj.getContext().eval(HAS_OWN_PROPERTY_SOURCE);
        try {
            return hasOwnProperty.execute(new Object[]{obj, name}).asBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFunction(Object obj) {
        return obj instanceof Value && ((Value)obj).canExecute();
    }

    public static UnsupportedOperationException unsupported(String methodName) {
        return new UnsupportedOperationException(methodName);
    }

    public static RuntimeException wrapThrowable(Throwable t) {
        return new RuntimeException(t);
    }

    private static MethodHandle createReturnValueConverter(MethodHandles.Lookup lookup, Class<?> returnType) throws NoSuchMethodException, IllegalAccessException {
        return MethodHandles.insertArguments(lookup.findVirtual(Value.class, "as", VALUE_AS_METHOD_TYPE), 1, returnType);
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String methodName, MethodType type, int flags) throws NoSuchMethodException, IllegalAccessException {
        boolean varargs;
        MethodHandle target;
        if ((flags & 1) != 0) {
            target = lookup.findVirtual(Value.class, "invokeMember", VALUE_INVOKE_MEMBER_METHOD_TYPE);
            target = MethodHandles.insertArguments(target, 1, methodName);
        } else {
            assert ((flags & 2) != 0);
            target = type.returnType() == Void.TYPE ? lookup.findVirtual(Value.class, "executeVoid", VALUE_EXECUTE_VOID_METHOD_TYPE) : lookup.findVirtual(Value.class, "execute", VALUE_EXECUTE_METHOD_TYPE);
        }
        boolean bl = varargs = (flags & 4) != 0;
        if (varargs) {
            TypeDescriptor.OfField varargsParameter = type.parameterType(type.parameterCount() - 1);
            if (type.parameterCount() != 2 || varargsParameter != Object[].class) {
                MethodHandle fixedCollector = MethodHandles.identity(Object[].class).asCollector(Object[].class, type.parameterCount() - 2);
                MethodType fixedCollectorType = MethodType.methodType(Object[].class, Arrays.copyOfRange(type.parameterArray(), 1, type.parameterCount() - 1));
                fixedCollector = fixedCollector.asType(fixedCollectorType);
                MethodHandle concatArray = lookup.findStatic(JavaAdapterServices.class, "concatArrays", CONCAT_ARRAYS_METHOD_TYPE);
                concatArray = concatArray.asType(CONCAT_ARRAYS_METHOD_TYPE.changeParameterType(1, (Class<?>)varargsParameter));
                MethodHandle collector = MethodHandles.collectArguments(concatArray, 0, fixedCollector);
                target = MethodHandles.collectArguments(target, 1, collector);
            }
        } else {
            target = target.asCollector(Object[].class, type.parameterCount() - 1);
        }
        if (type.returnType() != Void.TYPE) {
            target = MethodHandles.filterReturnValue(target, JavaAdapterServices.createReturnValueConverter(lookup, type.returnType()));
        }
        target = target.asType(type);
        return new ConstantCallSite(target);
    }

    public static Object[] concatArrays(Object[] fixed, Object va) {
        int fixedLen = fixed.length;
        int vaLen = Array.getLength(va);
        Object[] concat = Arrays.copyOf(fixed, fixedLen + vaLen);
        for (int i = 0; i < vaLen; ++i) {
            concat[fixedLen + i] = Array.get(va, i);
        }
        return concat;
    }
}

