/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.tregex.automaton.AbstractTransition;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.automaton.TransitionBuilder;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.nfa.ASTStep;
import com.oracle.truffle.regex.tregex.nfa.ASTStepVisitor;
import com.oracle.truffle.regex.tregex.nfa.ASTSuccessor;
import com.oracle.truffle.regex.tregex.nfa.ASTTransition;
import com.oracle.truffle.regex.tregex.nfa.ASTTransitionCanonicalizer;
import com.oracle.truffle.regex.tregex.nfa.NFA;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.MatchFound;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class NFAGenerator {
    private final RegexAST ast;
    private final Counter.ThresholdCounter stateID = new Counter.ThresholdCounter(3500, "NFA explosion");
    private final Counter.ThresholdCounter transitionID = new Counter.ThresholdCounter(Short.MAX_VALUE, "NFA transition explosion");
    private final NFAState dummyInitialState;
    private final NFAState[] anchoredInitialStates;
    private final NFAState[] initialStates;
    private final NFAState anchoredFinalState;
    private final NFAState finalState;
    private final NFAStateTransition[] anchoredEntries;
    private final NFAStateTransition[] unAnchoredEntries;
    private final NFAStateTransition anchoredReverseEntry;
    private final NFAStateTransition unAnchoredReverseEntry;
    private final Deque<NFAState> expansionQueue = new ArrayDeque<NFAState>();
    private final Map<StateSet<RegexAST, ? extends RegexASTNode>, NFAState> nfaStates = new HashMap<StateSet<RegexAST, ? extends RegexASTNode>, NFAState>();
    private final List<NFAState> hardPrefixStates = new ArrayList<NFAState>();
    private final ASTStepVisitor astStepVisitor;
    private final ASTTransitionCanonicalizer astTransitionCanonicalizer;
    private final CompilationFinalBitSet transitionGBUpdateIndices;
    private final CompilationFinalBitSet transitionGBClearIndices;
    private final ArrayList<NFAStateTransition> transitionsBuffer = new ArrayList();
    private final CompilationBuffer compilationBuffer;

    private NFAGenerator(RegexAST ast, CompilationBuffer compilationBuffer) {
        int i;
        this.ast = ast;
        this.astStepVisitor = new ASTStepVisitor(ast);
        this.transitionGBUpdateIndices = new CompilationFinalBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.transitionGBClearIndices = new CompilationFinalBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.astTransitionCanonicalizer = new ASTTransitionCanonicalizer(ast, true, false);
        this.compilationBuffer = compilationBuffer;
        this.dummyInitialState = new NFAState((short)this.stateID.inc(), StateSet.create(ast, ast.getWrappedRoot()), CodePointSet.getEmpty(), Collections.emptySet(), false);
        this.nfaStates.put(this.dummyInitialState.getStateSet(), this.dummyInitialState);
        this.anchoredFinalState = this.createFinalState(StateSet.create(ast, ast.getReachableDollars()));
        this.anchoredFinalState.setAnchoredFinalState();
        this.finalState = this.createFinalState(StateSet.create(ast, ast.getRoot().getSubTreeParent().getMatchFound()));
        this.finalState.setUnAnchoredFinalState();
        assert (this.transitionGBUpdateIndices.isEmpty() && this.transitionGBClearIndices.isEmpty());
        this.anchoredReverseEntry = this.createTransition(this.anchoredFinalState, this.dummyInitialState);
        this.unAnchoredReverseEntry = this.createTransition(this.finalState, this.dummyInitialState);
        int nEntries = ast.getWrappedPrefixLength() + 1;
        this.initialStates = new NFAState[nEntries];
        this.unAnchoredEntries = new NFAStateTransition[nEntries];
        for (i = 0; i <= ast.getWrappedPrefixLength(); ++i) {
            NFAState initialState = this.createFinalState(StateSet.create(ast, ast.getNFAUnAnchoredInitialState(i)));
            initialState.setUnAnchoredInitialState(true);
            this.initialStates[i] = initialState;
            this.unAnchoredEntries[i] = this.createTransition(this.dummyInitialState, initialState);
        }
        if (ast.getReachableCarets().isEmpty()) {
            this.anchoredInitialStates = this.initialStates;
            this.anchoredEntries = this.unAnchoredEntries;
        } else {
            this.anchoredInitialStates = new NFAState[nEntries];
            this.anchoredEntries = new NFAStateTransition[nEntries];
            for (i = 0; i <= ast.getWrappedPrefixLength(); ++i) {
                NFAState anchoredInitialState = this.createFinalState(StateSet.create(ast, ast.getNFAAnchoredInitialState(i)));
                anchoredInitialState.setAnchoredInitialState();
                this.anchoredInitialStates[i] = anchoredInitialState;
                this.anchoredEntries[i] = this.createTransition(this.dummyInitialState, anchoredInitialState);
            }
        }
        NFAStateTransition[] dummyInitNext = Arrays.copyOf(this.anchoredEntries, nEntries * 2);
        System.arraycopy(this.unAnchoredEntries, 0, dummyInitNext, nEntries, nEntries);
        AbstractTransition[] dummyInitPrev = new NFAStateTransition[]{this.anchoredReverseEntry, this.unAnchoredReverseEntry};
        this.dummyInitialState.setSuccessors(dummyInitNext, false);
        this.dummyInitialState.setPredecessors(dummyInitPrev);
    }

    public static NFA createNFA(RegexAST ast, CompilationBuffer compilationBuffer) {
        return new NFAGenerator(ast, compilationBuffer).doCreateNFA();
    }

    /*
     * WARNING - void declaration
     */
    private NFA doCreateNFA() {
        void var2_6;
        Collections.addAll(this.expansionQueue, this.initialStates);
        if (!this.ast.getReachableCarets().isEmpty()) {
            Collections.addAll(this.expansionQueue, this.anchoredInitialStates);
        }
        while (!this.expansionQueue.isEmpty()) {
            this.expandNFAState(this.expansionQueue.pop());
        }
        for (NFAState nFAState : this.nfaStates.values()) {
            if (nFAState == this.dummyInitialState || !this.ast.getHardPrefixNodes().isDisjoint(nFAState.getStateSet())) continue;
            nFAState.linkPredecessors();
        }
        ArrayList<NFAState> deadStates = new ArrayList<NFAState>();
        this.findDeadStates(deadStates);
        while (!deadStates.isEmpty()) {
            for (NFAState state : deadStates) {
                for (NFAStateTransition pre : (NFAStateTransition[])state.getPredecessors()) {
                    pre.getSource().removeSuccessor(state);
                }
                for (NFAState prefixState : this.hardPrefixStates) {
                    prefixState.removeSuccessor(state);
                }
                this.nfaStates.remove(state.getStateSet());
            }
            deadStates.clear();
            this.findDeadStates(deadStates);
        }
        assert (this.transitionGBUpdateIndices.isEmpty() && this.transitionGBClearIndices.isEmpty());
        boolean bl = true;
        while (var2_6 < this.initialStates.length) {
            if (this.nfaStates.containsKey(this.initialStates[var2_6].getStateSet())) {
                this.initialStates[var2_6].addLoopBackNext(this.createTransition(this.initialStates[var2_6], this.initialStates[var2_6 - true]));
            }
            ++var2_6;
        }
        return new NFA(this.ast, this.dummyInitialState, this.anchoredEntries, this.unAnchoredEntries, this.anchoredReverseEntry, this.unAnchoredReverseEntry, this.nfaStates.values(), this.stateID, this.transitionID, null);
    }

    private void findDeadStates(ArrayList<NFAState> deadStates) {
        for (NFAState state : this.nfaStates.values()) {
            if (!state.isDead(true)) continue;
            deadStates.add(state);
        }
    }

    private void expandNFAState(NFAState curState) {
        boolean isHardPrefixState;
        ASTStep nextStep = this.astStepVisitor.step(curState);
        boolean bl = isHardPrefixState = !this.ast.getHardPrefixNodes().isDisjoint(curState.getStateSet());
        if (isHardPrefixState) {
            this.hardPrefixStates.add(curState);
        }
        curState.setSuccessors(this.createNFATransitions(curState, nextStep), !isHardPrefixState);
    }

    private NFAStateTransition[] createNFATransitions(NFAState sourceState, ASTStep nextStep) {
        this.transitionsBuffer.clear();
        for (ASTSuccessor successor : nextStep.getSuccessors()) {
            for (TransitionBuilder<RegexAST, Term, ASTTransition> mergeBuilder : successor.getMergedStates(this.astTransitionCanonicalizer, this.compilationBuffer)) {
                StateSet<RegexAST, CharacterClass> stateSetCC = null;
                StateSet finishedLookBehinds = null;
                boolean containsPositionAssertion = false;
                boolean containsMatchFound = false;
                boolean containsPrefixStates = false;
                for (ASTTransition astTransition : (ASTTransition[])mergeBuilder.getTransitionSet().getTransitions()) {
                    Term target = astTransition.getTarget();
                    if (target instanceof CharacterClass) {
                        if (stateSetCC == null) {
                            stateSetCC = StateSet.create(this.ast);
                            finishedLookBehinds = StateSet.create(this.ast);
                        }
                        stateSetCC.add((CharacterClass)target);
                        if (target.isInLookBehindAssertion() && target == ((Sequence)target.getParent()).getLastTerm()) {
                            finishedLookBehinds.add((LookBehindAssertion)target.getSubTreeParent());
                        }
                    } else if (target instanceof PositionAssertion) {
                        containsPositionAssertion = true;
                    } else {
                        assert (target instanceof MatchFound);
                        containsMatchFound = true;
                    }
                    containsPrefixStates |= target.isPrefix();
                    astTransition.getGroupBoundaries().updateBitSets(this.transitionGBUpdateIndices, this.transitionGBClearIndices);
                }
                if (stateSetCC == null) {
                    if (containsPositionAssertion) {
                        this.transitionsBuffer.add(this.createTransition(sourceState, this.anchoredFinalState));
                    } else if (containsMatchFound) {
                        this.transitionsBuffer.add(this.createTransition(sourceState, this.finalState));
                    }
                } else if (!containsPositionAssertion) {
                    assert (mergeBuilder.getMatcherBuilder().matchesSomething());
                    this.transitionsBuffer.add(this.createTransition(sourceState, this.registerMatcherState(stateSetCC, mergeBuilder.getMatcherBuilder(), finishedLookBehinds, containsPrefixStates)));
                }
                this.transitionGBUpdateIndices.clear();
                this.transitionGBClearIndices.clear();
            }
        }
        return this.transitionsBuffer.toArray(new NFAStateTransition[this.transitionsBuffer.size()]);
    }

    private NFAState createFinalState(StateSet<RegexAST, ? extends RegexASTNode> stateSet) {
        NFAState state = new NFAState((short)this.stateID.inc(), stateSet, CodePointSet.getFull(), Collections.emptySet(), false);
        assert (!this.nfaStates.containsKey(state.getStateSet()));
        this.nfaStates.put(state.getStateSet(), state);
        return state;
    }

    private NFAStateTransition createTransition(NFAState source, NFAState target) {
        return new NFAStateTransition((short)this.transitionID.inc(), source, target, this.ast.createGroupBoundaries(this.transitionGBUpdateIndices, this.transitionGBClearIndices));
    }

    private NFAState registerMatcherState(StateSet<RegexAST, CharacterClass> stateSetCC, CodePointSet matcherBuilder, StateSet<RegexAST, LookBehindAssertion> finishedLookBehinds, boolean containsPrefixStates) {
        if (this.nfaStates.containsKey(stateSetCC)) {
            return this.nfaStates.get(stateSetCC);
        }
        NFAState state = new NFAState((short)this.stateID.inc(), stateSetCC, matcherBuilder, finishedLookBehinds, containsPrefixStates);
        this.expansionQueue.push(state);
        this.nfaStates.put(state.getStateSet(), state);
        return state;
    }
}

