/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.Reader;
import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.BaseFilter;
import org.apache.maven.shared.filtering.FilterWrapper;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenReaderFilter;
import org.apache.maven.shared.filtering.MavenReaderFilterRequest;
import org.apache.maven.shared.filtering.MavenResourcesExecution;

@Singleton
@Named
public class DefaultMavenReaderFilter
extends BaseFilter
implements MavenReaderFilter {
    @Override
    public Reader filter(Reader from, boolean filtering, MavenProject mavenProject, List<String> filters, boolean escapedBackslashesInFilePath, MavenSession mavenSession) throws MavenFilteringException {
        MavenResourcesExecution mre = new MavenResourcesExecution();
        mre.setMavenProject(mavenProject);
        mre.setFileFilters(filters);
        mre.setEscapeWindowsPaths(escapedBackslashesInFilePath);
        mre.setMavenSession(mavenSession);
        mre.setInjectProjectBuildFilters(true);
        List filterWrappers = this.getDefaultFilterWrappers(mre);
        return this.filter(from, filtering, filterWrappers);
    }

    @Override
    public Reader filter(MavenReaderFilterRequest mavenFileFilterRequest) throws MavenFilteringException {
        List filterWrappers = this.getDefaultFilterWrappers(mavenFileFilterRequest);
        return this.filter(mavenFileFilterRequest.getFrom(), mavenFileFilterRequest.isFiltering(), filterWrappers);
    }

    @Override
    public Reader filter(Reader from, boolean filtering, List<FilterWrapper> filterWrappers) {
        return DefaultMavenReaderFilter.filterWrap(from, filtering ? filterWrappers : Collections.emptyList());
    }

    private static Reader filterWrap(Reader from, Iterable<FilterWrapper> wrappers) {
        Reader reader = from;
        for (FilterWrapper wrapper : wrappers) {
            reader = wrapper.getReader(reader);
        }
        return reader;
    }
}

