/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.helper.ListGetNode;
import com.oracle.truffle.js.builtins.helper.ListSizeNode;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNodeGen;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.UnmodifiableArrayList;
import java.util.List;

public abstract class EnumerableOwnPropertyNamesNode
extends JavaScriptBaseNode {
    private final boolean keys;
    private final boolean values;
    private final JSContext context;
    @Node.Child
    private JSGetOwnPropertyNode getOwnPropertyNode;
    private final ConditionProfile hasFastShapesProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile growProfile = BranchProfile.create();

    protected EnumerableOwnPropertyNamesNode(JSContext context, boolean keys, boolean values) {
        this.context = context;
        this.keys = keys;
        this.values = values;
    }

    public static EnumerableOwnPropertyNamesNode createKeys(JSContext context) {
        return EnumerableOwnPropertyNamesNodeGen.create(context, true, false);
    }

    public static EnumerableOwnPropertyNamesNode createValues(JSContext context) {
        return EnumerableOwnPropertyNamesNodeGen.create(context, false, true);
    }

    public static EnumerableOwnPropertyNamesNode createKeysValues(JSContext context) {
        return EnumerableOwnPropertyNamesNodeGen.create(context, true, true);
    }

    public abstract UnmodifiableArrayList<? extends Object> execute(DynamicObject var1);

    @Specialization
    protected UnmodifiableArrayList<? extends Object> enumerableOwnPropertyNames(DynamicObject thisObj, @Cached JSClassProfile jsclassProfile, @Cached ListSizeNode listSize, @Cached ListGetNode listGet) {
        JSClass jsclass = jsclassProfile.getJSClass(thisObj);
        if (this.hasFastShapesProfile.profile(this.keys && !this.values && jsclass.hasOnlyShapeProperties(thisObj))) {
            return JSShape.getEnumerablePropertyNames(thisObj.getShape());
        }
        boolean isProxy = JSProxy.isProxy(thisObj);
        List<Object> ownKeys = jsclass.ownPropertyKeys(thisObj);
        int ownKeysSize = listSize.execute(ownKeys);
        SimpleArrayList<Object> properties = new SimpleArrayList<Object>();
        for (int i = 0; i < ownKeysSize; ++i) {
            Object element;
            PropertyDescriptor desc;
            Object key = listGet.execute(ownKeys, i);
            if (!(key instanceof String) || (desc = this.getOwnProperty(thisObj, key)) == null || !desc.getEnumerable()) continue;
            if (this.keys && !this.values) {
                element = key;
            } else {
                Object value;
                Object object = value = desc.isAccessorDescriptor() || isProxy ? jsclass.get(thisObj, key) : desc.getValue();
                if (!this.keys && this.values) {
                    element = value;
                } else {
                    assert (this.keys && this.values);
                    element = JSArray.createConstant(this.context, new Object[]{key, value});
                }
            }
            properties.add(element, this.growProfile);
        }
        return new UnmodifiableArrayList<Object>(properties.toArray());
    }

    protected PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        if (this.getOwnPropertyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getOwnPropertyNode = (JSGetOwnPropertyNode)this.insert(JSGetOwnPropertyNode.create(this.values, true, false, false, false));
        }
        return this.getOwnPropertyNode.execute(thisObj, key);
    }
}

