/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.polyglot.FunctionProxyNode;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostWrapper;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

final class FunctionProxyHandler
implements InvocationHandler,
HostWrapper {
    final Object functionObj;
    final PolyglotLanguageContext languageContext;
    private final Method functionMethod;
    private final CallTarget target;

    FunctionProxyHandler(Object obj, Method functionMethod, PolyglotLanguageContext languageContext) {
        this.functionObj = obj;
        this.languageContext = languageContext;
        this.functionMethod = functionMethod;
        this.target = FunctionProxyNode.lookup(languageContext, obj.getClass(), functionMethod);
    }

    @Override
    public Object getGuestObject() {
        return this.functionObj;
    }

    @Override
    public PolyglotContextImpl getContext() {
        return this.languageContext.context;
    }

    @Override
    public PolyglotLanguageContext getLanguageContext() {
        return this.languageContext;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Object[] resolvedArguments;
        CompilerAsserts.neverPartOfCompilation();
        Object[] objectArray = resolvedArguments = arguments == null ? HostInteropReflect.EMPTY : arguments;
        if (method.equals(this.functionMethod)) {
            return this.target.call(this.languageContext, this.functionObj, this.spreadVarArgsArray(resolvedArguments));
        }
        return FunctionProxyHandler.invokeDefault(this, proxy, method, resolvedArguments);
    }

    private Object[] spreadVarArgsArray(Object[] arguments) {
        if (!this.functionMethod.isVarArgs()) {
            return arguments;
        }
        if (arguments.length == 1) {
            return (Object[])arguments[0];
        }
        int allButOne = arguments.length - 1;
        Object[] last = (Object[])arguments[allButOne];
        Object[] merge = new Object[allButOne + last.length];
        System.arraycopy(arguments, 0, merge, 0, allButOne);
        System.arraycopy(last, 0, merge, allButOne, last.length);
        return merge;
    }

    static Object invokeDefault(HostWrapper host, Object proxy, Method method, Object[] arguments) throws Throwable {
        MethodHandle mh;
        if (method.getDeclaringClass() == Object.class) {
            switch (method.getName()) {
                case "equals": {
                    return HostWrapper.equalsProxy(host, arguments[0]);
                }
                case "hashCode": {
                    return HostWrapper.hashCode(host);
                }
                case "toString": {
                    return HostWrapper.toString(host);
                }
            }
            throw new UnsupportedOperationException(method.getName());
        }
        if (TruffleOptions.AOT) {
            throw new UnsupportedOperationException("calling default method " + method.getName() + " is not yet supported on SubstrateVM");
        }
        Class<?> declaringClass = method.getDeclaringClass();
        assert (declaringClass.isInterface()) : declaringClass;
        try {
            mh = MethodHandles.lookup().findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(method.getName(), e);
        }
        return mh.bindTo(proxy).invokeWithArguments(arguments);
    }
}

