/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.lang.reflect.Proxy;
import java.util.Objects;

interface HostWrapper {
    public Object getGuestObject();

    public PolyglotContextImpl getContext();

    public PolyglotLanguageContext getLanguageContext();

    public static boolean isInstance(Object v) {
        if (v == null) {
            return false;
        }
        if (v instanceof Proxy) {
            return HostWrapper.isHostProxy(v);
        }
        return v instanceof HostWrapper;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isHostProxy(Object v) {
        if (Proxy.isProxyClass(v.getClass())) {
            return Proxy.getInvocationHandler(v) instanceof HostWrapper;
        }
        return false;
    }

    public static HostWrapper asInstance(Object v) {
        if (v instanceof Proxy) {
            return HostWrapper.getHostProxy(v);
        }
        return (HostWrapper)v;
    }

    @CompilerDirectives.TruffleBoundary
    public static HostWrapper getHostProxy(Object v) {
        return (HostWrapper)((Object)Proxy.getInvocationHandler(v));
    }

    public static boolean equals(HostWrapper wrapper, Object other) {
        if (other == null) {
            return false;
        }
        if (wrapper == other) {
            return true;
        }
        if (wrapper.getClass() == other.getClass()) {
            PolyglotContextImpl thisContext = wrapper.getContext();
            Object thisGuestObject = wrapper.getGuestObject();
            PolyglotContextImpl otherContext = ((HostWrapper)other).getContext();
            Object otherGuestObject = ((HostWrapper)other).getGuestObject();
            return thisContext == otherContext && Objects.equals(thisGuestObject, otherGuestObject);
        }
        return false;
    }

    public static boolean equalsProxy(HostWrapper wrapper, Object other) {
        if (other == null) {
            return false;
        }
        if (Proxy.isProxyClass(other.getClass())) {
            return HostWrapper.equals(wrapper, Proxy.getInvocationHandler(other));
        }
        return false;
    }

    public static int hashCode(HostWrapper thisObj) {
        return thisObj.getGuestObject().hashCode();
    }

    public static String toString(HostWrapper thisObj) {
        PolyglotLanguageContext thisContext = thisObj.getLanguageContext();
        Object thisGuestObject = thisObj.getGuestObject();
        if (thisContext != null) {
            try {
                return thisContext.asValue(thisGuestObject).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "Error in toString()";
    }
}

