/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.charset;

import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.UnicodeGeneralCategories;
import com.oracle.truffle.regex.charset.UnicodePropertyData;

public class UnicodeProperties {
    public static CodePointSet getProperty(String propertySpec) {
        return UnicodeProperties.evaluatePropertySpec(UnicodeProperties.normalizePropertySpec(propertySpec));
    }

    private static CodePointSet evaluatePropertySpec(String propertySpec) {
        CodePointSet generalCategory = UnicodeGeneralCategories.getGeneralCategory(propertySpec);
        if (generalCategory != null) {
            return generalCategory;
        }
        return UnicodePropertyData.retrieveProperty(propertySpec);
    }

    private static String normalizePropertySpec(String propertySpec) {
        int equals = propertySpec.indexOf(61);
        if (equals >= 0) {
            String propertyName = UnicodeProperties.normalizePropertyName(propertySpec.substring(0, equals));
            String propertyValue = propertySpec.substring(equals + 1);
            switch (propertyName) {
                case "gc": {
                    propertyValue = UnicodeProperties.normalizeGeneralCategoryName(propertyValue);
                    break;
                }
                case "sc": 
                case "scx": {
                    propertyValue = UnicodeProperties.normalizeScriptName(propertyValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Binary property %s cannot appear to the left of '=' in a Unicode property escape", propertySpec.substring(0, equals)));
                }
            }
            return propertyName + "=" + propertyValue;
        }
        if (UnicodeProperties.isGeneralCategoryName(propertySpec)) {
            return "gc=" + UnicodeProperties.normalizeGeneralCategoryName(propertySpec);
        }
        return UnicodeProperties.normalizePropertyName(propertySpec);
    }

    private static boolean isGeneralCategoryName(String generalCategoryName) {
        return UnicodePropertyData.GENERAL_CATEGORY_ALIASES.containsKey((Object)generalCategoryName);
    }

    private static String normalizePropertyName(String propertyName) {
        if (!UnicodePropertyData.PROPERTY_ALIASES.containsKey((Object)propertyName)) {
            throw new IllegalArgumentException(String.format("Unsupported Unicode character property '%s'", propertyName));
        }
        return (String)UnicodePropertyData.PROPERTY_ALIASES.get((Object)propertyName);
    }

    private static String normalizeGeneralCategoryName(String generalCategoryName) {
        if (!UnicodePropertyData.GENERAL_CATEGORY_ALIASES.containsKey((Object)generalCategoryName)) {
            throw new IllegalArgumentException(String.format("Unknown Unicode character general category '%s'", generalCategoryName));
        }
        return (String)UnicodePropertyData.GENERAL_CATEGORY_ALIASES.get((Object)generalCategoryName);
    }

    private static String normalizeScriptName(String scriptName) {
        if (!UnicodePropertyData.SCRIPT_ALIASES.containsKey((Object)scriptName)) {
            throw new IllegalArgumentException(String.format("Unkown Unicode script name '%s'", scriptName));
        }
        return (String)UnicodePropertyData.SCRIPT_ALIASES.get((Object)scriptName);
    }
}

