#!/bin/bash

# *****************************************************
# PROGRAM:	bashobash.sh
# PURPOSE:	haiku (俳句) poetry generator
# AUTHOR:		vovchik (bash and wxbasic)
# ORIGINAL:	Kent Peterson (FORTH), Peter van Eerten
# 			(BaCon)
# DEPENDS:	bash
# PLATFORM:	Puppy Linux (actually, any *nix and OSX)
# DATE:		13-02-2011
# NOTES:		Generated in the style of Matsuo Basho,
#			a Japanese poet of the 17th century.
#			(松尾 芭蕉)
# *****************************************************


# *********************
# INIT VARS
# *********************

# create newline var
nl=$'\012'
# create adjectives array
declare -a adje=("autumn" "hidden" "bitter" "misty" "silent" "empty" "dry" "dark" "summer" "icy" \
			"delicate" "quiet" "white" "cool" "spring" "winter" "patient" "twilight" "dawn" "crimson" \
			"wispy" "weathered" "blue" "billowing" "broken" "cold" "damp" "falling" "frosty" "green" \
			"long" "late" "lingering" "bold" "little" "morning" "muddy" "old" "red" "rough" \
			"still" "small" "sparkling" "throbbing" "shy" "wandering" "withered" "wild" "black" "young" \
			"holy" "solitary" "fragrant" "aged" "snowy" "proud" "floral" "restless" "divine" "polished" \
			"ancient" "purple" "lively" "nameless")
# create nouns array
declare -a noun=("waterfall" "river" "breeze" "moon" "rain" "wind" "sea" "morning" "snow" "lake" \
			"sunset" "pine" "shadow" "leaf" "dawn" "glitter" "forest" "hill" "cloud" "meadow" \
			"sun" "glade" "bird" "brook" "butterfly" "bush" "dew" "dust" "field" "fire" \
			"flower" "firefly" "feather" "grass" "haze" "mountain" "night" "pond" "darkness" "snowflake" \
			"silence" "sound" "sky" "shape" "surf" "thunder" "violet" "water" "wildflower" "wave" \
			"water" "resonance" "sun" "wood" "dream" "cherry" "tree" "fog" "frost" "voice" \
			"paper" "frog" "smoke" "star")
# create verbs array
declare -a verb=("shakes" "drifts" "has stopped" "struggles" "hears" "has passed" "sleeps" "creeps" "flutters" "fades" \
			"is falling" "trickles" "murmurs" "warms" "hides" "jumps" "is dreaming" "sleeps" "falls" "wanders" \
			"waits" "has risen" "stands" "dying" "is drawing" "singing" "rises" "paints" "capturing" "flying" \
			"lies" "picked up" "gathers in" "invites" "separates" "eats" "plants" "digs into" "has fallen" "weeping" \
			"facing" "mourns" "tastes" "breaking" "shaking" "walks" "builds" "reveals" "piercing" "craves" \
			"departing" "opens" "falling" "confronts" "keeps" "breaking" "is floating" "settles" "reaches" "illuminates" \
			"closes" "leaves" "explodes" "drawing")
# create prepositions array
declare -a prep=("on" "beside" "in" "beneath" "of" "above" "under" "by" "over" "against" "near")
# determine number of elements in each array
adje_cnt=${#adje[@]}
noun_cnt=${#noun[@]}
verb_cnt=${#verb[@]}
prep_cnt=${#prep[@]}
# generate random number (from 1 to 4) for style selection
mystyle=$((RANDOM%4+1))
# xcow vars
image="./zencat4.png"
haiku="Isn't this 俳句"
basho=" by 松尾 芭蕉?"
meaning="すべての意味は翻訳で失われる"
# initialize some vars, just for the hell of it
myline1=""
myline2=""
myline3=""
rnd=0

# *********************
# END INIT VARS
# *********************


# *********************
# FUNCTIONS
# *********************

# -------------
function dice()
# -------------  
{
	# yields a number from 0 to ($1 - 1), where
	# $1 is the total number of elements in the array.
	# The random result is contained in the rnd variable
	rnd=$[ ($RANDOM % $1) ]
}

# *********************
# END FUNCTIONS
# *********************


# *********************
# MAIN
# *********************

case $mystyle in
# assemble haiku in one of four styles
	1)	
		# --------------
		# myline1
		# --------------
		dice $adje_cnt; myline1a=${adje[$rnd]}
		dice $noun_cnt; myline1b=${noun[$rnd]}
		myline1="$myline1a $myline1b"
		# --------------
		# myline2
		# --------------
		dice $noun_cnt; myline2a=${noun[$rnd]}
		dice $verb_cnt; myline2b=${verb[$rnd]}
		dice $prep_cnt; myline2c=${prep[$rnd]}
		dice $noun_cnt; myline2d=${noun[$rnd]}
		myline2="$myline2a $myline2b $myline2c $myline2d"
		# --------------
		# myline3
		# --------------
		dice $adje_cnt; myline3a=${adje[$rnd]}
		dice $adje_cnt; myline3b=${adje[$rnd]}
		dice $noun_cnt; myline3c=${noun[$rnd]}
		myline3="$myline3a $myline3b $myline3c"
	;;
	2)
		# --------------
		# myline1
		# --------------
		dice $adje_cnt; myline1a=${adje[$rnd]}
		dice $noun_cnt; myline1b=${noun[$rnd]}
		dice $verb_cnt; myline1c=${verb[$rnd]}
		myline1="$myline1a $myline1b $myline1c"
		# --------------
		# myline2
		# --------------
		dice $adje_cnt; myline2a=${adje[$rnd]}
		dice $adje_cnt; myline2b=${adje[$rnd]}
		dice $noun_cnt; myline2c=${noun[$rnd]}
		myline2="$myline2a $myline2b $myline2c"
		# --------------
		# myline3
		# --------------
		dice $verb_cnt; myline3a=${verb[$rnd]}
		dice $adje_cnt; myline3b=${adje[$rnd]}
		dice $noun_cnt; myline3c=${noun[$rnd]}
		myline3="$myline3a $myline3b $myline3c"
	;;
	3)
		# --------------
		# myline1
		# --------------	
		dice $adje_cnt; myline1a=${adje[$rnd]}
		dice $adje_cnt; myline1b=${adje[$rnd]}
		dice $noun_cnt; myline1c=${noun[$rnd]}
		myline1="$myline1a $myline1b $myline1c"
		# --------------
		# myline2
		# --------------
		dice $prep_cnt; myline2a=${prep[$rnd]}
		dice $adje_cnt; myline2b=${adje[$rnd]}
		dice $noun_cnt; myline2c=${noun[$rnd]}
		myline2="$myline2a $myline2b $myline2c"
		# --------------
		# myline3
		# --------------
		dice $noun_cnt; myline3a=${noun[$rnd]}
		dice $verb_cnt; myline3b=${verb[$rnd]}
		myline3="$myline3a $myline3b"
	;;
	4)		
		# --------------
		# myline1
		# --------------	
		dice $noun_cnt; myline1a=${noun[$rnd]}
		dice $prep_cnt; myline1b=${prep[$rnd]}
		dice $noun_cnt; myline1c=${noun[$rnd]}
		myline1="$myline1a $myline1b $myline1c"	
		# --------------
		# myline2
		# --------------
		dice $adje_cnt; myline2a=${adje[$rnd]}
		dice $noun_cnt; myline2b=${noun[$rnd]}
		dice $prep_cnt; myline2c=${prep[$rnd]}
		myline2="$myline2a $myline2b $myline2c"	
		# --------------
		# myline3
		# --------------
		dice $adje_cnt; myline3a=${adje[$rnd]}
		dice $noun_cnt; myline3b=${noun[$rnd]}
		myline3="$myline3a $myline3b"	
	;;
esac
# display haiku
poem="$myline1$nl$myline2$nl$myline3"
if [ `which xcowsay` ]; then
	# if xcowsay exists, use it
	msg="<b><big><span color=\"black\">$poem</span></big></b>$nl$nl$meaning"
	xcowsay --bubble-at=-70,-110 --think --image="$image" -t 5 "$msg"
	echo "xcowsay will be used to display haiku"
elif [ `which gxmessage` ]; then
	# if not, then if gxmessage exists use it
	gxmessage -center -title -timeout 5 "bashobash" "$nl$poem"
	echo "no xcowsay, but gxmessage found and will be used to display haiku"
else
	# if neither xcowsay nor gxmessage is in the exec path, use console
	echo "$nl$poem$nl"
fi
exit 0

# *********************
# END MAIN
# *********************

