#!/bin/sh
# pinstall script for BetaFTPD
# papaschtroumpf for puppy linux 
#
# The current directory is different depending in which install mode we are:
#  - creatuppy: current directory is puppy-unleashed/rootfs-complete
#  - pupget: current directory is /
#

RUNDIR=`pwd`

# man doesn't work if you spell betaftpd BetaFTPD, fix that
#(removed, link is in package) ln -s usr/share/doc/betaftpd.htm usr/share/doc/BetaFTPD.htm

#####################################
# special handling for pupget - unleashed will have to be built in by Barry
#

if [ $RUNDIR = "/" ] ; then
  ### show the help file
  xmessage -bg "#e0ffe0" -center -name "BetaFTPD" -title "BetaFTPD help file" -file ./usr/share/doc/betaftpd.txt  

  ### register the package
  # PupGet tried to create an alienpackages entry but the description says
  # unknown, so fix it instead, otherwise create the entry
  # ??? doesn't appear to work I guess the alienpackages.txt must be written in the wrong order?
  sync 
  grep betaftpd-0.0.8pre17 /root/.packages/alienpackages.txt >/dev/null
  [ $? -eq 0 ]  &&  sed -i -e "/betaftpd-0.0.8pre17/ d" /root/.packages/alienpackages.txt
  echo '"betaftpd-0.0.8pre17" "betaftpd-0.0.8pre17: FTP Server" on "32K" \' >> /root/.packages/alienpackages.txt

  #### build the file list
  ## ??? Is this needed? PupGet seemed to have built it automatically?
  #echo '/usr/sbin/betaftpd' > /root/.packages/betaftpd-0.0.8pre17.files
  #echo '/usr/sbin/betaftpd-cc' >> /root/.packages/betaftpd-0.0.8pre17.files
  #echo '/usr/share/doc/betaftpd.txt' >> /root/.packages/betaftpd-0.0.8pre17.files

  ### put an entry in the documentation
  # documentation is built in the Control Center - not needed in index.html


  #### register ourselves in the fvwm95 menu
  ## we place ourselves immediately beofre the LinPopUp menu item
  ## The menu item will bring up the BetaFTPD Control Center
  #FVWM95RC="./root/.fvwm95rc"
  #if [ -f $FVWM95RC ] ; then
  #  # if somehow the script got ran multiple times we could keep adding
  #  # more instances: don't do that
  #  grep "/usr/sbin/betaftpd-cc" $FVWM95RC
  #  if [ $? -ne 0 ] ;then
  #    cp -f $FVWM95RC /tmp/DOTfvwm95.ftpd.backup
  #    EDITTEXT="s/^\(.\+Exec LinPopUp\)/+ \"BetaFTPD FTP server%pc-2x.xpm%\" Exec exec \/usr\/sbin\/betaftpd-cc\n\1/"
  #    sed -e "$EDITTEXT" $FVWM95RC >/tmp/betaftpdinstall.tmp
  #    mv -f /tmp/betaftpdinstall.tmp $FVWM95RC
  #  fi
  #fi

  
  #### register ourselves in the jwm menu
  ## we place ourselves immediately beofre the LinPopUp menu item
  ## The menu item will bring up the BetaFTPD Control Center
  #JWMRC="./root/.jwmrc"
  #if [ -f $JWMRC ] ; then
  #  # if somehow the script got ran multiple times we could keep adding
  #  # more instances: don't do that
  #  grep "/usr/sbin/betaftpd-cc" $JWMRC
  #  if [ $? -ne 0 ] ;then
  #    cp -f $JWMRC /tmp/DOTjwm.ftpd.backup
  #    EDITTEXT="s/^\(.\+Program label=\"LinPopUp Samba messaging.\+$\)/<Program label=\"BetaFTPD FTP server\" icon=\"pc-2x.xpm\">exec \/usr\/sbin\/betaftpd-cc<\/Program>\n\1/"
  #    sed -e "$EDITTEXT" $JWMRC >/tmp/betaftpdinstall.tmp
  #    mv -f /tmp/betaftpdinstall.tmp $JWMRC
  #  fi
  #fi



  ### register ourselves in the icewm menu
  # we place ourselves immediately beofre the LinPopUp menu item
  # The menu item will bring up the BetaFTPD Control Center
  ICEWMMENU="./root/.icewm/menu"
  if [ -f $ICEWMMENU ] ; then
    # if somehow the script got ran multiple times we could keep adding
    # more instances: don't do that
    grep "/usr/sbin/betaftpd-cc" $ICEWMMENU
    if [ $? -ne 0 ] ;then
      cp -f $ICEWMMENU /tmp/icewmmenu.ftpd.backup
      EDITTEXT="s/^\(.\+prog \"LinPopUp Samba messaging.\+$\)/\tprog \"BetaFTPD FTP Server\" pc-2x \/usr\/sbin\/betaftpd-cc\n\1/"
      sed -e "$EDITTEXT" $ICEWMMENU >/tmp/betaftpdinstall.tmp
      mv -f /tmp/betaftpdinstall.tmp $ICEWMMENU
    fi
  fi


  ### create the remove script
  # pupget should already handle removing the files in the list above
  # we need to :
  # - kill the daemon
  # - remove the ftp user
  # - remove the xferlog
  # - TODO! remove the menu entries! (works automatically in icewm)
  # - we leave /root/ftp alone though (give a message?)
  echo '#kill the server' > /root/.packages/betaftpd-0.0.8pre17.remove
  echo 'ps aux | egrep "[SR] +/usr/sbin/betaftpd"' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo '  if [ $? -eq 0 ] ; then' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo '    THEPID=`ps aux | egrep "[SR] +/usr/sbin/betaftpd" | cut -d " " -f 1`' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo '    kill -sTerm $THEPID' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo '  fi' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo '#delete the ftp user' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo 'deluser ftp 2>/dev/null' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo '#remove transfer log' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo 'rm -f /var/log/xferlog' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo '#remove menu entry: fvwm95' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo 'sed -e "/BetaFTPD/ d" /root/.fvwm95rc >/tmp/betaftpduninstall.tmp' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo 'mv -f /tmp/betaftpduninstall.tmp /root/.fvwm95rc ' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo '#remove menu entry: jwm' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo 'sed -e "/BetaFTPD/ d" /root/.jwmrc >/tmp/betaftpduninstall.tmp' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo 'mv -f /tmp/betaftpduninstall.tmp /root/.jwmrc ' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo '#remove menu entry: icewm' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo 'sed -e "/BetaFTPD/ d" /root/.icewm/menu >/tmp/betaftpduninstall.tmp' >> /root/.packages/betaftpd-0.0.8pre17.remove
  echo 'mv -f /tmp/betaftpduninstall.tmp /root/.icewm/menu ' >> /root/.packages/betaftpd-0.0.8pre17.remove


  sync 
  ### run the control center for further configuration
  /usr/sbin/betaftpd-cc

fi
#
###########################################





