# This function library is a descendant of the Wifi Access Gadget
# created by Keenerd. It went to several modifications to finally 
# be fully integrated into the ethernet/network wizard.

# History of wag-profiles
# Rarsa
# Ver 1.0 Oct 23, 2006
#  Reorganized code
#  Integrated into net-setup (the Puppy Ethernet/Network wizard)

# History of Wifi Access Gadget
# Keenerd
# ver 0.4.0
#  under development
#  new ping dialog
#  profile generator
#  new interface
#  replace xmessage dialogs
#  automatic dhcpcd handling
# ver 0.3.2
#  10+ cells
#  socket-test in main program
#  improved pupget registration
#  improved ifconfig use
#  improved ad-hoc support
#  waiting dialog
#  slightly prettier xmessage
# ver 0.3.1
#  improved 1.0.5 compatability
#  bug fixes
# ver 0.3.0
#  profiles
#  help interface
#  install to /usr
# ver 0.2.6
#  additional scan error handling
#  additional dhcpcd error handling
#  smarter buttons
#  PCMCIA optional
#  rewrote everything (bug hunt/verbose code)
#  new debug script
# ver 0.2.5
#  essid with spaces
#  external wag-conf
#  no overwrite of user files on reinstall
#  better socket testing
# ver 0.2.4
#  autodetect adapter from /proc/net/wireless
#  ping moved to seperate button
#  got rid of silly disk writes
#  added socket testing
# ver 0.2.3
#  usability improvements in documentation and installer
# ver 0.2.2
#  reports open networks
#  refresh in Scan dialog
#  dotpupped
# ver 0.2.1
#  scan bug fixed
#  partial support of Wifi-Beta
#  intelligent buttons
# ver 0.2.0
#  interactive scanning
#  public release
# ver 0.1.0
#  interactive command buttons
# ver 0.0.0
#  basic diagnostic listing


#================================================================================
showProfilesWindow()
{
	INTERFACE=$1
	refreshProfilesWindowInfo
	setupNewProfile
	EXIT=""
	while [ "${EXIT}" != "19" ] && [ "${EXIT}" != "22" ] && [ "${EXIT}" != "abort" ]
	do

		buildProfilesWindow

		I=$IFS; IFS=""
		for STATEMENTS in  $(gtkdialog --program Puppy_Network_Setup); do
			eval $STATEMENTS
		done
		IFS=$I

		case "$EXIT" in
			"abort" | "19" ) # Back or close window
				;; # Do Nothing, It will exit the while loop
			"11" ) # Scan
			  #scanForNetworks
			  showScanWindow
				;; 
			"12" ) # New profile
				setupNewProfile
				;;
			"20" ) # Save
				buildNewProfileData
				saveProfiles
				refreshProfilesWindowInfo
				setupNewProfile
				;;
			"21" ) # Delete
				NEW_PROFILE_DATA=""
				saveProfiles
				refreshProfilesWindowInfo
				setupNewProfile
				;;
			"22" ) # Use This Profile
				useProfile
				;;
			* ) # If it wasn't any other button, it must be a profile button
				PROFILE_TITLES="`echo "${PROFILE_TITLES}" | grep -v \"#NEW#\"`"
				loadProfileData "${EXIT}"
				CURRENT_PROFILE="${EXIT}"
				;;
		esac

	done

	if [ "${EXIT}" == "22" ] ; then
		return 0
	else
		return 1
	fi

} # end showProfilesWindow

#================================================================================
refreshProfilesWindowInfo()
{
#		SCANALL=`iwlist ${INTERFACE} scan`

		PROFILE_CONF=`cat /etc/WAG/profile-conf`
		PROFILE_TITLES=`echo "${PROFILE_CONF}" | grep -E 'TITLE[0-9]+=' | cut -d= -f2 | tr -d '"'`
} # end refreshProfilesWindowInfo

#================================================================================
buildProfilesWindow()
{
	DEFAULT_TITLE=""
	DEFAULT_ESSID=""
	DEFAULT_MODE=""
	DEFAULT_KEY=""
	DEFAULT_NWID=""
	DEFAULT_FREQ=""
	DEFAULT_CHANNEL=""
	DEFAULT_AP_MAC=""

	echo $PROFILE_TITLE | grep -qE "^$" ;
	[ $? -eq 1 ] && DEFAULT_TITLE="<default>${PROFILE_TITLE}</default>"
	echo $PROFILE_ESSID | grep -qE "^$" ;
	[ $? -eq 1 ] && DEFAULT_ESSID="<default>${PROFILE_ESSID}</default>"
	echo $PROFILE_MODE | grep -qE "^$" ;
	[ $? -eq 1 ] && DEFAULT_MODE="<default>${PROFILE_MODE}</default>"
	echo $PROFILE_KEY | grep -qE "^$" ;
	[ $? -eq 1 ] && DEFAULT_KEY="<default>${PROFILE_KEY}</default>"
	echo $PROFILE_NWID | grep -qE "^$" ;
	[ $? -eq 1 ] && DEFAULT_NWID="<default>${PROFILE_NWID}</default>"
	echo $PROFILE_FREQ | grep -qE "^$" ;
	[ $? -eq 1 ] && DEFAULT_FREQ="<default>${PROFILE_FREQ}</default>"
	echo $PROFILE_CHANNEL | grep -qE "^$" ;
	[ $? -eq 1 ] && DEFAULT_CHANNEL="<default>${PROFILE_CHANNEL}</default>"
	echo $PROFILE_AP_MAC | grep -qE "^$" ;
	[ $? -eq 1 ] && DEFAULT_AP_MAC="<default>${PROFILE_AP_MAC}</default>"

	buildProfilesWindowButtons


		export Puppy_Network_Setup="
			<vbox>
				<text><label>\"Create a new wireless profile or select an existing one.
if your driver supports scanning you can try scanning for available
networks. The newly created networks will be saved for future use.
\"</label></text>
				<hbox>
					<frame Select Profile>
						${PROFILE_BUTTONS}
					</frame>
					<frame Edit Wireless Profile Parameters>
						<hbox>
							<vbox>
								<text><label>Name:</label></text>
								<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
							</vbox>
							<entry><variable>PROFILE_TITLE</variable>${DEFAULT_TITLE}</entry>
						</hbox>
						<hbox>
							<vbox>
								<text><label>ESSID:</label></text>
								<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
							</vbox>
							<entry><variable>PROFILE_ESSID</variable>${DEFAULT_ESSID}</entry>
						</hbox>
						<hbox>
							<vbox>
								<text><label>Mode:</label></text>
								<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
							</vbox>
							<entry><variable>PROFILE_MODE</variable>${DEFAULT_MODE}</entry>
						</hbox>
						<hbox>
							<vbox>
								<text><label>Key:</label></text>
								<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
							</vbox>
							<entry><variable>PROFILE_KEY</variable>${DEFAULT_KEY}</entry>
						</hbox>
						<hbox>
							<vbox>
								<text><label>Network Id:</label></text>
								<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
							</vbox>
							<entry><variable>PROFILE_NWID</variable>${DEFAULT_NWID}</entry>
						</hbox>
						<hbox>
							<vbox>
								<text><label>Frequency:</label></text>
								<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
							</vbox>
							<entry><variable>PROFILE_FREQ</variable>${DEFAULT_FREQ}</entry>
						</hbox>
						<hbox>
							<vbox>
								<text><label>Channel:</label></text>
								<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
							</vbox>
							<entry><variable>PROFILE_CHANNEL</variable>${DEFAULT_CHANNEL}</entry>
						</hbox>
						<hbox>
							<vbox>
								<text><label>\"Access point
MAC:\"</label></text>
								<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
							</vbox>
							<entry><variable>PROFILE_AP_MAC</variable>${DEFAULT_AP_MAC}</entry>
						</hbox>
						<hbox>
							<vbox>
								<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
								<button><label>Save</label><action>Exit=20</action></button>
							</vbox>
							<vbox>
								<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
								<button><label>Delete</label><action>Exit=21</action></button>
							</vbox>
							<vbox>
								<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
								<button><label>Use This Profile</label><action>Exit=22</action></button>
							</vbox>
						</hbox>
					</frame>
				</hbox>
				<hbox>
					<vbox>
						<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
						<button><label>Scan</label><action>Exit=11</action></button>
					</vbox>
					<vbox>
						<pixmap><input file>/usr/share/pixmaps/net-setup_btnsize.png</input></pixmap>
						<button><label>Back</label><action>Exit=19</action></button>
					</vbox>
				</hbox>
			</vbox>
			"
}

#================================================================================
buildProfilesWindowButtons()
{
	PROFILE_BUTTONS="<button><label>New Profile</label><action>Exit=12</action></button>"

	for PROFILE in ${PROFILE_TITLES}
	do
    if [ "${PROFILE}" != "#NEW#" ] ; then
			PROFILE_BUTTONS="${PROFILE_BUTTONS}<button><label>${PROFILE}</label></button>"
		fi
  done
} # end buildProfileWindowButtons

#================================================================================
setupNewProfile ()
{
	PROFILE_TITLE=""
	PROFILE_ESSID=""
	PROFILE_MODE=""
	PROFILE_KEY=""
	PROFILE_NWID=""
	PROFILE_FREQ=""
	PROFILE_CHANNEL=""
	PROFILE_AP_MAC=""

	PROFILE_TITLES="`echo "${PROFILE_TITLES}" | grep -v \"#NEW#\"`"
	PROFILE_TITLES="${PROFILE_TITLES}
#NEW#"
	CURRENT_PROFILE="#NEW#"

} # end clearProfileFields

#================================================================================
loadProfileData()
{
	PROFILE_TITLE=$1
	PROFILE_DATA=`echo "${PROFILE_CONF}" | grep -A 9 -E "TITLE[0-9]+=\"${PROFILE_TITLE}\""`
	PROFILE_IP=`echo "${PROFILE_DATA}" | grep 'IP=' | cut -d= -f2 | tr -d '"'`
	PROFILE_GATEWAY=`echo "${PROFILE_DATA}" | grep 'GATEWAY=' | cut -d= -f2 | tr -d '"'`
	PROFILE_ESSID=`echo "${PROFILE_DATA}" | grep 'ESSID=' | cut -d= -f2 | tr -d '"'`
	PROFILE_NWID=`echo "${PROFILE_DATA}" | grep 'NWID=' | cut -d= -f2 | tr -d '"'`
	PROFILE_KEY=`echo "${PROFILE_DATA}" | grep 'KEY=' | cut -d= -f2 | tr -d '"'`
	PROFILE_MODE=`echo "${PROFILE_DATA}" | grep 'MODE=' | cut -d= -f2 | tr -d '"'`
	PROFILE_FREQ=`echo "${PROFILE_DATA}" | grep 'FREQ=' | cut -d= -f2 | tr -d '"'`
	PROFILE_CHANNEL=`echo "${PROFILE_DATA}" | grep 'CHANNEL=' | cut -d= -f2 | tr -d '"'`
	PROFILE_AP_MAC=`echo "${PROFILE_DATA}" | grep 'AP_MAC=' | cut -d= -f2 | tr -d '"'`

#	PROFILE_DETECTED=`echo "$SCANALL" | grep "ESSID:\"${PROFILE_ESSID}\""`

} # end loadProfileData

#================================================================================
buildNewProfileData ()
{
	NEW_PROFILE_DATA="TITLE1=\"${PROFILE_TITLE}\"
        IP=\"\"
        GATEWAY=\"\"
        ESSID=\"${PROFILE_ESSID}\"
        NWID=\"${PROFILE_NWID}\"
        KEY=\"${PROFILE_KEY}\"
        MODE=\"${PROFILE_MODE}\"
        FREQ=\"${PROFILE_FREQ}\"
        CHANNEL=\"${PROFILE_CHANNEL}\"
        AP_MAC=\"${PROFILE_AP_MAC}\"
        "
}

#================================================================================
saveProfiles ()
{
	NEW_PROFILE_CONF="
# This is the config file for WAG's profile management.
# It allows you to store the connection information for access points.
# For now you must set it up by hand.
# Two connections are supplied by default.
# The first is called 'autoconnect'.  It clears all settings
# and forces your card to connect to the best station it can find.
# The second is a template.  Copy it when making a new entry.

# WAG uses a combination of context search and line counting to
# find the required information.  Don't misspell a line or delete
# an unneeded line.  This will break the profile.  Settings not
# required should be set to ""
# TITLE must be sequentially numbered.
	"
	TITLE_NUM=0
	for PROFILE in ${PROFILE_TITLES}
	do
    if [ "${PROFILE}" != "${CURRENT_PROFILE}" ] ; then
			loadProfileData ${PROFILE}
    else
			PROFILE_DATA="${NEW_PROFILE_DATA}"
    fi

    if [ ! -z "${PROFILE_DATA}" ] ; then
			TITLE_NUM=`expr ${TITLE_NUM} + 1`

			PROFILE_TITLE=`echo "${PROFILE_DATA}" | grep -E "TITLE[0-9]+=" | cut -d= -f2 | tr -d '"'`
			SAVE_PROFILE_DATA=`echo "${PROFILE_DATA}" | grep -v -E "TITLE[0-9]+=\"${PROFILE_TITLE}\""`
			NEW_PROFILE_CONF="${NEW_PROFILE_CONF}
TITLE${TITLE_NUM}=\"${PROFILE_TITLE}\"
${SAVE_PROFILE_DATA}"
		fi
  done

	echo "${NEW_PROFILE_CONF}" > /etc/WAG/profile-conf
} # end saveProfiles

#================================================================================
useProfile ()
{
	IWCONFIG_PARAMS="${INTERFACE}"
	[ "$PROFILE_ESSID" != "" ] && IWCONFIG_PARAMS="${IWCONFIG_PARAMS} essid \"${PROFILE_ESSID}\""
	[ "$PROFILE_NWID" != "" ] && IWCONFIG_PARAMS="${IWCONFIG_PARAMS} nwid $PROFILE_NWID"
	[ "$PROFILE_FREQ" != "" ] && IWCONFIG_PARAMS="${IWCONFIG_PARAMS} freq $PROFILE_FREQ"
	[ "$PROFILE_CHANNEL" != "" ] && IWCONFIG_PARAMS="${IWCONFIG_PARAMS} channel $PROFILE_CHANNEL"
	[ "$PROFILE_MODE" != "" ] && IWCONFIG_PARAMS="${IWCONFIG_PARAMS} mode $PROFILE_MODE"
	[ "$PROFILE_AP_MAC" != "" ] && IWCONFIG_PARAMS="${IWCONFIG_PARAMS} ap $PROFILE_AP_MAC"
	[ "$PROFILE_KEY" != "" ] && IWCONFIG_PARAMS="${IWCONFIG_PARAMS} key $PROFILE_KEY"

	echo -e "
#Configure the wireless interface
echo \"Configuring wireless interface ${INTERFACE}\"
ifconfig ${INTERFACE} up
iwconfig ${IWCONFIG_PARAMS}" > /tmp/wag-profiles_iwconfig.sh
	sh /tmp/wag-profiles_iwconfig.sh

} # end loadProfile

#================================================================================
showScanWindow()
{
	buildScanWindow

	SCANWINDOW_RESPONSE="`sh /tmp/net-setup_scanwindow`"

	CELL=`echo ${SCANWINDOW_RESPONSE} | grep -Eo "[0-9]+"`

	[ ! -z ${CELL} ] &&	setupScanedProfile 

} # end of showScanWindow

#================================================================================
buildScanWindow()
{
	SCANWINDOW_BUTTONS=""
	ifconfig ${INTERFACE} up

	SCANALL=`iwlist ${INTERFACE} scan`
	SCAN_LIST=`echo "$SCANALL" | grep 'Cell\|ESSID\|Mode\|Frequency\|Quality\|Encryption'`
	if [ "$SCAN_LIST" == "" ]; then
		echo "Xdialog --left --title \"Puppy Network Wizard:\" --msgbox \"No networks detected\" 0 0 " > /tmp/net-setup_scanwindow
	else
		# give each Cell its own button
		CELL_LIST=`echo "$SCAN_LIST" | grep -Eo "Cell [0-9]+" | cut -f2 -d " "`
		for CELL in ${CELL_LIST} ; do
		  getCellParameters ${CELL}
			SCANWINDOW_BUTTONS="${SCANWINDOW_BUTTONS} \"${CELL}\" \"${CELL_ESSID}\" off \"${CELL_MODE}; Encryption:${CELL_ENCRYPTION}\""
		done
		echo "Xdialog --left --item-help --stdout --title \"Puppy Network Wizard:\" --radiolist \"Select one of the available networks
Move the mouse over to see more details.\"  0 0 4  \
${SCANWINDOW_BUTTONS} 2> /dev/null" > /tmp/net-setup_scanwindow
	fi

} #end of buildScanWindow

#================================================================================
setupScanedProfile()
{
	setupNewProfile

	getCellParameters ${CELL}
	PROFILE_ESSID="${CELL_ESSID}"
	PROFILE_TITLE="${CELL_ESSID}"
	PROFILE_FREQ="${CELL_FREQ}"
	PROFILE_CHANNEL="${CELL_CHANNEL}"
	PROFILE_AP_MAC="${CELL_AP_MAC}"

	if [ "${CELL_MODE}" = "Mode:Ad-Hoc" ]; then
		PROFILE_MODE="Ad-Hoc"
	else
		PROFILE_MODE="Managed"
	fi

	if [ "${CELL_ENCRYPTION}" == "on" ] ; then
		PROFILE_KEY="Provide a key"
	else
		PROFILE_KEY=""
	fi
} # end of setupScanedProfile

#================================================================================
getCellParameters()
{
	CELL=$1
	SCAN_CELL=`echo "$SCAN_LIST" | grep -A 5 "Cell ${CELL}"`
	CELL_ESSID=`echo "$SCAN_CELL" | grep -E -o 'ESSID:".+"' | grep -E -o '".+"' | grep -E -o '[^"]+'`
	CELL_FREQ=`echo "$SCAN_CELL" | grep "Frequency" | grep -Eo '[0-9]+\.[0-9]+ +G'`
	CELL_CHANNEL=`echo "$SCAN_CELL" | grep "Frequency" | grep -Eo 'Channel [0-9]+' | cut -f2 -d" "`
	CELL_AP_MAC=`echo "$SCAN_CELL" | grep -E -o '[0-9A-F]{2}:[0-9A-F]{2}:[0-9A-F]{2}:[0-9A-F]{2}:[0-9A-F]{2}:[0-9A-F]{2}'`
	CELL_MODE=`echo "$SCAN_CELL" | grep -o 'Mode:Master\|Mode:Ad-Hoc'`
	CELL_ENCRYPTION=`echo "${SCAN_CELL}" | grep -Eo "Encryption key:[a-zA-Z]+" | cut -d":" -f2`
} # end of getCellParameters

#================================================================================
#=============== START OF SCRIPT BODY ====================
#================================================================================

# If ran by itself it shows the interface, Otherwise it's only used as a function library
CURRENT_CONTEXT=`expr "$0" : '.*/\(.*\)$' `
if [ "${CURRENT_CONTEXT}" == "wag-profiles.sh" ] ; then
	showProfilesWindow $1
fi 

#================================================================================
#=============== END OF SCRIPT BODY ====================
#================================================================================
