#!/bin/bash
TEMP=/tmp/LIBFILES
rm -rf "$TEMP"
mkdir "$TEMP"

#  get list od all binaries / libraries
#  "/usr /root" can be replaced by "/", but then the contents of 
#+ /bin and /lib will be checked, which is pointless (and takes time).
for FILE in `find /usr /root -type f -perm +1 | xargs file | grep "stripped" |cut -d : -f1 ` ; 
do 
	echo -n "." # just so you know it's working...
# list it in a temp file for each library it depends on
	ldd "$FILE" | while read LIB
	do
		NAME="`echo "$LIB"| sed 's% =*[a-zA-Z]*.*)%%'`"
		[ "$NAME" = "/lib/ld-linux.so.2" ] && continue #  these two-		
		[ "$NAME" = "linux-gate.so.1" ] && continue    #+ always appear
		echo "$FILE" >> $TEMP/"$NAME"
	done
done

rm -f "$TEMP"/"not a dynamic executable"
rm -f "$TEMP"/"statically linked"

echo; echo 'creating files /root/dependents.txt & /root/missing.txt'
# create header for first file
echo 'This is a list of libraries and their dependents
It is arranged as follows:

--- library-name ---
dependent1
dependent2
...
#########################################################
' > /root/dependents.txt
# create header for second file
echo 'This is a list of libraries that were found to be missing.
It is arranged as follows:

--- missing-library ---
dependent1
dependent2
...
#########################################################
' > /root/missing.txt
# create header for third file
echo 'This is a list of "orphaned" libraries (nothing depends on them).
Please note that this does NOT necessarily mean they are not needed --
anything inside a program subdirectory is probably a plugin, etc.


#########################################################
' > /root/orphans.txt

echo; echo 'searching for orphaned libraries'
# search for libs with no dependents
for EACHLIB in `find /usr /root -type f -perm +1 | xargs file | grep "stripped" | grep "shared object" | cut -d : -f1`
do 
	echo -n "."
	NAME="`basename $EACHLIB | sed 's%so.[0-9].*%so%'`"
	! echo "$NAME" | grep -q "lib" && continue
	if ! ls "$TEMP" | grep -q "$NAME"; then
		echo "$EACHLIB" >> /root/orphans.txt
	fi
done

#  create the actual list, out of all the single-library files.
#  I put /usr/lib first since it's the most relevant and 
#+ has the most libraries - thus it works slightly faster.
#  the "/root /usr" at the end is just in case there's something left...
for LIBDIR in /usr/lib /usr/local/lib /usr/X11R6/lib /lib /root /usr
do
	echo; echo "listing libraries from $LIBDIR"
	ls -1 "$TEMP" | while read LIB
	do
		if echo "$LIB" | grep -q "not found" ; then
			NAME="$LIB" ; LSTFILE="/root/missing.txt"
		else
# for some reason some files are found with the "!" and others without...
			NAME=`find "$LIBDIR" ! -type f -name "$LIB"`
			if [ "$NAME" = "" ];then
				NAME=`find "$LIBDIR" -type f -name "$LIB"`
				[ "$NAME" = "" ] && continue # skip to next lib if not found
			fi
			LSTFILE="/root/dependents.txt"
		fi
		echo "
		
	--- $NAME ---" >> "$LSTFILE"
		cat $TEMP/"$LIB" | sort >> "$LSTFILE"
		rm -f $TEMP/"$LIB"
	done
done

rm -rf "$TEMP"	

exit 0
