#!/bin/sh
#Barry Kauler 2006
#updates /etc/networkmodules, for net-setup.sh (Network Wizard).
#this script is executed in Puppy Unleashed when building a Puppy iso,
#called from 'createpuppy' script.

[ ! -d ./rootfs-complete ] && exit #precaution.
[ ! -d ./modules-complete ] && exit #precaution.

KERNVER="`uname -r`"
DRIVERSDIR="modules-complete/lib/modules/$KERNVER/kernel/drivers/net"
#DRIVERSDIR will only have the local drivers, the full set are in
#the zdrv file.

echo "Updating rootfs-complet/etc/networkmodules..."

#get the full list...
OFFICIALLIST="`cat rootfs-complete/lib/modules/modules.dep.${KERNVER} | grep "^/lib/modules/$KERNVER/kernel/drivers/net/" | cut -f 1 -d ':'`"
#there are a few extra scattered around... needs to be manually updated...
EXTRALIST="/lib/modules/$KERNVER/extra/acx.ko
/lib/modules/$KERNVER/extra/rt2400.ko
/lib/modules/$KERNVER/extra/rt2500.ko
/lib/modules/$KERNVER/extra/rt2570.ko
/lib/modules/$KERNVER/extra/rt61.ko
/lib/modules/$KERNVER/extra/rt73.ko
/lib/modules/$KERNVER/net/ath_pci.ko
/lib/modules/$KERNVER/linux-wlan-ng/prism2_usb.ko
/lib/modules/$KERNVER/linux-wlan-ng/prism2_pci.ko
/lib/modules/$KERNVER/linux-wlan-ng/prism2_plx.ko
"
RAWLIST="$OFFICIALLIST
$EXTRALIST"

echo "$RAWLIST" >/tmp/rawlist.txt #test

#the list has to be cutdown to genuine network interfaces only...
#this script requires currently-running puppy to have the same kernel
#and modules as for the pupppy iso being built! (otherwise some modules
#may get left out)
echo -n "" > /tmp/networkmodules
echo "$RAWLIST" |
while read ONERAW
do
 [ "$ONERAW" = "" ] && continue #precaution
 ONEBASE="`basename $ONERAW .ko`"
 modprobe -vn $ONEBASE >/dev/null 2>&1
 ONEINFO="`modinfo $ONEBASE | tr '\t' ' ' | tr -s ' '`"
 ONETYPE="`echo "$ONEINFO" | grep '^alias:' | head -n 1 | cut -f 2 -d ' ' | cut -f 1 -d ':'`"
 ONEDESCR="`echo "$ONEINFO" | grep '^description:' | head -n 1 | cut -f 2 -d ':'`"
 if [ "$ONETYPE" = "pci" -o "$ONETYPE" = "pcmcia" -o "$ONETYPE" = "usb" ];then
  echo "Adding $ONEBASE"
  echo -e "$ONEBASE \"$ONETYPE: $ONEDESCR\"" >> /tmp/networkmodules
 fi
done

sort /tmp/networkmodules > rootfs-complete/etc/networkmodules

###end###
