#!/bin/sh
#this is for hacks needed to fix a package, that might not have been done elsewhere.
#called from /usr/local/petget/installpkg.sh
#package that has just been installed is passed in on commandline.
#120924 DejaVu font no good for non-Latin languages. 120925 add korean.
#130122 xsane: remove warning about running as root.
#130221 pemasu: google-chrome run as root. 130224 pemasu: limit cache size.
#130326 pass in $DLPKG_NAME as $2. font size fix for 96 dpi.
#130507 kompozer needs MOZILLA_FIVE_HOME fix.

INSTALLEDPKG="$1" #ex: vlc_2.0.3-0ubuntu0.12.04.1_i386, without .deb
INSTALLEDNAME="$2" #130326

case $INSTALLEDPKG in
 vlc-nox_*)
  #120907 vlc in debian/ubuntu configured to not run as root (it is a pre-compile configure option to enable running as root).
  #this hack will fix it...
  #note, this code is also in FIXUPHACK in 'vlc' template.
  if [ -f /usr/bin/bbe ];then #bbe is a sed-like utility for binary files.
   if [ -f /usr/bin/vlc  ];then
    bbe -e 's/geteuid/getppid/' /usr/bin/vlc > /tmp/vlc-temp1
    mv -f /tmp/vlc-temp1 /usr/bin/vlc
    chmod 755 /usr/bin/vlc
   fi
  fi
 ;;
 exaile_*)
  if [ -f /usr/bin/bbe ];then #bbe is a sed-like utility for binary files.
   if [ -f /usr/lib/exaile/exaile.py  ];then
    bbe -e 's/geteuid/getppid/' /usr/lib/exaile/exaile.py > /tmp/vlc-temp1
    mv -f /tmp/vlc-temp1 /usr/lib/exaile/exaile.py
    chmod 755 /usr/lib/exaile/exaile.py
   fi
  fi
 ;; 
 "0ad"*)
  if [ -f /usr/bin/bbe ];then #bbe is a sed-like utility for binary files.
   if [ -f /usr/games/pyrogenesis  ];then
    bbe -e 's/geteuid/getppid/' /usr/games/pyrogenesis > /tmp/vlc-temp1
    mv -f /tmp/vlc-temp1 /usr/games/pyrogenesis
    chmod 755 /usr/games/pyrogenesis
   fi
  fi
  ;;
 kde-runtime_*)
  if [ -f /usr/bin/kde4 ];then 
    update-mime-database /usr/share/mime
  fi
 ;;
 chromium-browser_*)
   if [ -f /usr/bin/chromium-browser ];then
   mv /usr/bin/chromium-browser /usr/bin/chromium-browser1
   echo "#!/bin/sh" > /usr/bin/chromium-browser
   echo 'exec chromium-browser1 --user-data-dir=/root/.config/chrome --allow-outdated-plugins --audio-buffer-size=2048 "$@"
' >> /usr/bin/chromium-browser
   chmod 755 /usr/bin/chromium-browser
   fi
 ;;
 google-earth-stable_*)
   if [ -f /usr/bin/google-earth ];then
   ln -s /lib/ld-2.19.so /lib/ld-lsb-x86-64.so.3
   echo '[Desktop Entry]
Version=1.0
Name=Google Earth
GenericName=3D planet viewer
Comment=Explore, search and discover the planet
Exec=/opt/google/earth/free/google-earth
Terminal=false
MultipleArgs=false
Icon=/opt/google/earth/free/product_logo_128.png
Type=Application
Categories=Network
MimeType=application/vnd.google-earth.kml+xml;application/vnd.google-earth.kmz;application/earthviewer;application/keyhole' > /usr/share/applications/google-earth.desktop
chmod 755 /initrd/pup_rw
   fi
 ;; 
 skype-*)
   if [ -f /usr/bin/skype ];then
   echo '[Desktop Entry]
Name=Skype
Comment=Skype Internet Telephony
Exec=apulse skype
Icon=skype.png
Terminal=false
Type=Application
Encoding=UTF-8
Categories=Network;Application;
MimeType=x-scheme-handler/skype;
X-KDE-Protocols=skype' > /usr/share/applications/skype.desktop
   fi
 ;;
  "iron"*)
   if [ -f /usr/share/iron/iron ];then
   mv /usr/share/iron/iron /usr/share/iron/iron1
   echo "#!/bin/sh" > /usr/share/iron/iron
   echo '/usr/share/iron/iron1 --user-data-dir=/root/.config/chrome --allow-outdated-plugins --audio-buffer-size=2048 "$@"
' >> /usr/share/iron/iron
   chmod 755 /usr/share/iron/iron
   ln -s /usr/share/iron/iron /usr/bin/iron
   fi
 ;;
  python-wxgtk2.8_*)
   if [ -f /usr/lib/python2.7/dist-packages/wx-2.8-gtk2-unicode/wxPython/_wx.py ];then
   ln -s /usr/lib/python2.7/dist-packages/wx-2.8-gtk2-unicode/wx /usr/lib/python2.7/dist-packages
   fi
 ;;
 google-chrome-*) #130221 pemasu. 130224 pemasu: limit cache size...
   if [ -f /opt/google/chrome/chrome  ];then
   mv /opt/google/chrome/google-chrome /opt/google/chrome/google-chrome1
   echo "#!/bin/sh" > /opt/google/chrome/google-chrome
   echo 'export GOOGLE-CHROME=/opt/google/chrome/google-chrome' >> /opt/google/chrome/google-chrome
   echo 'export LD_LIBRARY_PATH=/opt/google/chrome:/opt/google/chrome/lib:$LD_LIBRARY_PATH' >> /opt/google/chrome/google-chrome
   echo 'export CHROME_VERSION_EXTRA="stable"' >> /opt/google/chrome/google-chrome
   echo 'exec /opt/google/chrome/chrome --user-data-dir=/root/.config/chrome --allow-outdated-plugins --audio-buffer-size=2048 "$@"' >> /opt/google/chrome/google-chrome
   chmod 755 /opt/google/chrome/google-chrome
   echo '[Desktop Entry]
Encoding=UTF-8
Version=1.0
Name=Google Chrome web browser
GenericName=Google Chrome
Comment=Google Chrome web browser
Exec=google-chrome
Terminal=false
Type=Application
Icon=/opt/google/chrome/product_logo_128.png
Categories=WebBrowser;' > /usr/share/applications/google-chrome.desktop
ln -s /usr/bin/google-chrome-stable /usr/bin/google-chrome
/opt/google/earth/free/product_logo_128.png
   fi
 ;;
 jwm_theme_*)
  #120924 DejaVu font no good for non-Latin languages...
  #see also langpack_* pinstall.sh (template is in /usr/share/doc/langpack-template/pinstall.sh, read by momanager).
  LANGUSER="`grep '^LANG=' /etc/profile | cut -f 2 -d '=' | cut -f 1 -d ' '`"
  case $LANGUSER in
   zh*|ja*|ko*) #chinese, japanese, korean
    sed -i -e 's%DejaVu Sans%Sans%' /etc/xdg/templates/_root_*
    sed -i -e 's%DejaVu Sans%Sans%' /root/.jwm/themes/*-jwmrc
    sed -i -e 's%DejaVu Sans%Sans%' /root/.jwm/jwmrc-theme
   ;;
  esac
  #130326 font size fix for 96 dpi...
  if [ "$INSTALLEDNAME" ];then
   JWMTHEMEFILE="$(grep '^/root/\.jwm/themes/.*-jwmrc$' /root/.packages/${INSTALLEDNAME}.files | head -n 1)"
   [ "$JWMTHEMEFILE" ] && hackfontsize "JWMTHEMES='${JWMTHEMEFILE}'"
  fi
 ;;
 openbox*)
  #120924 DejaVu font no good for non-Latin languages...
  #see also langpack_* pinstall.sh (template is in /usr/share/doc/langpack-template/pinstall.sh, read by momanager).
  LANGUSER="`grep '^LANG=' /etc/profile | cut -f 2 -d '=' | cut -f 1 -d ' '`"
  case $LANGUSER in
   zh*|ja*|ko*) #chinese, japanese, korean
    sed -i -e 's%DejaVu Sans%Sans%' /etc/xdg/openbox/*.xml
    sed -i -e 's%DejaVu Sans%Sans%' /root/.config/openbox/*.xml
   ;;
  esac
 ;;
 gtk_theme_*)
  #120924 DejaVu font no good for non-Latin languages...
  #see also langpack_* pinstall.sh (template is in /usr/share/doc/langpack-template/pinstall.sh, read by momanager).
  LANGUSER="`grep '^LANG=' /etc/profile | cut -f 2 -d '=' | cut -f 1 -d ' '`"
  case $LANGUSER in
   zh*|ja*|ko*) #chinese, japanese, korean
    GTKRCFILE="$(find /usr/share/themes -type f -name gtkrc | tr '\n' ' ')"
    for ONEGTKRC in $GTKRCFILE
    do
     sed -i -e 's%DejaVu Sans%Sans%' $ONEGTKRC
    done
   ;;
  esac
  #130326 font size fix for 96 dpi...
  if [ "$INSTALLEDNAME" ];then
   GTKTHEMEFILE="$(grep '^/usr/share/themes/.*/gtk-2\.0/gtkrc$' /root/.packages/${INSTALLEDNAME}.files | head -n 1)"
   [ "$GTKTHEMEFILE" ] && hackfontsize "GTKRCS='${GTKTHEMEFILE}'"
  fi
 ;;
 seamonkey*|firefox*)
  #120924 DejaVu font no good for non-Latin languages...
  #see also langpack_* pinstall.sh (template is in /usr/share/doc/langpack-template/pinstall.sh, read by momanager).
  LANGUSER="`grep '^LANG=' /etc/profile | cut -f 2 -d '=' | cut -f 1 -d ' '`"
  case $LANGUSER in
   zh*|ja*|ko*) #chinese, japanese, korean
    MOZFILE="$(find /root/.mozilla -type f -name prefs.js -o -name '*.css' | tr '\n' ' ')"
    for ONEMOZ in $MOZFILE
    do
     sed -i -e 's%DejaVu Sans%Sans%' $ONEMOZ
    done
   ;;
  esac
 ;;
 mc_*) #121206 midnight commander
  #in ubuntu, won't run from the menu. this fixes it...
  [ -f /usr/share/applications/mc.desktop ] && sed -i -e 's%^Exec=.*%Exec=TERM=xterm mc%' /usr/share/applications/mc.desktop
 ;;
 xsane*) #130122
  #xsane puts up a warning msg at startup if running as root, remove it...
  #this code is also in file FIXUPHACK in xsane template (in Woof).
  #WARNING: this may only work for x86 binary.
  if [ -f /usr/bin/bbe ];then #bbe is a sed-like utility for binary files.
   if [ -f /usr/bin/xsane  ];then
    bbe -e 's/\x6b\x00getuid/\x6b\x00getpid/' /usr/bin/xsane > /tmp/xsane-temp1
    mv -f /tmp/xsane-temp1 /usr/bin/xsane
    chmod 755 /usr/bin/xsane
   fi
  fi
 ;;
 kompozer*) #130507
  [ -f /usr/bin/kompozer ] && [ -d /usr/lib/kompozer ] && sed -i -e 's%^moz_libdir=%export MOZILLA_FIVE_HOME="/usr/lib/kompozer" #BK\nmoz_libdir=%' /usr/bin/kompozer
 ;;
esac

