#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#define DEBUG 0

int main(int argc, char *argv[]) {
  char *pathcopy, *realpath;
  char *token, *teststr, *targstr, *suidprog;
  int argsize, strsize, pid;

  /* For testing if the file is a symlink...*/
  struct stat *statbuftest;
  struct stat *statbuftarget;
 
  if ((statbuftest = (struct stat *) malloc (sizeof(struct stat))) == NULL) {
    fprintf(stderr,"Cannot allocate stat buffer\n");
    exit(-1);
  }
  if ((statbuftarget = (struct stat *) malloc (sizeof(struct stat))) == NULL) {
    fprintf(stderr,"Cannot allocate stattarget buffer\n");
    exit(-1);
  }

  /* Tokenize a string-a-ling-a-ling */
  realpath = (char *) getenv("PATH");
  
  if ((pathcopy = (char *) malloc( (strlen(realpath)+1) * sizeof(char))) == NULL) {
    fprintf(stderr,"Cannot allocate path\n");
    exit(-1);
  }
  
  if (pathcopy == NULL) exit(-1);
  else
    strcpy(pathcopy,realpath);

  argsize = strlen(argv[0]);
  
  token = strtok(pathcopy, ":");
  
  /* Find the executable (if possible) */
  if ((teststr = (char *) malloc( strlen(argv[0]) * sizeof(char))) == NULL) {
    fprintf(stderr,"Cannot allocate test string\n");
    exit(-1);
  }
  strcpy(teststr,argv[0]);
  if (DEBUG) printf("First, checking %s\n",teststr);
  if (access(teststr,X_OK) ) { /* Not executable as it stands, check path */
    while ( token != NULL ) {
      if (DEBUG) printf("Testing %s\n",token);
      strsize = argsize + strlen(token) + 2; // for the "/" and the '\0'
      if (strlen(teststr) < strsize) {
        // We don't have enough in this buffer
        if (DEBUG) printf("Size of string is %d\n", strlen(teststr));
        free(teststr);
        if ((teststr = (char *) malloc (strsize*sizeof(char))) == 0) {
          fprintf(stderr,"Cannot allocate test string\n");
          exit(-1);
        }
      }
      strcpy(teststr,token);
      strcat(teststr,"/");
      strcat(teststr,argv[0]);
      
      if ( !access(teststr,X_OK ) ) break;
      token = strtok(NULL,":");
    }
  }
  if (DEBUG) printf("Checking the executable %s\n",teststr);
  
  /* Did we get the right string? */
  
  if (access(teststr,X_OK) ) {
    fprintf(stderr,"%s isn't an executable file\n",teststr);
    /* No, the string is not executable */
    exit(1);
  }
  
  if (DEBUG) printf("Got an executable: %s\n",teststr);
  
  /* Now test the file for sym linkage ... */
  
  if (stat(teststr,statbuftest)){
    perror("stat");
    exit(1);
  }
  
  /* Find the target file */
  if ((targstr = (char *) malloc((strlen(argv[0])+
	       strlen("/mnt/rw/setuid/")+1) * sizeof(char))) == NULL) {
    fprintf(stderr,"Cannot allocate target string\n");
    exit(-1);
  }
  
  strcat(targstr,"/mnt/rw/setuid/");
  strcat(targstr,teststr);
  stat(targstr,statbuftarget);
  
  if (statbuftarget->st_ino == statbuftest->st_ino) {
    if (pid = fork()) {
      if ((suidprog = 
        (char *) malloc((strlen("/setuid")+ strlen(teststr)+1)* sizeof(char))) == NULL) {
        fprintf(stderr,"Cannot allocate suidprog\n");
        exit(-1);
      }
      strcpy(suidprog,"/setuid");
      strcat(suidprog,teststr);
      if (DEBUG) printf("Executing %s\n",suidprog);
      execv(suidprog,argv);
      perror("execv");
    } else {
      free(statbuftest);
      free(statbuftarget);
      free(pathcopy);
      free(teststr);
      free(targstr);
      wait(pid);
      free(suidprog);
    }
  }
}
