///*   Firewall State On/Off by Rob Lane 2009-2011    */
///*   A system tray applet to display                 */
///*   the firewall status and provide a small      */
///*   additional menu for extra features.           */
///*   Released under the GPL3 licence              */
///*   based on a simple systray applet              */
///*   example by Rodrigo De Castro, 2007        */
//120909 rodin.s adding gettext

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <glib/gstdio.h>
#define THIS_VERSION "2.5"
#include <libintl.h>
#include <locale.h>
#define _(STRING)    gettext(STRING)

GtkStatusIcon *tray_icon;

void hide_close(GtkButton *w, gpointer window);
void quit(GtkWidget *w, gpointer dummy);
void showme_window(GtkWidget *w, gpointer dummy);
void shownet_window(GtkWidget *w, gpointer dummy);
void show_hide_window(void);
void timdat_window(GtkWidget *w, gpointer dummy);
//void ISip ();
void NETip();
void psync_window(GtkWidget *w, gpointer dummy);

char pupname[17];
char pupvernum[4];  
char puppyversion[30];
char space[4]="   ";
char pupname1[6]="Puppy";
char keyvers[6];
char langvers[6];
//char ipis[16];
char netis[30];
char tzis[25];

unsigned int interval = 1000; /*update interval in milliseconds  */

FILE *fp;

gboolean Firestate(gpointer ptr);
gboolean Firestate(gpointer ptr) {    /////////* ###### This is the constantly updated routine ###### *////////////


/* Firewall text check and set icon in tray  */

char SearchText[]="ip_tables\n";   
char MainText[80]; 
  
    fp =(FILE *) popen("/bin/lsmod | grep 'ip_tables' | awk '{print $1}' ","r");
          
 while (feof(fp) == 0)

		{ fgets( MainText,80,fp );
 
 if (strcmp(MainText,SearchText) == 0 ) {   /*  */

	gtk_status_icon_set_from_file(tray_icon,"/usr/share/pixmaps/puppy/shield_yes.svg" );
	gtk_status_icon_set_tooltip(tray_icon,_("Firewall On") );
  
  break;    /* Stop the match process if matched */
		}
else         	{     /*    */
     
  gtk_status_icon_set_from_file(tray_icon,"/usr/share/pixmaps/puppy/shield_no.svg" );
  gtk_status_icon_set_tooltip(tray_icon, _("Firewall Off, Left click to run wizard") );
					}	
   
		}  
pclose(fp);      
return(1);
}

//////////////////////////////////////////////////////////   Retrieve information
gboolean Info(gpointer ptr);
gboolean Info(gpointer ptr)  {
	
	
/* Check for DISTRO_SPECS file, if doesn't exist run /etc/puppyversion instead  */
if (( fp =(FILE *) fopen("/etc/DISTRO_SPECS", "r")) == NULL)

		{       
fp = (FILE *)popen("cat /etc/puppyversion  |  awk '{print $1 }'   " , "r" );

    fgets(pupvernum,sizeof pupvernum,fp);
    pclose(fp);   
      strcpy (pupname,("%s", pupname1));
      strcat (puppyversion,("%s", space));  
		}
else   			{

		{       /* Easy way to retrieve the info  */
fp = (FILE *)popen("cat /etc/DISTRO_SPECS  | grep  DISTRO_NAME | awk '{print $1 , $2}'  | cut  -d '=' -f2  " , "r" );
    fgets(pupname,sizeof pupname,fp);      
    pclose(fp);
		}

					}
		{	 
fp = (FILE *)popen("cat /etc/DISTRO_SPECS  | grep  'DISTRO_VERSION' | awk '{print $1}' | cut  -d '=' -f2 " , "r" );
  fgets(pupvernum,sizeof pupvernum,fp);
   pclose(fp);
		}

		{   /* join the seperate info together (concatenation) example only - not used except as spacer */
 strcpy (puppyversion,("%s",pupname));
 strcat (puppyversion,("%s",space));
 strcat (puppyversion,("%s",pupvernum));
		}

		{  /* Keyboard in use */
	 
fp = (FILE *)popen("cat /etc/keymap  | awk '{print $1}' " , "r" );
    fgets(keyvers,sizeof keyvers,fp);
    pclose(fp);
		}

		{  /* Language in use */
	 
fp = (FILE *)popen("locale | grep 'LANG=' | cut -d '=' -f2" , "r" );
    fgets(langvers,sizeof langvers,fp);
    pclose(fp);
		}

		{  /* Get your IP address from created tmp file ipis.txt*/

   /*fp = (FILE *)popen("cat /tmp/ipis.txt |  awk '{print $1}'  " , "r" );
    fgets(ipis,sizeof ipis,fp);
    pclose(fp);*/   
		}
  
		{ /* Get your network from created tmp file ifstuff.txt */

   fp = (FILE *)popen("cat /tmp/ifstuff.txt |  grep 'addr:'  | head -n1 | cut -d ':'  -f2  |  awk '{print $1}'  " , "r" );
    fgets(netis,sizeof netis,fp);
    pclose(fp);   
		}

		{ 
	 /* Get your TimeZone */
   fp = (FILE *)popen("readlink /etc/localtime | sed -e 's%^.*share/zoneinfo/%%'  " , "r" );
    fgets(tzis,sizeof tzis,fp);
    pclose(fp);   
		}
}


//////////////////////////////////////////////   Firewall ON/OFF  Call to a separate gtkdialog routine
void onoff_window(GtkWidget *w, gpointer dummy) {
    system("/usr/local/firewallgtk/firewallgtk &");
}

 ////////////////////////////////////////////////// Runs External IP script routine
/*void   ISip (){
  system("/usr/local/firewallstate/ipwget");
}*/

////////////////////////////////////////////////// Runs Net IP script
void NETip()  {
  system("/sbin/ifconfig  > /tmp/ifstuff.txt 2>&1");
  }
 
 ////////////////////////////////////////////////////    Run Psync time server update
void psync_window(GtkWidget *w, gpointer dummy) {
    system("/usr/local/psync/psync &");
}
 
////////////////////////////////////////////////////    Time and date set
void timdat_window(GtkWidget *w, gpointer dummy) {
    system("set-time-for-puppy");
}

////////////////////////////////////////////////////    Runs Firewall Wizard
void showme_window(GtkWidget *w, gpointer dummy) {
    system("rxvt -e firewallinstallshell");
}

////////////////////////////////////////////////////  Runs network Wizard
void shownet_window(GtkWidget *w, gpointer dummy) {
    system("connectwizard &");
}

////////////////////////////////////////////////////  Quit and remove from starting
void quit(GtkWidget *w, gpointer dummy) {
    remove("/root/.config/autostart/firewallstaterun.desktop"); /*  removes applet from Startup folder to prevent next start at boot */
    gtk_main_quit();                          /* note that rerun.sh script is called from menu which re-instates in Startup*/
}

////////////////////////////////////////////////////  Information window called from right click menu
void show_hide_window(void) {
	
	GtkWidget *window, *widget, *vbox, *frame, *box ;
	char temp[50] , istemp1[30], istemp2[30],  istemp3[30],  
	keytemp[25], langtemp[30] , nettemp[50],
	tztemp[50];

	    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	    gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
 gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroy),window);
 gtk_signal_connect(GTK_OBJECT(window), "destroy_event", GTK_SIGNAL_FUNC(gtk_widget_destroy),window); 

	    gtk_window_set_title(GTK_WINDOW(window), _("Information"));
        gtk_container_set_border_width(GTK_CONTAINER(window), 8);
	    gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, TRUE);
	    gtk_widget_realize(window);
	
	    vbox = gtk_vbox_new(FALSE, 5);
	    gtk_container_add(GTK_CONTAINER(window), vbox);	
	    frame = gtk_frame_new("");
    	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 3);
	    box = gtk_vbox_new(FALSE, 5);
	    gtk_container_set_border_width(GTK_CONTAINER(box), 10);
	    gtk_container_add(GTK_CONTAINER(frame), box);	
	    g_snprintf(istemp3, sizeof(istemp3), "%s", pupname);
	    widget = gtk_label_new(istemp3);
			gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 3);		
			g_snprintf(istemp2, sizeof(istemp2), _("Version %s"), pupvernum);
			widget = gtk_label_new(istemp2);
	    gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 3);	
	    g_snprintf(istemp1, sizeof(istemp1), "", puppyversion);
	    widget = gtk_label_new(istemp1);
		/*	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 3);	
			g_snprintf(ipistemp, sizeof(ipistemp), _("Your external IP is  %s"), ipis);
			widget = gtk_label_new(ipistemp);   */	
	    gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 3);	
	    g_snprintf(nettemp, sizeof(nettemp), _("PC network address %s"), netis);
	    widget = gtk_label_new(nettemp);   	
			gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 3);	
			g_snprintf(langtemp, sizeof(langtemp), _("Language is :- %s"), langvers);
			widget = gtk_label_new(langtemp); 	
	    gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 3);	
	    g_snprintf(keytemp, sizeof(keytemp), _("Keyboard is set to :- %s"), keyvers);
	    widget = gtk_label_new(keytemp); 
			gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 3);	
			g_snprintf(tztemp, sizeof(tztemp), _("TimeZone is :- %s"), tzis);
			widget = gtk_label_new(tztemp); 
	    gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 3);	  
	    g_snprintf(temp, sizeof(temp), _("    Firewall Status v %s  Rob Lane 2010    "), THIS_VERSION);
	    widget = gtk_label_new(temp);
			gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 3);
			widget = gtk_button_new_with_label(_("Close"));
			g_signal_connect_swapped (GTK_OBJECT(widget), "clicked",G_CALLBACK (gtk_widget_destroy),window);
	    gtk_box_pack_start(GTK_BOX(vbox), widget, FALSE, FALSE, 0);

	    gtk_widget_show_all(window);
}

////////////////////////////////////////////////////  What right click does, calls gtk menu with "items" 
void tray_icon_on_menu(GtkStatusIcon *status_icon,  guint button, guint activate_time, gpointer user_data)
{
        GtkWidget *menu, *menuitem, *label, *iconw, *image, *sep  ;
        menu = gtk_menu_new();
 
        
        label = gtk_image_menu_item_new_with_label(_("Psync - set accurate time"));
	    image = gtk_image_new_from_file("/usr/local/lib/X11/mini-icons/mini-clock.xpm");
	    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(label), image);
	    gtk_menu_shell_append(GTK_MENU_SHELL(menu), label);
	    g_signal_connect(label, "activate", (GCallback) psync_window, status_icon); 
                             
        label = gtk_image_menu_item_new_with_label(_("Set time and date"));
	    image = gtk_image_new_from_file("/usr/local/lib/X11/mini-icons/mini-clock.xpm");
	    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(label), image);
	    gtk_menu_shell_append(GTK_MENU_SHELL(menu), label);
	    g_signal_connect(label, "activate", (GCallback) timdat_window, status_icon); 
	     
        label = gtk_image_menu_item_new_with_label(_("Internet Connection Wizard"));
	    iconw = gtk_image_new_from_stock(GTK_STOCK_NETWORK, GTK_ICON_SIZE_MENU);
	    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(label), iconw);
	    gtk_menu_shell_append(GTK_MENU_SHELL(menu), label);
	    g_signal_connect(label, "activate", (GCallback) shownet_window, status_icon); 
	          
        label = gtk_image_menu_item_new_with_label(_("Firewall Wizard"));
	    iconw = gtk_image_new_from_stock(GTK_STOCK_EXECUTE, GTK_ICON_SIZE_MENU);
	    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(label), iconw);
	    gtk_menu_shell_append(GTK_MENU_SHELL(menu), label);
	    g_signal_connect(label, "activate", (GCallback) showme_window, status_icon); 
	     
	    label = gtk_image_menu_item_new_with_label(_("Firewall ON/OFF/Remove"));
	    image= gtk_image_new_from_file ("/usr/local/lib/X11/mini-icons/mini-firewall.xpm");
	    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(label), image);
	    gtk_menu_shell_append(GTK_MENU_SHELL(menu), label);
	    g_signal_connect(label, "activate", (GCallback) onoff_window, status_icon); 
	     
	     label = gtk_image_menu_item_new_with_label(_("Information"));
	    iconw = gtk_image_new_from_stock(GTK_STOCK_INFO, GTK_ICON_SIZE_MENU);
	    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(label), iconw);
	    gtk_menu_shell_append(GTK_MENU_SHELL(menu), label);
	    g_signal_connect(label, "activate", (GCallback) show_hide_window, status_icon);
	    	    
	    sep = gtk_menu_item_new();      /* Separator */
        gtk_menu_append(GTK_MENU(menu), sep);
        
        label = gtk_image_menu_item_new_with_label(_("Quit & Remove Firewall Status"));
	    iconw = gtk_image_new_from_stock(GTK_STOCK_QUIT, GTK_ICON_SIZE_MENU);
	    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(label), iconw);
	    gtk_menu_shell_append(GTK_MENU_SHELL(menu), label);
	    g_signal_connect(label, "activate", (GCallback) quit, status_icon);	    


        gtk_widget_show_all(menu);
        gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, button, gdk_event_get_time(NULL));
}

//////////////////////////////////////////////////// What left click does, brings up Firewall Wizard
void tray_icon_on_click(GtkStatusIcon *status_icon, gpointer user_data)  {  
	system("rxvt -e firewallinstallshell");
     }
 
//////////////////////////////////////////////////// -create icon and 'click' properties
static GtkStatusIcon *create_tray_icon() {

       tray_icon = gtk_status_icon_new();

			g_signal_connect(G_OBJECT(tray_icon), "activate", G_CALLBACK(tray_icon_on_click), NULL);

			g_signal_connect(G_OBJECT(tray_icon), "popup-menu", G_CALLBACK(tray_icon_on_menu), NULL);

			gtk_status_icon_set_visible(tray_icon, TRUE);

       return tray_icon;
}

//////////////////////////////////////////////////// THE main 'running' routine i.e. all above routines called here and run, 
//////////////////////////////////////////////////// Then starts again running at 'interval' value.(currently 1 second)
int main(int argc, char **argv) {
	
	    setlocale( LC_ALL, "" );
        bindtextdomain( "firewallstate", "/usr/share/locale" );
        textdomain( "firewallstate" );

		gtk_init(&argc, &argv);
		 
		//ISip(NULL);
		
		NETip(NULL);
		
		Info(NULL);

        tray_icon = create_tray_icon();
                        
        g_timeout_add(interval, Firestate, NULL); //changed from gtk_timeout_add
	
        gtk_main();

        return 0;
}
