/* 
 * minixcal - a minimalistic X calendar
 *
 * Copyright (C) 2006, Lior Tubi <lior2b@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/* BK hacked for osmo, jan 2008 */

#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <X11/Xlib.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>

#define MINIXCAL_VERSION "1.1.1"

/****************************************************************************
 ****************************************************************************/

void CalQuit(GtkWidget *widget, gpointer gdata);
void CalKeyPress(GtkWidget *widget, GdkEventKey *event, gpointer gdata);
void CalButtonPress(GtkWidget *widget, GdkEventButton *event, gpointer gdata);
void LaunchIcal(GtkWidget *widget, gpointer gdata);
void WindowSetOnTop(Window window);
void GetMousePosition(int *x, int *y);

/****************************************************************************
 ****************************************************************************/
 
int main(int argc, char **argv) {
	time_t curTime;
	struct tm *curTimeBroken;
	GtkWidget *window;
	GtkWidget *calendar;
	GtkWidget *vbox;
	GtkWidget *button;
	GtkStyle *style;
	GtkCalendarDisplayOptions flags;
	FILE *fp;
	char which[] = "\0";
	int mouseX, mouseY;
	int i;
	XWindowAttributes windowAttributes;

	gtk_init(&argc, &argv);

	for(i = 1; i < argc; ++i) {
		if(!strcmp(argv[i], "-v") || !strcmp(argv[i], "--version") || !strcmp(argv[i], "-h") || !strcmp(argv[i], "--help")) {
			printf("minixcal v%s by Lior Tubi <lior2b@gmail.com>\n", MINIXCAL_VERSION);
			return 0;
		}
	}

	curTime = time(NULL);

	if(curTime == -1) {
		g_print("Error: could not read date\n");
		return 0;
	}

	curTimeBroken = localtime(&curTime);

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), "minixcal");
	
	/* black border */
	style = gtk_style_copy(gtk_widget_get_style(window));
	style->bg[GTK_STATE_NORMAL] = style->black;
	gtk_widget_set_style(window, style);
	gtk_container_set_border_width(GTK_CONTAINER(window), 1);

	gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(CalQuit), NULL);
	gtk_signal_connect(GTK_OBJECT(window), "focus_out_event", GTK_SIGNAL_FUNC(CalQuit), NULL);
	gtk_signal_connect(GTK_OBJECT(window), "key_press_event", GTK_SIGNAL_FUNC(CalKeyPress), NULL);
	gtk_signal_connect(GTK_OBJECT(window), "button_press_event", GTK_SIGNAL_FUNC(CalButtonPress), NULL);

	vbox = gtk_vbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(window), vbox);

	/* use which to determine if Ical is installed. BK osmo... */
	fp = popen("which osmo", "r");
	fgets(which, sizeof(which), fp);
	if(which[0]) {
	    button = gtk_button_new_with_label("Launch Osmo Calendar");
		gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(LaunchIcal), NULL);
		gtk_box_pack_start(GTK_BOX(vbox), button, TRUE, TRUE, 0);
	}
	pclose(fp);

	calendar = gtk_calendar_new();
	flags = GTK_CALENDAR_SHOW_HEADING | GTK_CALENDAR_SHOW_DAY_NAMES | GTK_CALENDAR_SHOW_WEEK_NUMBERS;
	gtk_calendar_display_options(GTK_CALENDAR(calendar), flags);
	gtk_calendar_select_month(GTK_CALENDAR(calendar), curTimeBroken->tm_mon, 1900+curTimeBroken->tm_year);
	gtk_calendar_select_day(GTK_CALENDAR(calendar), curTimeBroken->tm_mday);
	gtk_box_pack_start(GTK_BOX(vbox), calendar, TRUE, TRUE, 0);

	gtk_widget_realize(window);
	gdk_window_set_decorations(window->window, 0);
	gtk_widget_show_all(window);

	GetMousePosition(&mouseX, &mouseY);
	if(mouseX > -1) {
		XGetWindowAttributes(GDK_DISPLAY(), GDK_WINDOW_XWINDOW(window->window), &windowAttributes);
		gdk_window_move(window->window,
			(mouseX + windowAttributes.width > gdk_screen_width())?(mouseX - windowAttributes.width):(mouseX),
			(mouseY + windowAttributes.height > gdk_screen_height())?(mouseY - windowAttributes.height):(mouseY));
	} else {
		gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
	}
	WindowSetOnTop(GDK_WINDOW_XWINDOW(window->window));

	gtk_main();

	return 0;
}

/****************************************************************************
 * Exit on Enter, Escape or Space key press.
 ****************************************************************************/

void CalKeyPress(GtkWidget *widget, GdkEventKey *event, gpointer gdata) {
	switch(event->keyval) {
		case GDK_Return:
		case GDK_Escape:
		case GDK_space:
			CalQuit(widget, gdata);
			break;
		default:
			return;
	}
}

/****************************************************************************
 * Exit on right mouse click press.
 ****************************************************************************/

void CalButtonPress(GtkWidget *widget, GdkEventButton *event, gpointer gdata) {
	if(event->button == 3) {
		CalQuit(widget, gdata);
	}
}

/****************************************************************************
 ****************************************************************************/

void CalQuit(GtkWidget *widget, gpointer gdata) {
	gtk_main_quit();
}

/****************************************************************************
 * Returns the current mouse position or (-1, -1) on failure.
 ****************************************************************************/

void GetMousePosition(int *x, int *y) {
	Window child, root;
	int win_x, win_y;
	unsigned int mask;

	if(!XQueryPointer(GDK_DISPLAY(), GDK_ROOT_WINDOW(), &root, &child, x, y, &win_x, &win_y, &mask)) {
		*x = -1;
		*y = -1;
	}
}

/****************************************************************************
 * Sends an event to bring the window to front.
 ****************************************************************************/

void WindowSetOnTop(Window window) {
	XEvent xevent;

	xevent.type = ClientMessage;
	xevent.xclient.type = ClientMessage;
	xevent.xclient.window = window;
	xevent.xclient.message_type = XInternAtom(GDK_DISPLAY(), "_WIN_LAYER", FALSE);
	xevent.xclient.format = 32;
	xevent.xclient.data.l[0] = 10;
	XSendEvent(GDK_DISPLAY(), GDK_ROOT_WINDOW(), FALSE, SubstructureNotifyMask, (XEvent *) & xevent);
}

/****************************************************************************
 * Launch Ical and exit.
 ****************************************************************************/

void LaunchIcal(GtkWidget *widget, gpointer gdata) {
	execl("/bin/sh", "sh", "-c", "osmo &", NULL);
	CalQuit(NULL, NULL);
}
