#include <stdio.h>	      
#include <stdlib.h>
#include "lists.h"
#include "scan.h"
#include "net.h"

static void printh_stat(int s){
	switch(s){
	case H_TEST:
		printf("Host test");
		return;
	case H_TESTRUN:
		printf("Host testrun");
		return;
	case H_RUN:
		printf("Host scan");
		return;
	case H_DONE:
		printf("Host done");
	}	
}

static void printp_stat(int s){
	switch(s){
	case P_TEST:
		printf("port test");
		return;
	case P_WAIT:
		printf("port wait");
		return;
	case P_FAIL:
		printf("port fail");
		return;
	case P_OK:
		printf("port OK");
	}	
}

static void print_succese(long int ip,int port){
	printf("ip: %s %d OK",inet_htoa(ip),port);
	if(net_portname(port)!=NULL)
		printf(" service:%s",net_portname(port));
	if(net_portprota(port)!=NULL)
		printf(" protocol:%s",net_portprota(port));
	printf("\n");
}


static void print_fail(long int ip,int port){
	if(verbose_level()==0)
		return;
	printf("ip: %s %d FAIL",inet_htoa(ip),port);
	if(net_portname(port)!=NULL)
		printf(" service:%s",net_portname(port));
	if(net_portprota(port)!=NULL)
		printf(" protocol:%s",net_portprota(port));
	printf("\n");
}

/* post list */
plist addp_one(PElement info,plist l){
	plist res=malloc(sizeof(*res));
	if(res==NULL)
		return mkPEmpty();
	res->next=l;
	res->info=info;
	return res;
}

void free_plist(plist l){
	if(isPEmpty(l))
		return;
	free_plist(l->next);
	free(l);
}

void print_port(plist l){
	if(isPEmpty(l))
		return;
	print_port(l->next);
	printf("Port %d ",l->info.port);
	printp_stat(l->info.status);
	if(net_portname(l->info.port)!=NULL)
		printf(" service:%10s",net_portname(l->info.port));
	if(net_portprota(l->info.port)!=NULL)
		printf(", protocol:%4s",net_portprota(l->info.port));
	printf("\n");
}

/* ip list */
list add_one(Element info,list l){
	list res=malloc(sizeof(*res));
	if(res==NULL)
		return mkEmpty();
	res->next=l;
	res->info=info;
	return res;
}

void free_list(list l){
	if(isEmpty(l))
		return;
	free_list(l->next);
	free(l);
}

void print_ip(list l){
	if(isEmpty(l))
		return;
	print_ip(l->next);	
	printf("ip:\t%s\t",inet_htoa(l->info.ip));
	printh_stat(l->info.status);
	printf("\n");
}

void print_ports(list l){
	if(isEmpty(l))
		return; 
	print_ports(l->next);
	printf("ip:\t%s\t",inet_htoa(l->info.ip));
	printh_stat(l->info.status);
	printf("\n");
	print_port(l->info.ports);
}


void free_ports(list l){
	if(isEmpty(l))
		return;
	free_plist(l->info.ports);
	free_ports(l->next);
}

static plist init_port(int s,int e){
	int i;
	plist res=mkPEmpty();
	for(i=s;i<=e;i++){
		PElement in;
		in.port=i;
		in.status=P_TEST;
		res=addp_one(in,res);
		if(isPEmpty(res))
			return mkPEmpty();
	}
	return res;
}

int init_ports(int s,int e,list l){
	if(isEmpty(l))
		return 0;
	l->info.ports=init_port(s,e);
	if(isPEmpty(l->info.ports))
		return -1;
	return init_ports(s,e,l->next);	
}

int is_open_connection(list l){
	if(isEmpty(l))
		return 0;
	if(l->info.status == H_TEST 
	|| l->info.status == H_TESTRUN
	|| l->info.status == H_RUN )
		return 1;
	return is_open_connection(l->next);
}

static plist last_p(plist p){
	if(isPEmpty(p->next))
		return p;
	return last_p(p->next);	
}

static int open_one_port(list l){
	int status;
	plist p=last_p(l->info.ports);
	p->info.socket=connect_to(l->info.ip,p->info.port,&status);
	switch(status){
	case ST_CONNECT:
		l->info.status=H_RUN;
		p->info.status=P_OK;
		print_succese(l->info.ip,p->info.port);
		return 0;
	case ST_ERROR:
		return -1;
	case ST_WAIT:
		l->info.status=H_TESTRUN;
		p->info.status=P_WAIT;
		return 0;
	case ST_NOCONNECT:
		l->info.status=H_RUN;
		p->info.status=P_FAIL;
		print_fail(l->info.ip,p->info.port);
		return 0;
	case ST_FAIL:	
		l->info.status=H_DONE;
		p->info.status=P_FAIL;
		print_fail(l->info.ip,p->info.port);
		return 0;
	case ST_NORESOURCE:
		return 1;
	}
	return 0;
}

static int open_all_ports_1(list l,plist p){
	if(isPEmpty(p))
		return 0;
	if(p->info.status==P_TEST){
		int status;
		p->info.socket=connect_to(l->info.ip,p->info.port,&status);
	
		switch(status){
		case ST_CONNECT:
			p->info.status=P_OK;
			print_succese(l->info.ip,p->info.port);
			break;
		case ST_ERROR:
			return -1;
		case ST_WAIT:
			p->info.status=P_WAIT;
			break;
		case ST_NOCONNECT:
			p->info.status=P_FAIL;
			print_fail(l->info.ip,p->info.port);
			break;
		case ST_FAIL:	
			p->info.status=P_FAIL;
			print_fail(l->info.ip,p->info.port);
			break;
		case ST_NORESOURCE:
			return 1;
		}
	}
	return open_all_ports_1(l,p->next);
}

static int open_all_ports(list l){
	return open_all_ports_1(l,l->info.ports);
}

int connections(list l){
	int k=0;
	if(isEmpty(l))
		return 0;
	switch(l->info.status){
	case H_TEST:
		k=open_one_port(l);
		break;
	case H_RUN:
		k=open_all_ports(l);
		break;
	}	
	if(k==-1)
		return -1;
	else if(k==1)
		return 0;
	return connections(l->next);	
}

static void set_listen_to_ports(plist p){
	if(isPEmpty(p))
		return;
	if(p->info.status==P_WAIT)
		add_to_list(p->info.socket);
	set_listen_to_ports(p->next);	
}

static void set_listen_ports(list l){
	if(isEmpty(l))
		return;
	if(l->info.status==H_TESTRUN || l->info.status==H_RUN)
		set_listen_to_ports(l->info.ports);	
	set_listen_ports(l->next);		
}

static void check_ports_reult(list l,plist p){
	if(isPEmpty(p))
		return;
	if(p->info.status==P_WAIT){
		if(is_in_list(p->info.socket)){
			int status;
			get_con_status(p->info.socket,&status);
			
			switch(status){
			case ST_CONNECT:
				p->info.status=P_OK;
				print_succese(l->info.ip,p->info.port);
			break;
			/*case ST_ERROR:
				return -1;*/
			case ST_NOCONNECT:
				p->info.status=P_FAIL;
				print_fail(l->info.ip,p->info.port);
				break;
			case ST_FAIL:	
				p->info.status=P_FAIL;
				print_fail(l->info.ip,p->info.port);
				break;
			/*case ST_NORESOURCE:
				return 1;*/
			}
		}
	}
	check_ports_reult(l,p->next);
}

static int check_if_done(plist p){
	if(isPEmpty(p))
		return 1;
	if(p->info.status==P_TEST
	|| p->info.status==P_WAIT)
		return 0;
	return check_if_done(p->next);	
}


static int check_ports_one_reult(list l){
	int status;
	plist p=last_p(l->info.ports);
	if(!is_in_list(p->info.socket))
		return 0;
	get_con_status(p->info.socket,&status);
	switch(status){
	case ST_CONNECT:
		l->info.status=H_RUN;
		p->info.status=P_OK;
		print_succese(l->info.ip,p->info.port);
		return 0;
	case ST_ERROR:
		return -1;
	case ST_WAIT:
		l->info.status=H_TESTRUN;
		p->info.status=P_WAIT;
		return 0;
	case ST_NOCONNECT:
		l->info.status=H_RUN;
		p->info.status=P_FAIL;
		print_fail(l->info.ip,p->info.port);
		return 0;
	case ST_FAIL:	
		l->info.status=H_DONE;
		p->info.status=P_FAIL;
		print_fail(l->info.ip,p->info.port);
		return 0;
	case ST_NORESOURCE:
		return 1;
	}
	return 0;
}

static void check_result(list l){
	if(isEmpty(l))
		return;
	if(l->info.status==H_TESTRUN)
		check_ports_one_reult(l);
	if(l->info.status==H_RUN){
		check_ports_reult(l,l->info.ports);
		if(check_if_done(l->info.ports))
			l->info.status=H_DONE;
	}
	check_result(l->next);	
}

int listen_results(list l){
	reset_list();
	set_listen_ports(l);
	switch(listen_list()){
	case -1: return -1;
	case 2: return 1;
	}
	check_result(l);
	return 0;
}
