#ifndef _LISTS_H__
#define _LISTS_H__

#define H_TEST    0
#define H_TESTRUN 1
#define H_RUN     2
#define H_DONE    3

#define P_TEST    0
#define P_WAIT    1
#define P_FAIL    2
#define P_OK      3

/* ports list */
typedef struct{
	int port;
	int status;
	int socket;
} PElement;

typedef struct pnode *plist;
struct pnode{
	PElement info;
	plist next;
};

#define NULL_plist ((plist)0)
#define mkPEmpty() (NULL_plist)
#define isPEmpty(l) (l==mkPEmpty())

plist addp_one(PElement info,plist l);
void free_plist(plist l);

/* ip list */
typedef struct{
	long int ip;
	int status;
	plist ports;
} Element;

typedef struct Node* list;
struct Node{
	Element info;
	list next;
};

#define NULL_LIST ((list)0)
#define mkEmpty() (NULL_LIST)
#define isEmpty(l) (l==mkEmpty())

list add_one(Element info,list l);
void free_list(list l);
void print_ip(list l);
void print_ports(list l);

void free_ports(list l);
int init_ports(int s,int e,list l);

int is_open_connection(list l);
int connections(list l);
int listen_results(list l);
#endif
