#include "scan.h"
#include "lists.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>	      
#include <stdlib.h>
#include "net.h"

static list hlist;
static int verb;

int verbose_level(void){
	return verb;
}

/* ip host byte order */
static long int next_ip_(char **ip,int len){
	static int p=0;
	static int num=0;
	
	if(p>=len)
		return -2;
	if(*ip[p]=='-'){
		long int max;
		long int base;
		if(p+1>=len)
			return -2;
		max=inet_network(ip[p+1]);
		if(max==-1){
			p+=2;
			return -1;
		}
		num++;
		base=inet_network(ip[p-1]);
		if(base+num<max && base != -1)
			return inet_network(ip[p-1])+num;
		p++;	
	}  
	num=0;
	return inet_network(ip[p++]);
}

static long int next_ip(char **ip,int len){
	long int res;
	while((res=next_ip_(ip,len))==-1);
	return res;
}


static int init_host_ip(char **ip,int len){
	long int hip;
	hlist=mkEmpty();
	while((hip=next_ip(ip,len))!=-2){
		Element in;
		in.ip=hip;
		in.status=H_TEST;
		in.ports=mkPEmpty();
		hlist=add_one(in,hlist);
		if(isEmpty(hlist))
			return -1;
	}

	return 0;
}

static void close_hosts(void){
	free_ports(hlist);
	free_list(hlist);
}


int scan(int s_port,int e_port,char **ip,int len,int typ,int verbose){
	verb=verbose;
	if(init_host_ip(ip,len)!=0)
		return -1;
	if(init_ports(s_port,e_port,hlist)!=0)
		return -1;
	if(verbose==2)
		print_ip(hlist);
	else if(verbose>=3)
		print_ports(hlist);
	if(connections(hlist)==-1)
		exit(-1);
	while(is_open_connection(hlist)){
		switch(listen_results(hlist)){
		case -1: exit(-1);
		case 1:  exit(0);
		}
		if(connections(hlist)==-1)
			exit(-1);
	}
	close_hosts();
	return 0;
}
