#include <stdlib.h>
#include <stdio.h>
#include <getopt.h>
#include "scan.h"
#include "net.h"
#include "config.h"

static int stealth=0;
static int verbose=0;
static int s_port=1;
static int e_port=1;

static void version(void){
	printf(PACKAGE ", " VERSION "\n");
}

static void usage(char *name){
	version();
	printf("Suggestions, comments, and bugs to: Markus Fraczek (marekf@gmx.net)\n\n");
	printf("usage: %s [-V] | [-h] | [-v] [-t sec] [-p N] [-e N] IP\n",name);
	printf("\n" 
	       "-V\t\tPrints Version\n"
	       "-h\t\tshow this usage message\n"
	       "-v\t\tverbose, -vvv more verbose\n"
	       "-t\t\ttimeout sec\n"
	       "-p\t\tfirst port\n"
	       "-e\t\tlast port\n"
	       "IP:\t\tlist or range\n"
	       "\nexample:\t%s -p 22 192.168.1.1 - 192.168.1.10\n"
	         "        \t%s -p 53 -e 101 192.168.1.1\n",name,name);
}

static int init(int argc, char **argv){
	int c;	
	while((c=getopt(argc,argv,"hVvp:e:st:"))!=-1){
		switch(c){
		case 's':
		        /* TODO: stealth scanner */		
			stealth=1;	
			break;
		case 'V':
			version();
			exit(0);
		case 'v': 
			verbose++;
			break;
		case 'p': 
			if(optarg){
				s_port=atoi(optarg);	
				if(e_port < s_port)
					e_port=s_port;
			}
			break;
		case 'e':
			if(optarg)
				e_port=atoi(optarg);
			if(e_port < s_port){
				usage(argv[0]);
				return -1;
			}	
			break;	
		case 't':
		        if(optarg){
				int timeout=atoi(optarg);
				set_timeout(timeout);
			}
			break;
		case 'h':
			usage(argv[0]);
			exit(0);
		case '?':
			break;
		}	
	}
	if (optind == argc) {
		usage(argv[0]);
		return -1;
	}	
	return optind;	
}

int main(int argc, char **argv)
{
	if(init(argc,argv)==-1)
		return -1;
	if(scan(s_port,e_port,argv+optind,argc-optind,S_CON,verbose)!=0)
		return -1;
	return 0;
}
