/*simple systray applet example by Rodrigo De Castro, 2007*/
/*adjusted accordingly for mtpstatus, 01micko 2014*/
/*5th revision*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <glib/gstdio.h>

char infomsg[60];
FILE *fp;

GdkPixbuf *icon_pixbuf;
GtkStatusIcon *tray_icon;
GError *gerror = NULL;

void tray_icon_on_click(GtkStatusIcon *status_icon, gpointer user_data) {
	system("/usr/sbin/mtpdevice unmount &");
}

void view_popup_menu_umount (GtkWidget *w, gpointer dummy) {
    system("/usr/sbin/mtpdevice unmount &");
}

void view_browse_device (GtkWidget *w, gpointer dummy) {
    system("MNT=`cat /tmp/myMTPdevice | sed 's% %%g'`;FILEMGR='rox';type thunar &>/dev/null && FILEMGR='thunar';type pcmanfm &>/dev/null && FILEMGR='pcmanfm';type xfe &>/dev/null && FILEMGR='xfe';if [ $FILEMGR = 'rox' ];then rox -x /mnt/MTPdevice${MNT};rox -d /mnt/MTPdevice${MNT};else $FILEMGR /mnt/MTPdevice${MNT};fi");
}

void view_show_log (GtkWidget *w, gpointer dummy) {
    system("[ -f /tmp/MTP.log ] && defaulttextviewer /tmp/MTP.log &");
}

void view_show_licence (GtkWidget *w, gpointer dummy) {
    system("[ -f /usr/share/doc/legal/gpl-2.0.txt ] && defaulttextviewer /usr/share/doc/legal/gpl-2.0.txt &");
}

void quit (GtkWidget *w, gpointer dummy) {
    system("gtkdialog-splash -bg orange -close never -timeout 4 -text 'You will have to unmount your device from the menu entry' &");
    gtk_main_quit();
}

gchar *devicename () {
	char mkmodel[42];

	fp = (FILE *)popen("cat /tmp/myMTPdevice" , "r" );
	if ( fp == NULL ) {
		fprintf(stderr, "Cant find device");
		exit (-1);
	}
    fgets(mkmodel,sizeof mkmodel,fp);
    pclose(fp);
    
	infomsg[0] = 0;
	strcat(infomsg, "Unmount ");
	if (mkmodel != NULL) {
		strcat(infomsg, mkmodel);
	}
	return infomsg;
}

void tray_icon_on_menu(GtkStatusIcon *status_icon, guint button,guint activate_time, gpointer user_data) {
	GtkWidget *menu, *menuitem, *icon;
	menu = gtk_menu_new();
	
	menuitem = gtk_image_menu_item_new_with_label("View Licence");
	icon = gtk_image_new_from_stock(GTK_STOCK_INDEX, GTK_ICON_SIZE_MENU);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), icon);
    gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	g_signal_connect(menuitem, "activate", (GCallback) view_show_licence, status_icon);
	
	menuitem = gtk_image_menu_item_new_with_label("View Log");
	icon = gtk_image_new_from_stock(GTK_STOCK_JUSTIFY_LEFT, GTK_ICON_SIZE_MENU);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), icon);
    gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	g_signal_connect(menuitem, "activate", (GCallback) view_show_log, status_icon);
	
	menuitem = gtk_image_menu_item_new_with_label("Browse device");
	icon = gtk_image_new_from_stock(GTK_STOCK_OPEN, GTK_ICON_SIZE_MENU);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), icon);
    gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	g_signal_connect(menuitem, "activate", (GCallback) view_browse_device, status_icon);
	
	menuitem = gtk_image_menu_item_new_with_label(devicename());
	icon = gtk_image_new_from_stock(GTK_STOCK_EXECUTE, GTK_ICON_SIZE_MENU);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), icon);
    gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	g_signal_connect(menuitem, "activate", (GCallback) view_popup_menu_umount, status_icon);
	
	menuitem = gtk_image_menu_item_new_with_label("Quit");
    icon = gtk_image_new_from_stock(GTK_STOCK_QUIT, GTK_ICON_SIZE_MENU);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), icon);
    gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
    g_signal_connect(menuitem, "activate", (GCallback) quit, status_icon);
	
	gtk_widget_show_all(menu);
	gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, button, gdk_event_get_time(NULL));
}

static GtkStatusIcon *create_tray_icon() {

    tray_icon = gtk_status_icon_new();
	g_signal_connect(G_OBJECT(tray_icon), "activate", G_CALLBACK(tray_icon_on_click), NULL);
	
	g_signal_connect(G_OBJECT(tray_icon), "popup-menu", G_CALLBACK(tray_icon_on_menu), NULL);
					 
	icon_pixbuf=gdk_pixbuf_new_from_file("/usr/share/pixmaps/go.svg",&gerror);				 
					 
	gtk_status_icon_set_from_pixbuf(tray_icon,icon_pixbuf);								   
									   
	gtk_status_icon_set_tooltip(tray_icon, devicename());
	
	gtk_status_icon_set_visible(tray_icon, TRUE);

	return tray_icon;
}

int main(int argc, char **argv) {

	gtk_init(&argc, &argv);
	tray_icon = create_tray_icon();
	gtk_main();

	return 0;
}
