#!/bin/sh
#v3.98 handle puppy-unleashed/devx-extra

#script to create usr_devx.sfs out of usr-development folder.

PUPVER="`cat puppy-unleashed/boot/initrd-tree0/PUPPYVERSION`"

[ ! -d tmp ] && mkdir tmp
rm devx_$PUPVER.sfs-OLD
mv devx_$PUPVER.sfs devx_$PUPVER.sfs-OLD
rm devx_$PUPVER.sfs.txt
rm -rf tmp/.devx_$PUPVER
rm -f tmp/devx_$PUPVER.sfs

echo "Copying puppy-devx to tmp/.devx_$PUPVER..."
cp -a puppy-devx tmp/.devx_$PUPVER
sync

if [ -d puppy-unleashed/devx-extra ];then
 echo
 echo -n "ENTER only to add puppy-unleashed/devx-extra: "
 read DEVXE
 if [ "$DEVXE" = "" ];then
  echo "Copying puppy-unleashed/devx-extra/* to tmp/.devx_$PUPVER/ ..."
  cp -a --remove-destination puppy-unleashed/devx-extra/* tmp/.devx_$PUPVER/
  sync
 fi
fi

KERCHANGE=""
USEKERNEL="`uname -r`"
echo -n "Which kernel is this being built for [${USEKERNEL}]: "
read newusekernel
[ "$newusekernel" != "" ] && USEKERNEL="$newusekernel"
if [ -d puppy-unleashed/packages-k${USEKERNEL} ];then
 if [ -d puppy-unleashed/packages-k${USEKERNEL}/linux-header-${USEKERNEL} ];then
  cp -a --remove-destination puppy-unleashed/packages-k${USEKERNEL}/linux-header-${USEKERNEL}/* tmp/.devx_$PUPVER/
  KERCHANGE="-k${USEKERNEL}"
  sync
 fi
fi

echo "Making squashfs devx_${PUPVER}${KERCHANGE}.sfs..."
cd tmp
mksquashfs .devx_$PUPVER devx_$PUPVER.sfs
sync

cp -a devx_$PUPVER.sfs ../devx_${PUPVER}${KERCHANGE}.sfs
sync
cd ..
chmod 744 devx_${PUPVER}${KERCHANGE}.sfs
echo "Creating md5sum devx_$PUPVER.sfs.md5.txt..."
md5sum devx_${PUPVER}${KERCHANGE}.sfs > devx_${PUPVER}${KERCHANGE}.sfs.md5.txt
sync

rm -rf tmp/.devx_$PUPVER
sync

echo "Finished"

###end###

