#! /bin/sh

# -----------------------------------------------------------------------------
# Associate ROX 'SendTo/OpenWith' with MultiRename
# -----------------------------------------------------------------------------

APPNAME="MultiRename"
APPPATH="/usr/local/apps/MultiRename"

if [ "`pwd`" = "/" ]; then
  LOC1="/etc/xdg/rox.sourceforge.net/SendTo"
  LOC2="$HOME/.config/rox.sourceforge.net/SendTo"
  LOC3="$HOME/.config/rox.sourceforge.net/OpenWith"
  for i in "$LOC1" "$LOC2" "$LOC3"; do
    [ -d "$i" ] && { RC_PATH="$i"; break; }
  done
else	# Woof
  RC_PATH="./root/.config/rox.sourceforge.net/OpenWith"
fi

[ ! -L "${RC_PATH}/.inode_directory/${APPNAME}" ] && ln -s "${APPPATH}" "${RC_PATH}/.inode_directory/${APPNAME}"
[ ! -L "${RC_PATH}/.inode_mount-point/${APPNAME}" ] && ln -s "${APPPATH}" "${RC_PATH}/.inode_mount-point/${APPNAME}"

# =============================================================================
