#!/bin/sh

if [ ! "`pwd`" = "/" ]; then ##Woof build

 echo "Installing PupShutdown"

else ##Conventional PET install

 # Set the default file-backup and task-manager applications for PupShutdown
 WORKDIR="/usr/local/PupShutdown"
 if [ "`which snap2`" ]; then
  sed -i 's/^.*BACKUP.*$/BACKUP="snap2"/' $WORKDIR/PSD-apps.rc
  echo "#!/bin/bash" > $WORKDIR/defaultapps/backup
  echo "snap2" >> $WORKDIR/defaultapps/backup
 elif [ "`which pbackup`" ]; then
  sed -i 's/^.*BACKUP.*$/BACKUP="pbackup"/' $WORKDIR/PSD-apps.rc
  echo "#!/bin/bash" > $WORKDIR/defaultapps/backup
  echo "pbackup" >> $WORKDIR/defaultapps/backup
 elif [ "`which gadmin-rsync`" ]; then
  sed -i 's/^.*BACKUP.*$/BACKUP="gadmin-rsync"/' $WORKDIR/PSD-apps.rc
  echo "#!/bin/bash" > $WORKDIR/defaultapps/backup
  echo "gadmin-rsync" >> $WORKDIR/defaultapps/backup
 fi

 if [ "`which lxtask`" ]; then
  sed -i 's/^.*TASK_MANAGER.*$/TASK_MANAGER="lxtask"/' $WORKDIR/PSD-apps.rc
  echo "#!/bin/bash" > $WORKDIR/defaultapps/taskmanager
  echo "lxtask" >> $WORKDIR/defaultapps/taskmanager
 elif [ "`which htop`" ]; then
  sed -i 's/^.*TASK_MANAGER.*$/TASK_MANAGER="htop"/' $WORKDIR/PSD-apps.rc
  echo "#!/bin/bash" > $WORKDIR/defaultapps/taskmanager
  echo "rxvt +sb -fn 9x15 -bg black -fg white -title htop -n htop -e htop" >> $WORKDIR/defaultapps/taskmanager
 elif [ "`which xfce4-taskmanager`" ]; then
  sed -i 's/^.*TASK_MANAGER.*$/TASK_MANAGER="xfce4-taskmanager"/' $WORKDIR/PSD-apps.rc
  echo "#!/bin/bash" > $WORKDIR/defaultapps/taskmanager
  echo "xfce4-taskmanager" >> $WORKDIR/defaultapps/taskmanager
 elif [ "`which pprocess`" ]; then
  sed -i 's/^.*TASK_MANAGER.*$/TASK_MANAGER="pprocess"/' $WORKDIR/PSD-apps.rc
  echo "#!/bin/bash" > $WORKDIR/defaultapps/taskmanager
  echo "pprocess" >> $WORKDIR/defaultapps/taskmanager
 fi

 . /etc/DISTRO_SPECS
 sed -i -e 's/^.*NEWLABEL=.*$/NEWLABEL="'"$DISTRO_NAME"'"/' $HOME/.PupShutdown/pupshutdown.rc
 cp -f $HOME/.PupShutdown/pupshutdown.rc $HOME/.PupShutdown/pupshutdown-restore.rc
 cp -f $WORKDIR/PSD-apps.rc $WORKDIR/PSD-apps2.rc
 Xdialog --title PSD --beep --msgbox "  All files are installed...  \n\n  The PupShutdown 'Ctrl+Shift+X' hotkey is available for  \n  IceWM, JWM, Fluxbox, Openbox and LXDE-LXPanel.  \n\n  Go to PupShutdown Preferences to select the \n default applications and program hotkey.  " 0x0+200+100 && exit 0
fi

#END
