# This file has been autogenerated by the pywayland scanner

# Copyright 2015 Sean Vig
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSurface


class ZwpPointerGestureSwipeV1(Interface):
    """A swipe gesture object

    A swipe gesture object notifies a client about a multi-finger swipe gesture
    detected on an indirect input device such as a touchpad. The gesture is
    usually initiated by multiple fingers moving in the same direction but once
    initiated the direction may change. The precise conditions of when such a
    gesture is detected are implementation-dependent.

    A gesture consists of three stages: begin, update (optional) and end. There
    cannot be multiple simultaneous hold, pinch or swipe gestures on a same
    pointer/seat, how compositors prevent these situations is implementation-
    dependent.

    A gesture may be cancelled by the compositor or the hardware. Clients
    should not consider performing permanent or irreversible actions until the
    end of a gesture has been received.
    """

    name = "zwp_pointer_gesture_swipe_v1"
    version = 2


class ZwpPointerGestureSwipeV1Proxy(Proxy[ZwpPointerGestureSwipeV1]):
    interface = ZwpPointerGestureSwipeV1

    @ZwpPointerGestureSwipeV1.request()
    def destroy(self) -> None:
        """Destroy the pointer swipe gesture object
        """
        self._marshal(0)
        self._destroy()


class ZwpPointerGestureSwipeV1Resource(Resource):
    interface = ZwpPointerGestureSwipeV1

    @ZwpPointerGestureSwipeV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.Uint),
    )
    def begin(self, serial: int, time: int, surface: WlSurface, fingers: int) -> None:
        """Multi-finger swipe begin

        This event is sent when a multi-finger swipe gesture is detected on the
        device.

        :param serial:
        :type serial:
            `ArgumentType.Uint`
        :param time:
            timestamp with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :param fingers:
            number of fingers
        :type fingers:
            `ArgumentType.Uint`
        """
        self._post_event(0, serial, time, surface, fingers)

    @ZwpPointerGestureSwipeV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Fixed),
    )
    def update(self, time: int, dx: float, dy: float) -> None:
        """Multi-finger swipe motion

        This event is sent when a multi-finger swipe gesture changes the
        position of the logical center.

        The dx and dy coordinates are relative coordinates of the logical
        center of the gesture compared to the previous event.

        :param time:
            timestamp with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        :param dx:
            delta x coordinate in surface coordinate space
        :type dx:
            `ArgumentType.Fixed`
        :param dy:
            delta y coordinate in surface coordinate space
        :type dy:
            `ArgumentType.Fixed`
        """
        self._post_event(1, time, dx, dy)

    @ZwpPointerGestureSwipeV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Int),
    )
    def end(self, serial: int, time: int, cancelled: int) -> None:
        """Multi-finger swipe end

        This event is sent when a multi-finger swipe gesture ceases to be
        valid. This may happen when one or more fingers are lifted or the
        gesture is cancelled.

        When a gesture is cancelled, the client should undo state changes
        caused by this gesture. What causes a gesture to be cancelled is
        implementation-dependent.

        :param serial:
        :type serial:
            `ArgumentType.Uint`
        :param time:
            timestamp with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        :param cancelled:
            1 if the gesture was cancelled, 0 otherwise
        :type cancelled:
            `ArgumentType.Int`
        """
        self._post_event(2, serial, time, cancelled)


class ZwpPointerGestureSwipeV1Global(Global):
    interface = ZwpPointerGestureSwipeV1


ZwpPointerGestureSwipeV1._gen_c()
ZwpPointerGestureSwipeV1.proxy_class = ZwpPointerGestureSwipeV1Proxy
ZwpPointerGestureSwipeV1.resource_class = ZwpPointerGestureSwipeV1Resource
ZwpPointerGestureSwipeV1.global_class = ZwpPointerGestureSwipeV1Global
