#!/usr/bin/env bash

export local distupstream="gentoo"
export local distname="redcore"
export local disttarget="desktop"
export local distver="1"
export local kernver="$(readlink /usr/src/linux|sed -e "s/\linux-//g" -e "s/\///g")"

export local jailx64=""$distname"_"$distver"_core_x64.squashfs"
export local jailx64sum=""$jailx64".md5sum"

export local ropath="rodir"
export local rwpath="rwdir"
export local workpath="workdir"
export local overlaypath="overlaydir"

export local jailuser="root"
export local jailarch="x86_64"
export local jailtarget="${@:2}"
export local jailkernname="vmlinuz-"$kernver""
export local jailramfsname="initrd-"$kernver""
export local jailrootpath="$distname"-"$disttarget"-"$distver"-"$jailarch"
export local jailsynctarget=""$jailrootpath"/rootfs"
export local jailsyncsource="/tmp/"$jailrootpath""
export local jailbootldrpath=""$jailrootpath"/boot/grub"
export local jailefildrpath=""$jailrootpath"/efi/boot"
export local jaildvdpath=""$jailrootpath"/CDroot"
export local jailsquashfspath=""$jailrootpath"/LiveOS"
export local jailrealfspath=""$jaildvdpath"/LiveOS"
export local jailbootldrdlpath="/tmp/bootcore"
export local jailbootldrcfgpath=""$jailbootldrdlpath"/cdroot/boot"
export local jailmainportpath="/usr/ports/"$distupstream""
export local jailaddonportpath="/usr/ports/"$distname""
export local jailportcfgtarget="/etc/portage"
export local jailportcfgsource="/opt/"$distname"-build/conf/intel/portage"
export local jailportvcspath="/opt/"$distname"-build"
