// SPDX-License-Identifier: GPL-2.0 OR BSD-3-Clause
/* Copyright(c) 2025  Realtek Corporation
 */

#include "main.h"
#include "phy.h"
#include "rtw8814a_table.h"

static const u32 rtw8814a_mac[] = {
	0x010, 0x0000007C,
	0x014, 0x000000DB,
	0x016, 0x00000002,
	0x073, 0x00000010,
	0x420, 0x00000080,
	0x421, 0x0000000F,
	0x428, 0x0000000A,
	0x429, 0x00000010,
	0x430, 0x00000000,
	0x431, 0x00000000,
	0x432, 0x00000000,
	0x433, 0x00000001,
	0x434, 0x00000004,
	0x435, 0x00000005,
	0x436, 0x00000007,
	0x437, 0x00000008,
	0x43C, 0x00000004,
	0x43D, 0x00000005,
	0x43E, 0x00000007,
	0x43F, 0x00000008,
	0x440, 0x0000005D,
	0x441, 0x00000001,
	0x442, 0x00000000,
	0x444, 0x00000010,
	0x445, 0x000000F0,
	0x446, 0x00000001,
	0x447, 0x000000FE,
	0x448, 0x00000000,
	0x449, 0x00000000,
	0x44A, 0x00000000,
	0x44B, 0x00000040,
	0x44C, 0x00000010,
	0x44D, 0x000000F0,
	0x44E, 0x0000003F,
	0x44F, 0x00000000,
	0x450, 0x00000000,
	0x451, 0x00000000,
	0x452, 0x00000000,
	0x453, 0x00000040,
	0x45E, 0x00000004,
	0x49C, 0x00000010,
	0x49D, 0x000000F0,
	0x49E, 0x00000000,
	0x49F, 0x00000006,
	0x4A0, 0x000000E0,
	0x4A1, 0x00000003,
	0x4A2, 0x00000000,
	0x4A3, 0x00000040,
	0x4A4, 0x00000015,
	0x4A5, 0x000000F0,
	0x4A6, 0x00000000,
	0x4A7, 0x00000006,
	0x4A8, 0x000000E0,
	0x4A9, 0x00000000,
	0x4AA, 0x00000000,
	0x4AB, 0x00000000,
	0x7DA, 0x00000008,
	0x1448, 0x00000006,
	0x144A, 0x00000006,
	0x144C, 0x00000006,
	0x144E, 0x00000006,
	0x4C8, 0x000000FF,
	0x4C9, 0x00000008,
	0x4CA, 0x0000003C,
	0x4CB, 0x0000003C,
	0x4CC, 0x000000FF,
	0x4CD, 0x000000FF,
	0x4CE, 0x00000001,
	0x4CF, 0x00000008,
	0x500, 0x00000026,
	0x501, 0x000000A2,
	0x502, 0x0000002F,
	0x503, 0x00000000,
	0x504, 0x00000028,
	0x505, 0x000000A3,
	0x506, 0x0000005E,
	0x507, 0x00000000,
	0x508, 0x0000002B,
	0x509, 0x000000A4,
	0x50A, 0x0000005E,
	0x50B, 0x00000000,
	0x50C, 0x0000004F,
	0x50D, 0x000000A4,
	0x50E, 0x00000000,
	0x50F, 0x00000000,
	0x512, 0x0000001C,
	0x514, 0x0000000A,
	0x516, 0x0000000A,
	0x521, 0x0000002F,
	0x525, 0x00000047,
	0x550, 0x00000010,
	0x551, 0x00000010,
	0x559, 0x00000002,
	0x55C, 0x00000064,
	0x55D, 0x000000FF,
	0x577, 0x00000003,
	0x5BE, 0x00000064,
	0x604, 0x00000001,
	0x605, 0x00000030,
	0x607, 0x00000001,
	0x608, 0x0000000E,
	0x609, 0x0000002A,
	0x60A, 0x00000000,
	0x60C, 0x00000018,
	0x60D, 0x00000050,
	0x6A0, 0x000000FF,
	0x6A1, 0x000000FF,
	0x6A2, 0x000000FF,
	0x6A3, 0x000000FF,
	0x6A4, 0x000000FF,
	0x6A5, 0x000000FF,
	0x6DE, 0x00000084,
	0x620, 0x000000FF,
	0x621, 0x000000FF,
	0x622, 0x000000FF,
	0x623, 0x000000FF,
	0x624, 0x000000FF,
	0x625, 0x000000FF,
	0x626, 0x000000FF,
	0x627, 0x000000FF,
	0x638, 0x00000064,
	0x63C, 0x0000000A,
	0x63D, 0x0000000A,
	0x63E, 0x0000000E,
	0x63F, 0x0000000E,
	0x640, 0x00000040,
	0x642, 0x00000040,
	0x643, 0x00000000,
	0x652, 0x000000C8,
	0x66E, 0x00000005,
	0x700, 0x00000021,
	0x701, 0x00000043,
	0x702, 0x00000065,
	0x703, 0x00000087,
	0x708, 0x00000021,
	0x709, 0x00000043,
	0x70A, 0x00000065,
	0x70B, 0x00000087,
	0x718, 0x00000040,
	0x7D5, 0x000000BC,
	0x7D8, 0x00000028,
	0x7D9, 0x00000000,
	0x7DA, 0x0000000B,
};

RTW_DECL_TABLE_PHY_COND(rtw8814a_mac, rtw_phy_cfg_mac);

static const u32 rtw8814a_agc[] = {
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000003,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000003,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000003,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000003,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFF000003,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000003,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFF000003,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000003,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000003,
	0xA0000000,	0x00000000,
	0x81C, 0xFF000003,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000003,
	0x81C, 0xFD020003,
	0x81C, 0xFC040003,
	0x81C, 0xFB060003,
	0x81C, 0xFA080003,
	0x81C, 0xF90A0003,
	0x81C, 0xF80C0003,
	0x81C, 0xF70E0003,
	0x81C, 0xF6100003,
	0x81C, 0xF5120003,
	0x81C, 0xF4140003,
	0x81C, 0xF3160003,
	0x81C, 0xF2180003,
	0x81C, 0xF11A0003,
	0x81C, 0xF01C0003,
	0x81C, 0xEF1E0003,
	0x81C, 0xEE200003,
	0x81C, 0xED220003,
	0x81C, 0xCF240003,
	0x81C, 0xCE260003,
	0x81C, 0xCD280003,
	0x81C, 0xCC2A0003,
	0x81C, 0xCB2C0003,
	0x81C, 0xCA2E0003,
	0x81C, 0xC9300003,
	0x81C, 0xC8320003,
	0x81C, 0xC7340003,
	0x81C, 0xC6360003,
	0x81C, 0xC5380003,
	0x81C, 0xC43A0003,
	0x81C, 0xA63C0003,
	0x81C, 0xA53E0003,
	0x81C, 0xA4400003,
	0x81C, 0xA3420003,
	0x81C, 0xA2440003,
	0x81C, 0xA1460003,
	0x81C, 0x86480003,
	0x81C, 0x854A0003,
	0x81C, 0x844C0003,
	0x81C, 0x834E0003,
	0x81C, 0x66500003,
	0x81C, 0x65520003,
	0x81C, 0x64540003,
	0x81C, 0x63560003,
	0x81C, 0x62580003,
	0x81C, 0x615A0003,
	0x81C, 0x435C0003,
	0x81C, 0x425E0003,
	0x81C, 0x41600003,
	0x81C, 0x27620003,
	0x81C, 0x26640003,
	0x81C, 0x25660003,
	0x81C, 0x24680003,
	0x81C, 0x236A0003,
	0x81C, 0x226C0003,
	0x81C, 0x216E0003,
	0x81C, 0x21700003,
	0x81C, 0x21720003,
	0x81C, 0x21740003,
	0x81C, 0x21760003,
	0x81C, 0x21780003,
	0x81C, 0x217A0003,
	0x81C, 0x217C0003,
	0x81C, 0x217E0003,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFF000003,
	0x81C, 0xFE020003,
	0x81C, 0xFD040003,
	0x81C, 0xFC060003,
	0x81C, 0xFB080003,
	0x81C, 0xFA0A0003,
	0x81C, 0xF90C0003,
	0x81C, 0xF80E0003,
	0x81C, 0xF7100003,
	0x81C, 0xF6120003,
	0x81C, 0xF5140003,
	0x81C, 0xF4160003,
	0x81C, 0xF3180003,
	0x81C, 0xF21A0003,
	0x81C, 0xF11C0003,
	0x81C, 0xF01E0003,
	0x81C, 0xEF200003,
	0x81C, 0xEE220003,
	0x81C, 0xED240003,
	0x81C, 0xEC260003,
	0x81C, 0xEB280003,
	0x81C, 0xEA2A0003,
	0x81C, 0xE92C0003,
	0x81C, 0xE82E0003,
	0x81C, 0xE7300003,
	0x81C, 0xE6320003,
	0x81C, 0xE5340003,
	0x81C, 0xE4360003,
	0x81C, 0xE3380003,
	0x81C, 0xC53A0003,
	0x81C, 0xC43C0003,
	0x81C, 0xC33E0003,
	0x81C, 0xC2400003,
	0x81C, 0xC1420003,
	0x81C, 0xA8440003,
	0x81C, 0xA7460003,
	0x81C, 0xA6480003,
	0x81C, 0xA54A0003,
	0x81C, 0xA44C0003,
	0x81C, 0xA34E0003,
	0x81C, 0xA2500003,
	0x81C, 0x65520003,
	0x81C, 0x64540003,
	0x81C, 0x63560003,
	0x81C, 0x62580003,
	0x81C, 0x615A0003,
	0x81C, 0x475C0003,
	0x81C, 0x465E0003,
	0x81C, 0x45600003,
	0x81C, 0x44620003,
	0x81C, 0x43640003,
	0x81C, 0x42660003,
	0x81C, 0x41680003,
	0x81C, 0x416A0003,
	0x81C, 0x416C0003,
	0x81C, 0x416E0003,
	0x81C, 0x41700003,
	0x81C, 0x41720003,
	0x81C, 0x41740003,
	0x81C, 0x41760003,
	0x81C, 0x41780003,
	0x81C, 0x417A0003,
	0x81C, 0x417C0003,
	0x81C, 0x417E0003,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000003,
	0x81C, 0xFD020003,
	0x81C, 0xFC040003,
	0x81C, 0xFB060003,
	0x81C, 0xFA080003,
	0x81C, 0xF90A0003,
	0x81C, 0xF80C0003,
	0x81C, 0xF70E0003,
	0x81C, 0xF6100003,
	0x81C, 0xF5120003,
	0x81C, 0xF4140003,
	0x81C, 0xF3160003,
	0x81C, 0xF2180003,
	0x81C, 0xF11A0003,
	0x81C, 0xF01C0003,
	0x81C, 0xEF1E0003,
	0x81C, 0xEE200003,
	0x81C, 0xED220003,
	0x81C, 0xEC240003,
	0x81C, 0xEB260003,
	0x81C, 0xEA280003,
	0x81C, 0xE92A0003,
	0x81C, 0xE82C0003,
	0x81C, 0xE72E0003,
	0x81C, 0xE6300003,
	0x81C, 0xE5320003,
	0x81C, 0xE4340003,
	0x81C, 0xE3360003,
	0x81C, 0xC6380003,
	0x81C, 0xC53A0003,
	0x81C, 0xC43C0003,
	0x81C, 0xC33E0003,
	0x81C, 0xC2400003,
	0x81C, 0xA9420003,
	0x81C, 0xA8440003,
	0x81C, 0xA7460003,
	0x81C, 0xA6480003,
	0x81C, 0xA54A0003,
	0x81C, 0xA44C0003,
	0x81C, 0xA34E0003,
	0x81C, 0x66500003,
	0x81C, 0x65520003,
	0x81C, 0x64540003,
	0x81C, 0x63560003,
	0x81C, 0x49580003,
	0x81C, 0x485A0003,
	0x81C, 0x475C0003,
	0x81C, 0x465E0003,
	0x81C, 0x45600003,
	0x81C, 0x44620003,
	0x81C, 0x43640003,
	0x81C, 0x42660003,
	0x81C, 0x41680003,
	0x81C, 0x416A0003,
	0x81C, 0x416C0003,
	0x81C, 0x416E0003,
	0x81C, 0x41700003,
	0x81C, 0x41720003,
	0x81C, 0x41740003,
	0x81C, 0x41760003,
	0x81C, 0x41780003,
	0x81C, 0x417A0003,
	0x81C, 0x417C0003,
	0x81C, 0x417E0003,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFF000003,
	0x81C, 0xFE020003,
	0x81C, 0xFD040003,
	0x81C, 0xFC060003,
	0x81C, 0xFB080003,
	0x81C, 0xFA0A0003,
	0x81C, 0xF90C0003,
	0x81C, 0xF80E0003,
	0x81C, 0xF7100003,
	0x81C, 0xF6120003,
	0x81C, 0xF5140003,
	0x81C, 0xF4160003,
	0x81C, 0xF3180003,
	0x81C, 0xF21A0003,
	0x81C, 0xF11C0003,
	0x81C, 0xF01E0003,
	0x81C, 0xEF200003,
	0x81C, 0xEE220003,
	0x81C, 0xED240003,
	0x81C, 0xEC260003,
	0x81C, 0xEB280003,
	0x81C, 0xEA2A0003,
	0x81C, 0xE92C0003,
	0x81C, 0xE82E0003,
	0x81C, 0xE7300003,
	0x81C, 0xE6320003,
	0x81C, 0xE5340003,
	0x81C, 0xE4360003,
	0x81C, 0xE3380003,
	0x81C, 0xC53A0003,
	0x81C, 0xC43C0003,
	0x81C, 0xC33E0003,
	0x81C, 0xC2400003,
	0x81C, 0xC1420003,
	0x81C, 0xA8440003,
	0x81C, 0xA7460003,
	0x81C, 0xA6480003,
	0x81C, 0xA54A0003,
	0x81C, 0xA44C0003,
	0x81C, 0xA34E0003,
	0x81C, 0xA2500003,
	0x81C, 0x65520003,
	0x81C, 0x64540003,
	0x81C, 0x63560003,
	0x81C, 0x62580003,
	0x81C, 0x615A0003,
	0x81C, 0x475C0003,
	0x81C, 0x465E0003,
	0x81C, 0x45600003,
	0x81C, 0x44620003,
	0x81C, 0x43640003,
	0x81C, 0x42660003,
	0x81C, 0x41680003,
	0x81C, 0x416A0003,
	0x81C, 0x416C0003,
	0x81C, 0x416E0003,
	0x81C, 0x41700003,
	0x81C, 0x41720003,
	0x81C, 0x41740003,
	0x81C, 0x41760003,
	0x81C, 0x41780003,
	0x81C, 0x417A0003,
	0x81C, 0x417C0003,
	0x81C, 0x417E0003,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000003,
	0x81C, 0xFD020003,
	0x81C, 0xFC040003,
	0x81C, 0xFB060003,
	0x81C, 0xFA080003,
	0x81C, 0xF90A0003,
	0x81C, 0xF80C0003,
	0x81C, 0xF70E0003,
	0x81C, 0xF6100003,
	0x81C, 0xF5120003,
	0x81C, 0xF4140003,
	0x81C, 0xF3160003,
	0x81C, 0xF2180003,
	0x81C, 0xF11A0003,
	0x81C, 0xF01C0003,
	0x81C, 0xEF1E0003,
	0x81C, 0xEE200003,
	0x81C, 0xED220003,
	0x81C, 0xEC240003,
	0x81C, 0xEB260003,
	0x81C, 0xEA280003,
	0x81C, 0xE92A0003,
	0x81C, 0xE82C0003,
	0x81C, 0xE72E0003,
	0x81C, 0xE6300003,
	0x81C, 0xE5320003,
	0x81C, 0xE4340003,
	0x81C, 0xE3360003,
	0x81C, 0xC6380003,
	0x81C, 0xC53A0003,
	0x81C, 0xC43C0003,
	0x81C, 0xC33E0003,
	0x81C, 0xC2400003,
	0x81C, 0xA9420003,
	0x81C, 0xA8440003,
	0x81C, 0xA7460003,
	0x81C, 0xA6480003,
	0x81C, 0xA54A0003,
	0x81C, 0xA44C0003,
	0x81C, 0xA34E0003,
	0x81C, 0x66500003,
	0x81C, 0x65520003,
	0x81C, 0x64540003,
	0x81C, 0x63560003,
	0x81C, 0x49580003,
	0x81C, 0x485A0003,
	0x81C, 0x475C0003,
	0x81C, 0x465E0003,
	0x81C, 0x45600003,
	0x81C, 0x44620003,
	0x81C, 0x43640003,
	0x81C, 0x42660003,
	0x81C, 0x41680003,
	0x81C, 0x416A0003,
	0x81C, 0x416C0003,
	0x81C, 0x416E0003,
	0x81C, 0x41700003,
	0x81C, 0x41720003,
	0x81C, 0x41740003,
	0x81C, 0x41760003,
	0x81C, 0x41780003,
	0x81C, 0x417A0003,
	0x81C, 0x417C0003,
	0x81C, 0x417E0003,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xDF000003,
	0x81C, 0xDF020003,
	0x81C, 0xDF040003,
	0x81C, 0xDE060003,
	0x81C, 0xDD080003,
	0x81C, 0xDC0A0003,
	0x81C, 0xDB0C0003,
	0x81C, 0xDA0E0003,
	0x81C, 0xD9100003,
	0x81C, 0xD8120003,
	0x81C, 0xD7140003,
	0x81C, 0xD6160003,
	0x81C, 0xD5180003,
	0x81C, 0xD41A0003,
	0x81C, 0xD31C0003,
	0x81C, 0xD21E0003,
	0x81C, 0xD1200003,
	0x81C, 0xD0220003,
	0x81C, 0xCF240003,
	0x81C, 0xCE260003,
	0x81C, 0xCD280003,
	0x81C, 0xCC2A0003,
	0x81C, 0xCB2C0003,
	0x81C, 0xCA2E0003,
	0x81C, 0xC9300003,
	0x81C, 0xC8320003,
	0x81C, 0xC7340003,
	0x81C, 0xC6360003,
	0x81C, 0xC5380003,
	0x81C, 0xA73A0003,
	0x81C, 0xA63C0003,
	0x81C, 0xA53E0003,
	0x81C, 0xA4400003,
	0x81C, 0xA3420003,
	0x81C, 0xA2440003,
	0x81C, 0x87460003,
	0x81C, 0x86480003,
	0x81C, 0x854A0003,
	0x81C, 0x844C0003,
	0x81C, 0x834E0003,
	0x81C, 0x82500003,
	0x81C, 0x81520003,
	0x81C, 0x64540003,
	0x81C, 0x63560003,
	0x81C, 0x62580003,
	0x81C, 0x615A0003,
	0x81C, 0x445C0003,
	0x81C, 0x435E0003,
	0x81C, 0x42600003,
	0x81C, 0x41620003,
	0x81C, 0x27640003,
	0x81C, 0x26660003,
	0x81C, 0x25680003,
	0x81C, 0x246A0003,
	0x81C, 0x236C0003,
	0x81C, 0x226E0003,
	0x81C, 0x21700003,
	0x81C, 0x21720003,
	0x81C, 0x21740003,
	0x81C, 0x21760003,
	0x81C, 0x21780003,
	0x81C, 0x217A0003,
	0x81C, 0x217C0003,
	0x81C, 0x217E0003,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFF000003,
	0x81C, 0xFE020003,
	0x81C, 0xFD040003,
	0x81C, 0xFC060003,
	0x81C, 0xFB080003,
	0x81C, 0xFA0A0003,
	0x81C, 0xF90C0003,
	0x81C, 0xF80E0003,
	0x81C, 0xF7100003,
	0x81C, 0xF6120003,
	0x81C, 0xF5140003,
	0x81C, 0xF4160003,
	0x81C, 0xF3180003,
	0x81C, 0xF21A0003,
	0x81C, 0xF11C0003,
	0x81C, 0xF01E0003,
	0x81C, 0xEF200003,
	0x81C, 0xEE220003,
	0x81C, 0xED240003,
	0x81C, 0xEC260003,
	0x81C, 0xEB280003,
	0x81C, 0xEA2A0003,
	0x81C, 0xE92C0003,
	0x81C, 0xE82E0003,
	0x81C, 0xE7300003,
	0x81C, 0xE6320003,
	0x81C, 0xE5340003,
	0x81C, 0xE4360003,
	0x81C, 0xE3380003,
	0x81C, 0xC53A0003,
	0x81C, 0xC43C0003,
	0x81C, 0xC33E0003,
	0x81C, 0xC2400003,
	0x81C, 0xC1420003,
	0x81C, 0xA8440003,
	0x81C, 0xA7460003,
	0x81C, 0xA6480003,
	0x81C, 0xA54A0003,
	0x81C, 0xA44C0003,
	0x81C, 0xA34E0003,
	0x81C, 0xA2500003,
	0x81C, 0x65520003,
	0x81C, 0x64540003,
	0x81C, 0x63560003,
	0x81C, 0x62580003,
	0x81C, 0x615A0003,
	0x81C, 0x475C0003,
	0x81C, 0x465E0003,
	0x81C, 0x45600003,
	0x81C, 0x44620003,
	0x81C, 0x43640003,
	0x81C, 0x42660003,
	0x81C, 0x41680003,
	0x81C, 0x416A0003,
	0x81C, 0x416C0003,
	0x81C, 0x416E0003,
	0x81C, 0x41700003,
	0x81C, 0x41720003,
	0x81C, 0x41740003,
	0x81C, 0x41760003,
	0x81C, 0x41780003,
	0x81C, 0x417A0003,
	0x81C, 0x417C0003,
	0x81C, 0x417E0003,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xDF000003,
	0x81C, 0xDF020003,
	0x81C, 0xDF040003,
	0x81C, 0xDE060003,
	0x81C, 0xDD080003,
	0x81C, 0xDC0A0003,
	0x81C, 0xDB0C0003,
	0x81C, 0xDA0E0003,
	0x81C, 0xD9100003,
	0x81C, 0xD8120003,
	0x81C, 0xD7140003,
	0x81C, 0xD6160003,
	0x81C, 0xD5180003,
	0x81C, 0xD41A0003,
	0x81C, 0xD31C0003,
	0x81C, 0xD21E0003,
	0x81C, 0xD1200003,
	0x81C, 0xD0220003,
	0x81C, 0xCF240003,
	0x81C, 0xCE260003,
	0x81C, 0xCD280003,
	0x81C, 0xCC2A0003,
	0x81C, 0xCB2C0003,
	0x81C, 0xCA2E0003,
	0x81C, 0xC9300003,
	0x81C, 0xC8320003,
	0x81C, 0xC7340003,
	0x81C, 0xC6360003,
	0x81C, 0xC5380003,
	0x81C, 0xA73A0003,
	0x81C, 0xA63C0003,
	0x81C, 0xA53E0003,
	0x81C, 0xA4400003,
	0x81C, 0xA3420003,
	0x81C, 0xA2440003,
	0x81C, 0x87460003,
	0x81C, 0x86480003,
	0x81C, 0x854A0003,
	0x81C, 0x844C0003,
	0x81C, 0x834E0003,
	0x81C, 0x82500003,
	0x81C, 0x81520003,
	0x81C, 0x64540003,
	0x81C, 0x63560003,
	0x81C, 0x62580003,
	0x81C, 0x615A0003,
	0x81C, 0x445C0003,
	0x81C, 0x435E0003,
	0x81C, 0x42600003,
	0x81C, 0x41620003,
	0x81C, 0x27640003,
	0x81C, 0x26660003,
	0x81C, 0x25680003,
	0x81C, 0x246A0003,
	0x81C, 0x236C0003,
	0x81C, 0x226E0003,
	0x81C, 0x21700003,
	0x81C, 0x21720003,
	0x81C, 0x21740003,
	0x81C, 0x21760003,
	0x81C, 0x21780003,
	0x81C, 0x217A0003,
	0x81C, 0x217C0003,
	0x81C, 0x217E0003,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000003,
	0x81C, 0xFE020003,
	0x81C, 0xFD040003,
	0x81C, 0xFC060003,
	0x81C, 0xFB080003,
	0x81C, 0xFA0A0003,
	0x81C, 0xF90C0003,
	0x81C, 0xF80E0003,
	0x81C, 0xF7100003,
	0x81C, 0xF6120003,
	0x81C, 0xF5140003,
	0x81C, 0xF4160003,
	0x81C, 0xF3180003,
	0x81C, 0xF21A0003,
	0x81C, 0xF11C0003,
	0x81C, 0xF01E0003,
	0x81C, 0xEF200003,
	0x81C, 0xEE220003,
	0x81C, 0xED240003,
	0x81C, 0x0F260003,
	0x81C, 0x0E280003,
	0x81C, 0x0D2A0003,
	0x81C, 0x0C2C0003,
	0x81C, 0x0B2E0003,
	0x81C, 0x0A300003,
	0x81C, 0x09320003,
	0x81C, 0x08340003,
	0x81C, 0x07360003,
	0x81C, 0x06380003,
	0x81C, 0x053A0003,
	0x81C, 0x043C0003,
	0x81C, 0x033E0003,
	0x81C, 0x23400003,
	0x81C, 0x22420003,
	0x81C, 0xA8440003,
	0x81C, 0xA7460003,
	0x81C, 0xA6480003,
	0x81C, 0xA54A0003,
	0x81C, 0xA44C0003,
	0x81C, 0x684E0003,
	0x81C, 0x67500003,
	0x81C, 0x66520003,
	0x81C, 0x65540003,
	0x81C, 0x64560003,
	0x81C, 0x63580003,
	0x81C, 0x625A0003,
	0x81C, 0x615C0003,
	0x81C, 0x475E0003,
	0x81C, 0x46600003,
	0x81C, 0x45620003,
	0x81C, 0x44640003,
	0x81C, 0x43660003,
	0x81C, 0x42680003,
	0x81C, 0x416A0003,
	0x81C, 0x416C0003,
	0x81C, 0x416E0003,
	0x81C, 0x41700003,
	0x81C, 0x41720003,
	0x81C, 0x41740003,
	0x81C, 0x41760003,
	0x81C, 0x41780003,
	0x81C, 0x417A0003,
	0x81C, 0x417C0003,
	0x81C, 0x417E0003,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000003,
	0x81C, 0xFE020003,
	0x81C, 0xFD040003,
	0x81C, 0xFC060003,
	0x81C, 0xFB080003,
	0x81C, 0xFA0A0003,
	0x81C, 0xF90C0003,
	0x81C, 0xF80E0003,
	0x81C, 0xF7100003,
	0x81C, 0xF6120003,
	0x81C, 0xF5140003,
	0x81C, 0xF4160003,
	0x81C, 0xF3180003,
	0x81C, 0xF21A0003,
	0x81C, 0xF11C0003,
	0x81C, 0xF01E0003,
	0x81C, 0xEF200003,
	0x81C, 0xEE220003,
	0x81C, 0xED240003,
	0x81C, 0xEC260003,
	0x81C, 0xEB280003,
	0x81C, 0xEA2A0003,
	0x81C, 0xE92C0003,
	0x81C, 0xE72E0003,
	0x81C, 0xE6300003,
	0x81C, 0xE5320003,
	0x81C, 0x08340003,
	0x81C, 0x07360003,
	0x81C, 0x06380003,
	0x81C, 0x053A0003,
	0x81C, 0x043C0003,
	0x81C, 0x033E0003,
	0x81C, 0x02400003,
	0x81C, 0xA9420003,
	0x81C, 0xA8440003,
	0x81C, 0xA7460003,
	0x81C, 0xA6480003,
	0x81C, 0xA54A0003,
	0x81C, 0x684C0003,
	0x81C, 0x674E0003,
	0x81C, 0x66500003,
	0x81C, 0x65520003,
	0x81C, 0x64540003,
	0x81C, 0x63560003,
	0x81C, 0x62580003,
	0x81C, 0x615A0003,
	0x81C, 0x475C0003,
	0x81C, 0x465E0003,
	0x81C, 0x45600003,
	0x81C, 0x44620003,
	0x81C, 0x43640003,
	0x81C, 0x42660003,
	0x81C, 0x41680003,
	0x81C, 0x416A0003,
	0x81C, 0x416C0003,
	0x81C, 0x416E0003,
	0x81C, 0x41700003,
	0x81C, 0x41720003,
	0x81C, 0x41740003,
	0x81C, 0x41760003,
	0x81C, 0x41780003,
	0x81C, 0x417A0003,
	0x81C, 0x417C0003,
	0x81C, 0x417E0003,
	0xA0000000,	0x00000000,
	0x81C, 0xFE000003,
	0x81C, 0xFD020003,
	0x81C, 0xFC040003,
	0x81C, 0xFB060003,
	0x81C, 0xFA080003,
	0x81C, 0xF90A0003,
	0x81C, 0xF80C0003,
	0x81C, 0xF70E0003,
	0x81C, 0xF6100003,
	0x81C, 0xF5120003,
	0x81C, 0xF4140003,
	0x81C, 0xF3160003,
	0x81C, 0xF2180003,
	0x81C, 0xF11A0003,
	0x81C, 0xF01C0003,
	0x81C, 0xEF1E0003,
	0x81C, 0xEE200003,
	0x81C, 0xED220003,
	0x81C, 0xCF240003,
	0x81C, 0xCE260003,
	0x81C, 0xCD280003,
	0x81C, 0xCC2A0003,
	0x81C, 0xCB2C0003,
	0x81C, 0xCA2E0003,
	0x81C, 0xC9300003,
	0x81C, 0xC8320003,
	0x81C, 0xC7340003,
	0x81C, 0xC6360003,
	0x81C, 0xC5380003,
	0x81C, 0xC43A0003,
	0x81C, 0xA63C0003,
	0x81C, 0xA53E0003,
	0x81C, 0xA4400003,
	0x81C, 0xA3420003,
	0x81C, 0xA2440003,
	0x81C, 0xA1460003,
	0x81C, 0x86480003,
	0x81C, 0x854A0003,
	0x81C, 0x844C0003,
	0x81C, 0x834E0003,
	0x81C, 0x66500003,
	0x81C, 0x65520003,
	0x81C, 0x64540003,
	0x81C, 0x63560003,
	0x81C, 0x62580003,
	0x81C, 0x615A0003,
	0x81C, 0x435C0003,
	0x81C, 0x425E0003,
	0x81C, 0x41600003,
	0x81C, 0x27620003,
	0x81C, 0x26640003,
	0x81C, 0x25660003,
	0x81C, 0x24680003,
	0x81C, 0x236A0003,
	0x81C, 0x226C0003,
	0x81C, 0x216E0003,
	0x81C, 0x21700003,
	0x81C, 0x21720003,
	0x81C, 0x21740003,
	0x81C, 0x21760003,
	0x81C, 0x21780003,
	0x81C, 0x217A0003,
	0x81C, 0x217C0003,
	0x81C, 0x217E0003,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF9000103,
	0x81C, 0xF8020103,
	0x81C, 0xF7040103,
	0x81C, 0xF6060103,
	0x81C, 0xF5080103,
	0x81C, 0xF40A0103,
	0x81C, 0xF30C0103,
	0x81C, 0xF20E0103,
	0x81C, 0xF1100103,
	0x81C, 0xF0120103,
	0x81C, 0xEF140103,
	0x81C, 0xEE160103,
	0x81C, 0xED180103,
	0x81C, 0xEC1A0103,
	0x81C, 0xEB1C0103,
	0x81C, 0xEA1E0103,
	0x81C, 0xE9200103,
	0x81C, 0xE8220103,
	0x81C, 0xE7240103,
	0x81C, 0xE6260103,
	0x81C, 0xE5280103,
	0x81C, 0xE42A0103,
	0x81C, 0xE32C0103,
	0x81C, 0xC32E0103,
	0x81C, 0xC2300103,
	0x81C, 0xC1320103,
	0x81C, 0xA5340103,
	0x81C, 0xA4360103,
	0x81C, 0xA3380103,
	0x81C, 0xA23A0103,
	0x81C, 0xA13C0103,
	0x81C, 0x843E0103,
	0x81C, 0x83400103,
	0x81C, 0x82420103,
	0x81C, 0x81440103,
	0x81C, 0x64460103,
	0x81C, 0x63480103,
	0x81C, 0x624A0103,
	0x81C, 0x614C0103,
	0x81C, 0x444E0103,
	0x81C, 0x43500103,
	0x81C, 0x42520103,
	0x81C, 0x41540103,
	0x81C, 0x25560103,
	0x81C, 0x24580103,
	0x81C, 0x235A0103,
	0x81C, 0x065C0103,
	0x81C, 0x055E0103,
	0x81C, 0x04600103,
	0x81C, 0x03620103,
	0x81C, 0x02640103,
	0x81C, 0x01660103,
	0x81C, 0x01680103,
	0x81C, 0x016A0103,
	0x81C, 0x016C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF8000103,
	0x81C, 0xF7020103,
	0x81C, 0xF6040103,
	0x81C, 0xF5060103,
	0x81C, 0xF4080103,
	0x81C, 0xF30A0103,
	0x81C, 0xF20C0103,
	0x81C, 0xF10E0103,
	0x81C, 0xF0100103,
	0x81C, 0xEF120103,
	0x81C, 0xEE140103,
	0x81C, 0xED160103,
	0x81C, 0xEC180103,
	0x81C, 0xEB1A0103,
	0x81C, 0xEA1C0103,
	0x81C, 0xE91E0103,
	0x81C, 0xE8200103,
	0x81C, 0xE7220103,
	0x81C, 0xE6240103,
	0x81C, 0xE5260103,
	0x81C, 0xE4280103,
	0x81C, 0xE32A0103,
	0x81C, 0xE22C0103,
	0x81C, 0xE12E0103,
	0x81C, 0xA5300103,
	0x81C, 0xA4320103,
	0x81C, 0xA3340103,
	0x81C, 0xA2360103,
	0x81C, 0xA1380103,
	0x81C, 0x843A0103,
	0x81C, 0x833C0103,
	0x81C, 0x823E0103,
	0x81C, 0x81400103,
	0x81C, 0x64420103,
	0x81C, 0x63440103,
	0x81C, 0x62460103,
	0x81C, 0x61480103,
	0x81C, 0x454A0103,
	0x81C, 0x444C0103,
	0x81C, 0x434E0103,
	0x81C, 0x42500103,
	0x81C, 0x25520103,
	0x81C, 0x24540103,
	0x81C, 0x23560103,
	0x81C, 0x06580103,
	0x81C, 0x055A0103,
	0x81C, 0x045C0103,
	0x81C, 0x035E0103,
	0x81C, 0x02600103,
	0x81C, 0x01620103,
	0x81C, 0x01640103,
	0x81C, 0x01660103,
	0x81C, 0x01680103,
	0x81C, 0x016A0103,
	0x81C, 0x016C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFC000103,
	0x81C, 0xFB020103,
	0x81C, 0xFA040103,
	0x81C, 0xF9060103,
	0x81C, 0xF8080103,
	0x81C, 0xF70A0103,
	0x81C, 0xF60C0103,
	0x81C, 0xF50E0103,
	0x81C, 0xF4100103,
	0x81C, 0xF3120103,
	0x81C, 0xF2140103,
	0x81C, 0xF1160103,
	0x81C, 0xF0180103,
	0x81C, 0xEF1A0103,
	0x81C, 0xEE1C0103,
	0x81C, 0xED1E0103,
	0x81C, 0xEC200103,
	0x81C, 0xEB220103,
	0x81C, 0xEA240103,
	0x81C, 0xE9260103,
	0x81C, 0xE8280103,
	0x81C, 0xE72A0103,
	0x81C, 0xE62C0103,
	0x81C, 0xE52E0103,
	0x81C, 0xE4300103,
	0x81C, 0xE3320103,
	0x81C, 0xE2340103,
	0x81C, 0xE1360103,
	0x81C, 0x87380103,
	0x81C, 0x863A0103,
	0x81C, 0x853C0103,
	0x81C, 0x843E0103,
	0x81C, 0x83400103,
	0x81C, 0x82420103,
	0x81C, 0x81440103,
	0x81C, 0x64460103,
	0x81C, 0x63480103,
	0x81C, 0x624A0103,
	0x81C, 0x464C0103,
	0x81C, 0x454E0103,
	0x81C, 0x44500103,
	0x81C, 0x43520103,
	0x81C, 0x26540103,
	0x81C, 0x25560103,
	0x81C, 0x24580103,
	0x81C, 0x075A0103,
	0x81C, 0x065C0103,
	0x81C, 0x055E0103,
	0x81C, 0x04600103,
	0x81C, 0x03620103,
	0x81C, 0x02640103,
	0x81C, 0x01660103,
	0x81C, 0x01680103,
	0x81C, 0x016A0103,
	0x81C, 0x016C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF9000103,
	0x81C, 0xF8020103,
	0x81C, 0xF7040103,
	0x81C, 0xF6060103,
	0x81C, 0xF5080103,
	0x81C, 0xF40A0103,
	0x81C, 0xF30C0103,
	0x81C, 0xF20E0103,
	0x81C, 0xF1100103,
	0x81C, 0xF0120103,
	0x81C, 0xEF140103,
	0x81C, 0xEE160103,
	0x81C, 0xED180103,
	0x81C, 0xEC1A0103,
	0x81C, 0xEB1C0103,
	0x81C, 0xEA1E0103,
	0x81C, 0xE9200103,
	0x81C, 0xE8220103,
	0x81C, 0xE7240103,
	0x81C, 0xE6260103,
	0x81C, 0xE5280103,
	0x81C, 0xE42A0103,
	0x81C, 0xE32C0103,
	0x81C, 0xE22E0103,
	0x81C, 0xA6300103,
	0x81C, 0xA5320103,
	0x81C, 0xA4340103,
	0x81C, 0xA3360103,
	0x81C, 0xA2380103,
	0x81C, 0xA13A0103,
	0x81C, 0x843C0103,
	0x81C, 0x833E0103,
	0x81C, 0x82400103,
	0x81C, 0x81420103,
	0x81C, 0x64440103,
	0x81C, 0x63460103,
	0x81C, 0x62480103,
	0x81C, 0x614A0103,
	0x81C, 0x444C0103,
	0x81C, 0x434E0103,
	0x81C, 0x42500103,
	0x81C, 0x41520103,
	0x81C, 0x25540103,
	0x81C, 0x24560103,
	0x81C, 0x23580103,
	0x81C, 0x225A0103,
	0x81C, 0x055C0103,
	0x81C, 0x045E0103,
	0x81C, 0x03600103,
	0x81C, 0x02620103,
	0x81C, 0x01640103,
	0x81C, 0x01660103,
	0x81C, 0x01680103,
	0x81C, 0x016A0103,
	0x81C, 0x016C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFD000103,
	0x81C, 0xFC020103,
	0x81C, 0xFB040103,
	0x81C, 0xFA060103,
	0x81C, 0xF9080103,
	0x81C, 0xF80A0103,
	0x81C, 0xF70C0103,
	0x81C, 0xF60E0103,
	0x81C, 0xF5100103,
	0x81C, 0xF4120103,
	0x81C, 0xF3140103,
	0x81C, 0xF2160103,
	0x81C, 0xF1180103,
	0x81C, 0xF01A0103,
	0x81C, 0xEF1C0103,
	0x81C, 0xEE1E0103,
	0x81C, 0xED200103,
	0x81C, 0xEC220103,
	0x81C, 0xEB240103,
	0x81C, 0xEA260103,
	0x81C, 0xE9280103,
	0x81C, 0xE82A0103,
	0x81C, 0xE72C0103,
	0x81C, 0xE62E0103,
	0x81C, 0xE5300103,
	0x81C, 0xE4320103,
	0x81C, 0xE3340103,
	0x81C, 0xE2360103,
	0x81C, 0xE1380103,
	0x81C, 0xA33A0103,
	0x81C, 0xA23C0103,
	0x81C, 0xA13E0103,
	0x81C, 0x84400103,
	0x81C, 0x83420103,
	0x81C, 0x82440103,
	0x81C, 0x81460103,
	0x81C, 0x64480103,
	0x81C, 0x634A0103,
	0x81C, 0x624C0103,
	0x81C, 0x614E0103,
	0x81C, 0x45500103,
	0x81C, 0x44520103,
	0x81C, 0x43540103,
	0x81C, 0x42560103,
	0x81C, 0x25580103,
	0x81C, 0x245A0103,
	0x81C, 0x235C0103,
	0x81C, 0x065E0103,
	0x81C, 0x05600103,
	0x81C, 0x04620103,
	0x81C, 0x03640103,
	0x81C, 0x02660103,
	0x81C, 0x01680103,
	0x81C, 0x016A0103,
	0x81C, 0x016C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFA000103,
	0x81C, 0xF9020103,
	0x81C, 0xF8040103,
	0x81C, 0xF7060103,
	0x81C, 0xF6080103,
	0x81C, 0xF50A0103,
	0x81C, 0xF40C0103,
	0x81C, 0xF30E0103,
	0x81C, 0xF2100103,
	0x81C, 0xF1120103,
	0x81C, 0xF0140103,
	0x81C, 0xEF160103,
	0x81C, 0xEE180103,
	0x81C, 0xED1A0103,
	0x81C, 0xEC1C0103,
	0x81C, 0xEB1E0103,
	0x81C, 0xEA200103,
	0x81C, 0xE9220103,
	0x81C, 0xE8240103,
	0x81C, 0xE7260103,
	0x81C, 0xE6280103,
	0x81C, 0xE52A0103,
	0x81C, 0xE42C0103,
	0x81C, 0xE32E0103,
	0x81C, 0xE2300103,
	0x81C, 0xE1320103,
	0x81C, 0xA5340103,
	0x81C, 0xA4360103,
	0x81C, 0xA3380103,
	0x81C, 0xA23A0103,
	0x81C, 0xA13C0103,
	0x81C, 0x843E0103,
	0x81C, 0x83400103,
	0x81C, 0x82420103,
	0x81C, 0x81440103,
	0x81C, 0x64460103,
	0x81C, 0x63480103,
	0x81C, 0x624A0103,
	0x81C, 0x614C0103,
	0x81C, 0x454E0103,
	0x81C, 0x44500103,
	0x81C, 0x43520103,
	0x81C, 0x42540103,
	0x81C, 0x41560103,
	0x81C, 0x24580103,
	0x81C, 0x235A0103,
	0x81C, 0x225C0103,
	0x81C, 0x055E0103,
	0x81C, 0x04600103,
	0x81C, 0x03620103,
	0x81C, 0x02640103,
	0x81C, 0x01660103,
	0x81C, 0x01680103,
	0x81C, 0x016A0103,
	0x81C, 0x016C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFF000103,
	0x81C, 0xFF020103,
	0x81C, 0xFE040103,
	0x81C, 0xFD060103,
	0x81C, 0xFC080103,
	0x81C, 0xFB0A0103,
	0x81C, 0xFA0C0103,
	0x81C, 0xF90E0103,
	0x81C, 0xF8100103,
	0x81C, 0xF7120103,
	0x81C, 0xF6140103,
	0x81C, 0xF5160103,
	0x81C, 0xF4180103,
	0x81C, 0xF31A0103,
	0x81C, 0xF21C0103,
	0x81C, 0xF11E0103,
	0x81C, 0xF0200103,
	0x81C, 0xEF220103,
	0x81C, 0xEE240103,
	0x81C, 0xED260103,
	0x81C, 0xEC280103,
	0x81C, 0xEB2A0103,
	0x81C, 0xEA2C0103,
	0x81C, 0xE92E0103,
	0x81C, 0xE8300103,
	0x81C, 0xE7320103,
	0x81C, 0xE6340103,
	0x81C, 0xE5360103,
	0x81C, 0xE4380103,
	0x81C, 0xE33A0103,
	0x81C, 0xA53C0103,
	0x81C, 0xA43E0103,
	0x81C, 0xA3400103,
	0x81C, 0xA2420103,
	0x81C, 0xA1440103,
	0x81C, 0x85460103,
	0x81C, 0x84480103,
	0x81C, 0x834A0103,
	0x81C, 0x824C0103,
	0x81C, 0x814E0103,
	0x81C, 0x64500103,
	0x81C, 0x63520103,
	0x81C, 0x62540103,
	0x81C, 0x44560103,
	0x81C, 0x43580103,
	0x81C, 0x425A0103,
	0x81C, 0x265C0103,
	0x81C, 0x255E0103,
	0x81C, 0x24600103,
	0x81C, 0x07620103,
	0x81C, 0x06640103,
	0x81C, 0x05660103,
	0x81C, 0x04680103,
	0x81C, 0x036A0103,
	0x81C, 0x026C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF8000103,
	0x81C, 0xF7020103,
	0x81C, 0xF6040103,
	0x81C, 0xF5060103,
	0x81C, 0xF4080103,
	0x81C, 0xF30A0103,
	0x81C, 0xF20C0103,
	0x81C, 0xF10E0103,
	0x81C, 0xF0100103,
	0x81C, 0xEF120103,
	0x81C, 0xEE140103,
	0x81C, 0xED160103,
	0x81C, 0xEC180103,
	0x81C, 0xEB1A0103,
	0x81C, 0xEA1C0103,
	0x81C, 0xE91E0103,
	0x81C, 0xE8200103,
	0x81C, 0xE7220103,
	0x81C, 0xE6240103,
	0x81C, 0xE5260103,
	0x81C, 0xE4280103,
	0x81C, 0xE32A0103,
	0x81C, 0xE22C0103,
	0x81C, 0xE12E0103,
	0x81C, 0xA4300103,
	0x81C, 0xA3320103,
	0x81C, 0xA2340103,
	0x81C, 0xA1360103,
	0x81C, 0x85380103,
	0x81C, 0x843A0103,
	0x81C, 0x833C0103,
	0x81C, 0x823E0103,
	0x81C, 0x65400103,
	0x81C, 0x64420103,
	0x81C, 0x63440103,
	0x81C, 0x62460103,
	0x81C, 0x45480103,
	0x81C, 0x444A0103,
	0x81C, 0x434C0103,
	0x81C, 0x264E0103,
	0x81C, 0x25500103,
	0x81C, 0x24520103,
	0x81C, 0x08540103,
	0x81C, 0x07560103,
	0x81C, 0x06580103,
	0x81C, 0x055A0103,
	0x81C, 0x045C0103,
	0x81C, 0x035E0103,
	0x81C, 0x02600103,
	0x81C, 0x01620103,
	0x81C, 0x01640103,
	0x81C, 0x01660103,
	0x81C, 0x01680103,
	0x81C, 0x016A0103,
	0x81C, 0x016C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFF000103,
	0x81C, 0xFF020103,
	0x81C, 0xFE040103,
	0x81C, 0xFD060103,
	0x81C, 0xFC080103,
	0x81C, 0xFB0A0103,
	0x81C, 0xFA0C0103,
	0x81C, 0xF90E0103,
	0x81C, 0xF8100103,
	0x81C, 0xF7120103,
	0x81C, 0xF6140103,
	0x81C, 0xF5160103,
	0x81C, 0xF4180103,
	0x81C, 0xF31A0103,
	0x81C, 0xF21C0103,
	0x81C, 0xF11E0103,
	0x81C, 0xF0200103,
	0x81C, 0xEF220103,
	0x81C, 0xEE240103,
	0x81C, 0xED260103,
	0x81C, 0xEC280103,
	0x81C, 0xEB2A0103,
	0x81C, 0xEA2C0103,
	0x81C, 0xE92E0103,
	0x81C, 0xE8300103,
	0x81C, 0xE7320103,
	0x81C, 0xE6340103,
	0x81C, 0xE5360103,
	0x81C, 0xE4380103,
	0x81C, 0xE33A0103,
	0x81C, 0xA53C0103,
	0x81C, 0xA43E0103,
	0x81C, 0xA3400103,
	0x81C, 0xA2420103,
	0x81C, 0xA1440103,
	0x81C, 0x85460103,
	0x81C, 0x84480103,
	0x81C, 0x834A0103,
	0x81C, 0x824C0103,
	0x81C, 0x814E0103,
	0x81C, 0x64500103,
	0x81C, 0x63520103,
	0x81C, 0x62540103,
	0x81C, 0x44560103,
	0x81C, 0x43580103,
	0x81C, 0x425A0103,
	0x81C, 0x265C0103,
	0x81C, 0x255E0103,
	0x81C, 0x24600103,
	0x81C, 0x07620103,
	0x81C, 0x06640103,
	0x81C, 0x05660103,
	0x81C, 0x04680103,
	0x81C, 0x036A0103,
	0x81C, 0x026C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF9000103,
	0x81C, 0xF8020103,
	0x81C, 0xF7040103,
	0x81C, 0xF6060103,
	0x81C, 0xF5080103,
	0x81C, 0xF40A0103,
	0x81C, 0xF30C0103,
	0x81C, 0xF20E0103,
	0x81C, 0xF1100103,
	0x81C, 0xF0120103,
	0x81C, 0xEF140103,
	0x81C, 0xEE160103,
	0x81C, 0xED180103,
	0x81C, 0xEC1A0103,
	0x81C, 0xEB1C0103,
	0x81C, 0xEA1E0103,
	0x81C, 0xE9200103,
	0x81C, 0xE8220103,
	0x81C, 0xE7240103,
	0x81C, 0xE6260103,
	0x81C, 0xE5280103,
	0x81C, 0xE42A0103,
	0x81C, 0xE32C0103,
	0x81C, 0xE22E0103,
	0x81C, 0xA6300103,
	0x81C, 0xA5320103,
	0x81C, 0xA4340103,
	0x81C, 0xA3360103,
	0x81C, 0xA2380103,
	0x81C, 0xA13A0103,
	0x81C, 0x843C0103,
	0x81C, 0x833E0103,
	0x81C, 0x82400103,
	0x81C, 0x81420103,
	0x81C, 0x64440103,
	0x81C, 0x63460103,
	0x81C, 0x62480103,
	0x81C, 0x614A0103,
	0x81C, 0x444C0103,
	0x81C, 0x434E0103,
	0x81C, 0x42500103,
	0x81C, 0x41520103,
	0x81C, 0x25540103,
	0x81C, 0x24560103,
	0x81C, 0x23580103,
	0x81C, 0x225A0103,
	0x81C, 0x055C0103,
	0x81C, 0x045E0103,
	0x81C, 0x03600103,
	0x81C, 0x02620103,
	0x81C, 0x01640103,
	0x81C, 0x01660103,
	0x81C, 0x01680103,
	0x81C, 0x016A0103,
	0x81C, 0x016C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFA000103,
	0x81C, 0xF9020103,
	0x81C, 0xF8040103,
	0x81C, 0xF7060103,
	0x81C, 0xF6080103,
	0x81C, 0xF50A0103,
	0x81C, 0xF40C0103,
	0x81C, 0xF30E0103,
	0x81C, 0xF2100103,
	0x81C, 0xF1120103,
	0x81C, 0xF0140103,
	0x81C, 0xEF160103,
	0x81C, 0xEE180103,
	0x81C, 0xED1A0103,
	0x81C, 0xCC1C0103,
	0x81C, 0xCB1E0103,
	0x81C, 0xCA200103,
	0x81C, 0xE9220103,
	0x81C, 0xE8240103,
	0x81C, 0xE7260103,
	0x81C, 0xE6280103,
	0x81C, 0xE42A0103,
	0x81C, 0xE32C0103,
	0x81C, 0xE22E0103,
	0x81C, 0xA7300103,
	0x81C, 0xA6320103,
	0x81C, 0xA5340103,
	0x81C, 0xA4360103,
	0x81C, 0xA3380103,
	0x81C, 0xA23A0103,
	0x81C, 0xA13C0103,
	0x81C, 0x843E0103,
	0x81C, 0x83400103,
	0x81C, 0x82420103,
	0x81C, 0x65440103,
	0x81C, 0x64460103,
	0x81C, 0x63480103,
	0x81C, 0x624A0103,
	0x81C, 0x614C0103,
	0x81C, 0x444E0103,
	0x81C, 0x43500103,
	0x81C, 0x42520103,
	0x81C, 0x41540103,
	0x81C, 0x24560103,
	0x81C, 0x23580103,
	0x81C, 0x055A0103,
	0x81C, 0x045C0103,
	0x81C, 0x035E0103,
	0x81C, 0x02600103,
	0x81C, 0x01620103,
	0x81C, 0x01640103,
	0x81C, 0x01660103,
	0x81C, 0x01680103,
	0x81C, 0x016A0103,
	0x81C, 0x016C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0xA0000000,	0x00000000,
	0x81C, 0xFF000103,
	0x81C, 0xFE020103,
	0x81C, 0xFD040103,
	0x81C, 0xFC060103,
	0x81C, 0xFB080103,
	0x81C, 0xFA0A0103,
	0x81C, 0xF90C0103,
	0x81C, 0xF80E0103,
	0x81C, 0xF7100103,
	0x81C, 0xF6120103,
	0x81C, 0xF5140103,
	0x81C, 0xF4160103,
	0x81C, 0xF3180103,
	0x81C, 0xF21A0103,
	0x81C, 0xF11C0103,
	0x81C, 0xF01E0103,
	0x81C, 0xEF200103,
	0x81C, 0xEE220103,
	0x81C, 0xED240103,
	0x81C, 0xEC260103,
	0x81C, 0xEB280103,
	0x81C, 0xEA2A0103,
	0x81C, 0xE92C0103,
	0x81C, 0xE82E0103,
	0x81C, 0xE7300103,
	0x81C, 0xE6320103,
	0x81C, 0xE5340103,
	0x81C, 0xE4360103,
	0x81C, 0xE3380103,
	0x81C, 0xE23A0103,
	0x81C, 0xE13C0103,
	0x81C, 0xA43E0103,
	0x81C, 0xA3400103,
	0x81C, 0xA2420103,
	0x81C, 0xA1440103,
	0x81C, 0x86460103,
	0x81C, 0x85480103,
	0x81C, 0x844A0103,
	0x81C, 0x834C0103,
	0x81C, 0x824E0103,
	0x81C, 0x81500103,
	0x81C, 0x64520103,
	0x81C, 0x63540103,
	0x81C, 0x62560103,
	0x81C, 0x61580103,
	0x81C, 0x435A0103,
	0x81C, 0x425C0103,
	0x81C, 0x415E0103,
	0x81C, 0x25600103,
	0x81C, 0x24620103,
	0x81C, 0x06640103,
	0x81C, 0x05660103,
	0x81C, 0x04680103,
	0x81C, 0x036A0103,
	0x81C, 0x026C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFA000203,
	0x81C, 0xF9020203,
	0x81C, 0xF8040203,
	0x81C, 0xF7060203,
	0x81C, 0xF6080203,
	0x81C, 0xF50A0203,
	0x81C, 0xF40C0203,
	0x81C, 0xF30E0203,
	0x81C, 0xF2100203,
	0x81C, 0xF1120203,
	0x81C, 0xF0140203,
	0x81C, 0xEF160203,
	0x81C, 0xEE180203,
	0x81C, 0xED1A0203,
	0x81C, 0xEC1C0203,
	0x81C, 0xEB1E0203,
	0x81C, 0xEA200203,
	0x81C, 0xE9220203,
	0x81C, 0xE8240203,
	0x81C, 0xE7260203,
	0x81C, 0xE6280203,
	0x81C, 0xE52A0203,
	0x81C, 0xE42C0203,
	0x81C, 0xE32E0203,
	0x81C, 0xE2300203,
	0x81C, 0xE1320203,
	0x81C, 0xA5340203,
	0x81C, 0xA4360203,
	0x81C, 0xA3380203,
	0x81C, 0xA23A0203,
	0x81C, 0xA13C0203,
	0x81C, 0x843E0203,
	0x81C, 0x83400203,
	0x81C, 0x82420203,
	0x81C, 0x81440203,
	0x81C, 0x63460203,
	0x81C, 0x62480203,
	0x81C, 0x614A0203,
	0x81C, 0x464C0203,
	0x81C, 0x454E0203,
	0x81C, 0x44500203,
	0x81C, 0x43520203,
	0x81C, 0x42540203,
	0x81C, 0x41560203,
	0x81C, 0x24580203,
	0x81C, 0x235A0203,
	0x81C, 0x065C0203,
	0x81C, 0x055E0203,
	0x81C, 0x04600203,
	0x81C, 0x03620203,
	0x81C, 0x02640203,
	0x81C, 0x01660203,
	0x81C, 0x01680203,
	0x81C, 0x016A0203,
	0x81C, 0x016C0203,
	0x81C, 0x016E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF8000203,
	0x81C, 0xF7020203,
	0x81C, 0xF6040203,
	0x81C, 0xF5060203,
	0x81C, 0xF4080203,
	0x81C, 0xF30A0203,
	0x81C, 0xF20C0203,
	0x81C, 0xF10E0203,
	0x81C, 0xF0100203,
	0x81C, 0xEF120203,
	0x81C, 0xEE140203,
	0x81C, 0xED160203,
	0x81C, 0xEC180203,
	0x81C, 0xEB1A0203,
	0x81C, 0xEA1C0203,
	0x81C, 0xE91E0203,
	0x81C, 0xE8200203,
	0x81C, 0xE7220203,
	0x81C, 0xE6240203,
	0x81C, 0xE5260203,
	0x81C, 0xE4280203,
	0x81C, 0xE32A0203,
	0x81C, 0xE22C0203,
	0x81C, 0xE12E0203,
	0x81C, 0xA6300203,
	0x81C, 0xA5320203,
	0x81C, 0xA4340203,
	0x81C, 0xA3360203,
	0x81C, 0xA2380203,
	0x81C, 0x853A0203,
	0x81C, 0x843C0203,
	0x81C, 0x833E0203,
	0x81C, 0x82400203,
	0x81C, 0x81420203,
	0x81C, 0x64440203,
	0x81C, 0x63460203,
	0x81C, 0x62480203,
	0x81C, 0x614A0203,
	0x81C, 0x444C0203,
	0x81C, 0x434E0203,
	0x81C, 0x42500203,
	0x81C, 0x25520203,
	0x81C, 0x24540203,
	0x81C, 0x23560203,
	0x81C, 0x06580203,
	0x81C, 0x055A0203,
	0x81C, 0x045C0203,
	0x81C, 0x035E0203,
	0x81C, 0x02600203,
	0x81C, 0x01620203,
	0x81C, 0x01640203,
	0x81C, 0x01660203,
	0x81C, 0x01680203,
	0x81C, 0x016A0203,
	0x81C, 0x016C0203,
	0x81C, 0x016E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFC000203,
	0x81C, 0xFB020203,
	0x81C, 0xFA040203,
	0x81C, 0xF9060203,
	0x81C, 0xF8080203,
	0x81C, 0xF70A0203,
	0x81C, 0xF60C0203,
	0x81C, 0xF50E0203,
	0x81C, 0xF4100203,
	0x81C, 0xF3120203,
	0x81C, 0xF2140203,
	0x81C, 0xF1160203,
	0x81C, 0xF0180203,
	0x81C, 0xEF1A0203,
	0x81C, 0xEE1C0203,
	0x81C, 0xED1E0203,
	0x81C, 0xEC200203,
	0x81C, 0xEB220203,
	0x81C, 0xEA240203,
	0x81C, 0xE9260203,
	0x81C, 0xE8280203,
	0x81C, 0xE72A0203,
	0x81C, 0xE62C0203,
	0x81C, 0xE52E0203,
	0x81C, 0xE4300203,
	0x81C, 0xE3320203,
	0x81C, 0xE2340203,
	0x81C, 0xE1360203,
	0x81C, 0x87380203,
	0x81C, 0x863A0203,
	0x81C, 0x853C0203,
	0x81C, 0x843E0203,
	0x81C, 0x83400203,
	0x81C, 0x82420203,
	0x81C, 0x81440203,
	0x81C, 0x64460203,
	0x81C, 0x63480203,
	0x81C, 0x624A0203,
	0x81C, 0x474C0203,
	0x81C, 0x464E0203,
	0x81C, 0x45500203,
	0x81C, 0x44520203,
	0x81C, 0x43540203,
	0x81C, 0x42560203,
	0x81C, 0x24580203,
	0x81C, 0x235A0203,
	0x81C, 0x075C0203,
	0x81C, 0x065E0203,
	0x81C, 0x05600203,
	0x81C, 0x04620203,
	0x81C, 0x03640203,
	0x81C, 0x02660203,
	0x81C, 0x01680203,
	0x81C, 0x016A0203,
	0x81C, 0x016C0203,
	0x81C, 0x016E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF8000203,
	0x81C, 0xF7020203,
	0x81C, 0xF6040203,
	0x81C, 0xF5060203,
	0x81C, 0xF4080203,
	0x81C, 0xF30A0203,
	0x81C, 0xF20C0203,
	0x81C, 0xF10E0203,
	0x81C, 0xF0100203,
	0x81C, 0xEF120203,
	0x81C, 0xEE140203,
	0x81C, 0xED160203,
	0x81C, 0xEC180203,
	0x81C, 0xEB1A0203,
	0x81C, 0xEA1C0203,
	0x81C, 0xE91E0203,
	0x81C, 0xE8200203,
	0x81C, 0xE7220203,
	0x81C, 0xE6240203,
	0x81C, 0xE5260203,
	0x81C, 0xE4280203,
	0x81C, 0xE32A0203,
	0x81C, 0xE22C0203,
	0x81C, 0xE12E0203,
	0x81C, 0xA6300203,
	0x81C, 0xA5320203,
	0x81C, 0xA4340203,
	0x81C, 0xA3360203,
	0x81C, 0xA2380203,
	0x81C, 0xA13A0203,
	0x81C, 0x843C0203,
	0x81C, 0x833E0203,
	0x81C, 0x82400203,
	0x81C, 0x81420203,
	0x81C, 0x64440203,
	0x81C, 0x63460203,
	0x81C, 0x62480203,
	0x81C, 0x614A0203,
	0x81C, 0x444C0203,
	0x81C, 0x434E0203,
	0x81C, 0x42500203,
	0x81C, 0x41520203,
	0x81C, 0x25540203,
	0x81C, 0x24560203,
	0x81C, 0x23580203,
	0x81C, 0x065A0203,
	0x81C, 0x055C0203,
	0x81C, 0x045E0203,
	0x81C, 0x03600203,
	0x81C, 0x02620203,
	0x81C, 0x01640203,
	0x81C, 0x01660203,
	0x81C, 0x01680203,
	0x81C, 0x016A0203,
	0x81C, 0x016C0203,
	0x81C, 0x016E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFB000203,
	0x81C, 0xFA020203,
	0x81C, 0xF9040203,
	0x81C, 0xF8060203,
	0x81C, 0xF7080203,
	0x81C, 0xF60A0203,
	0x81C, 0xF50C0203,
	0x81C, 0xF40E0203,
	0x81C, 0xF3100203,
	0x81C, 0xF2120203,
	0x81C, 0xF1140203,
	0x81C, 0xF0160203,
	0x81C, 0xEF180203,
	0x81C, 0xEE1A0203,
	0x81C, 0xED1C0203,
	0x81C, 0xEC1E0203,
	0x81C, 0xEB200203,
	0x81C, 0xEA220203,
	0x81C, 0xE9240203,
	0x81C, 0xE8260203,
	0x81C, 0xE7280203,
	0x81C, 0xE62A0203,
	0x81C, 0xE52C0203,
	0x81C, 0xE42E0203,
	0x81C, 0xE3300203,
	0x81C, 0xE2320203,
	0x81C, 0xE1340203,
	0x81C, 0xA5360203,
	0x81C, 0xA4380203,
	0x81C, 0xA33A0203,
	0x81C, 0xA23C0203,
	0x81C, 0x843E0203,
	0x81C, 0x83400203,
	0x81C, 0x82420203,
	0x81C, 0x81440203,
	0x81C, 0x64460203,
	0x81C, 0x63480203,
	0x81C, 0x624A0203,
	0x81C, 0x614C0203,
	0x81C, 0x474E0203,
	0x81C, 0x46500203,
	0x81C, 0x45520203,
	0x81C, 0x44540203,
	0x81C, 0x43560203,
	0x81C, 0x25580203,
	0x81C, 0x245A0203,
	0x81C, 0x235C0203,
	0x81C, 0x075E0203,
	0x81C, 0x06600203,
	0x81C, 0x05620203,
	0x81C, 0x04640203,
	0x81C, 0x03660203,
	0x81C, 0x02680203,
	0x81C, 0x016A0203,
	0x81C, 0x016C0203,
	0x81C, 0x016E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFC000203,
	0x81C, 0xFB020203,
	0x81C, 0xFA040203,
	0x81C, 0xF9060203,
	0x81C, 0xF8080203,
	0x81C, 0xF70A0203,
	0x81C, 0xF60C0203,
	0x81C, 0xF50E0203,
	0x81C, 0xF4100203,
	0x81C, 0xF3120203,
	0x81C, 0xF2140203,
	0x81C, 0xF1160203,
	0x81C, 0xF0180203,
	0x81C, 0xEF1A0203,
	0x81C, 0xEE1C0203,
	0x81C, 0xED1E0203,
	0x81C, 0xEC200203,
	0x81C, 0xEB220203,
	0x81C, 0xEA240203,
	0x81C, 0xE9260203,
	0x81C, 0xE8280203,
	0x81C, 0xE72A0203,
	0x81C, 0xE62C0203,
	0x81C, 0xE52E0203,
	0x81C, 0xE4300203,
	0x81C, 0xE3320203,
	0x81C, 0xE2340203,
	0x81C, 0xE1360203,
	0x81C, 0xA5380203,
	0x81C, 0xA43A0203,
	0x81C, 0xA33C0203,
	0x81C, 0x853E0203,
	0x81C, 0x84400203,
	0x81C, 0x83420203,
	0x81C, 0x82440203,
	0x81C, 0x81460203,
	0x81C, 0x64480203,
	0x81C, 0x634A0203,
	0x81C, 0x624C0203,
	0x81C, 0x614E0203,
	0x81C, 0x46500203,
	0x81C, 0x45520203,
	0x81C, 0x44540203,
	0x81C, 0x43560203,
	0x81C, 0x25580203,
	0x81C, 0x245A0203,
	0x81C, 0x235C0203,
	0x81C, 0x075E0203,
	0x81C, 0x06600203,
	0x81C, 0x05620203,
	0x81C, 0x04640203,
	0x81C, 0x03660203,
	0x81C, 0x02680203,
	0x81C, 0x016A0203,
	0x81C, 0x016C0203,
	0x81C, 0x016E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFF000203,
	0x81C, 0xFF020203,
	0x81C, 0xFE040203,
	0x81C, 0xFD060203,
	0x81C, 0xFC080203,
	0x81C, 0xFB0A0203,
	0x81C, 0xFA0C0203,
	0x81C, 0xF90E0203,
	0x81C, 0xF8100203,
	0x81C, 0xF7120203,
	0x81C, 0xF6140203,
	0x81C, 0xF5160203,
	0x81C, 0xF4180203,
	0x81C, 0xF31A0203,
	0x81C, 0xF21C0203,
	0x81C, 0xF11E0203,
	0x81C, 0xF0200203,
	0x81C, 0xEF220203,
	0x81C, 0xEE240203,
	0x81C, 0xED260203,
	0x81C, 0xEC280203,
	0x81C, 0xEB2A0203,
	0x81C, 0xEA2C0203,
	0x81C, 0xE92E0203,
	0x81C, 0xE8300203,
	0x81C, 0xE7320203,
	0x81C, 0xE6340203,
	0x81C, 0xE5360203,
	0x81C, 0xE4380203,
	0x81C, 0xE33A0203,
	0x81C, 0xE23C0203,
	0x81C, 0xE13E0203,
	0x81C, 0xA4400203,
	0x81C, 0xA3420203,
	0x81C, 0xA2440203,
	0x81C, 0xA1460203,
	0x81C, 0x84480203,
	0x81C, 0x834A0203,
	0x81C, 0x824C0203,
	0x81C, 0x814E0203,
	0x81C, 0x64500203,
	0x81C, 0x63520203,
	0x81C, 0x62540203,
	0x81C, 0x61560203,
	0x81C, 0x45580203,
	0x81C, 0x445A0203,
	0x81C, 0x435C0203,
	0x81C, 0x425E0203,
	0x81C, 0x24600203,
	0x81C, 0x23620203,
	0x81C, 0x07640203,
	0x81C, 0x06660203,
	0x81C, 0x05680203,
	0x81C, 0x046A0203,
	0x81C, 0x036C0203,
	0x81C, 0x026E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF7000203,
	0x81C, 0xF6020203,
	0x81C, 0xF5040203,
	0x81C, 0xF4060203,
	0x81C, 0xF3080203,
	0x81C, 0xF20A0203,
	0x81C, 0xF10C0203,
	0x81C, 0xF00E0203,
	0x81C, 0xEF100203,
	0x81C, 0xEE120203,
	0x81C, 0xED140203,
	0x81C, 0xEC160203,
	0x81C, 0xEB180203,
	0x81C, 0xEA1A0203,
	0x81C, 0xE91C0203,
	0x81C, 0xE81E0203,
	0x81C, 0xE7200203,
	0x81C, 0xE6220203,
	0x81C, 0xE5240203,
	0x81C, 0xE4260203,
	0x81C, 0xE3280203,
	0x81C, 0xE22A0203,
	0x81C, 0xA62C0203,
	0x81C, 0xA52E0203,
	0x81C, 0xA4300203,
	0x81C, 0xA3320203,
	0x81C, 0xA2340203,
	0x81C, 0xA1360203,
	0x81C, 0x86380203,
	0x81C, 0x853A0203,
	0x81C, 0x843C0203,
	0x81C, 0x833E0203,
	0x81C, 0x65400203,
	0x81C, 0x64420203,
	0x81C, 0x63440203,
	0x81C, 0x46460203,
	0x81C, 0x45480203,
	0x81C, 0x444A0203,
	0x81C, 0x434C0203,
	0x81C, 0x264E0203,
	0x81C, 0x25500203,
	0x81C, 0x24520203,
	0x81C, 0x08540203,
	0x81C, 0x07560203,
	0x81C, 0x06580203,
	0x81C, 0x055A0203,
	0x81C, 0x045C0203,
	0x81C, 0x035E0203,
	0x81C, 0x02600203,
	0x81C, 0x01620203,
	0x81C, 0x01640203,
	0x81C, 0x01660203,
	0x81C, 0x01680203,
	0x81C, 0x016A0203,
	0x81C, 0x016C0203,
	0x81C, 0x016E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFF000203,
	0x81C, 0xFF020203,
	0x81C, 0xFE040203,
	0x81C, 0xFD060203,
	0x81C, 0xFC080203,
	0x81C, 0xFB0A0203,
	0x81C, 0xFA0C0203,
	0x81C, 0xF90E0203,
	0x81C, 0xF8100203,
	0x81C, 0xF7120203,
	0x81C, 0xF6140203,
	0x81C, 0xF5160203,
	0x81C, 0xF4180203,
	0x81C, 0xF31A0203,
	0x81C, 0xF21C0203,
	0x81C, 0xF11E0203,
	0x81C, 0xF0200203,
	0x81C, 0xEF220203,
	0x81C, 0xEE240203,
	0x81C, 0xED260203,
	0x81C, 0xEC280203,
	0x81C, 0xEB2A0203,
	0x81C, 0xEA2C0203,
	0x81C, 0xE92E0203,
	0x81C, 0xE8300203,
	0x81C, 0xE7320203,
	0x81C, 0xE6340203,
	0x81C, 0xE5360203,
	0x81C, 0xE4380203,
	0x81C, 0xE33A0203,
	0x81C, 0xE23C0203,
	0x81C, 0xE13E0203,
	0x81C, 0xA4400203,
	0x81C, 0xA3420203,
	0x81C, 0xA2440203,
	0x81C, 0xA1460203,
	0x81C, 0x84480203,
	0x81C, 0x834A0203,
	0x81C, 0x824C0203,
	0x81C, 0x814E0203,
	0x81C, 0x64500203,
	0x81C, 0x63520203,
	0x81C, 0x62540203,
	0x81C, 0x61560203,
	0x81C, 0x45580203,
	0x81C, 0x445A0203,
	0x81C, 0x435C0203,
	0x81C, 0x425E0203,
	0x81C, 0x24600203,
	0x81C, 0x23620203,
	0x81C, 0x07640203,
	0x81C, 0x06660203,
	0x81C, 0x05680203,
	0x81C, 0x046A0203,
	0x81C, 0x036C0203,
	0x81C, 0x026E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF8000203,
	0x81C, 0xF7020203,
	0x81C, 0xF6040203,
	0x81C, 0xF5060203,
	0x81C, 0xF4080203,
	0x81C, 0xF30A0203,
	0x81C, 0xF20C0203,
	0x81C, 0xF10E0203,
	0x81C, 0xF0100203,
	0x81C, 0xEF120203,
	0x81C, 0xEE140203,
	0x81C, 0xED160203,
	0x81C, 0xEC180203,
	0x81C, 0xEB1A0203,
	0x81C, 0xEA1C0203,
	0x81C, 0xE91E0203,
	0x81C, 0xE8200203,
	0x81C, 0xE7220203,
	0x81C, 0xE6240203,
	0x81C, 0xE5260203,
	0x81C, 0xE4280203,
	0x81C, 0xE32A0203,
	0x81C, 0xE22C0203,
	0x81C, 0xE12E0203,
	0x81C, 0xA6300203,
	0x81C, 0xA5320203,
	0x81C, 0xA4340203,
	0x81C, 0xA3360203,
	0x81C, 0xA2380203,
	0x81C, 0xA13A0203,
	0x81C, 0x843C0203,
	0x81C, 0x833E0203,
	0x81C, 0x82400203,
	0x81C, 0x81420203,
	0x81C, 0x64440203,
	0x81C, 0x63460203,
	0x81C, 0x62480203,
	0x81C, 0x614A0203,
	0x81C, 0x444C0203,
	0x81C, 0x434E0203,
	0x81C, 0x42500203,
	0x81C, 0x41520203,
	0x81C, 0x25540203,
	0x81C, 0x24560203,
	0x81C, 0x23580203,
	0x81C, 0x065A0203,
	0x81C, 0x055C0203,
	0x81C, 0x045E0203,
	0x81C, 0x03600203,
	0x81C, 0x02620203,
	0x81C, 0x01640203,
	0x81C, 0x01660203,
	0x81C, 0x01680203,
	0x81C, 0x016A0203,
	0x81C, 0x016C0203,
	0x81C, 0x016E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF9000203,
	0x81C, 0xF8020203,
	0x81C, 0xF7040203,
	0x81C, 0xF6060203,
	0x81C, 0xF5080203,
	0x81C, 0xF40A0203,
	0x81C, 0xF30C0203,
	0x81C, 0xF20E0203,
	0x81C, 0xF1100203,
	0x81C, 0xF0120203,
	0x81C, 0xEF140203,
	0x81C, 0xCE160203,
	0x81C, 0xCD180203,
	0x81C, 0xCC1A0203,
	0x81C, 0xCB1C0203,
	0x81C, 0xCA1E0203,
	0x81C, 0xC9200203,
	0x81C, 0xC8220203,
	0x81C, 0xC7240203,
	0x81C, 0xC6260203,
	0x81C, 0xC5280203,
	0x81C, 0xC42A0203,
	0x81C, 0xC32C0203,
	0x81C, 0xC22E0203,
	0x81C, 0xC1300203,
	0x81C, 0xA5320203,
	0x81C, 0xA4340203,
	0x81C, 0xA3360203,
	0x81C, 0xA2380203,
	0x81C, 0xA13A0203,
	0x81C, 0x853C0203,
	0x81C, 0x843E0203,
	0x81C, 0x83400203,
	0x81C, 0x82420203,
	0x81C, 0x81440203,
	0x81C, 0x64460203,
	0x81C, 0x63480203,
	0x81C, 0x624A0203,
	0x81C, 0x614C0203,
	0x81C, 0x444E0203,
	0x81C, 0x43500203,
	0x81C, 0x42520203,
	0x81C, 0x41540203,
	0x81C, 0x24560203,
	0x81C, 0x23580203,
	0x81C, 0x075A0203,
	0x81C, 0x065C0203,
	0x81C, 0x055E0203,
	0x81C, 0x04600203,
	0x81C, 0x03620203,
	0x81C, 0x02640203,
	0x81C, 0x01660203,
	0x81C, 0x01680203,
	0x81C, 0x016A0203,
	0x81C, 0x016C0203,
	0x81C, 0x016E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0xA0000000,	0x00000000,
	0x81C, 0xFF000203,
	0x81C, 0xFF020203,
	0x81C, 0xFE040203,
	0x81C, 0xFD060203,
	0x81C, 0xFC080203,
	0x81C, 0xFB0A0203,
	0x81C, 0xFA0C0203,
	0x81C, 0xF90E0203,
	0x81C, 0xF8100203,
	0x81C, 0xF7120203,
	0x81C, 0xF6140203,
	0x81C, 0xF5160203,
	0x81C, 0xF4180203,
	0x81C, 0xF31A0203,
	0x81C, 0xF21C0203,
	0x81C, 0xF11E0203,
	0x81C, 0xF0200203,
	0x81C, 0xEF220203,
	0x81C, 0xEE240203,
	0x81C, 0xED260203,
	0x81C, 0xEC280203,
	0x81C, 0xEB2A0203,
	0x81C, 0xEA2C0203,
	0x81C, 0xE92E0203,
	0x81C, 0xE8300203,
	0x81C, 0xE7320203,
	0x81C, 0xE6340203,
	0x81C, 0xE5360203,
	0x81C, 0xE4380203,
	0x81C, 0xE33A0203,
	0x81C, 0xE23C0203,
	0x81C, 0xE13E0203,
	0x81C, 0xA4400203,
	0x81C, 0xA3420203,
	0x81C, 0xA2440203,
	0x81C, 0xA1460203,
	0x81C, 0x85480203,
	0x81C, 0x844A0203,
	0x81C, 0x834C0203,
	0x81C, 0x824E0203,
	0x81C, 0x81500203,
	0x81C, 0x64520203,
	0x81C, 0x63540203,
	0x81C, 0x62560203,
	0x81C, 0x61580203,
	0x81C, 0x445A0203,
	0x81C, 0x435C0203,
	0x81C, 0x425E0203,
	0x81C, 0x25600203,
	0x81C, 0x24620203,
	0x81C, 0x06640203,
	0x81C, 0x05660203,
	0x81C, 0x04680203,
	0x81C, 0x036A0203,
	0x81C, 0x026C0203,
	0x81C, 0x016E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF8000303,
	0x81C, 0xF7020303,
	0x81C, 0xF6040303,
	0x81C, 0xF5060303,
	0x81C, 0xF4080303,
	0x81C, 0xF30A0303,
	0x81C, 0xF20C0303,
	0x81C, 0xF10E0303,
	0x81C, 0xF0100303,
	0x81C, 0xEF120303,
	0x81C, 0xEE140303,
	0x81C, 0xED160303,
	0x81C, 0xEC180303,
	0x81C, 0xEB1A0303,
	0x81C, 0xEA1C0303,
	0x81C, 0xE91E0303,
	0x81C, 0xE8200303,
	0x81C, 0xE7220303,
	0x81C, 0xE6240303,
	0x81C, 0xE5260303,
	0x81C, 0xE4280303,
	0x81C, 0xE32A0303,
	0x81C, 0xE22C0303,
	0x81C, 0xE12E0303,
	0x81C, 0xA6300303,
	0x81C, 0xA5320303,
	0x81C, 0xA4340303,
	0x81C, 0xA3360303,
	0x81C, 0xA2380303,
	0x81C, 0xA13A0303,
	0x81C, 0x843C0303,
	0x81C, 0x833E0303,
	0x81C, 0x82400303,
	0x81C, 0x81420303,
	0x81C, 0x64440303,
	0x81C, 0x63460303,
	0x81C, 0x62480303,
	0x81C, 0x614A0303,
	0x81C, 0x454C0303,
	0x81C, 0x444E0303,
	0x81C, 0x43500303,
	0x81C, 0x42520303,
	0x81C, 0x41540303,
	0x81C, 0x24560303,
	0x81C, 0x23580303,
	0x81C, 0x065A0303,
	0x81C, 0x055C0303,
	0x81C, 0x045E0303,
	0x81C, 0x03600303,
	0x81C, 0x02620303,
	0x81C, 0x01640303,
	0x81C, 0x01660303,
	0x81C, 0x01680303,
	0x81C, 0x016A0303,
	0x81C, 0x016C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF7000303,
	0x81C, 0xF6020303,
	0x81C, 0xF5040303,
	0x81C, 0xF4060303,
	0x81C, 0xF3080303,
	0x81C, 0xF20A0303,
	0x81C, 0xF10C0303,
	0x81C, 0xF00E0303,
	0x81C, 0xEF100303,
	0x81C, 0xEE120303,
	0x81C, 0xED140303,
	0x81C, 0xEC160303,
	0x81C, 0xEB180303,
	0x81C, 0xEA1A0303,
	0x81C, 0xE91C0303,
	0x81C, 0xE81E0303,
	0x81C, 0xE7200303,
	0x81C, 0xE6220303,
	0x81C, 0xE5240303,
	0x81C, 0xE4260303,
	0x81C, 0xE3280303,
	0x81C, 0xC32A0303,
	0x81C, 0xC22C0303,
	0x81C, 0xC12E0303,
	0x81C, 0xA5300303,
	0x81C, 0xA4320303,
	0x81C, 0xA3340303,
	0x81C, 0xA2360303,
	0x81C, 0xA1380303,
	0x81C, 0x853A0303,
	0x81C, 0x843C0303,
	0x81C, 0x833E0303,
	0x81C, 0x82400303,
	0x81C, 0x81420303,
	0x81C, 0x64440303,
	0x81C, 0x63460303,
	0x81C, 0x62480303,
	0x81C, 0x614A0303,
	0x81C, 0x454C0303,
	0x81C, 0x444E0303,
	0x81C, 0x43500303,
	0x81C, 0x25520303,
	0x81C, 0x24540303,
	0x81C, 0x23560303,
	0x81C, 0x06580303,
	0x81C, 0x055A0303,
	0x81C, 0x045C0303,
	0x81C, 0x035E0303,
	0x81C, 0x02600303,
	0x81C, 0x01620303,
	0x81C, 0x01640303,
	0x81C, 0x01660303,
	0x81C, 0x01680303,
	0x81C, 0x016A0303,
	0x81C, 0x016C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF9000303,
	0x81C, 0xF8020303,
	0x81C, 0xF7040303,
	0x81C, 0xF6060303,
	0x81C, 0xF5080303,
	0x81C, 0xF40A0303,
	0x81C, 0xF30C0303,
	0x81C, 0xF20E0303,
	0x81C, 0xF1100303,
	0x81C, 0xF0120303,
	0x81C, 0xEF140303,
	0x81C, 0xEE160303,
	0x81C, 0xED180303,
	0x81C, 0xEC1A0303,
	0x81C, 0xEB1C0303,
	0x81C, 0xEA1E0303,
	0x81C, 0xE9200303,
	0x81C, 0xE8220303,
	0x81C, 0xE7240303,
	0x81C, 0xE6260303,
	0x81C, 0xE5280303,
	0x81C, 0xE42A0303,
	0x81C, 0xE32C0303,
	0x81C, 0xE22E0303,
	0x81C, 0xE1300303,
	0x81C, 0xA4320303,
	0x81C, 0xA3340303,
	0x81C, 0xA2360303,
	0x81C, 0xA1380303,
	0x81C, 0x853A0303,
	0x81C, 0x843C0303,
	0x81C, 0x833E0303,
	0x81C, 0x82400303,
	0x81C, 0x81420303,
	0x81C, 0x64440303,
	0x81C, 0x63460303,
	0x81C, 0x62480303,
	0x81C, 0x614A0303,
	0x81C, 0x444C0303,
	0x81C, 0x434E0303,
	0x81C, 0x42500303,
	0x81C, 0x25520303,
	0x81C, 0x24540303,
	0x81C, 0x23560303,
	0x81C, 0x07580303,
	0x81C, 0x065A0303,
	0x81C, 0x055C0303,
	0x81C, 0x045E0303,
	0x81C, 0x03600303,
	0x81C, 0x02620303,
	0x81C, 0x01640303,
	0x81C, 0x01660303,
	0x81C, 0x01680303,
	0x81C, 0x016A0303,
	0x81C, 0x016C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF7000303,
	0x81C, 0xF6020303,
	0x81C, 0xF5040303,
	0x81C, 0xF4060303,
	0x81C, 0xF3080303,
	0x81C, 0xF20A0303,
	0x81C, 0xF10C0303,
	0x81C, 0xF00E0303,
	0x81C, 0xEF100303,
	0x81C, 0xEE120303,
	0x81C, 0xED140303,
	0x81C, 0xEC160303,
	0x81C, 0xEB180303,
	0x81C, 0xEA1A0303,
	0x81C, 0xE91C0303,
	0x81C, 0xE81E0303,
	0x81C, 0xE7200303,
	0x81C, 0xE6220303,
	0x81C, 0xE5240303,
	0x81C, 0xE4260303,
	0x81C, 0xE3280303,
	0x81C, 0xE22A0303,
	0x81C, 0xE12C0303,
	0x81C, 0xA72E0303,
	0x81C, 0xA6300303,
	0x81C, 0xA5320303,
	0x81C, 0xA4340303,
	0x81C, 0xA3360303,
	0x81C, 0xA2380303,
	0x81C, 0xA13A0303,
	0x81C, 0x843C0303,
	0x81C, 0x833E0303,
	0x81C, 0x82400303,
	0x81C, 0x81420303,
	0x81C, 0x64440303,
	0x81C, 0x63460303,
	0x81C, 0x62480303,
	0x81C, 0x614A0303,
	0x81C, 0x454C0303,
	0x81C, 0x444E0303,
	0x81C, 0x43500303,
	0x81C, 0x42520303,
	0x81C, 0x41540303,
	0x81C, 0x24560303,
	0x81C, 0x23580303,
	0x81C, 0x065A0303,
	0x81C, 0x055C0303,
	0x81C, 0x045E0303,
	0x81C, 0x03600303,
	0x81C, 0x02620303,
	0x81C, 0x01640303,
	0x81C, 0x01660303,
	0x81C, 0x01680303,
	0x81C, 0x016A0303,
	0x81C, 0x016C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFB000303,
	0x81C, 0xFA020303,
	0x81C, 0xF9040303,
	0x81C, 0xF8060303,
	0x81C, 0xF7080303,
	0x81C, 0xF60A0303,
	0x81C, 0xF50C0303,
	0x81C, 0xF40E0303,
	0x81C, 0xF3100303,
	0x81C, 0xF2120303,
	0x81C, 0xF1140303,
	0x81C, 0xF0160303,
	0x81C, 0xEF180303,
	0x81C, 0xEE1A0303,
	0x81C, 0xED1C0303,
	0x81C, 0xEC1E0303,
	0x81C, 0xEB200303,
	0x81C, 0xEA220303,
	0x81C, 0xE9240303,
	0x81C, 0xE8260303,
	0x81C, 0xE7280303,
	0x81C, 0xE62A0303,
	0x81C, 0xE52C0303,
	0x81C, 0xE42E0303,
	0x81C, 0xE3300303,
	0x81C, 0xE2320303,
	0x81C, 0xE1340303,
	0x81C, 0xC2360303,
	0x81C, 0xC1380303,
	0x81C, 0xA33A0303,
	0x81C, 0xA23C0303,
	0x81C, 0x853E0303,
	0x81C, 0x84400303,
	0x81C, 0x83420303,
	0x81C, 0x66440303,
	0x81C, 0x65460303,
	0x81C, 0x64480303,
	0x81C, 0x634A0303,
	0x81C, 0x624C0303,
	0x81C, 0x614E0303,
	0x81C, 0x45500303,
	0x81C, 0x44520303,
	0x81C, 0x43540303,
	0x81C, 0x42560303,
	0x81C, 0x25580303,
	0x81C, 0x245A0303,
	0x81C, 0x235C0303,
	0x81C, 0x065E0303,
	0x81C, 0x05600303,
	0x81C, 0x04620303,
	0x81C, 0x03640303,
	0x81C, 0x02660303,
	0x81C, 0x01680303,
	0x81C, 0x016A0303,
	0x81C, 0x016C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF9000303,
	0x81C, 0xF8020303,
	0x81C, 0xF7040303,
	0x81C, 0xF6060303,
	0x81C, 0xF5080303,
	0x81C, 0xF40A0303,
	0x81C, 0xF30C0303,
	0x81C, 0xF20E0303,
	0x81C, 0xF1100303,
	0x81C, 0xF0120303,
	0x81C, 0xEF140303,
	0x81C, 0xEE160303,
	0x81C, 0xED180303,
	0x81C, 0xEC1A0303,
	0x81C, 0xEB1C0303,
	0x81C, 0xEA1E0303,
	0x81C, 0xE9200303,
	0x81C, 0xE8220303,
	0x81C, 0xE7240303,
	0x81C, 0xE6260303,
	0x81C, 0xE5280303,
	0x81C, 0xE42A0303,
	0x81C, 0xE32C0303,
	0x81C, 0xE22E0303,
	0x81C, 0xE1300303,
	0x81C, 0xA6320303,
	0x81C, 0xA5340303,
	0x81C, 0xA4360303,
	0x81C, 0xA3380303,
	0x81C, 0xA23A0303,
	0x81C, 0xA13C0303,
	0x81C, 0x853E0303,
	0x81C, 0x84400303,
	0x81C, 0x83420303,
	0x81C, 0x82440303,
	0x81C, 0x81460303,
	0x81C, 0x64480303,
	0x81C, 0x634A0303,
	0x81C, 0x624C0303,
	0x81C, 0x614E0303,
	0x81C, 0x44500303,
	0x81C, 0x43520303,
	0x81C, 0x42540303,
	0x81C, 0x41560303,
	0x81C, 0x25580303,
	0x81C, 0x245A0303,
	0x81C, 0x235C0303,
	0x81C, 0x055E0303,
	0x81C, 0x04600303,
	0x81C, 0x03620303,
	0x81C, 0x02640303,
	0x81C, 0x01660303,
	0x81C, 0x01680303,
	0x81C, 0x016A0303,
	0x81C, 0x016C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000303,
	0x81C, 0xFD020303,
	0x81C, 0xFC040303,
	0x81C, 0xFB060303,
	0x81C, 0xFA080303,
	0x81C, 0xF90A0303,
	0x81C, 0xF80C0303,
	0x81C, 0xF70E0303,
	0x81C, 0xF6100303,
	0x81C, 0xF5120303,
	0x81C, 0xF4140303,
	0x81C, 0xF3160303,
	0x81C, 0xF2180303,
	0x81C, 0xF11A0303,
	0x81C, 0xF01C0303,
	0x81C, 0xEF1E0303,
	0x81C, 0xEE200303,
	0x81C, 0xED220303,
	0x81C, 0xEC240303,
	0x81C, 0xEB260303,
	0x81C, 0xEA280303,
	0x81C, 0xE92A0303,
	0x81C, 0xE82C0303,
	0x81C, 0xE72E0303,
	0x81C, 0xE6300303,
	0x81C, 0xE5320303,
	0x81C, 0xE4340303,
	0x81C, 0xE3360303,
	0x81C, 0xC3380303,
	0x81C, 0xC23A0303,
	0x81C, 0xC13C0303,
	0x81C, 0xA43E0303,
	0x81C, 0xA3400303,
	0x81C, 0xA2420303,
	0x81C, 0xA1440303,
	0x81C, 0x85460303,
	0x81C, 0x84480303,
	0x81C, 0x834A0303,
	0x81C, 0x824C0303,
	0x81C, 0x814E0303,
	0x81C, 0x64500303,
	0x81C, 0x63520303,
	0x81C, 0x62540303,
	0x81C, 0x61560303,
	0x81C, 0x44580303,
	0x81C, 0x435A0303,
	0x81C, 0x425C0303,
	0x81C, 0x265E0303,
	0x81C, 0x25600303,
	0x81C, 0x24620303,
	0x81C, 0x06640303,
	0x81C, 0x05660303,
	0x81C, 0x04680303,
	0x81C, 0x036A0303,
	0x81C, 0x026C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF7000303,
	0x81C, 0xF6020303,
	0x81C, 0xF5040303,
	0x81C, 0xF4060303,
	0x81C, 0xF3080303,
	0x81C, 0xF20A0303,
	0x81C, 0xF10C0303,
	0x81C, 0xF00E0303,
	0x81C, 0xEF100303,
	0x81C, 0xEE120303,
	0x81C, 0xED140303,
	0x81C, 0xEC160303,
	0x81C, 0xEB180303,
	0x81C, 0xEA1A0303,
	0x81C, 0xE91C0303,
	0x81C, 0xE81E0303,
	0x81C, 0xE7200303,
	0x81C, 0xE6220303,
	0x81C, 0xE5240303,
	0x81C, 0xE4260303,
	0x81C, 0xE3280303,
	0x81C, 0xE22A0303,
	0x81C, 0xA62C0303,
	0x81C, 0xA52E0303,
	0x81C, 0xA4300303,
	0x81C, 0xA3320303,
	0x81C, 0xA2340303,
	0x81C, 0x87360303,
	0x81C, 0x86380303,
	0x81C, 0x853A0303,
	0x81C, 0x843C0303,
	0x81C, 0x833E0303,
	0x81C, 0x66400303,
	0x81C, 0x65420303,
	0x81C, 0x64440303,
	0x81C, 0x45460303,
	0x81C, 0x44480303,
	0x81C, 0x434A0303,
	0x81C, 0x274C0303,
	0x81C, 0x264E0303,
	0x81C, 0x25500303,
	0x81C, 0x24520303,
	0x81C, 0x23540303,
	0x81C, 0x08560303,
	0x81C, 0x07580303,
	0x81C, 0x065A0303,
	0x81C, 0x055C0303,
	0x81C, 0x045E0303,
	0x81C, 0x03600303,
	0x81C, 0x02620303,
	0x81C, 0x01640303,
	0x81C, 0x01660303,
	0x81C, 0x01680303,
	0x81C, 0x016A0303,
	0x81C, 0x016C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFE000303,
	0x81C, 0xFD020303,
	0x81C, 0xFC040303,
	0x81C, 0xFB060303,
	0x81C, 0xFA080303,
	0x81C, 0xF90A0303,
	0x81C, 0xF80C0303,
	0x81C, 0xF70E0303,
	0x81C, 0xF6100303,
	0x81C, 0xF5120303,
	0x81C, 0xF4140303,
	0x81C, 0xF3160303,
	0x81C, 0xF2180303,
	0x81C, 0xF11A0303,
	0x81C, 0xF01C0303,
	0x81C, 0xEF1E0303,
	0x81C, 0xEE200303,
	0x81C, 0xED220303,
	0x81C, 0xEC240303,
	0x81C, 0xEB260303,
	0x81C, 0xEA280303,
	0x81C, 0xE92A0303,
	0x81C, 0xE82C0303,
	0x81C, 0xE72E0303,
	0x81C, 0xE6300303,
	0x81C, 0xE5320303,
	0x81C, 0xE4340303,
	0x81C, 0xE3360303,
	0x81C, 0xC3380303,
	0x81C, 0xC23A0303,
	0x81C, 0xC13C0303,
	0x81C, 0xA43E0303,
	0x81C, 0xA3400303,
	0x81C, 0xA2420303,
	0x81C, 0xA1440303,
	0x81C, 0x85460303,
	0x81C, 0x84480303,
	0x81C, 0x834A0303,
	0x81C, 0x824C0303,
	0x81C, 0x814E0303,
	0x81C, 0x64500303,
	0x81C, 0x63520303,
	0x81C, 0x62540303,
	0x81C, 0x61560303,
	0x81C, 0x44580303,
	0x81C, 0x435A0303,
	0x81C, 0x425C0303,
	0x81C, 0x265E0303,
	0x81C, 0x25600303,
	0x81C, 0x24620303,
	0x81C, 0x06640303,
	0x81C, 0x05660303,
	0x81C, 0x04680303,
	0x81C, 0x036A0303,
	0x81C, 0x026C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF7000303,
	0x81C, 0xF6020303,
	0x81C, 0xF5040303,
	0x81C, 0xF4060303,
	0x81C, 0xF3080303,
	0x81C, 0xF20A0303,
	0x81C, 0xF10C0303,
	0x81C, 0xF00E0303,
	0x81C, 0xEF100303,
	0x81C, 0xEE120303,
	0x81C, 0xED140303,
	0x81C, 0xEC160303,
	0x81C, 0xEB180303,
	0x81C, 0xEA1A0303,
	0x81C, 0xE91C0303,
	0x81C, 0xE81E0303,
	0x81C, 0xE7200303,
	0x81C, 0xE6220303,
	0x81C, 0xE5240303,
	0x81C, 0xE4260303,
	0x81C, 0xE3280303,
	0x81C, 0xE22A0303,
	0x81C, 0xE12C0303,
	0x81C, 0xA72E0303,
	0x81C, 0xA6300303,
	0x81C, 0xA5320303,
	0x81C, 0xA4340303,
	0x81C, 0xA3360303,
	0x81C, 0xA2380303,
	0x81C, 0xA13A0303,
	0x81C, 0x843C0303,
	0x81C, 0x833E0303,
	0x81C, 0x82400303,
	0x81C, 0x81420303,
	0x81C, 0x64440303,
	0x81C, 0x63460303,
	0x81C, 0x62480303,
	0x81C, 0x614A0303,
	0x81C, 0x454C0303,
	0x81C, 0x444E0303,
	0x81C, 0x43500303,
	0x81C, 0x42520303,
	0x81C, 0x41540303,
	0x81C, 0x24560303,
	0x81C, 0x23580303,
	0x81C, 0x065A0303,
	0x81C, 0x055C0303,
	0x81C, 0x045E0303,
	0x81C, 0x03600303,
	0x81C, 0x02620303,
	0x81C, 0x01640303,
	0x81C, 0x01660303,
	0x81C, 0x01680303,
	0x81C, 0x016A0303,
	0x81C, 0x016C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xF7000303,
	0x81C, 0xF6020303,
	0x81C, 0xF5040303,
	0x81C, 0xF4060303,
	0x81C, 0xF3080303,
	0x81C, 0xF20A0303,
	0x81C, 0xF10C0303,
	0x81C, 0xF00E0303,
	0x81C, 0xEF100303,
	0x81C, 0xEE120303,
	0x81C, 0xED140303,
	0x81C, 0xEC160303,
	0x81C, 0xEB180303,
	0x81C, 0xEA1A0303,
	0x81C, 0xAF1C0303,
	0x81C, 0xAE1E0303,
	0x81C, 0xAD200303,
	0x81C, 0xAC220303,
	0x81C, 0xAB240303,
	0x81C, 0xAA260303,
	0x81C, 0xC5280303,
	0x81C, 0xC42A0303,
	0x81C, 0xC32C0303,
	0x81C, 0xC22E0303,
	0x81C, 0xA5300303,
	0x81C, 0xA4320303,
	0x81C, 0xA3340303,
	0x81C, 0xA2360303,
	0x81C, 0xA1380303,
	0x81C, 0x853A0303,
	0x81C, 0x843C0303,
	0x81C, 0x833E0303,
	0x81C, 0x82400303,
	0x81C, 0x81420303,
	0x81C, 0x64440303,
	0x81C, 0x63460303,
	0x81C, 0x62480303,
	0x81C, 0x614A0303,
	0x81C, 0x444C0303,
	0x81C, 0x434E0303,
	0x81C, 0x42500303,
	0x81C, 0x41520303,
	0x81C, 0x25540303,
	0x81C, 0x24560303,
	0x81C, 0x06580303,
	0x81C, 0x055A0303,
	0x81C, 0x045C0303,
	0x81C, 0x035E0303,
	0x81C, 0x02600303,
	0x81C, 0x01620303,
	0x81C, 0x01640303,
	0x81C, 0x01660303,
	0x81C, 0x01680303,
	0x81C, 0x016A0303,
	0x81C, 0x016C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0xA0000000,	0x00000000,
	0x81C, 0xFD000303,
	0x81C, 0xFC020303,
	0x81C, 0xFB040303,
	0x81C, 0xFA060303,
	0x81C, 0xF9080303,
	0x81C, 0xF80A0303,
	0x81C, 0xF70C0303,
	0x81C, 0xF60E0303,
	0x81C, 0xF5100303,
	0x81C, 0xF4120303,
	0x81C, 0xF3140303,
	0x81C, 0xF2160303,
	0x81C, 0xF1180303,
	0x81C, 0xF01A0303,
	0x81C, 0xEF1C0303,
	0x81C, 0xEE1E0303,
	0x81C, 0xED200303,
	0x81C, 0xEC220303,
	0x81C, 0xEB240303,
	0x81C, 0xEA260303,
	0x81C, 0xE9280303,
	0x81C, 0xE82A0303,
	0x81C, 0xE72C0303,
	0x81C, 0xE62E0303,
	0x81C, 0xE5300303,
	0x81C, 0xE4320303,
	0x81C, 0xE3340303,
	0x81C, 0xE2360303,
	0x81C, 0xE1380303,
	0x81C, 0xA53A0303,
	0x81C, 0xA43C0303,
	0x81C, 0xA33E0303,
	0x81C, 0xA2400303,
	0x81C, 0xA1420303,
	0x81C, 0x87440303,
	0x81C, 0x86460303,
	0x81C, 0x85480303,
	0x81C, 0x844A0303,
	0x81C, 0x834C0303,
	0x81C, 0x824E0303,
	0x81C, 0x81500303,
	0x81C, 0x64520303,
	0x81C, 0x63540303,
	0x81C, 0x62560303,
	0x81C, 0x61580303,
	0x81C, 0x435A0303,
	0x81C, 0x425C0303,
	0x81C, 0x415E0303,
	0x81C, 0x07600303,
	0x81C, 0x06620303,
	0x81C, 0x05640303,
	0x81C, 0x04660303,
	0x81C, 0x03680303,
	0x81C, 0x026A0303,
	0x81C, 0x016C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0xB0000000,	0x00000000,
	0xC50, 0x00000022,
	0xC50, 0x00000020,
	0xE50, 0x00000022,
	0xE50, 0x00000020,
	0x1850, 0x00000022,
	0x1850, 0x00000020,
	0x1A50, 0x00000022,
	0x1A50, 0x00000020,
};

RTW_DECL_TABLE_PHY_COND(rtw8814a_agc, rtw_phy_cfg_agc);

static const u32 rtw8814a_bb[] = {
	0x800, 0x9020D010,
	0x804, 0x08011280,
	0x808, 0x0E0282FF,
	0x80C, 0x1000002F,
	0x80000003,	0x00000000,	0x40000000,	0x00000000,
	0x810, 0x33303265,
	0xA0000000,	0x00000000,
	0x810, 0x33303265,
	0xB0000000,	0x00000000,
	0x814, 0x020C3D10,
	0x818, 0x04A10385,
	0x820, 0x00000000,
	0x824, 0x00033E40,
	0x828, 0x00000000,
	0x82C, 0x73985170,
	0x830, 0x79A0EA08,
	0x834, 0x042E708A,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
	0x838, 0x86667640,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x838, 0x86667641,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x838, 0x86667641,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x838, 0x86667641,
	0xA0000000,	0x00000000,
	0x838, 0x86667640,
	0xB0000000,	0x00000000,
	0x83C, 0x9798B9B9,
	0x840, 0x17578F60,
	0x844, 0x4BBDFCDE,
	0x848, 0x5CD07F8B,
	0x84C, 0x6CFBF7B5,
	0x850, 0x28834706,
	0x854, 0x0001520C,
	0x858, 0x4060C000,
	0x85C, 0x74210368,
	0x860, 0x6929C321,
	0x864, 0x79727432,
	0x868, 0x8CA7A314,
	0x86C, 0x438C2878,
	0x870, 0x44444444,
	0x874, 0x21612C2E,
	0x878, 0x00003152,
	0x87C, 0x000FC000,
	0x8A0, 0x00000013,
	0x8A4, 0x7F7F7F7F,
	0x8A8, 0xA202033E,
	0x8AC, 0xF40F550A,
	0x8B0, 0x00000600,
	0x8B4, 0x000FC080,
	0x8B8, 0xEC0057FF,
	0x8BC, 0x8CA520C3,
	0x8C0, 0x3FF00020,
	0x8C4, 0x44C00000,
	0x80000009,	0x00000000,	0x40000000,	0x00000000,
	0x8C8, 0x80025969,
	0xA0000000,	0x00000000,
	0x8C8, 0x80025167,
	0xB0000000,	0x00000000,
	0x8CC, 0x08250492,
	0x8D0, 0x0000B800,
	0x8D4, 0x940008A0,
	0x8D8, 0x290B5612,
	0x8DC, 0x00000000,
	0x8E0, 0x32316407,
	0x8E4, 0x4A092925,
	0x8E8, 0xFFFFC42C,
	0x8EC, 0x99999999,
	0x8F0, 0x00009999,
	0x8F4, 0x00F80FA1,
	0x8F8, 0x400082C0,
	0x8FC, 0x00000000,
	0x900, 0x00400700,
	0x90C, 0x09004000,
	0x910, 0x0000FC00,
	0x914, 0xD6400404,
	0x918, 0x1C1028C0,
	0x91C, 0x64B11A1C,
	0x920, 0xE0767233,
	0x924, 0x055AA500,
	0x928, 0x4AB0E4E4,
	0x92C, 0xFFFE0000,
	0x930, 0xFFFFFFFE,
	0x934, 0x001FFFFF,
	0x938, 0x00008400,
	0x93C, 0x932C0642,
	0x940, 0x093E9360,
	0x944, 0x08000000,
	0x948, 0x04000000,
	0x950, 0x02010080,
	0x954, 0x86510080,
	0x960, 0x00000000,
	0x964, 0x00000000,
	0x968, 0x00000000,
	0x96C, 0x00000000,
	0x970, 0x801FFFFF,
	0x978, 0x00000000,
	0x97C, 0x00000000,
	0x980, 0x00000000,
	0x984, 0x00000000,
	0x988, 0x00000000,
	0x98C, 0x03440000,
	0x990, 0x27100000,
	0x994, 0xFFFF0100,
	0x998, 0xFFFFFF5C,
	0x99C, 0xFFFFFFFF,
	0x9A0, 0x000000FF,
	0x9A4, 0x00080080,
	0x9A8, 0x0C2F0000,
	0x9AC, 0x00560000,
	0x9B0, 0x81081008,
	0x9B4, 0x00000000,
	0x9B8, 0x01081008,
	0x9BC, 0x01081008,
	0x9D0, 0x00000000,
	0x9D4, 0x00000000,
	0x9D8, 0x00000000,
	0x9DC, 0x00000000,
	0x9E4, 0x00000002,
	0x9E8, 0x000022D5,
	0x9FC, 0xEFFFF7FF,
	0xB00, 0xE3100000,
	0xB04, 0x0000B000,
	0xB0C, 0x31EAA006,
	0xB5C, 0x41CFFFFF,
	0xC00, 0x00000007,
	0xC04, 0x00042020,
	0xC08, 0x80410231,
	0xC0C, 0x00000000,
	0xC10, 0x00000100,
	0xC14, 0x01000000,
	0xC1C, 0x40000053,
	0xC50, 0x00000020,
	0xC54, 0x00000000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
	0xC58, 0x3C0A0C14,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0xC58, 0x3C0A0C14,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0xC58, 0x3C0A0C14,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xC58, 0x3C0A0C14,
	0xA0000000,	0x00000000,
	0xC58, 0x3C020C14,
	0xB0000000,	0x00000000,
	0xC5C, 0x0D000058,
	0xC60, 0x1B800000,
	0xC60, 0x0B800001,
	0xC60, 0x05800002,
	0xC60, 0x07800003,
	0xC60, 0x1A800004,
	0xC60, 0x0B800005,
	0xC60, 0x05800006,
	0xC60, 0x0E800007,
	0xC60, 0x1A800008,
	0xC60, 0x0B800009,
	0xC60, 0x1580000A,
	0xC60, 0x0880000B,
	0xC60, 0x1A80000C,
	0xC60, 0x0B80000D,
	0xC60, 0x0580000E,
	0xC60, 0x0E80000F,
	0xC60, 0x1A800010,
	0xC60, 0x0B800011,
	0xC60, 0x15800012,
	0xC60, 0x08800013,
	0xC60, 0x1A800014,
	0xC60, 0x0B800015,
	0xC60, 0x05800016,
	0xC60, 0x07800017,
	0xC60, 0x1A800018,
	0xC60, 0x0B800019,
	0xC60, 0x1580001A,
	0xC60, 0x0880001B,
	0xC60, 0x1B80001C,
	0xC60, 0x0B80001D,
	0xC60, 0x0580001E,
	0xC60, 0x0780001F,
	0xC60, 0x1B800020,
	0xC60, 0x0B800021,
	0xC60, 0x05800022,
	0xC60, 0x07800023,
	0xC60, 0x1B800024,
	0xC60, 0x0B800025,
	0xC60, 0x05800026,
	0xC60, 0x07800027,
	0xC60, 0x1B800028,
	0xC60, 0x0B800029,
	0xC60, 0x0580002A,
	0xC60, 0x0780002B,
	0xC60, 0x1B800030,
	0xC60, 0x0B800031,
	0xC60, 0x05800032,
	0xC60, 0x00800033,
	0xC60, 0x1B800034,
	0xC60, 0x0B800035,
	0xC60, 0x05800036,
	0xC60, 0x00800037,
	0xC60, 0x1B800038,
	0xC60, 0x0B800039,
	0xC60, 0x0580003A,
	0xC60, 0x0E80803B,
	0xC94, 0x01000401,
	0xC98, 0x00188000,
	0xCA0, 0x00002929,
	0xCA4, 0x08040201,
	0xCA8, 0x80402010,
	0xCAC, 0x77777000,
	0xCB0, 0x54775477,
	0xCB4, 0x54775477,
	0xCB8, 0x00500000,
	0xCBC, 0x77700000,
	0xCC0, 0x00000010,
	0xCC8, 0x00000010,
	0xE00, 0x00000007,
	0xE04, 0x00042020,
	0xE08, 0x80410231,
	0xE0C, 0x00000000,
	0xE10, 0x00000100,
	0xE14, 0x01000000,
	0xE1C, 0x40000053,
	0xE50, 0x00000020,
	0xE54, 0x00000000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
	0xE58, 0x3C0A0C14,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0xE58, 0x3C0A0C14,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0xE58, 0x3C0A0C14,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xE58, 0x3C0A0C14,
	0xA0000000,	0x00000000,
	0xE58, 0x3C020C14,
	0xB0000000,	0x00000000,
	0xE5C, 0x0D000058,
	0xE60, 0x1B800000,
	0xE60, 0x0B800001,
	0xE60, 0x05800002,
	0xE60, 0x07800003,
	0xE60, 0x1A800004,
	0xE60, 0x0B800005,
	0xE60, 0x05800006,
	0xE60, 0x0E800007,
	0xE60, 0x1A800008,
	0xE60, 0x0B800009,
	0xE60, 0x1580000A,
	0xE60, 0x0880000B,
	0xE60, 0x1A80000C,
	0xE60, 0x0B80000D,
	0xE60, 0x0580000E,
	0xE60, 0x0E80000F,
	0xE60, 0x1A800010,
	0xE60, 0x0B800011,
	0xE60, 0x15800012,
	0xE60, 0x08800013,
	0xE60, 0x1A800014,
	0xE60, 0x0B800015,
	0xE60, 0x05800016,
	0xE60, 0x07800017,
	0xE60, 0x1A800018,
	0xE60, 0x0B800019,
	0xE60, 0x1580001A,
	0xE60, 0x0880001B,
	0xE60, 0x1B80001C,
	0xE60, 0x0B80001D,
	0xE60, 0x0580001E,
	0xE60, 0x0780001F,
	0xE60, 0x1B800020,
	0xE60, 0x0B800021,
	0xE60, 0x05800022,
	0xE60, 0x07800023,
	0xE60, 0x1B800024,
	0xE60, 0x0B800025,
	0xE60, 0x05800026,
	0xE60, 0x07800027,
	0xE60, 0x1B800028,
	0xE60, 0x0B800029,
	0xE60, 0x0580002A,
	0xE60, 0x0780002B,
	0xE60, 0x1B800030,
	0xE60, 0x0B800031,
	0xE60, 0x05800032,
	0xE60, 0x00800033,
	0xE60, 0x1B800034,
	0xE60, 0x0B800035,
	0xE60, 0x05800036,
	0xE60, 0x00800037,
	0xE60, 0x1B800038,
	0xE60, 0x0B800039,
	0xE60, 0x0580003A,
	0xE60, 0x0E80803B,
	0xE94, 0x01000401,
	0xE98, 0x00188000,
	0xEA0, 0x00002929,
	0xEA4, 0x08040201,
	0xEA8, 0x80402010,
	0xEAC, 0x77777000,
	0xEB0, 0x54775477,
	0xEB4, 0x54775477,
	0xEB8, 0x00500000,
	0xEBC, 0x77700000,
	0x1800, 0x00000007,
	0x1804, 0x00042020,
	0x1808, 0x80410231,
	0x180C, 0x00000000,
	0x1810, 0x00000100,
	0x1814, 0x01000000,
	0x181C, 0x40000053,
	0x1850, 0x00000020,
	0x1854, 0x00000000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
	0x1858, 0x3C0A0C14,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1858, 0x3C0A0C14,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1858, 0x3C0A0C14,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1858, 0x3C0A0C14,
	0xA0000000,	0x00000000,
	0x1858, 0x3C020C14,
	0xB0000000,	0x00000000,
	0x185C, 0x0D000058,
	0x1860, 0x1B800000,
	0x1860, 0x0B800001,
	0x1860, 0x05800002,
	0x1860, 0x07800003,
	0x1860, 0x1A800004,
	0x1860, 0x0B800005,
	0x1860, 0x05800006,
	0x1860, 0x0E800007,
	0x1860, 0x1A800008,
	0x1860, 0x0B800009,
	0x1860, 0x1580000A,
	0x1860, 0x0880000B,
	0x1860, 0x1A80000C,
	0x1860, 0x0B80000D,
	0x1860, 0x0580000E,
	0x1860, 0x0E80000F,
	0x1860, 0x1A800010,
	0x1860, 0x0B800011,
	0x1860, 0x15800012,
	0x1860, 0x08800013,
	0x1860, 0x1A800014,
	0x1860, 0x0B800015,
	0x1860, 0x05800016,
	0x1860, 0x07800017,
	0x1860, 0x1A800018,
	0x1860, 0x0B800019,
	0x1860, 0x1580001A,
	0x1860, 0x0880001B,
	0x1860, 0x1B80001C,
	0x1860, 0x0B80001D,
	0x1860, 0x0580001E,
	0x1860, 0x0780001F,
	0x1860, 0x1B800020,
	0x1860, 0x0B800021,
	0x1860, 0x05800022,
	0x1860, 0x07800023,
	0x1860, 0x1B800024,
	0x1860, 0x0B800025,
	0x1860, 0x05800026,
	0x1860, 0x07800027,
	0x1860, 0x1B800028,
	0x1860, 0x0B800029,
	0x1860, 0x0580002A,
	0x1860, 0x0780002B,
	0x1860, 0x1B800030,
	0x1860, 0x0B800031,
	0x1860, 0x05800032,
	0x1860, 0x00800033,
	0x1860, 0x1B800034,
	0x1860, 0x0B800035,
	0x1860, 0x05800036,
	0x1860, 0x00800037,
	0x1860, 0x1B800038,
	0x1860, 0x0B800039,
	0x1860, 0x0580003A,
	0x1860, 0x0E80803B,
	0x1894, 0x01000401,
	0x1898, 0x00188000,
	0x18A0, 0x00002929,
	0x18A4, 0x08040201,
	0x18A8, 0x80402010,
	0x18AC, 0x77777000,
	0x18B0, 0x54775477,
	0x18B4, 0x54775477,
	0x18B8, 0x00500000,
	0x18BC, 0x77700000,
	0x1A00, 0x00000007,
	0x1A04, 0x00042020,
	0x1A08, 0x80410231,
	0x1A0C, 0x00000000,
	0x1A10, 0x00000100,
	0x1A14, 0x01000000,
	0x1A1C, 0x40000053,
	0x1A50, 0x00000020,
	0x1A54, 0x00000000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
	0x1A58, 0x3C0A0C14,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1A58, 0x3C0A0C14,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1A58, 0x3C0A0C14,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1A58, 0x3C0A0C14,
	0xA0000000,	0x00000000,
	0x1A58, 0x3C020C14,
	0xB0000000,	0x00000000,
	0x1A5C, 0x0D000058,
	0x1A60, 0x1B800000,
	0x1A60, 0x0B800001,
	0x1A60, 0x05800002,
	0x1A60, 0x07800003,
	0x1A60, 0x1A800004,
	0x1A60, 0x0B800005,
	0x1A60, 0x05800006,
	0x1A60, 0x0E800007,
	0x1A60, 0x1A800008,
	0x1A60, 0x0B800009,
	0x1A60, 0x1580000A,
	0x1A60, 0x0880000B,
	0x1A60, 0x1A80000C,
	0x1A60, 0x0B80000D,
	0x1A60, 0x0580000E,
	0x1A60, 0x0E80000F,
	0x1A60, 0x1A800010,
	0x1A60, 0x0B800011,
	0x1A60, 0x15800012,
	0x1A60, 0x08800013,
	0x1A60, 0x1A800014,
	0x1A60, 0x0B800015,
	0x1A60, 0x05800016,
	0x1A60, 0x07800017,
	0x1A60, 0x1A800018,
	0x1A60, 0x0B800019,
	0x1A60, 0x1580001A,
	0x1A60, 0x0880001B,
	0x1A60, 0x1B80001C,
	0x1A60, 0x0B80001D,
	0x1A60, 0x0580001E,
	0x1A60, 0x0780001F,
	0x1A60, 0x1B800020,
	0x1A60, 0x0B800021,
	0x1A60, 0x05800022,
	0x1A60, 0x07800023,
	0x1A60, 0x1B800024,
	0x1A60, 0x0B800025,
	0x1A60, 0x05800026,
	0x1A60, 0x07800027,
	0x1A60, 0x1B800028,
	0x1A60, 0x0B800029,
	0x1A60, 0x0580002A,
	0x1A60, 0x0780002B,
	0x1A60, 0x1B800030,
	0x1A60, 0x0B800031,
	0x1A60, 0x05800032,
	0x1A60, 0x00800033,
	0x1A60, 0x1B800034,
	0x1A60, 0x0B800035,
	0x1A60, 0x05800036,
	0x1A60, 0x00800037,
	0x1A60, 0x1B800038,
	0x1A60, 0x0B800039,
	0x1A60, 0x0580003A,
	0x1A60, 0x0E80803B,
	0x1A94, 0x01000401,
	0x1A98, 0x00188000,
	0x1AA0, 0x00002929,
	0x1AA4, 0x08040201,
	0x1AA8, 0x80402010,
	0x1AAC, 0x77777000,
	0x1AB0, 0x54775477,
	0x1AB4, 0x54775477,
	0x1AB8, 0x00500000,
	0x1ABC, 0x77700000,
	0x1904, 0x00030000,
	0x1914, 0x00030000,
	0x1984, 0x03000000,
	0x1988, 0x00000087,
	0x198C, 0x00000007,
	0x1990, 0xFFAA5500,
	0x1994, 0x00000077,
	0x1998, 0x12801000,
	0x1998, 0x12801000,
	0x1998, 0x12801001,
	0x1998, 0x12801002,
	0x1998, 0x12801003,
	0x1998, 0x12801004,
	0x1998, 0x12801005,
	0x1998, 0x12801006,
	0x1998, 0x12801007,
	0x1998, 0x12801008,
	0x1998, 0x12801009,
	0x1998, 0x1280100A,
	0x1998, 0x1280100B,
	0x1998, 0x1280100C,
	0x1998, 0x1280100D,
	0x1998, 0x1280100E,
	0x1998, 0x1280100F,
	0x1998, 0x12801010,
	0x1998, 0x12801011,
	0x1998, 0x12801012,
	0x1998, 0x12801013,
	0x1998, 0x12801014,
	0x1998, 0x12801015,
	0x1998, 0x12801016,
	0x1998, 0x12801017,
	0x1998, 0x12801018,
	0x1998, 0x12801019,
	0x1998, 0x1280101A,
	0x1998, 0x1280101B,
	0x1998, 0x1280101C,
	0x1998, 0x1280101D,
	0x1998, 0x1280101E,
	0x1998, 0x1280101F,
	0x1998, 0x12801020,
	0x1998, 0x12801021,
	0x1998, 0x12801022,
	0x1998, 0x12801023,
	0x1998, 0x1280102C,
	0x1998, 0x1280102D,
	0x1998, 0x1280102E,
	0x1998, 0x1280102F,
	0x1998, 0x12801030,
	0x1998, 0x12801031,
	0x1998, 0x12801032,
	0x1998, 0x12801033,
	0x1998, 0x12801034,
	0x1998, 0x12801035,
	0x1998, 0x12801036,
	0x1998, 0x12801037,
	0x1998, 0x12801038,
	0x1998, 0x12801039,
	0x1998, 0x1280103A,
	0x1998, 0x1280103B,
	0x1998, 0x1280103C,
	0x1998, 0x1280103D,
	0x1998, 0x1280103E,
	0x1998, 0x1280103F,
	0x1998, 0x12801040,
	0x1998, 0x12801041,
	0x1998, 0x12801042,
	0x1998, 0x12801043,
	0x1998, 0x12801044,
	0x1998, 0x12801045,
	0x1998, 0x12801046,
	0x1998, 0x12801047,
	0x1998, 0x12801048,
	0x1998, 0x12801049,
	0x1998, 0x12801100,
	0x1998, 0x12801101,
	0x1998, 0x12801102,
	0x1998, 0x12801103,
	0x1998, 0x12801104,
	0x1998, 0x12801105,
	0x1998, 0x12801106,
	0x1998, 0x12801107,
	0x1998, 0x12801108,
	0x1998, 0x12801109,
	0x1998, 0x1280110A,
	0x1998, 0x1280110B,
	0x1998, 0x1280110C,
	0x1998, 0x1280110D,
	0x1998, 0x1280110E,
	0x1998, 0x1280110F,
	0x1998, 0x12801110,
	0x1998, 0x12801111,
	0x1998, 0x12801112,
	0x1998, 0x12801113,
	0x1998, 0x12801114,
	0x1998, 0x12801115,
	0x1998, 0x12801116,
	0x1998, 0x12801117,
	0x1998, 0x12801118,
	0x1998, 0x12801119,
	0x1998, 0x1280111A,
	0x1998, 0x1280111B,
	0x1998, 0x1280111C,
	0x1998, 0x1280111D,
	0x1998, 0x1280111E,
	0x1998, 0x1280111F,
	0x1998, 0x12801120,
	0x1998, 0x12801121,
	0x1998, 0x12801122,
	0x1998, 0x12801123,
	0x1998, 0x1280112C,
	0x1998, 0x1280112D,
	0x1998, 0x1280112E,
	0x1998, 0x1280112F,
	0x1998, 0x12801130,
	0x1998, 0x12801131,
	0x1998, 0x12801132,
	0x1998, 0x12801133,
	0x1998, 0x12801134,
	0x1998, 0x12801135,
	0x1998, 0x12801136,
	0x1998, 0x12801137,
	0x1998, 0x12801138,
	0x1998, 0x12801139,
	0x1998, 0x1280113A,
	0x1998, 0x1280113B,
	0x1998, 0x1280113C,
	0x1998, 0x1280113D,
	0x1998, 0x1280113E,
	0x1998, 0x1280113F,
	0x1998, 0x12801140,
	0x1998, 0x12801141,
	0x1998, 0x12801142,
	0x1998, 0x12801143,
	0x1998, 0x12801144,
	0x1998, 0x12801145,
	0x1998, 0x12801146,
	0x1998, 0x12801147,
	0x1998, 0x12801148,
	0x1998, 0x12801149,
	0x1998, 0x12801200,
	0x1998, 0x12801201,
	0x1998, 0x12801202,
	0x1998, 0x12801203,
	0x1998, 0x12801204,
	0x1998, 0x12801205,
	0x1998, 0x12801206,
	0x1998, 0x12801207,
	0x1998, 0x12801208,
	0x1998, 0x12801209,
	0x1998, 0x1280120A,
	0x1998, 0x1280120B,
	0x1998, 0x1280120C,
	0x1998, 0x1280120D,
	0x1998, 0x1280120E,
	0x1998, 0x1280120F,
	0x1998, 0x12801210,
	0x1998, 0x12801211,
	0x1998, 0x12801212,
	0x1998, 0x12801213,
	0x1998, 0x12801214,
	0x1998, 0x12801215,
	0x1998, 0x12801216,
	0x1998, 0x12801217,
	0x1998, 0x12801218,
	0x1998, 0x12801219,
	0x1998, 0x1280121A,
	0x1998, 0x1280121B,
	0x1998, 0x1280121C,
	0x1998, 0x1280121D,
	0x1998, 0x1280121E,
	0x1998, 0x1280121F,
	0x1998, 0x12801220,
	0x1998, 0x12801221,
	0x1998, 0x12801222,
	0x1998, 0x12801223,
	0x1998, 0x1280122C,
	0x1998, 0x1280122D,
	0x1998, 0x1280122E,
	0x1998, 0x1280122F,
	0x1998, 0x12801230,
	0x1998, 0x12801231,
	0x1998, 0x12801232,
	0x1998, 0x12801233,
	0x1998, 0x12801234,
	0x1998, 0x12801235,
	0x1998, 0x12801236,
	0x1998, 0x12801237,
	0x1998, 0x12801238,
	0x1998, 0x12801239,
	0x1998, 0x1280123A,
	0x1998, 0x1280123B,
	0x1998, 0x1280123C,
	0x1998, 0x1280123D,
	0x1998, 0x1280123E,
	0x1998, 0x1280123F,
	0x1998, 0x12801240,
	0x1998, 0x12801241,
	0x1998, 0x12801242,
	0x1998, 0x12801243,
	0x1998, 0x12801244,
	0x1998, 0x12801245,
	0x1998, 0x12801246,
	0x1998, 0x12801247,
	0x1998, 0x12801248,
	0x1998, 0x12801249,
	0x1998, 0x12801300,
	0x1998, 0x12801301,
	0x1998, 0x12801302,
	0x1998, 0x12801303,
	0x1998, 0x12801304,
	0x1998, 0x12801305,
	0x1998, 0x12801306,
	0x1998, 0x12801307,
	0x1998, 0x12801308,
	0x1998, 0x12801309,
	0x1998, 0x1280130A,
	0x1998, 0x1280130B,
	0x1998, 0x1280130C,
	0x1998, 0x1280130D,
	0x1998, 0x1280130E,
	0x1998, 0x1280130F,
	0x1998, 0x12801310,
	0x1998, 0x12801311,
	0x1998, 0x12801312,
	0x1998, 0x12801313,
	0x1998, 0x12801314,
	0x1998, 0x12801315,
	0x1998, 0x12801316,
	0x1998, 0x12801317,
	0x1998, 0x12801318,
	0x1998, 0x12801319,
	0x1998, 0x1280131A,
	0x1998, 0x1280131B,
	0x1998, 0x1280131C,
	0x1998, 0x1280131D,
	0x1998, 0x1280131E,
	0x1998, 0x1280131F,
	0x1998, 0x12801320,
	0x1998, 0x12801321,
	0x1998, 0x12801322,
	0x1998, 0x12801323,
	0x1998, 0x1280132C,
	0x1998, 0x1280132D,
	0x1998, 0x1280132E,
	0x1998, 0x1280132F,
	0x1998, 0x12801330,
	0x1998, 0x12801331,
	0x1998, 0x12801332,
	0x1998, 0x12801333,
	0x1998, 0x12801334,
	0x1998, 0x12801335,
	0x1998, 0x12801336,
	0x1998, 0x12801337,
	0x1998, 0x12801338,
	0x1998, 0x12801339,
	0x1998, 0x1280133A,
	0x1998, 0x1280133B,
	0x1998, 0x1280133C,
	0x1998, 0x1280133D,
	0x1998, 0x1280133E,
	0x1998, 0x1280133F,
	0x1998, 0x12801340,
	0x1998, 0x12801341,
	0x1998, 0x12801342,
	0x1998, 0x12801343,
	0x1998, 0x12801344,
	0x1998, 0x12801345,
	0x1998, 0x12801346,
	0x1998, 0x12801347,
	0x1998, 0x12801348,
	0x1998, 0x12801349,
	0x19D4, 0x88888888,
	0x19D8, 0x00000888,
	0xB00, 0xE3100100,
	0xB00, 0xE7100100,
	0xC60, 0x15808002,
	0xC60, 0x01808003,
	0xE60, 0x15808002,
	0xE60, 0x01808003,
	0x1860, 0x15808002,
	0x1860, 0x01808003,
	0x1A60, 0x15808002,
	0x1A60, 0x01808003,
	0xB00, 0xE3100100,
	0xC5C, 0x0D080058,
	0xE5C, 0x0D080058,
	0x185C, 0x0D080058,
	0x1A5C, 0x0D080058,
	0xC5C, 0x0D000058,
	0xE5C, 0x0D000058,
	0x185C, 0x0D000058,
	0x1A5C, 0x0D000058,
	0xC60, 0x05808002,
	0xC60, 0x0E808003,
	0xE60, 0x05808002,
	0xE60, 0x0E808003,
	0x1860, 0x05808002,
	0x1860, 0x0E808003,
	0x1A60, 0x05808002,
	0x1A60, 0x0E808003,
	0xB00, 0xE7100100,
	0xB00, 0xE3100100,
	0xB00, 0xE3100000,
	0x1C38, 0x00000002,
	0xA00, 0x00D047C8,
	0xA04, 0x46FF800C,
	0xA08, 0x8C838300,
	0xA0C, 0x2E7E000F,
	0xA10, 0x9500BB78,
	0xA14, 0x11144028,
	0xA18, 0x00881117,
	0xA1C, 0x89140F00,
	0xA20, 0x1A1B0030,
	0xA24, 0x090E1317,
	0xA28, 0x00000204,
	0xA2C, 0x00900000,
	0xA70, 0x101FFF00,
	0xA74, 0x00000128,
	0xA78, 0x00000900,
	0xA7C, 0x225B0606,
	0xA80, 0x218075B2,
	0xA84, 0x9C1F8C00,
	0x1B04, 0xE24628D2,
	0x1B10, 0x88010D46,
	0x1B14, 0x00000000,
	0x1B18, 0x00292903,
	0x1B00, 0xF8000000,
	0x1B00, 0xF800D000,
	0x1B00, 0xF801F000,
	0x1B1C, 0xA2123DB2,
	0x1B20, 0x07040001,
	0x1B24, 0x07060807,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0xA0000000,	0x00000000,
	0x1B28, 0xC0060348,
	0xB0000000,	0x00000000,
	0x1B2C, 0x20000003,
	0x1B30, 0x20000000,
	0x1B38, 0x20000000,
	0x1B3C, 0x20000000,
	0x1BD4, 0x00000001,
	0x1B94, 0x80000000,
	0x1B34, 0x00000000,
	0x1B34, 0x00000002,
	0x1B34, 0x00000000,
	0x1B00, 0xF8000002,
	0x1B00, 0xF800D002,
	0x1B00, 0xF801F002,
	0x1B1C, 0xA2123DB2,
	0x1B20, 0x07040001,
	0x1B24, 0x07060807,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0xA0000000,	0x00000000,
	0x1B28, 0xC0060348,
	0xB0000000,	0x00000000,
	0x1B2C, 0x20000003,
	0x1B30, 0x20000000,
	0x1B38, 0x20000000,
	0x1B3C, 0x20000000,
	0x1BD4, 0x00000001,
	0x1B94, 0x80000000,
	0x1B34, 0x00000000,
	0x1B34, 0x00000002,
	0x1B34, 0x00000000,
	0x1B00, 0xF8000004,
	0x1B00, 0xF800D004,
	0x1B00, 0xF801F004,
	0x1B1C, 0xA2123DB2,
	0x1B20, 0x07040001,
	0x1B24, 0x07060807,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0xA0000000,	0x00000000,
	0x1B28, 0xC0060348,
	0xB0000000,	0x00000000,
	0x1B2C, 0x20000003,
	0x1B30, 0x20000000,
	0x1B38, 0x20000000,
	0x1B3C, 0x20000000,
	0x1BD4, 0x00000001,
	0x1B94, 0x80000000,
	0x1B34, 0x00000000,
	0x1B34, 0x00000002,
	0x1B34, 0x00000000,
	0x1B00, 0xF8000006,
	0x1B00, 0xF800D006,
	0x1B00, 0xF801F006,
	0x1B1C, 0xA2123DB2,
	0x1B20, 0x07040001,
	0x1B24, 0x07060807,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B28, 0xC0060324,
	0xA0000000,	0x00000000,
	0x1B28, 0xC0060348,
	0xB0000000,	0x00000000,
	0x1B2C, 0x20000003,
	0x1B30, 0x20000000,
	0x1B38, 0x20000000,
	0x1B3C, 0x20000000,
	0x1BD4, 0x00000001,
	0x1B94, 0x80000000,
	0x1B34, 0x00000000,
	0x1B34, 0x00000002,
	0x1B34, 0x00000000,
	0x1B00, 0xF8000000,
	0x1B80, 0x00000007,
	0x1B80, 0x09060005,
	0x1B80, 0x09060007,
	0x1B80, 0x0FFE0015,
	0x1B80, 0x0FFE0017,
	0x1B80, 0x00240025,
	0x1B80, 0x00240027,
	0x1B80, 0x00040035,
	0x1B80, 0x00040037,
	0x1B80, 0x05C00045,
	0x1B80, 0x05C00047,
	0x1B80, 0x00070055,
	0x1B80, 0x00070057,
	0x1B80, 0x64000065,
	0x1B80, 0x64000067,
	0x1B80, 0x00020075,
	0x1B80, 0x00020077,
	0x1B80, 0x00080085,
	0x1B80, 0x00080087,
	0x1B80, 0x80000095,
	0x1B80, 0x80000097,
	0x1B80, 0x090100A5,
	0x1B80, 0x090100A7,
	0x1B80, 0x0F0200B5,
	0x1B80, 0x0F0200B7,
	0x1B80, 0x002400C5,
	0x1B80, 0x002400C7,
	0x1B80, 0x000400D5,
	0x1B80, 0x000400D7,
	0x1B80, 0x05C000E5,
	0x1B80, 0x05C000E7,
	0x1B80, 0x000700F5,
	0x1B80, 0x000700F7,
	0x1B80, 0x64020105,
	0x1B80, 0x64020107,
	0x1B80, 0x00020115,
	0x1B80, 0x00020117,
	0x1B80, 0x00040125,
	0x1B80, 0x00040127,
	0x1B80, 0x4A000135,
	0x1B80, 0x4A000137,
	0x1B80, 0x4B040145,
	0x1B80, 0x4B040147,
	0x1B80, 0x85030155,
	0x1B80, 0x85030157,
	0x1B80, 0x40010165,
	0x1B80, 0x40010167,
	0x1B80, 0xE0290175,
	0x1B80, 0xE0290177,
	0x1B80, 0x00040185,
	0x1B80, 0x00040187,
	0x1B80, 0x4B050195,
	0x1B80, 0x4B050197,
	0x1B80, 0x860301A5,
	0x1B80, 0x860301A7,
	0x1B80, 0x400301B5,
	0x1B80, 0x400301B7,
	0x1B80, 0xE02901C5,
	0x1B80, 0xE02901C7,
	0x1B80, 0x000401D5,
	0x1B80, 0x000401D7,
	0x1B80, 0x4B0601E5,
	0x1B80, 0x4B0601E7,
	0x1B80, 0x870301F5,
	0x1B80, 0x870301F7,
	0x1B80, 0x40050205,
	0x1B80, 0x40050207,
	0x1B80, 0xE0290215,
	0x1B80, 0xE0290217,
	0x1B80, 0x00040225,
	0x1B80, 0x00040227,
	0x1B80, 0x4B070235,
	0x1B80, 0x4B070237,
	0x1B80, 0x88030245,
	0x1B80, 0x88030247,
	0x1B80, 0x40070255,
	0x1B80, 0x40070257,
	0x1B80, 0xE0290265,
	0x1B80, 0xE0290267,
	0x1B80, 0x4B000275,
	0x1B80, 0x4B000277,
	0x1B80, 0x30000285,
	0x1B80, 0x30000287,
	0x1B80, 0xFE100295,
	0x1B80, 0xFE100297,
	0x1B80, 0xFF1002A5,
	0x1B80, 0xFF1002A7,
	0x1B80, 0xE18602B5,
	0x1B80, 0xE18602B7,
	0x1B80, 0xF00A02C5,
	0x1B80, 0xF00A02C7,
	0x1B80, 0xF10A02D5,
	0x1B80, 0xF10A02D7,
	0x1B80, 0xF20A02E5,
	0x1B80, 0xF20A02E7,
	0x1B80, 0xF30802F5,
	0x1B80, 0xF30802F7,
	0x1B80, 0xF4070305,
	0x1B80, 0xF4070307,
	0x1B80, 0xF5060315,
	0x1B80, 0xF5060317,
	0x1B80, 0xF7060325,
	0x1B80, 0xF7060327,
	0x1B80, 0xF8050335,
	0x1B80, 0xF8050337,
	0x1B80, 0xF9040345,
	0x1B80, 0xF9040347,
	0x1B80, 0x00010355,
	0x1B80, 0x00010357,
	0x1B80, 0x303B0365,
	0x1B80, 0x303B0367,
	0x1B80, 0x30500375,
	0x1B80, 0x30500377,
	0x1B80, 0x305C0385,
	0x1B80, 0x305C0387,
	0x1B80, 0x31D50395,
	0x1B80, 0x31D50397,
	0x1B80, 0x31C503A5,
	0x1B80, 0x31C503A7,
	0x1B80, 0x4D0403B5,
	0x1B80, 0x4D0403B7,
	0x1B80, 0x2EF003C5,
	0x1B80, 0x2EF003C7,
	0x1B80, 0x000203D5,
	0x1B80, 0x000203D7,
	0x1B80, 0x208003E5,
	0x1B80, 0x208003E7,
	0x1B80, 0x000003F5,
	0x1B80, 0x000003F7,
	0x1B80, 0x4D000405,
	0x1B80, 0x4D000407,
	0x1B80, 0x55070415,
	0x1B80, 0x55070417,
	0x1B80, 0xE1230425,
	0x1B80, 0xE1230427,
	0x1B80, 0xE1230435,
	0x1B80, 0xE1230437,
	0x1B80, 0x4D040445,
	0x1B80, 0x4D040447,
	0x1B80, 0x20800455,
	0x1B80, 0x20800457,
	0x1B80, 0x84000465,
	0x1B80, 0x84000467,
	0x1B80, 0x4D000475,
	0x1B80, 0x4D000477,
	0x1B80, 0x550F0485,
	0x1B80, 0x550F0487,
	0x1B80, 0xE1230495,
	0x1B80, 0xE1230497,
	0x1B80, 0x4F0204A5,
	0x1B80, 0x4F0204A7,
	0x1B80, 0x4E0004B5,
	0x1B80, 0x4E0004B7,
	0x1B80, 0x530204C5,
	0x1B80, 0x530204C7,
	0x1B80, 0x520104D5,
	0x1B80, 0x520104D7,
	0x1B80, 0xE12704E5,
	0x1B80, 0xE12704E7,
	0x1B80, 0x000104F5,
	0x1B80, 0x000104F7,
	0x1B80, 0x5C720505,
	0x1B80, 0x5C720507,
	0x1B80, 0xE1320515,
	0x1B80, 0xE1320517,
	0x1B80, 0x54E50525,
	0x1B80, 0x54E50527,
	0x1B80, 0x54BF0535,
	0x1B80, 0x54BF0537,
	0x1B80, 0x54C50545,
	0x1B80, 0x54C50547,
	0x1B80, 0x54BE0555,
	0x1B80, 0x54BE0557,
	0x1B80, 0x54DF0565,
	0x1B80, 0x54DF0567,
	0x1B80, 0x0BA60575,
	0x1B80, 0x0BA60577,
	0x1B80, 0xF3130585,
	0x1B80, 0xF3130587,
	0x1B80, 0xF41E0595,
	0x1B80, 0xF41E0597,
	0x1B80, 0xF53C05A5,
	0x1B80, 0xF53C05A7,
	0x1B80, 0x000105B5,
	0x1B80, 0x000105B7,
	0x1B80, 0x620605C5,
	0x1B80, 0x620605C7,
	0x1B80, 0x600605D5,
	0x1B80, 0x600605D7,
	0x1B80, 0xE1A905E5,
	0x1B80, 0xE1A905E7,
	0x1B80, 0x0C0005F5,
	0x1B80, 0x0C0005F7,
	0x1B80, 0x5C720605,
	0x1B80, 0x5C720607,
	0x1B80, 0xE1320615,
	0x1B80, 0xE1320617,
	0x1B80, 0x5CF10625,
	0x1B80, 0x5CF10627,
	0x1B80, 0x0C010635,
	0x1B80, 0x0C010637,
	0x1B80, 0xF2020645,
	0x1B80, 0xF2020647,
	0x1B80, 0x30D60655,
	0x1B80, 0x30D60657,
	0x1B80, 0x0AC60665,
	0x1B80, 0x0AC60667,
	0x1B80, 0xE1B60675,
	0x1B80, 0xE1B60677,
	0x1B80, 0xE1580685,
	0x1B80, 0xE1580687,
	0x1B80, 0x54E50695,
	0x1B80, 0x54E50697,
	0x1B80, 0x000106A5,
	0x1B80, 0x000106A7,
	0x1B80, 0x560106B5,
	0x1B80, 0x560106B7,
	0x1B80, 0x5CE206C5,
	0x1B80, 0x5CE206C7,
	0x1B80, 0x0AE106D5,
	0x1B80, 0x0AE106D7,
	0x1B80, 0x630C06E5,
	0x1B80, 0x630C06E7,
	0x1B80, 0xE13F06F5,
	0x1B80, 0xE13F06F7,
	0x1B80, 0x00270705,
	0x1B80, 0x00270707,
	0x1B80, 0xE16C0715,
	0x1B80, 0xE16C0717,
	0x1B80, 0x00020725,
	0x1B80, 0x00020727,
	0x1B80, 0x002A0735,
	0x1B80, 0x002A0737,
	0x1B80, 0x07140745,
	0x1B80, 0x07140747,
	0x1B80, 0x00020755,
	0x1B80, 0x00020757,
	0x1B80, 0x30C30765,
	0x1B80, 0x30C30767,
	0x1B80, 0x56010775,
	0x1B80, 0x56010777,
	0x1B80, 0x5CE20785,
	0x1B80, 0x5CE20787,
	0x1B80, 0x0AE10795,
	0x1B80, 0x0AE10797,
	0x1B80, 0x631707A5,
	0x1B80, 0x631707A7,
	0x1B80, 0xE13F07B5,
	0x1B80, 0xE13F07B7,
	0x1B80, 0x002507C5,
	0x1B80, 0x002507C7,
	0x1B80, 0xE16C07D5,
	0x1B80, 0xE16C07D7,
	0x1B80, 0x000207E5,
	0x1B80, 0x000207E7,
	0x1B80, 0x630F07F5,
	0x1B80, 0x630F07F7,
	0x1B80, 0xE13F0805,
	0x1B80, 0xE13F0807,
	0x1B80, 0x63070815,
	0x1B80, 0x63070817,
	0x1B80, 0xE13F0825,
	0x1B80, 0xE13F0827,
	0x1B80, 0x07140835,
	0x1B80, 0x07140837,
	0x1B80, 0x56000845,
	0x1B80, 0x56000847,
	0x1B80, 0x5CF20855,
	0x1B80, 0x5CF20857,
	0x1B80, 0x0AF10865,
	0x1B80, 0x0AF10867,
	0x1B80, 0x07140875,
	0x1B80, 0x07140877,
	0x1B80, 0x07140885,
	0x1B80, 0x07140887,
	0x1B80, 0x630F0895,
	0x1B80, 0x630F0897,
	0x1B80, 0xE13F08A5,
	0x1B80, 0xE13F08A7,
	0x1B80, 0x631708B5,
	0x1B80, 0x631708B7,
	0x1B80, 0xE13F08C5,
	0x1B80, 0xE13F08C7,
	0x1B80, 0x002508D5,
	0x1B80, 0x002508D7,
	0x1B80, 0xE16C08E5,
	0x1B80, 0xE16C08E7,
	0x1B80, 0x000208F5,
	0x1B80, 0x000208F7,
	0x1B80, 0x30C30905,
	0x1B80, 0x30C30907,
	0x1B80, 0xE1A90915,
	0x1B80, 0xE1A90917,
	0x1B80, 0x62060925,
	0x1B80, 0x62060927,
	0x1B80, 0x60060935,
	0x1B80, 0x60060937,
	0x1B80, 0xE1160945,
	0x1B80, 0xE1160947,
	0x1B80, 0x54BE0955,
	0x1B80, 0x54BE0957,
	0x1B80, 0x56010965,
	0x1B80, 0x56010967,
	0x1B80, 0x5CE20975,
	0x1B80, 0x5CE20977,
	0x1B80, 0x0AE10985,
	0x1B80, 0x0AE10987,
	0x1B80, 0x633A0995,
	0x1B80, 0x633A0997,
	0x1B80, 0xE13F09A5,
	0x1B80, 0xE13F09A7,
	0x1B80, 0x633709B5,
	0x1B80, 0x633709B7,
	0x1B80, 0xE13F09C5,
	0x1B80, 0xE13F09C7,
	0x1B80, 0x632F09D5,
	0x1B80, 0x632F09D7,
	0x1B80, 0xE13F09E5,
	0x1B80, 0xE13F09E7,
	0x1B80, 0x632709F5,
	0x1B80, 0x632709F7,
	0x1B80, 0xE13F0A05,
	0x1B80, 0xE13F0A07,
	0x1B80, 0x631F0A15,
	0x1B80, 0x631F0A17,
	0x1B80, 0xE13F0A25,
	0x1B80, 0xE13F0A27,
	0x1B80, 0x63170A35,
	0x1B80, 0x63170A37,
	0x1B80, 0xE13F0A45,
	0x1B80, 0xE13F0A47,
	0x1B80, 0x630F0A55,
	0x1B80, 0x630F0A57,
	0x1B80, 0xE13F0A65,
	0x1B80, 0xE13F0A67,
	0x1B80, 0x63070A75,
	0x1B80, 0x63070A77,
	0x1B80, 0xE13F0A85,
	0x1B80, 0xE13F0A87,
	0x1B80, 0xE16C0A95,
	0x1B80, 0xE16C0A97,
	0x1B80, 0x56000AA5,
	0x1B80, 0x56000AA7,
	0x1B80, 0x5CF20AB5,
	0x1B80, 0x5CF20AB7,
	0x1B80, 0x0AF10AC5,
	0x1B80, 0x0AF10AC7,
	0x1B80, 0xF5040AD5,
	0x1B80, 0xF5040AD7,
	0x1B80, 0xE13F0AE5,
	0x1B80, 0xE13F0AE7,
	0x1B80, 0xE16C0AF5,
	0x1B80, 0xE16C0AF7,
	0x1B80, 0x30B30B05,
	0x1B80, 0x30B30B07,
	0x1B80, 0x07140B15,
	0x1B80, 0x07140B17,
	0x1B80, 0x07140B25,
	0x1B80, 0x07140B27,
	0x1B80, 0x630F0B35,
	0x1B80, 0x630F0B37,
	0x1B80, 0xE13F0B45,
	0x1B80, 0xE13F0B47,
	0x1B80, 0x63170B55,
	0x1B80, 0x63170B57,
	0x1B80, 0xE13F0B65,
	0x1B80, 0xE13F0B67,
	0x1B80, 0x631F0B75,
	0x1B80, 0x631F0B77,
	0x1B80, 0xE13F0B85,
	0x1B80, 0xE13F0B87,
	0x1B80, 0x63270B95,
	0x1B80, 0x63270B97,
	0x1B80, 0xE13F0BA5,
	0x1B80, 0xE13F0BA7,
	0x1B80, 0x632F0BB5,
	0x1B80, 0x632F0BB7,
	0x1B80, 0xE13F0BC5,
	0x1B80, 0xE13F0BC7,
	0x1B80, 0x63370BD5,
	0x1B80, 0x63370BD7,
	0x1B80, 0xE13F0BE5,
	0x1B80, 0xE13F0BE7,
	0x1B80, 0x633A0BF5,
	0x1B80, 0x633A0BF7,
	0x1B80, 0xE13F0C05,
	0x1B80, 0xE13F0C07,
	0x1B80, 0xF60B0C15,
	0x1B80, 0xF60B0C17,
	0x1B80, 0xF7170C25,
	0x1B80, 0xF7170C27,
	0x1B80, 0x4D300C35,
	0x1B80, 0x4D300C37,
	0x1B80, 0x57040C45,
	0x1B80, 0x57040C47,
	0x1B80, 0x57000C55,
	0x1B80, 0x57000C57,
	0x1B80, 0x96000C65,
	0x1B80, 0x96000C67,
	0x1B80, 0x57080C75,
	0x1B80, 0x57080C77,
	0x1B80, 0x57000C85,
	0x1B80, 0x57000C87,
	0x1B80, 0x95000C95,
	0x1B80, 0x95000C97,
	0x1B80, 0x4D000CA5,
	0x1B80, 0x4D000CA7,
	0x1B80, 0x6C070CB5,
	0x1B80, 0x6C070CB7,
	0x1B80, 0x00010CC5,
	0x1B80, 0x00010CC7,
	0x1B80, 0x00220CD5,
	0x1B80, 0x00220CD7,
	0x1B80, 0x06140CE5,
	0x1B80, 0x06140CE7,
	0x1B80, 0xE16C0CF5,
	0x1B80, 0xE16C0CF7,
	0x1B80, 0x00020D05,
	0x1B80, 0x00020D07,
	0x1B80, 0x00250D15,
	0x1B80, 0x00250D17,
	0x1B80, 0x06140D25,
	0x1B80, 0x06140D27,
	0x1B80, 0xE16C0D35,
	0x1B80, 0xE16C0D37,
	0x1B80, 0x00020D45,
	0x1B80, 0x00020D47,
	0x1B80, 0x00010D55,
	0x1B80, 0x00010D57,
	0x1B80, 0x00320D65,
	0x1B80, 0x00320D67,
	0x1B80, 0xE16C0D75,
	0x1B80, 0xE16C0D77,
	0x1B80, 0x00020D85,
	0x1B80, 0x00020D87,
	0x1B80, 0xE1860D95,
	0x1B80, 0xE1860D97,
	0x1B80, 0xE1B60DA5,
	0x1B80, 0xE1B60DA7,
	0x1B80, 0x5CD10DB5,
	0x1B80, 0x5CD10DB7,
	0x1B80, 0x673A0DC5,
	0x1B80, 0x673A0DC7,
	0x1B80, 0xE1230DD5,
	0x1B80, 0xE1230DD7,
	0x1B80, 0xF80B0DE5,
	0x1B80, 0xF80B0DE7,
	0x1B80, 0xF9110DF5,
	0x1B80, 0xF9110DF7,
	0x1B80, 0xE1580E05,
	0x1B80, 0xE1580E07,
	0x1B80, 0x67370E15,
	0x1B80, 0x67370E17,
	0x1B80, 0xE1580E25,
	0x1B80, 0xE1580E27,
	0x1B80, 0x672F0E35,
	0x1B80, 0x672F0E37,
	0x1B80, 0xE1580E45,
	0x1B80, 0xE1580E47,
	0x1B80, 0x67270E55,
	0x1B80, 0x67270E57,
	0x1B80, 0xE1580E65,
	0x1B80, 0xE1580E67,
	0x1B80, 0x671F0E75,
	0x1B80, 0x671F0E77,
	0x1B80, 0xE1580E85,
	0x1B80, 0xE1580E87,
	0x1B80, 0x67170E95,
	0x1B80, 0x67170E97,
	0x1B80, 0xE1580EA5,
	0x1B80, 0xE1580EA7,
	0x1B80, 0xF8020EB5,
	0x1B80, 0xF8020EB7,
	0x1B80, 0x30EE0EC5,
	0x1B80, 0x30EE0EC7,
	0x1B80, 0xE0D10ED5,
	0x1B80, 0xE0D10ED7,
	0x1B80, 0x670F0EE5,
	0x1B80, 0x670F0EE7,
	0x1B80, 0xE1580EF5,
	0x1B80, 0xE1580EF7,
	0x1B80, 0x67070F05,
	0x1B80, 0x67070F07,
	0x1B80, 0xE1580F15,
	0x1B80, 0xE1580F17,
	0x1B80, 0xF9020F25,
	0x1B80, 0xF9020F27,
	0x1B80, 0x30F50F35,
	0x1B80, 0x30F50F37,
	0x1B80, 0xE0CD0F45,
	0x1B80, 0xE0CD0F47,
	0x1B80, 0x06140F55,
	0x1B80, 0x06140F57,
	0x1B80, 0xE16C0F65,
	0x1B80, 0xE16C0F67,
	0x1B80, 0x5CF10F75,
	0x1B80, 0x5CF10F77,
	0x1B80, 0xE1580F85,
	0x1B80, 0xE1580F87,
	0x1B80, 0x06140F95,
	0x1B80, 0x06140F97,
	0x1B80, 0xE16C0FA5,
	0x1B80, 0xE16C0FA7,
	0x1B80, 0xF9020FB5,
	0x1B80, 0xF9020FB7,
	0x1B80, 0x30FF0FC5,
	0x1B80, 0x30FF0FC7,
	0x1B80, 0xE0CD0FD5,
	0x1B80, 0xE0CD0FD7,
	0x1B80, 0x31130FE5,
	0x1B80, 0x31130FE7,
	0x1B80, 0x670F0FF5,
	0x1B80, 0x670F0FF7,
	0x1B80, 0xE1581005,
	0x1B80, 0xE1581007,
	0x1B80, 0x67171015,
	0x1B80, 0x67171017,
	0x1B80, 0xE1581025,
	0x1B80, 0xE1581027,
	0x1B80, 0xF8021035,
	0x1B80, 0xF8021037,
	0x1B80, 0x31071045,
	0x1B80, 0x31071047,
	0x1B80, 0xE0D11055,
	0x1B80, 0xE0D11057,
	0x1B80, 0x31131065,
	0x1B80, 0x31131067,
	0x1B80, 0x670F1075,
	0x1B80, 0x670F1077,
	0x1B80, 0xE1581085,
	0x1B80, 0xE1581087,
	0x1B80, 0x671F1095,
	0x1B80, 0x671F1097,
	0x1B80, 0xE15810A5,
	0x1B80, 0xE15810A7,
	0x1B80, 0x672710B5,
	0x1B80, 0x672710B7,
	0x1B80, 0xE15810C5,
	0x1B80, 0xE15810C7,
	0x1B80, 0x672F10D5,
	0x1B80, 0x672F10D7,
	0x1B80, 0xE15810E5,
	0x1B80, 0xE15810E7,
	0x1B80, 0x673710F5,
	0x1B80, 0x673710F7,
	0x1B80, 0xE1581105,
	0x1B80, 0xE1581107,
	0x1B80, 0x673A1115,
	0x1B80, 0x673A1117,
	0x1B80, 0xE1581125,
	0x1B80, 0xE1581127,
	0x1B80, 0x4D101135,
	0x1B80, 0x4D101137,
	0x1B80, 0x30C41145,
	0x1B80, 0x30C41147,
	0x1B80, 0x00011155,
	0x1B80, 0x00011157,
	0x1B80, 0x6F241165,
	0x1B80, 0x6F241167,
	0x1B80, 0x6E401175,
	0x1B80, 0x6E401177,
	0x1B80, 0x6D001185,
	0x1B80, 0x6D001187,
	0x1B80, 0x55031195,
	0x1B80, 0x55031197,
	0x1B80, 0x312311A5,
	0x1B80, 0x312311A7,
	0x1B80, 0x6F1C11B5,
	0x1B80, 0x6F1C11B7,
	0x1B80, 0x6E4011C5,
	0x1B80, 0x6E4011C7,
	0x1B80, 0x550B11D5,
	0x1B80, 0x550B11D7,
	0x1B80, 0x312311E5,
	0x1B80, 0x312311E7,
	0x1B80, 0x061C11F5,
	0x1B80, 0x061C11F7,
	0x1B80, 0x54DE1205,
	0x1B80, 0x54DE1207,
	0x1B80, 0x06DC1215,
	0x1B80, 0x06DC1217,
	0x1B80, 0x55131225,
	0x1B80, 0x55131227,
	0x1B80, 0x74011235,
	0x1B80, 0x74011237,
	0x1B80, 0x74001245,
	0x1B80, 0x74001247,
	0x1B80, 0x8E001255,
	0x1B80, 0x8E001257,
	0x1B80, 0x00011265,
	0x1B80, 0x00011267,
	0x1B80, 0x57021275,
	0x1B80, 0x57021277,
	0x1B80, 0x57001285,
	0x1B80, 0x57001287,
	0x1B80, 0x97001295,
	0x1B80, 0x97001297,
	0x1B80, 0x000112A5,
	0x1B80, 0x000112A7,
	0x1B80, 0x54BF12B5,
	0x1B80, 0x54BF12B7,
	0x1B80, 0x54C112C5,
	0x1B80, 0x54C112C7,
	0x1B80, 0x54A212D5,
	0x1B80, 0x54A212D7,
	0x1B80, 0x54C012E5,
	0x1B80, 0x54C012E7,
	0x1B80, 0x54A112F5,
	0x1B80, 0x54A112F7,
	0x1B80, 0x54DF1305,
	0x1B80, 0x54DF1307,
	0x1B80, 0x00011315,
	0x1B80, 0x00011317,
	0x1B80, 0x55001325,
	0x1B80, 0x55001327,
	0x1B80, 0xE1231335,
	0x1B80, 0xE1231337,
	0x1B80, 0x54811345,
	0x1B80, 0x54811347,
	0x1B80, 0xE1231355,
	0x1B80, 0xE1231357,
	0x1B80, 0x54801365,
	0x1B80, 0x54801367,
	0x1B80, 0x002A1375,
	0x1B80, 0x002A1377,
	0x1B80, 0xE12B1385,
	0x1B80, 0xE12B1387,
	0x1B80, 0xE1231395,
	0x1B80, 0xE1231397,
	0x1B80, 0x548013A5,
	0x1B80, 0x548013A7,
	0x1B80, 0xE17213B5,
	0x1B80, 0xE17213B7,
	0x1B80, 0xBF3013C5,
	0x1B80, 0xBF3013C7,
	0x1B80, 0x000213D5,
	0x1B80, 0x000213D7,
	0x1B80, 0x302813E5,
	0x1B80, 0x302813E7,
	0x1B80, 0x4F7813F5,
	0x1B80, 0x4F7813F7,
	0x1B80, 0x4E001405,
	0x1B80, 0x4E001407,
	0x1B80, 0x53871415,
	0x1B80, 0x53871417,
	0x1B80, 0x52F11425,
	0x1B80, 0x52F11427,
	0x1B80, 0xE1161435,
	0x1B80, 0xE1161437,
	0x1B80, 0xE11B1445,
	0x1B80, 0xE11B1447,
	0x1B80, 0xE11F1455,
	0x1B80, 0xE11F1457,
	0x1B80, 0xE1271465,
	0x1B80, 0xE1271467,
	0x1B80, 0x54811475,
	0x1B80, 0x54811477,
	0x1B80, 0xE1161485,
	0x1B80, 0xE1161487,
	0x1B80, 0xE11B1495,
	0x1B80, 0xE11B1497,
	0x1B80, 0xE11F14A5,
	0x1B80, 0xE11F14A7,
	0x1B80, 0xE12714B5,
	0x1B80, 0xE12714B7,
	0x1B80, 0x548014C5,
	0x1B80, 0x548014C7,
	0x1B80, 0x002A14D5,
	0x1B80, 0x002A14D7,
	0x1B80, 0xE12B14E5,
	0x1B80, 0xE12B14E7,
	0x1B80, 0xE11614F5,
	0x1B80, 0xE11614F7,
	0x1B80, 0xE11B1505,
	0x1B80, 0xE11B1507,
	0x1B80, 0xE11F1515,
	0x1B80, 0xE11F1517,
	0x1B80, 0xE1271525,
	0x1B80, 0xE1271527,
	0x1B80, 0x54801535,
	0x1B80, 0x54801537,
	0x1B80, 0xE1721545,
	0x1B80, 0xE1721547,
	0x1B80, 0xBF171555,
	0x1B80, 0xBF171557,
	0x1B80, 0x00021565,
	0x1B80, 0x00021567,
	0x1B80, 0x30281575,
	0x1B80, 0x30281577,
	0x1B80, 0x06141585,
	0x1B80, 0x06141587,
	0x1B80, 0x73201595,
	0x1B80, 0x73201597,
	0x1B80, 0x720015A5,
	0x1B80, 0x720015A7,
	0x1B80, 0x710015B5,
	0x1B80, 0x710015B7,
	0x1B80, 0x550115C5,
	0x1B80, 0x550115C7,
	0x1B80, 0xE12315D5,
	0x1B80, 0xE12315D7,
	0x1B80, 0xE12715E5,
	0x1B80, 0xE12715E7,
	0x1B80, 0x548115F5,
	0x1B80, 0x548115F7,
	0x1B80, 0xE1231605,
	0x1B80, 0xE1231607,
	0x1B80, 0xE1271615,
	0x1B80, 0xE1271617,
	0x1B80, 0x54801625,
	0x1B80, 0x54801627,
	0x1B80, 0x002A1635,
	0x1B80, 0x002A1637,
	0x1B80, 0xE12B1645,
	0x1B80, 0xE12B1647,
	0x1B80, 0xE1231655,
	0x1B80, 0xE1231657,
	0x1B80, 0xE1271665,
	0x1B80, 0xE1271667,
	0x1B80, 0x54801675,
	0x1B80, 0x54801677,
	0x1B80, 0xE1721685,
	0x1B80, 0xE1721687,
	0x1B80, 0xBF031695,
	0x1B80, 0xBF031697,
	0x1B80, 0x000216A5,
	0x1B80, 0x000216A7,
	0x1B80, 0x302816B5,
	0x1B80, 0x302816B7,
	0x1B80, 0x54BF16C5,
	0x1B80, 0x54BF16C7,
	0x1B80, 0x54C516D5,
	0x1B80, 0x54C516D7,
	0x1B80, 0x050A16E5,
	0x1B80, 0x050A16E7,
	0x1B80, 0x071416F5,
	0x1B80, 0x071416F7,
	0x1B80, 0x54DF1705,
	0x1B80, 0x54DF1707,
	0x1B80, 0x00011715,
	0x1B80, 0x00011717,
	0x1B80, 0x54BF1725,
	0x1B80, 0x54BF1727,
	0x1B80, 0x54C01735,
	0x1B80, 0x54C01737,
	0x1B80, 0x54A31745,
	0x1B80, 0x54A31747,
	0x1B80, 0x54C11755,
	0x1B80, 0x54C11757,
	0x1B80, 0x54A41765,
	0x1B80, 0x54A41767,
	0x1B80, 0x4C831775,
	0x1B80, 0x4C831777,
	0x1B80, 0x4C031785,
	0x1B80, 0x4C031787,
	0x1B80, 0xBF0B1795,
	0x1B80, 0xBF0B1797,
	0x1B80, 0x54C217A5,
	0x1B80, 0x54C217A7,
	0x1B80, 0x54A417B5,
	0x1B80, 0x54A417B7,
	0x1B80, 0x4C8517C5,
	0x1B80, 0x4C8517C7,
	0x1B80, 0x4C0517D5,
	0x1B80, 0x4C0517D7,
	0x1B80, 0xBF0617E5,
	0x1B80, 0xBF0617E7,
	0x1B80, 0x54C117F5,
	0x1B80, 0x54C117F7,
	0x1B80, 0x54A31805,
	0x1B80, 0x54A31807,
	0x1B80, 0x4C861815,
	0x1B80, 0x4C861817,
	0x1B80, 0x4C061825,
	0x1B80, 0x4C061827,
	0x1B80, 0xBF011835,
	0x1B80, 0xBF011837,
	0x1B80, 0x54DF1845,
	0x1B80, 0x54DF1847,
	0x1B80, 0x00011855,
	0x1B80, 0x00011857,
	0x1B80, 0x00071865,
	0x1B80, 0x00071867,
	0x1B80, 0x54011875,
	0x1B80, 0x54011877,
	0x1B80, 0x00041885,
	0x1B80, 0x00041887,
	0x1B80, 0x56001895,
	0x1B80, 0x56001897,
	0x1B80, 0x5CF218A5,
	0x1B80, 0x5CF218A7,
	0x1B80, 0x630718B5,
	0x1B80, 0x630718B7,
	0x1B80, 0x620418C5,
	0x1B80, 0x620418C7,
	0x1B80, 0x610018D5,
	0x1B80, 0x610018D7,
	0x1B80, 0x670718E5,
	0x1B80, 0x670718E7,
	0x1B80, 0x660618F5,
	0x1B80, 0x660618F7,
	0x1B80, 0x6F201905,
	0x1B80, 0x6F201907,
	0x1B80, 0x6E001915,
	0x1B80, 0x6E001917,
	0x1B80, 0x6D001925,
	0x1B80, 0x6D001927,
	0x1B80, 0x6C031935,
	0x1B80, 0x6C031937,
	0x1B80, 0x73201945,
	0x1B80, 0x73201947,
	0x1B80, 0x72001955,
	0x1B80, 0x72001957,
	0x1B80, 0x71001965,
	0x1B80, 0x71001967,
	0x1B80, 0x7B201975,
	0x1B80, 0x7B201977,
	0x1B80, 0x7A001985,
	0x1B80, 0x7A001987,
	0x1B80, 0x79001995,
	0x1B80, 0x79001997,
	0x1B80, 0x7F2019A5,
	0x1B80, 0x7F2019A7,
	0x1B80, 0x7E0019B5,
	0x1B80, 0x7E0019B7,
	0x1B80, 0x7D0019C5,
	0x1B80, 0x7D0019C7,
	0x1B80, 0x090119D5,
	0x1B80, 0x090119D7,
	0x1B80, 0x0AC619E5,
	0x1B80, 0x0AC619E7,
	0x1B80, 0x0BA619F5,
	0x1B80, 0x0BA619F7,
	0x1B80, 0x0C011A05,
	0x1B80, 0x0C011A07,
	0x1B80, 0x0D021A15,
	0x1B80, 0x0D021A17,
	0x1B80, 0x0E041A25,
	0x1B80, 0x0E041A27,
	0x1B80, 0x0FFF1A35,
	0x1B80, 0x0FFF1A37,
	0x1B80, 0x4D041A45,
	0x1B80, 0x4D041A47,
	0x1B80, 0x28F81A55,
	0x1B80, 0x28F81A57,
	0x1B80, 0xE0001A65,
	0x1B80, 0xE0001A67,
	0x1B80, 0x4D001A75,
	0x1B80, 0x4D001A77,
	0x1B80, 0x00011A85,
	0x1B80, 0x00011A87,
	0x1B80, 0x4D041A95,
	0x1B80, 0x4D041A97,
	0x1B80, 0x2EF81AA5,
	0x1B80, 0x2EF81AA7,
	0x1B80, 0x00021AB5,
	0x1B80, 0x00021AB7,
	0x1B80, 0x23031AC5,
	0x1B80, 0x23031AC7,
	0x1B80, 0x00001AD5,
	0x1B80, 0x00001AD7,
	0x1B80, 0x23131AE5,
	0x1B80, 0x23131AE7,
	0x1B80, 0xE77F1AF5,
	0x1B80, 0xE77F1AF7,
	0x1B80, 0x232F1B05,
	0x1B80, 0x232F1B07,
	0x1B80, 0xEFBF1B15,
	0x1B80, 0xEFBF1B17,
	0x1B80, 0x2EF01B25,
	0x1B80, 0x2EF01B27,
	0x1B80, 0x00021B35,
	0x1B80, 0x00021B37,
	0x1B80, 0x4D001B45,
	0x1B80, 0x4D001B47,
	0x1B80, 0x00011B55,
	0x1B80, 0x00011B57,
	0x1B80, 0x4D041B65,
	0x1B80, 0x4D041B67,
	0x1B80, 0x2EF81B75,
	0x1B80, 0x2EF81B77,
	0x1B80, 0x00021B85,
	0x1B80, 0x00021B87,
	0x1B80, 0x23031B95,
	0x1B80, 0x23031B97,
	0x1B80, 0x00001BA5,
	0x1B80, 0x00001BA7,
	0x1B80, 0x23131BB5,
	0x1B80, 0x23131BB7,
	0x1B80, 0xE77F1BC5,
	0x1B80, 0xE77F1BC7,
	0x1B80, 0x232F1BD5,
	0x1B80, 0x232F1BD7,
	0x1B80, 0xE79F1BE5,
	0x1B80, 0xE79F1BE7,
	0x1B80, 0x2EF01BF5,
	0x1B80, 0x2EF01BF7,
	0x1B80, 0x00021C05,
	0x1B80, 0x00021C07,
	0x1B80, 0x28F81C15,
	0x1B80, 0x28F81C17,
	0x1B80, 0x80001C25,
	0x1B80, 0x80001C27,
	0x1B80, 0x4D001C35,
	0x1B80, 0x4D001C37,
	0x1B80, 0x00011C45,
	0x1B80, 0x00011C47,
	0x1B80, 0x00041C55,
	0x1B80, 0x00041C57,
	0x1B80, 0x6BC01C65,
	0x1B80, 0x6BC01C67,
	0x1B80, 0x4D041C75,
	0x1B80, 0x4D041C77,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241C85,
	0x1B80, 0x68241C87,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241C85,
	0x1B80, 0x68241C87,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241C85,
	0x1B80, 0x68241C87,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241C85,
	0x1B80, 0x68241C87,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241C85,
	0x1B80, 0x68241C87,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241C85,
	0x1B80, 0x68241C87,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241C85,
	0x1B80, 0x68241C87,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241C85,
	0x1B80, 0x68241C87,
	0xA0000000,	0x00000000,
	0x1B80, 0x68481C85,
	0x1B80, 0x68481C87,
	0xB0000000,	0x00000000,
	0x1B80, 0x66061C95,
	0x1B80, 0x66061C97,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x650C1CA5,
	0x1B80, 0x650C1CA7,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x650C1CA5,
	0x1B80, 0x650C1CA7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x650C1CA5,
	0x1B80, 0x650C1CA7,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x650C1CA5,
	0x1B80, 0x650C1CA7,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x650C1CA5,
	0x1B80, 0x650C1CA7,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x650C1CA5,
	0x1B80, 0x650C1CA7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x650C1CA5,
	0x1B80, 0x650C1CA7,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x650C1CA5,
	0x1B80, 0x650C1CA7,
	0xA0000000,	0x00000000,
	0x1B80, 0x65041CA5,
	0x1B80, 0x65041CA7,
	0xB0000000,	0x00000000,
	0x1B80, 0x64471CB5,
	0x1B80, 0x64471CB7,
	0x1B80, 0x23411CC5,
	0x1B80, 0x23411CC7,
	0x1B80, 0x100E1CD5,
	0x1B80, 0x100E1CD7,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60101CE5,
	0x1B80, 0x60101CE7,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60101CE5,
	0x1B80, 0x60101CE7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60101CE5,
	0x1B80, 0x60101CE7,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60101CE5,
	0x1B80, 0x60101CE7,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60101CE5,
	0x1B80, 0x60101CE7,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60101CE5,
	0x1B80, 0x60101CE7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60101CE5,
	0x1B80, 0x60101CE7,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60101CE5,
	0x1B80, 0x60101CE7,
	0xA0000000,	0x00000000,
	0x1B80, 0x60011CE5,
	0x1B80, 0x60011CE7,
	0xB0000000,	0x00000000,
	0x1B80, 0x23411CF5,
	0x1B80, 0x23411CF7,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60811D05,
	0x1B80, 0x60811D07,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60811D05,
	0x1B80, 0x60811D07,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60811D05,
	0x1B80, 0x60811D07,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60811D05,
	0x1B80, 0x60811D07,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60811D05,
	0x1B80, 0x60811D07,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60811D05,
	0x1B80, 0x60811D07,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60811D05,
	0x1B80, 0x60811D07,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60811D05,
	0x1B80, 0x60811D07,
	0xA0000000,	0x00000000,
	0x1B80, 0x60611D05,
	0x1B80, 0x60611D07,
	0xB0000000,	0x00000000,
	0x1B80, 0x23411D15,
	0x1B80, 0x23411D17,
	0x1B80, 0x70E11D25,
	0x1B80, 0x70E11D27,
	0x1B80, 0x4D001D35,
	0x1B80, 0x4D001D37,
	0x1B80, 0x00011D45,
	0x1B80, 0x00011D47,
	0x1B80, 0x00041D55,
	0x1B80, 0x00041D57,
	0x1B80, 0x6B401D65,
	0x1B80, 0x6B401D67,
	0x1B80, 0x4D041D75,
	0x1B80, 0x4D041D77,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241D85,
	0x1B80, 0x68241D87,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241D85,
	0x1B80, 0x68241D87,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241D85,
	0x1B80, 0x68241D87,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241D85,
	0x1B80, 0x68241D87,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241D85,
	0x1B80, 0x68241D87,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x68241D85,
	0x1B80, 0x68241D87,
	0xA0000000,	0x00000000,
	0x1B80, 0x68481D85,
	0x1B80, 0x68481D87,
	0xB0000000,	0x00000000,
	0x1B80, 0x66061D95,
	0x1B80, 0x66061D97,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x65081DA5,
	0x1B80, 0x65081DA7,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x65181DA5,
	0x1B80, 0x65181DA7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x65181DA5,
	0x1B80, 0x65181DA7,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x65181DA5,
	0x1B80, 0x65181DA7,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x65181DA5,
	0x1B80, 0x65181DA7,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x65081DA5,
	0x1B80, 0x65081DA7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x65181DA5,
	0x1B80, 0x65181DA7,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x65181DA5,
	0x1B80, 0x65181DA7,
	0xA0000000,	0x00000000,
	0x1B80, 0x65081DA5,
	0x1B80, 0x65081DA7,
	0xB0000000,	0x00000000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x64481DB5,
	0x1B80, 0x64481DB7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x64481DB5,
	0x1B80, 0x64481DB7,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x64481DB5,
	0x1B80, 0x64481DB7,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x64481DB5,
	0x1B80, 0x64481DB7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x64481DB5,
	0x1B80, 0x64481DB7,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x64481DB5,
	0x1B80, 0x64481DB7,
	0xA0000000,	0x00000000,
	0x1B80, 0x64471DB5,
	0x1B80, 0x64471DB7,
	0xB0000000,	0x00000000,
	0x1B80, 0x23411DC5,
	0x1B80, 0x23411DC7,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x11E41DD5,
	0x1B80, 0x11E41DD7,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x11E81DD5,
	0x1B80, 0x11E81DD7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x11E81DD5,
	0x1B80, 0x11E81DD7,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x11E81DD5,
	0x1B80, 0x11E81DD7,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x11E81DD5,
	0x1B80, 0x11E81DD7,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x11E41DD5,
	0x1B80, 0x11E41DD7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x11E81DD5,
	0x1B80, 0x11E81DD7,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x11E81DD5,
	0x1B80, 0x11E81DD7,
	0xA0000000,	0x00000000,
	0x1B80, 0x11E41DD5,
	0x1B80, 0x11E41DD7,
	0xB0000000,	0x00000000,
	0x1B80, 0x60011DE5,
	0x1B80, 0x60011DE7,
	0x1B80, 0x23411DF5,
	0x1B80, 0x23411DF7,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60E11E05,
	0x1B80, 0x60E11E07,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x61E11E05,
	0x1B80, 0x61E11E07,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x61E11E05,
	0x1B80, 0x61E11E07,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x61E11E05,
	0x1B80, 0x61E11E07,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x61E11E05,
	0x1B80, 0x61E11E07,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x60E11E05,
	0x1B80, 0x60E11E07,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x61E11E05,
	0x1B80, 0x61E11E07,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0x1B80, 0x61E11E05,
	0x1B80, 0x61E11E07,
	0xA0000000,	0x00000000,
	0x1B80, 0x60E11E05,
	0x1B80, 0x60E11E07,
	0xB0000000,	0x00000000,
	0x1B80, 0x23411E15,
	0x1B80, 0x23411E17,
	0x1B80, 0x70611E25,
	0x1B80, 0x70611E27,
	0x1B80, 0x4D001E35,
	0x1B80, 0x4D001E37,
	0x1B80, 0x00011E45,
	0x1B80, 0x00011E47,
	0x1B80, 0x00001E55,
	0x1B80, 0x00001E57,
	0x1B80, 0x00001E65,
	0x1B80, 0x00001E67,
	0x1B80, 0x00001E75,
	0x1B80, 0x00001E77,
	0x1B80, 0x00001E85,
	0x1B80, 0x00001E87,
	0x1B80, 0x00001E95,
	0x1B80, 0x00001E97,
	0x1B80, 0x00001EA5,
	0x1B80, 0x00001EA7,
	0x1B80, 0x00001EB5,
	0x1B80, 0x00001EB7,
	0x1B80, 0x00001EC5,
	0x1B80, 0x00001EC7,
	0x1B80, 0x00001ED5,
	0x1B80, 0x00001ED7,
	0x1B80, 0x00001EE5,
	0x1B80, 0x00001EE7,
	0x1B80, 0x00001EF5,
	0x1B80, 0x00001EF7,
	0x1B80, 0x00001F05,
	0x1B80, 0x00001F07,
	0x1B80, 0x00001F15,
	0x1B80, 0x00001F17,
	0x1B80, 0x00001F25,
	0x1B80, 0x00001F27,
	0x1B80, 0x00001F35,
	0x1B80, 0x00001F37,
	0x1B80, 0x00001F45,
	0x1B80, 0x00001F47,
	0x1B80, 0x00001F55,
	0x1B80, 0x00001F57,
	0x1B80, 0x00001F65,
	0x1B80, 0x00001F67,
	0x1B80, 0x00001F75,
	0x1B80, 0x00001F77,
	0x1B80, 0x00001F85,
	0x1B80, 0x00001F87,
	0x1B80, 0x00001F95,
	0x1B80, 0x00001F97,
	0x1B80, 0x00001FA5,
	0x1B80, 0x00001FA7,
	0x1B80, 0x00001FB5,
	0x1B80, 0x00001FB7,
	0x1B80, 0x00001FC5,
	0x1B80, 0x00001FC7,
	0x1B80, 0x00001FD5,
	0x1B80, 0x00001FD7,
	0x1B80, 0x00001FE5,
	0x1B80, 0x00001FE7,
	0x1B80, 0x00001FF5,
	0x1B80, 0x00001FF7,
	0x1B80, 0x00000006,
	0x1B80, 0x00000002,
};

RTW_DECL_TABLE_PHY_COND(rtw8814a_bb, rtw_phy_cfg_bb);

static const struct rtw_phy_pg_cfg_pair rtw8814a_bb_pg[] = {
	{ 0, 0, 0, 0x00000c20, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c24, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c28, 0xffffffff, 0x30323434, },
	{ 0, 0, 0, 0x00000c2c, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c30, 0xffffffff, 0x28303234, },
	{ 0, 0, 1, 0x00000c34, 0xffffffff, 0x32323232, },
	{ 0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032, },
	{ 0, 0, 2, 0x00000cd8, 0xffffffff, 0x30303030, },
	{ 0, 0, 2, 0x00000cdc, 0xffffffff, 0x24262830, },
	{ 0, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c40, 0xffffffff, 0x28303234, },
	{ 0, 0, 0, 0x00000c44, 0xffffffff, 0x32322426, },
	{ 0, 0, 1, 0x00000c48, 0xffffffff, 0x30323232, },
	{ 0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628, },
	{ 0, 0, 2, 0x00000ce0, 0xffffffff, 0x30303030, },
	{ 0, 0, 2, 0x00000ce4, 0xffffffff, 0x24262830, },
	{ 0, 0, 2, 0x00000ce8, 0x0000ffff, 0x20222222, },
	{ 0, 1, 0, 0x00000e20, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e24, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e28, 0xffffffff, 0x30323434, },
	{ 0, 1, 0, 0x00000e2c, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e30, 0xffffffff, 0x28303234, },
	{ 0, 1, 1, 0x00000e34, 0xffffffff, 0x32323232, },
	{ 0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032, },
	{ 0, 1, 2, 0x00000ed8, 0xffffffff, 0x30303030, },
	{ 0, 1, 2, 0x00000edc, 0xffffffff, 0x24262830, },
	{ 0, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e40, 0xffffffff, 0x28303234, },
	{ 0, 1, 0, 0x00000e44, 0xffffffff, 0x32322426, },
	{ 0, 1, 1, 0x00000e48, 0xffffffff, 0x30323232, },
	{ 0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628, },
	{ 0, 1, 2, 0x00000ee0, 0xffffffff, 0x30303030, },
	{ 0, 1, 2, 0x00000ee4, 0xffffffff, 0x24262830, },
	{ 0, 1, 2, 0x00000ee8, 0x0000ffff, 0x20222222, },
	{ 0, 2, 0, 0x00001820, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001824, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001828, 0xffffffff, 0x30323434, },
	{ 0, 2, 0, 0x0000182c, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001830, 0xffffffff, 0x28303234, },
	{ 0, 2, 1, 0x00001834, 0xffffffff, 0x32323232, },
	{ 0, 2, 1, 0x00001838, 0xffffffff, 0x26283032, },
	{ 0, 2, 2, 0x000018d8, 0xffffffff, 0x30303030, },
	{ 0, 2, 2, 0x000018dc, 0xffffffff, 0x24262830, },
	{ 0, 2, 0, 0x0000183c, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001840, 0xffffffff, 0x28303234, },
	{ 0, 2, 0, 0x00001844, 0xffffffff, 0x32322426, },
	{ 0, 2, 1, 0x00001848, 0xffffffff, 0x30323232, },
	{ 0, 2, 1, 0x0000184c, 0xffffffff, 0x22242628, },
	{ 0, 2, 2, 0x000018e0, 0xffffffff, 0x30303030, },
	{ 0, 2, 2, 0x000018e4, 0xffffffff, 0x24262830, },
	{ 0, 2, 2, 0x000018e8, 0x0000ffff, 0x20222222, },
	{ 0, 3, 0, 0x00001a20, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a24, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a28, 0xffffffff, 0x30323434, },
	{ 0, 3, 0, 0x00001a2c, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a30, 0xffffffff, 0x28303234, },
	{ 0, 3, 1, 0x00001a34, 0xffffffff, 0x32323232, },
	{ 0, 3, 1, 0x00001a38, 0xffffffff, 0x26283032, },
	{ 0, 3, 2, 0x00001ad8, 0xffffffff, 0x30303030, },
	{ 0, 3, 2, 0x00001adc, 0xffffffff, 0x24262830, },
	{ 0, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a40, 0xffffffff, 0x28303234, },
	{ 0, 3, 0, 0x00001a44, 0xffffffff, 0x32322426, },
	{ 0, 3, 1, 0x00001a48, 0xffffffff, 0x30323232, },
	{ 0, 3, 1, 0x00001a4c, 0xffffffff, 0x22242628, },
	{ 0, 3, 2, 0x00001ae0, 0xffffffff, 0x30303030, },
	{ 0, 3, 2, 0x00001ae4, 0xffffffff, 0x24262830, },
	{ 0, 3, 2, 0x00001ae8, 0x0000ffff, 0x20222222, },
	{ 1, 0, 0, 0x00000c24, 0xffffffff, 0x34343434, },
	{ 1, 0, 0, 0x00000c28, 0xffffffff, 0x30323434, },
	{ 1, 0, 0, 0x00000c2c, 0xffffffff, 0x34343434, },
	{ 1, 0, 0, 0x00000c30, 0xffffffff, 0x28303234, },
	{ 1, 0, 1, 0x00000c34, 0xffffffff, 0x32323232, },
	{ 1, 0, 1, 0x00000c38, 0xffffffff, 0x26283032, },
	{ 1, 0, 2, 0x00000cd8, 0xffffffff, 0x30303030, },
	{ 1, 0, 2, 0x00000cdc, 0xffffffff, 0x24262830, },
	{ 1, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434, },
	{ 1, 0, 0, 0x00000c40, 0xffffffff, 0x28303234, },
	{ 1, 0, 0, 0x00000c44, 0xffffffff, 0x32322426, },
	{ 1, 0, 1, 0x00000c48, 0xffffffff, 0x30323232, },
	{ 1, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628, },
	{ 1, 0, 2, 0x00000ce0, 0xffffffff, 0x30303030, },
	{ 1, 0, 2, 0x00000ce4, 0xffffffff, 0x24262830, },
	{ 1, 0, 2, 0x00000ce8, 0x0000ffff, 0x20222222, },
	{ 1, 1, 0, 0x00000e24, 0xffffffff, 0x34343434, },
	{ 1, 1, 0, 0x00000e28, 0xffffffff, 0x30323434, },
	{ 1, 1, 0, 0x00000e2c, 0xffffffff, 0x34343434, },
	{ 1, 1, 0, 0x00000e30, 0xffffffff, 0x28303234, },
	{ 1, 1, 1, 0x00000e34, 0xffffffff, 0x32323232, },
	{ 1, 1, 1, 0x00000e38, 0xffffffff, 0x26283032, },
	{ 1, 1, 2, 0x00000ed8, 0xffffffff, 0x30303030, },
	{ 1, 1, 2, 0x00000edc, 0xffffffff, 0x24262830, },
	{ 1, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434, },
	{ 1, 1, 0, 0x00000e40, 0xffffffff, 0x28303234, },
	{ 1, 1, 0, 0x00000e44, 0xffffffff, 0x32322426, },
	{ 1, 1, 1, 0x00000e48, 0xffffffff, 0x30323232, },
	{ 1, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628, },
	{ 1, 1, 2, 0x00000ee0, 0xffffffff, 0x30303030, },
	{ 1, 1, 2, 0x00000ee4, 0xffffffff, 0x24262830, },
	{ 1, 1, 2, 0x00000ee8, 0x0000ffff, 0x20222222, },
	{ 1, 2, 0, 0x00001824, 0xffffffff, 0x34343434, },
	{ 1, 2, 0, 0x00001828, 0xffffffff, 0x30323434, },
	{ 1, 2, 0, 0x0000182c, 0xffffffff, 0x34343434, },
	{ 1, 2, 0, 0x00001830, 0xffffffff, 0x28303234, },
	{ 1, 2, 1, 0x00001834, 0xffffffff, 0x32323232, },
	{ 1, 2, 1, 0x00001838, 0xffffffff, 0x26283032, },
	{ 1, 2, 2, 0x000018d8, 0xffffffff, 0x30303030, },
	{ 1, 2, 2, 0x000018dc, 0xffffffff, 0x24262830, },
	{ 1, 2, 0, 0x0000183c, 0xffffffff, 0x34343434, },
	{ 1, 2, 0, 0x00001840, 0xffffffff, 0x28303234, },
	{ 1, 2, 0, 0x00001844, 0xffffffff, 0x32322426, },
	{ 1, 2, 1, 0x00001848, 0xffffffff, 0x30323232, },
	{ 1, 2, 1, 0x0000184c, 0xffffffff, 0x22242628, },
	{ 1, 2, 2, 0x000018e0, 0xffffffff, 0x30303030, },
	{ 1, 2, 2, 0x000018e4, 0xffffffff, 0x24262830, },
	{ 1, 2, 2, 0x000018e8, 0x0000ffff, 0x20222222, },
	{ 1, 3, 0, 0x00001a24, 0xffffffff, 0x34343434, },
	{ 1, 3, 0, 0x00001a28, 0xffffffff, 0x30323434, },
	{ 1, 3, 0, 0x00001a2c, 0xffffffff, 0x34343434, },
	{ 1, 3, 0, 0x00001a30, 0xffffffff, 0x28303234, },
	{ 1, 3, 1, 0x00001a34, 0xffffffff, 0x32323232, },
	{ 1, 3, 1, 0x00001a38, 0xffffffff, 0x26283032, },
	{ 1, 3, 2, 0x00001ad8, 0xffffffff, 0x30303030, },
	{ 1, 3, 2, 0x00001adc, 0xffffffff, 0x24262830, },
	{ 1, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434, },
	{ 1, 3, 0, 0x00001a40, 0xffffffff, 0x28303234, },
	{ 1, 3, 0, 0x00001a44, 0xffffffff, 0x32322426, },
	{ 1, 3, 1, 0x00001a48, 0xffffffff, 0x30323232, },
	{ 1, 3, 1, 0x00001a4c, 0xffffffff, 0x22242628, },
	{ 1, 3, 2, 0x00001ae0, 0xffffffff, 0x30303030, },
	{ 1, 3, 2, 0x00001ae4, 0xffffffff, 0x24262830, },
	{ 1, 3, 2, 0x00001ae8, 0x0000ffff, 0x20222222, },
};

RTW_DECL_TABLE_BB_PG(rtw8814a_bb_pg);

static const struct rtw_phy_pg_cfg_pair rtw8814a_bb_pg_type0[] = {
	{ 0, 0, 0, 0x00000c20, 0xffffffff, 0x32323232, },
	{ 0, 0, 0, 0x00000c24, 0xffffffff, 0x32323232, },
	{ 0, 0, 0, 0x00000c28, 0xffffffff, 0x28303232, },
	{ 0, 0, 0, 0x00000c2c, 0xffffffff, 0x32323232, },
	{ 0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032, },
	{ 0, 0, 1, 0x00000c34, 0xffffffff, 0x30303030, },
	{ 0, 0, 1, 0x00000c38, 0xffffffff, 0x24262830, },
	{ 0, 0, 2, 0x00000cd8, 0xffffffff, 0x28282828, },
	{ 0, 0, 2, 0x00000cdc, 0xffffffff, 0x22242628, },
	{ 0, 0, 0, 0x00000c3c, 0xffffffff, 0x32323232, },
	{ 0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032, },
	{ 0, 0, 0, 0x00000c44, 0xffffffff, 0x30302224, },
	{ 0, 0, 1, 0x00000c48, 0xffffffff, 0x28303030, },
	{ 0, 0, 1, 0x00000c4c, 0xffffffff, 0x20222426, },
	{ 0, 0, 2, 0x00000ce0, 0xffffffff, 0x28282828, },
	{ 0, 0, 2, 0x00000ce4, 0xffffffff, 0x22242628, },
	{ 0, 0, 2, 0x00000ce8, 0x0000ffff, 0x18202020, },
	{ 0, 1, 0, 0x00000e20, 0xffffffff, 0x32323232, },
	{ 0, 1, 0, 0x00000e24, 0xffffffff, 0x32323232, },
	{ 0, 1, 0, 0x00000e28, 0xffffffff, 0x28303232, },
	{ 0, 1, 0, 0x00000e2c, 0xffffffff, 0x32323232, },
	{ 0, 1, 0, 0x00000e30, 0xffffffff, 0x26283032, },
	{ 0, 1, 1, 0x00000e34, 0xffffffff, 0x30303030, },
	{ 0, 1, 1, 0x00000e38, 0xffffffff, 0x24262830, },
	{ 0, 1, 2, 0x00000ed8, 0xffffffff, 0x28282828, },
	{ 0, 1, 2, 0x00000edc, 0xffffffff, 0x22242628, },
	{ 0, 1, 0, 0x00000e3c, 0xffffffff, 0x32323232, },
	{ 0, 1, 0, 0x00000e40, 0xffffffff, 0x26283032, },
	{ 0, 1, 0, 0x00000e44, 0xffffffff, 0x30302224, },
	{ 0, 1, 1, 0x00000e48, 0xffffffff, 0x28303030, },
	{ 0, 1, 1, 0x00000e4c, 0xffffffff, 0x20222426, },
	{ 0, 1, 2, 0x00000ee0, 0xffffffff, 0x28282828, },
	{ 0, 1, 2, 0x00000ee4, 0xffffffff, 0x22242628, },
	{ 0, 1, 2, 0x00000ee8, 0x0000ffff, 0x18202020, },
	{ 0, 2, 0, 0x00001820, 0xffffffff, 0x32323232, },
	{ 0, 2, 0, 0x00001824, 0xffffffff, 0x32323232, },
	{ 0, 2, 0, 0x00001828, 0xffffffff, 0x28303232, },
	{ 0, 2, 0, 0x0000182c, 0xffffffff, 0x32323232, },
	{ 0, 2, 0, 0x00001830, 0xffffffff, 0x26283032, },
	{ 0, 2, 1, 0x00001834, 0xffffffff, 0x30303030, },
	{ 0, 2, 1, 0x00001838, 0xffffffff, 0x24262830, },
	{ 0, 2, 2, 0x000018d8, 0xffffffff, 0x28282828, },
	{ 0, 2, 2, 0x000018dc, 0xffffffff, 0x22242628, },
	{ 0, 2, 0, 0x0000183c, 0xffffffff, 0x32323232, },
	{ 0, 2, 0, 0x00001840, 0xffffffff, 0x26283032, },
	{ 0, 2, 0, 0x00001844, 0xffffffff, 0x30302224, },
	{ 0, 2, 1, 0x00001848, 0xffffffff, 0x28303030, },
	{ 0, 2, 1, 0x0000184c, 0xffffffff, 0x20222426, },
	{ 0, 2, 2, 0x000018e0, 0xffffffff, 0x28282828, },
	{ 0, 2, 2, 0x000018e4, 0xffffffff, 0x22242628, },
	{ 0, 2, 2, 0x000018e8, 0x0000ffff, 0x18202020, },
	{ 0, 3, 0, 0x00001a20, 0xffffffff, 0x32323232, },
	{ 0, 3, 0, 0x00001a24, 0xffffffff, 0x32323232, },
	{ 0, 3, 0, 0x00001a28, 0xffffffff, 0x28303232, },
	{ 0, 3, 0, 0x00001a2c, 0xffffffff, 0x32323232, },
	{ 0, 3, 0, 0x00001a30, 0xffffffff, 0x26283032, },
	{ 0, 3, 1, 0x00001a34, 0xffffffff, 0x30303030, },
	{ 0, 3, 1, 0x00001a38, 0xffffffff, 0x24262830, },
	{ 0, 3, 2, 0x00001ad8, 0xffffffff, 0x28282828, },
	{ 0, 3, 2, 0x00001adc, 0xffffffff, 0x22242628, },
	{ 0, 3, 0, 0x00001a3c, 0xffffffff, 0x32323232, },
	{ 0, 3, 0, 0x00001a40, 0xffffffff, 0x26283032, },
	{ 0, 3, 0, 0x00001a44, 0xffffffff, 0x30302224, },
	{ 0, 3, 1, 0x00001a48, 0xffffffff, 0x28303030, },
	{ 0, 3, 1, 0x00001a4c, 0xffffffff, 0x20222426, },
	{ 0, 3, 2, 0x00001ae0, 0xffffffff, 0x28282828, },
	{ 0, 3, 2, 0x00001ae4, 0xffffffff, 0x22242628, },
	{ 0, 3, 2, 0x00001ae8, 0x0000ffff, 0x18202020, },
	{ 1, 0, 0, 0x00000c24, 0xffffffff, 0x32323232, },
	{ 1, 0, 0, 0x00000c28, 0xffffffff, 0x28303232, },
	{ 1, 0, 0, 0x00000c2c, 0xffffffff, 0x32323232, },
	{ 1, 0, 0, 0x00000c30, 0xffffffff, 0x26283032, },
	{ 1, 0, 1, 0x00000c34, 0xffffffff, 0x30303030, },
	{ 1, 0, 1, 0x00000c38, 0xffffffff, 0x24262830, },
	{ 1, 0, 2, 0x00000cd8, 0xffffffff, 0x28282828, },
	{ 1, 0, 2, 0x00000cdc, 0xffffffff, 0x22242628, },
	{ 1, 0, 0, 0x00000c3c, 0xffffffff, 0x32323232, },
	{ 1, 0, 0, 0x00000c40, 0xffffffff, 0x26283032, },
	{ 1, 0, 0, 0x00000c44, 0xffffffff, 0x30302224, },
	{ 1, 0, 1, 0x00000c48, 0xffffffff, 0x28303030, },
	{ 1, 0, 1, 0x00000c4c, 0xffffffff, 0x20222426, },
	{ 1, 0, 2, 0x00000ce0, 0xffffffff, 0x28282828, },
	{ 1, 0, 2, 0x00000ce4, 0xffffffff, 0x22242628, },
	{ 1, 0, 2, 0x00000ce8, 0x0000ffff, 0x18202020, },
	{ 1, 1, 0, 0x00000e24, 0xffffffff, 0x32323232, },
	{ 1, 1, 0, 0x00000e28, 0xffffffff, 0x28303232, },
	{ 1, 1, 0, 0x00000e2c, 0xffffffff, 0x32323232, },
	{ 1, 1, 0, 0x00000e30, 0xffffffff, 0x26283032, },
	{ 1, 1, 1, 0x00000e34, 0xffffffff, 0x30303030, },
	{ 1, 1, 1, 0x00000e38, 0xffffffff, 0x24262830, },
	{ 1, 1, 2, 0x00000ed8, 0xffffffff, 0x28282828, },
	{ 1, 1, 2, 0x00000edc, 0xffffffff, 0x22242628, },
	{ 1, 1, 0, 0x00000e3c, 0xffffffff, 0x32323232, },
	{ 1, 1, 0, 0x00000e40, 0xffffffff, 0x26283032, },
	{ 1, 1, 0, 0x00000e44, 0xffffffff, 0x30302224, },
	{ 1, 1, 1, 0x00000e48, 0xffffffff, 0x28303030, },
	{ 1, 1, 1, 0x00000e4c, 0xffffffff, 0x20222426, },
	{ 1, 1, 2, 0x00000ee0, 0xffffffff, 0x28282828, },
	{ 1, 1, 2, 0x00000ee4, 0xffffffff, 0x22242628, },
	{ 1, 1, 2, 0x00000ee8, 0x0000ffff, 0x18202020, },
	{ 1, 2, 0, 0x00001824, 0xffffffff, 0x32323232, },
	{ 1, 2, 0, 0x00001828, 0xffffffff, 0x28303232, },
	{ 1, 2, 0, 0x0000182c, 0xffffffff, 0x32323232, },
	{ 1, 2, 0, 0x00001830, 0xffffffff, 0x26283032, },
	{ 1, 2, 1, 0x00001834, 0xffffffff, 0x30303030, },
	{ 1, 2, 1, 0x00001838, 0xffffffff, 0x24262830, },
	{ 1, 2, 2, 0x000018d8, 0xffffffff, 0x28282828, },
	{ 1, 2, 2, 0x000018dc, 0xffffffff, 0x22242628, },
	{ 1, 2, 0, 0x0000183c, 0xffffffff, 0x32323232, },
	{ 1, 2, 0, 0x00001840, 0xffffffff, 0x26283032, },
	{ 1, 2, 0, 0x00001844, 0xffffffff, 0x30302224, },
	{ 1, 2, 1, 0x00001848, 0xffffffff, 0x28303030, },
	{ 1, 2, 1, 0x0000184c, 0xffffffff, 0x20222426, },
	{ 1, 2, 2, 0x000018e0, 0xffffffff, 0x28282828, },
	{ 1, 2, 2, 0x000018e4, 0xffffffff, 0x22242628, },
	{ 1, 2, 2, 0x000018e8, 0x0000ffff, 0x18202020, },
	{ 1, 3, 0, 0x00001a24, 0xffffffff, 0x32323232, },
	{ 1, 3, 0, 0x00001a28, 0xffffffff, 0x28303232, },
	{ 1, 3, 0, 0x00001a2c, 0xffffffff, 0x32323232, },
	{ 1, 3, 0, 0x00001a30, 0xffffffff, 0x26283032, },
	{ 1, 3, 1, 0x00001a34, 0xffffffff, 0x30303030, },
	{ 1, 3, 1, 0x00001a38, 0xffffffff, 0x24262830, },
	{ 1, 3, 2, 0x00001ad8, 0xffffffff, 0x28282828, },
	{ 1, 3, 2, 0x00001adc, 0xffffffff, 0x22242628, },
	{ 1, 3, 0, 0x00001a3c, 0xffffffff, 0x32323232, },
	{ 1, 3, 0, 0x00001a40, 0xffffffff, 0x26283032, },
	{ 1, 3, 0, 0x00001a44, 0xffffffff, 0x30302224, },
	{ 1, 3, 1, 0x00001a48, 0xffffffff, 0x28303030, },
	{ 1, 3, 1, 0x00001a4c, 0xffffffff, 0x20222426, },
	{ 1, 3, 2, 0x00001ae0, 0xffffffff, 0x28282828, },
	{ 1, 3, 2, 0x00001ae4, 0xffffffff, 0x22242628, },
	{ 1, 3, 2, 0x00001ae8, 0x0000ffff, 0x18202020, },
};

RTW_DECL_TABLE_BB_PG(rtw8814a_bb_pg_type0);

static const struct rtw_phy_pg_cfg_pair rtw8814a_bb_pg_type2[] = {
	{ 0, 0, 0, 0x00000c20, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c24, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c28, 0xffffffff, 0x30323434, },
	{ 0, 0, 0, 0x00000c2c, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c30, 0xffffffff, 0x28303234, },
	{ 0, 0, 1, 0x00000c34, 0xffffffff, 0x32323232, },
	{ 0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032, },
	{ 0, 0, 2, 0x00000cd8, 0xffffffff, 0x30303030, },
	{ 0, 0, 2, 0x00000cdc, 0xffffffff, 0x24262830, },
	{ 0, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c40, 0xffffffff, 0x28303234, },
	{ 0, 0, 0, 0x00000c44, 0xffffffff, 0x32322426, },
	{ 0, 0, 1, 0x00000c48, 0xffffffff, 0x30323232, },
	{ 0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628, },
	{ 0, 0, 2, 0x00000ce0, 0xffffffff, 0x30303030, },
	{ 0, 0, 2, 0x00000ce4, 0xffffffff, 0x24262830, },
	{ 0, 0, 2, 0x00000ce8, 0x0000ffff, 0x20222222, },
	{ 0, 1, 0, 0x00000e20, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e24, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e28, 0xffffffff, 0x30323434, },
	{ 0, 1, 0, 0x00000e2c, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e30, 0xffffffff, 0x28303234, },
	{ 0, 1, 1, 0x00000e34, 0xffffffff, 0x32323232, },
	{ 0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032, },
	{ 0, 1, 2, 0x00000ed8, 0xffffffff, 0x30303030, },
	{ 0, 1, 2, 0x00000edc, 0xffffffff, 0x24262830, },
	{ 0, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e40, 0xffffffff, 0x28303234, },
	{ 0, 1, 0, 0x00000e44, 0xffffffff, 0x32322426, },
	{ 0, 1, 1, 0x00000e48, 0xffffffff, 0x30323232, },
	{ 0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628, },
	{ 0, 1, 2, 0x00000ee0, 0xffffffff, 0x30303030, },
	{ 0, 1, 2, 0x00000ee4, 0xffffffff, 0x24262830, },
	{ 0, 1, 2, 0x00000ee8, 0x0000ffff, 0x20222222, },
	{ 0, 2, 0, 0x00001820, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001824, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001828, 0xffffffff, 0x30323434, },
	{ 0, 2, 0, 0x0000182c, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001830, 0xffffffff, 0x28303234, },
	{ 0, 2, 1, 0x00001834, 0xffffffff, 0x32323232, },
	{ 0, 2, 1, 0x00001838, 0xffffffff, 0x26283032, },
	{ 0, 2, 2, 0x000018d8, 0xffffffff, 0x30303030, },
	{ 0, 2, 2, 0x000018dc, 0xffffffff, 0x24262830, },
	{ 0, 2, 0, 0x0000183c, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001840, 0xffffffff, 0x28303234, },
	{ 0, 2, 0, 0x00001844, 0xffffffff, 0x32322426, },
	{ 0, 2, 1, 0x00001848, 0xffffffff, 0x30323232, },
	{ 0, 2, 1, 0x0000184c, 0xffffffff, 0x22242628, },
	{ 0, 2, 2, 0x000018e0, 0xffffffff, 0x30303030, },
	{ 0, 2, 2, 0x000018e4, 0xffffffff, 0x24262830, },
	{ 0, 2, 2, 0x000018e8, 0x0000ffff, 0x20222222, },
	{ 0, 3, 0, 0x00001a20, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a24, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a28, 0xffffffff, 0x30323434, },
	{ 0, 3, 0, 0x00001a2c, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a30, 0xffffffff, 0x28303234, },
	{ 0, 3, 1, 0x00001a34, 0xffffffff, 0x32323232, },
	{ 0, 3, 1, 0x00001a38, 0xffffffff, 0x26283032, },
	{ 0, 3, 2, 0x00001ad8, 0xffffffff, 0x30303030, },
	{ 0, 3, 2, 0x00001adc, 0xffffffff, 0x24262830, },
	{ 0, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a40, 0xffffffff, 0x28303234, },
	{ 0, 3, 0, 0x00001a44, 0xffffffff, 0x32322426, },
	{ 0, 3, 1, 0x00001a48, 0xffffffff, 0x30323232, },
	{ 0, 3, 1, 0x00001a4c, 0xffffffff, 0x22242628, },
	{ 0, 3, 2, 0x00001ae0, 0xffffffff, 0x30303030, },
	{ 0, 3, 2, 0x00001ae4, 0xffffffff, 0x24262830, },
	{ 0, 3, 2, 0x00001ae8, 0x0000ffff, 0x20222222, },
	{ 1, 0, 0, 0x00000c24, 0xffffffff, 0x34343434, },
	{ 1, 0, 0, 0x00000c28, 0xffffffff, 0x30323434, },
	{ 1, 0, 0, 0x00000c2c, 0xffffffff, 0x34343434, },
	{ 1, 0, 0, 0x00000c30, 0xffffffff, 0x28303234, },
	{ 1, 0, 1, 0x00000c34, 0xffffffff, 0x32323232, },
	{ 1, 0, 1, 0x00000c38, 0xffffffff, 0x26283032, },
	{ 1, 0, 2, 0x00000cd8, 0xffffffff, 0x30303030, },
	{ 1, 0, 2, 0x00000cdc, 0xffffffff, 0x24262830, },
	{ 1, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434, },
	{ 1, 0, 0, 0x00000c40, 0xffffffff, 0x28303234, },
	{ 1, 0, 0, 0x00000c44, 0xffffffff, 0x32322426, },
	{ 1, 0, 1, 0x00000c48, 0xffffffff, 0x30323232, },
	{ 1, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628, },
	{ 1, 0, 2, 0x00000ce0, 0xffffffff, 0x30303030, },
	{ 1, 0, 2, 0x00000ce4, 0xffffffff, 0x24262830, },
	{ 1, 0, 2, 0x00000ce8, 0x0000ffff, 0x20222222, },
	{ 1, 1, 0, 0x00000e24, 0xffffffff, 0x34343434, },
	{ 1, 1, 0, 0x00000e28, 0xffffffff, 0x30323434, },
	{ 1, 1, 0, 0x00000e2c, 0xffffffff, 0x34343434, },
	{ 1, 1, 0, 0x00000e30, 0xffffffff, 0x28303234, },
	{ 1, 1, 1, 0x00000e34, 0xffffffff, 0x32323232, },
	{ 1, 1, 1, 0x00000e38, 0xffffffff, 0x26283032, },
	{ 1, 1, 2, 0x00000ed8, 0xffffffff, 0x30303030, },
	{ 1, 1, 2, 0x00000edc, 0xffffffff, 0x24262830, },
	{ 1, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434, },
	{ 1, 1, 0, 0x00000e40, 0xffffffff, 0x28303234, },
	{ 1, 1, 0, 0x00000e44, 0xffffffff, 0x32322426, },
	{ 1, 1, 1, 0x00000e48, 0xffffffff, 0x30323232, },
	{ 1, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628, },
	{ 1, 1, 2, 0x00000ee0, 0xffffffff, 0x30303030, },
	{ 1, 1, 2, 0x00000ee4, 0xffffffff, 0x24262830, },
	{ 1, 1, 2, 0x00000ee8, 0x0000ffff, 0x20222222, },
	{ 1, 2, 0, 0x00001824, 0xffffffff, 0x34343434, },
	{ 1, 2, 0, 0x00001828, 0xffffffff, 0x30323434, },
	{ 1, 2, 0, 0x0000182c, 0xffffffff, 0x34343434, },
	{ 1, 2, 0, 0x00001830, 0xffffffff, 0x28303234, },
	{ 1, 2, 1, 0x00001834, 0xffffffff, 0x32323232, },
	{ 1, 2, 1, 0x00001838, 0xffffffff, 0x26283032, },
	{ 1, 2, 2, 0x000018d8, 0xffffffff, 0x30303030, },
	{ 1, 2, 2, 0x000018dc, 0xffffffff, 0x24262830, },
	{ 1, 2, 0, 0x0000183c, 0xffffffff, 0x34343434, },
	{ 1, 2, 0, 0x00001840, 0xffffffff, 0x28303234, },
	{ 1, 2, 0, 0x00001844, 0xffffffff, 0x32322426, },
	{ 1, 2, 1, 0x00001848, 0xffffffff, 0x30323232, },
	{ 1, 2, 1, 0x0000184c, 0xffffffff, 0x22242628, },
	{ 1, 2, 2, 0x000018e0, 0xffffffff, 0x30303030, },
	{ 1, 2, 2, 0x000018e4, 0xffffffff, 0x24262830, },
	{ 1, 2, 2, 0x000018e8, 0x0000ffff, 0x20222222, },
	{ 1, 3, 0, 0x00001a24, 0xffffffff, 0x34343434, },
	{ 1, 3, 0, 0x00001a28, 0xffffffff, 0x30323434, },
	{ 1, 3, 0, 0x00001a2c, 0xffffffff, 0x34343434, },
	{ 1, 3, 0, 0x00001a30, 0xffffffff, 0x28303234, },
	{ 1, 3, 1, 0x00001a34, 0xffffffff, 0x32323232, },
	{ 1, 3, 1, 0x00001a38, 0xffffffff, 0x26283032, },
	{ 1, 3, 2, 0x00001ad8, 0xffffffff, 0x30303030, },
	{ 1, 3, 2, 0x00001adc, 0xffffffff, 0x24262830, },
	{ 1, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434, },
	{ 1, 3, 0, 0x00001a40, 0xffffffff, 0x28303234, },
	{ 1, 3, 0, 0x00001a44, 0xffffffff, 0x32322426, },
	{ 1, 3, 1, 0x00001a48, 0xffffffff, 0x30323232, },
	{ 1, 3, 1, 0x00001a4c, 0xffffffff, 0x22242628, },
	{ 1, 3, 2, 0x00001ae0, 0xffffffff, 0x30303030, },
	{ 1, 3, 2, 0x00001ae4, 0xffffffff, 0x24262830, },
	{ 1, 3, 2, 0x00001ae8, 0x0000ffff, 0x20222222, },
};

RTW_DECL_TABLE_BB_PG(rtw8814a_bb_pg_type2);

static const struct rtw_phy_pg_cfg_pair rtw8814a_bb_pg_type3[] = {
	{ 0, 0, 0, 0x00000c20, 0xffffffff, 0x48484848, },
	{ 0, 0, 0, 0x00000c24, 0xffffffff, 0x46464646, },
	{ 0, 0, 0, 0x00000c28, 0xffffffff, 0x44464646, },
	{ 0, 0, 0, 0x00000c2c, 0xffffffff, 0x46464646, },
	{ 0, 0, 0, 0x00000c30, 0xffffffff, 0x42444646, },
	{ 0, 0, 1, 0x00000c34, 0xffffffff, 0x46464646, },
	{ 0, 0, 1, 0x00000c38, 0xffffffff, 0x42444646, },
	{ 0, 0, 2, 0x00000cd8, 0xffffffff, 0x46464646, },
	{ 0, 0, 2, 0x00000cdc, 0xffffffff, 0x42444646, },
	{ 0, 0, 0, 0x00000c3c, 0xffffffff, 0x46464646, },
	{ 0, 0, 0, 0x00000c40, 0xffffffff, 0x42444646, },
	{ 0, 0, 0, 0x00000c44, 0xffffffff, 0x46463840, },
	{ 0, 0, 1, 0x00000c48, 0xffffffff, 0x46464646, },
	{ 0, 0, 1, 0x00000c4c, 0xffffffff, 0x38404244, },
	{ 0, 0, 2, 0x00000ce0, 0xffffffff, 0x46464646, },
	{ 0, 0, 2, 0x00000ce4, 0xffffffff, 0x42444646, },
	{ 0, 0, 2, 0x00000ce8, 0x0000ffff, 0x38383840, },
	{ 0, 1, 0, 0x00000e20, 0xffffffff, 0x48484848, },
	{ 0, 1, 0, 0x00000e24, 0xffffffff, 0x46464646, },
	{ 0, 1, 0, 0x00000e28, 0xffffffff, 0x44464646, },
	{ 0, 1, 0, 0x00000e2c, 0xffffffff, 0x46464646, },
	{ 0, 1, 0, 0x00000e30, 0xffffffff, 0x42444646, },
	{ 0, 1, 1, 0x00000e34, 0xffffffff, 0x46464646, },
	{ 0, 1, 1, 0x00000e38, 0xffffffff, 0x42444646, },
	{ 0, 1, 2, 0x00000ed8, 0xffffffff, 0x46464646, },
	{ 0, 1, 2, 0x00000edc, 0xffffffff, 0x42444646, },
	{ 0, 1, 0, 0x00000e3c, 0xffffffff, 0x46464646, },
	{ 0, 1, 0, 0x00000e40, 0xffffffff, 0x42444646, },
	{ 0, 1, 0, 0x00000e44, 0xffffffff, 0x46463840, },
	{ 0, 1, 1, 0x00000e48, 0xffffffff, 0x46464646, },
	{ 0, 1, 1, 0x00000e4c, 0xffffffff, 0x38404244, },
	{ 0, 1, 2, 0x00000ee0, 0xffffffff, 0x46464646, },
	{ 0, 1, 2, 0x00000ee4, 0xffffffff, 0x42444646, },
	{ 0, 1, 2, 0x00000ee8, 0x0000ffff, 0x38383840, },
	{ 0, 2, 0, 0x00001820, 0xffffffff, 0x48484848, },
	{ 0, 2, 0, 0x00001824, 0xffffffff, 0x46464646, },
	{ 0, 2, 0, 0x00001828, 0xffffffff, 0x44464646, },
	{ 0, 2, 0, 0x0000182c, 0xffffffff, 0x46464646, },
	{ 0, 2, 0, 0x00001830, 0xffffffff, 0x42444646, },
	{ 0, 2, 1, 0x00001834, 0xffffffff, 0x46464646, },
	{ 0, 2, 1, 0x00001838, 0xffffffff, 0x42444646, },
	{ 0, 2, 2, 0x000018d8, 0xffffffff, 0x46464646, },
	{ 0, 2, 2, 0x000018dc, 0xffffffff, 0x42444646, },
	{ 0, 2, 0, 0x0000183c, 0xffffffff, 0x46464646, },
	{ 0, 2, 0, 0x00001840, 0xffffffff, 0x42444646, },
	{ 0, 2, 0, 0x00001844, 0xffffffff, 0x46463840, },
	{ 0, 2, 1, 0x00001848, 0xffffffff, 0x46464646, },
	{ 0, 2, 1, 0x0000184c, 0xffffffff, 0x38404244, },
	{ 0, 2, 2, 0x000018e0, 0xffffffff, 0x46464646, },
	{ 0, 2, 2, 0x000018e4, 0xffffffff, 0x42444646, },
	{ 0, 2, 2, 0x000018e8, 0x0000ffff, 0x38383840, },
	{ 0, 3, 0, 0x00001a20, 0xffffffff, 0x48484848, },
	{ 0, 3, 0, 0x00001a24, 0xffffffff, 0x46464646, },
	{ 0, 3, 0, 0x00001a28, 0xffffffff, 0x44464646, },
	{ 0, 3, 0, 0x00001a2c, 0xffffffff, 0x46464646, },
	{ 0, 3, 0, 0x00001a30, 0xffffffff, 0x42444646, },
	{ 0, 3, 1, 0x00001a34, 0xffffffff, 0x46464646, },
	{ 0, 3, 1, 0x00001a38, 0xffffffff, 0x42444646, },
	{ 0, 3, 2, 0x00001ad8, 0xffffffff, 0x46464646, },
	{ 0, 3, 2, 0x00001adc, 0xffffffff, 0x42444646, },
	{ 0, 3, 0, 0x00001a3c, 0xffffffff, 0x46464646, },
	{ 0, 3, 0, 0x00001a40, 0xffffffff, 0x42444646, },
	{ 0, 3, 0, 0x00001a44, 0xffffffff, 0x46463840, },
	{ 0, 3, 1, 0x00001a48, 0xffffffff, 0x46464646, },
	{ 0, 3, 1, 0x00001a4c, 0xffffffff, 0x38404244, },
	{ 0, 3, 2, 0x00001ae0, 0xffffffff, 0x46464646, },
	{ 0, 3, 2, 0x00001ae4, 0xffffffff, 0x42444646, },
	{ 0, 3, 2, 0x00001ae8, 0x0000ffff, 0x38383840, },
	{ 1, 0, 0, 0x00000c24, 0xffffffff, 0x46464646, },
	{ 1, 0, 0, 0x00000c28, 0xffffffff, 0x44464646, },
	{ 1, 0, 0, 0x00000c2c, 0xffffffff, 0x46464646, },
	{ 1, 0, 0, 0x00000c30, 0xffffffff, 0x42444646, },
	{ 1, 0, 1, 0x00000c34, 0xffffffff, 0x46464646, },
	{ 1, 0, 1, 0x00000c38, 0xffffffff, 0x42444646, },
	{ 1, 0, 2, 0x00000cd8, 0xffffffff, 0x46464646, },
	{ 1, 0, 2, 0x00000cdc, 0xffffffff, 0x42444646, },
	{ 1, 0, 0, 0x00000c3c, 0xffffffff, 0x46464646, },
	{ 1, 0, 0, 0x00000c40, 0xffffffff, 0x42444646, },
	{ 1, 0, 0, 0x00000c44, 0xffffffff, 0x46463840, },
	{ 1, 0, 1, 0x00000c48, 0xffffffff, 0x46464646, },
	{ 1, 0, 1, 0x00000c4c, 0xffffffff, 0x38404244, },
	{ 1, 0, 2, 0x00000ce0, 0xffffffff, 0x46464646, },
	{ 1, 0, 2, 0x00000ce4, 0xffffffff, 0x42444646, },
	{ 1, 0, 2, 0x00000ce8, 0x0000ffff, 0x38383840, },
	{ 1, 1, 0, 0x00000e24, 0xffffffff, 0x46464646, },
	{ 1, 1, 0, 0x00000e28, 0xffffffff, 0x44464646, },
	{ 1, 1, 0, 0x00000e2c, 0xffffffff, 0x46464646, },
	{ 1, 1, 0, 0x00000e30, 0xffffffff, 0x42444646, },
	{ 1, 1, 1, 0x00000e34, 0xffffffff, 0x46464646, },
	{ 1, 1, 1, 0x00000e38, 0xffffffff, 0x42444646, },
	{ 1, 1, 2, 0x00000ed8, 0xffffffff, 0x46464646, },
	{ 1, 1, 2, 0x00000edc, 0xffffffff, 0x42444646, },
	{ 1, 1, 0, 0x00000e3c, 0xffffffff, 0x46464646, },
	{ 1, 1, 0, 0x00000e40, 0xffffffff, 0x42444646, },
	{ 1, 1, 0, 0x00000e44, 0xffffffff, 0x46463840, },
	{ 1, 1, 1, 0x00000e48, 0xffffffff, 0x46464646, },
	{ 1, 1, 1, 0x00000e4c, 0xffffffff, 0x38404244, },
	{ 1, 1, 2, 0x00000ee0, 0xffffffff, 0x46464646, },
	{ 1, 1, 2, 0x00000ee4, 0xffffffff, 0x42444646, },
	{ 1, 1, 2, 0x00000ee8, 0x0000ffff, 0x38383840, },
	{ 1, 2, 0, 0x00001824, 0xffffffff, 0x46464646, },
	{ 1, 2, 0, 0x00001828, 0xffffffff, 0x44464646, },
	{ 1, 2, 0, 0x0000182c, 0xffffffff, 0x46464646, },
	{ 1, 2, 0, 0x00001830, 0xffffffff, 0x42444646, },
	{ 1, 2, 1, 0x00001834, 0xffffffff, 0x46464646, },
	{ 1, 2, 1, 0x00001838, 0xffffffff, 0x42444646, },
	{ 1, 2, 2, 0x000018d8, 0xffffffff, 0x46464646, },
	{ 1, 2, 2, 0x000018dc, 0xffffffff, 0x42444646, },
	{ 1, 2, 0, 0x0000183c, 0xffffffff, 0x46464646, },
	{ 1, 2, 0, 0x00001840, 0xffffffff, 0x42444646, },
	{ 1, 2, 0, 0x00001844, 0xffffffff, 0x46463840, },
	{ 1, 2, 1, 0x00001848, 0xffffffff, 0x46464646, },
	{ 1, 2, 1, 0x0000184c, 0xffffffff, 0x38404244, },
	{ 1, 2, 2, 0x000018e0, 0xffffffff, 0x46464646, },
	{ 1, 2, 2, 0x000018e4, 0xffffffff, 0x42444646, },
	{ 1, 2, 2, 0x000018e8, 0x0000ffff, 0x38383840, },
	{ 1, 3, 0, 0x00001a24, 0xffffffff, 0x46464646, },
	{ 1, 3, 0, 0x00001a28, 0xffffffff, 0x44464646, },
	{ 1, 3, 0, 0x00001a2c, 0xffffffff, 0x46464646, },
	{ 1, 3, 0, 0x00001a30, 0xffffffff, 0x42444646, },
	{ 1, 3, 1, 0x00001a34, 0xffffffff, 0x46464646, },
	{ 1, 3, 1, 0x00001a38, 0xffffffff, 0x42444646, },
	{ 1, 3, 2, 0x00001ad8, 0xffffffff, 0x46464646, },
	{ 1, 3, 2, 0x00001adc, 0xffffffff, 0x42444646, },
	{ 1, 3, 0, 0x00001a3c, 0xffffffff, 0x46464646, },
	{ 1, 3, 0, 0x00001a40, 0xffffffff, 0x42444646, },
	{ 1, 3, 0, 0x00001a44, 0xffffffff, 0x46463840, },
	{ 1, 3, 1, 0x00001a48, 0xffffffff, 0x46464646, },
	{ 1, 3, 1, 0x00001a4c, 0xffffffff, 0x38404244, },
	{ 1, 3, 2, 0x00001ae0, 0xffffffff, 0x46464646, },
	{ 1, 3, 2, 0x00001ae4, 0xffffffff, 0x42444646, },
	{ 1, 3, 2, 0x00001ae8, 0x0000ffff, 0x38383840, },
};

RTW_DECL_TABLE_BB_PG(rtw8814a_bb_pg_type3);

static const struct rtw_phy_pg_cfg_pair rtw8814a_bb_pg_type4[] = {
	{ 0, 0, 0, 0x00000c20, 0xffffffff, 0x42424242, },
	{ 0, 0, 0, 0x00000c24, 0xffffffff, 0x42424242, },
	{ 0, 0, 0, 0x00000c28, 0xffffffff, 0x36384042, },
	{ 0, 0, 0, 0x00000c2c, 0xffffffff, 0x42424242, },
	{ 0, 0, 0, 0x00000c30, 0xffffffff, 0x34363840, },
	{ 0, 0, 1, 0x00000c34, 0xffffffff, 0x42424242, },
	{ 0, 0, 1, 0x00000c38, 0xffffffff, 0x34363840, },
	{ 0, 0, 2, 0x00000cd8, 0xffffffff, 0x42424242, },
	{ 0, 0, 2, 0x00000cdc, 0xffffffff, 0x34363840, },
	{ 0, 0, 0, 0x00000c3c, 0xffffffff, 0x42424242, },
	{ 0, 0, 0, 0x00000c40, 0xffffffff, 0x34363840, },
	{ 0, 0, 0, 0x00000c44, 0xffffffff, 0x42423032, },
	{ 0, 0, 1, 0x00000c48, 0xffffffff, 0x38404242, },
	{ 0, 0, 1, 0x00000c4c, 0xffffffff, 0x30323436, },
	{ 0, 0, 2, 0x00000ce0, 0xffffffff, 0x42424242, },
	{ 0, 0, 2, 0x00000ce4, 0xffffffff, 0x34363840, },
	{ 0, 0, 2, 0x00000ce8, 0x0000ffff, 0x30303032, },
	{ 0, 1, 0, 0x00000e20, 0xffffffff, 0x42424242, },
	{ 0, 1, 0, 0x00000e24, 0xffffffff, 0x42424242, },
	{ 0, 1, 0, 0x00000e28, 0xffffffff, 0x36384042, },
	{ 0, 1, 0, 0x00000e2c, 0xffffffff, 0x42424242, },
	{ 0, 1, 0, 0x00000e30, 0xffffffff, 0x34363840, },
	{ 0, 1, 1, 0x00000e34, 0xffffffff, 0x42424242, },
	{ 0, 1, 1, 0x00000e38, 0xffffffff, 0x34363840, },
	{ 0, 1, 2, 0x00000ed8, 0xffffffff, 0x42424242, },
	{ 0, 1, 2, 0x00000edc, 0xffffffff, 0x34363840, },
	{ 0, 1, 0, 0x00000e3c, 0xffffffff, 0x42424242, },
	{ 0, 1, 0, 0x00000e40, 0xffffffff, 0x34363840, },
	{ 0, 1, 0, 0x00000e44, 0xffffffff, 0x42423032, },
	{ 0, 1, 1, 0x00000e48, 0xffffffff, 0x38404242, },
	{ 0, 1, 1, 0x00000e4c, 0xffffffff, 0x30323436, },
	{ 0, 1, 2, 0x00000ee0, 0xffffffff, 0x42424242, },
	{ 0, 1, 2, 0x00000ee4, 0xffffffff, 0x34363840, },
	{ 0, 1, 2, 0x00000ee8, 0x0000ffff, 0x30303032, },
	{ 0, 2, 0, 0x00001820, 0xffffffff, 0x42424242, },
	{ 0, 2, 0, 0x00001824, 0xffffffff, 0x42424242, },
	{ 0, 2, 0, 0x00001828, 0xffffffff, 0x36384042, },
	{ 0, 2, 0, 0x0000182c, 0xffffffff, 0x42424242, },
	{ 0, 2, 0, 0x00001830, 0xffffffff, 0x34363840, },
	{ 0, 2, 1, 0x00001834, 0xffffffff, 0x42424242, },
	{ 0, 2, 1, 0x00001838, 0xffffffff, 0x34363840, },
	{ 0, 2, 2, 0x000018d8, 0xffffffff, 0x42424242, },
	{ 0, 2, 2, 0x000018dc, 0xffffffff, 0x34363840, },
	{ 0, 2, 0, 0x0000183c, 0xffffffff, 0x42424242, },
	{ 0, 2, 0, 0x00001840, 0xffffffff, 0x34363840, },
	{ 0, 2, 0, 0x00001844, 0xffffffff, 0x42423032, },
	{ 0, 2, 1, 0x00001848, 0xffffffff, 0x38404242, },
	{ 0, 2, 1, 0x0000184c, 0xffffffff, 0x30323436, },
	{ 0, 2, 2, 0x000018e0, 0xffffffff, 0x42424242, },
	{ 0, 2, 2, 0x000018e4, 0xffffffff, 0x34363840, },
	{ 0, 2, 2, 0x000018e8, 0x0000ffff, 0x30303032, },
	{ 0, 3, 0, 0x00001a20, 0xffffffff, 0x42424242, },
	{ 0, 3, 0, 0x00001a24, 0xffffffff, 0x42424242, },
	{ 0, 3, 0, 0x00001a28, 0xffffffff, 0x36384042, },
	{ 0, 3, 0, 0x00001a2c, 0xffffffff, 0x42424242, },
	{ 0, 3, 0, 0x00001a30, 0xffffffff, 0x34363840, },
	{ 0, 3, 1, 0x00001a34, 0xffffffff, 0x42424242, },
	{ 0, 3, 1, 0x00001a38, 0xffffffff, 0x34363840, },
	{ 0, 3, 2, 0x00001ad8, 0xffffffff, 0x42424242, },
	{ 0, 3, 2, 0x00001adc, 0xffffffff, 0x34363840, },
	{ 0, 3, 0, 0x00001a3c, 0xffffffff, 0x42424242, },
	{ 0, 3, 0, 0x00001a40, 0xffffffff, 0x34363840, },
	{ 0, 3, 0, 0x00001a44, 0xffffffff, 0x42423032, },
	{ 0, 3, 1, 0x00001a48, 0xffffffff, 0x38404242, },
	{ 0, 3, 1, 0x00001a4c, 0xffffffff, 0x30323436, },
	{ 0, 3, 2, 0x00001ae0, 0xffffffff, 0x42424242, },
	{ 0, 3, 2, 0x00001ae4, 0xffffffff, 0x34363840, },
	{ 0, 3, 2, 0x00001ae8, 0x0000ffff, 0x30303032, },
	{ 1, 0, 0, 0x00000c24, 0xffffffff, 0x42424242, },
	{ 1, 0, 0, 0x00000c28, 0xffffffff, 0x36384042, },
	{ 1, 0, 0, 0x00000c2c, 0xffffffff, 0x42424242, },
	{ 1, 0, 0, 0x00000c30, 0xffffffff, 0x34363840, },
	{ 1, 0, 1, 0x00000c34, 0xffffffff, 0x42424242, },
	{ 1, 0, 1, 0x00000c38, 0xffffffff, 0x34363840, },
	{ 1, 0, 2, 0x00000cd8, 0xffffffff, 0x42424242, },
	{ 1, 0, 2, 0x00000cdc, 0xffffffff, 0x34363840, },
	{ 1, 0, 0, 0x00000c3c, 0xffffffff, 0x42424242, },
	{ 1, 0, 0, 0x00000c40, 0xffffffff, 0x34363840, },
	{ 1, 0, 0, 0x00000c44, 0xffffffff, 0x42423032, },
	{ 1, 0, 1, 0x00000c48, 0xffffffff, 0x38404242, },
	{ 1, 0, 1, 0x00000c4c, 0xffffffff, 0x30323436, },
	{ 1, 0, 2, 0x00000ce0, 0xffffffff, 0x42424242, },
	{ 1, 0, 2, 0x00000ce4, 0xffffffff, 0x34363840, },
	{ 1, 0, 2, 0x00000ce8, 0x0000ffff, 0x30303032, },
	{ 1, 1, 0, 0x00000e24, 0xffffffff, 0x42424242, },
	{ 1, 1, 0, 0x00000e28, 0xffffffff, 0x36384042, },
	{ 1, 1, 0, 0x00000e2c, 0xffffffff, 0x42424242, },
	{ 1, 1, 0, 0x00000e30, 0xffffffff, 0x34363840, },
	{ 1, 1, 1, 0x00000e34, 0xffffffff, 0x42424242, },
	{ 1, 1, 1, 0x00000e38, 0xffffffff, 0x34363840, },
	{ 1, 1, 2, 0x00000ed8, 0xffffffff, 0x42424242, },
	{ 1, 1, 2, 0x00000edc, 0xffffffff, 0x34363840, },
	{ 1, 1, 0, 0x00000e3c, 0xffffffff, 0x42424242, },
	{ 1, 1, 0, 0x00000e40, 0xffffffff, 0x34363840, },
	{ 1, 1, 0, 0x00000e44, 0xffffffff, 0x42423032, },
	{ 1, 1, 1, 0x00000e48, 0xffffffff, 0x38404242, },
	{ 1, 1, 1, 0x00000e4c, 0xffffffff, 0x30323436, },
	{ 1, 1, 2, 0x00000ee0, 0xffffffff, 0x42424242, },
	{ 1, 1, 2, 0x00000ee4, 0xffffffff, 0x34363840, },
	{ 1, 1, 2, 0x00000ee8, 0x0000ffff, 0x30303032, },
	{ 1, 2, 0, 0x00001824, 0xffffffff, 0x42424242, },
	{ 1, 2, 0, 0x00001828, 0xffffffff, 0x36384042, },
	{ 1, 2, 0, 0x0000182c, 0xffffffff, 0x42424242, },
	{ 1, 2, 0, 0x00001830, 0xffffffff, 0x34363840, },
	{ 1, 2, 1, 0x00001834, 0xffffffff, 0x42424242, },
	{ 1, 2, 1, 0x00001838, 0xffffffff, 0x34363840, },
	{ 1, 2, 2, 0x000018d8, 0xffffffff, 0x42424242, },
	{ 1, 2, 2, 0x000018dc, 0xffffffff, 0x34363840, },
	{ 1, 2, 0, 0x0000183c, 0xffffffff, 0x42424242, },
	{ 1, 2, 0, 0x00001840, 0xffffffff, 0x34363840, },
	{ 1, 2, 0, 0x00001844, 0xffffffff, 0x42423032, },
	{ 1, 2, 1, 0x00001848, 0xffffffff, 0x38404242, },
	{ 1, 2, 1, 0x0000184c, 0xffffffff, 0x30323436, },
	{ 1, 2, 2, 0x000018e0, 0xffffffff, 0x42424242, },
	{ 1, 2, 2, 0x000018e4, 0xffffffff, 0x34363840, },
	{ 1, 2, 2, 0x000018e8, 0x0000ffff, 0x30303032, },
	{ 1, 3, 0, 0x00001a24, 0xffffffff, 0x42424242, },
	{ 1, 3, 0, 0x00001a28, 0xffffffff, 0x36384042, },
	{ 1, 3, 0, 0x00001a2c, 0xffffffff, 0x42424242, },
	{ 1, 3, 0, 0x00001a30, 0xffffffff, 0x34363840, },
	{ 1, 3, 1, 0x00001a34, 0xffffffff, 0x42424242, },
	{ 1, 3, 1, 0x00001a38, 0xffffffff, 0x34363840, },
	{ 1, 3, 2, 0x00001ad8, 0xffffffff, 0x42424242, },
	{ 1, 3, 2, 0x00001adc, 0xffffffff, 0x34363840, },
	{ 1, 3, 0, 0x00001a3c, 0xffffffff, 0x42424242, },
	{ 1, 3, 0, 0x00001a40, 0xffffffff, 0x34363840, },
	{ 1, 3, 0, 0x00001a44, 0xffffffff, 0x42423032, },
	{ 1, 3, 1, 0x00001a48, 0xffffffff, 0x38404242, },
	{ 1, 3, 1, 0x00001a4c, 0xffffffff, 0x30323436, },
	{ 1, 3, 2, 0x00001ae0, 0xffffffff, 0x42424242, },
	{ 1, 3, 2, 0x00001ae4, 0xffffffff, 0x34363840, },
	{ 1, 3, 2, 0x00001ae8, 0x0000ffff, 0x30303032, },
};

RTW_DECL_TABLE_BB_PG(rtw8814a_bb_pg_type4);

static const struct rtw_phy_pg_cfg_pair rtw8814a_bb_pg_type5[] = {
	{ 0, 0, 0, 0x00000c20, 0xffffffff, 0x48484848, },
	{ 0, 0, 0, 0x00000c24, 0xffffffff, 0x46464646, },
	{ 0, 0, 0, 0x00000c28, 0xffffffff, 0x44464646, },
	{ 0, 0, 0, 0x00000c2c, 0xffffffff, 0x46464646, },
	{ 0, 0, 0, 0x00000c30, 0xffffffff, 0x42444646, },
	{ 0, 0, 1, 0x00000c34, 0xffffffff, 0x44444444, },
	{ 0, 0, 1, 0x00000c38, 0xffffffff, 0x40424444, },
	{ 0, 0, 2, 0x00000cd8, 0xffffffff, 0x42424242, },
	{ 0, 0, 2, 0x00000cdc, 0xffffffff, 0x38404242, },
	{ 0, 0, 0, 0x00000c3c, 0xffffffff, 0x46464646, },
	{ 0, 0, 0, 0x00000c40, 0xffffffff, 0x42444646, },
	{ 0, 0, 0, 0x00000c44, 0xffffffff, 0x44444040, },
	{ 0, 0, 1, 0x00000c48, 0xffffffff, 0x44444444, },
	{ 0, 0, 1, 0x00000c4c, 0xffffffff, 0x38384042, },
	{ 0, 0, 2, 0x00000ce0, 0xffffffff, 0x42424242, },
	{ 0, 0, 2, 0x00000ce4, 0xffffffff, 0x38404242, },
	{ 0, 0, 2, 0x00000ce8, 0x0000ffff, 0x20203636, },
	{ 0, 1, 0, 0x00000e20, 0xffffffff, 0x48484848, },
	{ 0, 1, 0, 0x00000e24, 0xffffffff, 0x46464646, },
	{ 0, 1, 0, 0x00000e28, 0xffffffff, 0x44464646, },
	{ 0, 1, 0, 0x00000e2c, 0xffffffff, 0x46464646, },
	{ 0, 1, 0, 0x00000e30, 0xffffffff, 0x42444646, },
	{ 0, 1, 1, 0x00000e34, 0xffffffff, 0x44444444, },
	{ 0, 1, 1, 0x00000e38, 0xffffffff, 0x40424444, },
	{ 0, 1, 2, 0x00000ed8, 0xffffffff, 0x42424242, },
	{ 0, 1, 2, 0x00000edc, 0xffffffff, 0x38404242, },
	{ 0, 1, 0, 0x00000e3c, 0xffffffff, 0x46464646, },
	{ 0, 1, 0, 0x00000e40, 0xffffffff, 0x42444646, },
	{ 0, 1, 0, 0x00000e44, 0xffffffff, 0x44444040, },
	{ 0, 1, 1, 0x00000e48, 0xffffffff, 0x44444444, },
	{ 0, 1, 1, 0x00000e4c, 0xffffffff, 0x38384042, },
	{ 0, 1, 2, 0x00000ee0, 0xffffffff, 0x42424242, },
	{ 0, 1, 2, 0x00000ee4, 0xffffffff, 0x38404242, },
	{ 0, 1, 2, 0x00000ee8, 0x0000ffff, 0x20203636, },
	{ 0, 2, 0, 0x00001820, 0xffffffff, 0x48484848, },
	{ 0, 2, 0, 0x00001824, 0xffffffff, 0x46464646, },
	{ 0, 2, 0, 0x00001828, 0xffffffff, 0x44464646, },
	{ 0, 2, 0, 0x0000182c, 0xffffffff, 0x46464646, },
	{ 0, 2, 0, 0x00001830, 0xffffffff, 0x42444646, },
	{ 0, 2, 1, 0x00001834, 0xffffffff, 0x44444444, },
	{ 0, 2, 1, 0x00001838, 0xffffffff, 0x40424444, },
	{ 0, 2, 2, 0x000018d8, 0xffffffff, 0x42424242, },
	{ 0, 2, 2, 0x000018dc, 0xffffffff, 0x38404242, },
	{ 0, 2, 0, 0x0000183c, 0xffffffff, 0x46464646, },
	{ 0, 2, 0, 0x00001840, 0xffffffff, 0x42444646, },
	{ 0, 2, 0, 0x00001844, 0xffffffff, 0x44444040, },
	{ 0, 2, 1, 0x00001848, 0xffffffff, 0x44444444, },
	{ 0, 2, 1, 0x0000184c, 0xffffffff, 0x38384042, },
	{ 0, 2, 2, 0x000018e0, 0xffffffff, 0x42424242, },
	{ 0, 2, 2, 0x000018e4, 0xffffffff, 0x38404242, },
	{ 0, 2, 2, 0x000018e8, 0x0000ffff, 0x20203636, },
	{ 0, 3, 0, 0x00001a20, 0xffffffff, 0x48484848, },
	{ 0, 3, 0, 0x00001a24, 0xffffffff, 0x46464646, },
	{ 0, 3, 0, 0x00001a28, 0xffffffff, 0x44464646, },
	{ 0, 3, 0, 0x00001a2c, 0xffffffff, 0x46464646, },
	{ 0, 3, 0, 0x00001a30, 0xffffffff, 0x42444646, },
	{ 0, 3, 1, 0x00001a34, 0xffffffff, 0x44444444, },
	{ 0, 3, 1, 0x00001a38, 0xffffffff, 0x40424444, },
	{ 0, 3, 2, 0x00001ad8, 0xffffffff, 0x42424242, },
	{ 0, 3, 2, 0x00001adc, 0xffffffff, 0x38404242, },
	{ 0, 3, 0, 0x00001a3c, 0xffffffff, 0x46464646, },
	{ 0, 3, 0, 0x00001a40, 0xffffffff, 0x42444646, },
	{ 0, 3, 0, 0x00001a44, 0xffffffff, 0x44444040, },
	{ 0, 3, 1, 0x00001a48, 0xffffffff, 0x44444444, },
	{ 0, 3, 1, 0x00001a4c, 0xffffffff, 0x38384042, },
	{ 0, 3, 2, 0x00001ae0, 0xffffffff, 0x42424242, },
	{ 0, 3, 2, 0x00001ae4, 0xffffffff, 0x38404242, },
	{ 0, 3, 2, 0x00001ae8, 0x0000ffff, 0x20203636, },
	{ 1, 0, 0, 0x00000c24, 0xffffffff, 0x46464646, },
	{ 1, 0, 0, 0x00000c28, 0xffffffff, 0x44464646, },
	{ 1, 0, 0, 0x00000c2c, 0xffffffff, 0x46464646, },
	{ 1, 0, 0, 0x00000c30, 0xffffffff, 0x42444646, },
	{ 1, 0, 1, 0x00000c34, 0xffffffff, 0x44444444, },
	{ 1, 0, 1, 0x00000c38, 0xffffffff, 0x40424444, },
	{ 1, 0, 2, 0x00000cd8, 0xffffffff, 0x42424242, },
	{ 1, 0, 2, 0x00000cdc, 0xffffffff, 0x38404242, },
	{ 1, 0, 0, 0x00000c3c, 0xffffffff, 0x46464646, },
	{ 1, 0, 0, 0x00000c40, 0xffffffff, 0x42444646, },
	{ 1, 0, 0, 0x00000c44, 0xffffffff, 0x44443840, },
	{ 1, 0, 1, 0x00000c48, 0xffffffff, 0x44444444, },
	{ 1, 0, 1, 0x00000c4c, 0xffffffff, 0x36384042, },
	{ 1, 0, 2, 0x00000ce0, 0xffffffff, 0x42424242, },
	{ 1, 0, 2, 0x00000ce4, 0xffffffff, 0x38404242, },
	{ 1, 0, 2, 0x00000ce8, 0x0000ffff, 0x20203436, },
	{ 1, 1, 0, 0x00000e24, 0xffffffff, 0x46464646, },
	{ 1, 1, 0, 0x00000e28, 0xffffffff, 0x44464646, },
	{ 1, 1, 0, 0x00000e2c, 0xffffffff, 0x46464646, },
	{ 1, 1, 0, 0x00000e30, 0xffffffff, 0x42444646, },
	{ 1, 1, 1, 0x00000e34, 0xffffffff, 0x44444444, },
	{ 1, 1, 1, 0x00000e38, 0xffffffff, 0x40424444, },
	{ 1, 1, 2, 0x00000ed8, 0xffffffff, 0x42424242, },
	{ 1, 1, 2, 0x00000edc, 0xffffffff, 0x38404242, },
	{ 1, 1, 0, 0x00000e3c, 0xffffffff, 0x46464646, },
	{ 1, 1, 0, 0x00000e40, 0xffffffff, 0x42444646, },
	{ 1, 1, 0, 0x00000e44, 0xffffffff, 0x44443840, },
	{ 1, 1, 1, 0x00000e48, 0xffffffff, 0x44444444, },
	{ 1, 1, 1, 0x00000e4c, 0xffffffff, 0x36384042, },
	{ 1, 1, 2, 0x00000ee0, 0xffffffff, 0x42424242, },
	{ 1, 1, 2, 0x00000ee4, 0xffffffff, 0x38404242, },
	{ 1, 1, 2, 0x00000ee8, 0x0000ffff, 0x20203436, },
	{ 1, 2, 0, 0x00001824, 0xffffffff, 0x46464646, },
	{ 1, 2, 0, 0x00001828, 0xffffffff, 0x44464646, },
	{ 1, 2, 0, 0x0000182c, 0xffffffff, 0x46464646, },
	{ 1, 2, 0, 0x00001830, 0xffffffff, 0x42444646, },
	{ 1, 2, 1, 0x00001834, 0xffffffff, 0x44444444, },
	{ 1, 2, 1, 0x00001838, 0xffffffff, 0x40424444, },
	{ 1, 2, 2, 0x000018d8, 0xffffffff, 0x42424242, },
	{ 1, 2, 2, 0x000018dc, 0xffffffff, 0x38404242, },
	{ 1, 2, 0, 0x0000183c, 0xffffffff, 0x46464646, },
	{ 1, 2, 0, 0x00001840, 0xffffffff, 0x42444646, },
	{ 1, 2, 0, 0x00001844, 0xffffffff, 0x44443840, },
	{ 1, 2, 1, 0x00001848, 0xffffffff, 0x44444444, },
	{ 1, 2, 1, 0x0000184c, 0xffffffff, 0x36384042, },
	{ 1, 2, 2, 0x000018e0, 0xffffffff, 0x42424242, },
	{ 1, 2, 2, 0x000018e4, 0xffffffff, 0x38404242, },
	{ 1, 2, 2, 0x000018e8, 0x0000ffff, 0x20203436, },
	{ 1, 3, 0, 0x00001a24, 0xffffffff, 0x46464646, },
	{ 1, 3, 0, 0x00001a28, 0xffffffff, 0x44464646, },
	{ 1, 3, 0, 0x00001a2c, 0xffffffff, 0x46464646, },
	{ 1, 3, 0, 0x00001a30, 0xffffffff, 0x42444646, },
	{ 1, 3, 1, 0x00001a34, 0xffffffff, 0x44444444, },
	{ 1, 3, 1, 0x00001a38, 0xffffffff, 0x40424444, },
	{ 1, 3, 2, 0x00001ad8, 0xffffffff, 0x42424242, },
	{ 1, 3, 2, 0x00001adc, 0xffffffff, 0x38404242, },
	{ 1, 3, 0, 0x00001a3c, 0xffffffff, 0x46464646, },
	{ 1, 3, 0, 0x00001a40, 0xffffffff, 0x42444646, },
	{ 1, 3, 0, 0x00001a44, 0xffffffff, 0x44443840, },
	{ 1, 3, 1, 0x00001a48, 0xffffffff, 0x44444444, },
	{ 1, 3, 1, 0x00001a4c, 0xffffffff, 0x36384042, },
	{ 1, 3, 2, 0x00001ae0, 0xffffffff, 0x42424242, },
	{ 1, 3, 2, 0x00001ae4, 0xffffffff, 0x38404242, },
	{ 1, 3, 2, 0x00001ae8, 0x0000ffff, 0x20203436, },
};

RTW_DECL_TABLE_BB_PG(rtw8814a_bb_pg_type5);

static const struct rtw_phy_pg_cfg_pair rtw8814a_bb_pg_type7[] = {
	{ 0, 0, 0, 0x00000c20, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c24, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c28, 0xffffffff, 0x30323434, },
	{ 0, 0, 0, 0x00000c2c, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c30, 0xffffffff, 0x28303234, },
	{ 0, 0, 1, 0x00000c34, 0xffffffff, 0x34343434, },
	{ 0, 0, 1, 0x00000c38, 0xffffffff, 0x28303234, },
	{ 0, 0, 2, 0x00000cd8, 0xffffffff, 0x34343434, },
	{ 0, 0, 2, 0x00000cdc, 0xffffffff, 0x28303234, },
	{ 0, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c40, 0xffffffff, 0x28303234, },
	{ 0, 0, 0, 0x00000c44, 0xffffffff, 0x34342426, },
	{ 0, 0, 1, 0x00000c48, 0xffffffff, 0x32343434, },
	{ 0, 0, 1, 0x00000c4c, 0xffffffff, 0x24262830, },
	{ 0, 0, 2, 0x00000ce0, 0xffffffff, 0x34343434, },
	{ 0, 0, 2, 0x00000ce4, 0xffffffff, 0x28303234, },
	{ 0, 0, 2, 0x00000ce8, 0x0000ffff, 0x24263434, },
	{ 0, 1, 0, 0x00000e20, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e24, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e28, 0xffffffff, 0x30323434, },
	{ 0, 1, 0, 0x00000e2c, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e30, 0xffffffff, 0x28303234, },
	{ 0, 1, 1, 0x00000e34, 0xffffffff, 0x34343434, },
	{ 0, 1, 1, 0x00000e38, 0xffffffff, 0x28303234, },
	{ 0, 1, 2, 0x00000ed8, 0xffffffff, 0x34343434, },
	{ 0, 1, 2, 0x00000edc, 0xffffffff, 0x28303234, },
	{ 0, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e40, 0xffffffff, 0x28303234, },
	{ 0, 1, 0, 0x00000e44, 0xffffffff, 0x34342426, },
	{ 0, 1, 1, 0x00000e48, 0xffffffff, 0x32343434, },
	{ 0, 1, 1, 0x00000e4c, 0xffffffff, 0x24262830, },
	{ 0, 1, 2, 0x00000ee0, 0xffffffff, 0x34343434, },
	{ 0, 1, 2, 0x00000ee4, 0xffffffff, 0x28303234, },
	{ 0, 1, 2, 0x00000ee8, 0x0000ffff, 0x24263434, },
	{ 0, 2, 0, 0x00001820, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001824, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001828, 0xffffffff, 0x30323434, },
	{ 0, 2, 0, 0x0000182c, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001830, 0xffffffff, 0x28303234, },
	{ 0, 2, 1, 0x00001834, 0xffffffff, 0x34343434, },
	{ 0, 2, 1, 0x00001838, 0xffffffff, 0x28303234, },
	{ 0, 2, 2, 0x000018d8, 0xffffffff, 0x34343434, },
	{ 0, 2, 2, 0x000018dc, 0xffffffff, 0x28303234, },
	{ 0, 2, 0, 0x0000183c, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001840, 0xffffffff, 0x28303234, },
	{ 0, 2, 0, 0x00001844, 0xffffffff, 0x34342426, },
	{ 0, 2, 1, 0x00001848, 0xffffffff, 0x32343434, },
	{ 0, 2, 1, 0x0000184c, 0xffffffff, 0x24262830, },
	{ 0, 2, 2, 0x000018e0, 0xffffffff, 0x34343434, },
	{ 0, 2, 2, 0x000018e4, 0xffffffff, 0x28303234, },
	{ 0, 2, 2, 0x000018e8, 0x0000ffff, 0x24263434, },
	{ 0, 3, 0, 0x00001a20, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a24, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a28, 0xffffffff, 0x30323434, },
	{ 0, 3, 0, 0x00001a2c, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a30, 0xffffffff, 0x28303234, },
	{ 0, 3, 1, 0x00001a34, 0xffffffff, 0x34343434, },
	{ 0, 3, 1, 0x00001a38, 0xffffffff, 0x28303234, },
	{ 0, 3, 2, 0x00001ad8, 0xffffffff, 0x34343434, },
	{ 0, 3, 2, 0x00001adc, 0xffffffff, 0x28303234, },
	{ 0, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a40, 0xffffffff, 0x28303234, },
	{ 0, 3, 0, 0x00001a44, 0xffffffff, 0x34342426, },
	{ 0, 3, 1, 0x00001a48, 0xffffffff, 0x32343434, },
	{ 0, 3, 1, 0x00001a4c, 0xffffffff, 0x24262830, },
	{ 0, 3, 2, 0x00001ae0, 0xffffffff, 0x34343434, },
	{ 0, 3, 2, 0x00001ae4, 0xffffffff, 0x28303234, },
	{ 0, 3, 2, 0x00001ae8, 0x0000ffff, 0x24263434, },
	{ 1, 0, 0, 0x00000c24, 0xffffffff, 0x34343434, },
	{ 1, 0, 0, 0x00000c28, 0xffffffff, 0x30323434, },
	{ 1, 0, 0, 0x00000c2c, 0xffffffff, 0x34343434, },
	{ 1, 0, 0, 0x00000c30, 0xffffffff, 0x28303234, },
	{ 1, 0, 1, 0x00000c34, 0xffffffff, 0x34343434, },
	{ 1, 0, 1, 0x00000c38, 0xffffffff, 0x28303234, },
	{ 1, 0, 2, 0x00000cd8, 0xffffffff, 0x34343434, },
	{ 1, 0, 2, 0x00000cdc, 0xffffffff, 0x28303234, },
	{ 1, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434, },
	{ 1, 0, 0, 0x00000c40, 0xffffffff, 0x28303234, },
	{ 1, 0, 0, 0x00000c44, 0xffffffff, 0x34342426, },
	{ 1, 0, 1, 0x00000c48, 0xffffffff, 0x32343434, },
	{ 1, 0, 1, 0x00000c4c, 0xffffffff, 0x24262830, },
	{ 1, 0, 2, 0x00000ce0, 0xffffffff, 0x34343434, },
	{ 1, 0, 2, 0x00000ce4, 0xffffffff, 0x28303234, },
	{ 1, 0, 2, 0x00000ce8, 0x0000ffff, 0x24263434, },
	{ 1, 1, 0, 0x00000e24, 0xffffffff, 0x34343434, },
	{ 1, 1, 0, 0x00000e28, 0xffffffff, 0x30323434, },
	{ 1, 1, 0, 0x00000e2c, 0xffffffff, 0x34343434, },
	{ 1, 1, 0, 0x00000e30, 0xffffffff, 0x28303234, },
	{ 1, 1, 1, 0x00000e34, 0xffffffff, 0x34343434, },
	{ 1, 1, 1, 0x00000e38, 0xffffffff, 0x28303234, },
	{ 1, 1, 2, 0x00000ed8, 0xffffffff, 0x34343434, },
	{ 1, 1, 2, 0x00000edc, 0xffffffff, 0x28303234, },
	{ 1, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434, },
	{ 1, 1, 0, 0x00000e40, 0xffffffff, 0x28303234, },
	{ 1, 1, 0, 0x00000e44, 0xffffffff, 0x34342426, },
	{ 1, 1, 1, 0x00000e48, 0xffffffff, 0x32343434, },
	{ 1, 1, 1, 0x00000e4c, 0xffffffff, 0x24262830, },
	{ 1, 1, 2, 0x00000ee0, 0xffffffff, 0x34343434, },
	{ 1, 1, 2, 0x00000ee4, 0xffffffff, 0x28303234, },
	{ 1, 1, 2, 0x00000ee8, 0x0000ffff, 0x24263434, },
	{ 1, 2, 0, 0x00001824, 0xffffffff, 0x34343434, },
	{ 1, 2, 0, 0x00001828, 0xffffffff, 0x30323434, },
	{ 1, 2, 0, 0x0000182c, 0xffffffff, 0x34343434, },
	{ 1, 2, 0, 0x00001830, 0xffffffff, 0x28303234, },
	{ 1, 2, 1, 0x00001834, 0xffffffff, 0x34343434, },
	{ 1, 2, 1, 0x00001838, 0xffffffff, 0x28303234, },
	{ 1, 2, 2, 0x000018d8, 0xffffffff, 0x34343434, },
	{ 1, 2, 2, 0x000018dc, 0xffffffff, 0x28303234, },
	{ 1, 2, 0, 0x0000183c, 0xffffffff, 0x34343434, },
	{ 1, 2, 0, 0x00001840, 0xffffffff, 0x28303234, },
	{ 1, 2, 0, 0x00001844, 0xffffffff, 0x34342426, },
	{ 1, 2, 1, 0x00001848, 0xffffffff, 0x32343434, },
	{ 1, 2, 1, 0x0000184c, 0xffffffff, 0x24262830, },
	{ 1, 2, 2, 0x000018e0, 0xffffffff, 0x34343434, },
	{ 1, 2, 2, 0x000018e4, 0xffffffff, 0x28303234, },
	{ 1, 2, 2, 0x000018e8, 0x0000ffff, 0x24263434, },
	{ 1, 3, 0, 0x00001a24, 0xffffffff, 0x34343434, },
	{ 1, 3, 0, 0x00001a28, 0xffffffff, 0x30323434, },
	{ 1, 3, 0, 0x00001a2c, 0xffffffff, 0x34343434, },
	{ 1, 3, 0, 0x00001a30, 0xffffffff, 0x28303234, },
	{ 1, 3, 1, 0x00001a34, 0xffffffff, 0x34343434, },
	{ 1, 3, 1, 0x00001a38, 0xffffffff, 0x28303234, },
	{ 1, 3, 2, 0x00001ad8, 0xffffffff, 0x34343434, },
	{ 1, 3, 2, 0x00001adc, 0xffffffff, 0x28303234, },
	{ 1, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434, },
	{ 1, 3, 0, 0x00001a40, 0xffffffff, 0x28303234, },
	{ 1, 3, 0, 0x00001a44, 0xffffffff, 0x34342426, },
	{ 1, 3, 1, 0x00001a48, 0xffffffff, 0x32343434, },
	{ 1, 3, 1, 0x00001a4c, 0xffffffff, 0x24262830, },
	{ 1, 3, 2, 0x00001ae0, 0xffffffff, 0x34343434, },
	{ 1, 3, 2, 0x00001ae4, 0xffffffff, 0x28303234, },
	{ 1, 3, 2, 0x00001ae8, 0x0000ffff, 0x24263434, },
};

RTW_DECL_TABLE_BB_PG(rtw8814a_bb_pg_type7);

static const struct rtw_phy_pg_cfg_pair rtw8814a_bb_pg_type8[] = {
	{ 0, 0, 0, 0x00000c20, 0xffffffff, 0x43434343, },
	{ 0, 0, 0, 0x00000c24, 0xffffffff, 0x43434343, },
	{ 0, 0, 0, 0x00000c28, 0xffffffff, 0x35373941, },
	{ 0, 0, 0, 0x00000c2c, 0xffffffff, 0x43434343, },
	{ 0, 0, 0, 0x00000c30, 0xffffffff, 0x33353739, },
	{ 0, 0, 1, 0x00000c34, 0xffffffff, 0x43434343, },
	{ 0, 0, 1, 0x00000c38, 0xffffffff, 0x31333537, },
	{ 0, 0, 2, 0x00000cd8, 0xffffffff, 0x43434343, },
	{ 0, 0, 2, 0x00000cdc, 0xffffffff, 0x29313335, },
	{ 0, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c40, 0xffffffff, 0x28303234, },
	{ 0, 0, 0, 0x00000c44, 0xffffffff, 0x32322426, },
	{ 0, 0, 1, 0x00000c48, 0xffffffff, 0x30323232, },
	{ 0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628, },
	{ 0, 0, 2, 0x00000ce0, 0xffffffff, 0x30303030, },
	{ 0, 0, 2, 0x00000ce4, 0xffffffff, 0x24262830, },
	{ 0, 0, 2, 0x00000ce8, 0x0000ffff, 0x20222222, },
	{ 0, 1, 0, 0x00000e20, 0xffffffff, 0x43434343, },
	{ 0, 1, 0, 0x00000e24, 0xffffffff, 0x43434343, },
	{ 0, 1, 0, 0x00000e28, 0xffffffff, 0x35373941, },
	{ 0, 1, 0, 0x00000e2c, 0xffffffff, 0x41434343, },
	{ 0, 1, 0, 0x00000e30, 0xffffffff, 0x33353739, },
	{ 0, 1, 1, 0x00000e34, 0xffffffff, 0x39414141, },
	{ 0, 1, 1, 0x00000e38, 0xffffffff, 0x31333537, },
	{ 0, 1, 2, 0x00000ed8, 0xffffffff, 0x37393939, },
	{ 0, 1, 2, 0x00000edc, 0xffffffff, 0x29313335, },
	{ 0, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e40, 0xffffffff, 0x28303234, },
	{ 0, 1, 0, 0x00000e44, 0xffffffff, 0x32322426, },
	{ 0, 1, 1, 0x00000e48, 0xffffffff, 0x30323232, },
	{ 0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628, },
	{ 0, 1, 2, 0x00000ee0, 0xffffffff, 0x30303030, },
	{ 0, 1, 2, 0x00000ee4, 0xffffffff, 0x24262830, },
	{ 0, 1, 2, 0x00000ee8, 0x0000ffff, 0x20222222, },
	{ 0, 2, 0, 0x00001820, 0xffffffff, 0x43434343, },
	{ 0, 2, 0, 0x00001824, 0xffffffff, 0x43434343, },
	{ 0, 2, 0, 0x00001828, 0xffffffff, 0x35373941, },
	{ 0, 2, 0, 0x0000182c, 0xffffffff, 0x41434343, },
	{ 0, 2, 0, 0x00001830, 0xffffffff, 0x33353739, },
	{ 0, 2, 1, 0x00001834, 0xffffffff, 0x39414141, },
	{ 0, 2, 1, 0x00001838, 0xffffffff, 0x31333537, },
	{ 0, 2, 2, 0x000018d8, 0xffffffff, 0x37393939, },
	{ 0, 2, 2, 0x000018dc, 0xffffffff, 0x29313335, },
	{ 0, 2, 0, 0x0000183c, 0xffffffff, 0x34343434, },
	{ 0, 2, 0, 0x00001840, 0xffffffff, 0x28303234, },
	{ 0, 2, 0, 0x00001844, 0xffffffff, 0x32322426, },
	{ 0, 2, 1, 0x00001848, 0xffffffff, 0x30323232, },
	{ 0, 2, 1, 0x0000184c, 0xffffffff, 0x22242628, },
	{ 0, 2, 2, 0x000018e0, 0xffffffff, 0x30303030, },
	{ 0, 2, 2, 0x000018e4, 0xffffffff, 0x24262830, },
	{ 0, 2, 2, 0x000018e8, 0x0000ffff, 0x20222222, },
	{ 0, 3, 0, 0x00001a20, 0xffffffff, 0x43434343, },
	{ 0, 3, 0, 0x00001a24, 0xffffffff, 0x43434343, },
	{ 0, 3, 0, 0x00001a28, 0xffffffff, 0x35373941, },
	{ 0, 3, 0, 0x00001a2c, 0xffffffff, 0x41434343, },
	{ 0, 3, 0, 0x00001a30, 0xffffffff, 0x33353739, },
	{ 0, 3, 1, 0x00001a34, 0xffffffff, 0x39414141, },
	{ 0, 3, 1, 0x00001a38, 0xffffffff, 0x31333537, },
	{ 0, 3, 2, 0x00001ad8, 0xffffffff, 0x37393939, },
	{ 0, 3, 2, 0x00001adc, 0xffffffff, 0x29313335, },
	{ 0, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434, },
	{ 0, 3, 0, 0x00001a40, 0xffffffff, 0x28303234, },
	{ 0, 3, 0, 0x00001a44, 0xffffffff, 0x32322426, },
	{ 0, 3, 1, 0x00001a48, 0xffffffff, 0x30323232, },
	{ 0, 3, 1, 0x00001a4c, 0xffffffff, 0x22242628, },
	{ 0, 3, 2, 0x00001ae0, 0xffffffff, 0x30303030, },
	{ 0, 3, 2, 0x00001ae4, 0xffffffff, 0x24262830, },
	{ 0, 3, 2, 0x00001ae8, 0x0000ffff, 0x20222222, },
	{ 1, 0, 0, 0x00000c24, 0xffffffff, 0x46464646, },
	{ 1, 0, 0, 0x00000c28, 0xffffffff, 0x39414345, },
	{ 1, 0, 0, 0x00000c2c, 0xffffffff, 0x46464646, },
	{ 1, 0, 0, 0x00000c30, 0xffffffff, 0x38404244, },
	{ 1, 0, 1, 0x00000c34, 0xffffffff, 0x46464646, },
	{ 1, 0, 1, 0x00000c38, 0xffffffff, 0x36384042, },
	{ 1, 0, 2, 0x00000cd8, 0xffffffff, 0x46464646, },
	{ 1, 0, 2, 0x00000cdc, 0xffffffff, 0x34363840, },
	{ 1, 0, 0, 0x00000c3c, 0xffffffff, 0x46464646, },
	{ 1, 0, 0, 0x00000c40, 0xffffffff, 0x38404244, },
	{ 1, 0, 0, 0x00000c44, 0xffffffff, 0x46463738, },
	{ 1, 0, 1, 0x00000c48, 0xffffffff, 0x42444646, },
	{ 1, 0, 1, 0x00000c4c, 0xffffffff, 0x35373840, },
	{ 1, 0, 2, 0x00000ce0, 0xffffffff, 0x46464646, },
	{ 1, 0, 2, 0x00000ce4, 0xffffffff, 0x37394143, },
	{ 1, 0, 2, 0x00000ce8, 0x0000ffff, 0x33333335, },
	{ 1, 1, 0, 0x00000e24, 0xffffffff, 0x46464646, },
	{ 1, 1, 0, 0x00000e28, 0xffffffff, 0x39414345, },
	{ 1, 1, 0, 0x00000e2c, 0xffffffff, 0x46464646, },
	{ 1, 1, 0, 0x00000e30, 0xffffffff, 0x38404244, },
	{ 1, 1, 1, 0x00000e34, 0xffffffff, 0x46464646, },
	{ 1, 1, 1, 0x00000e38, 0xffffffff, 0x36384042, },
	{ 1, 1, 2, 0x00000ed8, 0xffffffff, 0x46464646, },
	{ 1, 1, 2, 0x00000edc, 0xffffffff, 0x34363840, },
	{ 1, 1, 0, 0x00000e3c, 0xffffffff, 0x46464646, },
	{ 1, 1, 0, 0x00000e40, 0xffffffff, 0x38404244, },
	{ 1, 1, 0, 0x00000e44, 0xffffffff, 0x46463738, },
	{ 1, 1, 1, 0x00000e48, 0xffffffff, 0x42444646, },
	{ 1, 1, 1, 0x00000e4c, 0xffffffff, 0x35373840, },
	{ 1, 1, 2, 0x00000ee0, 0xffffffff, 0x46464646, },
	{ 1, 1, 2, 0x00000ee4, 0xffffffff, 0x37394143, },
	{ 1, 1, 2, 0x00000ee8, 0x0000ffff, 0x33333335, },
	{ 1, 2, 0, 0x00001824, 0xffffffff, 0x46464646, },
	{ 1, 2, 0, 0x00001828, 0xffffffff, 0x39414345, },
	{ 1, 2, 0, 0x0000182c, 0xffffffff, 0x46464646, },
	{ 1, 2, 0, 0x00001830, 0xffffffff, 0x38404244, },
	{ 1, 2, 1, 0x00001834, 0xffffffff, 0x46464646, },
	{ 1, 2, 1, 0x00001838, 0xffffffff, 0x36384042, },
	{ 1, 2, 2, 0x000018d8, 0xffffffff, 0x46464646, },
	{ 1, 2, 2, 0x000018dc, 0xffffffff, 0x34363840, },
	{ 1, 2, 0, 0x0000183c, 0xffffffff, 0x46464646, },
	{ 1, 2, 0, 0x00001840, 0xffffffff, 0x38404244, },
	{ 1, 2, 0, 0x00001844, 0xffffffff, 0x46463738, },
	{ 1, 2, 1, 0x00001848, 0xffffffff, 0x42444646, },
	{ 1, 2, 1, 0x0000184c, 0xffffffff, 0x35373840, },
	{ 1, 2, 2, 0x000018e0, 0xffffffff, 0x46464646, },
	{ 1, 2, 2, 0x000018e4, 0xffffffff, 0x37394143, },
	{ 1, 2, 2, 0x000018e8, 0x0000ffff, 0x33333335, },
	{ 1, 3, 0, 0x00001a24, 0xffffffff, 0x46464646, },
	{ 1, 3, 0, 0x00001a28, 0xffffffff, 0x39414345, },
	{ 1, 3, 0, 0x00001a2c, 0xffffffff, 0x46464646, },
	{ 1, 3, 0, 0x00001a30, 0xffffffff, 0x38404244, },
	{ 1, 3, 1, 0x00001a34, 0xffffffff, 0x46464646, },
	{ 1, 3, 1, 0x00001a38, 0xffffffff, 0x36384042, },
	{ 1, 3, 2, 0x00001ad8, 0xffffffff, 0x46464646, },
	{ 1, 3, 2, 0x00001adc, 0xffffffff, 0x34363840, },
	{ 1, 3, 0, 0x00001a3c, 0xffffffff, 0x46464646, },
	{ 1, 3, 0, 0x00001a40, 0xffffffff, 0x38404244, },
	{ 1, 3, 0, 0x00001a44, 0xffffffff, 0x46463738, },
	{ 1, 3, 1, 0x00001a48, 0xffffffff, 0x42444646, },
	{ 1, 3, 1, 0x00001a4c, 0xffffffff, 0x35373840, },
	{ 1, 3, 2, 0x00001ae0, 0xffffffff, 0x46464646, },
	{ 1, 3, 2, 0x00001ae4, 0xffffffff, 0x37394143, },
	{ 1, 3, 2, 0x00001ae8, 0x0000ffff, 0x33333335, },
};

RTW_DECL_TABLE_BB_PG(rtw8814a_bb_pg_type8);

static const u32 rtw8814a_rf_a[] = {
		0x018, 0x00013124,
		0x040, 0x00000C00,
		0x058, 0x00000F98,
		0x07F, 0x00068004,
		0x0B0, 0x000FFFFE,
		0x0B1, 0x0003FF48,
		0x0B2, 0x0006AA3F,
		0x0B3, 0x000FFC9A,
		0x0B4, 0x0000A78F,
		0x0B5, 0x00000A3F,
		0x0B6, 0x0000C09C,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0xA0000000,	0x00000000,
		0x0B7, 0x0003000C,
	0xB0000000,	0x00000000,
		0x0B8, 0x0007400E,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B9, 0x000FBF50,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B9, 0x000FBF50,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0B9, 0x000FBF50,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B9, 0x000FBF50,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0B9, 0x000FBF50,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x0B9, 0x000FBF50,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x0B9, 0x000FBF50,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x0B9, 0x000FBF50,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x0B9, 0x000FBF50,
	0xA0000000,	0x00000000,
		0x0B9, 0x000FBF50,
	0xB0000000,	0x00000000,
		0x0BA, 0x00050780,
		0x0BB, 0x00000000,
		0x0BC, 0x00040009,
		0x0BD, 0x00000000,
		0x0BE, 0x00000000,
		0x0BF, 0x00000000,
		0x0EF, 0x00020000,
		0x03E, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030000,
	0xA0000000,	0x00000000,
		0x03F, 0x00030000,
	0xB0000000,	0x00000000,
		0x03E, 0x00020000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00040000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00040000,
	0xA0000000,	0x00000000,
		0x03F, 0x00040000,
	0xB0000000,	0x00000000,
		0x03E, 0x00040000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030000,
	0xA0000000,	0x00000000,
		0x03F, 0x00030000,
	0xB0000000,	0x00000000,
		0x03E, 0x00060000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030000,
	0xA0000000,	0x00000000,
		0x03F, 0x00030000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00010000,
		0x03E, 0x00000000,
		0x03F, 0x00006800,
		0x03E, 0x00000080,
		0x03F, 0x00006000,
		0x03E, 0x00000100,
		0x03F, 0x00004800,
		0x03E, 0x00000180,
		0x03F, 0x00004000,
		0x03E, 0x00000200,
		0x03F, 0x00004000,
		0x03E, 0x00000280,
		0x03F, 0x00002800,
		0x03E, 0x00000300,
		0x03F, 0x00002800,
		0x03E, 0x00000380,
		0x03F, 0x00002000,
		0x0EF, 0x00000000,
		0x0EF, 0x00040000,
		0x03E, 0x00000000,
		0x03F, 0x000000BC,
		0x03E, 0x00000040,
		0x03F, 0x00000053,
		0x03E, 0x00000050,
		0x03F, 0x00000050,
		0x03E, 0x00000060,
		0x03F, 0x00000050,
		0x0EF, 0x00000000,
		0x0EF, 0x00000400,
		0x03E, 0x00000006,
		0x041, 0x000EE080,
		0x03E, 0x00000008,
		0x041, 0x000EE0C0,
		0x03E, 0x0000000A,
		0x041, 0x000EE100,
		0x03E, 0x0000000C,
		0x041, 0x000EE100,
		0x0EF, 0x00000000,
		0x018, 0x00000006,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0xA0000000,	0x00000000,
		0x086, 0x000E4B58,
		0x087, 0x00049F80,
	0xB0000000,	0x00000000,
		0x0DF, 0x00000008,
		0x0EF, 0x00002000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x000179C3,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x000179C3,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x000179C3,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x000179C3,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x000179C3,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x000179C3,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x000179C3,
	0xA0000000,	0x00000000,
		0x03B, 0x0003F258,
		0x03B, 0x00030A58,
		0x03B, 0x0002FA58,
		0x03B, 0x00022590,
		0x03B, 0x0001FA50,
		0x03B, 0x00010248,
		0x03B, 0x00008240,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000100,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0000ADF6,
		0x034, 0x00009DF3,
		0x034, 0x00008DF0,
		0x034, 0x00007DED,
		0x034, 0x00006DEA,
		0x034, 0x00005CED,
		0x034, 0x00004CEA,
		0x034, 0x000034EA,
		0x034, 0x000024E7,
		0x034, 0x0000146A,
		0x034, 0x0000006B,
	0xB0000000,	0x00000000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0008ADF6,
		0x034, 0x00089DF3,
		0x034, 0x00088DF0,
		0x034, 0x00087DED,
		0x034, 0x00086DEA,
		0x034, 0x00085CED,
		0x034, 0x00084CEA,
		0x034, 0x000834EA,
		0x034, 0x000824E7,
		0x034, 0x0008146A,
		0x034, 0x0008006B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x000020A2,
		0x0DF, 0x00000080,
		0x035, 0x00000192,
		0x035, 0x00008192,
		0x035, 0x00010192,
		0x036, 0x00000024,
		0x036, 0x00008024,
		0x036, 0x00010024,
		0x036, 0x00018024,
		0x0EF, 0x00000000,
		0x051, 0x00000C21,
		0x052, 0x000006D9,
		0x053, 0x000FC649,
		0x054, 0x0000017E,
		0x018, 0x0001012A,
		0x081, 0x0007FC00,
		0x089, 0x00050110,
		0x08A, 0x00043E50,
		0x08B, 0x0002E180,
		0x08C, 0x00093C3C,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x000F8000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x000F8000,
	0xA0000000,	0x00000000,
		0x085, 0x000F8000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0xA0000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0xB0000000,	0x00000000,
		0x0EF, 0x00001000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00084000,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0xA0000000,	0x00000000,
		0x03C, 0x00028000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00030023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00028623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00021633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0001C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00010293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00009593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0000118B,
	0xA0000000,	0x00000000,
		0x03B, 0x0000078B,
	0xB0000000,	0x00000000,
		0x03C, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x000AC000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00040000,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0xA0000000,	0x00000000,
		0x03C, 0x0004C000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00070023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00068623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00061633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0005C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00050293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00049593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0004138B,
	0xA0000000,	0x00000000,
		0x03B, 0x0004078B,
	0xB0000000,	0x00000000,
		0x03C, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00084000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0008C000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00084000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00084000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00060000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00084000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00084000,
	0xA0000000,	0x00000000,
		0x03C, 0x00004000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B0023,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0xA0000000,	0x00000000,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A8623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A1633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0009C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00090293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00089593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0008118B,
	0xA0000000,	0x00000000,
		0x03B, 0x0008078B,
	0xB0000000,	0x00000000,
		0x03C, 0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
		0x03B, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000801,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001003,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001003,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001003,
	0xA0000000,	0x00000000,
		0x03A, 0x00000803,
	0xB0000000,	0x00000000,
		0x03B, 0x00040000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001801,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000003,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000003,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001001,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0xA0000000,	0x00000000,
		0x03A, 0x00001000,
	0xB0000000,	0x00000000,
		0x03B, 0x00080000,
	0x80000007,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001802,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000800,
	0xA0000000,	0x00000000,
		0x03A, 0x00001002,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x00013124,
		0x0EF, 0x00000100,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A1AD,
		0x034, 0x000491AA,
		0x034, 0x000481A7,
		0x034, 0x000470AA,
		0x034, 0x000460A7,
		0x034, 0x00045049,
		0x034, 0x00044046,
		0x034, 0x00043026,
		0x034, 0x00042009,
		0x034, 0x00041006,
		0x034, 0x00040003,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AF,
		0x034, 0x000483AB,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004406A,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AF,
		0x034, 0x000483AB,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004406A,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AF,
		0x034, 0x000483AB,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004406A,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AF,
		0x034, 0x000483AB,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004406A,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3F5,
		0x034, 0x000493F2,
		0x034, 0x000483B0,
		0x034, 0x00047370,
		0x034, 0x0004636D,
		0x034, 0x0004536A,
		0x034, 0x00044349,
		0x034, 0x0004316A,
		0x034, 0x00042167,
		0x034, 0x00041129,
		0x034, 0x00040049,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AF,
		0x034, 0x000483AB,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004406A,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AF,
		0x034, 0x000483AB,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004406A,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0xA0000000,	0x00000000,
		0x034, 0x0004AFF1,
		0x034, 0x00049FEE,
		0x034, 0x00048FEB,
		0x034, 0x00047FE8,
		0x034, 0x00046DEA,
		0x034, 0x00045DE7,
		0x034, 0x00044CEA,
		0x034, 0x00043CE7,
		0x034, 0x00042C69,
		0x034, 0x00041C66,
		0x034, 0x00040C28,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A1AD,
		0x034, 0x000291AA,
		0x034, 0x000281A7,
		0x034, 0x000270AA,
		0x034, 0x000260A7,
		0x034, 0x00025049,
		0x034, 0x00024046,
		0x034, 0x00023026,
		0x034, 0x00022009,
		0x034, 0x00021006,
		0x034, 0x00020003,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EF,
		0x034, 0x000293AC,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EF,
		0x034, 0x000293AC,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EF,
		0x034, 0x000293AC,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EF,
		0x034, 0x000293AC,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3F5,
		0x034, 0x000293F2,
		0x034, 0x000282F1,
		0x034, 0x000272B0,
		0x034, 0x000262AD,
		0x034, 0x000252AA,
		0x034, 0x000242A7,
		0x034, 0x000230EC,
		0x034, 0x000220E9,
		0x034, 0x0002106A,
		0x034, 0x00020067,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EF,
		0x034, 0x000293AC,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EF,
		0x034, 0x000293AC,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0xA0000000,	0x00000000,
		0x034, 0x0002AFF1,
		0x034, 0x00029FEE,
		0x034, 0x00028FEB,
		0x034, 0x00027FE8,
		0x034, 0x00026DEA,
		0x034, 0x00025DE7,
		0x034, 0x00024CEA,
		0x034, 0x00023CE7,
		0x034, 0x00022C69,
		0x034, 0x00021C66,
		0x034, 0x00020C28,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EC,
		0x034, 0x0000938C,
		0x034, 0x000081AD,
		0x034, 0x000071AA,
		0x034, 0x000061A7,
		0x034, 0x000050AA,
		0x034, 0x000040A7,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x0000100C,
		0x034, 0x00000009,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3F4,
		0x034, 0x000093F1,
		0x034, 0x000082B1,
		0x034, 0x000071D1,
		0x034, 0x000061CE,
		0x034, 0x000051CB,
		0x034, 0x000041C8,
		0x034, 0x000030CB,
		0x034, 0x000020C8,
		0x034, 0x00001087,
		0x034, 0x00000084,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0xA0000000,	0x00000000,
		0x034, 0x0000AFF1,
		0x034, 0x00009FEE,
		0x034, 0x00008FEB,
		0x034, 0x00007FE8,
		0x034, 0x00006DEA,
		0x034, 0x00005DE7,
		0x034, 0x00004CEA,
		0x034, 0x00003CE7,
		0x034, 0x00002C69,
		0x034, 0x00001C66,
		0x034, 0x00000C28,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA1AD,
		0x034, 0x000C91AA,
		0x034, 0x000C81A7,
		0x034, 0x000C70AA,
		0x034, 0x000C60A7,
		0x034, 0x000C5049,
		0x034, 0x000C4046,
		0x034, 0x000C3026,
		0x034, 0x000C2009,
		0x034, 0x000C1006,
		0x034, 0x000C0003,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AF,
		0x034, 0x000C83AB,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C406A,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AF,
		0x034, 0x000C83AB,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C406A,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AF,
		0x034, 0x000C83AB,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C406A,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AF,
		0x034, 0x000C83AB,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C406A,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3F5,
		0x034, 0x000C93F2,
		0x034, 0x000C83B0,
		0x034, 0x000C7370,
		0x034, 0x000C636D,
		0x034, 0x000C536A,
		0x034, 0x000C4349,
		0x034, 0x000C316A,
		0x034, 0x000C2167,
		0x034, 0x000C1129,
		0x034, 0x000C0049,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AF,
		0x034, 0x000C83AB,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C406A,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AF,
		0x034, 0x000C83AB,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C406A,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0xA0000000,	0x00000000,
		0x034, 0x000CA794,
		0x034, 0x000C9791,
		0x034, 0x000C878E,
		0x034, 0x000C778B,
		0x034, 0x000C658D,
		0x034, 0x000C558A,
		0x034, 0x000C448D,
		0x034, 0x000C348A,
		0x034, 0x000C244C,
		0x034, 0x000C1449,
		0x034, 0x000C042B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA1AD,
		0x034, 0x000A91AA,
		0x034, 0x000A81A7,
		0x034, 0x000A70AA,
		0x034, 0x000A60A7,
		0x034, 0x000A5049,
		0x034, 0x000A4046,
		0x034, 0x000A3026,
		0x034, 0x000A2009,
		0x034, 0x000A1006,
		0x034, 0x000A0003,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EF,
		0x034, 0x000A93AC,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EF,
		0x034, 0x000A93AC,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EF,
		0x034, 0x000A93AC,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EF,
		0x034, 0x000A93AC,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3F5,
		0x034, 0x000A93F2,
		0x034, 0x000A82F1,
		0x034, 0x000A72B0,
		0x034, 0x000A62AD,
		0x034, 0x000A52AA,
		0x034, 0x000A42A7,
		0x034, 0x000A30EC,
		0x034, 0x000A20E9,
		0x034, 0x000A106A,
		0x034, 0x000A0067,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EF,
		0x034, 0x000A93AC,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EF,
		0x034, 0x000A93AC,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0xA0000000,	0x00000000,
		0x034, 0x000AA794,
		0x034, 0x000A9791,
		0x034, 0x000A878E,
		0x034, 0x000A778B,
		0x034, 0x000A658D,
		0x034, 0x000A558A,
		0x034, 0x000A448D,
		0x034, 0x000A348A,
		0x034, 0x000A244C,
		0x034, 0x000A1449,
		0x034, 0x000A042B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EC,
		0x034, 0x0008938C,
		0x034, 0x000881AD,
		0x034, 0x000871AA,
		0x034, 0x000861A7,
		0x034, 0x000850AA,
		0x034, 0x000840A7,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x0008100C,
		0x034, 0x00080009,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3F4,
		0x034, 0x000893F1,
		0x034, 0x000882B1,
		0x034, 0x000871D1,
		0x034, 0x000861CE,
		0x034, 0x000851CB,
		0x034, 0x000841C8,
		0x034, 0x000830CB,
		0x034, 0x000820C8,
		0x034, 0x00081087,
		0x034, 0x00080084,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0xA0000000,	0x00000000,
		0x034, 0x0008A794,
		0x034, 0x00089791,
		0x034, 0x0008878E,
		0x034, 0x0008778B,
		0x034, 0x0008658D,
		0x034, 0x0008558A,
		0x034, 0x0008448D,
		0x034, 0x0008348A,
		0x034, 0x0008244C,
		0x034, 0x00081449,
		0x034, 0x0008042B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0DF, 0x00000001,
		0x018, 0x0001712A,
		0x0EF, 0x00000040,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0xA0000000,	0x00000000,
		0x035, 0x00000747,
		0x035, 0x00008747,
		0x035, 0x00010747,
		0x035, 0x00020747,
		0x035, 0x00028747,
		0x035, 0x00030747,
		0x035, 0x00040747,
		0x035, 0x00048747,
		0x035, 0x00050747,
		0x035, 0x000805FB,
		0x035, 0x000885FB,
		0x035, 0x000905FB,
		0x035, 0x000A05FB,
		0x035, 0x000A85FB,
		0x035, 0x000B05FB,
		0x035, 0x000C05FB,
		0x035, 0x000C85FB,
		0x035, 0x000D05FB,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0DF, 0x00000001,
		0x018, 0x0001712A,
		0x0EF, 0x00000010,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000473,
		0x036, 0x00008473,
		0x036, 0x00010473,
		0x036, 0x00020473,
		0x036, 0x00028473,
		0x036, 0x00030473,
		0x036, 0x00040473,
		0x036, 0x00048473,
		0x036, 0x00050473,
		0x036, 0x00080473,
		0x036, 0x00088473,
		0x036, 0x00090473,
		0x036, 0x000A0473,
		0x036, 0x000A8473,
		0x036, 0x000B0473,
		0x036, 0x000C0473,
		0x036, 0x000C8473,
		0x036, 0x000D0473,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0xA0000000,	0x00000000,
		0x036, 0x00000473,
		0x036, 0x00008473,
		0x036, 0x00010473,
		0x036, 0x00020473,
		0x036, 0x00028473,
		0x036, 0x00030473,
		0x036, 0x00040473,
		0x036, 0x00048473,
		0x036, 0x00050473,
		0x036, 0x00080473,
		0x036, 0x00088473,
		0x036, 0x00090473,
		0x036, 0x000A0473,
		0x036, 0x000A8473,
		0x036, 0x000B0473,
		0x036, 0x000C0473,
		0x036, 0x000C8473,
		0x036, 0x000D0473,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000004,
		0x037, 0x00000000,
		0x038, 0x00005146,
		0x037, 0x00004000,
		0x038, 0x00005146,
		0x037, 0x00008000,
		0x038, 0x00005146,
		0x037, 0x00010000,
		0x038, 0x00005146,
		0x037, 0x00014000,
		0x038, 0x00005146,
		0x037, 0x00018000,
		0x038, 0x00004D4E,
		0x037, 0x0001C000,
		0x038, 0x00004D4E,
		0x037, 0x00020000,
		0x038, 0x00004D4E,
		0x037, 0x00024000,
		0x038, 0x000071C6,
		0x037, 0x00028000,
		0x038, 0x000071C6,
		0x037, 0x0002C000,
		0x038, 0x000071C6,
		0x037, 0x00030000,
		0x038, 0x000071CE,
		0x037, 0x00034000,
		0x038, 0x000071CE,
		0x037, 0x00038000,
		0x038, 0x00005126,
		0x037, 0x0003C000,
		0x038, 0x00005126,
		0x037, 0x00040000,
		0x038, 0x00005126,
		0x037, 0x00044000,
		0x038, 0x00005126,
		0x037, 0x00048000,
		0x038, 0x00005126,
		0x037, 0x00080000,
		0x038, 0x00005ECE,
		0x037, 0x00084000,
		0x038, 0x00005ECE,
		0x037, 0x00088000,
		0x038, 0x00005ECE,
		0x037, 0x00090000,
		0x038, 0x00005ECE,
		0x037, 0x00094000,
		0x038, 0x00005ECE,
		0x037, 0x00098000,
		0x038, 0x00005ECE,
		0x037, 0x0009C000,
		0x038, 0x00005ECE,
		0x037, 0x000A0000,
		0x038, 0x00005ECE,
		0x037, 0x000A4000,
		0x038, 0x00005ECE,
		0x037, 0x000A8000,
		0x038, 0x00005ECE,
		0x037, 0x000AC000,
		0x038, 0x00005ECE,
		0x037, 0x000B0000,
		0x038, 0x00005ECE,
		0x037, 0x000B4000,
		0x038, 0x00005ECE,
		0x037, 0x000B8000,
		0x038, 0x00005ECE,
		0x037, 0x000BC000,
		0x038, 0x00005ECE,
		0x037, 0x000C0000,
		0x038, 0x00005ECE,
		0x037, 0x000C4000,
		0x038, 0x00005ECE,
		0x037, 0x000C8000,
		0x038, 0x00005ECE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000008,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x03C, 0x0000007D,
		0x03C, 0x0000047D,
		0x03C, 0x0000087D,
		0x03C, 0x0000107D,
		0x03C, 0x0000147D,
		0x03C, 0x0000187D,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x0000054A,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x0000154A,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x0000254A,
		0x03C, 0x00002821,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x0000054A,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x0000154A,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x0000254A,
		0x03C, 0x00002821,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x0000054A,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x0000154A,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x0000254A,
		0x03C, 0x00002821,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x0000054A,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x0000154A,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x0000254A,
		0x03C, 0x00002821,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x0000054A,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x0000154A,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x0000254A,
		0x03C, 0x00002821,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x0000054A,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x0000154A,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x0000254A,
		0x03C, 0x00002821,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x0000054A,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x0000154A,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x0000254A,
		0x03C, 0x00002821,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x0000054A,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x0000154A,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x0000254A,
		0x03C, 0x00002821,
	0xA0000000,	0x00000000,
		0x03C, 0x0000037E,
		0x03C, 0x00000575,
		0x03C, 0x00000971,
		0x03C, 0x0000127E,
		0x03C, 0x00001575,
		0x03C, 0x00001871,
		0x03C, 0x0000217E,
		0x03C, 0x00002575,
		0x03C, 0x00002871,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x061, 0x000C0D47,
		0x062, 0x0000133C,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0xA0000000,	0x00000000,
		0x063, 0x0007D0E7,
	0xB0000000,	0x00000000,
		0x064, 0x00014FEC,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0xA0000000,	0x00000000,
		0x065, 0x000933FF,
	0xB0000000,	0x00000000,
		0x066, 0x00000040,
		0x057, 0x00050000,
		0x056, 0x00051DF0,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x055, 0x00082061,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x055, 0x00082061,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x055, 0x00082061,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x055, 0x00082061,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x055, 0x00082061,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x055, 0x00082061,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x055, 0x00082061,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x055, 0x00082061,
	0xA0000000,	0x00000000,
		0x055, 0x00082060,
	0xB0000000,	0x00000000,
		0x01C, 0x000739D2,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x01F, 0x0002255C,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x01F, 0x0002255C,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x01F, 0x0002255C,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x01F, 0x0002255C,
	0xA0000000,	0x00000000,
		0x01F, 0x0002255C,
	0xB0000000,	0x00000000,
		0x0B1, 0x0007FF48,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0C4, 0x00081700,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0C4, 0x00081700,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0C4, 0x00081700,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0C4, 0x00081700,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0C4, 0x00081700,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x0C4, 0x00081700,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x0C4, 0x00081700,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x0C4, 0x00081700,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x0C4, 0x00081700,
	0xA0000000,	0x00000000,
		0x0C4, 0x00083F00,
	0xB0000000,	0x00000000,
		0x018, 0x0001B126,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00013126,
		0x018, 0x00013124,
};

RTW_DECL_TABLE_RF_RADIO(rtw8814a_rf_a, A);

static const u32 rtw8814a_rf_b[] = {
		0x018, 0x00013124,
		0x040, 0x00000C00,
		0x058, 0x00000F98,
		0x07F, 0x00068004,
		0x018, 0x00000006,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0xA0000000,	0x00000000,
		0x086, 0x000E4B58,
		0x087, 0x00049F80,
	0xB0000000,	0x00000000,
		0x0DF, 0x00000008,
		0x0EF, 0x00002000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017BC3,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F39B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017BC3,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017BC3,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F39B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017BC3,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017BC3,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017BC3,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017BC3,
	0xA0000000,	0x00000000,
		0x03B, 0x0003F258,
		0x03B, 0x00030A58,
		0x03B, 0x0002FA58,
		0x03B, 0x00022590,
		0x03B, 0x0001FA50,
		0x03B, 0x00010248,
		0x03B, 0x00008240,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000100,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0000ADF6,
		0x034, 0x00009DF3,
		0x034, 0x00008DF0,
		0x034, 0x00007DED,
		0x034, 0x00006DEA,
		0x034, 0x00005CED,
		0x034, 0x00004CEA,
		0x034, 0x000034EA,
		0x034, 0x000024E7,
		0x034, 0x0000146A,
		0x034, 0x0000006B,
	0xB0000000,	0x00000000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0008ADF6,
		0x034, 0x00089DF3,
		0x034, 0x00088DF0,
		0x034, 0x00087DED,
		0x034, 0x00086DEA,
		0x034, 0x00085CED,
		0x034, 0x00084CEA,
		0x034, 0x000834EA,
		0x034, 0x000824E7,
		0x034, 0x0008146A,
		0x034, 0x0008006B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x000020A2,
		0x0DF, 0x00000080,
		0x035, 0x00000192,
		0x035, 0x00008192,
		0x035, 0x00010192,
		0x036, 0x00000024,
		0x036, 0x00008024,
		0x036, 0x00010024,
		0x036, 0x00018024,
		0x0EF, 0x00000000,
		0x051, 0x00000C21,
		0x052, 0x000006D9,
		0x053, 0x000FC649,
		0x054, 0x0000017E,
		0x018, 0x0001012A,
		0x081, 0x0007FC00,
		0x089, 0x00050110,
		0x08A, 0x00043E50,
		0x08B, 0x0002E180,
		0x08C, 0x00093C3C,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x000F8000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x000F8000,
	0xA0000000,	0x00000000,
		0x085, 0x000F8000,
	0xB0000000,	0x00000000,
		0x08D, 0x000FFFF0,
		0x0EF, 0x00001000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00084000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0xA0000000,	0x00000000,
		0x03C, 0x00040000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00030023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00028623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00021633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0001C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00010293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00009593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x00000F8B,
	0xA0000000,	0x00000000,
		0x03B, 0x0000078B,
	0xB0000000,	0x00000000,
		0x03C, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00060000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00048000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00048000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00048000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00048000,
	0xA0000000,	0x00000000,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00070023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00068623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00061633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0005C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00050293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00049593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0004078B,
		0x03C, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00048000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00060000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0004C000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00044000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0004C000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00048000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00004000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00044000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00044000,
	0xA0000000,	0x00000000,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B0023,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0xA0000000,	0x00000000,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A8623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A1633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0009C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00090293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00089593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0008138B,
	0xA0000000,	0x00000000,
		0x03B, 0x0008078B,
	0xB0000000,	0x00000000,
		0x03C, 0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
		0x03B, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001003,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001003,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001003,
	0xA0000000,	0x00000000,
		0x03A, 0x00000803,
	0xB0000000,	0x00000000,
		0x03B, 0x00040000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001003,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000800,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000800,
	0xA0000000,	0x00000000,
		0x03A, 0x00001000,
	0xB0000000,	0x00000000,
		0x03B, 0x00080000,
	0x80000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001802,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001802,
	0xA0000000,	0x00000000,
		0x03A, 0x00001002,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x00013124,
		0x0EF, 0x00000100,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A38C,
		0x034, 0x000491AD,
		0x034, 0x000481AA,
		0x034, 0x000471A7,
		0x034, 0x000460AA,
		0x034, 0x000450A7,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x0004200C,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A38C,
		0x034, 0x00049389,
		0x034, 0x0004816D,
		0x034, 0x0004716A,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A38B,
		0x034, 0x00049388,
		0x034, 0x0004818B,
		0x034, 0x00047188,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A38C,
		0x034, 0x00049389,
		0x034, 0x0004816D,
		0x034, 0x0004716A,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A38B,
		0x034, 0x00049388,
		0x034, 0x0004818B,
		0x034, 0x00047188,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3F5,
		0x034, 0x000493F3,
		0x034, 0x000483B2,
		0x034, 0x00047390,
		0x034, 0x0004638D,
		0x034, 0x0004538A,
		0x034, 0x00044387,
		0x034, 0x0004324A,
		0x034, 0x00042247,
		0x034, 0x0004104D,
		0x034, 0x0004004A,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004AFF7,
		0x034, 0x00049FF6,
		0x034, 0x00048FF3,
		0x034, 0x00047FF0,
		0x034, 0x00046FED,
		0x034, 0x00045FEA,
		0x034, 0x00044FE7,
		0x034, 0x00043DEA,
		0x034, 0x00042DE7,
		0x034, 0x00041DE4,
		0x034, 0x00040CE7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A38C,
		0x034, 0x00049389,
		0x034, 0x0004816D,
		0x034, 0x0004716A,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A38C,
		0x034, 0x00049389,
		0x034, 0x0004816D,
		0x034, 0x0004716A,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0xA0000000,	0x00000000,
		0x034, 0x0004AFF4,
		0x034, 0x00049FF1,
		0x034, 0x00048FEE,
		0x034, 0x00047FEB,
		0x034, 0x00046FE8,
		0x034, 0x00045DEA,
		0x034, 0x00044CED,
		0x034, 0x00043CEA,
		0x034, 0x00042C6C,
		0x034, 0x00041C69,
		0x034, 0x00040C2B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A38C,
		0x034, 0x000291AD,
		0x034, 0x000281AA,
		0x034, 0x000271A7,
		0x034, 0x000260AA,
		0x034, 0x000250A7,
		0x034, 0x0002402C,
		0x034, 0x00023029,
		0x034, 0x0002200C,
		0x034, 0x00021009,
		0x034, 0x00020006,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EE,
		0x034, 0x000293AC,
		0x034, 0x00028389,
		0x034, 0x0002716D,
		0x034, 0x0002616A,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EF,
		0x034, 0x000293AD,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EE,
		0x034, 0x000293AC,
		0x034, 0x00028389,
		0x034, 0x0002716D,
		0x034, 0x0002616A,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EF,
		0x034, 0x000293AD,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3F5,
		0x034, 0x000293F3,
		0x034, 0x000283D0,
		0x034, 0x00027371,
		0x034, 0x0002636E,
		0x034, 0x0002536B,
		0x034, 0x00024368,
		0x034, 0x0002332A,
		0x034, 0x00022327,
		0x034, 0x0002104C,
		0x034, 0x00020049,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002AFF7,
		0x034, 0x00029FF6,
		0x034, 0x00028FF3,
		0x034, 0x00027FF0,
		0x034, 0x00026FED,
		0x034, 0x00025FEA,
		0x034, 0x00024FE7,
		0x034, 0x00023DEA,
		0x034, 0x00022DE7,
		0x034, 0x00021DE4,
		0x034, 0x00020F25,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EE,
		0x034, 0x000293AC,
		0x034, 0x00028389,
		0x034, 0x0002716D,
		0x034, 0x0002616A,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EE,
		0x034, 0x000293AC,
		0x034, 0x00028389,
		0x034, 0x0002716D,
		0x034, 0x0002616A,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0xA0000000,	0x00000000,
		0x034, 0x0002AFF4,
		0x034, 0x00029FF1,
		0x034, 0x00028FEE,
		0x034, 0x00027FEB,
		0x034, 0x00026FE8,
		0x034, 0x00025DEA,
		0x034, 0x00024CED,
		0x034, 0x00023CEA,
		0x034, 0x00022C6C,
		0x034, 0x00021C69,
		0x034, 0x00020C2B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A38C,
		0x034, 0x000091AD,
		0x034, 0x000081AA,
		0x034, 0x000071A7,
		0x034, 0x000060AA,
		0x034, 0x000050A7,
		0x034, 0x0000402C,
		0x034, 0x00003029,
		0x034, 0x00002026,
		0x034, 0x00001009,
		0x034, 0x00000006,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EC,
		0x034, 0x000093AC,
		0x034, 0x000081EC,
		0x034, 0x0000716D,
		0x034, 0x0000616A,
		0x034, 0x0000506D,
		0x034, 0x0000404C,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EF,
		0x034, 0x000093AD,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EC,
		0x034, 0x000093AC,
		0x034, 0x000081EC,
		0x034, 0x0000716D,
		0x034, 0x0000616A,
		0x034, 0x0000506D,
		0x034, 0x0000404C,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EF,
		0x034, 0x000093AD,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3F4,
		0x034, 0x000093F0,
		0x034, 0x000083AE,
		0x034, 0x00007350,
		0x034, 0x0000634D,
		0x034, 0x0000534A,
		0x034, 0x00004347,
		0x034, 0x0000312D,
		0x034, 0x0000212A,
		0x034, 0x00001127,
		0x034, 0x0000002A,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000AFF7,
		0x034, 0x00009FF4,
		0x034, 0x00008FF1,
		0x034, 0x00007FEE,
		0x034, 0x00006FEB,
		0x034, 0x00005FE8,
		0x034, 0x00004DEB,
		0x034, 0x00003DE8,
		0x034, 0x00002DE5,
		0x034, 0x00001C8B,
		0x034, 0x00000C88,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EC,
		0x034, 0x000093AC,
		0x034, 0x000081EC,
		0x034, 0x0000716D,
		0x034, 0x0000616A,
		0x034, 0x0000506D,
		0x034, 0x0000404C,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EC,
		0x034, 0x000093AC,
		0x034, 0x000081EC,
		0x034, 0x0000716D,
		0x034, 0x0000616A,
		0x034, 0x0000506D,
		0x034, 0x0000404C,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0xA0000000,	0x00000000,
		0x034, 0x0000AFF4,
		0x034, 0x00009FF1,
		0x034, 0x00008FEE,
		0x034, 0x00007FEB,
		0x034, 0x00006FE8,
		0x034, 0x00005DEA,
		0x034, 0x00004CED,
		0x034, 0x00003CEA,
		0x034, 0x00002C6C,
		0x034, 0x00001C69,
		0x034, 0x00000C2B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA38C,
		0x034, 0x000C91AD,
		0x034, 0x000C81AA,
		0x034, 0x000C71A7,
		0x034, 0x000C60AA,
		0x034, 0x000C50A7,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C200C,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA38C,
		0x034, 0x000C9389,
		0x034, 0x000C816D,
		0x034, 0x000C716A,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA38B,
		0x034, 0x000C9388,
		0x034, 0x000C818B,
		0x034, 0x000C7188,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA38C,
		0x034, 0x000C9389,
		0x034, 0x000C816D,
		0x034, 0x000C716A,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA38B,
		0x034, 0x000C9388,
		0x034, 0x000C818B,
		0x034, 0x000C7188,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3F5,
		0x034, 0x000C93F3,
		0x034, 0x000C83B2,
		0x034, 0x000C7390,
		0x034, 0x000C638D,
		0x034, 0x000C538A,
		0x034, 0x000C4387,
		0x034, 0x000C324A,
		0x034, 0x000C2247,
		0x034, 0x000C104D,
		0x034, 0x000C004A,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CAFF7,
		0x034, 0x000C9FF6,
		0x034, 0x000C8FF3,
		0x034, 0x000C7FF0,
		0x034, 0x000C6FED,
		0x034, 0x000C5FEA,
		0x034, 0x000C4FE7,
		0x034, 0x000C3DEA,
		0x034, 0x000C2DE7,
		0x034, 0x000C1DE4,
		0x034, 0x000C0CE7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA38C,
		0x034, 0x000C9389,
		0x034, 0x000C816D,
		0x034, 0x000C716A,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA38C,
		0x034, 0x000C9389,
		0x034, 0x000C816D,
		0x034, 0x000C716A,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0xA0000000,	0x00000000,
		0x034, 0x000CA794,
		0x034, 0x000C9791,
		0x034, 0x000C878E,
		0x034, 0x000C778B,
		0x034, 0x000C658D,
		0x034, 0x000C558A,
		0x034, 0x000C448D,
		0x034, 0x000C348A,
		0x034, 0x000C244C,
		0x034, 0x000C1449,
		0x034, 0x000C042B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA38C,
		0x034, 0x000A91AD,
		0x034, 0x000A81AA,
		0x034, 0x000A71A7,
		0x034, 0x000A60AA,
		0x034, 0x000A50A7,
		0x034, 0x000A402C,
		0x034, 0x000A3029,
		0x034, 0x000A200C,
		0x034, 0x000A1009,
		0x034, 0x000A0006,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EE,
		0x034, 0x000A93AC,
		0x034, 0x000A8389,
		0x034, 0x000A716D,
		0x034, 0x000A616A,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EF,
		0x034, 0x000A93AD,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EE,
		0x034, 0x000A93AC,
		0x034, 0x000A8389,
		0x034, 0x000A716D,
		0x034, 0x000A616A,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EF,
		0x034, 0x000A93AD,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3F5,
		0x034, 0x000A93F3,
		0x034, 0x000A83D0,
		0x034, 0x000A7371,
		0x034, 0x000A636E,
		0x034, 0x000A536B,
		0x034, 0x000A4368,
		0x034, 0x000A332A,
		0x034, 0x000A2327,
		0x034, 0x000A104C,
		0x034, 0x000A0049,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AAFF7,
		0x034, 0x000A9FF6,
		0x034, 0x000A8FF3,
		0x034, 0x000A7FF0,
		0x034, 0x000A6FED,
		0x034, 0x000A5FEA,
		0x034, 0x000A4FE7,
		0x034, 0x000A3DEA,
		0x034, 0x000A2DE7,
		0x034, 0x000A1DE4,
		0x034, 0x000A0F25,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EE,
		0x034, 0x000A93AC,
		0x034, 0x000A8389,
		0x034, 0x000A716D,
		0x034, 0x000A616A,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EE,
		0x034, 0x000A93AC,
		0x034, 0x000A8389,
		0x034, 0x000A716D,
		0x034, 0x000A616A,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0xA0000000,	0x00000000,
		0x034, 0x000AA794,
		0x034, 0x000A9791,
		0x034, 0x000A878E,
		0x034, 0x000A778B,
		0x034, 0x000A658D,
		0x034, 0x000A558A,
		0x034, 0x000A448D,
		0x034, 0x000A348A,
		0x034, 0x000A244C,
		0x034, 0x000A1449,
		0x034, 0x000A042B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A38C,
		0x034, 0x000891AD,
		0x034, 0x000881AA,
		0x034, 0x000871A7,
		0x034, 0x000860AA,
		0x034, 0x000850A7,
		0x034, 0x0008402C,
		0x034, 0x00083029,
		0x034, 0x00082026,
		0x034, 0x00081009,
		0x034, 0x00080006,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EC,
		0x034, 0x000893AC,
		0x034, 0x000881EC,
		0x034, 0x0008716D,
		0x034, 0x0008616A,
		0x034, 0x0008506D,
		0x034, 0x0008404C,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EF,
		0x034, 0x000893AD,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EC,
		0x034, 0x000893AC,
		0x034, 0x000881EC,
		0x034, 0x0008716D,
		0x034, 0x0008616A,
		0x034, 0x0008506D,
		0x034, 0x0008404C,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EF,
		0x034, 0x000893AD,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3F4,
		0x034, 0x000893F0,
		0x034, 0x000883AE,
		0x034, 0x00087350,
		0x034, 0x0008634D,
		0x034, 0x0008534A,
		0x034, 0x00084347,
		0x034, 0x0008312D,
		0x034, 0x0008212A,
		0x034, 0x00081127,
		0x034, 0x0008002A,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008AFF7,
		0x034, 0x00089FF4,
		0x034, 0x00088FF1,
		0x034, 0x00087FEE,
		0x034, 0x00086FEB,
		0x034, 0x00085FE8,
		0x034, 0x00084DEB,
		0x034, 0x00083DE8,
		0x034, 0x00082DE5,
		0x034, 0x00081C8B,
		0x034, 0x00080C88,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EC,
		0x034, 0x000893AC,
		0x034, 0x000881EC,
		0x034, 0x0008716D,
		0x034, 0x0008616A,
		0x034, 0x0008506D,
		0x034, 0x0008404C,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EC,
		0x034, 0x000893AC,
		0x034, 0x000881EC,
		0x034, 0x0008716D,
		0x034, 0x0008616A,
		0x034, 0x0008506D,
		0x034, 0x0008404C,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0xA0000000,	0x00000000,
		0x034, 0x0008A794,
		0x034, 0x00089791,
		0x034, 0x0008878E,
		0x034, 0x0008778B,
		0x034, 0x0008658D,
		0x034, 0x0008558A,
		0x034, 0x0008448D,
		0x034, 0x0008348A,
		0x034, 0x0008244C,
		0x034, 0x00081449,
		0x034, 0x0008042B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0xA0000000,	0x00000000,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x0001712A,
		0x0EF, 0x00000040,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0xA0000000,	0x00000000,
		0x035, 0x00000484,
		0x035, 0x00008484,
		0x035, 0x00010484,
		0x035, 0x00020584,
		0x035, 0x00028584,
		0x035, 0x00030584,
		0x035, 0x00040584,
		0x035, 0x00048584,
		0x035, 0x00050584,
		0x035, 0x000805FB,
		0x035, 0x000885FB,
		0x035, 0x000905FB,
		0x035, 0x000A05FB,
		0x035, 0x000A85FB,
		0x035, 0x000B05FB,
		0x035, 0x000C05FB,
		0x035, 0x000C85FB,
		0x035, 0x000D05FB,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0xA0000000,	0x00000000,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x0001712A,
		0x0EF, 0x00000010,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000473,
		0x036, 0x00008473,
		0x036, 0x00010473,
		0x036, 0x00020473,
		0x036, 0x00028473,
		0x036, 0x00030473,
		0x036, 0x00040473,
		0x036, 0x00048473,
		0x036, 0x00050473,
		0x036, 0x00080473,
		0x036, 0x00088473,
		0x036, 0x00090473,
		0x036, 0x000A0473,
		0x036, 0x000A8473,
		0x036, 0x000B0473,
		0x036, 0x000C0473,
		0x036, 0x000C8473,
		0x036, 0x000D0473,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0xA0000000,	0x00000000,
		0x036, 0x00000474,
		0x036, 0x00008474,
		0x036, 0x00010474,
		0x036, 0x00020474,
		0x036, 0x00028474,
		0x036, 0x00030474,
		0x036, 0x00040474,
		0x036, 0x00048474,
		0x036, 0x00050474,
		0x036, 0x00080474,
		0x036, 0x00088474,
		0x036, 0x00090474,
		0x036, 0x000A0474,
		0x036, 0x000A8474,
		0x036, 0x000B0474,
		0x036, 0x000C0474,
		0x036, 0x000C8474,
		0x036, 0x000D0474,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000004,
		0x037, 0x00000000,
		0x038, 0x0000514E,
		0x037, 0x00004000,
		0x038, 0x0000514E,
		0x037, 0x00008000,
		0x038, 0x0000514E,
		0x037, 0x00010000,
		0x038, 0x0000514E,
		0x037, 0x00014000,
		0x038, 0x0000514E,
		0x037, 0x00018000,
		0x038, 0x0000514E,
		0x037, 0x0001C000,
		0x038, 0x0000514E,
		0x037, 0x00020000,
		0x038, 0x0000514E,
		0x037, 0x00024000,
		0x038, 0x0000514E,
		0x037, 0x00028000,
		0x038, 0x0000514E,
		0x037, 0x0002C000,
		0x038, 0x0000714E,
		0x037, 0x00030000,
		0x038, 0x0000514E,
		0x037, 0x00034000,
		0x038, 0x0000514E,
		0x037, 0x00038000,
		0x038, 0x0000514E,
		0x037, 0x0003C000,
		0x038, 0x0000514E,
		0x037, 0x00040000,
		0x038, 0x0000514E,
		0x037, 0x00044000,
		0x038, 0x0000514E,
		0x037, 0x00048000,
		0x038, 0x0000514E,
		0x037, 0x00080000,
		0x038, 0x00005ECE,
		0x037, 0x00084000,
		0x038, 0x00005ECE,
		0x037, 0x00088000,
		0x038, 0x00005ECE,
		0x037, 0x00090000,
		0x038, 0x00005ECE,
		0x037, 0x00094000,
		0x038, 0x00005ECE,
		0x037, 0x00098000,
		0x038, 0x00005ECE,
		0x037, 0x0009C000,
		0x038, 0x00005ECE,
		0x037, 0x000A0000,
		0x038, 0x00005ECE,
		0x037, 0x000A4000,
		0x038, 0x00005ECE,
		0x037, 0x000A8000,
		0x038, 0x00005ECE,
		0x037, 0x000AC000,
		0x038, 0x00005ECE,
		0x037, 0x000B0000,
		0x038, 0x00005ECE,
		0x037, 0x000B4000,
		0x038, 0x00005ECE,
		0x037, 0x000B8000,
		0x038, 0x00005ECE,
		0x037, 0x000BC000,
		0x038, 0x00005ECE,
		0x037, 0x000C0000,
		0x038, 0x00005ECE,
		0x037, 0x000C4000,
		0x038, 0x00005ECE,
		0x037, 0x000C8000,
		0x038, 0x00005ECE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000008,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x03C, 0x0000007D,
		0x03C, 0x0000047D,
		0x03C, 0x0000087D,
		0x03C, 0x0000107D,
		0x03C, 0x0000147D,
		0x03C, 0x0000187D,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027E,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127E,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227E,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027E,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127E,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227E,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027E,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127E,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227E,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027E,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127E,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227E,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027E,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127E,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227E,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027E,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127E,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227E,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027E,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127E,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227E,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027E,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127E,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227E,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0xA0000000,	0x00000000,
		0x03C, 0x0000037E,
		0x03C, 0x00000575,
		0x03C, 0x00000971,
		0x03C, 0x0000127E,
		0x03C, 0x00001575,
		0x03C, 0x00001871,
		0x03C, 0x0000217E,
		0x03C, 0x00002575,
		0x03C, 0x00002871,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x061, 0x000C0D47,
		0x062, 0x0000133C,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0xA0000000,	0x00000000,
		0x063, 0x0007D0E7,
	0xB0000000,	0x00000000,
		0x064, 0x00014FEC,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0xA0000000,	0x00000000,
		0x065, 0x000923FF,
	0xB0000000,	0x00000000,
		0x066, 0x00000040,
		0x057, 0x00050000,
		0x056, 0x00051DF0,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x055, 0x00082060,
	0xB0000000,	0x00000000,
};

RTW_DECL_TABLE_RF_RADIO(rtw8814a_rf_b, B);

static const u32 rtw8814a_rf_c[] = {
		0x018, 0x00013124,
		0x040, 0x00000C00,
		0x058, 0x00000F98,
		0x07F, 0x00068004,
		0x018, 0x00000006,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0xA0000000,	0x00000000,
		0x086, 0x000E4B58,
		0x087, 0x00049F80,
	0xB0000000,	0x00000000,
		0x0DF, 0x00000008,
		0x0EF, 0x00002000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017823,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017823,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017823,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017823,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017823,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017823,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017823,
	0xA0000000,	0x00000000,
		0x03B, 0x0003F258,
		0x03B, 0x00030A58,
		0x03B, 0x0002FA58,
		0x03B, 0x00022590,
		0x03B, 0x0001FA50,
		0x03B, 0x00010248,
		0x03B, 0x00008240,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000100,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0000ADF6,
		0x034, 0x00009DF3,
		0x034, 0x00008DF0,
		0x034, 0x00007DED,
		0x034, 0x00006DEA,
		0x034, 0x00005CED,
		0x034, 0x00004CEA,
		0x034, 0x000034EA,
		0x034, 0x000024E7,
		0x034, 0x0000146A,
		0x034, 0x0000006B,
	0xB0000000,	0x00000000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0008ADF6,
		0x034, 0x00089DF3,
		0x034, 0x00088DF0,
		0x034, 0x00087DED,
		0x034, 0x00086DEA,
		0x034, 0x00085CED,
		0x034, 0x00084CEA,
		0x034, 0x000834EA,
		0x034, 0x000824E7,
		0x034, 0x0008146A,
		0x034, 0x0008006B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x000020A2,
		0x0DF, 0x00000080,
		0x035, 0x00000192,
		0x035, 0x00008192,
		0x035, 0x00010192,
		0x036, 0x00000024,
		0x036, 0x00008024,
		0x036, 0x00010024,
		0x036, 0x00018024,
		0x0EF, 0x00000000,
		0x051, 0x00000C21,
		0x052, 0x000006D9,
		0x053, 0x000FC649,
		0x054, 0x0000017E,
		0x018, 0x0001012A,
		0x081, 0x0007FC00,
		0x089, 0x00050110,
		0x08A, 0x00043E50,
		0x08B, 0x0002E180,
		0x08C, 0x00093C3C,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x000F8000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x000F8000,
	0xA0000000,	0x00000000,
		0x085, 0x000F8000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0xA0000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0xB0000000,	0x00000000,
		0x0EF, 0x00001000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0006C000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x000D4000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00080000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0006C000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0008C000,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00004000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0xA0000000,	0x00000000,
		0x03C, 0x000A0000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00030023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00028623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00021633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0001C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00010293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00009593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0000118B,
	0xA0000000,	0x00000000,
		0x03B, 0x0000078B,
	0xB0000000,	0x00000000,
		0x03C, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0004C000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00084000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00080000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0004C000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x000D0000,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00080000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00080000,
	0xA0000000,	0x00000000,
		0x03C, 0x00028000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00070023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00068623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00061633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0005C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00050293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00049593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0004078B,
		0x03C, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00060000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00080000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0xA0000000,	0x00000000,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B0023,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0xA0000000,	0x00000000,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A8623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A1633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0009C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00090293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00089593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0008128B,
	0xA0000000,	0x00000000,
		0x03B, 0x0008078B,
	0xB0000000,	0x00000000,
		0x03C, 0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
		0x03B, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001803,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001803,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001003,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001003,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001003,
	0xA0000000,	0x00000000,
		0x03A, 0x00000803,
	0xB0000000,	0x00000000,
		0x03B, 0x00040000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000800,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0xA0000000,	0x00000000,
		0x03A, 0x00001000,
	0xB0000000,	0x00000000,
		0x03B, 0x00080000,
	0x80000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001802,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001802,
	0xA0000000,	0x00000000,
		0x03A, 0x00001002,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
	0xB0000000,	0x00000000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000100,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A38C,
		0x034, 0x000491AD,
		0x034, 0x000481AA,
		0x034, 0x000471A7,
		0x034, 0x000460AA,
		0x034, 0x000450A7,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x0004200C,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AD,
		0x034, 0x0004838A,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004404C,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AD,
		0x034, 0x0004838A,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004404C,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AD,
		0x034, 0x0004838A,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004404C,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AD,
		0x034, 0x0004838A,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004404C,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3F5,
		0x034, 0x000493F3,
		0x034, 0x00048393,
		0x034, 0x00047390,
		0x034, 0x0004638D,
		0x034, 0x0004538A,
		0x034, 0x00044387,
		0x034, 0x000430ED,
		0x034, 0x000420EA,
		0x034, 0x000410E7,
		0x034, 0x0004002D,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004AFF7,
		0x034, 0x00049FF6,
		0x034, 0x00048FF3,
		0x034, 0x00047FF0,
		0x034, 0x00046FED,
		0x034, 0x00045FEA,
		0x034, 0x00044FE7,
		0x034, 0x00043CD0,
		0x034, 0x00042CCD,
		0x034, 0x00041CCA,
		0x034, 0x00040CC7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AD,
		0x034, 0x0004838A,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004404C,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AD,
		0x034, 0x0004838A,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004404C,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0xA0000000,	0x00000000,
		0x034, 0x0004AFF4,
		0x034, 0x00049FF1,
		0x034, 0x00048FEE,
		0x034, 0x00047FEB,
		0x034, 0x00046FE8,
		0x034, 0x00045DEA,
		0x034, 0x00044CED,
		0x034, 0x00043CEA,
		0x034, 0x00042C6C,
		0x034, 0x00041C69,
		0x034, 0x00040C2B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EC,
		0x034, 0x0002938C,
		0x034, 0x000281AD,
		0x034, 0x000271AA,
		0x034, 0x000261A7,
		0x034, 0x000250AA,
		0x034, 0x000240A7,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x0002100C,
		0x034, 0x00020009,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EC,
		0x034, 0x0002936D,
		0x034, 0x0002836A,
		0x034, 0x0002716D,
		0x034, 0x0002616A,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EC,
		0x034, 0x000293AC,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EC,
		0x034, 0x0002936D,
		0x034, 0x0002836A,
		0x034, 0x0002716D,
		0x034, 0x0002616A,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EC,
		0x034, 0x000293AC,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3F5,
		0x034, 0x000293F3,
		0x034, 0x000282F2,
		0x034, 0x000272D0,
		0x034, 0x000262CD,
		0x034, 0x000252CA,
		0x034, 0x000242C7,
		0x034, 0x000230CD,
		0x034, 0x000220CA,
		0x034, 0x000210C7,
		0x034, 0x00020086,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002AFF7,
		0x034, 0x00029FF6,
		0x034, 0x00028FF3,
		0x034, 0x00027FF0,
		0x034, 0x00026FED,
		0x034, 0x00025FEA,
		0x034, 0x00024FE7,
		0x034, 0x00023DEA,
		0x034, 0x00022DE7,
		0x034, 0x00021DE4,
		0x034, 0x00020E44,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EC,
		0x034, 0x0002936D,
		0x034, 0x0002836A,
		0x034, 0x0002716D,
		0x034, 0x0002616A,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EC,
		0x034, 0x0002936D,
		0x034, 0x0002836A,
		0x034, 0x0002716D,
		0x034, 0x0002616A,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0xA0000000,	0x00000000,
		0x034, 0x0002AFF4,
		0x034, 0x00029FF1,
		0x034, 0x00028FEE,
		0x034, 0x00027FEB,
		0x034, 0x00026FE8,
		0x034, 0x00025DEA,
		0x034, 0x00024CED,
		0x034, 0x00023CEA,
		0x034, 0x00022C6C,
		0x034, 0x00021C69,
		0x034, 0x00020C2B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A38C,
		0x034, 0x000091AD,
		0x034, 0x000081AA,
		0x034, 0x000071A7,
		0x034, 0x000060AA,
		0x034, 0x000050A7,
		0x034, 0x0000402C,
		0x034, 0x00003029,
		0x034, 0x0000200C,
		0x034, 0x00001009,
		0x034, 0x00000006,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AB,
		0x034, 0x00008389,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AB,
		0x034, 0x00008389,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AB,
		0x034, 0x00008389,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AB,
		0x034, 0x00008389,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3F5,
		0x034, 0x000093F1,
		0x034, 0x000083B0,
		0x034, 0x00007370,
		0x034, 0x0000636D,
		0x034, 0x0000536A,
		0x034, 0x00004367,
		0x034, 0x0000308E,
		0x034, 0x0000208B,
		0x034, 0x00001088,
		0x034, 0x00000085,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000AFF7,
		0x034, 0x00009FF5,
		0x034, 0x00008FF2,
		0x034, 0x00007FEF,
		0x034, 0x00006FEC,
		0x034, 0x00005FE9,
		0x034, 0x00004EAA,
		0x034, 0x00003EA7,
		0x034, 0x00002C70,
		0x034, 0x00001C6D,
		0x034, 0x00000C6A,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AB,
		0x034, 0x00008389,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AB,
		0x034, 0x00008389,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0xA0000000,	0x00000000,
		0x034, 0x0000AFF4,
		0x034, 0x00009FF1,
		0x034, 0x00008FEE,
		0x034, 0x00007FEB,
		0x034, 0x00006FE8,
		0x034, 0x00005DEA,
		0x034, 0x00004CED,
		0x034, 0x00003CEA,
		0x034, 0x00002C6C,
		0x034, 0x00001C69,
		0x034, 0x00000C2B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA38C,
		0x034, 0x000C91AD,
		0x034, 0x000C81AA,
		0x034, 0x000C71A7,
		0x034, 0x000C60AA,
		0x034, 0x000C50A7,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C200C,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AD,
		0x034, 0x000C838A,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C404C,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AD,
		0x034, 0x000C838A,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C404C,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AD,
		0x034, 0x000C838A,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C404C,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AD,
		0x034, 0x000C838A,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C404C,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3F5,
		0x034, 0x000C93F3,
		0x034, 0x000C8393,
		0x034, 0x000C7390,
		0x034, 0x000C638D,
		0x034, 0x000C538A,
		0x034, 0x000C4387,
		0x034, 0x000C30ED,
		0x034, 0x000C20EA,
		0x034, 0x000C10E7,
		0x034, 0x000C002D,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CAFF7,
		0x034, 0x000C9FF6,
		0x034, 0x000C8FF3,
		0x034, 0x000C7FF0,
		0x034, 0x000C6FED,
		0x034, 0x000C5FEA,
		0x034, 0x000C4FE7,
		0x034, 0x000C3CD0,
		0x034, 0x000C2CCD,
		0x034, 0x000C1CCA,
		0x034, 0x000C0CC7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AD,
		0x034, 0x000C838A,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C404C,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AD,
		0x034, 0x000C838A,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C404C,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0xA0000000,	0x00000000,
		0x034, 0x000CA794,
		0x034, 0x000C9791,
		0x034, 0x000C878E,
		0x034, 0x000C778B,
		0x034, 0x000C658D,
		0x034, 0x000C558A,
		0x034, 0x000C448D,
		0x034, 0x000C348A,
		0x034, 0x000C244C,
		0x034, 0x000C1449,
		0x034, 0x000C042B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EC,
		0x034, 0x000A938C,
		0x034, 0x000A81AD,
		0x034, 0x000A71AA,
		0x034, 0x000A61A7,
		0x034, 0x000A50AA,
		0x034, 0x000A40A7,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A100C,
		0x034, 0x000A0009,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EC,
		0x034, 0x000A936D,
		0x034, 0x000A836A,
		0x034, 0x000A716D,
		0x034, 0x000A616A,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EC,
		0x034, 0x000A93AC,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EC,
		0x034, 0x000A936D,
		0x034, 0x000A836A,
		0x034, 0x000A716D,
		0x034, 0x000A616A,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EC,
		0x034, 0x000A93AC,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3F5,
		0x034, 0x000A93F3,
		0x034, 0x000A82F2,
		0x034, 0x000A72D0,
		0x034, 0x000A62CD,
		0x034, 0x000A52CA,
		0x034, 0x000A42C7,
		0x034, 0x000A30CD,
		0x034, 0x000A20CA,
		0x034, 0x000A10C7,
		0x034, 0x000A0086,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AAFF7,
		0x034, 0x000A9FF6,
		0x034, 0x000A8FF3,
		0x034, 0x000A7FF0,
		0x034, 0x000A6FED,
		0x034, 0x000A5FEA,
		0x034, 0x000A4FE7,
		0x034, 0x000A3DEA,
		0x034, 0x000A2DE7,
		0x034, 0x000A1DE4,
		0x034, 0x000A0E44,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EC,
		0x034, 0x000A936D,
		0x034, 0x000A836A,
		0x034, 0x000A716D,
		0x034, 0x000A616A,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EC,
		0x034, 0x000A936D,
		0x034, 0x000A836A,
		0x034, 0x000A716D,
		0x034, 0x000A616A,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0xA0000000,	0x00000000,
		0x034, 0x000AA794,
		0x034, 0x000A9791,
		0x034, 0x000A878E,
		0x034, 0x000A778B,
		0x034, 0x000A658D,
		0x034, 0x000A558A,
		0x034, 0x000A448D,
		0x034, 0x000A348A,
		0x034, 0x000A244C,
		0x034, 0x000A1449,
		0x034, 0x000A042B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A38C,
		0x034, 0x000891AD,
		0x034, 0x000881AA,
		0x034, 0x000871A7,
		0x034, 0x000860AA,
		0x034, 0x000850A7,
		0x034, 0x0008402C,
		0x034, 0x00083029,
		0x034, 0x0008200C,
		0x034, 0x00081009,
		0x034, 0x00000006,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AB,
		0x034, 0x00088389,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AB,
		0x034, 0x00088389,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AB,
		0x034, 0x00088389,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AB,
		0x034, 0x00088389,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3F5,
		0x034, 0x000893F1,
		0x034, 0x000883B0,
		0x034, 0x00087370,
		0x034, 0x0008636D,
		0x034, 0x0008536A,
		0x034, 0x00084367,
		0x034, 0x0008308E,
		0x034, 0x0008208B,
		0x034, 0x00081088,
		0x034, 0x00080085,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008AFF7,
		0x034, 0x00089FF5,
		0x034, 0x00088FF2,
		0x034, 0x00087FEF,
		0x034, 0x00086FEC,
		0x034, 0x00085FE9,
		0x034, 0x00084EAA,
		0x034, 0x00083EA7,
		0x034, 0x00082C70,
		0x034, 0x00081C6D,
		0x034, 0x00080C6A,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AB,
		0x034, 0x00088389,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AB,
		0x034, 0x00088389,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0xA0000000,	0x00000000,
		0x034, 0x0008A794,
		0x034, 0x00089791,
		0x034, 0x0008878E,
		0x034, 0x0008778B,
		0x034, 0x0008658D,
		0x034, 0x0008558A,
		0x034, 0x0008448D,
		0x034, 0x0008348A,
		0x034, 0x0008244C,
		0x034, 0x00081449,
		0x034, 0x0008042B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0xA0000000,	0x00000000,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x0001712A,
		0x0EF, 0x00000040,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0xA0000000,	0x00000000,
		0x035, 0x00000484,
		0x035, 0x00008484,
		0x035, 0x00010484,
		0x035, 0x00020584,
		0x035, 0x00028584,
		0x035, 0x00030584,
		0x035, 0x00040584,
		0x035, 0x00048584,
		0x035, 0x00050584,
		0x035, 0x000805FB,
		0x035, 0x000885FB,
		0x035, 0x000905FB,
		0x035, 0x000A05FB,
		0x035, 0x000A85FB,
		0x035, 0x000B05FB,
		0x035, 0x000C05FB,
		0x035, 0x000C85FB,
		0x035, 0x000D05FB,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0xA0000000,	0x00000000,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x0001712A,
		0x0EF, 0x00000010,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000473,
		0x036, 0x00008473,
		0x036, 0x00010473,
		0x036, 0x00020473,
		0x036, 0x00028473,
		0x036, 0x00030473,
		0x036, 0x00040473,
		0x036, 0x00048473,
		0x036, 0x00050473,
		0x036, 0x00080473,
		0x036, 0x00088473,
		0x036, 0x00090473,
		0x036, 0x000A0473,
		0x036, 0x000A8473,
		0x036, 0x000B0473,
		0x036, 0x000C0473,
		0x036, 0x000C8473,
		0x036, 0x000D0473,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0xA0000000,	0x00000000,
		0x036, 0x00000474,
		0x036, 0x00008474,
		0x036, 0x00010474,
		0x036, 0x00020474,
		0x036, 0x00028474,
		0x036, 0x00030474,
		0x036, 0x00040474,
		0x036, 0x00048474,
		0x036, 0x00050474,
		0x036, 0x00080474,
		0x036, 0x00088474,
		0x036, 0x00090474,
		0x036, 0x000A0474,
		0x036, 0x000A8474,
		0x036, 0x000B0474,
		0x036, 0x000C0474,
		0x036, 0x000C8474,
		0x036, 0x000D0474,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000004,
		0x037, 0x00000000,
		0x038, 0x0000514E,
		0x037, 0x00004000,
		0x038, 0x0000514E,
		0x037, 0x00008000,
		0x038, 0x0000514E,
		0x037, 0x00010000,
		0x038, 0x0000514E,
		0x037, 0x00014000,
		0x038, 0x0000514E,
		0x037, 0x00018000,
		0x038, 0x0000514E,
		0x037, 0x0001C000,
		0x038, 0x0000514E,
		0x037, 0x00020000,
		0x038, 0x0000514E,
		0x037, 0x00024000,
		0x038, 0x0000514E,
		0x037, 0x00028000,
		0x038, 0x0000514E,
		0x037, 0x0002C000,
		0x038, 0x0000714E,
		0x037, 0x00030000,
		0x038, 0x0000514E,
		0x037, 0x00034000,
		0x038, 0x0000514E,
		0x037, 0x00038000,
		0x038, 0x0000514E,
		0x037, 0x0003C000,
		0x038, 0x0000514E,
		0x037, 0x00040000,
		0x038, 0x0000514E,
		0x037, 0x00044000,
		0x038, 0x0000514E,
		0x037, 0x00048000,
		0x038, 0x0000514E,
		0x037, 0x00080000,
		0x038, 0x00005ECE,
		0x037, 0x00084000,
		0x038, 0x00005ECE,
		0x037, 0x00088000,
		0x038, 0x00005ECE,
		0x037, 0x00090000,
		0x038, 0x00005ECE,
		0x037, 0x00094000,
		0x038, 0x00005ECE,
		0x037, 0x00098000,
		0x038, 0x00005ECE,
		0x037, 0x0009C000,
		0x038, 0x00005ECE,
		0x037, 0x000A0000,
		0x038, 0x00005ECE,
		0x037, 0x000A4000,
		0x038, 0x00005ECE,
		0x037, 0x000A8000,
		0x038, 0x00005ECE,
		0x037, 0x000AC000,
		0x038, 0x00005ECE,
		0x037, 0x000B0000,
		0x038, 0x00005ECE,
		0x037, 0x000B4000,
		0x038, 0x00005ECE,
		0x037, 0x000B8000,
		0x038, 0x00005ECE,
		0x037, 0x000BC000,
		0x038, 0x00005ECE,
		0x037, 0x000C0000,
		0x038, 0x00005ECE,
		0x037, 0x000C4000,
		0x038, 0x00005ECE,
		0x037, 0x000C8000,
		0x038, 0x00005ECE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000008,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x03C, 0x0000007D,
		0x03C, 0x0000047D,
		0x03C, 0x0000087D,
		0x03C, 0x0000107D,
		0x03C, 0x0000147D,
		0x03C, 0x0000187D,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x00000541,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x00001541,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x00002541,
		0x03C, 0x00002821,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0xA0000000,	0x00000000,
		0x03C, 0x0000037E,
		0x03C, 0x00000575,
		0x03C, 0x00000971,
		0x03C, 0x0000127E,
		0x03C, 0x00001575,
		0x03C, 0x00001871,
		0x03C, 0x0000217E,
		0x03C, 0x00002575,
		0x03C, 0x00002871,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x061, 0x000C0D47,
		0x062, 0x0000133C,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0xA0000000,	0x00000000,
		0x063, 0x0007D0E7,
	0xB0000000,	0x00000000,
		0x064, 0x00014FEC,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0xA0000000,	0x00000000,
		0x065, 0x000923FF,
	0xB0000000,	0x00000000,
		0x066, 0x00000040,
		0x057, 0x00050000,
		0x056, 0x00051DF0,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x055, 0x00082060,
	0xB0000000,	0x00000000,
};

RTW_DECL_TABLE_RF_RADIO(rtw8814a_rf_c, C);

static const u32 rtw8814a_rf_d[] = {
		0x018, 0x00013124,
		0x040, 0x00000C00,
		0x058, 0x00000F98,
		0x07F, 0x00068004,
		0x018, 0x00000006,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0xA0000000,	0x00000000,
		0x086, 0x000E4B58,
		0x087, 0x00049F80,
	0xB0000000,	0x00000000,
		0x0DF, 0x00000008,
		0x0EF, 0x00002000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017803,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F09B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017803,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017803,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F09B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017803,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017803,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017803,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017803,
	0xA0000000,	0x00000000,
		0x03B, 0x0003F258,
		0x03B, 0x00030A58,
		0x03B, 0x0002FA58,
		0x03B, 0x00022590,
		0x03B, 0x0001FA50,
		0x03B, 0x00010248,
		0x03B, 0x00008240,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000100,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0000ADF6,
		0x034, 0x00009DF3,
		0x034, 0x00008DF0,
		0x034, 0x00007DED,
		0x034, 0x00006DEA,
		0x034, 0x00005CED,
		0x034, 0x00004CEA,
		0x034, 0x000034EA,
		0x034, 0x000024E7,
		0x034, 0x0000146A,
		0x034, 0x0000006B,
	0xB0000000,	0x00000000,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0008ADF6,
		0x034, 0x00089DF3,
		0x034, 0x00088DF0,
		0x034, 0x00087DED,
		0x034, 0x00086DEA,
		0x034, 0x00085CED,
		0x034, 0x00084CEA,
		0x034, 0x000834EA,
		0x034, 0x000824E7,
		0x034, 0x0008146A,
		0x034, 0x0008006B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x000020A2,
		0x0DF, 0x00000080,
		0x035, 0x00000192,
		0x035, 0x00008192,
		0x035, 0x00010192,
		0x036, 0x00000024,
		0x036, 0x00008024,
		0x036, 0x00010024,
		0x036, 0x00018024,
		0x0EF, 0x00000000,
		0x051, 0x00000C21,
		0x052, 0x000006D9,
		0x053, 0x000FC649,
		0x054, 0x0000017E,
		0x018, 0x0001012A,
		0x081, 0x0007FC00,
		0x089, 0x00050110,
		0x08A, 0x00043E50,
		0x08B, 0x0002E180,
		0x08C, 0x00093C3C,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x000F8000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x000F8000,
	0xA0000000,	0x00000000,
		0x085, 0x000F8000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0xA0000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0xB0000000,	0x00000000,
		0x0EF, 0x00001000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00044000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00048000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00044000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00040000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0xA0000000,	0x00000000,
		0x03C, 0x00048000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00030023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00028623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00021633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0001C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00010293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00009593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x00000F8B,
	0xA0000000,	0x00000000,
		0x03B, 0x0000078B,
	0xB0000000,	0x00000000,
		0x03C, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00044000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00044000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00044000,
	0xA0000000,	0x00000000,
		0x03C, 0x00024000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00070023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00068623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00061633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0005C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00050293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00049593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x00040F8B,
	0xA0000000,	0x00000000,
		0x03B, 0x0004078B,
	0xB0000000,	0x00000000,
		0x03C, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00004000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00060000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00004000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00060000,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0xA0000000,	0x00000000,
		0x03C, 0x00004000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B0023,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0xA0000000,	0x00000000,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A8623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A1633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0009C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00090293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00089593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x0008138B,
	0xA0000000,	0x00000000,
		0x03B, 0x0008078B,
	0xB0000000,	0x00000000,
		0x03C, 0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
		0x03B, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001003,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001003,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001803,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0xA0000000,	0x00000000,
		0x03A, 0x00000803,
	0xB0000000,	0x00000000,
		0x03B, 0x00040000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001002,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000001,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000802,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001803,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0xA0000000,	0x00000000,
		0x03A, 0x00001000,
	0xB0000000,	0x00000000,
		0x03B, 0x00080000,
	0x80000007,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001802,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000802,
	0xA0000000,	0x00000000,
		0x03A, 0x00001002,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x00013124,
		0x0EF, 0x00000100,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EB,
		0x034, 0x0004938B,
		0x034, 0x000481AC,
		0x034, 0x000471A9,
		0x034, 0x000460AC,
		0x034, 0x000450A9,
		0x034, 0x0004402E,
		0x034, 0x0004302B,
		0x034, 0x00042028,
		0x034, 0x0004100B,
		0x034, 0x00040008,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3AD,
		0x034, 0x0004938A,
		0x034, 0x0004818C,
		0x034, 0x00047189,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3AD,
		0x034, 0x0004938A,
		0x034, 0x0004818C,
		0x034, 0x00047189,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3AD,
		0x034, 0x0004938A,
		0x034, 0x0004818C,
		0x034, 0x00047189,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3AD,
		0x034, 0x0004938A,
		0x034, 0x0004818C,
		0x034, 0x00047189,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3F4,
		0x034, 0x000493D2,
		0x034, 0x000482D1,
		0x034, 0x000471F1,
		0x034, 0x000461EE,
		0x034, 0x000451EB,
		0x034, 0x000441E8,
		0x034, 0x0004314B,
		0x034, 0x00042148,
		0x034, 0x0004104B,
		0x034, 0x00040048,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004AFF7,
		0x034, 0x00049FF6,
		0x034, 0x00048FF3,
		0x034, 0x00047FF0,
		0x034, 0x00046FED,
		0x034, 0x00045FEA,
		0x034, 0x00044FE7,
		0x034, 0x00043CB1,
		0x034, 0x00042CAE,
		0x034, 0x00041CAB,
		0x034, 0x00040CA8,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3AD,
		0x034, 0x0004938A,
		0x034, 0x0004818C,
		0x034, 0x00047189,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3AD,
		0x034, 0x0004938A,
		0x034, 0x0004818C,
		0x034, 0x00047189,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0xA0000000,	0x00000000,
		0x034, 0x0004AFF4,
		0x034, 0x00049FF1,
		0x034, 0x00048FEE,
		0x034, 0x00047FEB,
		0x034, 0x00046FE8,
		0x034, 0x00045DEA,
		0x034, 0x00044CED,
		0x034, 0x00043CEA,
		0x034, 0x00042C6C,
		0x034, 0x00041C69,
		0x034, 0x00040C2B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EE,
		0x034, 0x000293EB,
		0x034, 0x0002838B,
		0x034, 0x000271AC,
		0x034, 0x000261A9,
		0x034, 0x000250AC,
		0x034, 0x000240A9,
		0x034, 0x000230A6,
		0x034, 0x0002202C,
		0x034, 0x00021029,
		0x034, 0x00020026,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3AD,
		0x034, 0x0002938A,
		0x034, 0x0002818C,
		0x034, 0x00027189,
		0x034, 0x0002606D,
		0x034, 0x0002504C,
		0x034, 0x0002402C,
		0x034, 0x00023029,
		0x034, 0x00022026,
		0x034, 0x00021023,
		0x034, 0x00020006,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3AD,
		0x034, 0x0002938A,
		0x034, 0x0002818C,
		0x034, 0x00027189,
		0x034, 0x0002606D,
		0x034, 0x0002504C,
		0x034, 0x0002402C,
		0x034, 0x00023029,
		0x034, 0x00022026,
		0x034, 0x00021023,
		0x034, 0x00020006,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3AD,
		0x034, 0x0002938A,
		0x034, 0x0002818C,
		0x034, 0x00027189,
		0x034, 0x0002606D,
		0x034, 0x0002504C,
		0x034, 0x0002402C,
		0x034, 0x00023029,
		0x034, 0x00022026,
		0x034, 0x00021023,
		0x034, 0x00020006,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3AD,
		0x034, 0x0002938A,
		0x034, 0x0002818C,
		0x034, 0x00027189,
		0x034, 0x0002606D,
		0x034, 0x0002504C,
		0x034, 0x0002402C,
		0x034, 0x00023029,
		0x034, 0x00022026,
		0x034, 0x00021023,
		0x034, 0x00020006,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3F5,
		0x034, 0x000293D2,
		0x034, 0x000283CE,
		0x034, 0x00027290,
		0x034, 0x0002628D,
		0x034, 0x0002528A,
		0x034, 0x00024287,
		0x034, 0x0002308D,
		0x034, 0x0002208A,
		0x034, 0x00021087,
		0x034, 0x00020048,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002AFF7,
		0x034, 0x00029FF6,
		0x034, 0x00028FF3,
		0x034, 0x00027FF0,
		0x034, 0x00026FED,
		0x034, 0x00025FEA,
		0x034, 0x00024FE7,
		0x034, 0x00023DEA,
		0x034, 0x00022DE7,
		0x034, 0x00021DE4,
		0x034, 0x00020D48,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3AD,
		0x034, 0x0002938A,
		0x034, 0x0002818C,
		0x034, 0x00027189,
		0x034, 0x0002606D,
		0x034, 0x0002504C,
		0x034, 0x0002402C,
		0x034, 0x00023029,
		0x034, 0x00022026,
		0x034, 0x00021023,
		0x034, 0x00020006,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3AD,
		0x034, 0x0002938A,
		0x034, 0x0002818C,
		0x034, 0x00027189,
		0x034, 0x0002606D,
		0x034, 0x0002504C,
		0x034, 0x0002402C,
		0x034, 0x00023029,
		0x034, 0x00022026,
		0x034, 0x00021023,
		0x034, 0x00020006,
	0xA0000000,	0x00000000,
		0x034, 0x0002AFF4,
		0x034, 0x00029FF1,
		0x034, 0x00028FEE,
		0x034, 0x00027FEB,
		0x034, 0x00026FE8,
		0x034, 0x00025DEA,
		0x034, 0x00024CED,
		0x034, 0x00023CEA,
		0x034, 0x00022C6C,
		0x034, 0x00021C69,
		0x034, 0x00020C2B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EF,
		0x034, 0x000093EC,
		0x034, 0x0000838C,
		0x034, 0x000071AD,
		0x034, 0x000061AA,
		0x034, 0x000050AD,
		0x034, 0x000040AA,
		0x034, 0x0000306A,
		0x034, 0x0000202D,
		0x034, 0x0000102A,
		0x034, 0x00000027,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3F1,
		0x034, 0x000092B1,
		0x034, 0x000081CF,
		0x034, 0x00007170,
		0x034, 0x0000616D,
		0x034, 0x0000516A,
		0x034, 0x00004167,
		0x034, 0x0000302F,
		0x034, 0x0000202C,
		0x034, 0x00001029,
		0x034, 0x00000026,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000AFF7,
		0x034, 0x00009FF6,
		0x034, 0x00008FF3,
		0x034, 0x00007FF0,
		0x034, 0x00006FED,
		0x034, 0x00005FEA,
		0x034, 0x00004FE7,
		0x034, 0x00003EC7,
		0x034, 0x00002EC4,
		0x034, 0x00001D4B,
		0x034, 0x00000D48,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0xA0000000,	0x00000000,
		0x034, 0x0000AFF4,
		0x034, 0x00009FF1,
		0x034, 0x00008FEE,
		0x034, 0x00007FEB,
		0x034, 0x00006FE8,
		0x034, 0x00005DEA,
		0x034, 0x00004CED,
		0x034, 0x00003CEA,
		0x034, 0x00002C6C,
		0x034, 0x00001C69,
		0x034, 0x00000C2B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EB,
		0x034, 0x000C938B,
		0x034, 0x000C81AC,
		0x034, 0x000C71A9,
		0x034, 0x000C60AC,
		0x034, 0x000C50A9,
		0x034, 0x000C402E,
		0x034, 0x000C302B,
		0x034, 0x000C2028,
		0x034, 0x000C100B,
		0x034, 0x000C0008,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3AD,
		0x034, 0x000C938A,
		0x034, 0x000C818C,
		0x034, 0x000C7189,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3AD,
		0x034, 0x000C938A,
		0x034, 0x000C818C,
		0x034, 0x000C7189,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3AD,
		0x034, 0x000C938A,
		0x034, 0x000C818C,
		0x034, 0x000C7189,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3AD,
		0x034, 0x000C938A,
		0x034, 0x000C818C,
		0x034, 0x000C7189,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3F4,
		0x034, 0x000C93D2,
		0x034, 0x000C82D1,
		0x034, 0x000C71F1,
		0x034, 0x000C61EE,
		0x034, 0x000C51EB,
		0x034, 0x000C41E8,
		0x034, 0x000C314B,
		0x034, 0x000C2148,
		0x034, 0x000C104B,
		0x034, 0x000C0048,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CAFF7,
		0x034, 0x000C9FF6,
		0x034, 0x000C8FF3,
		0x034, 0x000C7FF0,
		0x034, 0x000C6FED,
		0x034, 0x000C5FEA,
		0x034, 0x000C4FE7,
		0x034, 0x000C3CB1,
		0x034, 0x000C2CAE,
		0x034, 0x000C1CAB,
		0x034, 0x000C0CA8,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3AD,
		0x034, 0x000C938A,
		0x034, 0x000C818C,
		0x034, 0x000C7189,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3AD,
		0x034, 0x000C938A,
		0x034, 0x000C818C,
		0x034, 0x000C7189,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0xA0000000,	0x00000000,
		0x034, 0x000CA794,
		0x034, 0x000C9791,
		0x034, 0x000C878E,
		0x034, 0x000C778B,
		0x034, 0x000C658D,
		0x034, 0x000C558A,
		0x034, 0x000C448D,
		0x034, 0x000C348A,
		0x034, 0x000C244C,
		0x034, 0x000C1449,
		0x034, 0x000C042B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EE,
		0x034, 0x000A93EB,
		0x034, 0x000A838B,
		0x034, 0x000A71AC,
		0x034, 0x000A61A9,
		0x034, 0x000A50AC,
		0x034, 0x000A40A9,
		0x034, 0x000A30A6,
		0x034, 0x000A202C,
		0x034, 0x000A1029,
		0x034, 0x000A0026,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3AD,
		0x034, 0x000A938A,
		0x034, 0x000A818C,
		0x034, 0x000A7189,
		0x034, 0x000A606D,
		0x034, 0x000A504C,
		0x034, 0x000A402C,
		0x034, 0x000A3029,
		0x034, 0x000A2026,
		0x034, 0x000A1023,
		0x034, 0x000A0006,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3AD,
		0x034, 0x000A938A,
		0x034, 0x000A818C,
		0x034, 0x000A7189,
		0x034, 0x000A606D,
		0x034, 0x000A504C,
		0x034, 0x000A402C,
		0x034, 0x000A3029,
		0x034, 0x000A2026,
		0x034, 0x000A1023,
		0x034, 0x000A0006,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3AD,
		0x034, 0x000A938A,
		0x034, 0x000A818C,
		0x034, 0x000A7189,
		0x034, 0x000A606D,
		0x034, 0x000A504C,
		0x034, 0x000A402C,
		0x034, 0x000A3029,
		0x034, 0x000A2026,
		0x034, 0x000A1023,
		0x034, 0x000A0006,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3AD,
		0x034, 0x000A938A,
		0x034, 0x000A818C,
		0x034, 0x000A7189,
		0x034, 0x000A606D,
		0x034, 0x000A504C,
		0x034, 0x000A402C,
		0x034, 0x000A3029,
		0x034, 0x000A2026,
		0x034, 0x000A1023,
		0x034, 0x000A0006,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3F5,
		0x034, 0x000A93D2,
		0x034, 0x000A83CE,
		0x034, 0x000A7290,
		0x034, 0x000A628D,
		0x034, 0x000A528A,
		0x034, 0x000A4287,
		0x034, 0x000A308D,
		0x034, 0x000A208A,
		0x034, 0x000A1087,
		0x034, 0x000A0048,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AAFF7,
		0x034, 0x000A9FF6,
		0x034, 0x000A8FF3,
		0x034, 0x000A7FF0,
		0x034, 0x000A6FED,
		0x034, 0x000A5FEA,
		0x034, 0x000A4FE7,
		0x034, 0x000A3DEA,
		0x034, 0x000A2DE7,
		0x034, 0x000A1DE4,
		0x034, 0x000A0D48,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3AD,
		0x034, 0x000A938A,
		0x034, 0x000A818C,
		0x034, 0x000A7189,
		0x034, 0x000A606D,
		0x034, 0x000A504C,
		0x034, 0x000A402C,
		0x034, 0x000A3029,
		0x034, 0x000A2026,
		0x034, 0x000A1023,
		0x034, 0x000A0006,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3AD,
		0x034, 0x000A938A,
		0x034, 0x000A818C,
		0x034, 0x000A7189,
		0x034, 0x000A606D,
		0x034, 0x000A504C,
		0x034, 0x000A402C,
		0x034, 0x000A3029,
		0x034, 0x000A2026,
		0x034, 0x000A1023,
		0x034, 0x000A0006,
	0xA0000000,	0x00000000,
		0x034, 0x000AA794,
		0x034, 0x000A9791,
		0x034, 0x000A878E,
		0x034, 0x000A778B,
		0x034, 0x000A658D,
		0x034, 0x000A558A,
		0x034, 0x000A448D,
		0x034, 0x000A348A,
		0x034, 0x000A244C,
		0x034, 0x000A1449,
		0x034, 0x000A042B,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EF,
		0x034, 0x000893EC,
		0x034, 0x0008838C,
		0x034, 0x000871AD,
		0x034, 0x000861AA,
		0x034, 0x000850AD,
		0x034, 0x000840AA,
		0x034, 0x0008306A,
		0x034, 0x0008202D,
		0x034, 0x0008102A,
		0x034, 0x00080027,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3F1,
		0x034, 0x000892B1,
		0x034, 0x000881CF,
		0x034, 0x00087170,
		0x034, 0x0008616D,
		0x034, 0x0008516A,
		0x034, 0x00084167,
		0x034, 0x0008302F,
		0x034, 0x0008202C,
		0x034, 0x00081029,
		0x034, 0x00080026,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008AFF7,
		0x034, 0x00089FF6,
		0x034, 0x00088FF3,
		0x034, 0x00087FF0,
		0x034, 0x00086FED,
		0x034, 0x00085FEA,
		0x034, 0x00084FE7,
		0x034, 0x00083EC7,
		0x034, 0x00082EC4,
		0x034, 0x00081D4B,
		0x034, 0x00080D48,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0xA0000000,	0x00000000,
		0x034, 0x0008A794,
		0x034, 0x00089791,
		0x034, 0x0008878E,
		0x034, 0x0008778B,
		0x034, 0x0008658D,
		0x034, 0x0008558A,
		0x034, 0x0008448D,
		0x034, 0x0008348A,
		0x034, 0x0008244C,
		0x034, 0x00081449,
		0x034, 0x0008042B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0xA0000000,	0x00000000,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x0001712A,
		0x0EF, 0x00000040,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0xA0000000,	0x00000000,
		0x035, 0x00000484,
		0x035, 0x00008484,
		0x035, 0x00010484,
		0x035, 0x00020584,
		0x035, 0x00028584,
		0x035, 0x00030584,
		0x035, 0x00040584,
		0x035, 0x00048584,
		0x035, 0x00050584,
		0x035, 0x000805FB,
		0x035, 0x000885FB,
		0x035, 0x000905FB,
		0x035, 0x000A05FB,
		0x035, 0x000A85FB,
		0x035, 0x000B05FB,
		0x035, 0x000C05FB,
		0x035, 0x000C85FB,
		0x035, 0x000D05FB,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0xA0000000,	0x00000000,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x0001712A,
		0x0EF, 0x00000010,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000473,
		0x036, 0x00008473,
		0x036, 0x00010473,
		0x036, 0x00020473,
		0x036, 0x00028473,
		0x036, 0x00030473,
		0x036, 0x00040473,
		0x036, 0x00048473,
		0x036, 0x00050473,
		0x036, 0x00080473,
		0x036, 0x00088473,
		0x036, 0x00090473,
		0x036, 0x000A0473,
		0x036, 0x000A8473,
		0x036, 0x000B0473,
		0x036, 0x000C0473,
		0x036, 0x000C8473,
		0x036, 0x000D0473,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0xA0000000,	0x00000000,
		0x036, 0x00000474,
		0x036, 0x00008474,
		0x036, 0x00010474,
		0x036, 0x00020474,
		0x036, 0x00028474,
		0x036, 0x00030474,
		0x036, 0x00040474,
		0x036, 0x00048474,
		0x036, 0x00050474,
		0x036, 0x00080474,
		0x036, 0x00088474,
		0x036, 0x00090474,
		0x036, 0x000A0474,
		0x036, 0x000A8474,
		0x036, 0x000B0474,
		0x036, 0x000C0474,
		0x036, 0x000C8474,
		0x036, 0x000D0474,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000004,
		0x037, 0x00000000,
		0x038, 0x0000514E,
		0x037, 0x00004000,
		0x038, 0x0000514E,
		0x037, 0x00008000,
		0x038, 0x0000514E,
		0x037, 0x00010000,
		0x038, 0x0000514E,
		0x037, 0x00014000,
		0x038, 0x0000514E,
		0x037, 0x00018000,
		0x038, 0x0000514E,
		0x037, 0x0001C000,
		0x038, 0x0000514E,
		0x037, 0x00020000,
		0x038, 0x0000514E,
		0x037, 0x00024000,
		0x038, 0x0000514E,
		0x037, 0x00028000,
		0x038, 0x0000514E,
		0x037, 0x0002C000,
		0x038, 0x0000714E,
		0x037, 0x00030000,
		0x038, 0x0000514E,
		0x037, 0x00034000,
		0x038, 0x0000514E,
		0x037, 0x00038000,
		0x038, 0x0000514E,
		0x037, 0x0003C000,
		0x038, 0x0000514E,
		0x037, 0x00040000,
		0x038, 0x0000514E,
		0x037, 0x00044000,
		0x038, 0x0000514E,
		0x037, 0x00048000,
		0x038, 0x0000514E,
		0x037, 0x00080000,
		0x038, 0x00005ECE,
		0x037, 0x00084000,
		0x038, 0x00005ECE,
		0x037, 0x00088000,
		0x038, 0x00005ECE,
		0x037, 0x00090000,
		0x038, 0x00005ECE,
		0x037, 0x00094000,
		0x038, 0x00005ECE,
		0x037, 0x00098000,
		0x038, 0x00005ECE,
		0x037, 0x0009C000,
		0x038, 0x00005ECE,
		0x037, 0x000A0000,
		0x038, 0x00005ECE,
		0x037, 0x000A4000,
		0x038, 0x00005ECE,
		0x037, 0x000A8000,
		0x038, 0x00005ECE,
		0x037, 0x000AC000,
		0x038, 0x00005ECE,
		0x037, 0x000B0000,
		0x038, 0x00005ECE,
		0x037, 0x000B4000,
		0x038, 0x00005ECE,
		0x037, 0x000B8000,
		0x038, 0x00005ECE,
		0x037, 0x000BC000,
		0x038, 0x00005ECE,
		0x037, 0x000C0000,
		0x038, 0x00005ECE,
		0x037, 0x000C4000,
		0x038, 0x00005ECE,
		0x037, 0x000C8000,
		0x038, 0x00005ECE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000008,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x03C, 0x0000007D,
		0x03C, 0x0000047D,
		0x03C, 0x0000087D,
		0x03C, 0x0000107D,
		0x03C, 0x0000147D,
		0x03C, 0x0000187D,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000275,
		0x03C, 0x00000542,
		0x03C, 0x00000821,
		0x03C, 0x00001275,
		0x03C, 0x00001542,
		0x03C, 0x00001821,
		0x03C, 0x00002275,
		0x03C, 0x00002542,
		0x03C, 0x00002821,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027F,
		0x03C, 0x00000542,
		0x03C, 0x00000821,
		0x03C, 0x0000127F,
		0x03C, 0x00001542,
		0x03C, 0x00001821,
		0x03C, 0x0000227F,
		0x03C, 0x00002542,
		0x03C, 0x00002821,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027F,
		0x03C, 0x00000542,
		0x03C, 0x00000821,
		0x03C, 0x0000127F,
		0x03C, 0x00001542,
		0x03C, 0x00001821,
		0x03C, 0x0000227F,
		0x03C, 0x00002542,
		0x03C, 0x00002821,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027F,
		0x03C, 0x00000542,
		0x03C, 0x00000821,
		0x03C, 0x0000127F,
		0x03C, 0x00001542,
		0x03C, 0x00001821,
		0x03C, 0x0000227F,
		0x03C, 0x00002542,
		0x03C, 0x00002821,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027F,
		0x03C, 0x00000542,
		0x03C, 0x00000821,
		0x03C, 0x0000127F,
		0x03C, 0x00001542,
		0x03C, 0x00001821,
		0x03C, 0x0000227F,
		0x03C, 0x00002542,
		0x03C, 0x00002821,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027F,
		0x03C, 0x00000542,
		0x03C, 0x00000821,
		0x03C, 0x0000127F,
		0x03C, 0x00001542,
		0x03C, 0x00001821,
		0x03C, 0x0000227F,
		0x03C, 0x00002542,
		0x03C, 0x00002821,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027F,
		0x03C, 0x00000542,
		0x03C, 0x00000821,
		0x03C, 0x0000127F,
		0x03C, 0x00001542,
		0x03C, 0x00001821,
		0x03C, 0x0000227F,
		0x03C, 0x00002542,
		0x03C, 0x00002821,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027F,
		0x03C, 0x00000542,
		0x03C, 0x00000821,
		0x03C, 0x0000127F,
		0x03C, 0x00001542,
		0x03C, 0x00001821,
		0x03C, 0x0000227F,
		0x03C, 0x00002542,
		0x03C, 0x00002821,
	0xA0000000,	0x00000000,
		0x03C, 0x0000037E,
		0x03C, 0x00000575,
		0x03C, 0x00000971,
		0x03C, 0x0000127E,
		0x03C, 0x00001575,
		0x03C, 0x00001871,
		0x03C, 0x0000217E,
		0x03C, 0x00002575,
		0x03C, 0x00002871,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x061, 0x000C0D47,
		0x062, 0x0000133C,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0xA0000000,	0x00000000,
		0x063, 0x0007D0E7,
	0xB0000000,	0x00000000,
		0x064, 0x00014FEC,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0xA0000000,	0x00000000,
		0x065, 0x000923FF,
	0xB0000000,	0x00000000,
		0x066, 0x00000040,
		0x057, 0x00050000,
		0x056, 0x00051DF0,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x055, 0x00082060,
	0xB0000000,	0x00000000,
};

RTW_DECL_TABLE_RF_RADIO(rtw8814a_rf_d, D);

static const struct rtw_txpwr_lmt_cfg_pair rtw8814a_txpwr_lmt[] = {
	{ 0, 0, 0, 0, 1, 36, },
	{ 2, 0, 0, 0, 1, 32, },
	{ 1, 0, 0, 0, 1, 32, },
	{ 0, 0, 0, 0, 2, 36, },
	{ 2, 0, 0, 0, 2, 32, },
	{ 1, 0, 0, 0, 2, 32, },
	{ 0, 0, 0, 0, 3, 36, },
	{ 2, 0, 0, 0, 3, 32, },
	{ 1, 0, 0, 0, 3, 32, },
	{ 0, 0, 0, 0, 4, 36, },
	{ 2, 0, 0, 0, 4, 32, },
	{ 1, 0, 0, 0, 4, 32, },
	{ 0, 0, 0, 0, 5, 36, },
	{ 2, 0, 0, 0, 5, 32, },
	{ 1, 0, 0, 0, 5, 32, },
	{ 0, 0, 0, 0, 6, 36, },
	{ 2, 0, 0, 0, 6, 32, },
	{ 1, 0, 0, 0, 6, 32, },
	{ 0, 0, 0, 0, 7, 36, },
	{ 2, 0, 0, 0, 7, 32, },
	{ 1, 0, 0, 0, 7, 32, },
	{ 0, 0, 0, 0, 8, 36, },
	{ 2, 0, 0, 0, 8, 32, },
	{ 1, 0, 0, 0, 8, 32, },
	{ 0, 0, 0, 0, 9, 36, },
	{ 2, 0, 0, 0, 9, 32, },
	{ 1, 0, 0, 0, 9, 32, },
	{ 0, 0, 0, 0, 10, 36, },
	{ 2, 0, 0, 0, 10, 32, },
	{ 1, 0, 0, 0, 10, 32, },
	{ 0, 0, 0, 0, 11, 36, },
	{ 2, 0, 0, 0, 11, 32, },
	{ 1, 0, 0, 0, 11, 32, },
	{ 0, 0, 0, 0, 12, 63, },
	{ 2, 0, 0, 0, 12, 32, },
	{ 1, 0, 0, 0, 12, 32, },
	{ 0, 0, 0, 0, 13, 63, },
	{ 2, 0, 0, 0, 13, 32, },
	{ 1, 0, 0, 0, 13, 32, },
	{ 0, 0, 0, 0, 14, 63, },
	{ 2, 0, 0, 0, 14, 63, },
	{ 1, 0, 0, 0, 14, 32, },
	{ 0, 0, 0, 1, 1, 34, },
	{ 2, 0, 0, 1, 1, 32, },
	{ 1, 0, 0, 1, 1, 32, },
	{ 0, 0, 0, 1, 2, 36, },
	{ 2, 0, 0, 1, 2, 32, },
	{ 1, 0, 0, 1, 2, 32, },
	{ 0, 0, 0, 1, 3, 36, },
	{ 2, 0, 0, 1, 3, 32, },
	{ 1, 0, 0, 1, 3, 32, },
	{ 0, 0, 0, 1, 4, 36, },
	{ 2, 0, 0, 1, 4, 32, },
	{ 1, 0, 0, 1, 4, 32, },
	{ 0, 0, 0, 1, 5, 36, },
	{ 2, 0, 0, 1, 5, 32, },
	{ 1, 0, 0, 1, 5, 32, },
	{ 0, 0, 0, 1, 6, 36, },
	{ 2, 0, 0, 1, 6, 32, },
	{ 1, 0, 0, 1, 6, 32, },
	{ 0, 0, 0, 1, 7, 36, },
	{ 2, 0, 0, 1, 7, 32, },
	{ 1, 0, 0, 1, 7, 32, },
	{ 0, 0, 0, 1, 8, 36, },
	{ 2, 0, 0, 1, 8, 32, },
	{ 1, 0, 0, 1, 8, 32, },
	{ 0, 0, 0, 1, 9, 36, },
	{ 2, 0, 0, 1, 9, 32, },
	{ 1, 0, 0, 1, 9, 32, },
	{ 0, 0, 0, 1, 10, 36, },
	{ 2, 0, 0, 1, 10, 32, },
	{ 1, 0, 0, 1, 10, 32, },
	{ 0, 0, 0, 1, 11, 32, },
	{ 2, 0, 0, 1, 11, 32, },
	{ 1, 0, 0, 1, 11, 32, },
	{ 0, 0, 0, 1, 12, 63, },
	{ 2, 0, 0, 1, 12, 32, },
	{ 1, 0, 0, 1, 12, 32, },
	{ 0, 0, 0, 1, 13, 63, },
	{ 2, 0, 0, 1, 13, 32, },
	{ 1, 0, 0, 1, 13, 32, },
	{ 0, 0, 0, 1, 14, 63, },
	{ 2, 0, 0, 1, 14, 63, },
	{ 1, 0, 0, 1, 14, 63, },
	{ 0, 0, 0, 2, 1, 34, },
	{ 2, 0, 0, 2, 1, 32, },
	{ 1, 0, 0, 2, 1, 32, },
	{ 0, 0, 0, 2, 2, 36, },
	{ 2, 0, 0, 2, 2, 32, },
	{ 1, 0, 0, 2, 2, 32, },
	{ 0, 0, 0, 2, 3, 36, },
	{ 2, 0, 0, 2, 3, 32, },
	{ 1, 0, 0, 2, 3, 32, },
	{ 0, 0, 0, 2, 4, 36, },
	{ 2, 0, 0, 2, 4, 32, },
	{ 1, 0, 0, 2, 4, 32, },
	{ 0, 0, 0, 2, 5, 36, },
	{ 2, 0, 0, 2, 5, 32, },
	{ 1, 0, 0, 2, 5, 32, },
	{ 0, 0, 0, 2, 6, 36, },
	{ 2, 0, 0, 2, 6, 32, },
	{ 1, 0, 0, 2, 6, 32, },
	{ 0, 0, 0, 2, 7, 36, },
	{ 2, 0, 0, 2, 7, 32, },
	{ 1, 0, 0, 2, 7, 32, },
	{ 0, 0, 0, 2, 8, 36, },
	{ 2, 0, 0, 2, 8, 32, },
	{ 1, 0, 0, 2, 8, 32, },
	{ 0, 0, 0, 2, 9, 36, },
	{ 2, 0, 0, 2, 9, 32, },
	{ 1, 0, 0, 2, 9, 32, },
	{ 0, 0, 0, 2, 10, 36, },
	{ 2, 0, 0, 2, 10, 32, },
	{ 1, 0, 0, 2, 10, 32, },
	{ 0, 0, 0, 2, 11, 32, },
	{ 2, 0, 0, 2, 11, 32, },
	{ 1, 0, 0, 2, 11, 32, },
	{ 0, 0, 0, 2, 12, 63, },
	{ 2, 0, 0, 2, 12, 32, },
	{ 1, 0, 0, 2, 12, 32, },
	{ 0, 0, 0, 2, 13, 63, },
	{ 2, 0, 0, 2, 13, 32, },
	{ 1, 0, 0, 2, 13, 32, },
	{ 0, 0, 0, 2, 14, 63, },
	{ 2, 0, 0, 2, 14, 63, },
	{ 1, 0, 0, 2, 14, 63, },
	{ 0, 0, 0, 3, 1, 32, },
	{ 2, 0, 0, 3, 1, 30, },
	{ 1, 0, 0, 3, 1, 30, },
	{ 0, 0, 0, 3, 2, 34, },
	{ 2, 0, 0, 3, 2, 30, },
	{ 1, 0, 0, 3, 2, 30, },
	{ 0, 0, 0, 3, 3, 34, },
	{ 2, 0, 0, 3, 3, 30, },
	{ 1, 0, 0, 3, 3, 30, },
	{ 0, 0, 0, 3, 4, 34, },
	{ 2, 0, 0, 3, 4, 30, },
	{ 1, 0, 0, 3, 4, 30, },
	{ 0, 0, 0, 3, 5, 34, },
	{ 2, 0, 0, 3, 5, 30, },
	{ 1, 0, 0, 3, 5, 30, },
	{ 0, 0, 0, 3, 6, 34, },
	{ 2, 0, 0, 3, 6, 30, },
	{ 1, 0, 0, 3, 6, 30, },
	{ 0, 0, 0, 3, 7, 34, },
	{ 2, 0, 0, 3, 7, 30, },
	{ 1, 0, 0, 3, 7, 30, },
	{ 0, 0, 0, 3, 8, 34, },
	{ 2, 0, 0, 3, 8, 30, },
	{ 1, 0, 0, 3, 8, 30, },
	{ 0, 0, 0, 3, 9, 34, },
	{ 2, 0, 0, 3, 9, 30, },
	{ 1, 0, 0, 3, 9, 30, },
	{ 0, 0, 0, 3, 10, 34, },
	{ 2, 0, 0, 3, 10, 30, },
	{ 1, 0, 0, 3, 10, 30, },
	{ 0, 0, 0, 3, 11, 30, },
	{ 2, 0, 0, 3, 11, 30, },
	{ 1, 0, 0, 3, 11, 30, },
	{ 0, 0, 0, 3, 12, 63, },
	{ 2, 0, 0, 3, 12, 30, },
	{ 1, 0, 0, 3, 12, 30, },
	{ 0, 0, 0, 3, 13, 63, },
	{ 2, 0, 0, 3, 13, 30, },
	{ 1, 0, 0, 3, 13, 30, },
	{ 0, 0, 0, 3, 14, 63, },
	{ 2, 0, 0, 3, 14, 63, },
	{ 1, 0, 0, 3, 14, 63, },
	{ 0, 0, 0, 6, 1, 30, },
	{ 2, 0, 0, 6, 1, 28, },
	{ 1, 0, 0, 6, 1, 28, },
	{ 0, 0, 0, 6, 2, 32, },
	{ 2, 0, 0, 6, 2, 28, },
	{ 1, 0, 0, 6, 2, 28, },
	{ 0, 0, 0, 6, 3, 32, },
	{ 2, 0, 0, 6, 3, 28, },
	{ 1, 0, 0, 6, 3, 28, },
	{ 0, 0, 0, 6, 4, 32, },
	{ 2, 0, 0, 6, 4, 28, },
	{ 1, 0, 0, 6, 4, 28, },
	{ 0, 0, 0, 6, 5, 32, },
	{ 2, 0, 0, 6, 5, 28, },
	{ 1, 0, 0, 6, 5, 28, },
	{ 0, 0, 0, 6, 6, 32, },
	{ 2, 0, 0, 6, 6, 28, },
	{ 1, 0, 0, 6, 6, 28, },
	{ 0, 0, 0, 6, 7, 32, },
	{ 2, 0, 0, 6, 7, 28, },
	{ 1, 0, 0, 6, 7, 28, },
	{ 0, 0, 0, 6, 8, 32, },
	{ 2, 0, 0, 6, 8, 28, },
	{ 1, 0, 0, 6, 8, 28, },
	{ 0, 0, 0, 6, 9, 32, },
	{ 2, 0, 0, 6, 9, 28, },
	{ 1, 0, 0, 6, 9, 28, },
	{ 0, 0, 0, 6, 10, 32, },
	{ 2, 0, 0, 6, 10, 28, },
	{ 1, 0, 0, 6, 10, 28, },
	{ 0, 0, 0, 6, 11, 28, },
	{ 2, 0, 0, 6, 11, 28, },
	{ 1, 0, 0, 6, 11, 28, },
	{ 0, 0, 0, 6, 12, 63, },
	{ 2, 0, 0, 6, 12, 28, },
	{ 1, 0, 0, 6, 12, 28, },
	{ 0, 0, 0, 6, 13, 63, },
	{ 2, 0, 0, 6, 13, 28, },
	{ 1, 0, 0, 6, 13, 28, },
	{ 0, 0, 0, 6, 14, 63, },
	{ 2, 0, 0, 6, 14, 63, },
	{ 1, 0, 0, 6, 14, 63, },
	{ 0, 0, 0, 7, 1, 28, },
	{ 2, 0, 0, 7, 1, 26, },
	{ 1, 0, 0, 7, 1, 26, },
	{ 0, 0, 0, 7, 2, 30, },
	{ 2, 0, 0, 7, 2, 26, },
	{ 1, 0, 0, 7, 2, 26, },
	{ 0, 0, 0, 7, 3, 30, },
	{ 2, 0, 0, 7, 3, 26, },
	{ 1, 0, 0, 7, 3, 26, },
	{ 0, 0, 0, 7, 4, 30, },
	{ 2, 0, 0, 7, 4, 26, },
	{ 1, 0, 0, 7, 4, 26, },
	{ 0, 0, 0, 7, 5, 30, },
	{ 2, 0, 0, 7, 5, 26, },
	{ 1, 0, 0, 7, 5, 26, },
	{ 0, 0, 0, 7, 6, 30, },
	{ 2, 0, 0, 7, 6, 26, },
	{ 1, 0, 0, 7, 6, 26, },
	{ 0, 0, 0, 7, 7, 30, },
	{ 2, 0, 0, 7, 7, 26, },
	{ 1, 0, 0, 7, 7, 26, },
	{ 0, 0, 0, 7, 8, 30, },
	{ 2, 0, 0, 7, 8, 26, },
	{ 1, 0, 0, 7, 8, 26, },
	{ 0, 0, 0, 7, 9, 30, },
	{ 2, 0, 0, 7, 9, 26, },
	{ 1, 0, 0, 7, 9, 26, },
	{ 0, 0, 0, 7, 10, 30, },
	{ 2, 0, 0, 7, 10, 26, },
	{ 1, 0, 0, 7, 10, 26, },
	{ 0, 0, 0, 7, 11, 26, },
	{ 2, 0, 0, 7, 11, 26, },
	{ 1, 0, 0, 7, 11, 26, },
	{ 0, 0, 0, 7, 12, 63, },
	{ 2, 0, 0, 7, 12, 26, },
	{ 1, 0, 0, 7, 12, 26, },
	{ 0, 0, 0, 7, 13, 63, },
	{ 2, 0, 0, 7, 13, 26, },
	{ 1, 0, 0, 7, 13, 26, },
	{ 0, 0, 0, 7, 14, 63, },
	{ 2, 0, 0, 7, 14, 63, },
	{ 1, 0, 0, 7, 14, 63, },
	{ 0, 0, 1, 2, 1, 63, },
	{ 2, 0, 1, 2, 1, 63, },
	{ 1, 0, 1, 2, 1, 63, },
	{ 0, 0, 1, 2, 2, 63, },
	{ 2, 0, 1, 2, 2, 63, },
	{ 1, 0, 1, 2, 2, 63, },
	{ 0, 0, 1, 2, 3, 32, },
	{ 2, 0, 1, 2, 3, 32, },
	{ 1, 0, 1, 2, 3, 32, },
	{ 0, 0, 1, 2, 4, 36, },
	{ 2, 0, 1, 2, 4, 32, },
	{ 1, 0, 1, 2, 4, 32, },
	{ 0, 0, 1, 2, 5, 36, },
	{ 2, 0, 1, 2, 5, 32, },
	{ 1, 0, 1, 2, 5, 32, },
	{ 0, 0, 1, 2, 6, 36, },
	{ 2, 0, 1, 2, 6, 32, },
	{ 1, 0, 1, 2, 6, 32, },
	{ 0, 0, 1, 2, 7, 36, },
	{ 2, 0, 1, 2, 7, 32, },
	{ 1, 0, 1, 2, 7, 32, },
	{ 0, 0, 1, 2, 8, 36, },
	{ 2, 0, 1, 2, 8, 32, },
	{ 1, 0, 1, 2, 8, 32, },
	{ 0, 0, 1, 2, 9, 36, },
	{ 2, 0, 1, 2, 9, 32, },
	{ 1, 0, 1, 2, 9, 32, },
	{ 0, 0, 1, 2, 10, 36, },
	{ 2, 0, 1, 2, 10, 32, },
	{ 1, 0, 1, 2, 10, 32, },
	{ 0, 0, 1, 2, 11, 32, },
	{ 2, 0, 1, 2, 11, 32, },
	{ 1, 0, 1, 2, 11, 32, },
	{ 0, 0, 1, 2, 12, 63, },
	{ 2, 0, 1, 2, 12, 32, },
	{ 1, 0, 1, 2, 12, 32, },
	{ 0, 0, 1, 2, 13, 63, },
	{ 2, 0, 1, 2, 13, 32, },
	{ 1, 0, 1, 2, 13, 32, },
	{ 0, 0, 1, 2, 14, 63, },
	{ 2, 0, 1, 2, 14, 63, },
	{ 1, 0, 1, 2, 14, 63, },
	{ 0, 0, 1, 3, 1, 63, },
	{ 2, 0, 1, 3, 1, 63, },
	{ 1, 0, 1, 3, 1, 63, },
	{ 0, 0, 1, 3, 2, 63, },
	{ 2, 0, 1, 3, 2, 63, },
	{ 1, 0, 1, 3, 2, 63, },
	{ 0, 0, 1, 3, 3, 30, },
	{ 2, 0, 1, 3, 3, 30, },
	{ 1, 0, 1, 3, 3, 30, },
	{ 0, 0, 1, 3, 4, 34, },
	{ 2, 0, 1, 3, 4, 30, },
	{ 1, 0, 1, 3, 4, 30, },
	{ 0, 0, 1, 3, 5, 34, },
	{ 2, 0, 1, 3, 5, 30, },
	{ 1, 0, 1, 3, 5, 30, },
	{ 0, 0, 1, 3, 6, 34, },
	{ 2, 0, 1, 3, 6, 30, },
	{ 1, 0, 1, 3, 6, 30, },
	{ 0, 0, 1, 3, 7, 34, },
	{ 2, 0, 1, 3, 7, 30, },
	{ 1, 0, 1, 3, 7, 30, },
	{ 0, 0, 1, 3, 8, 34, },
	{ 2, 0, 1, 3, 8, 30, },
	{ 1, 0, 1, 3, 8, 30, },
	{ 0, 0, 1, 3, 9, 34, },
	{ 2, 0, 1, 3, 9, 30, },
	{ 1, 0, 1, 3, 9, 30, },
	{ 0, 0, 1, 3, 10, 34, },
	{ 2, 0, 1, 3, 10, 30, },
	{ 1, 0, 1, 3, 10, 30, },
	{ 0, 0, 1, 3, 11, 30, },
	{ 2, 0, 1, 3, 11, 30, },
	{ 1, 0, 1, 3, 11, 30, },
	{ 0, 0, 1, 3, 12, 63, },
	{ 2, 0, 1, 3, 12, 30, },
	{ 1, 0, 1, 3, 12, 30, },
	{ 0, 0, 1, 3, 13, 63, },
	{ 2, 0, 1, 3, 13, 30, },
	{ 1, 0, 1, 3, 13, 30, },
	{ 0, 0, 1, 3, 14, 63, },
	{ 2, 0, 1, 3, 14, 63, },
	{ 1, 0, 1, 3, 14, 63, },
	{ 0, 0, 1, 6, 1, 63, },
	{ 2, 0, 1, 6, 1, 63, },
	{ 1, 0, 1, 6, 1, 63, },
	{ 0, 0, 1, 6, 2, 63, },
	{ 2, 0, 1, 6, 2, 63, },
	{ 1, 0, 1, 6, 2, 63, },
	{ 0, 0, 1, 6, 3, 28, },
	{ 2, 0, 1, 6, 3, 28, },
	{ 1, 0, 1, 6, 3, 28, },
	{ 0, 0, 1, 6, 4, 32, },
	{ 2, 0, 1, 6, 4, 28, },
	{ 1, 0, 1, 6, 4, 28, },
	{ 0, 0, 1, 6, 5, 32, },
	{ 2, 0, 1, 6, 5, 28, },
	{ 1, 0, 1, 6, 5, 28, },
	{ 0, 0, 1, 6, 6, 32, },
	{ 2, 0, 1, 6, 6, 28, },
	{ 1, 0, 1, 6, 6, 28, },
	{ 0, 0, 1, 6, 7, 32, },
	{ 2, 0, 1, 6, 7, 28, },
	{ 1, 0, 1, 6, 7, 28, },
	{ 0, 0, 1, 6, 8, 32, },
	{ 2, 0, 1, 6, 8, 28, },
	{ 1, 0, 1, 6, 8, 28, },
	{ 0, 0, 1, 6, 9, 32, },
	{ 2, 0, 1, 6, 9, 28, },
	{ 1, 0, 1, 6, 9, 28, },
	{ 0, 0, 1, 6, 10, 32, },
	{ 2, 0, 1, 6, 10, 28, },
	{ 1, 0, 1, 6, 10, 28, },
	{ 0, 0, 1, 6, 11, 28, },
	{ 2, 0, 1, 6, 11, 28, },
	{ 1, 0, 1, 6, 11, 28, },
	{ 0, 0, 1, 6, 12, 63, },
	{ 2, 0, 1, 6, 12, 28, },
	{ 1, 0, 1, 6, 12, 28, },
	{ 0, 0, 1, 6, 13, 63, },
	{ 2, 0, 1, 6, 13, 28, },
	{ 1, 0, 1, 6, 13, 28, },
	{ 0, 0, 1, 6, 14, 63, },
	{ 2, 0, 1, 6, 14, 63, },
	{ 1, 0, 1, 6, 14, 63, },
	{ 0, 0, 1, 7, 1, 63, },
	{ 2, 0, 1, 7, 1, 63, },
	{ 1, 0, 1, 7, 1, 63, },
	{ 0, 0, 1, 7, 2, 63, },
	{ 2, 0, 1, 7, 2, 63, },
	{ 1, 0, 1, 7, 2, 63, },
	{ 0, 0, 1, 7, 3, 26, },
	{ 2, 0, 1, 7, 3, 26, },
	{ 1, 0, 1, 7, 3, 26, },
	{ 0, 0, 1, 7, 4, 30, },
	{ 2, 0, 1, 7, 4, 26, },
	{ 1, 0, 1, 7, 4, 26, },
	{ 0, 0, 1, 7, 5, 30, },
	{ 2, 0, 1, 7, 5, 26, },
	{ 1, 0, 1, 7, 5, 26, },
	{ 0, 0, 1, 7, 6, 30, },
	{ 2, 0, 1, 7, 6, 26, },
	{ 1, 0, 1, 7, 6, 26, },
	{ 0, 0, 1, 7, 7, 30, },
	{ 2, 0, 1, 7, 7, 26, },
	{ 1, 0, 1, 7, 7, 26, },
	{ 0, 0, 1, 7, 8, 30, },
	{ 2, 0, 1, 7, 8, 26, },
	{ 1, 0, 1, 7, 8, 26, },
	{ 0, 0, 1, 7, 9, 30, },
	{ 2, 0, 1, 7, 9, 26, },
	{ 1, 0, 1, 7, 9, 26, },
	{ 0, 0, 1, 7, 10, 30, },
	{ 2, 0, 1, 7, 10, 26, },
	{ 1, 0, 1, 7, 10, 26, },
	{ 0, 0, 1, 7, 11, 26, },
	{ 2, 0, 1, 7, 11, 26, },
	{ 1, 0, 1, 7, 11, 26, },
	{ 0, 0, 1, 7, 12, 63, },
	{ 2, 0, 1, 7, 12, 26, },
	{ 1, 0, 1, 7, 12, 26, },
	{ 0, 0, 1, 7, 13, 63, },
	{ 2, 0, 1, 7, 13, 26, },
	{ 1, 0, 1, 7, 13, 26, },
	{ 0, 0, 1, 7, 14, 63, },
	{ 2, 0, 1, 7, 14, 63, },
	{ 1, 0, 1, 7, 14, 63, },
	{ 0, 1, 0, 1, 36, 30, },
	{ 2, 1, 0, 1, 36, 32, },
	{ 1, 1, 0, 1, 36, 32, },
	{ 0, 1, 0, 1, 40, 30, },
	{ 2, 1, 0, 1, 40, 32, },
	{ 1, 1, 0, 1, 40, 32, },
	{ 0, 1, 0, 1, 44, 30, },
	{ 2, 1, 0, 1, 44, 32, },
	{ 1, 1, 0, 1, 44, 32, },
	{ 0, 1, 0, 1, 48, 30, },
	{ 2, 1, 0, 1, 48, 32, },
	{ 1, 1, 0, 1, 48, 32, },
	{ 0, 1, 0, 1, 52, 36, },
	{ 2, 1, 0, 1, 52, 32, },
	{ 1, 1, 0, 1, 52, 32, },
	{ 0, 1, 0, 1, 56, 34, },
	{ 2, 1, 0, 1, 56, 32, },
	{ 1, 1, 0, 1, 56, 32, },
	{ 0, 1, 0, 1, 60, 32, },
	{ 2, 1, 0, 1, 60, 32, },
	{ 1, 1, 0, 1, 60, 32, },
	{ 0, 1, 0, 1, 64, 28, },
	{ 2, 1, 0, 1, 64, 32, },
	{ 1, 1, 0, 1, 64, 32, },
	{ 0, 1, 0, 1, 100, 30, },
	{ 2, 1, 0, 1, 100, 32, },
	{ 1, 1, 0, 1, 100, 32, },
	{ 0, 1, 0, 1, 104, 30, },
	{ 2, 1, 0, 1, 104, 32, },
	{ 1, 1, 0, 1, 104, 32, },
	{ 0, 1, 0, 1, 108, 32, },
	{ 2, 1, 0, 1, 108, 32, },
	{ 1, 1, 0, 1, 108, 32, },
	{ 0, 1, 0, 1, 112, 34, },
	{ 2, 1, 0, 1, 112, 32, },
	{ 1, 1, 0, 1, 112, 32, },
	{ 0, 1, 0, 1, 116, 34, },
	{ 2, 1, 0, 1, 116, 32, },
	{ 1, 1, 0, 1, 116, 32, },
	{ 0, 1, 0, 1, 120, 36, },
	{ 2, 1, 0, 1, 120, 32, },
	{ 1, 1, 0, 1, 120, 32, },
	{ 0, 1, 0, 1, 124, 34, },
	{ 2, 1, 0, 1, 124, 32, },
	{ 1, 1, 0, 1, 124, 32, },
	{ 0, 1, 0, 1, 128, 32, },
	{ 2, 1, 0, 1, 128, 32, },
	{ 1, 1, 0, 1, 128, 32, },
	{ 0, 1, 0, 1, 132, 30, },
	{ 2, 1, 0, 1, 132, 32, },
	{ 1, 1, 0, 1, 132, 32, },
	{ 0, 1, 0, 1, 136, 30, },
	{ 2, 1, 0, 1, 136, 32, },
	{ 1, 1, 0, 1, 136, 32, },
	{ 0, 1, 0, 1, 140, 28, },
	{ 2, 1, 0, 1, 140, 32, },
	{ 1, 1, 0, 1, 140, 32, },
	{ 0, 1, 0, 1, 149, 36, },
	{ 2, 1, 0, 1, 149, 32, },
	{ 1, 1, 0, 1, 149, 63, },
	{ 0, 1, 0, 1, 153, 36, },
	{ 2, 1, 0, 1, 153, 32, },
	{ 1, 1, 0, 1, 153, 63, },
	{ 0, 1, 0, 1, 157, 36, },
	{ 2, 1, 0, 1, 157, 32, },
	{ 1, 1, 0, 1, 157, 63, },
	{ 0, 1, 0, 1, 161, 36, },
	{ 2, 1, 0, 1, 161, 32, },
	{ 1, 1, 0, 1, 161, 63, },
	{ 0, 1, 0, 1, 165, 36, },
	{ 2, 1, 0, 1, 165, 32, },
	{ 1, 1, 0, 1, 165, 63, },
	{ 0, 1, 0, 2, 36, 30, },
	{ 2, 1, 0, 2, 36, 32, },
	{ 1, 1, 0, 2, 36, 32, },
	{ 0, 1, 0, 2, 40, 30, },
	{ 2, 1, 0, 2, 40, 32, },
	{ 1, 1, 0, 2, 40, 32, },
	{ 0, 1, 0, 2, 44, 30, },
	{ 2, 1, 0, 2, 44, 32, },
	{ 1, 1, 0, 2, 44, 32, },
	{ 0, 1, 0, 2, 48, 30, },
	{ 2, 1, 0, 2, 48, 32, },
	{ 1, 1, 0, 2, 48, 32, },
	{ 0, 1, 0, 2, 52, 36, },
	{ 2, 1, 0, 2, 52, 32, },
	{ 1, 1, 0, 2, 52, 32, },
	{ 0, 1, 0, 2, 56, 34, },
	{ 2, 1, 0, 2, 56, 32, },
	{ 1, 1, 0, 2, 56, 32, },
	{ 0, 1, 0, 2, 60, 32, },
	{ 2, 1, 0, 2, 60, 32, },
	{ 1, 1, 0, 2, 60, 32, },
	{ 0, 1, 0, 2, 64, 28, },
	{ 2, 1, 0, 2, 64, 32, },
	{ 1, 1, 0, 2, 64, 32, },
	{ 0, 1, 0, 2, 100, 30, },
	{ 2, 1, 0, 2, 100, 32, },
	{ 1, 1, 0, 2, 100, 32, },
	{ 0, 1, 0, 2, 104, 30, },
	{ 2, 1, 0, 2, 104, 32, },
	{ 1, 1, 0, 2, 104, 32, },
	{ 0, 1, 0, 2, 108, 32, },
	{ 2, 1, 0, 2, 108, 32, },
	{ 1, 1, 0, 2, 108, 32, },
	{ 0, 1, 0, 2, 112, 34, },
	{ 2, 1, 0, 2, 112, 32, },
	{ 1, 1, 0, 2, 112, 32, },
	{ 0, 1, 0, 2, 116, 34, },
	{ 2, 1, 0, 2, 116, 32, },
	{ 1, 1, 0, 2, 116, 32, },
	{ 0, 1, 0, 2, 120, 36, },
	{ 2, 1, 0, 2, 120, 32, },
	{ 1, 1, 0, 2, 120, 32, },
	{ 0, 1, 0, 2, 124, 34, },
	{ 2, 1, 0, 2, 124, 32, },
	{ 1, 1, 0, 2, 124, 32, },
	{ 0, 1, 0, 2, 128, 32, },
	{ 2, 1, 0, 2, 128, 32, },
	{ 1, 1, 0, 2, 128, 32, },
	{ 0, 1, 0, 2, 132, 30, },
	{ 2, 1, 0, 2, 132, 32, },
	{ 1, 1, 0, 2, 132, 32, },
	{ 0, 1, 0, 2, 136, 30, },
	{ 2, 1, 0, 2, 136, 32, },
	{ 1, 1, 0, 2, 136, 32, },
	{ 0, 1, 0, 2, 140, 28, },
	{ 2, 1, 0, 2, 140, 32, },
	{ 1, 1, 0, 2, 140, 32, },
	{ 0, 1, 0, 2, 149, 36, },
	{ 2, 1, 0, 2, 149, 32, },
	{ 1, 1, 0, 2, 149, 63, },
	{ 0, 1, 0, 2, 153, 36, },
	{ 2, 1, 0, 2, 153, 32, },
	{ 1, 1, 0, 2, 153, 63, },
	{ 0, 1, 0, 2, 157, 36, },
	{ 2, 1, 0, 2, 157, 32, },
	{ 1, 1, 0, 2, 157, 63, },
	{ 0, 1, 0, 2, 161, 36, },
	{ 2, 1, 0, 2, 161, 32, },
	{ 1, 1, 0, 2, 161, 63, },
	{ 0, 1, 0, 2, 165, 36, },
	{ 2, 1, 0, 2, 165, 32, },
	{ 1, 1, 0, 2, 165, 63, },
	{ 0, 1, 0, 3, 36, 28, },
	{ 2, 1, 0, 3, 36, 30, },
	{ 1, 1, 0, 3, 36, 30, },
	{ 0, 1, 0, 3, 40, 28, },
	{ 2, 1, 0, 3, 40, 30, },
	{ 1, 1, 0, 3, 40, 30, },
	{ 0, 1, 0, 3, 44, 28, },
	{ 2, 1, 0, 3, 44, 30, },
	{ 1, 1, 0, 3, 44, 30, },
	{ 0, 1, 0, 3, 48, 28, },
	{ 2, 1, 0, 3, 48, 30, },
	{ 1, 1, 0, 3, 48, 30, },
	{ 0, 1, 0, 3, 52, 34, },
	{ 2, 1, 0, 3, 52, 30, },
	{ 1, 1, 0, 3, 52, 30, },
	{ 0, 1, 0, 3, 56, 32, },
	{ 2, 1, 0, 3, 56, 30, },
	{ 1, 1, 0, 3, 56, 30, },
	{ 0, 1, 0, 3, 60, 30, },
	{ 2, 1, 0, 3, 60, 30, },
	{ 1, 1, 0, 3, 60, 30, },
	{ 0, 1, 0, 3, 64, 26, },
	{ 2, 1, 0, 3, 64, 30, },
	{ 1, 1, 0, 3, 64, 30, },
	{ 0, 1, 0, 3, 100, 28, },
	{ 2, 1, 0, 3, 100, 30, },
	{ 1, 1, 0, 3, 100, 30, },
	{ 0, 1, 0, 3, 104, 28, },
	{ 2, 1, 0, 3, 104, 30, },
	{ 1, 1, 0, 3, 104, 30, },
	{ 0, 1, 0, 3, 108, 30, },
	{ 2, 1, 0, 3, 108, 30, },
	{ 1, 1, 0, 3, 108, 30, },
	{ 0, 1, 0, 3, 112, 32, },
	{ 2, 1, 0, 3, 112, 30, },
	{ 1, 1, 0, 3, 112, 30, },
	{ 0, 1, 0, 3, 116, 32, },
	{ 2, 1, 0, 3, 116, 30, },
	{ 1, 1, 0, 3, 116, 30, },
	{ 0, 1, 0, 3, 120, 34, },
	{ 2, 1, 0, 3, 120, 30, },
	{ 1, 1, 0, 3, 120, 30, },
	{ 0, 1, 0, 3, 124, 32, },
	{ 2, 1, 0, 3, 124, 30, },
	{ 1, 1, 0, 3, 124, 30, },
	{ 0, 1, 0, 3, 128, 30, },
	{ 2, 1, 0, 3, 128, 30, },
	{ 1, 1, 0, 3, 128, 30, },
	{ 0, 1, 0, 3, 132, 28, },
	{ 2, 1, 0, 3, 132, 30, },
	{ 1, 1, 0, 3, 132, 30, },
	{ 0, 1, 0, 3, 136, 28, },
	{ 2, 1, 0, 3, 136, 30, },
	{ 1, 1, 0, 3, 136, 30, },
	{ 0, 1, 0, 3, 140, 26, },
	{ 2, 1, 0, 3, 140, 30, },
	{ 1, 1, 0, 3, 140, 30, },
	{ 0, 1, 0, 3, 149, 34, },
	{ 2, 1, 0, 3, 149, 30, },
	{ 1, 1, 0, 3, 149, 63, },
	{ 0, 1, 0, 3, 153, 34, },
	{ 2, 1, 0, 3, 153, 30, },
	{ 1, 1, 0, 3, 153, 63, },
	{ 0, 1, 0, 3, 157, 34, },
	{ 2, 1, 0, 3, 157, 30, },
	{ 1, 1, 0, 3, 157, 63, },
	{ 0, 1, 0, 3, 161, 34, },
	{ 2, 1, 0, 3, 161, 30, },
	{ 1, 1, 0, 3, 161, 63, },
	{ 0, 1, 0, 3, 165, 34, },
	{ 2, 1, 0, 3, 165, 30, },
	{ 1, 1, 0, 3, 165, 63, },
	{ 0, 1, 0, 6, 36, 26, },
	{ 2, 1, 0, 6, 36, 28, },
	{ 1, 1, 0, 6, 36, 28, },
	{ 0, 1, 0, 6, 40, 26, },
	{ 2, 1, 0, 6, 40, 28, },
	{ 1, 1, 0, 6, 40, 28, },
	{ 0, 1, 0, 6, 44, 26, },
	{ 2, 1, 0, 6, 44, 28, },
	{ 1, 1, 0, 6, 44, 28, },
	{ 0, 1, 0, 6, 48, 26, },
	{ 2, 1, 0, 6, 48, 28, },
	{ 1, 1, 0, 6, 48, 28, },
	{ 0, 1, 0, 6, 52, 32, },
	{ 2, 1, 0, 6, 52, 28, },
	{ 1, 1, 0, 6, 52, 28, },
	{ 0, 1, 0, 6, 56, 30, },
	{ 2, 1, 0, 6, 56, 28, },
	{ 1, 1, 0, 6, 56, 28, },
	{ 0, 1, 0, 6, 60, 28, },
	{ 2, 1, 0, 6, 60, 28, },
	{ 1, 1, 0, 6, 60, 28, },
	{ 0, 1, 0, 6, 64, 24, },
	{ 2, 1, 0, 6, 64, 28, },
	{ 1, 1, 0, 6, 64, 28, },
	{ 0, 1, 0, 6, 100, 26, },
	{ 2, 1, 0, 6, 100, 28, },
	{ 1, 1, 0, 6, 100, 28, },
	{ 0, 1, 0, 6, 104, 26, },
	{ 2, 1, 0, 6, 104, 28, },
	{ 1, 1, 0, 6, 104, 28, },
	{ 0, 1, 0, 6, 108, 28, },
	{ 2, 1, 0, 6, 108, 28, },
	{ 1, 1, 0, 6, 108, 28, },
	{ 0, 1, 0, 6, 112, 30, },
	{ 2, 1, 0, 6, 112, 28, },
	{ 1, 1, 0, 6, 112, 28, },
	{ 0, 1, 0, 6, 116, 30, },
	{ 2, 1, 0, 6, 116, 28, },
	{ 1, 1, 0, 6, 116, 28, },
	{ 0, 1, 0, 6, 120, 32, },
	{ 2, 1, 0, 6, 120, 28, },
	{ 1, 1, 0, 6, 120, 28, },
	{ 0, 1, 0, 6, 124, 30, },
	{ 2, 1, 0, 6, 124, 28, },
	{ 1, 1, 0, 6, 124, 28, },
	{ 0, 1, 0, 6, 128, 28, },
	{ 2, 1, 0, 6, 128, 28, },
	{ 1, 1, 0, 6, 128, 28, },
	{ 0, 1, 0, 6, 132, 26, },
	{ 2, 1, 0, 6, 132, 28, },
	{ 1, 1, 0, 6, 132, 28, },
	{ 0, 1, 0, 6, 136, 26, },
	{ 2, 1, 0, 6, 136, 28, },
	{ 1, 1, 0, 6, 136, 28, },
	{ 0, 1, 0, 6, 140, 24, },
	{ 2, 1, 0, 6, 140, 28, },
	{ 1, 1, 0, 6, 140, 28, },
	{ 0, 1, 0, 6, 149, 32, },
	{ 2, 1, 0, 6, 149, 28, },
	{ 1, 1, 0, 6, 149, 63, },
	{ 0, 1, 0, 6, 153, 32, },
	{ 2, 1, 0, 6, 153, 28, },
	{ 1, 1, 0, 6, 153, 63, },
	{ 0, 1, 0, 6, 157, 32, },
	{ 2, 1, 0, 6, 157, 28, },
	{ 1, 1, 0, 6, 157, 63, },
	{ 0, 1, 0, 6, 161, 32, },
	{ 2, 1, 0, 6, 161, 28, },
	{ 1, 1, 0, 6, 161, 63, },
	{ 0, 1, 0, 6, 165, 32, },
	{ 2, 1, 0, 6, 165, 28, },
	{ 1, 1, 0, 6, 165, 63, },
	{ 0, 1, 0, 7, 36, 24, },
	{ 2, 1, 0, 7, 36, 26, },
	{ 1, 1, 0, 7, 36, 26, },
	{ 0, 1, 0, 7, 40, 24, },
	{ 2, 1, 0, 7, 40, 26, },
	{ 1, 1, 0, 7, 40, 26, },
	{ 0, 1, 0, 7, 44, 24, },
	{ 2, 1, 0, 7, 44, 26, },
	{ 1, 1, 0, 7, 44, 26, },
	{ 0, 1, 0, 7, 48, 24, },
	{ 2, 1, 0, 7, 48, 26, },
	{ 1, 1, 0, 7, 48, 26, },
	{ 0, 1, 0, 7, 52, 30, },
	{ 2, 1, 0, 7, 52, 26, },
	{ 1, 1, 0, 7, 52, 26, },
	{ 0, 1, 0, 7, 56, 28, },
	{ 2, 1, 0, 7, 56, 26, },
	{ 1, 1, 0, 7, 56, 26, },
	{ 0, 1, 0, 7, 60, 26, },
	{ 2, 1, 0, 7, 60, 26, },
	{ 1, 1, 0, 7, 60, 26, },
	{ 0, 1, 0, 7, 64, 22, },
	{ 2, 1, 0, 7, 64, 26, },
	{ 1, 1, 0, 7, 64, 26, },
	{ 0, 1, 0, 7, 100, 24, },
	{ 2, 1, 0, 7, 100, 26, },
	{ 1, 1, 0, 7, 100, 26, },
	{ 0, 1, 0, 7, 104, 24, },
	{ 2, 1, 0, 7, 104, 26, },
	{ 1, 1, 0, 7, 104, 26, },
	{ 0, 1, 0, 7, 108, 26, },
	{ 2, 1, 0, 7, 108, 26, },
	{ 1, 1, 0, 7, 108, 26, },
	{ 0, 1, 0, 7, 112, 28, },
	{ 2, 1, 0, 7, 112, 26, },
	{ 1, 1, 0, 7, 112, 26, },
	{ 0, 1, 0, 7, 116, 28, },
	{ 2, 1, 0, 7, 116, 26, },
	{ 1, 1, 0, 7, 116, 26, },
	{ 0, 1, 0, 7, 120, 30, },
	{ 2, 1, 0, 7, 120, 26, },
	{ 1, 1, 0, 7, 120, 26, },
	{ 0, 1, 0, 7, 124, 28, },
	{ 2, 1, 0, 7, 124, 26, },
	{ 1, 1, 0, 7, 124, 26, },
	{ 0, 1, 0, 7, 128, 26, },
	{ 2, 1, 0, 7, 128, 26, },
	{ 1, 1, 0, 7, 128, 26, },
	{ 0, 1, 0, 7, 132, 24, },
	{ 2, 1, 0, 7, 132, 26, },
	{ 1, 1, 0, 7, 132, 26, },
	{ 0, 1, 0, 7, 136, 24, },
	{ 2, 1, 0, 7, 136, 26, },
	{ 1, 1, 0, 7, 136, 26, },
	{ 0, 1, 0, 7, 140, 22, },
	{ 2, 1, 0, 7, 140, 26, },
	{ 1, 1, 0, 7, 140, 26, },
	{ 0, 1, 0, 7, 149, 30, },
	{ 2, 1, 0, 7, 149, 26, },
	{ 1, 1, 0, 7, 149, 63, },
	{ 0, 1, 0, 7, 153, 30, },
	{ 2, 1, 0, 7, 153, 26, },
	{ 1, 1, 0, 7, 153, 63, },
	{ 0, 1, 0, 7, 157, 30, },
	{ 2, 1, 0, 7, 157, 26, },
	{ 1, 1, 0, 7, 157, 63, },
	{ 0, 1, 0, 7, 161, 30, },
	{ 2, 1, 0, 7, 161, 26, },
	{ 1, 1, 0, 7, 161, 63, },
	{ 0, 1, 0, 7, 165, 30, },
	{ 2, 1, 0, 7, 165, 26, },
	{ 1, 1, 0, 7, 165, 63, },
	{ 0, 1, 1, 2, 38, 30, },
	{ 2, 1, 1, 2, 38, 32, },
	{ 1, 1, 1, 2, 38, 32, },
	{ 0, 1, 1, 2, 46, 30, },
	{ 2, 1, 1, 2, 46, 32, },
	{ 1, 1, 1, 2, 46, 32, },
	{ 0, 1, 1, 2, 54, 32, },
	{ 2, 1, 1, 2, 54, 32, },
	{ 1, 1, 1, 2, 54, 32, },
	{ 0, 1, 1, 2, 62, 32, },
	{ 2, 1, 1, 2, 62, 32, },
	{ 1, 1, 1, 2, 62, 32, },
	{ 0, 1, 1, 2, 102, 28, },
	{ 2, 1, 1, 2, 102, 32, },
	{ 1, 1, 1, 2, 102, 32, },
	{ 0, 1, 1, 2, 110, 32, },
	{ 2, 1, 1, 2, 110, 32, },
	{ 1, 1, 1, 2, 110, 32, },
	{ 0, 1, 1, 2, 118, 36, },
	{ 2, 1, 1, 2, 118, 32, },
	{ 1, 1, 1, 2, 118, 32, },
	{ 0, 1, 1, 2, 126, 34, },
	{ 2, 1, 1, 2, 126, 32, },
	{ 1, 1, 1, 2, 126, 32, },
	{ 0, 1, 1, 2, 134, 32, },
	{ 2, 1, 1, 2, 134, 32, },
	{ 1, 1, 1, 2, 134, 32, },
	{ 0, 1, 1, 2, 151, 36, },
	{ 2, 1, 1, 2, 151, 32, },
	{ 1, 1, 1, 2, 151, 63, },
	{ 0, 1, 1, 2, 159, 36, },
	{ 2, 1, 1, 2, 159, 32, },
	{ 1, 1, 1, 2, 159, 63, },
	{ 0, 1, 1, 3, 38, 28, },
	{ 2, 1, 1, 3, 38, 30, },
	{ 1, 1, 1, 3, 38, 30, },
	{ 0, 1, 1, 3, 46, 28, },
	{ 2, 1, 1, 3, 46, 30, },
	{ 1, 1, 1, 3, 46, 30, },
	{ 0, 1, 1, 3, 54, 30, },
	{ 2, 1, 1, 3, 54, 30, },
	{ 1, 1, 1, 3, 54, 30, },
	{ 0, 1, 1, 3, 62, 30, },
	{ 2, 1, 1, 3, 62, 30, },
	{ 1, 1, 1, 3, 62, 30, },
	{ 0, 1, 1, 3, 102, 26, },
	{ 2, 1, 1, 3, 102, 30, },
	{ 1, 1, 1, 3, 102, 30, },
	{ 0, 1, 1, 3, 110, 30, },
	{ 2, 1, 1, 3, 110, 30, },
	{ 1, 1, 1, 3, 110, 30, },
	{ 0, 1, 1, 3, 118, 34, },
	{ 2, 1, 1, 3, 118, 30, },
	{ 1, 1, 1, 3, 118, 30, },
	{ 0, 1, 1, 3, 126, 32, },
	{ 2, 1, 1, 3, 126, 30, },
	{ 1, 1, 1, 3, 126, 30, },
	{ 0, 1, 1, 3, 134, 30, },
	{ 2, 1, 1, 3, 134, 30, },
	{ 1, 1, 1, 3, 134, 30, },
	{ 0, 1, 1, 3, 151, 34, },
	{ 2, 1, 1, 3, 151, 30, },
	{ 1, 1, 1, 3, 151, 63, },
	{ 0, 1, 1, 3, 159, 34, },
	{ 2, 1, 1, 3, 159, 30, },
	{ 1, 1, 1, 3, 159, 63, },
	{ 0, 1, 1, 6, 38, 26, },
	{ 2, 1, 1, 6, 38, 28, },
	{ 1, 1, 1, 6, 38, 28, },
	{ 0, 1, 1, 6, 46, 26, },
	{ 2, 1, 1, 6, 46, 28, },
	{ 1, 1, 1, 6, 46, 28, },
	{ 0, 1, 1, 6, 54, 28, },
	{ 2, 1, 1, 6, 54, 28, },
	{ 1, 1, 1, 6, 54, 28, },
	{ 0, 1, 1, 6, 62, 28, },
	{ 2, 1, 1, 6, 62, 28, },
	{ 1, 1, 1, 6, 62, 28, },
	{ 0, 1, 1, 6, 102, 24, },
	{ 2, 1, 1, 6, 102, 28, },
	{ 1, 1, 1, 6, 102, 28, },
	{ 0, 1, 1, 6, 110, 28, },
	{ 2, 1, 1, 6, 110, 28, },
	{ 1, 1, 1, 6, 110, 28, },
	{ 0, 1, 1, 6, 118, 32, },
	{ 2, 1, 1, 6, 118, 28, },
	{ 1, 1, 1, 6, 118, 28, },
	{ 0, 1, 1, 6, 126, 30, },
	{ 2, 1, 1, 6, 126, 28, },
	{ 1, 1, 1, 6, 126, 28, },
	{ 0, 1, 1, 6, 134, 28, },
	{ 2, 1, 1, 6, 134, 28, },
	{ 1, 1, 1, 6, 134, 28, },
	{ 0, 1, 1, 6, 151, 32, },
	{ 2, 1, 1, 6, 151, 28, },
	{ 1, 1, 1, 6, 151, 63, },
	{ 0, 1, 1, 6, 159, 32, },
	{ 2, 1, 1, 6, 159, 28, },
	{ 1, 1, 1, 6, 159, 63, },
	{ 0, 1, 1, 7, 38, 24, },
	{ 2, 1, 1, 7, 38, 26, },
	{ 1, 1, 1, 7, 38, 26, },
	{ 0, 1, 1, 7, 46, 24, },
	{ 2, 1, 1, 7, 46, 26, },
	{ 1, 1, 1, 7, 46, 26, },
	{ 0, 1, 1, 7, 54, 26, },
	{ 2, 1, 1, 7, 54, 26, },
	{ 1, 1, 1, 7, 54, 26, },
	{ 0, 1, 1, 7, 62, 26, },
	{ 2, 1, 1, 7, 62, 26, },
	{ 1, 1, 1, 7, 62, 26, },
	{ 0, 1, 1, 7, 102, 22, },
	{ 2, 1, 1, 7, 102, 26, },
	{ 1, 1, 1, 7, 102, 26, },
	{ 0, 1, 1, 7, 110, 26, },
	{ 2, 1, 1, 7, 110, 26, },
	{ 1, 1, 1, 7, 110, 26, },
	{ 0, 1, 1, 7, 118, 30, },
	{ 2, 1, 1, 7, 118, 26, },
	{ 1, 1, 1, 7, 118, 26, },
	{ 0, 1, 1, 7, 126, 28, },
	{ 2, 1, 1, 7, 126, 26, },
	{ 1, 1, 1, 7, 126, 26, },
	{ 0, 1, 1, 7, 134, 26, },
	{ 2, 1, 1, 7, 134, 26, },
	{ 1, 1, 1, 7, 134, 26, },
	{ 0, 1, 1, 7, 151, 30, },
	{ 2, 1, 1, 7, 151, 26, },
	{ 1, 1, 1, 7, 151, 63, },
	{ 0, 1, 1, 7, 159, 30, },
	{ 2, 1, 1, 7, 159, 26, },
	{ 1, 1, 1, 7, 159, 63, },
	{ 0, 1, 2, 4, 42, 30, },
	{ 2, 1, 2, 4, 42, 32, },
	{ 1, 1, 2, 4, 42, 32, },
	{ 0, 1, 2, 4, 58, 28, },
	{ 2, 1, 2, 4, 58, 32, },
	{ 1, 1, 2, 4, 58, 32, },
	{ 0, 1, 2, 4, 106, 30, },
	{ 2, 1, 2, 4, 106, 32, },
	{ 1, 1, 2, 4, 106, 32, },
	{ 0, 1, 2, 4, 122, 34, },
	{ 2, 1, 2, 4, 122, 32, },
	{ 1, 1, 2, 4, 122, 32, },
	{ 0, 1, 2, 4, 155, 36, },
	{ 2, 1, 2, 4, 155, 32, },
	{ 1, 1, 2, 4, 155, 63, },
	{ 0, 1, 2, 5, 42, 28, },
	{ 2, 1, 2, 5, 42, 30, },
	{ 1, 1, 2, 5, 42, 30, },
	{ 0, 1, 2, 5, 58, 26, },
	{ 2, 1, 2, 5, 58, 30, },
	{ 1, 1, 2, 5, 58, 30, },
	{ 0, 1, 2, 5, 106, 28, },
	{ 2, 1, 2, 5, 106, 30, },
	{ 1, 1, 2, 5, 106, 30, },
	{ 0, 1, 2, 5, 122, 32, },
	{ 2, 1, 2, 5, 122, 30, },
	{ 1, 1, 2, 5, 122, 30, },
	{ 0, 1, 2, 5, 155, 34, },
	{ 2, 1, 2, 5, 155, 30, },
	{ 1, 1, 2, 5, 155, 63, },
	{ 0, 1, 2, 8, 42, 26, },
	{ 2, 1, 2, 8, 42, 28, },
	{ 1, 1, 2, 8, 42, 28, },
	{ 0, 1, 2, 8, 58, 24, },
	{ 2, 1, 2, 8, 58, 28, },
	{ 1, 1, 2, 8, 58, 28, },
	{ 0, 1, 2, 8, 106, 26, },
	{ 2, 1, 2, 8, 106, 28, },
	{ 1, 1, 2, 8, 106, 28, },
	{ 0, 1, 2, 8, 122, 30, },
	{ 2, 1, 2, 8, 122, 28, },
	{ 1, 1, 2, 8, 122, 28, },
	{ 0, 1, 2, 8, 155, 32, },
	{ 2, 1, 2, 8, 155, 28, },
	{ 1, 1, 2, 8, 155, 63, },
	{ 0, 1, 2, 9, 42, 24, },
	{ 2, 1, 2, 9, 42, 26, },
	{ 1, 1, 2, 9, 42, 26, },
	{ 0, 1, 2, 9, 58, 22, },
	{ 2, 1, 2, 9, 58, 26, },
	{ 1, 1, 2, 9, 58, 26, },
	{ 0, 1, 2, 9, 106, 24, },
	{ 2, 1, 2, 9, 106, 26, },
	{ 1, 1, 2, 9, 106, 26, },
	{ 0, 1, 2, 9, 122, 28, },
	{ 2, 1, 2, 9, 122, 26, },
	{ 1, 1, 2, 9, 122, 26, },
	{ 0, 1, 2, 9, 155, 30, },
	{ 2, 1, 2, 9, 155, 26, },
	{ 1, 1, 2, 9, 155, 63, },
};

RTW_DECL_TABLE_TXPWR_LMT(rtw8814a_txpwr_lmt);

static const struct rtw_txpwr_lmt_cfg_pair rtw8814a_txpwr_lmt_type0[] = {
	{ 0, 0, 0, 0, 1, 32, },
	{ 2, 0, 0, 0, 1, 32, },
	{ 1, 0, 0, 0, 1, 32, },
	{ 0, 0, 0, 0, 2, 32, },
	{ 2, 0, 0, 0, 2, 32, },
	{ 1, 0, 0, 0, 2, 32, },
	{ 0, 0, 0, 0, 3, 32, },
	{ 2, 0, 0, 0, 3, 32, },
	{ 1, 0, 0, 0, 3, 32, },
	{ 0, 0, 0, 0, 4, 32, },
	{ 2, 0, 0, 0, 4, 32, },
	{ 1, 0, 0, 0, 4, 32, },
	{ 0, 0, 0, 0, 5, 32, },
	{ 2, 0, 0, 0, 5, 32, },
	{ 1, 0, 0, 0, 5, 32, },
	{ 0, 0, 0, 0, 6, 32, },
	{ 2, 0, 0, 0, 6, 32, },
	{ 1, 0, 0, 0, 6, 32, },
	{ 0, 0, 0, 0, 7, 32, },
	{ 2, 0, 0, 0, 7, 32, },
	{ 1, 0, 0, 0, 7, 32, },
	{ 0, 0, 0, 0, 8, 32, },
	{ 2, 0, 0, 0, 8, 32, },
	{ 1, 0, 0, 0, 8, 32, },
	{ 0, 0, 0, 0, 9, 32, },
	{ 2, 0, 0, 0, 9, 32, },
	{ 1, 0, 0, 0, 9, 32, },
	{ 0, 0, 0, 0, 10, 32, },
	{ 2, 0, 0, 0, 10, 32, },
	{ 1, 0, 0, 0, 10, 32, },
	{ 0, 0, 0, 0, 11, 32, },
	{ 2, 0, 0, 0, 11, 32, },
	{ 1, 0, 0, 0, 11, 32, },
	{ 0, 0, 0, 0, 12, 24, },
	{ 2, 0, 0, 0, 12, 32, },
	{ 1, 0, 0, 0, 12, 32, },
	{ 0, 0, 0, 0, 13, 16, },
	{ 2, 0, 0, 0, 13, 32, },
	{ 1, 0, 0, 0, 13, 32, },
	{ 0, 0, 0, 0, 14, 63, },
	{ 2, 0, 0, 0, 14, 63, },
	{ 1, 0, 0, 0, 14, 32, },
	{ 0, 0, 0, 1, 1, 28, },
	{ 2, 0, 0, 1, 1, 32, },
	{ 1, 0, 0, 1, 1, 32, },
	{ 0, 0, 0, 1, 2, 32, },
	{ 2, 0, 0, 1, 2, 32, },
	{ 1, 0, 0, 1, 2, 32, },
	{ 0, 0, 0, 1, 3, 32, },
	{ 2, 0, 0, 1, 3, 32, },
	{ 1, 0, 0, 1, 3, 32, },
	{ 0, 0, 0, 1, 4, 32, },
	{ 2, 0, 0, 1, 4, 32, },
	{ 1, 0, 0, 1, 4, 32, },
	{ 0, 0, 0, 1, 5, 32, },
	{ 2, 0, 0, 1, 5, 32, },
	{ 1, 0, 0, 1, 5, 32, },
	{ 0, 0, 0, 1, 6, 32, },
	{ 2, 0, 0, 1, 6, 32, },
	{ 1, 0, 0, 1, 6, 32, },
	{ 0, 0, 0, 1, 7, 32, },
	{ 2, 0, 0, 1, 7, 32, },
	{ 1, 0, 0, 1, 7, 32, },
	{ 0, 0, 0, 1, 8, 32, },
	{ 2, 0, 0, 1, 8, 32, },
	{ 1, 0, 0, 1, 8, 32, },
	{ 0, 0, 0, 1, 9, 32, },
	{ 2, 0, 0, 1, 9, 32, },
	{ 1, 0, 0, 1, 9, 32, },
	{ 0, 0, 0, 1, 10, 32, },
	{ 2, 0, 0, 1, 10, 32, },
	{ 1, 0, 0, 1, 10, 32, },
	{ 0, 0, 0, 1, 11, 28, },
	{ 2, 0, 0, 1, 11, 32, },
	{ 1, 0, 0, 1, 11, 32, },
	{ 0, 0, 0, 1, 12, 18, },
	{ 2, 0, 0, 1, 12, 32, },
	{ 1, 0, 0, 1, 12, 32, },
	{ 0, 0, 0, 1, 13, 8, },
	{ 2, 0, 0, 1, 13, 32, },
	{ 1, 0, 0, 1, 13, 32, },
	{ 0, 0, 0, 1, 14, 63, },
	{ 2, 0, 0, 1, 14, 63, },
	{ 1, 0, 0, 1, 14, 63, },
	{ 0, 0, 0, 2, 1, 26, },
	{ 2, 0, 0, 2, 1, 32, },
	{ 1, 0, 0, 2, 1, 32, },
	{ 0, 0, 0, 2, 2, 32, },
	{ 2, 0, 0, 2, 2, 32, },
	{ 1, 0, 0, 2, 2, 32, },
	{ 0, 0, 0, 2, 3, 32, },
	{ 2, 0, 0, 2, 3, 32, },
	{ 1, 0, 0, 2, 3, 32, },
	{ 0, 0, 0, 2, 4, 32, },
	{ 2, 0, 0, 2, 4, 32, },
	{ 1, 0, 0, 2, 4, 32, },
	{ 0, 0, 0, 2, 5, 32, },
	{ 2, 0, 0, 2, 5, 32, },
	{ 1, 0, 0, 2, 5, 32, },
	{ 0, 0, 0, 2, 6, 32, },
	{ 2, 0, 0, 2, 6, 32, },
	{ 1, 0, 0, 2, 6, 32, },
	{ 0, 0, 0, 2, 7, 32, },
	{ 2, 0, 0, 2, 7, 32, },
	{ 1, 0, 0, 2, 7, 32, },
	{ 0, 0, 0, 2, 8, 32, },
	{ 2, 0, 0, 2, 8, 32, },
	{ 1, 0, 0, 2, 8, 32, },
	{ 0, 0, 0, 2, 9, 32, },
	{ 2, 0, 0, 2, 9, 32, },
	{ 1, 0, 0, 2, 9, 32, },
	{ 0, 0, 0, 2, 10, 32, },
	{ 2, 0, 0, 2, 10, 32, },
	{ 1, 0, 0, 2, 10, 32, },
	{ 0, 0, 0, 2, 11, 26, },
	{ 2, 0, 0, 2, 11, 32, },
	{ 1, 0, 0, 2, 11, 32, },
	{ 0, 0, 0, 2, 12, 16, },
	{ 2, 0, 0, 2, 12, 32, },
	{ 1, 0, 0, 2, 12, 32, },
	{ 0, 0, 0, 2, 13, 6, },
	{ 2, 0, 0, 2, 13, 32, },
	{ 1, 0, 0, 2, 13, 32, },
	{ 0, 0, 0, 2, 14, 63, },
	{ 2, 0, 0, 2, 14, 63, },
	{ 1, 0, 0, 2, 14, 63, },
	{ 0, 0, 0, 3, 1, 24, },
	{ 2, 0, 0, 3, 1, 30, },
	{ 1, 0, 0, 3, 1, 30, },
	{ 0, 0, 0, 3, 2, 30, },
	{ 2, 0, 0, 3, 2, 30, },
	{ 1, 0, 0, 3, 2, 30, },
	{ 0, 0, 0, 3, 3, 30, },
	{ 2, 0, 0, 3, 3, 30, },
	{ 1, 0, 0, 3, 3, 30, },
	{ 0, 0, 0, 3, 4, 30, },
	{ 2, 0, 0, 3, 4, 30, },
	{ 1, 0, 0, 3, 4, 30, },
	{ 0, 0, 0, 3, 5, 30, },
	{ 2, 0, 0, 3, 5, 30, },
	{ 1, 0, 0, 3, 5, 30, },
	{ 0, 0, 0, 3, 6, 30, },
	{ 2, 0, 0, 3, 6, 30, },
	{ 1, 0, 0, 3, 6, 30, },
	{ 0, 0, 0, 3, 7, 30, },
	{ 2, 0, 0, 3, 7, 30, },
	{ 1, 0, 0, 3, 7, 30, },
	{ 0, 0, 0, 3, 8, 30, },
	{ 2, 0, 0, 3, 8, 30, },
	{ 1, 0, 0, 3, 8, 30, },
	{ 0, 0, 0, 3, 9, 30, },
	{ 2, 0, 0, 3, 9, 30, },
	{ 1, 0, 0, 3, 9, 30, },
	{ 0, 0, 0, 3, 10, 30, },
	{ 2, 0, 0, 3, 10, 30, },
	{ 1, 0, 0, 3, 10, 30, },
	{ 0, 0, 0, 3, 11, 24, },
	{ 2, 0, 0, 3, 11, 30, },
	{ 1, 0, 0, 3, 11, 30, },
	{ 0, 0, 0, 3, 12, 14, },
	{ 2, 0, 0, 3, 12, 30, },
	{ 1, 0, 0, 3, 12, 30, },
	{ 0, 0, 0, 3, 13, 4, },
	{ 2, 0, 0, 3, 13, 30, },
	{ 1, 0, 0, 3, 13, 30, },
	{ 0, 0, 0, 3, 14, 63, },
	{ 2, 0, 0, 3, 14, 63, },
	{ 1, 0, 0, 3, 14, 63, },
	{ 0, 0, 0, 6, 1, 22, },
	{ 2, 0, 0, 6, 1, 28, },
	{ 1, 0, 0, 6, 1, 28, },
	{ 0, 0, 0, 6, 2, 28, },
	{ 2, 0, 0, 6, 2, 28, },
	{ 1, 0, 0, 6, 2, 28, },
	{ 0, 0, 0, 6, 3, 28, },
	{ 2, 0, 0, 6, 3, 28, },
	{ 1, 0, 0, 6, 3, 28, },
	{ 0, 0, 0, 6, 4, 28, },
	{ 2, 0, 0, 6, 4, 28, },
	{ 1, 0, 0, 6, 4, 28, },
	{ 0, 0, 0, 6, 5, 28, },
	{ 2, 0, 0, 6, 5, 28, },
	{ 1, 0, 0, 6, 5, 28, },
	{ 0, 0, 0, 6, 6, 28, },
	{ 2, 0, 0, 6, 6, 28, },
	{ 1, 0, 0, 6, 6, 28, },
	{ 0, 0, 0, 6, 7, 28, },
	{ 2, 0, 0, 6, 7, 28, },
	{ 1, 0, 0, 6, 7, 28, },
	{ 0, 0, 0, 6, 8, 28, },
	{ 2, 0, 0, 6, 8, 28, },
	{ 1, 0, 0, 6, 8, 28, },
	{ 0, 0, 0, 6, 9, 28, },
	{ 2, 0, 0, 6, 9, 28, },
	{ 1, 0, 0, 6, 9, 28, },
	{ 0, 0, 0, 6, 10, 28, },
	{ 2, 0, 0, 6, 10, 28, },
	{ 1, 0, 0, 6, 10, 28, },
	{ 0, 0, 0, 6, 11, 22, },
	{ 2, 0, 0, 6, 11, 28, },
	{ 1, 0, 0, 6, 11, 28, },
	{ 0, 0, 0, 6, 12, 14, },
	{ 2, 0, 0, 6, 12, 28, },
	{ 1, 0, 0, 6, 12, 28, },
	{ 0, 0, 0, 6, 13, 4, },
	{ 2, 0, 0, 6, 13, 28, },
	{ 1, 0, 0, 6, 13, 28, },
	{ 0, 0, 0, 6, 14, 63, },
	{ 2, 0, 0, 6, 14, 63, },
	{ 1, 0, 0, 6, 14, 63, },
	{ 0, 0, 0, 7, 1, 20, },
	{ 2, 0, 0, 7, 1, 26, },
	{ 1, 0, 0, 7, 1, 26, },
	{ 0, 0, 0, 7, 2, 26, },
	{ 2, 0, 0, 7, 2, 26, },
	{ 1, 0, 0, 7, 2, 26, },
	{ 0, 0, 0, 7, 3, 26, },
	{ 2, 0, 0, 7, 3, 26, },
	{ 1, 0, 0, 7, 3, 26, },
	{ 0, 0, 0, 7, 4, 26, },
	{ 2, 0, 0, 7, 4, 26, },
	{ 1, 0, 0, 7, 4, 26, },
	{ 0, 0, 0, 7, 5, 26, },
	{ 2, 0, 0, 7, 5, 26, },
	{ 1, 0, 0, 7, 5, 26, },
	{ 0, 0, 0, 7, 6, 26, },
	{ 2, 0, 0, 7, 6, 26, },
	{ 1, 0, 0, 7, 6, 26, },
	{ 0, 0, 0, 7, 7, 26, },
	{ 2, 0, 0, 7, 7, 26, },
	{ 1, 0, 0, 7, 7, 26, },
	{ 0, 0, 0, 7, 8, 26, },
	{ 2, 0, 0, 7, 8, 26, },
	{ 1, 0, 0, 7, 8, 26, },
	{ 0, 0, 0, 7, 9, 26, },
	{ 2, 0, 0, 7, 9, 26, },
	{ 1, 0, 0, 7, 9, 26, },
	{ 0, 0, 0, 7, 10, 26, },
	{ 2, 0, 0, 7, 10, 26, },
	{ 1, 0, 0, 7, 10, 26, },
	{ 0, 0, 0, 7, 11, 20, },
	{ 2, 0, 0, 7, 11, 26, },
	{ 1, 0, 0, 7, 11, 26, },
	{ 0, 0, 0, 7, 12, 14, },
	{ 2, 0, 0, 7, 12, 26, },
	{ 1, 0, 0, 7, 12, 26, },
	{ 0, 0, 0, 7, 13, 4, },
	{ 2, 0, 0, 7, 13, 26, },
	{ 1, 0, 0, 7, 13, 26, },
	{ 0, 0, 0, 7, 14, 63, },
	{ 2, 0, 0, 7, 14, 63, },
	{ 1, 0, 0, 7, 14, 63, },
	{ 0, 0, 1, 2, 1, 63, },
	{ 2, 0, 1, 2, 1, 63, },
	{ 1, 0, 1, 2, 1, 63, },
	{ 0, 0, 1, 2, 2, 63, },
	{ 2, 0, 1, 2, 2, 63, },
	{ 1, 0, 1, 2, 2, 63, },
	{ 0, 0, 1, 2, 3, 26, },
	{ 2, 0, 1, 2, 3, 32, },
	{ 1, 0, 1, 2, 3, 32, },
	{ 0, 0, 1, 2, 4, 32, },
	{ 2, 0, 1, 2, 4, 32, },
	{ 1, 0, 1, 2, 4, 32, },
	{ 0, 0, 1, 2, 5, 32, },
	{ 2, 0, 1, 2, 5, 32, },
	{ 1, 0, 1, 2, 5, 32, },
	{ 0, 0, 1, 2, 6, 32, },
	{ 2, 0, 1, 2, 6, 32, },
	{ 1, 0, 1, 2, 6, 32, },
	{ 0, 0, 1, 2, 7, 32, },
	{ 2, 0, 1, 2, 7, 32, },
	{ 1, 0, 1, 2, 7, 32, },
	{ 0, 0, 1, 2, 8, 32, },
	{ 2, 0, 1, 2, 8, 32, },
	{ 1, 0, 1, 2, 8, 32, },
	{ 0, 0, 1, 2, 9, 32, },
	{ 2, 0, 1, 2, 9, 32, },
	{ 1, 0, 1, 2, 9, 32, },
	{ 0, 0, 1, 2, 10, 32, },
	{ 2, 0, 1, 2, 10, 32, },
	{ 1, 0, 1, 2, 10, 32, },
	{ 0, 0, 1, 2, 11, 26, },
	{ 2, 0, 1, 2, 11, 32, },
	{ 1, 0, 1, 2, 11, 32, },
	{ 0, 0, 1, 2, 12, 16, },
	{ 2, 0, 1, 2, 12, 32, },
	{ 1, 0, 1, 2, 12, 32, },
	{ 0, 0, 1, 2, 13, 10, },
	{ 2, 0, 1, 2, 13, 32, },
	{ 1, 0, 1, 2, 13, 32, },
	{ 0, 0, 1, 2, 14, 63, },
	{ 2, 0, 1, 2, 14, 63, },
	{ 1, 0, 1, 2, 14, 63, },
	{ 0, 0, 1, 3, 1, 63, },
	{ 2, 0, 1, 3, 1, 63, },
	{ 1, 0, 1, 3, 1, 63, },
	{ 0, 0, 1, 3, 2, 63, },
	{ 2, 0, 1, 3, 2, 63, },
	{ 1, 0, 1, 3, 2, 63, },
	{ 0, 0, 1, 3, 3, 24, },
	{ 2, 0, 1, 3, 3, 30, },
	{ 1, 0, 1, 3, 3, 30, },
	{ 0, 0, 1, 3, 4, 30, },
	{ 2, 0, 1, 3, 4, 30, },
	{ 1, 0, 1, 3, 4, 30, },
	{ 0, 0, 1, 3, 5, 30, },
	{ 2, 0, 1, 3, 5, 30, },
	{ 1, 0, 1, 3, 5, 30, },
	{ 0, 0, 1, 3, 6, 30, },
	{ 2, 0, 1, 3, 6, 30, },
	{ 1, 0, 1, 3, 6, 30, },
	{ 0, 0, 1, 3, 7, 30, },
	{ 2, 0, 1, 3, 7, 30, },
	{ 1, 0, 1, 3, 7, 30, },
	{ 0, 0, 1, 3, 8, 30, },
	{ 2, 0, 1, 3, 8, 30, },
	{ 1, 0, 1, 3, 8, 30, },
	{ 0, 0, 1, 3, 9, 30, },
	{ 2, 0, 1, 3, 9, 30, },
	{ 1, 0, 1, 3, 9, 30, },
	{ 0, 0, 1, 3, 10, 30, },
	{ 2, 0, 1, 3, 10, 30, },
	{ 1, 0, 1, 3, 10, 30, },
	{ 0, 0, 1, 3, 11, 24, },
	{ 2, 0, 1, 3, 11, 30, },
	{ 1, 0, 1, 3, 11, 30, },
	{ 0, 0, 1, 3, 12, 14, },
	{ 2, 0, 1, 3, 12, 30, },
	{ 1, 0, 1, 3, 12, 30, },
	{ 0, 0, 1, 3, 13, 8, },
	{ 2, 0, 1, 3, 13, 30, },
	{ 1, 0, 1, 3, 13, 30, },
	{ 0, 0, 1, 3, 14, 63, },
	{ 2, 0, 1, 3, 14, 63, },
	{ 1, 0, 1, 3, 14, 63, },
	{ 0, 0, 1, 6, 1, 63, },
	{ 2, 0, 1, 6, 1, 63, },
	{ 1, 0, 1, 6, 1, 63, },
	{ 0, 0, 1, 6, 2, 63, },
	{ 2, 0, 1, 6, 2, 63, },
	{ 1, 0, 1, 6, 2, 63, },
	{ 0, 0, 1, 6, 3, 22, },
	{ 2, 0, 1, 6, 3, 28, },
	{ 1, 0, 1, 6, 3, 28, },
	{ 0, 0, 1, 6, 4, 28, },
	{ 2, 0, 1, 6, 4, 28, },
	{ 1, 0, 1, 6, 4, 28, },
	{ 0, 0, 1, 6, 5, 28, },
	{ 2, 0, 1, 6, 5, 28, },
	{ 1, 0, 1, 6, 5, 28, },
	{ 0, 0, 1, 6, 6, 28, },
	{ 2, 0, 1, 6, 6, 28, },
	{ 1, 0, 1, 6, 6, 28, },
	{ 0, 0, 1, 6, 7, 28, },
	{ 2, 0, 1, 6, 7, 28, },
	{ 1, 0, 1, 6, 7, 28, },
	{ 0, 0, 1, 6, 8, 28, },
	{ 2, 0, 1, 6, 8, 28, },
	{ 1, 0, 1, 6, 8, 28, },
	{ 0, 0, 1, 6, 9, 28, },
	{ 2, 0, 1, 6, 9, 28, },
	{ 1, 0, 1, 6, 9, 28, },
	{ 0, 0, 1, 6, 10, 28, },
	{ 2, 0, 1, 6, 10, 28, },
	{ 1, 0, 1, 6, 10, 28, },
	{ 0, 0, 1, 6, 11, 22, },
	{ 2, 0, 1, 6, 11, 28, },
	{ 1, 0, 1, 6, 11, 28, },
	{ 0, 0, 1, 6, 12, 14, },
	{ 2, 0, 1, 6, 12, 28, },
	{ 1, 0, 1, 6, 12, 28, },
	{ 0, 0, 1, 6, 13, 8, },
	{ 2, 0, 1, 6, 13, 28, },
	{ 1, 0, 1, 6, 13, 28, },
	{ 0, 0, 1, 6, 14, 63, },
	{ 2, 0, 1, 6, 14, 63, },
	{ 1, 0, 1, 6, 14, 63, },
	{ 0, 0, 1, 7, 1, 63, },
	{ 2, 0, 1, 7, 1, 63, },
	{ 1, 0, 1, 7, 1, 63, },
	{ 0, 0, 1, 7, 2, 63, },
	{ 2, 0, 1, 7, 2, 63, },
	{ 1, 0, 1, 7, 2, 63, },
	{ 0, 0, 1, 7, 3, 20, },
	{ 2, 0, 1, 7, 3, 26, },
	{ 1, 0, 1, 7, 3, 26, },
	{ 0, 0, 1, 7, 4, 26, },
	{ 2, 0, 1, 7, 4, 26, },
	{ 1, 0, 1, 7, 4, 26, },
	{ 0, 0, 1, 7, 5, 26, },
	{ 2, 0, 1, 7, 5, 26, },
	{ 1, 0, 1, 7, 5, 26, },
	{ 0, 0, 1, 7, 6, 26, },
	{ 2, 0, 1, 7, 6, 26, },
	{ 1, 0, 1, 7, 6, 26, },
	{ 0, 0, 1, 7, 7, 26, },
	{ 2, 0, 1, 7, 7, 26, },
	{ 1, 0, 1, 7, 7, 26, },
	{ 0, 0, 1, 7, 8, 26, },
	{ 2, 0, 1, 7, 8, 26, },
	{ 1, 0, 1, 7, 8, 26, },
	{ 0, 0, 1, 7, 9, 26, },
	{ 2, 0, 1, 7, 9, 26, },
	{ 1, 0, 1, 7, 9, 26, },
	{ 0, 0, 1, 7, 10, 26, },
	{ 2, 0, 1, 7, 10, 26, },
	{ 1, 0, 1, 7, 10, 26, },
	{ 0, 0, 1, 7, 11, 20, },
	{ 2, 0, 1, 7, 11, 26, },
	{ 1, 0, 1, 7, 11, 26, },
	{ 0, 0, 1, 7, 12, 14, },
	{ 2, 0, 1, 7, 12, 26, },
	{ 1, 0, 1, 7, 12, 26, },
	{ 0, 0, 1, 7, 13, 8, },
	{ 2, 0, 1, 7, 13, 26, },
	{ 1, 0, 1, 7, 13, 26, },
	{ 0, 0, 1, 7, 14, 63, },
	{ 2, 0, 1, 7, 14, 63, },
	{ 1, 0, 1, 7, 14, 63, },
	{ 0, 1, 0, 1, 36, 28, },
	{ 2, 1, 0, 1, 36, 32, },
	{ 1, 1, 0, 1, 36, 32, },
	{ 0, 1, 0, 1, 40, 32, },
	{ 2, 1, 0, 1, 40, 32, },
	{ 1, 1, 0, 1, 40, 32, },
	{ 0, 1, 0, 1, 44, 32, },
	{ 2, 1, 0, 1, 44, 32, },
	{ 1, 1, 0, 1, 44, 32, },
	{ 0, 1, 0, 1, 48, 32, },
	{ 2, 1, 0, 1, 48, 32, },
	{ 1, 1, 0, 1, 48, 32, },
	{ 0, 1, 0, 1, 52, 32, },
	{ 2, 1, 0, 1, 52, 32, },
	{ 1, 1, 0, 1, 52, 32, },
	{ 0, 1, 0, 1, 56, 32, },
	{ 2, 1, 0, 1, 56, 32, },
	{ 1, 1, 0, 1, 56, 32, },
	{ 0, 1, 0, 1, 60, 32, },
	{ 2, 1, 0, 1, 60, 32, },
	{ 1, 1, 0, 1, 60, 32, },
	{ 0, 1, 0, 1, 64, 28, },
	{ 2, 1, 0, 1, 64, 32, },
	{ 1, 1, 0, 1, 64, 32, },
	{ 0, 1, 0, 1, 100, 28, },
	{ 2, 1, 0, 1, 100, 32, },
	{ 1, 1, 0, 1, 100, 32, },
	{ 0, 1, 0, 1, 104, 32, },
	{ 2, 1, 0, 1, 104, 32, },
	{ 1, 1, 0, 1, 104, 32, },
	{ 0, 1, 0, 1, 108, 32, },
	{ 2, 1, 0, 1, 108, 32, },
	{ 1, 1, 0, 1, 108, 32, },
	{ 0, 1, 0, 1, 112, 32, },
	{ 2, 1, 0, 1, 112, 32, },
	{ 1, 1, 0, 1, 112, 32, },
	{ 0, 1, 0, 1, 116, 32, },
	{ 2, 1, 0, 1, 116, 32, },
	{ 1, 1, 0, 1, 116, 32, },
	{ 0, 1, 0, 1, 120, 32, },
	{ 2, 1, 0, 1, 120, 32, },
	{ 1, 1, 0, 1, 120, 32, },
	{ 0, 1, 0, 1, 124, 32, },
	{ 2, 1, 0, 1, 124, 32, },
	{ 1, 1, 0, 1, 124, 32, },
	{ 0, 1, 0, 1, 128, 32, },
	{ 2, 1, 0, 1, 128, 32, },
	{ 1, 1, 0, 1, 128, 32, },
	{ 0, 1, 0, 1, 132, 32, },
	{ 2, 1, 0, 1, 132, 32, },
	{ 1, 1, 0, 1, 132, 32, },
	{ 0, 1, 0, 1, 136, 32, },
	{ 2, 1, 0, 1, 136, 32, },
	{ 1, 1, 0, 1, 136, 32, },
	{ 0, 1, 0, 1, 140, 28, },
	{ 2, 1, 0, 1, 140, 32, },
	{ 1, 1, 0, 1, 140, 32, },
	{ 0, 1, 0, 1, 149, 28, },
	{ 2, 1, 0, 1, 149, 32, },
	{ 1, 1, 0, 1, 149, 63, },
	{ 0, 1, 0, 1, 153, 32, },
	{ 2, 1, 0, 1, 153, 32, },
	{ 1, 1, 0, 1, 153, 63, },
	{ 0, 1, 0, 1, 157, 32, },
	{ 2, 1, 0, 1, 157, 32, },
	{ 1, 1, 0, 1, 157, 63, },
	{ 0, 1, 0, 1, 161, 32, },
	{ 2, 1, 0, 1, 161, 32, },
	{ 1, 1, 0, 1, 161, 63, },
	{ 0, 1, 0, 1, 165, 32, },
	{ 2, 1, 0, 1, 165, 32, },
	{ 1, 1, 0, 1, 165, 63, },
	{ 0, 1, 0, 2, 36, 26, },
	{ 2, 1, 0, 2, 36, 32, },
	{ 1, 1, 0, 2, 36, 32, },
	{ 0, 1, 0, 2, 40, 32, },
	{ 2, 1, 0, 2, 40, 32, },
	{ 1, 1, 0, 2, 40, 32, },
	{ 0, 1, 0, 2, 44, 32, },
	{ 2, 1, 0, 2, 44, 32, },
	{ 1, 1, 0, 2, 44, 32, },
	{ 0, 1, 0, 2, 48, 32, },
	{ 2, 1, 0, 2, 48, 32, },
	{ 1, 1, 0, 2, 48, 32, },
	{ 0, 1, 0, 2, 52, 32, },
	{ 2, 1, 0, 2, 52, 32, },
	{ 1, 1, 0, 2, 52, 32, },
	{ 0, 1, 0, 2, 56, 32, },
	{ 2, 1, 0, 2, 56, 32, },
	{ 1, 1, 0, 2, 56, 32, },
	{ 0, 1, 0, 2, 60, 32, },
	{ 2, 1, 0, 2, 60, 32, },
	{ 1, 1, 0, 2, 60, 32, },
	{ 0, 1, 0, 2, 64, 26, },
	{ 2, 1, 0, 2, 64, 32, },
	{ 1, 1, 0, 2, 64, 32, },
	{ 0, 1, 0, 2, 100, 26, },
	{ 2, 1, 0, 2, 100, 32, },
	{ 1, 1, 0, 2, 100, 32, },
	{ 0, 1, 0, 2, 104, 32, },
	{ 2, 1, 0, 2, 104, 32, },
	{ 1, 1, 0, 2, 104, 32, },
	{ 0, 1, 0, 2, 108, 32, },
	{ 2, 1, 0, 2, 108, 32, },
	{ 1, 1, 0, 2, 108, 32, },
	{ 0, 1, 0, 2, 112, 32, },
	{ 2, 1, 0, 2, 112, 32, },
	{ 1, 1, 0, 2, 112, 32, },
	{ 0, 1, 0, 2, 116, 32, },
	{ 2, 1, 0, 2, 116, 32, },
	{ 1, 1, 0, 2, 116, 32, },
	{ 0, 1, 0, 2, 120, 32, },
	{ 2, 1, 0, 2, 120, 32, },
	{ 1, 1, 0, 2, 120, 32, },
	{ 0, 1, 0, 2, 124, 32, },
	{ 2, 1, 0, 2, 124, 32, },
	{ 1, 1, 0, 2, 124, 32, },
	{ 0, 1, 0, 2, 128, 32, },
	{ 2, 1, 0, 2, 128, 32, },
	{ 1, 1, 0, 2, 128, 32, },
	{ 0, 1, 0, 2, 132, 32, },
	{ 2, 1, 0, 2, 132, 32, },
	{ 1, 1, 0, 2, 132, 32, },
	{ 0, 1, 0, 2, 136, 32, },
	{ 2, 1, 0, 2, 136, 32, },
	{ 1, 1, 0, 2, 136, 32, },
	{ 0, 1, 0, 2, 140, 26, },
	{ 2, 1, 0, 2, 140, 32, },
	{ 1, 1, 0, 2, 140, 32, },
	{ 0, 1, 0, 2, 149, 26, },
	{ 2, 1, 0, 2, 149, 32, },
	{ 1, 1, 0, 2, 149, 63, },
	{ 0, 1, 0, 2, 153, 32, },
	{ 2, 1, 0, 2, 153, 32, },
	{ 1, 1, 0, 2, 153, 63, },
	{ 0, 1, 0, 2, 157, 32, },
	{ 2, 1, 0, 2, 157, 32, },
	{ 1, 1, 0, 2, 157, 63, },
	{ 0, 1, 0, 2, 161, 32, },
	{ 2, 1, 0, 2, 161, 32, },
	{ 1, 1, 0, 2, 161, 63, },
	{ 0, 1, 0, 2, 165, 32, },
	{ 2, 1, 0, 2, 165, 32, },
	{ 1, 1, 0, 2, 165, 63, },
	{ 0, 1, 0, 3, 36, 24, },
	{ 2, 1, 0, 3, 36, 28, },
	{ 1, 1, 0, 3, 36, 28, },
	{ 0, 1, 0, 3, 40, 28, },
	{ 2, 1, 0, 3, 40, 28, },
	{ 1, 1, 0, 3, 40, 28, },
	{ 0, 1, 0, 3, 44, 28, },
	{ 2, 1, 0, 3, 44, 28, },
	{ 1, 1, 0, 3, 44, 28, },
	{ 0, 1, 0, 3, 48, 28, },
	{ 2, 1, 0, 3, 48, 28, },
	{ 1, 1, 0, 3, 48, 28, },
	{ 0, 1, 0, 3, 52, 28, },
	{ 2, 1, 0, 3, 52, 28, },
	{ 1, 1, 0, 3, 52, 28, },
	{ 0, 1, 0, 3, 56, 28, },
	{ 2, 1, 0, 3, 56, 28, },
	{ 1, 1, 0, 3, 56, 28, },
	{ 0, 1, 0, 3, 60, 28, },
	{ 2, 1, 0, 3, 60, 28, },
	{ 1, 1, 0, 3, 60, 28, },
	{ 0, 1, 0, 3, 64, 24, },
	{ 2, 1, 0, 3, 64, 28, },
	{ 1, 1, 0, 3, 64, 28, },
	{ 0, 1, 0, 3, 100, 24, },
	{ 2, 1, 0, 3, 100, 28, },
	{ 1, 1, 0, 3, 100, 28, },
	{ 0, 1, 0, 3, 104, 28, },
	{ 2, 1, 0, 3, 104, 28, },
	{ 1, 1, 0, 3, 104, 28, },
	{ 0, 1, 0, 3, 108, 28, },
	{ 2, 1, 0, 3, 108, 28, },
	{ 1, 1, 0, 3, 108, 28, },
	{ 0, 1, 0, 3, 112, 28, },
	{ 2, 1, 0, 3, 112, 28, },
	{ 1, 1, 0, 3, 112, 28, },
	{ 0, 1, 0, 3, 116, 28, },
	{ 2, 1, 0, 3, 116, 28, },
	{ 1, 1, 0, 3, 116, 28, },
	{ 0, 1, 0, 3, 120, 28, },
	{ 2, 1, 0, 3, 120, 28, },
	{ 1, 1, 0, 3, 120, 28, },
	{ 0, 1, 0, 3, 124, 28, },
	{ 2, 1, 0, 3, 124, 28, },
	{ 1, 1, 0, 3, 124, 28, },
	{ 0, 1, 0, 3, 128, 28, },
	{ 2, 1, 0, 3, 128, 28, },
	{ 1, 1, 0, 3, 128, 28, },
	{ 0, 1, 0, 3, 132, 28, },
	{ 2, 1, 0, 3, 132, 28, },
	{ 1, 1, 0, 3, 132, 28, },
	{ 0, 1, 0, 3, 136, 28, },
	{ 2, 1, 0, 3, 136, 28, },
	{ 1, 1, 0, 3, 136, 28, },
	{ 0, 1, 0, 3, 140, 24, },
	{ 2, 1, 0, 3, 140, 28, },
	{ 1, 1, 0, 3, 140, 28, },
	{ 0, 1, 0, 3, 149, 24, },
	{ 2, 1, 0, 3, 149, 28, },
	{ 1, 1, 0, 3, 149, 63, },
	{ 0, 1, 0, 3, 153, 28, },
	{ 2, 1, 0, 3, 153, 28, },
	{ 1, 1, 0, 3, 153, 63, },
	{ 0, 1, 0, 3, 157, 28, },
	{ 2, 1, 0, 3, 157, 28, },
	{ 1, 1, 0, 3, 157, 63, },
	{ 0, 1, 0, 3, 161, 28, },
	{ 2, 1, 0, 3, 161, 28, },
	{ 1, 1, 0, 3, 161, 63, },
	{ 0, 1, 0, 3, 165, 28, },
	{ 2, 1, 0, 3, 165, 28, },
	{ 1, 1, 0, 3, 165, 63, },
	{ 0, 1, 0, 6, 36, 22, },
	{ 2, 1, 0, 6, 36, 26, },
	{ 1, 1, 0, 6, 36, 26, },
	{ 0, 1, 0, 6, 40, 26, },
	{ 2, 1, 0, 6, 40, 26, },
	{ 1, 1, 0, 6, 40, 26, },
	{ 0, 1, 0, 6, 44, 26, },
	{ 2, 1, 0, 6, 44, 26, },
	{ 1, 1, 0, 6, 44, 26, },
	{ 0, 1, 0, 6, 48, 26, },
	{ 2, 1, 0, 6, 48, 26, },
	{ 1, 1, 0, 6, 48, 26, },
	{ 0, 1, 0, 6, 52, 26, },
	{ 2, 1, 0, 6, 52, 26, },
	{ 1, 1, 0, 6, 52, 26, },
	{ 0, 1, 0, 6, 56, 26, },
	{ 2, 1, 0, 6, 56, 26, },
	{ 1, 1, 0, 6, 56, 26, },
	{ 0, 1, 0, 6, 60, 26, },
	{ 2, 1, 0, 6, 60, 26, },
	{ 1, 1, 0, 6, 60, 26, },
	{ 0, 1, 0, 6, 64, 22, },
	{ 2, 1, 0, 6, 64, 26, },
	{ 1, 1, 0, 6, 64, 26, },
	{ 0, 1, 0, 6, 100, 22, },
	{ 2, 1, 0, 6, 100, 26, },
	{ 1, 1, 0, 6, 100, 26, },
	{ 0, 1, 0, 6, 104, 26, },
	{ 2, 1, 0, 6, 104, 26, },
	{ 1, 1, 0, 6, 104, 26, },
	{ 0, 1, 0, 6, 108, 26, },
	{ 2, 1, 0, 6, 108, 26, },
	{ 1, 1, 0, 6, 108, 26, },
	{ 0, 1, 0, 6, 112, 26, },
	{ 2, 1, 0, 6, 112, 26, },
	{ 1, 1, 0, 6, 112, 26, },
	{ 0, 1, 0, 6, 116, 26, },
	{ 2, 1, 0, 6, 116, 26, },
	{ 1, 1, 0, 6, 116, 26, },
	{ 0, 1, 0, 6, 120, 26, },
	{ 2, 1, 0, 6, 120, 26, },
	{ 1, 1, 0, 6, 120, 26, },
	{ 0, 1, 0, 6, 124, 26, },
	{ 2, 1, 0, 6, 124, 26, },
	{ 1, 1, 0, 6, 124, 26, },
	{ 0, 1, 0, 6, 128, 26, },
	{ 2, 1, 0, 6, 128, 26, },
	{ 1, 1, 0, 6, 128, 26, },
	{ 0, 1, 0, 6, 132, 26, },
	{ 2, 1, 0, 6, 132, 26, },
	{ 1, 1, 0, 6, 132, 26, },
	{ 0, 1, 0, 6, 136, 26, },
	{ 2, 1, 0, 6, 136, 26, },
	{ 1, 1, 0, 6, 136, 26, },
	{ 0, 1, 0, 6, 140, 22, },
	{ 2, 1, 0, 6, 140, 26, },
	{ 1, 1, 0, 6, 140, 26, },
	{ 0, 1, 0, 6, 149, 22, },
	{ 2, 1, 0, 6, 149, 26, },
	{ 1, 1, 0, 6, 149, 63, },
	{ 0, 1, 0, 6, 153, 26, },
	{ 2, 1, 0, 6, 153, 26, },
	{ 1, 1, 0, 6, 153, 63, },
	{ 0, 1, 0, 6, 157, 26, },
	{ 2, 1, 0, 6, 157, 26, },
	{ 1, 1, 0, 6, 157, 63, },
	{ 0, 1, 0, 6, 161, 26, },
	{ 2, 1, 0, 6, 161, 26, },
	{ 1, 1, 0, 6, 161, 63, },
	{ 0, 1, 0, 6, 165, 26, },
	{ 2, 1, 0, 6, 165, 26, },
	{ 1, 1, 0, 6, 165, 63, },
	{ 0, 1, 0, 7, 36, 20, },
	{ 2, 1, 0, 7, 36, 24, },
	{ 1, 1, 0, 7, 36, 24, },
	{ 0, 1, 0, 7, 40, 24, },
	{ 2, 1, 0, 7, 40, 24, },
	{ 1, 1, 0, 7, 40, 24, },
	{ 0, 1, 0, 7, 44, 24, },
	{ 2, 1, 0, 7, 44, 24, },
	{ 1, 1, 0, 7, 44, 24, },
	{ 0, 1, 0, 7, 48, 24, },
	{ 2, 1, 0, 7, 48, 24, },
	{ 1, 1, 0, 7, 48, 24, },
	{ 0, 1, 0, 7, 52, 24, },
	{ 2, 1, 0, 7, 52, 24, },
	{ 1, 1, 0, 7, 52, 24, },
	{ 0, 1, 0, 7, 56, 24, },
	{ 2, 1, 0, 7, 56, 24, },
	{ 1, 1, 0, 7, 56, 24, },
	{ 0, 1, 0, 7, 60, 24, },
	{ 2, 1, 0, 7, 60, 24, },
	{ 1, 1, 0, 7, 60, 24, },
	{ 0, 1, 0, 7, 64, 20, },
	{ 2, 1, 0, 7, 64, 24, },
	{ 1, 1, 0, 7, 64, 24, },
	{ 0, 1, 0, 7, 100, 20, },
	{ 2, 1, 0, 7, 100, 24, },
	{ 1, 1, 0, 7, 100, 24, },
	{ 0, 1, 0, 7, 104, 24, },
	{ 2, 1, 0, 7, 104, 24, },
	{ 1, 1, 0, 7, 104, 24, },
	{ 0, 1, 0, 7, 108, 24, },
	{ 2, 1, 0, 7, 108, 24, },
	{ 1, 1, 0, 7, 108, 24, },
	{ 0, 1, 0, 7, 112, 24, },
	{ 2, 1, 0, 7, 112, 24, },
	{ 1, 1, 0, 7, 112, 24, },
	{ 0, 1, 0, 7, 116, 24, },
	{ 2, 1, 0, 7, 116, 24, },
	{ 1, 1, 0, 7, 116, 24, },
	{ 0, 1, 0, 7, 120, 24, },
	{ 2, 1, 0, 7, 120, 24, },
	{ 1, 1, 0, 7, 120, 24, },
	{ 0, 1, 0, 7, 124, 24, },
	{ 2, 1, 0, 7, 124, 24, },
	{ 1, 1, 0, 7, 124, 24, },
	{ 0, 1, 0, 7, 128, 24, },
	{ 2, 1, 0, 7, 128, 24, },
	{ 1, 1, 0, 7, 128, 24, },
	{ 0, 1, 0, 7, 132, 24, },
	{ 2, 1, 0, 7, 132, 24, },
	{ 1, 1, 0, 7, 132, 24, },
	{ 0, 1, 0, 7, 136, 24, },
	{ 2, 1, 0, 7, 136, 24, },
	{ 1, 1, 0, 7, 136, 24, },
	{ 0, 1, 0, 7, 140, 20, },
	{ 2, 1, 0, 7, 140, 24, },
	{ 1, 1, 0, 7, 140, 24, },
	{ 0, 1, 0, 7, 149, 20, },
	{ 2, 1, 0, 7, 149, 24, },
	{ 1, 1, 0, 7, 149, 63, },
	{ 0, 1, 0, 7, 153, 24, },
	{ 2, 1, 0, 7, 153, 24, },
	{ 1, 1, 0, 7, 153, 63, },
	{ 0, 1, 0, 7, 157, 24, },
	{ 2, 1, 0, 7, 157, 24, },
	{ 1, 1, 0, 7, 157, 63, },
	{ 0, 1, 0, 7, 161, 24, },
	{ 2, 1, 0, 7, 161, 24, },
	{ 1, 1, 0, 7, 161, 63, },
	{ 0, 1, 0, 7, 165, 24, },
	{ 2, 1, 0, 7, 165, 24, },
	{ 1, 1, 0, 7, 165, 63, },
	{ 0, 1, 1, 2, 38, 26, },
	{ 2, 1, 1, 2, 38, 32, },
	{ 1, 1, 1, 2, 38, 32, },
	{ 0, 1, 1, 2, 46, 32, },
	{ 2, 1, 1, 2, 46, 32, },
	{ 1, 1, 1, 2, 46, 32, },
	{ 0, 1, 1, 2, 54, 32, },
	{ 2, 1, 1, 2, 54, 32, },
	{ 1, 1, 1, 2, 54, 32, },
	{ 0, 1, 1, 2, 62, 26, },
	{ 2, 1, 1, 2, 62, 32, },
	{ 1, 1, 1, 2, 62, 32, },
	{ 0, 1, 1, 2, 102, 26, },
	{ 2, 1, 1, 2, 102, 32, },
	{ 1, 1, 1, 2, 102, 32, },
	{ 0, 1, 1, 2, 110, 32, },
	{ 2, 1, 1, 2, 110, 32, },
	{ 1, 1, 1, 2, 110, 32, },
	{ 0, 1, 1, 2, 118, 32, },
	{ 2, 1, 1, 2, 118, 32, },
	{ 1, 1, 1, 2, 118, 32, },
	{ 0, 1, 1, 2, 126, 32, },
	{ 2, 1, 1, 2, 126, 32, },
	{ 1, 1, 1, 2, 126, 32, },
	{ 0, 1, 1, 2, 134, 32, },
	{ 2, 1, 1, 2, 134, 32, },
	{ 1, 1, 1, 2, 134, 32, },
	{ 0, 1, 1, 2, 151, 26, },
	{ 2, 1, 1, 2, 151, 32, },
	{ 1, 1, 1, 2, 151, 63, },
	{ 0, 1, 1, 2, 159, 32, },
	{ 2, 1, 1, 2, 159, 32, },
	{ 1, 1, 1, 2, 159, 63, },
	{ 0, 1, 1, 3, 38, 24, },
	{ 2, 1, 1, 3, 38, 28, },
	{ 1, 1, 1, 3, 38, 28, },
	{ 0, 1, 1, 3, 46, 28, },
	{ 2, 1, 1, 3, 46, 28, },
	{ 1, 1, 1, 3, 46, 28, },
	{ 0, 1, 1, 3, 54, 28, },
	{ 2, 1, 1, 3, 54, 28, },
	{ 1, 1, 1, 3, 54, 28, },
	{ 0, 1, 1, 3, 62, 24, },
	{ 2, 1, 1, 3, 62, 28, },
	{ 1, 1, 1, 3, 62, 28, },
	{ 0, 1, 1, 3, 102, 24, },
	{ 2, 1, 1, 3, 102, 28, },
	{ 1, 1, 1, 3, 102, 28, },
	{ 0, 1, 1, 3, 110, 28, },
	{ 2, 1, 1, 3, 110, 28, },
	{ 1, 1, 1, 3, 110, 28, },
	{ 0, 1, 1, 3, 118, 28, },
	{ 2, 1, 1, 3, 118, 28, },
	{ 1, 1, 1, 3, 118, 28, },
	{ 0, 1, 1, 3, 126, 28, },
	{ 2, 1, 1, 3, 126, 28, },
	{ 1, 1, 1, 3, 126, 28, },
	{ 0, 1, 1, 3, 134, 28, },
	{ 2, 1, 1, 3, 134, 28, },
	{ 1, 1, 1, 3, 134, 28, },
	{ 0, 1, 1, 3, 151, 24, },
	{ 2, 1, 1, 3, 151, 28, },
	{ 1, 1, 1, 3, 151, 63, },
	{ 0, 1, 1, 3, 159, 28, },
	{ 2, 1, 1, 3, 159, 28, },
	{ 1, 1, 1, 3, 159, 63, },
	{ 0, 1, 1, 6, 38, 20, },
	{ 2, 1, 1, 6, 38, 26, },
	{ 1, 1, 1, 6, 38, 26, },
	{ 0, 1, 1, 6, 46, 26, },
	{ 2, 1, 1, 6, 46, 26, },
	{ 1, 1, 1, 6, 46, 26, },
	{ 0, 1, 1, 6, 54, 26, },
	{ 2, 1, 1, 6, 54, 26, },
	{ 1, 1, 1, 6, 54, 26, },
	{ 0, 1, 1, 6, 62, 20, },
	{ 2, 1, 1, 6, 62, 26, },
	{ 1, 1, 1, 6, 62, 26, },
	{ 0, 1, 1, 6, 102, 20, },
	{ 2, 1, 1, 6, 102, 26, },
	{ 1, 1, 1, 6, 102, 26, },
	{ 0, 1, 1, 6, 110, 26, },
	{ 2, 1, 1, 6, 110, 26, },
	{ 1, 1, 1, 6, 110, 26, },
	{ 0, 1, 1, 6, 118, 26, },
	{ 2, 1, 1, 6, 118, 26, },
	{ 1, 1, 1, 6, 118, 26, },
	{ 0, 1, 1, 6, 126, 26, },
	{ 2, 1, 1, 6, 126, 26, },
	{ 1, 1, 1, 6, 126, 26, },
	{ 0, 1, 1, 6, 134, 26, },
	{ 2, 1, 1, 6, 134, 26, },
	{ 1, 1, 1, 6, 134, 26, },
	{ 0, 1, 1, 6, 151, 20, },
	{ 2, 1, 1, 6, 151, 26, },
	{ 1, 1, 1, 6, 151, 63, },
	{ 0, 1, 1, 6, 159, 26, },
	{ 2, 1, 1, 6, 159, 26, },
	{ 1, 1, 1, 6, 159, 63, },
	{ 0, 1, 1, 7, 38, 18, },
	{ 2, 1, 1, 7, 38, 24, },
	{ 1, 1, 1, 7, 38, 24, },
	{ 0, 1, 1, 7, 46, 24, },
	{ 2, 1, 1, 7, 46, 24, },
	{ 1, 1, 1, 7, 46, 24, },
	{ 0, 1, 1, 7, 54, 24, },
	{ 2, 1, 1, 7, 54, 24, },
	{ 1, 1, 1, 7, 54, 24, },
	{ 0, 1, 1, 7, 62, 18, },
	{ 2, 1, 1, 7, 62, 24, },
	{ 1, 1, 1, 7, 62, 24, },
	{ 0, 1, 1, 7, 102, 18, },
	{ 2, 1, 1, 7, 102, 24, },
	{ 1, 1, 1, 7, 102, 24, },
	{ 0, 1, 1, 7, 110, 24, },
	{ 2, 1, 1, 7, 110, 24, },
	{ 1, 1, 1, 7, 110, 24, },
	{ 0, 1, 1, 7, 118, 24, },
	{ 2, 1, 1, 7, 118, 24, },
	{ 1, 1, 1, 7, 118, 24, },
	{ 0, 1, 1, 7, 126, 24, },
	{ 2, 1, 1, 7, 126, 24, },
	{ 1, 1, 1, 7, 126, 24, },
	{ 0, 1, 1, 7, 134, 24, },
	{ 2, 1, 1, 7, 134, 24, },
	{ 1, 1, 1, 7, 134, 24, },
	{ 0, 1, 1, 7, 151, 18, },
	{ 2, 1, 1, 7, 151, 24, },
	{ 1, 1, 1, 7, 151, 63, },
	{ 0, 1, 1, 7, 159, 24, },
	{ 2, 1, 1, 7, 159, 24, },
	{ 1, 1, 1, 7, 159, 63, },
	{ 0, 1, 2, 4, 42, 22, },
	{ 2, 1, 2, 4, 42, 30, },
	{ 1, 1, 2, 4, 42, 30, },
	{ 0, 1, 2, 4, 58, 22, },
	{ 2, 1, 2, 4, 58, 30, },
	{ 1, 1, 2, 4, 58, 30, },
	{ 0, 1, 2, 4, 106, 22, },
	{ 2, 1, 2, 4, 106, 30, },
	{ 1, 1, 2, 4, 106, 30, },
	{ 0, 1, 2, 4, 122, 30, },
	{ 2, 1, 2, 4, 122, 30, },
	{ 1, 1, 2, 4, 122, 30, },
	{ 0, 1, 2, 4, 155, 22, },
	{ 2, 1, 2, 4, 155, 30, },
	{ 1, 1, 2, 4, 155, 63, },
	{ 0, 1, 2, 5, 42, 20, },
	{ 2, 1, 2, 5, 42, 28, },
	{ 1, 1, 2, 5, 42, 28, },
	{ 0, 1, 2, 5, 58, 20, },
	{ 2, 1, 2, 5, 58, 28, },
	{ 1, 1, 2, 5, 58, 28, },
	{ 0, 1, 2, 5, 106, 20, },
	{ 2, 1, 2, 5, 106, 28, },
	{ 1, 1, 2, 5, 106, 28, },
	{ 0, 1, 2, 5, 122, 28, },
	{ 2, 1, 2, 5, 122, 28, },
	{ 1, 1, 2, 5, 122, 28, },
	{ 0, 1, 2, 5, 155, 20, },
	{ 2, 1, 2, 5, 155, 28, },
	{ 1, 1, 2, 5, 155, 63, },
	{ 0, 1, 2, 8, 42, 18, },
	{ 2, 1, 2, 8, 42, 26, },
	{ 1, 1, 2, 8, 42, 26, },
	{ 0, 1, 2, 8, 58, 18, },
	{ 2, 1, 2, 8, 58, 26, },
	{ 1, 1, 2, 8, 58, 26, },
	{ 0, 1, 2, 8, 106, 18, },
	{ 2, 1, 2, 8, 106, 26, },
	{ 1, 1, 2, 8, 106, 26, },
	{ 0, 1, 2, 8, 122, 26, },
	{ 2, 1, 2, 8, 122, 26, },
	{ 1, 1, 2, 8, 122, 26, },
	{ 0, 1, 2, 8, 155, 18, },
	{ 2, 1, 2, 8, 155, 26, },
	{ 1, 1, 2, 8, 155, 63, },
	{ 0, 1, 2, 9, 42, 16, },
	{ 2, 1, 2, 9, 42, 24, },
	{ 1, 1, 2, 9, 42, 24, },
	{ 0, 1, 2, 9, 58, 16, },
	{ 2, 1, 2, 9, 58, 24, },
	{ 1, 1, 2, 9, 58, 24, },
	{ 0, 1, 2, 9, 106, 16, },
	{ 2, 1, 2, 9, 106, 24, },
	{ 1, 1, 2, 9, 106, 24, },
	{ 0, 1, 2, 9, 122, 24, },
	{ 2, 1, 2, 9, 122, 24, },
	{ 1, 1, 2, 9, 122, 24, },
	{ 0, 1, 2, 9, 155, 16, },
	{ 2, 1, 2, 9, 155, 24, },
	{ 1, 1, 2, 9, 155, 63, },
};

RTW_DECL_TABLE_TXPWR_LMT(rtw8814a_txpwr_lmt_type0);

static const struct rtw_txpwr_lmt_cfg_pair rtw8814a_txpwr_lmt_type1[] = {
		{ 0, 0, 0, 0, 1, 34, },
	{ 2, 0, 0, 0, 1, 32, },
	{ 1, 0, 0, 0, 1, 32, },
	{ 0, 0, 0, 0, 2, 34, },
	{ 2, 0, 0, 0, 2, 32, },
	{ 1, 0, 0, 0, 2, 32, },
	{ 0, 0, 0, 0, 3, 34, },
	{ 2, 0, 0, 0, 3, 32, },
	{ 1, 0, 0, 0, 3, 32, },
	{ 0, 0, 0, 0, 4, 34, },
	{ 2, 0, 0, 0, 4, 32, },
	{ 1, 0, 0, 0, 4, 32, },
	{ 0, 0, 0, 0, 5, 34, },
	{ 2, 0, 0, 0, 5, 32, },
	{ 1, 0, 0, 0, 5, 32, },
	{ 0, 0, 0, 0, 6, 34, },
	{ 2, 0, 0, 0, 6, 32, },
	{ 1, 0, 0, 0, 6, 32, },
	{ 0, 0, 0, 0, 7, 34, },
	{ 2, 0, 0, 0, 7, 32, },
	{ 1, 0, 0, 0, 7, 32, },
	{ 0, 0, 0, 0, 8, 34, },
	{ 2, 0, 0, 0, 8, 32, },
	{ 1, 0, 0, 0, 8, 32, },
	{ 0, 0, 0, 0, 9, 34, },
	{ 2, 0, 0, 0, 9, 32, },
	{ 1, 0, 0, 0, 9, 32, },
	{ 0, 0, 0, 0, 10, 34, },
	{ 2, 0, 0, 0, 10, 32, },
	{ 1, 0, 0, 0, 10, 32, },
	{ 0, 0, 0, 0, 11, 34, },
	{ 2, 0, 0, 0, 11, 32, },
	{ 1, 0, 0, 0, 11, 32, },
	{ 0, 0, 0, 0, 12, 24, },
	{ 2, 0, 0, 0, 12, 32, },
	{ 1, 0, 0, 0, 12, 32, },
	{ 0, 0, 0, 0, 13, 16, },
	{ 2, 0, 0, 0, 13, 32, },
	{ 1, 0, 0, 0, 13, 32, },
	{ 0, 0, 0, 0, 14, 63, },
	{ 2, 0, 0, 0, 14, 63, },
	{ 1, 0, 0, 0, 14, 32, },
	{ 0, 0, 0, 1, 1, 30, },
	{ 2, 0, 0, 1, 1, 32, },
	{ 1, 0, 0, 1, 1, 32, },
	{ 0, 0, 0, 1, 2, 32, },
	{ 2, 0, 0, 1, 2, 32, },
	{ 1, 0, 0, 1, 2, 32, },
	{ 0, 0, 0, 1, 3, 32, },
	{ 2, 0, 0, 1, 3, 32, },
	{ 1, 0, 0, 1, 3, 32, },
	{ 0, 0, 0, 1, 4, 32, },
	{ 2, 0, 0, 1, 4, 32, },
	{ 1, 0, 0, 1, 4, 32, },
	{ 0, 0, 0, 1, 5, 32, },
	{ 2, 0, 0, 1, 5, 32, },
	{ 1, 0, 0, 1, 5, 32, },
	{ 0, 0, 0, 1, 6, 32, },
	{ 2, 0, 0, 1, 6, 32, },
	{ 1, 0, 0, 1, 6, 32, },
	{ 0, 0, 0, 1, 7, 32, },
	{ 2, 0, 0, 1, 7, 32, },
	{ 1, 0, 0, 1, 7, 32, },
	{ 0, 0, 0, 1, 8, 32, },
	{ 2, 0, 0, 1, 8, 32, },
	{ 1, 0, 0, 1, 8, 32, },
	{ 0, 0, 0, 1, 9, 32, },
	{ 2, 0, 0, 1, 9, 32, },
	{ 1, 0, 0, 1, 9, 32, },
	{ 0, 0, 0, 1, 10, 32, },
	{ 2, 0, 0, 1, 10, 32, },
	{ 1, 0, 0, 1, 10, 32, },
	{ 0, 0, 0, 1, 11, 30, },
	{ 2, 0, 0, 1, 11, 32, },
	{ 1, 0, 0, 1, 11, 32, },
	{ 0, 0, 0, 1, 12, 18, },
	{ 2, 0, 0, 1, 12, 32, },
	{ 1, 0, 0, 1, 12, 32, },
	{ 0, 0, 0, 1, 13, 8, },
	{ 2, 0, 0, 1, 13, 32, },
	{ 1, 0, 0, 1, 13, 32, },
	{ 0, 0, 0, 1, 14, 63, },
	{ 2, 0, 0, 1, 14, 63, },
	{ 1, 0, 0, 1, 14, 63, },
	{ 0, 0, 0, 2, 1, 28, },
	{ 2, 0, 0, 2, 1, 32, },
	{ 1, 0, 0, 2, 1, 32, },
	{ 0, 0, 0, 2, 2, 32, },
	{ 2, 0, 0, 2, 2, 32, },
	{ 1, 0, 0, 2, 2, 32, },
	{ 0, 0, 0, 2, 3, 32, },
	{ 2, 0, 0, 2, 3, 32, },
	{ 1, 0, 0, 2, 3, 32, },
	{ 0, 0, 0, 2, 4, 32, },
	{ 2, 0, 0, 2, 4, 32, },
	{ 1, 0, 0, 2, 4, 32, },
	{ 0, 0, 0, 2, 5, 32, },
	{ 2, 0, 0, 2, 5, 32, },
	{ 1, 0, 0, 2, 5, 32, },
	{ 0, 0, 0, 2, 6, 32, },
	{ 2, 0, 0, 2, 6, 32, },
	{ 1, 0, 0, 2, 6, 32, },
	{ 0, 0, 0, 2, 7, 32, },
	{ 2, 0, 0, 2, 7, 32, },
	{ 1, 0, 0, 2, 7, 32, },
	{ 0, 0, 0, 2, 8, 32, },
	{ 2, 0, 0, 2, 8, 32, },
	{ 1, 0, 0, 2, 8, 32, },
	{ 0, 0, 0, 2, 9, 32, },
	{ 2, 0, 0, 2, 9, 32, },
	{ 1, 0, 0, 2, 9, 32, },
	{ 0, 0, 0, 2, 10, 32, },
	{ 2, 0, 0, 2, 10, 32, },
	{ 1, 0, 0, 2, 10, 32, },
	{ 0, 0, 0, 2, 11, 28, },
	{ 2, 0, 0, 2, 11, 32, },
	{ 1, 0, 0, 2, 11, 32, },
	{ 0, 0, 0, 2, 12, 16, },
	{ 2, 0, 0, 2, 12, 32, },
	{ 1, 0, 0, 2, 12, 32, },
	{ 0, 0, 0, 2, 13, 6, },
	{ 2, 0, 0, 2, 13, 32, },
	{ 1, 0, 0, 2, 13, 32, },
	{ 0, 0, 0, 2, 14, 63, },
	{ 2, 0, 0, 2, 14, 63, },
	{ 1, 0, 0, 2, 14, 63, },
	{ 0, 0, 0, 3, 1, 26, },
	{ 2, 0, 0, 3, 1, 30, },
	{ 1, 0, 0, 3, 1, 30, },
	{ 0, 0, 0, 3, 2, 30, },
	{ 2, 0, 0, 3, 2, 30, },
	{ 1, 0, 0, 3, 2, 30, },
	{ 0, 0, 0, 3, 3, 30, },
	{ 2, 0, 0, 3, 3, 30, },
	{ 1, 0, 0, 3, 3, 30, },
	{ 0, 0, 0, 3, 4, 30, },
	{ 2, 0, 0, 3, 4, 30, },
	{ 1, 0, 0, 3, 4, 30, },
	{ 0, 0, 0, 3, 5, 30, },
	{ 2, 0, 0, 3, 5, 30, },
	{ 1, 0, 0, 3, 5, 30, },
	{ 0, 0, 0, 3, 6, 30, },
	{ 2, 0, 0, 3, 6, 30, },
	{ 1, 0, 0, 3, 6, 30, },
	{ 0, 0, 0, 3, 7, 30, },
	{ 2, 0, 0, 3, 7, 30, },
	{ 1, 0, 0, 3, 7, 30, },
	{ 0, 0, 0, 3, 8, 30, },
	{ 2, 0, 0, 3, 8, 30, },
	{ 1, 0, 0, 3, 8, 30, },
	{ 0, 0, 0, 3, 9, 30, },
	{ 2, 0, 0, 3, 9, 30, },
	{ 1, 0, 0, 3, 9, 30, },
	{ 0, 0, 0, 3, 10, 30, },
	{ 2, 0, 0, 3, 10, 30, },
	{ 1, 0, 0, 3, 10, 30, },
	{ 0, 0, 0, 3, 11, 26, },
	{ 2, 0, 0, 3, 11, 30, },
	{ 1, 0, 0, 3, 11, 30, },
	{ 0, 0, 0, 3, 12, 14, },
	{ 2, 0, 0, 3, 12, 30, },
	{ 1, 0, 0, 3, 12, 30, },
	{ 0, 0, 0, 3, 13, 4, },
	{ 2, 0, 0, 3, 13, 30, },
	{ 1, 0, 0, 3, 13, 30, },
	{ 0, 0, 0, 3, 14, 63, },
	{ 2, 0, 0, 3, 14, 63, },
	{ 1, 0, 0, 3, 14, 63, },
	{ 0, 0, 0, 6, 1, 24, },
	{ 2, 0, 0, 6, 1, 28, },
	{ 1, 0, 0, 6, 1, 28, },
	{ 0, 0, 0, 6, 2, 28, },
	{ 2, 0, 0, 6, 2, 28, },
	{ 1, 0, 0, 6, 2, 28, },
	{ 0, 0, 0, 6, 3, 28, },
	{ 2, 0, 0, 6, 3, 28, },
	{ 1, 0, 0, 6, 3, 28, },
	{ 0, 0, 0, 6, 4, 28, },
	{ 2, 0, 0, 6, 4, 28, },
	{ 1, 0, 0, 6, 4, 28, },
	{ 0, 0, 0, 6, 5, 28, },
	{ 2, 0, 0, 6, 5, 28, },
	{ 1, 0, 0, 6, 5, 28, },
	{ 0, 0, 0, 6, 6, 28, },
	{ 2, 0, 0, 6, 6, 28, },
	{ 1, 0, 0, 6, 6, 28, },
	{ 0, 0, 0, 6, 7, 28, },
	{ 2, 0, 0, 6, 7, 28, },
	{ 1, 0, 0, 6, 7, 28, },
	{ 0, 0, 0, 6, 8, 28, },
	{ 2, 0, 0, 6, 8, 28, },
	{ 1, 0, 0, 6, 8, 28, },
	{ 0, 0, 0, 6, 9, 28, },
	{ 2, 0, 0, 6, 9, 28, },
	{ 1, 0, 0, 6, 9, 28, },
	{ 0, 0, 0, 6, 10, 28, },
	{ 2, 0, 0, 6, 10, 28, },
	{ 1, 0, 0, 6, 10, 28, },
	{ 0, 0, 0, 6, 11, 24, },
	{ 2, 0, 0, 6, 11, 28, },
	{ 1, 0, 0, 6, 11, 28, },
	{ 0, 0, 0, 6, 12, 14, },
	{ 2, 0, 0, 6, 12, 28, },
	{ 1, 0, 0, 6, 12, 28, },
	{ 0, 0, 0, 6, 13, 4, },
	{ 2, 0, 0, 6, 13, 28, },
	{ 1, 0, 0, 6, 13, 28, },
	{ 0, 0, 0, 6, 14, 63, },
	{ 2, 0, 0, 6, 14, 63, },
	{ 1, 0, 0, 6, 14, 63, },
	{ 0, 0, 0, 7, 1, 22, },
	{ 2, 0, 0, 7, 1, 26, },
	{ 1, 0, 0, 7, 1, 26, },
	{ 0, 0, 0, 7, 2, 26, },
	{ 2, 0, 0, 7, 2, 26, },
	{ 1, 0, 0, 7, 2, 26, },
	{ 0, 0, 0, 7, 3, 26, },
	{ 2, 0, 0, 7, 3, 26, },
	{ 1, 0, 0, 7, 3, 26, },
	{ 0, 0, 0, 7, 4, 26, },
	{ 2, 0, 0, 7, 4, 26, },
	{ 1, 0, 0, 7, 4, 26, },
	{ 0, 0, 0, 7, 5, 26, },
	{ 2, 0, 0, 7, 5, 26, },
	{ 1, 0, 0, 7, 5, 26, },
	{ 0, 0, 0, 7, 6, 26, },
	{ 2, 0, 0, 7, 6, 26, },
	{ 1, 0, 0, 7, 6, 26, },
	{ 0, 0, 0, 7, 7, 26, },
	{ 2, 0, 0, 7, 7, 26, },
	{ 1, 0, 0, 7, 7, 26, },
	{ 0, 0, 0, 7, 8, 26, },
	{ 2, 0, 0, 7, 8, 26, },
	{ 1, 0, 0, 7, 8, 26, },
	{ 0, 0, 0, 7, 9, 26, },
	{ 2, 0, 0, 7, 9, 26, },
	{ 1, 0, 0, 7, 9, 26, },
	{ 0, 0, 0, 7, 10, 26, },
	{ 2, 0, 0, 7, 10, 26, },
	{ 1, 0, 0, 7, 10, 26, },
	{ 0, 0, 0, 7, 11, 22, },
	{ 2, 0, 0, 7, 11, 26, },
	{ 1, 0, 0, 7, 11, 26, },
	{ 0, 0, 0, 7, 12, 14, },
	{ 2, 0, 0, 7, 12, 26, },
	{ 1, 0, 0, 7, 12, 26, },
	{ 0, 0, 0, 7, 13, 4, },
	{ 2, 0, 0, 7, 13, 26, },
	{ 1, 0, 0, 7, 13, 26, },
	{ 0, 0, 0, 7, 14, 63, },
	{ 2, 0, 0, 7, 14, 63, },
	{ 1, 0, 0, 7, 14, 63, },
	{ 0, 0, 1, 2, 1, 63, },
	{ 2, 0, 1, 2, 1, 63, },
	{ 1, 0, 1, 2, 1, 63, },
	{ 0, 0, 1, 2, 2, 63, },
	{ 2, 0, 1, 2, 2, 63, },
	{ 1, 0, 1, 2, 2, 63, },
	{ 0, 0, 1, 2, 3, 28, },
	{ 2, 0, 1, 2, 3, 32, },
	{ 1, 0, 1, 2, 3, 32, },
	{ 0, 0, 1, 2, 4, 32, },
	{ 2, 0, 1, 2, 4, 32, },
	{ 1, 0, 1, 2, 4, 32, },
	{ 0, 0, 1, 2, 5, 32, },
	{ 2, 0, 1, 2, 5, 32, },
	{ 1, 0, 1, 2, 5, 32, },
	{ 0, 0, 1, 2, 6, 32, },
	{ 2, 0, 1, 2, 6, 32, },
	{ 1, 0, 1, 2, 6, 32, },
	{ 0, 0, 1, 2, 7, 32, },
	{ 2, 0, 1, 2, 7, 32, },
	{ 1, 0, 1, 2, 7, 32, },
	{ 0, 0, 1, 2, 8, 32, },
	{ 2, 0, 1, 2, 8, 32, },
	{ 1, 0, 1, 2, 8, 32, },
	{ 0, 0, 1, 2, 9, 32, },
	{ 2, 0, 1, 2, 9, 32, },
	{ 1, 0, 1, 2, 9, 32, },
	{ 0, 0, 1, 2, 10, 32, },
	{ 2, 0, 1, 2, 10, 32, },
	{ 1, 0, 1, 2, 10, 32, },
	{ 0, 0, 1, 2, 11, 28, },
	{ 2, 0, 1, 2, 11, 32, },
	{ 1, 0, 1, 2, 11, 32, },
	{ 0, 0, 1, 2, 12, 16, },
	{ 2, 0, 1, 2, 12, 32, },
	{ 1, 0, 1, 2, 12, 32, },
	{ 0, 0, 1, 2, 13, 10, },
	{ 2, 0, 1, 2, 13, 32, },
	{ 1, 0, 1, 2, 13, 32, },
	{ 0, 0, 1, 2, 14, 63, },
	{ 2, 0, 1, 2, 14, 63, },
	{ 1, 0, 1, 2, 14, 63, },
	{ 0, 0, 1, 3, 1, 63, },
	{ 2, 0, 1, 3, 1, 63, },
	{ 1, 0, 1, 3, 1, 63, },
	{ 0, 0, 1, 3, 2, 63, },
	{ 2, 0, 1, 3, 2, 63, },
	{ 1, 0, 1, 3, 2, 63, },
	{ 0, 0, 1, 3, 3, 26, },
	{ 2, 0, 1, 3, 3, 30, },
	{ 1, 0, 1, 3, 3, 30, },
	{ 0, 0, 1, 3, 4, 30, },
	{ 2, 0, 1, 3, 4, 30, },
	{ 1, 0, 1, 3, 4, 30, },
	{ 0, 0, 1, 3, 5, 30, },
	{ 2, 0, 1, 3, 5, 30, },
	{ 1, 0, 1, 3, 5, 30, },
	{ 0, 0, 1, 3, 6, 30, },
	{ 2, 0, 1, 3, 6, 30, },
	{ 1, 0, 1, 3, 6, 30, },
	{ 0, 0, 1, 3, 7, 30, },
	{ 2, 0, 1, 3, 7, 30, },
	{ 1, 0, 1, 3, 7, 30, },
	{ 0, 0, 1, 3, 8, 30, },
	{ 2, 0, 1, 3, 8, 30, },
	{ 1, 0, 1, 3, 8, 30, },
	{ 0, 0, 1, 3, 9, 30, },
	{ 2, 0, 1, 3, 9, 30, },
	{ 1, 0, 1, 3, 9, 30, },
	{ 0, 0, 1, 3, 10, 30, },
	{ 2, 0, 1, 3, 10, 30, },
	{ 1, 0, 1, 3, 10, 30, },
	{ 0, 0, 1, 3, 11, 26, },
	{ 2, 0, 1, 3, 11, 30, },
	{ 1, 0, 1, 3, 11, 30, },
	{ 0, 0, 1, 3, 12, 14, },
	{ 2, 0, 1, 3, 12, 30, },
	{ 1, 0, 1, 3, 12, 30, },
	{ 0, 0, 1, 3, 13, 8, },
	{ 2, 0, 1, 3, 13, 30, },
	{ 1, 0, 1, 3, 13, 30, },
	{ 0, 0, 1, 3, 14, 63, },
	{ 2, 0, 1, 3, 14, 63, },
	{ 1, 0, 1, 3, 14, 63, },
	{ 0, 0, 1, 6, 1, 63, },
	{ 2, 0, 1, 6, 1, 63, },
	{ 1, 0, 1, 6, 1, 63, },
	{ 0, 0, 1, 6, 2, 63, },
	{ 2, 0, 1, 6, 2, 63, },
	{ 1, 0, 1, 6, 2, 63, },
	{ 0, 0, 1, 6, 3, 24, },
	{ 2, 0, 1, 6, 3, 28, },
	{ 1, 0, 1, 6, 3, 28, },
	{ 0, 0, 1, 6, 4, 28, },
	{ 2, 0, 1, 6, 4, 28, },
	{ 1, 0, 1, 6, 4, 28, },
	{ 0, 0, 1, 6, 5, 28, },
	{ 2, 0, 1, 6, 5, 28, },
	{ 1, 0, 1, 6, 5, 28, },
	{ 0, 0, 1, 6, 6, 28, },
	{ 2, 0, 1, 6, 6, 28, },
	{ 1, 0, 1, 6, 6, 28, },
	{ 0, 0, 1, 6, 7, 28, },
	{ 2, 0, 1, 6, 7, 28, },
	{ 1, 0, 1, 6, 7, 28, },
	{ 0, 0, 1, 6, 8, 28, },
	{ 2, 0, 1, 6, 8, 28, },
	{ 1, 0, 1, 6, 8, 28, },
	{ 0, 0, 1, 6, 9, 28, },
	{ 2, 0, 1, 6, 9, 28, },
	{ 1, 0, 1, 6, 9, 28, },
	{ 0, 0, 1, 6, 10, 28, },
	{ 2, 0, 1, 6, 10, 28, },
	{ 1, 0, 1, 6, 10, 28, },
	{ 0, 0, 1, 6, 11, 24, },
	{ 2, 0, 1, 6, 11, 28, },
	{ 1, 0, 1, 6, 11, 28, },
	{ 0, 0, 1, 6, 12, 14, },
	{ 2, 0, 1, 6, 12, 28, },
	{ 1, 0, 1, 6, 12, 28, },
	{ 0, 0, 1, 6, 13, 8, },
	{ 2, 0, 1, 6, 13, 28, },
	{ 1, 0, 1, 6, 13, 28, },
	{ 0, 0, 1, 6, 14, 63, },
	{ 2, 0, 1, 6, 14, 63, },
	{ 1, 0, 1, 6, 14, 63, },
	{ 0, 0, 1, 7, 1, 63, },
	{ 2, 0, 1, 7, 1, 63, },
	{ 1, 0, 1, 7, 1, 63, },
	{ 0, 0, 1, 7, 2, 63, },
	{ 2, 0, 1, 7, 2, 63, },
	{ 1, 0, 1, 7, 2, 63, },
	{ 0, 0, 1, 7, 3, 22, },
	{ 2, 0, 1, 7, 3, 26, },
	{ 1, 0, 1, 7, 3, 26, },
	{ 0, 0, 1, 7, 4, 26, },
	{ 2, 0, 1, 7, 4, 26, },
	{ 1, 0, 1, 7, 4, 26, },
	{ 0, 0, 1, 7, 5, 26, },
	{ 2, 0, 1, 7, 5, 26, },
	{ 1, 0, 1, 7, 5, 26, },
	{ 0, 0, 1, 7, 6, 26, },
	{ 2, 0, 1, 7, 6, 26, },
	{ 1, 0, 1, 7, 6, 26, },
	{ 0, 0, 1, 7, 7, 26, },
	{ 2, 0, 1, 7, 7, 26, },
	{ 1, 0, 1, 7, 7, 26, },
	{ 0, 0, 1, 7, 8, 26, },
	{ 2, 0, 1, 7, 8, 26, },
	{ 1, 0, 1, 7, 8, 26, },
	{ 0, 0, 1, 7, 9, 26, },
	{ 2, 0, 1, 7, 9, 26, },
	{ 1, 0, 1, 7, 9, 26, },
	{ 0, 0, 1, 7, 10, 26, },
	{ 2, 0, 1, 7, 10, 26, },
	{ 1, 0, 1, 7, 10, 26, },
	{ 0, 0, 1, 7, 11, 22, },
	{ 2, 0, 1, 7, 11, 26, },
	{ 1, 0, 1, 7, 11, 26, },
	{ 0, 0, 1, 7, 12, 14, },
	{ 2, 0, 1, 7, 12, 26, },
	{ 1, 0, 1, 7, 12, 26, },
	{ 0, 0, 1, 7, 13, 8, },
	{ 2, 0, 1, 7, 13, 26, },
	{ 1, 0, 1, 7, 13, 26, },
	{ 0, 0, 1, 7, 14, 63, },
	{ 2, 0, 1, 7, 14, 63, },
	{ 1, 0, 1, 7, 14, 63, },
	{ 0, 1, 0, 1, 36, 28, },
	{ 2, 1, 0, 1, 36, 32, },
	{ 1, 1, 0, 1, 36, 32, },
	{ 0, 1, 0, 1, 40, 32, },
	{ 2, 1, 0, 1, 40, 32, },
	{ 1, 1, 0, 1, 40, 32, },
	{ 0, 1, 0, 1, 44, 32, },
	{ 2, 1, 0, 1, 44, 32, },
	{ 1, 1, 0, 1, 44, 32, },
	{ 0, 1, 0, 1, 48, 32, },
	{ 2, 1, 0, 1, 48, 32, },
	{ 1, 1, 0, 1, 48, 32, },
	{ 0, 1, 0, 1, 52, 32, },
	{ 2, 1, 0, 1, 52, 32, },
	{ 1, 1, 0, 1, 52, 32, },
	{ 0, 1, 0, 1, 56, 32, },
	{ 2, 1, 0, 1, 56, 32, },
	{ 1, 1, 0, 1, 56, 32, },
	{ 0, 1, 0, 1, 60, 32, },
	{ 2, 1, 0, 1, 60, 32, },
	{ 1, 1, 0, 1, 60, 32, },
	{ 0, 1, 0, 1, 64, 30, },
	{ 2, 1, 0, 1, 64, 32, },
	{ 1, 1, 0, 1, 64, 32, },
	{ 0, 1, 0, 1, 100, 28, },
	{ 2, 1, 0, 1, 100, 32, },
	{ 1, 1, 0, 1, 100, 32, },
	{ 0, 1, 0, 1, 104, 32, },
	{ 2, 1, 0, 1, 104, 32, },
	{ 1, 1, 0, 1, 104, 32, },
	{ 0, 1, 0, 1, 108, 32, },
	{ 2, 1, 0, 1, 108, 32, },
	{ 1, 1, 0, 1, 108, 32, },
	{ 0, 1, 0, 1, 112, 32, },
	{ 2, 1, 0, 1, 112, 32, },
	{ 1, 1, 0, 1, 112, 32, },
	{ 0, 1, 0, 1, 116, 32, },
	{ 2, 1, 0, 1, 116, 32, },
	{ 1, 1, 0, 1, 116, 32, },
	{ 0, 1, 0, 1, 120, 32, },
	{ 2, 1, 0, 1, 120, 32, },
	{ 1, 1, 0, 1, 120, 32, },
	{ 0, 1, 0, 1, 124, 32, },
	{ 2, 1, 0, 1, 124, 32, },
	{ 1, 1, 0, 1, 124, 32, },
	{ 0, 1, 0, 1, 128, 32, },
	{ 2, 1, 0, 1, 128, 32, },
	{ 1, 1, 0, 1, 128, 32, },
	{ 0, 1, 0, 1, 132, 32, },
	{ 2, 1, 0, 1, 132, 32, },
	{ 1, 1, 0, 1, 132, 32, },
	{ 0, 1, 0, 1, 136, 32, },
	{ 2, 1, 0, 1, 136, 32, },
	{ 1, 1, 0, 1, 136, 32, },
	{ 0, 1, 0, 1, 140, 28, },
	{ 2, 1, 0, 1, 140, 32, },
	{ 1, 1, 0, 1, 140, 32, },
	{ 0, 1, 0, 1, 149, 28, },
	{ 2, 1, 0, 1, 149, 32, },
	{ 1, 1, 0, 1, 149, 63, },
	{ 0, 1, 0, 1, 153, 32, },
	{ 2, 1, 0, 1, 153, 32, },
	{ 1, 1, 0, 1, 153, 63, },
	{ 0, 1, 0, 1, 157, 32, },
	{ 2, 1, 0, 1, 157, 32, },
	{ 1, 1, 0, 1, 157, 63, },
	{ 0, 1, 0, 1, 161, 32, },
	{ 2, 1, 0, 1, 161, 32, },
	{ 1, 1, 0, 1, 161, 63, },
	{ 0, 1, 0, 1, 165, 32, },
	{ 2, 1, 0, 1, 165, 32, },
	{ 1, 1, 0, 1, 165, 63, },
	{ 0, 1, 0, 2, 36, 28, },
	{ 2, 1, 0, 2, 36, 32, },
	{ 1, 1, 0, 2, 36, 32, },
	{ 0, 1, 0, 2, 40, 32, },
	{ 2, 1, 0, 2, 40, 32, },
	{ 1, 1, 0, 2, 40, 32, },
	{ 0, 1, 0, 2, 44, 32, },
	{ 2, 1, 0, 2, 44, 32, },
	{ 1, 1, 0, 2, 44, 32, },
	{ 0, 1, 0, 2, 48, 32, },
	{ 2, 1, 0, 2, 48, 32, },
	{ 1, 1, 0, 2, 48, 32, },
	{ 0, 1, 0, 2, 52, 32, },
	{ 2, 1, 0, 2, 52, 32, },
	{ 1, 1, 0, 2, 52, 32, },
	{ 0, 1, 0, 2, 56, 32, },
	{ 2, 1, 0, 2, 56, 32, },
	{ 1, 1, 0, 2, 56, 32, },
	{ 0, 1, 0, 2, 60, 32, },
	{ 2, 1, 0, 2, 60, 32, },
	{ 1, 1, 0, 2, 60, 32, },
	{ 0, 1, 0, 2, 64, 30, },
	{ 2, 1, 0, 2, 64, 32, },
	{ 1, 1, 0, 2, 64, 32, },
	{ 0, 1, 0, 2, 100, 28, },
	{ 2, 1, 0, 2, 100, 32, },
	{ 1, 1, 0, 2, 100, 32, },
	{ 0, 1, 0, 2, 104, 32, },
	{ 2, 1, 0, 2, 104, 32, },
	{ 1, 1, 0, 2, 104, 32, },
	{ 0, 1, 0, 2, 108, 32, },
	{ 2, 1, 0, 2, 108, 32, },
	{ 1, 1, 0, 2, 108, 32, },
	{ 0, 1, 0, 2, 112, 32, },
	{ 2, 1, 0, 2, 112, 32, },
	{ 1, 1, 0, 2, 112, 32, },
	{ 0, 1, 0, 2, 116, 32, },
	{ 2, 1, 0, 2, 116, 32, },
	{ 1, 1, 0, 2, 116, 32, },
	{ 0, 1, 0, 2, 120, 32, },
	{ 2, 1, 0, 2, 120, 32, },
	{ 1, 1, 0, 2, 120, 32, },
	{ 0, 1, 0, 2, 124, 32, },
	{ 2, 1, 0, 2, 124, 32, },
	{ 1, 1, 0, 2, 124, 32, },
	{ 0, 1, 0, 2, 128, 32, },
	{ 2, 1, 0, 2, 128, 32, },
	{ 1, 1, 0, 2, 128, 32, },
	{ 0, 1, 0, 2, 132, 32, },
	{ 2, 1, 0, 2, 132, 32, },
	{ 1, 1, 0, 2, 132, 32, },
	{ 0, 1, 0, 2, 136, 32, },
	{ 2, 1, 0, 2, 136, 32, },
	{ 1, 1, 0, 2, 136, 32, },
	{ 0, 1, 0, 2, 140, 28, },
	{ 2, 1, 0, 2, 140, 32, },
	{ 1, 1, 0, 2, 140, 32, },
	{ 0, 1, 0, 2, 149, 28, },
	{ 2, 1, 0, 2, 149, 32, },
	{ 1, 1, 0, 2, 149, 63, },
	{ 0, 1, 0, 2, 153, 32, },
	{ 2, 1, 0, 2, 153, 32, },
	{ 1, 1, 0, 2, 153, 63, },
	{ 0, 1, 0, 2, 157, 32, },
	{ 2, 1, 0, 2, 157, 32, },
	{ 1, 1, 0, 2, 157, 63, },
	{ 0, 1, 0, 2, 161, 32, },
	{ 2, 1, 0, 2, 161, 32, },
	{ 1, 1, 0, 2, 161, 63, },
	{ 0, 1, 0, 2, 165, 32, },
	{ 2, 1, 0, 2, 165, 32, },
	{ 1, 1, 0, 2, 165, 63, },
	{ 0, 1, 0, 3, 36, 26, },
	{ 2, 1, 0, 3, 36, 30, },
	{ 1, 1, 0, 3, 36, 30, },
	{ 0, 1, 0, 3, 40, 30, },
	{ 2, 1, 0, 3, 40, 30, },
	{ 1, 1, 0, 3, 40, 30, },
	{ 0, 1, 0, 3, 44, 30, },
	{ 2, 1, 0, 3, 44, 30, },
	{ 1, 1, 0, 3, 44, 30, },
	{ 0, 1, 0, 3, 48, 30, },
	{ 2, 1, 0, 3, 48, 30, },
	{ 1, 1, 0, 3, 48, 30, },
	{ 0, 1, 0, 3, 52, 30, },
	{ 2, 1, 0, 3, 52, 30, },
	{ 1, 1, 0, 3, 52, 30, },
	{ 0, 1, 0, 3, 56, 30, },
	{ 2, 1, 0, 3, 56, 30, },
	{ 1, 1, 0, 3, 56, 30, },
	{ 0, 1, 0, 3, 60, 30, },
	{ 2, 1, 0, 3, 60, 30, },
	{ 1, 1, 0, 3, 60, 30, },
	{ 0, 1, 0, 3, 64, 28, },
	{ 2, 1, 0, 3, 64, 30, },
	{ 1, 1, 0, 3, 64, 30, },
	{ 0, 1, 0, 3, 100, 28, },
	{ 2, 1, 0, 3, 100, 30, },
	{ 1, 1, 0, 3, 100, 30, },
	{ 0, 1, 0, 3, 104, 30, },
	{ 2, 1, 0, 3, 104, 30, },
	{ 1, 1, 0, 3, 104, 30, },
	{ 0, 1, 0, 3, 108, 30, },
	{ 2, 1, 0, 3, 108, 30, },
	{ 1, 1, 0, 3, 108, 30, },
	{ 0, 1, 0, 3, 112, 30, },
	{ 2, 1, 0, 3, 112, 30, },
	{ 1, 1, 0, 3, 112, 30, },
	{ 0, 1, 0, 3, 116, 30, },
	{ 2, 1, 0, 3, 116, 30, },
	{ 1, 1, 0, 3, 116, 30, },
	{ 0, 1, 0, 3, 120, 30, },
	{ 2, 1, 0, 3, 120, 30, },
	{ 1, 1, 0, 3, 120, 30, },
	{ 0, 1, 0, 3, 124, 30, },
	{ 2, 1, 0, 3, 124, 30, },
	{ 1, 1, 0, 3, 124, 30, },
	{ 0, 1, 0, 3, 128, 30, },
	{ 2, 1, 0, 3, 128, 30, },
	{ 1, 1, 0, 3, 128, 30, },
	{ 0, 1, 0, 3, 132, 30, },
	{ 2, 1, 0, 3, 132, 30, },
	{ 1, 1, 0, 3, 132, 30, },
	{ 0, 1, 0, 3, 136, 30, },
	{ 2, 1, 0, 3, 136, 30, },
	{ 1, 1, 0, 3, 136, 30, },
	{ 0, 1, 0, 3, 140, 26, },
	{ 2, 1, 0, 3, 140, 30, },
	{ 1, 1, 0, 3, 140, 30, },
	{ 0, 1, 0, 3, 149, 26, },
	{ 2, 1, 0, 3, 149, 30, },
	{ 1, 1, 0, 3, 149, 63, },
	{ 0, 1, 0, 3, 153, 30, },
	{ 2, 1, 0, 3, 153, 30, },
	{ 1, 1, 0, 3, 153, 63, },
	{ 0, 1, 0, 3, 157, 30, },
	{ 2, 1, 0, 3, 157, 30, },
	{ 1, 1, 0, 3, 157, 63, },
	{ 0, 1, 0, 3, 161, 30, },
	{ 2, 1, 0, 3, 161, 30, },
	{ 1, 1, 0, 3, 161, 63, },
	{ 0, 1, 0, 3, 165, 30, },
	{ 2, 1, 0, 3, 165, 30, },
	{ 1, 1, 0, 3, 165, 63, },
	{ 0, 1, 0, 6, 36, 24, },
	{ 2, 1, 0, 6, 36, 28, },
	{ 1, 1, 0, 6, 36, 28, },
	{ 0, 1, 0, 6, 40, 28, },
	{ 2, 1, 0, 6, 40, 28, },
	{ 1, 1, 0, 6, 40, 28, },
	{ 0, 1, 0, 6, 44, 28, },
	{ 2, 1, 0, 6, 44, 28, },
	{ 1, 1, 0, 6, 44, 28, },
	{ 0, 1, 0, 6, 48, 28, },
	{ 2, 1, 0, 6, 48, 28, },
	{ 1, 1, 0, 6, 48, 28, },
	{ 0, 1, 0, 6, 52, 28, },
	{ 2, 1, 0, 6, 52, 28, },
	{ 1, 1, 0, 6, 52, 28, },
	{ 0, 1, 0, 6, 56, 28, },
	{ 2, 1, 0, 6, 56, 28, },
	{ 1, 1, 0, 6, 56, 28, },
	{ 0, 1, 0, 6, 60, 28, },
	{ 2, 1, 0, 6, 60, 28, },
	{ 1, 1, 0, 6, 60, 28, },
	{ 0, 1, 0, 6, 64, 26, },
	{ 2, 1, 0, 6, 64, 28, },
	{ 1, 1, 0, 6, 64, 28, },
	{ 0, 1, 0, 6, 100, 24, },
	{ 2, 1, 0, 6, 100, 28, },
	{ 1, 1, 0, 6, 100, 28, },
	{ 0, 1, 0, 6, 104, 28, },
	{ 2, 1, 0, 6, 104, 28, },
	{ 1, 1, 0, 6, 104, 28, },
	{ 0, 1, 0, 6, 108, 28, },
	{ 2, 1, 0, 6, 108, 28, },
	{ 1, 1, 0, 6, 108, 28, },
	{ 0, 1, 0, 6, 112, 28, },
	{ 2, 1, 0, 6, 112, 28, },
	{ 1, 1, 0, 6, 112, 28, },
	{ 0, 1, 0, 6, 116, 28, },
	{ 2, 1, 0, 6, 116, 28, },
	{ 1, 1, 0, 6, 116, 28, },
	{ 0, 1, 0, 6, 120, 28, },
	{ 2, 1, 0, 6, 120, 28, },
	{ 1, 1, 0, 6, 120, 28, },
	{ 0, 1, 0, 6, 124, 28, },
	{ 2, 1, 0, 6, 124, 28, },
	{ 1, 1, 0, 6, 124, 28, },
	{ 0, 1, 0, 6, 128, 28, },
	{ 2, 1, 0, 6, 128, 28, },
	{ 1, 1, 0, 6, 128, 28, },
	{ 0, 1, 0, 6, 132, 28, },
	{ 2, 1, 0, 6, 132, 28, },
	{ 1, 1, 0, 6, 132, 28, },
	{ 0, 1, 0, 6, 136, 28, },
	{ 2, 1, 0, 6, 136, 28, },
	{ 1, 1, 0, 6, 136, 28, },
	{ 0, 1, 0, 6, 140, 24, },
	{ 2, 1, 0, 6, 140, 28, },
	{ 1, 1, 0, 6, 140, 28, },
	{ 0, 1, 0, 6, 149, 24, },
	{ 2, 1, 0, 6, 149, 28, },
	{ 1, 1, 0, 6, 149, 63, },
	{ 0, 1, 0, 6, 153, 28, },
	{ 2, 1, 0, 6, 153, 28, },
	{ 1, 1, 0, 6, 153, 63, },
	{ 0, 1, 0, 6, 157, 28, },
	{ 2, 1, 0, 6, 157, 28, },
	{ 1, 1, 0, 6, 157, 63, },
	{ 0, 1, 0, 6, 161, 28, },
	{ 2, 1, 0, 6, 161, 28, },
	{ 1, 1, 0, 6, 161, 63, },
	{ 0, 1, 0, 6, 165, 28, },
	{ 2, 1, 0, 6, 165, 28, },
	{ 1, 1, 0, 6, 165, 63, },
	{ 0, 1, 0, 7, 36, 22, },
	{ 2, 1, 0, 7, 36, 26, },
	{ 1, 1, 0, 7, 36, 26, },
	{ 0, 1, 0, 7, 40, 26, },
	{ 2, 1, 0, 7, 40, 26, },
	{ 1, 1, 0, 7, 40, 26, },
	{ 0, 1, 0, 7, 44, 26, },
	{ 2, 1, 0, 7, 44, 26, },
	{ 1, 1, 0, 7, 44, 26, },
	{ 0, 1, 0, 7, 48, 26, },
	{ 2, 1, 0, 7, 48, 26, },
	{ 1, 1, 0, 7, 48, 26, },
	{ 0, 1, 0, 7, 52, 26, },
	{ 2, 1, 0, 7, 52, 26, },
	{ 1, 1, 0, 7, 52, 26, },
	{ 0, 1, 0, 7, 56, 26, },
	{ 2, 1, 0, 7, 56, 26, },
	{ 1, 1, 0, 7, 56, 26, },
	{ 0, 1, 0, 7, 60, 26, },
	{ 2, 1, 0, 7, 60, 26, },
	{ 1, 1, 0, 7, 60, 26, },
	{ 0, 1, 0, 7, 64, 24, },
	{ 2, 1, 0, 7, 64, 26, },
	{ 1, 1, 0, 7, 64, 26, },
	{ 0, 1, 0, 7, 100, 22, },
	{ 2, 1, 0, 7, 100, 26, },
	{ 1, 1, 0, 7, 100, 26, },
	{ 0, 1, 0, 7, 104, 26, },
	{ 2, 1, 0, 7, 104, 26, },
	{ 1, 1, 0, 7, 104, 26, },
	{ 0, 1, 0, 7, 108, 26, },
	{ 2, 1, 0, 7, 108, 26, },
	{ 1, 1, 0, 7, 108, 26, },
	{ 0, 1, 0, 7, 112, 26, },
	{ 2, 1, 0, 7, 112, 26, },
	{ 1, 1, 0, 7, 112, 26, },
	{ 0, 1, 0, 7, 116, 26, },
	{ 2, 1, 0, 7, 116, 26, },
	{ 1, 1, 0, 7, 116, 26, },
	{ 0, 1, 0, 7, 120, 26, },
	{ 2, 1, 0, 7, 120, 26, },
	{ 1, 1, 0, 7, 120, 26, },
	{ 0, 1, 0, 7, 124, 26, },
	{ 2, 1, 0, 7, 124, 26, },
	{ 1, 1, 0, 7, 124, 26, },
	{ 0, 1, 0, 7, 128, 26, },
	{ 2, 1, 0, 7, 128, 26, },
	{ 1, 1, 0, 7, 128, 26, },
	{ 0, 1, 0, 7, 132, 26, },
	{ 2, 1, 0, 7, 132, 26, },
	{ 1, 1, 0, 7, 132, 26, },
	{ 0, 1, 0, 7, 136, 26, },
	{ 2, 1, 0, 7, 136, 26, },
	{ 1, 1, 0, 7, 136, 26, },
	{ 0, 1, 0, 7, 140, 22, },
	{ 2, 1, 0, 7, 140, 26, },
	{ 1, 1, 0, 7, 140, 26, },
	{ 0, 1, 0, 7, 149, 22, },
	{ 2, 1, 0, 7, 149, 26, },
	{ 1, 1, 0, 7, 149, 63, },
	{ 0, 1, 0, 7, 153, 26, },
	{ 2, 1, 0, 7, 153, 26, },
	{ 1, 1, 0, 7, 153, 63, },
	{ 0, 1, 0, 7, 157, 26, },
	{ 2, 1, 0, 7, 157, 26, },
	{ 1, 1, 0, 7, 157, 63, },
	{ 0, 1, 0, 7, 161, 26, },
	{ 2, 1, 0, 7, 161, 26, },
	{ 1, 1, 0, 7, 161, 63, },
	{ 0, 1, 0, 7, 165, 26, },
	{ 2, 1, 0, 7, 165, 26, },
	{ 1, 1, 0, 7, 165, 63, },
	{ 0, 1, 1, 2, 38, 28, },
	{ 2, 1, 1, 2, 38, 32, },
	{ 1, 1, 1, 2, 38, 32, },
	{ 0, 1, 1, 2, 46, 32, },
	{ 2, 1, 1, 2, 46, 32, },
	{ 1, 1, 1, 2, 46, 32, },
	{ 0, 1, 1, 2, 54, 32, },
	{ 2, 1, 1, 2, 54, 32, },
	{ 1, 1, 1, 2, 54, 32, },
	{ 0, 1, 1, 2, 62, 28, },
	{ 2, 1, 1, 2, 62, 32, },
	{ 1, 1, 1, 2, 62, 32, },
	{ 0, 1, 1, 2, 102, 28, },
	{ 2, 1, 1, 2, 102, 32, },
	{ 1, 1, 1, 2, 102, 32, },
	{ 0, 1, 1, 2, 110, 32, },
	{ 2, 1, 1, 2, 110, 32, },
	{ 1, 1, 1, 2, 110, 32, },
	{ 0, 1, 1, 2, 118, 32, },
	{ 2, 1, 1, 2, 118, 32, },
	{ 1, 1, 1, 2, 118, 32, },
	{ 0, 1, 1, 2, 126, 32, },
	{ 2, 1, 1, 2, 126, 32, },
	{ 1, 1, 1, 2, 126, 32, },
	{ 0, 1, 1, 2, 134, 30, },
	{ 2, 1, 1, 2, 134, 32, },
	{ 1, 1, 1, 2, 134, 32, },
	{ 0, 1, 1, 2, 151, 28, },
	{ 2, 1, 1, 2, 151, 32, },
	{ 1, 1, 1, 2, 151, 63, },
	{ 0, 1, 1, 2, 159, 32, },
	{ 2, 1, 1, 2, 159, 32, },
	{ 1, 1, 1, 2, 159, 63, },
	{ 0, 1, 1, 3, 38, 26, },
	{ 2, 1, 1, 3, 38, 30, },
	{ 1, 1, 1, 3, 38, 30, },
	{ 0, 1, 1, 3, 46, 30, },
	{ 2, 1, 1, 3, 46, 30, },
	{ 1, 1, 1, 3, 46, 30, },
	{ 0, 1, 1, 3, 54, 30, },
	{ 2, 1, 1, 3, 54, 30, },
	{ 1, 1, 1, 3, 54, 30, },
	{ 0, 1, 1, 3, 62, 26, },
	{ 2, 1, 1, 3, 62, 30, },
	{ 1, 1, 1, 3, 62, 30, },
	{ 0, 1, 1, 3, 102, 26, },
	{ 2, 1, 1, 3, 102, 30, },
	{ 1, 1, 1, 3, 102, 30, },
	{ 0, 1, 1, 3, 110, 30, },
	{ 2, 1, 1, 3, 110, 30, },
	{ 1, 1, 1, 3, 110, 30, },
	{ 0, 1, 1, 3, 118, 30, },
	{ 2, 1, 1, 3, 118, 30, },
	{ 1, 1, 1, 3, 118, 30, },
	{ 0, 1, 1, 3, 126, 30, },
	{ 2, 1, 1, 3, 126, 30, },
	{ 1, 1, 1, 3, 126, 30, },
	{ 0, 1, 1, 3, 134, 28, },
	{ 2, 1, 1, 3, 134, 30, },
	{ 1, 1, 1, 3, 134, 30, },
	{ 0, 1, 1, 3, 151, 26, },
	{ 2, 1, 1, 3, 151, 30, },
	{ 1, 1, 1, 3, 151, 63, },
	{ 0, 1, 1, 3, 159, 30, },
	{ 2, 1, 1, 3, 159, 30, },
	{ 1, 1, 1, 3, 159, 63, },
	{ 0, 1, 1, 6, 38, 20, },
	{ 2, 1, 1, 6, 38, 28, },
	{ 1, 1, 1, 6, 38, 28, },
	{ 0, 1, 1, 6, 46, 28, },
	{ 2, 1, 1, 6, 46, 28, },
	{ 1, 1, 1, 6, 46, 28, },
	{ 0, 1, 1, 6, 54, 28, },
	{ 2, 1, 1, 6, 54, 28, },
	{ 1, 1, 1, 6, 54, 28, },
	{ 0, 1, 1, 6, 62, 20, },
	{ 2, 1, 1, 6, 62, 28, },
	{ 1, 1, 1, 6, 62, 28, },
	{ 0, 1, 1, 6, 102, 22, },
	{ 2, 1, 1, 6, 102, 28, },
	{ 1, 1, 1, 6, 102, 28, },
	{ 0, 1, 1, 6, 110, 28, },
	{ 2, 1, 1, 6, 110, 28, },
	{ 1, 1, 1, 6, 110, 28, },
	{ 0, 1, 1, 6, 118, 28, },
	{ 2, 1, 1, 6, 118, 28, },
	{ 1, 1, 1, 6, 118, 28, },
	{ 0, 1, 1, 6, 126, 28, },
	{ 2, 1, 1, 6, 126, 28, },
	{ 1, 1, 1, 6, 126, 28, },
	{ 0, 1, 1, 6, 134, 26, },
	{ 2, 1, 1, 6, 134, 28, },
	{ 1, 1, 1, 6, 134, 28, },
	{ 0, 1, 1, 6, 151, 22, },
	{ 2, 1, 1, 6, 151, 28, },
	{ 1, 1, 1, 6, 151, 63, },
	{ 0, 1, 1, 6, 159, 28, },
	{ 2, 1, 1, 6, 159, 28, },
	{ 1, 1, 1, 6, 159, 63, },
	{ 0, 1, 1, 7, 38, 18, },
	{ 2, 1, 1, 7, 38, 26, },
	{ 1, 1, 1, 7, 38, 26, },
	{ 0, 1, 1, 7, 46, 26, },
	{ 2, 1, 1, 7, 46, 26, },
	{ 1, 1, 1, 7, 46, 26, },
	{ 0, 1, 1, 7, 54, 26, },
	{ 2, 1, 1, 7, 54, 26, },
	{ 1, 1, 1, 7, 54, 26, },
	{ 0, 1, 1, 7, 62, 18, },
	{ 2, 1, 1, 7, 62, 26, },
	{ 1, 1, 1, 7, 62, 26, },
	{ 0, 1, 1, 7, 102, 20, },
	{ 2, 1, 1, 7, 102, 26, },
	{ 1, 1, 1, 7, 102, 26, },
	{ 0, 1, 1, 7, 110, 26, },
	{ 2, 1, 1, 7, 110, 26, },
	{ 1, 1, 1, 7, 110, 26, },
	{ 0, 1, 1, 7, 118, 26, },
	{ 2, 1, 1, 7, 118, 26, },
	{ 1, 1, 1, 7, 118, 26, },
	{ 0, 1, 1, 7, 126, 26, },
	{ 2, 1, 1, 7, 126, 26, },
	{ 1, 1, 1, 7, 126, 26, },
	{ 0, 1, 1, 7, 134, 24, },
	{ 2, 1, 1, 7, 134, 26, },
	{ 1, 1, 1, 7, 134, 26, },
	{ 0, 1, 1, 7, 151, 20, },
	{ 2, 1, 1, 7, 151, 26, },
	{ 1, 1, 1, 7, 151, 63, },
	{ 0, 1, 1, 7, 159, 26, },
	{ 2, 1, 1, 7, 159, 26, },
	{ 1, 1, 1, 7, 159, 63, },
	{ 0, 1, 2, 4, 42, 24, },
	{ 2, 1, 2, 4, 42, 32, },
	{ 1, 1, 2, 4, 42, 32, },
	{ 0, 1, 2, 4, 58, 24, },
	{ 2, 1, 2, 4, 58, 32, },
	{ 1, 1, 2, 4, 58, 32, },
	{ 0, 1, 2, 4, 106, 24, },
	{ 2, 1, 2, 4, 106, 32, },
	{ 1, 1, 2, 4, 106, 32, },
	{ 0, 1, 2, 4, 122, 32, },
	{ 2, 1, 2, 4, 122, 32, },
	{ 1, 1, 2, 4, 122, 32, },
	{ 0, 1, 2, 4, 155, 26, },
	{ 2, 1, 2, 4, 155, 32, },
	{ 1, 1, 2, 4, 155, 63, },
	{ 0, 1, 2, 5, 42, 22, },
	{ 2, 1, 2, 5, 42, 30, },
	{ 1, 1, 2, 5, 42, 30, },
	{ 0, 1, 2, 5, 58, 22, },
	{ 2, 1, 2, 5, 58, 30, },
	{ 1, 1, 2, 5, 58, 30, },
	{ 0, 1, 2, 5, 106, 22, },
	{ 2, 1, 2, 5, 106, 30, },
	{ 1, 1, 2, 5, 106, 30, },
	{ 0, 1, 2, 5, 122, 30, },
	{ 2, 1, 2, 5, 122, 30, },
	{ 1, 1, 2, 5, 122, 30, },
	{ 0, 1, 2, 5, 155, 24, },
	{ 2, 1, 2, 5, 155, 30, },
	{ 1, 1, 2, 5, 155, 63, },
	{ 0, 1, 2, 8, 42, 20, },
	{ 2, 1, 2, 8, 42, 28, },
	{ 1, 1, 2, 8, 42, 28, },
	{ 0, 1, 2, 8, 58, 20, },
	{ 2, 1, 2, 8, 58, 28, },
	{ 1, 1, 2, 8, 58, 28, },
	{ 0, 1, 2, 8, 106, 20, },
	{ 2, 1, 2, 8, 106, 28, },
	{ 1, 1, 2, 8, 106, 28, },
	{ 0, 1, 2, 8, 122, 28, },
	{ 2, 1, 2, 8, 122, 28, },
	{ 1, 1, 2, 8, 122, 28, },
	{ 0, 1, 2, 8, 155, 20, },
	{ 2, 1, 2, 8, 155, 28, },
	{ 1, 1, 2, 8, 155, 63, },
	{ 0, 1, 2, 9, 42, 18, },
	{ 2, 1, 2, 9, 42, 26, },
	{ 1, 1, 2, 9, 42, 26, },
	{ 0, 1, 2, 9, 58, 18, },
	{ 2, 1, 2, 9, 58, 26, },
	{ 1, 1, 2, 9, 58, 26, },
	{ 0, 1, 2, 9, 106, 18, },
	{ 2, 1, 2, 9, 106, 26, },
	{ 1, 1, 2, 9, 106, 26, },
	{ 0, 1, 2, 9, 122, 26, },
	{ 2, 1, 2, 9, 122, 26, },
	{ 1, 1, 2, 9, 122, 26, },
	{ 0, 1, 2, 9, 155, 18, },
	{ 2, 1, 2, 9, 155, 26, },
	{ 1, 1, 2, 9, 155, 63, },
};

RTW_DECL_TABLE_TXPWR_LMT(rtw8814a_txpwr_lmt_type1);

static const struct rtw_txpwr_lmt_cfg_pair rtw8814a_txpwr_lmt_type2[] = {
	{ 0, 0, 0, 0, 1, 42, },
	{ 2, 0, 0, 0, 1, 42, },
	{ 1, 0, 0, 0, 1, 42, },
	{ 0, 0, 0, 0, 2, 50, },
	{ 2, 0, 0, 0, 2, 42, },
	{ 1, 0, 0, 0, 2, 42, },
	{ 0, 0, 0, 0, 3, 50, },
	{ 2, 0, 0, 0, 3, 42, },
	{ 1, 0, 0, 0, 3, 42, },
	{ 0, 0, 0, 0, 4, 50, },
	{ 2, 0, 0, 0, 4, 42, },
	{ 1, 0, 0, 0, 4, 42, },
	{ 0, 0, 0, 0, 5, 50, },
	{ 2, 0, 0, 0, 5, 42, },
	{ 1, 0, 0, 0, 5, 42, },
	{ 0, 0, 0, 0, 6, 50, },
	{ 2, 0, 0, 0, 6, 42, },
	{ 1, 0, 0, 0, 6, 42, },
	{ 0, 0, 0, 0, 7, 50, },
	{ 2, 0, 0, 0, 7, 42, },
	{ 1, 0, 0, 0, 7, 42, },
	{ 0, 0, 0, 0, 8, 50, },
	{ 2, 0, 0, 0, 8, 42, },
	{ 1, 0, 0, 0, 8, 42, },
	{ 0, 0, 0, 0, 9, 50, },
	{ 2, 0, 0, 0, 9, 42, },
	{ 1, 0, 0, 0, 9, 42, },
	{ 0, 0, 0, 0, 10, 50, },
	{ 2, 0, 0, 0, 10, 42, },
	{ 1, 0, 0, 0, 10, 42, },
	{ 0, 0, 0, 0, 11, 44, },
	{ 2, 0, 0, 0, 11, 42, },
	{ 1, 0, 0, 0, 11, 42, },
	{ 0, 0, 0, 0, 12, 63, },
	{ 2, 0, 0, 0, 12, 42, },
	{ 1, 0, 0, 0, 12, 42, },
	{ 0, 0, 0, 0, 13, 63, },
	{ 2, 0, 0, 0, 13, 42, },
	{ 1, 0, 0, 0, 13, 42, },
	{ 0, 0, 0, 0, 14, 63, },
	{ 2, 0, 0, 0, 14, 63, },
	{ 1, 0, 0, 0, 14, 42, },
	{ 0, 0, 0, 1, 1, 32, },
	{ 2, 0, 0, 1, 1, 42, },
	{ 1, 0, 0, 1, 1, 42, },
	{ 0, 0, 0, 1, 2, 42, },
	{ 2, 0, 0, 1, 2, 42, },
	{ 1, 0, 0, 1, 2, 42, },
	{ 0, 0, 0, 1, 3, 42, },
	{ 2, 0, 0, 1, 3, 42, },
	{ 1, 0, 0, 1, 3, 42, },
	{ 0, 0, 0, 1, 4, 42, },
	{ 2, 0, 0, 1, 4, 42, },
	{ 1, 0, 0, 1, 4, 42, },
	{ 0, 0, 0, 1, 5, 42, },
	{ 2, 0, 0, 1, 5, 42, },
	{ 1, 0, 0, 1, 5, 42, },
	{ 0, 0, 0, 1, 6, 42, },
	{ 2, 0, 0, 1, 6, 42, },
	{ 1, 0, 0, 1, 6, 42, },
	{ 0, 0, 0, 1, 7, 42, },
	{ 2, 0, 0, 1, 7, 42, },
	{ 1, 0, 0, 1, 7, 42, },
	{ 0, 0, 0, 1, 8, 42, },
	{ 2, 0, 0, 1, 8, 42, },
	{ 1, 0, 0, 1, 8, 42, },
	{ 0, 0, 0, 1, 9, 42, },
	{ 2, 0, 0, 1, 9, 42, },
	{ 1, 0, 0, 1, 9, 42, },
	{ 0, 0, 0, 1, 10, 42, },
	{ 2, 0, 0, 1, 10, 42, },
	{ 1, 0, 0, 1, 10, 42, },
	{ 0, 0, 0, 1, 11, 32, },
	{ 2, 0, 0, 1, 11, 42, },
	{ 1, 0, 0, 1, 11, 42, },
	{ 0, 0, 0, 1, 12, 63, },
	{ 2, 0, 0, 1, 12, 42, },
	{ 1, 0, 0, 1, 12, 42, },
	{ 0, 0, 0, 1, 13, 63, },
	{ 2, 0, 0, 1, 13, 42, },
	{ 1, 0, 0, 1, 13, 42, },
	{ 0, 0, 0, 1, 14, 63, },
	{ 2, 0, 0, 1, 14, 63, },
	{ 1, 0, 0, 1, 14, 63, },
	{ 0, 0, 0, 2, 1, 32, },
	{ 2, 0, 0, 2, 1, 42, },
	{ 1, 0, 0, 2, 1, 42, },
	{ 0, 0, 0, 2, 2, 40, },
	{ 2, 0, 0, 2, 2, 42, },
	{ 1, 0, 0, 2, 2, 42, },
	{ 0, 0, 0, 2, 3, 40, },
	{ 2, 0, 0, 2, 3, 42, },
	{ 1, 0, 0, 2, 3, 42, },
	{ 0, 0, 0, 2, 4, 40, },
	{ 2, 0, 0, 2, 4, 42, },
	{ 1, 0, 0, 2, 4, 42, },
	{ 0, 0, 0, 2, 5, 40, },
	{ 2, 0, 0, 2, 5, 42, },
	{ 1, 0, 0, 2, 5, 42, },
	{ 0, 0, 0, 2, 6, 40, },
	{ 2, 0, 0, 2, 6, 42, },
	{ 1, 0, 0, 2, 6, 42, },
	{ 0, 0, 0, 2, 7, 40, },
	{ 2, 0, 0, 2, 7, 42, },
	{ 1, 0, 0, 2, 7, 42, },
	{ 0, 0, 0, 2, 8, 40, },
	{ 2, 0, 0, 2, 8, 42, },
	{ 1, 0, 0, 2, 8, 42, },
	{ 0, 0, 0, 2, 9, 40, },
	{ 2, 0, 0, 2, 9, 42, },
	{ 1, 0, 0, 2, 9, 42, },
	{ 0, 0, 0, 2, 10, 40, },
	{ 2, 0, 0, 2, 10, 42, },
	{ 1, 0, 0, 2, 10, 42, },
	{ 0, 0, 0, 2, 11, 28, },
	{ 2, 0, 0, 2, 11, 42, },
	{ 1, 0, 0, 2, 11, 42, },
	{ 0, 0, 0, 2, 12, 63, },
	{ 2, 0, 0, 2, 12, 42, },
	{ 1, 0, 0, 2, 12, 42, },
	{ 0, 0, 0, 2, 13, 63, },
	{ 2, 0, 0, 2, 13, 42, },
	{ 1, 0, 0, 2, 13, 42, },
	{ 0, 0, 0, 2, 14, 63, },
	{ 2, 0, 0, 2, 14, 63, },
	{ 1, 0, 0, 2, 14, 63, },
	{ 0, 0, 0, 3, 1, 32, },
	{ 2, 0, 0, 3, 1, 40, },
	{ 1, 0, 0, 3, 1, 40, },
	{ 0, 0, 0, 3, 2, 40, },
	{ 2, 0, 0, 3, 2, 40, },
	{ 1, 0, 0, 3, 2, 40, },
	{ 0, 0, 0, 3, 3, 40, },
	{ 2, 0, 0, 3, 3, 40, },
	{ 1, 0, 0, 3, 3, 40, },
	{ 0, 0, 0, 3, 4, 40, },
	{ 2, 0, 0, 3, 4, 40, },
	{ 1, 0, 0, 3, 4, 40, },
	{ 0, 0, 0, 3, 5, 40, },
	{ 2, 0, 0, 3, 5, 40, },
	{ 1, 0, 0, 3, 5, 40, },
	{ 0, 0, 0, 3, 6, 40, },
	{ 2, 0, 0, 3, 6, 40, },
	{ 1, 0, 0, 3, 6, 40, },
	{ 0, 0, 0, 3, 7, 40, },
	{ 2, 0, 0, 3, 7, 40, },
	{ 1, 0, 0, 3, 7, 40, },
	{ 0, 0, 0, 3, 8, 40, },
	{ 2, 0, 0, 3, 8, 40, },
	{ 1, 0, 0, 3, 8, 40, },
	{ 0, 0, 0, 3, 9, 40, },
	{ 2, 0, 0, 3, 9, 40, },
	{ 1, 0, 0, 3, 9, 40, },
	{ 0, 0, 0, 3, 10, 40, },
	{ 2, 0, 0, 3, 10, 40, },
	{ 1, 0, 0, 3, 10, 40, },
	{ 0, 0, 0, 3, 11, 28, },
	{ 2, 0, 0, 3, 11, 40, },
	{ 1, 0, 0, 3, 11, 40, },
	{ 0, 0, 0, 3, 12, 63, },
	{ 2, 0, 0, 3, 12, 40, },
	{ 1, 0, 0, 3, 12, 40, },
	{ 0, 0, 0, 3, 13, 63, },
	{ 2, 0, 0, 3, 13, 40, },
	{ 1, 0, 0, 3, 13, 40, },
	{ 0, 0, 0, 3, 14, 63, },
	{ 2, 0, 0, 3, 14, 63, },
	{ 1, 0, 0, 3, 14, 63, },
	{ 0, 0, 0, 6, 1, 32, },
	{ 2, 0, 0, 6, 1, 40, },
	{ 1, 0, 0, 6, 1, 40, },
	{ 0, 0, 0, 6, 2, 40, },
	{ 2, 0, 0, 6, 2, 40, },
	{ 1, 0, 0, 6, 2, 40, },
	{ 0, 0, 0, 6, 3, 40, },
	{ 2, 0, 0, 6, 3, 40, },
	{ 1, 0, 0, 6, 3, 40, },
	{ 0, 0, 0, 6, 4, 40, },
	{ 2, 0, 0, 6, 4, 40, },
	{ 1, 0, 0, 6, 4, 40, },
	{ 0, 0, 0, 6, 5, 40, },
	{ 2, 0, 0, 6, 5, 40, },
	{ 1, 0, 0, 6, 5, 40, },
	{ 0, 0, 0, 6, 6, 40, },
	{ 2, 0, 0, 6, 6, 40, },
	{ 1, 0, 0, 6, 6, 40, },
	{ 0, 0, 0, 6, 7, 40, },
	{ 2, 0, 0, 6, 7, 40, },
	{ 1, 0, 0, 6, 7, 40, },
	{ 0, 0, 0, 6, 8, 40, },
	{ 2, 0, 0, 6, 8, 40, },
	{ 1, 0, 0, 6, 8, 40, },
	{ 0, 0, 0, 6, 9, 40, },
	{ 2, 0, 0, 6, 9, 40, },
	{ 1, 0, 0, 6, 9, 40, },
	{ 0, 0, 0, 6, 10, 40, },
	{ 2, 0, 0, 6, 10, 40, },
	{ 1, 0, 0, 6, 10, 40, },
	{ 0, 0, 0, 6, 11, 28, },
	{ 2, 0, 0, 6, 11, 40, },
	{ 1, 0, 0, 6, 11, 40, },
	{ 0, 0, 0, 6, 12, 63, },
	{ 2, 0, 0, 6, 12, 40, },
	{ 1, 0, 0, 6, 12, 40, },
	{ 0, 0, 0, 6, 13, 63, },
	{ 2, 0, 0, 6, 13, 40, },
	{ 1, 0, 0, 6, 13, 40, },
	{ 0, 0, 0, 6, 14, 63, },
	{ 2, 0, 0, 6, 14, 63, },
	{ 1, 0, 0, 6, 14, 63, },
	{ 0, 0, 0, 7, 1, 32, },
	{ 2, 0, 0, 7, 1, 40, },
	{ 1, 0, 0, 7, 1, 40, },
	{ 0, 0, 0, 7, 2, 40, },
	{ 2, 0, 0, 7, 2, 40, },
	{ 1, 0, 0, 7, 2, 40, },
	{ 0, 0, 0, 7, 3, 40, },
	{ 2, 0, 0, 7, 3, 40, },
	{ 1, 0, 0, 7, 3, 40, },
	{ 0, 0, 0, 7, 4, 40, },
	{ 2, 0, 0, 7, 4, 40, },
	{ 1, 0, 0, 7, 4, 40, },
	{ 0, 0, 0, 7, 5, 40, },
	{ 2, 0, 0, 7, 5, 40, },
	{ 1, 0, 0, 7, 5, 40, },
	{ 0, 0, 0, 7, 6, 40, },
	{ 2, 0, 0, 7, 6, 40, },
	{ 1, 0, 0, 7, 6, 40, },
	{ 0, 0, 0, 7, 7, 40, },
	{ 2, 0, 0, 7, 7, 40, },
	{ 1, 0, 0, 7, 7, 40, },
	{ 0, 0, 0, 7, 8, 40, },
	{ 2, 0, 0, 7, 8, 40, },
	{ 1, 0, 0, 7, 8, 40, },
	{ 0, 0, 0, 7, 9, 40, },
	{ 2, 0, 0, 7, 9, 40, },
	{ 1, 0, 0, 7, 9, 40, },
	{ 0, 0, 0, 7, 10, 40, },
	{ 2, 0, 0, 7, 10, 40, },
	{ 1, 0, 0, 7, 10, 40, },
	{ 0, 0, 0, 7, 11, 28, },
	{ 2, 0, 0, 7, 11, 40, },
	{ 1, 0, 0, 7, 11, 40, },
	{ 0, 0, 0, 7, 12, 63, },
	{ 2, 0, 0, 7, 12, 40, },
	{ 1, 0, 0, 7, 12, 40, },
	{ 0, 0, 0, 7, 13, 63, },
	{ 2, 0, 0, 7, 13, 40, },
	{ 1, 0, 0, 7, 13, 40, },
	{ 0, 0, 0, 7, 14, 63, },
	{ 2, 0, 0, 7, 14, 63, },
	{ 1, 0, 0, 7, 14, 63, },
	{ 0, 0, 1, 2, 1, 63, },
	{ 2, 0, 1, 2, 1, 63, },
	{ 1, 0, 1, 2, 1, 63, },
	{ 0, 0, 1, 2, 2, 63, },
	{ 2, 0, 1, 2, 2, 63, },
	{ 1, 0, 1, 2, 2, 63, },
	{ 0, 0, 1, 2, 3, 30, },
	{ 2, 0, 1, 2, 3, 34, },
	{ 1, 0, 1, 2, 3, 34, },
	{ 0, 0, 1, 2, 4, 34, },
	{ 2, 0, 1, 2, 4, 34, },
	{ 1, 0, 1, 2, 4, 34, },
	{ 0, 0, 1, 2, 5, 34, },
	{ 2, 0, 1, 2, 5, 34, },
	{ 1, 0, 1, 2, 5, 34, },
	{ 0, 0, 1, 2, 6, 34, },
	{ 2, 0, 1, 2, 6, 34, },
	{ 1, 0, 1, 2, 6, 34, },
	{ 0, 0, 1, 2, 7, 34, },
	{ 2, 0, 1, 2, 7, 34, },
	{ 1, 0, 1, 2, 7, 34, },
	{ 0, 0, 1, 2, 8, 34, },
	{ 2, 0, 1, 2, 8, 34, },
	{ 1, 0, 1, 2, 8, 34, },
	{ 0, 0, 1, 2, 9, 34, },
	{ 2, 0, 1, 2, 9, 34, },
	{ 1, 0, 1, 2, 9, 34, },
	{ 0, 0, 1, 2, 10, 34, },
	{ 2, 0, 1, 2, 10, 34, },
	{ 1, 0, 1, 2, 10, 34, },
	{ 0, 0, 1, 2, 11, 28, },
	{ 2, 0, 1, 2, 11, 34, },
	{ 1, 0, 1, 2, 11, 34, },
	{ 0, 0, 1, 2, 12, 63, },
	{ 2, 0, 1, 2, 12, 34, },
	{ 1, 0, 1, 2, 12, 34, },
	{ 0, 0, 1, 2, 13, 63, },
	{ 2, 0, 1, 2, 13, 34, },
	{ 1, 0, 1, 2, 13, 34, },
	{ 0, 0, 1, 2, 14, 63, },
	{ 2, 0, 1, 2, 14, 63, },
	{ 1, 0, 1, 2, 14, 63, },
	{ 0, 0, 1, 3, 1, 63, },
	{ 2, 0, 1, 3, 1, 63, },
	{ 1, 0, 1, 3, 1, 63, },
	{ 0, 0, 1, 3, 2, 63, },
	{ 2, 0, 1, 3, 2, 63, },
	{ 1, 0, 1, 3, 2, 63, },
	{ 0, 0, 1, 3, 3, 30, },
	{ 2, 0, 1, 3, 3, 34, },
	{ 1, 0, 1, 3, 3, 34, },
	{ 0, 0, 1, 3, 4, 34, },
	{ 2, 0, 1, 3, 4, 34, },
	{ 1, 0, 1, 3, 4, 34, },
	{ 0, 0, 1, 3, 5, 34, },
	{ 2, 0, 1, 3, 5, 34, },
	{ 1, 0, 1, 3, 5, 34, },
	{ 0, 0, 1, 3, 6, 34, },
	{ 2, 0, 1, 3, 6, 34, },
	{ 1, 0, 1, 3, 6, 34, },
	{ 0, 0, 1, 3, 7, 34, },
	{ 2, 0, 1, 3, 7, 34, },
	{ 1, 0, 1, 3, 7, 34, },
	{ 0, 0, 1, 3, 8, 34, },
	{ 2, 0, 1, 3, 8, 34, },
	{ 1, 0, 1, 3, 8, 34, },
	{ 0, 0, 1, 3, 9, 34, },
	{ 2, 0, 1, 3, 9, 34, },
	{ 1, 0, 1, 3, 9, 34, },
	{ 0, 0, 1, 3, 10, 34, },
	{ 2, 0, 1, 3, 10, 34, },
	{ 1, 0, 1, 3, 10, 34, },
	{ 0, 0, 1, 3, 11, 28, },
	{ 2, 0, 1, 3, 11, 34, },
	{ 1, 0, 1, 3, 11, 34, },
	{ 0, 0, 1, 3, 12, 63, },
	{ 2, 0, 1, 3, 12, 34, },
	{ 1, 0, 1, 3, 12, 34, },
	{ 0, 0, 1, 3, 13, 63, },
	{ 2, 0, 1, 3, 13, 34, },
	{ 1, 0, 1, 3, 13, 34, },
	{ 0, 0, 1, 3, 14, 63, },
	{ 2, 0, 1, 3, 14, 63, },
	{ 1, 0, 1, 3, 14, 63, },
	{ 0, 0, 1, 6, 1, 63, },
	{ 2, 0, 1, 6, 1, 63, },
	{ 1, 0, 1, 6, 1, 63, },
	{ 0, 0, 1, 6, 2, 63, },
	{ 2, 0, 1, 6, 2, 63, },
	{ 1, 0, 1, 6, 2, 63, },
	{ 0, 0, 1, 6, 3, 30, },
	{ 2, 0, 1, 6, 3, 34, },
	{ 1, 0, 1, 6, 3, 34, },
	{ 0, 0, 1, 6, 4, 34, },
	{ 2, 0, 1, 6, 4, 34, },
	{ 1, 0, 1, 6, 4, 34, },
	{ 0, 0, 1, 6, 5, 34, },
	{ 2, 0, 1, 6, 5, 34, },
	{ 1, 0, 1, 6, 5, 34, },
	{ 0, 0, 1, 6, 6, 34, },
	{ 2, 0, 1, 6, 6, 34, },
	{ 1, 0, 1, 6, 6, 34, },
	{ 0, 0, 1, 6, 7, 34, },
	{ 2, 0, 1, 6, 7, 34, },
	{ 1, 0, 1, 6, 7, 34, },
	{ 0, 0, 1, 6, 8, 34, },
	{ 2, 0, 1, 6, 8, 34, },
	{ 1, 0, 1, 6, 8, 34, },
	{ 0, 0, 1, 6, 9, 34, },
	{ 2, 0, 1, 6, 9, 34, },
	{ 1, 0, 1, 6, 9, 34, },
	{ 0, 0, 1, 6, 10, 34, },
	{ 2, 0, 1, 6, 10, 34, },
	{ 1, 0, 1, 6, 10, 34, },
	{ 0, 0, 1, 6, 11, 28, },
	{ 2, 0, 1, 6, 11, 34, },
	{ 1, 0, 1, 6, 11, 34, },
	{ 0, 0, 1, 6, 12, 63, },
	{ 2, 0, 1, 6, 12, 34, },
	{ 1, 0, 1, 6, 12, 34, },
	{ 0, 0, 1, 6, 13, 63, },
	{ 2, 0, 1, 6, 13, 34, },
	{ 1, 0, 1, 6, 13, 34, },
	{ 0, 0, 1, 6, 14, 63, },
	{ 2, 0, 1, 6, 14, 63, },
	{ 1, 0, 1, 6, 14, 63, },
	{ 0, 0, 1, 7, 1, 63, },
	{ 2, 0, 1, 7, 1, 63, },
	{ 1, 0, 1, 7, 1, 63, },
	{ 0, 0, 1, 7, 2, 63, },
	{ 2, 0, 1, 7, 2, 63, },
	{ 1, 0, 1, 7, 2, 63, },
	{ 0, 0, 1, 7, 3, 30, },
	{ 2, 0, 1, 7, 3, 34, },
	{ 1, 0, 1, 7, 3, 34, },
	{ 0, 0, 1, 7, 4, 34, },
	{ 2, 0, 1, 7, 4, 34, },
	{ 1, 0, 1, 7, 4, 34, },
	{ 0, 0, 1, 7, 5, 34, },
	{ 2, 0, 1, 7, 5, 34, },
	{ 1, 0, 1, 7, 5, 34, },
	{ 0, 0, 1, 7, 6, 34, },
	{ 2, 0, 1, 7, 6, 34, },
	{ 1, 0, 1, 7, 6, 34, },
	{ 0, 0, 1, 7, 7, 34, },
	{ 2, 0, 1, 7, 7, 34, },
	{ 1, 0, 1, 7, 7, 34, },
	{ 0, 0, 1, 7, 8, 34, },
	{ 2, 0, 1, 7, 8, 34, },
	{ 1, 0, 1, 7, 8, 34, },
	{ 0, 0, 1, 7, 9, 34, },
	{ 2, 0, 1, 7, 9, 34, },
	{ 1, 0, 1, 7, 9, 34, },
	{ 0, 0, 1, 7, 10, 34, },
	{ 2, 0, 1, 7, 10, 34, },
	{ 1, 0, 1, 7, 10, 34, },
	{ 0, 0, 1, 7, 11, 28, },
	{ 2, 0, 1, 7, 11, 34, },
	{ 1, 0, 1, 7, 11, 34, },
	{ 0, 0, 1, 7, 12, 63, },
	{ 2, 0, 1, 7, 12, 34, },
	{ 1, 0, 1, 7, 12, 34, },
	{ 0, 0, 1, 7, 13, 63, },
	{ 2, 0, 1, 7, 13, 34, },
	{ 1, 0, 1, 7, 13, 34, },
	{ 0, 0, 1, 7, 14, 63, },
	{ 2, 0, 1, 7, 14, 63, },
	{ 1, 0, 1, 7, 14, 63, },
	{ 0, 1, 0, 1, 36, 42, },
	{ 2, 1, 0, 1, 36, 42, },
	{ 1, 1, 0, 1, 36, 42, },
	{ 0, 1, 0, 1, 40, 42, },
	{ 2, 1, 0, 1, 40, 42, },
	{ 1, 1, 0, 1, 40, 42, },
	{ 0, 1, 0, 1, 44, 42, },
	{ 2, 1, 0, 1, 44, 42, },
	{ 1, 1, 0, 1, 44, 42, },
	{ 0, 1, 0, 1, 48, 42, },
	{ 2, 1, 0, 1, 48, 42, },
	{ 1, 1, 0, 1, 48, 42, },
	{ 0, 1, 0, 1, 52, 42, },
	{ 2, 1, 0, 1, 52, 42, },
	{ 1, 1, 0, 1, 52, 42, },
	{ 0, 1, 0, 1, 56, 42, },
	{ 2, 1, 0, 1, 56, 42, },
	{ 1, 1, 0, 1, 56, 42, },
	{ 0, 1, 0, 1, 60, 42, },
	{ 2, 1, 0, 1, 60, 42, },
	{ 1, 1, 0, 1, 60, 42, },
	{ 0, 1, 0, 1, 64, 42, },
	{ 2, 1, 0, 1, 64, 42, },
	{ 1, 1, 0, 1, 64, 42, },
	{ 0, 1, 0, 1, 100, 42, },
	{ 2, 1, 0, 1, 100, 42, },
	{ 1, 1, 0, 1, 100, 42, },
	{ 0, 1, 0, 1, 104, 42, },
	{ 2, 1, 0, 1, 104, 42, },
	{ 1, 1, 0, 1, 104, 42, },
	{ 0, 1, 0, 1, 108, 42, },
	{ 2, 1, 0, 1, 108, 42, },
	{ 1, 1, 0, 1, 108, 42, },
	{ 0, 1, 0, 1, 112, 42, },
	{ 2, 1, 0, 1, 112, 42, },
	{ 1, 1, 0, 1, 112, 42, },
	{ 0, 1, 0, 1, 116, 42, },
	{ 2, 1, 0, 1, 116, 42, },
	{ 1, 1, 0, 1, 116, 42, },
	{ 0, 1, 0, 1, 120, 42, },
	{ 2, 1, 0, 1, 120, 42, },
	{ 1, 1, 0, 1, 120, 42, },
	{ 0, 1, 0, 1, 124, 42, },
	{ 2, 1, 0, 1, 124, 42, },
	{ 1, 1, 0, 1, 124, 42, },
	{ 0, 1, 0, 1, 128, 42, },
	{ 2, 1, 0, 1, 128, 42, },
	{ 1, 1, 0, 1, 128, 42, },
	{ 0, 1, 0, 1, 132, 42, },
	{ 2, 1, 0, 1, 132, 42, },
	{ 1, 1, 0, 1, 132, 42, },
	{ 0, 1, 0, 1, 136, 42, },
	{ 2, 1, 0, 1, 136, 42, },
	{ 1, 1, 0, 1, 136, 42, },
	{ 0, 1, 0, 1, 140, 40, },
	{ 2, 1, 0, 1, 140, 40, },
	{ 1, 1, 0, 1, 140, 40, },
	{ 0, 1, 0, 1, 149, 44, },
	{ 2, 1, 0, 1, 149, 44, },
	{ 1, 1, 0, 1, 149, 63, },
	{ 0, 1, 0, 1, 153, 44, },
	{ 2, 1, 0, 1, 153, 44, },
	{ 1, 1, 0, 1, 153, 63, },
	{ 0, 1, 0, 1, 157, 44, },
	{ 2, 1, 0, 1, 157, 44, },
	{ 1, 1, 0, 1, 157, 63, },
	{ 0, 1, 0, 1, 161, 44, },
	{ 2, 1, 0, 1, 161, 44, },
	{ 1, 1, 0, 1, 161, 63, },
	{ 0, 1, 0, 1, 165, 44, },
	{ 2, 1, 0, 1, 165, 44, },
	{ 1, 1, 0, 1, 165, 63, },
	{ 0, 1, 0, 2, 36, 32, },
	{ 2, 1, 0, 2, 36, 32, },
	{ 1, 1, 0, 2, 36, 32, },
	{ 0, 1, 0, 2, 40, 32, },
	{ 2, 1, 0, 2, 40, 32, },
	{ 1, 1, 0, 2, 40, 32, },
	{ 0, 1, 0, 2, 44, 32, },
	{ 2, 1, 0, 2, 44, 32, },
	{ 1, 1, 0, 2, 44, 32, },
	{ 0, 1, 0, 2, 48, 36, },
	{ 2, 1, 0, 2, 48, 36, },
	{ 1, 1, 0, 2, 48, 36, },
	{ 0, 1, 0, 2, 52, 36, },
	{ 2, 1, 0, 2, 52, 36, },
	{ 1, 1, 0, 2, 52, 36, },
	{ 0, 1, 0, 2, 56, 32, },
	{ 2, 1, 0, 2, 56, 32, },
	{ 1, 1, 0, 2, 56, 32, },
	{ 0, 1, 0, 2, 60, 32, },
	{ 2, 1, 0, 2, 60, 32, },
	{ 1, 1, 0, 2, 60, 32, },
	{ 0, 1, 0, 2, 64, 32, },
	{ 2, 1, 0, 2, 64, 32, },
	{ 1, 1, 0, 2, 64, 32, },
	{ 0, 1, 0, 2, 100, 32, },
	{ 2, 1, 0, 2, 100, 32, },
	{ 1, 1, 0, 2, 100, 32, },
	{ 0, 1, 0, 2, 104, 32, },
	{ 2, 1, 0, 2, 104, 32, },
	{ 1, 1, 0, 2, 104, 32, },
	{ 0, 1, 0, 2, 108, 32, },
	{ 2, 1, 0, 2, 108, 32, },
	{ 1, 1, 0, 2, 108, 32, },
	{ 0, 1, 0, 2, 112, 32, },
	{ 2, 1, 0, 2, 112, 32, },
	{ 1, 1, 0, 2, 112, 32, },
	{ 0, 1, 0, 2, 116, 32, },
	{ 2, 1, 0, 2, 116, 32, },
	{ 1, 1, 0, 2, 116, 32, },
	{ 0, 1, 0, 2, 120, 32, },
	{ 2, 1, 0, 2, 120, 32, },
	{ 1, 1, 0, 2, 120, 32, },
	{ 0, 1, 0, 2, 124, 32, },
	{ 2, 1, 0, 2, 124, 32, },
	{ 1, 1, 0, 2, 124, 32, },
	{ 0, 1, 0, 2, 128, 32, },
	{ 2, 1, 0, 2, 128, 32, },
	{ 1, 1, 0, 2, 128, 32, },
	{ 0, 1, 0, 2, 132, 32, },
	{ 2, 1, 0, 2, 132, 32, },
	{ 1, 1, 0, 2, 132, 32, },
	{ 0, 1, 0, 2, 136, 32, },
	{ 2, 1, 0, 2, 136, 32, },
	{ 1, 1, 0, 2, 136, 32, },
	{ 0, 1, 0, 2, 140, 30, },
	{ 2, 1, 0, 2, 140, 30, },
	{ 1, 1, 0, 2, 140, 30, },
	{ 0, 1, 0, 2, 149, 40, },
	{ 2, 1, 0, 2, 149, 40, },
	{ 1, 1, 0, 2, 149, 63, },
	{ 0, 1, 0, 2, 153, 40, },
	{ 2, 1, 0, 2, 153, 40, },
	{ 1, 1, 0, 2, 153, 63, },
	{ 0, 1, 0, 2, 157, 40, },
	{ 2, 1, 0, 2, 157, 40, },
	{ 1, 1, 0, 2, 157, 63, },
	{ 0, 1, 0, 2, 161, 40, },
	{ 2, 1, 0, 2, 161, 40, },
	{ 1, 1, 0, 2, 161, 63, },
	{ 0, 1, 0, 2, 165, 42, },
	{ 2, 1, 0, 2, 165, 42, },
	{ 1, 1, 0, 2, 165, 63, },
	{ 0, 1, 0, 3, 36, 32, },
	{ 2, 1, 0, 3, 36, 32, },
	{ 1, 1, 0, 3, 36, 32, },
	{ 0, 1, 0, 3, 40, 32, },
	{ 2, 1, 0, 3, 40, 32, },
	{ 1, 1, 0, 3, 40, 32, },
	{ 0, 1, 0, 3, 44, 32, },
	{ 2, 1, 0, 3, 44, 32, },
	{ 1, 1, 0, 3, 44, 32, },
	{ 0, 1, 0, 3, 48, 36, },
	{ 2, 1, 0, 3, 48, 36, },
	{ 1, 1, 0, 3, 48, 36, },
	{ 0, 1, 0, 3, 52, 36, },
	{ 2, 1, 0, 3, 52, 36, },
	{ 1, 1, 0, 3, 52, 36, },
	{ 0, 1, 0, 3, 56, 32, },
	{ 2, 1, 0, 3, 56, 32, },
	{ 1, 1, 0, 3, 56, 32, },
	{ 0, 1, 0, 3, 60, 32, },
	{ 2, 1, 0, 3, 60, 32, },
	{ 1, 1, 0, 3, 60, 32, },
	{ 0, 1, 0, 3, 64, 32, },
	{ 2, 1, 0, 3, 64, 32, },
	{ 1, 1, 0, 3, 64, 32, },
	{ 0, 1, 0, 3, 100, 32, },
	{ 2, 1, 0, 3, 100, 32, },
	{ 1, 1, 0, 3, 100, 32, },
	{ 0, 1, 0, 3, 104, 32, },
	{ 2, 1, 0, 3, 104, 32, },
	{ 1, 1, 0, 3, 104, 32, },
	{ 0, 1, 0, 3, 108, 32, },
	{ 2, 1, 0, 3, 108, 32, },
	{ 1, 1, 0, 3, 108, 32, },
	{ 0, 1, 0, 3, 112, 32, },
	{ 2, 1, 0, 3, 112, 32, },
	{ 1, 1, 0, 3, 112, 32, },
	{ 0, 1, 0, 3, 116, 32, },
	{ 2, 1, 0, 3, 116, 32, },
	{ 1, 1, 0, 3, 116, 32, },
	{ 0, 1, 0, 3, 120, 32, },
	{ 2, 1, 0, 3, 120, 32, },
	{ 1, 1, 0, 3, 120, 32, },
	{ 0, 1, 0, 3, 124, 32, },
	{ 2, 1, 0, 3, 124, 32, },
	{ 1, 1, 0, 3, 124, 32, },
	{ 0, 1, 0, 3, 128, 32, },
	{ 2, 1, 0, 3, 128, 32, },
	{ 1, 1, 0, 3, 128, 32, },
	{ 0, 1, 0, 3, 132, 32, },
	{ 2, 1, 0, 3, 132, 32, },
	{ 1, 1, 0, 3, 132, 32, },
	{ 0, 1, 0, 3, 136, 32, },
	{ 2, 1, 0, 3, 136, 32, },
	{ 1, 1, 0, 3, 136, 32, },
	{ 0, 1, 0, 3, 140, 30, },
	{ 2, 1, 0, 3, 140, 30, },
	{ 1, 1, 0, 3, 140, 30, },
	{ 0, 1, 0, 3, 149, 40, },
	{ 2, 1, 0, 3, 149, 40, },
	{ 1, 1, 0, 3, 149, 63, },
	{ 0, 1, 0, 3, 153, 40, },
	{ 2, 1, 0, 3, 153, 40, },
	{ 1, 1, 0, 3, 153, 63, },
	{ 0, 1, 0, 3, 157, 40, },
	{ 2, 1, 0, 3, 157, 40, },
	{ 1, 1, 0, 3, 157, 63, },
	{ 0, 1, 0, 3, 161, 40, },
	{ 2, 1, 0, 3, 161, 40, },
	{ 1, 1, 0, 3, 161, 63, },
	{ 0, 1, 0, 3, 165, 42, },
	{ 2, 1, 0, 3, 165, 42, },
	{ 1, 1, 0, 3, 165, 63, },
	{ 0, 1, 0, 6, 36, 32, },
	{ 2, 1, 0, 6, 36, 32, },
	{ 1, 1, 0, 6, 36, 32, },
	{ 0, 1, 0, 6, 40, 32, },
	{ 2, 1, 0, 6, 40, 32, },
	{ 1, 1, 0, 6, 40, 32, },
	{ 0, 1, 0, 6, 44, 32, },
	{ 2, 1, 0, 6, 44, 32, },
	{ 1, 1, 0, 6, 44, 32, },
	{ 0, 1, 0, 6, 48, 36, },
	{ 2, 1, 0, 6, 48, 36, },
	{ 1, 1, 0, 6, 48, 36, },
	{ 0, 1, 0, 6, 52, 36, },
	{ 2, 1, 0, 6, 52, 36, },
	{ 1, 1, 0, 6, 52, 36, },
	{ 0, 1, 0, 6, 56, 32, },
	{ 2, 1, 0, 6, 56, 32, },
	{ 1, 1, 0, 6, 56, 32, },
	{ 0, 1, 0, 6, 60, 32, },
	{ 2, 1, 0, 6, 60, 32, },
	{ 1, 1, 0, 6, 60, 32, },
	{ 0, 1, 0, 6, 64, 32, },
	{ 2, 1, 0, 6, 64, 32, },
	{ 1, 1, 0, 6, 64, 32, },
	{ 0, 1, 0, 6, 100, 32, },
	{ 2, 1, 0, 6, 100, 32, },
	{ 1, 1, 0, 6, 100, 32, },
	{ 0, 1, 0, 6, 104, 32, },
	{ 2, 1, 0, 6, 104, 32, },
	{ 1, 1, 0, 6, 104, 32, },
	{ 0, 1, 0, 6, 108, 32, },
	{ 2, 1, 0, 6, 108, 32, },
	{ 1, 1, 0, 6, 108, 32, },
	{ 0, 1, 0, 6, 112, 32, },
	{ 2, 1, 0, 6, 112, 32, },
	{ 1, 1, 0, 6, 112, 32, },
	{ 0, 1, 0, 6, 116, 32, },
	{ 2, 1, 0, 6, 116, 32, },
	{ 1, 1, 0, 6, 116, 32, },
	{ 0, 1, 0, 6, 120, 32, },
	{ 2, 1, 0, 6, 120, 32, },
	{ 1, 1, 0, 6, 120, 32, },
	{ 0, 1, 0, 6, 124, 32, },
	{ 2, 1, 0, 6, 124, 32, },
	{ 1, 1, 0, 6, 124, 32, },
	{ 0, 1, 0, 6, 128, 32, },
	{ 2, 1, 0, 6, 128, 32, },
	{ 1, 1, 0, 6, 128, 32, },
	{ 0, 1, 0, 6, 132, 32, },
	{ 2, 1, 0, 6, 132, 32, },
	{ 1, 1, 0, 6, 132, 32, },
	{ 0, 1, 0, 6, 136, 32, },
	{ 2, 1, 0, 6, 136, 32, },
	{ 1, 1, 0, 6, 136, 32, },
	{ 0, 1, 0, 6, 140, 30, },
	{ 2, 1, 0, 6, 140, 30, },
	{ 1, 1, 0, 6, 140, 30, },
	{ 0, 1, 0, 6, 149, 40, },
	{ 2, 1, 0, 6, 149, 40, },
	{ 1, 1, 0, 6, 149, 63, },
	{ 0, 1, 0, 6, 153, 40, },
	{ 2, 1, 0, 6, 153, 40, },
	{ 1, 1, 0, 6, 153, 63, },
	{ 0, 1, 0, 6, 157, 40, },
	{ 2, 1, 0, 6, 157, 40, },
	{ 1, 1, 0, 6, 157, 63, },
	{ 0, 1, 0, 6, 161, 40, },
	{ 2, 1, 0, 6, 161, 40, },
	{ 1, 1, 0, 6, 161, 63, },
	{ 0, 1, 0, 6, 165, 42, },
	{ 2, 1, 0, 6, 165, 42, },
	{ 1, 1, 0, 6, 165, 63, },
	{ 0, 1, 0, 7, 36, 32, },
	{ 2, 1, 0, 7, 36, 32, },
	{ 1, 1, 0, 7, 36, 32, },
	{ 0, 1, 0, 7, 40, 32, },
	{ 2, 1, 0, 7, 40, 32, },
	{ 1, 1, 0, 7, 40, 32, },
	{ 0, 1, 0, 7, 44, 32, },
	{ 2, 1, 0, 7, 44, 32, },
	{ 1, 1, 0, 7, 44, 32, },
	{ 0, 1, 0, 7, 48, 36, },
	{ 2, 1, 0, 7, 48, 36, },
	{ 1, 1, 0, 7, 48, 36, },
	{ 0, 1, 0, 7, 52, 36, },
	{ 2, 1, 0, 7, 52, 36, },
	{ 1, 1, 0, 7, 52, 36, },
	{ 0, 1, 0, 7, 56, 32, },
	{ 2, 1, 0, 7, 56, 32, },
	{ 1, 1, 0, 7, 56, 32, },
	{ 0, 1, 0, 7, 60, 32, },
	{ 2, 1, 0, 7, 60, 32, },
	{ 1, 1, 0, 7, 60, 32, },
	{ 0, 1, 0, 7, 64, 32, },
	{ 2, 1, 0, 7, 64, 32, },
	{ 1, 1, 0, 7, 64, 32, },
	{ 0, 1, 0, 7, 100, 32, },
	{ 2, 1, 0, 7, 100, 32, },
	{ 1, 1, 0, 7, 100, 32, },
	{ 0, 1, 0, 7, 104, 32, },
	{ 2, 1, 0, 7, 104, 32, },
	{ 1, 1, 0, 7, 104, 32, },
	{ 0, 1, 0, 7, 108, 32, },
	{ 2, 1, 0, 7, 108, 32, },
	{ 1, 1, 0, 7, 108, 32, },
	{ 0, 1, 0, 7, 112, 32, },
	{ 2, 1, 0, 7, 112, 32, },
	{ 1, 1, 0, 7, 112, 32, },
	{ 0, 1, 0, 7, 116, 32, },
	{ 2, 1, 0, 7, 116, 32, },
	{ 1, 1, 0, 7, 116, 32, },
	{ 0, 1, 0, 7, 120, 32, },
	{ 2, 1, 0, 7, 120, 32, },
	{ 1, 1, 0, 7, 120, 32, },
	{ 0, 1, 0, 7, 124, 32, },
	{ 2, 1, 0, 7, 124, 32, },
	{ 1, 1, 0, 7, 124, 32, },
	{ 0, 1, 0, 7, 128, 32, },
	{ 2, 1, 0, 7, 128, 32, },
	{ 1, 1, 0, 7, 128, 32, },
	{ 0, 1, 0, 7, 132, 32, },
	{ 2, 1, 0, 7, 132, 32, },
	{ 1, 1, 0, 7, 132, 32, },
	{ 0, 1, 0, 7, 136, 32, },
	{ 2, 1, 0, 7, 136, 32, },
	{ 1, 1, 0, 7, 136, 32, },
	{ 0, 1, 0, 7, 140, 30, },
	{ 2, 1, 0, 7, 140, 30, },
	{ 1, 1, 0, 7, 140, 30, },
	{ 0, 1, 0, 7, 149, 40, },
	{ 2, 1, 0, 7, 149, 40, },
	{ 1, 1, 0, 7, 149, 63, },
	{ 0, 1, 0, 7, 153, 40, },
	{ 2, 1, 0, 7, 153, 40, },
	{ 1, 1, 0, 7, 153, 63, },
	{ 0, 1, 0, 7, 157, 40, },
	{ 2, 1, 0, 7, 157, 40, },
	{ 1, 1, 0, 7, 157, 63, },
	{ 0, 1, 0, 7, 161, 40, },
	{ 2, 1, 0, 7, 161, 40, },
	{ 1, 1, 0, 7, 161, 63, },
	{ 0, 1, 0, 7, 165, 42, },
	{ 2, 1, 0, 7, 165, 42, },
	{ 1, 1, 0, 7, 165, 63, },
	{ 0, 1, 1, 2, 38, 32, },
	{ 2, 1, 1, 2, 38, 32, },
	{ 1, 1, 1, 2, 38, 32, },
	{ 0, 1, 1, 2, 46, 36, },
	{ 2, 1, 1, 2, 46, 36, },
	{ 1, 1, 1, 2, 46, 36, },
	{ 0, 1, 1, 2, 54, 36, },
	{ 2, 1, 1, 2, 54, 36, },
	{ 1, 1, 1, 2, 54, 36, },
	{ 0, 1, 1, 2, 62, 32, },
	{ 2, 1, 1, 2, 62, 32, },
	{ 1, 1, 1, 2, 62, 32, },
	{ 0, 1, 1, 2, 102, 30, },
	{ 2, 1, 1, 2, 102, 30, },
	{ 1, 1, 1, 2, 102, 30, },
	{ 0, 1, 1, 2, 110, 32, },
	{ 2, 1, 1, 2, 110, 32, },
	{ 1, 1, 1, 2, 110, 32, },
	{ 0, 1, 1, 2, 118, 32, },
	{ 2, 1, 1, 2, 118, 32, },
	{ 1, 1, 1, 2, 118, 32, },
	{ 0, 1, 1, 2, 126, 32, },
	{ 2, 1, 1, 2, 126, 32, },
	{ 1, 1, 1, 2, 126, 32, },
	{ 0, 1, 1, 2, 134, 36, },
	{ 2, 1, 1, 2, 134, 36, },
	{ 1, 1, 1, 2, 134, 36, },
	{ 0, 1, 1, 2, 151, 36, },
	{ 2, 1, 1, 2, 151, 36, },
	{ 1, 1, 1, 2, 151, 63, },
	{ 0, 1, 1, 2, 159, 40, },
	{ 2, 1, 1, 2, 159, 40, },
	{ 1, 1, 1, 2, 159, 63, },
	{ 0, 1, 1, 3, 38, 32, },
	{ 2, 1, 1, 3, 38, 32, },
	{ 1, 1, 1, 3, 38, 32, },
	{ 0, 1, 1, 3, 46, 36, },
	{ 2, 1, 1, 3, 46, 36, },
	{ 1, 1, 1, 3, 46, 36, },
	{ 0, 1, 1, 3, 54, 36, },
	{ 2, 1, 1, 3, 54, 36, },
	{ 1, 1, 1, 3, 54, 36, },
	{ 0, 1, 1, 3, 62, 32, },
	{ 2, 1, 1, 3, 62, 32, },
	{ 1, 1, 1, 3, 62, 32, },
	{ 0, 1, 1, 3, 102, 30, },
	{ 2, 1, 1, 3, 102, 30, },
	{ 1, 1, 1, 3, 102, 30, },
	{ 0, 1, 1, 3, 110, 32, },
	{ 2, 1, 1, 3, 110, 32, },
	{ 1, 1, 1, 3, 110, 32, },
	{ 0, 1, 1, 3, 118, 32, },
	{ 2, 1, 1, 3, 118, 32, },
	{ 1, 1, 1, 3, 118, 32, },
	{ 0, 1, 1, 3, 126, 32, },
	{ 2, 1, 1, 3, 126, 32, },
	{ 1, 1, 1, 3, 126, 32, },
	{ 0, 1, 1, 3, 134, 36, },
	{ 2, 1, 1, 3, 134, 36, },
	{ 1, 1, 1, 3, 134, 36, },
	{ 0, 1, 1, 3, 151, 36, },
	{ 2, 1, 1, 3, 151, 36, },
	{ 1, 1, 1, 3, 151, 63, },
	{ 0, 1, 1, 3, 159, 40, },
	{ 2, 1, 1, 3, 159, 40, },
	{ 1, 1, 1, 3, 159, 63, },
	{ 0, 1, 1, 6, 38, 32, },
	{ 2, 1, 1, 6, 38, 32, },
	{ 1, 1, 1, 6, 38, 32, },
	{ 0, 1, 1, 6, 46, 36, },
	{ 2, 1, 1, 6, 46, 36, },
	{ 1, 1, 1, 6, 46, 36, },
	{ 0, 1, 1, 6, 54, 36, },
	{ 2, 1, 1, 6, 54, 36, },
	{ 1, 1, 1, 6, 54, 36, },
	{ 0, 1, 1, 6, 62, 32, },
	{ 2, 1, 1, 6, 62, 32, },
	{ 1, 1, 1, 6, 62, 32, },
	{ 0, 1, 1, 6, 102, 30, },
	{ 2, 1, 1, 6, 102, 30, },
	{ 1, 1, 1, 6, 102, 30, },
	{ 0, 1, 1, 6, 110, 32, },
	{ 2, 1, 1, 6, 110, 32, },
	{ 1, 1, 1, 6, 110, 32, },
	{ 0, 1, 1, 6, 118, 32, },
	{ 2, 1, 1, 6, 118, 32, },
	{ 1, 1, 1, 6, 118, 32, },
	{ 0, 1, 1, 6, 126, 32, },
	{ 2, 1, 1, 6, 126, 32, },
	{ 1, 1, 1, 6, 126, 32, },
	{ 0, 1, 1, 6, 134, 36, },
	{ 2, 1, 1, 6, 134, 36, },
	{ 1, 1, 1, 6, 134, 36, },
	{ 0, 1, 1, 6, 151, 36, },
	{ 2, 1, 1, 6, 151, 36, },
	{ 1, 1, 1, 6, 151, 63, },
	{ 0, 1, 1, 6, 159, 40, },
	{ 2, 1, 1, 6, 159, 40, },
	{ 1, 1, 1, 6, 159, 63, },
	{ 0, 1, 1, 7, 38, 32, },
	{ 2, 1, 1, 7, 38, 32, },
	{ 1, 1, 1, 7, 38, 32, },
	{ 0, 1, 1, 7, 46, 36, },
	{ 2, 1, 1, 7, 46, 36, },
	{ 1, 1, 1, 7, 46, 36, },
	{ 0, 1, 1, 7, 54, 36, },
	{ 2, 1, 1, 7, 54, 36, },
	{ 1, 1, 1, 7, 54, 36, },
	{ 0, 1, 1, 7, 62, 32, },
	{ 2, 1, 1, 7, 62, 32, },
	{ 1, 1, 1, 7, 62, 32, },
	{ 0, 1, 1, 7, 102, 30, },
	{ 2, 1, 1, 7, 102, 30, },
	{ 1, 1, 1, 7, 102, 30, },
	{ 0, 1, 1, 7, 110, 32, },
	{ 2, 1, 1, 7, 110, 32, },
	{ 1, 1, 1, 7, 110, 32, },
	{ 0, 1, 1, 7, 118, 32, },
	{ 2, 1, 1, 7, 118, 32, },
	{ 1, 1, 1, 7, 118, 32, },
	{ 0, 1, 1, 7, 126, 32, },
	{ 2, 1, 1, 7, 126, 32, },
	{ 1, 1, 1, 7, 126, 32, },
	{ 0, 1, 1, 7, 134, 36, },
	{ 2, 1, 1, 7, 134, 36, },
	{ 1, 1, 1, 7, 134, 36, },
	{ 0, 1, 1, 7, 151, 36, },
	{ 2, 1, 1, 7, 151, 36, },
	{ 1, 1, 1, 7, 151, 63, },
	{ 0, 1, 1, 7, 159, 40, },
	{ 2, 1, 1, 7, 159, 40, },
	{ 1, 1, 1, 7, 159, 63, },
	{ 0, 1, 2, 4, 42, 34, },
	{ 2, 1, 2, 4, 42, 34, },
	{ 1, 1, 2, 4, 42, 34, },
	{ 0, 1, 2, 4, 58, 34, },
	{ 2, 1, 2, 4, 58, 34, },
	{ 1, 1, 2, 4, 58, 34, },
	{ 0, 1, 2, 4, 106, 32, },
	{ 2, 1, 2, 4, 106, 32, },
	{ 1, 1, 2, 4, 106, 32, },
	{ 0, 1, 2, 4, 122, 34, },
	{ 2, 1, 2, 4, 122, 34, },
	{ 1, 1, 2, 4, 122, 34, },
	{ 0, 1, 2, 4, 155, 34, },
	{ 2, 1, 2, 4, 155, 34, },
	{ 1, 1, 2, 4, 155, 63, },
	{ 0, 1, 2, 5, 42, 34, },
	{ 2, 1, 2, 5, 42, 34, },
	{ 1, 1, 2, 5, 42, 34, },
	{ 0, 1, 2, 5, 58, 34, },
	{ 2, 1, 2, 5, 58, 34, },
	{ 1, 1, 2, 5, 58, 34, },
	{ 0, 1, 2, 5, 106, 32, },
	{ 2, 1, 2, 5, 106, 32, },
	{ 1, 1, 2, 5, 106, 32, },
	{ 0, 1, 2, 5, 122, 34, },
	{ 2, 1, 2, 5, 122, 34, },
	{ 1, 1, 2, 5, 122, 34, },
	{ 0, 1, 2, 5, 155, 34, },
	{ 2, 1, 2, 5, 155, 34, },
	{ 1, 1, 2, 5, 155, 63, },
	{ 0, 1, 2, 8, 42, 34, },
	{ 2, 1, 2, 8, 42, 34, },
	{ 1, 1, 2, 8, 42, 34, },
	{ 0, 1, 2, 8, 58, 34, },
	{ 2, 1, 2, 8, 58, 34, },
	{ 1, 1, 2, 8, 58, 34, },
	{ 0, 1, 2, 8, 106, 32, },
	{ 2, 1, 2, 8, 106, 32, },
	{ 1, 1, 2, 8, 106, 32, },
	{ 0, 1, 2, 8, 122, 34, },
	{ 2, 1, 2, 8, 122, 34, },
	{ 1, 1, 2, 8, 122, 34, },
	{ 0, 1, 2, 8, 155, 34, },
	{ 2, 1, 2, 8, 155, 34, },
	{ 1, 1, 2, 8, 155, 63, },
	{ 0, 1, 2, 9, 42, 34, },
	{ 2, 1, 2, 9, 42, 34, },
	{ 1, 1, 2, 9, 42, 34, },
	{ 0, 1, 2, 9, 58, 34, },
	{ 2, 1, 2, 9, 58, 34, },
	{ 1, 1, 2, 9, 58, 34, },
	{ 0, 1, 2, 9, 106, 32, },
	{ 2, 1, 2, 9, 106, 32, },
	{ 1, 1, 2, 9, 106, 32, },
	{ 0, 1, 2, 9, 122, 34, },
	{ 2, 1, 2, 9, 122, 34, },
	{ 1, 1, 2, 9, 122, 34, },
	{ 0, 1, 2, 9, 155, 34, },
	{ 2, 1, 2, 9, 155, 34, },
	{ 1, 1, 2, 9, 155, 63, },
};

RTW_DECL_TABLE_TXPWR_LMT(rtw8814a_txpwr_lmt_type2);

static const struct rtw_txpwr_lmt_cfg_pair rtw8814a_txpwr_lmt_type3[] = {
	{ 0, 0, 0, 0, 1, 46, },
	{ 2, 0, 0, 0, 1, 40, },
	{ 1, 0, 0, 0, 1, 40, },
	{ 0, 0, 0, 0, 2, 46, },
	{ 2, 0, 0, 0, 2, 40, },
	{ 1, 0, 0, 0, 2, 40, },
	{ 0, 0, 0, 0, 3, 46, },
	{ 2, 0, 0, 0, 3, 40, },
	{ 1, 0, 0, 0, 3, 40, },
	{ 0, 0, 0, 0, 4, 46, },
	{ 2, 0, 0, 0, 4, 40, },
	{ 1, 0, 0, 0, 4, 40, },
	{ 0, 0, 0, 0, 5, 46, },
	{ 2, 0, 0, 0, 5, 40, },
	{ 1, 0, 0, 0, 5, 40, },
	{ 0, 0, 0, 0, 6, 46, },
	{ 2, 0, 0, 0, 6, 40, },
	{ 1, 0, 0, 0, 6, 40, },
	{ 0, 0, 0, 0, 7, 46, },
	{ 2, 0, 0, 0, 7, 40, },
	{ 1, 0, 0, 0, 7, 40, },
	{ 0, 0, 0, 0, 8, 46, },
	{ 2, 0, 0, 0, 8, 40, },
	{ 1, 0, 0, 0, 8, 40, },
	{ 0, 0, 0, 0, 9, 46, },
	{ 2, 0, 0, 0, 9, 40, },
	{ 1, 0, 0, 0, 9, 40, },
	{ 0, 0, 0, 0, 10, 46, },
	{ 2, 0, 0, 0, 10, 40, },
	{ 1, 0, 0, 0, 10, 40, },
	{ 0, 0, 0, 0, 11, 46, },
	{ 2, 0, 0, 0, 11, 40, },
	{ 1, 0, 0, 0, 11, 40, },
	{ 0, 0, 0, 0, 12, 63, },
	{ 2, 0, 0, 0, 12, 40, },
	{ 1, 0, 0, 0, 12, 40, },
	{ 0, 0, 0, 0, 13, 63, },
	{ 2, 0, 0, 0, 13, 40, },
	{ 1, 0, 0, 0, 13, 40, },
	{ 0, 0, 0, 0, 14, 63, },
	{ 2, 0, 0, 0, 14, 63, },
	{ 1, 0, 0, 0, 14, 40, },
	{ 0, 0, 0, 1, 1, 46, },
	{ 2, 0, 0, 1, 1, 40, },
	{ 1, 0, 0, 1, 1, 40, },
	{ 0, 0, 0, 1, 2, 46, },
	{ 2, 0, 0, 1, 2, 40, },
	{ 1, 0, 0, 1, 2, 40, },
	{ 0, 0, 0, 1, 3, 46, },
	{ 2, 0, 0, 1, 3, 40, },
	{ 1, 0, 0, 1, 3, 40, },
	{ 0, 0, 0, 1, 4, 46, },
	{ 2, 0, 0, 1, 4, 40, },
	{ 1, 0, 0, 1, 4, 40, },
	{ 0, 0, 0, 1, 5, 46, },
	{ 2, 0, 0, 1, 5, 40, },
	{ 1, 0, 0, 1, 5, 40, },
	{ 0, 0, 0, 1, 6, 46, },
	{ 2, 0, 0, 1, 6, 40, },
	{ 1, 0, 0, 1, 6, 40, },
	{ 0, 0, 0, 1, 7, 46, },
	{ 2, 0, 0, 1, 7, 40, },
	{ 1, 0, 0, 1, 7, 40, },
	{ 0, 0, 0, 1, 8, 46, },
	{ 2, 0, 0, 1, 8, 40, },
	{ 1, 0, 0, 1, 8, 40, },
	{ 0, 0, 0, 1, 9, 46, },
	{ 2, 0, 0, 1, 9, 40, },
	{ 1, 0, 0, 1, 9, 40, },
	{ 0, 0, 0, 1, 10, 46, },
	{ 2, 0, 0, 1, 10, 40, },
	{ 1, 0, 0, 1, 10, 40, },
	{ 0, 0, 0, 1, 11, 46, },
	{ 2, 0, 0, 1, 11, 40, },
	{ 1, 0, 0, 1, 11, 40, },
	{ 0, 0, 0, 1, 12, 63, },
	{ 2, 0, 0, 1, 12, 40, },
	{ 1, 0, 0, 1, 12, 40, },
	{ 0, 0, 0, 1, 13, 63, },
	{ 2, 0, 0, 1, 13, 40, },
	{ 1, 0, 0, 1, 13, 40, },
	{ 0, 0, 0, 1, 14, 63, },
	{ 2, 0, 0, 1, 14, 63, },
	{ 1, 0, 0, 1, 14, 63, },
	{ 0, 0, 0, 2, 1, 46, },
	{ 2, 0, 0, 2, 1, 40, },
	{ 1, 0, 0, 2, 1, 40, },
	{ 0, 0, 0, 2, 2, 46, },
	{ 2, 0, 0, 2, 2, 40, },
	{ 1, 0, 0, 2, 2, 40, },
	{ 0, 0, 0, 2, 3, 46, },
	{ 2, 0, 0, 2, 3, 40, },
	{ 1, 0, 0, 2, 3, 40, },
	{ 0, 0, 0, 2, 4, 46, },
	{ 2, 0, 0, 2, 4, 40, },
	{ 1, 0, 0, 2, 4, 40, },
	{ 0, 0, 0, 2, 5, 46, },
	{ 2, 0, 0, 2, 5, 40, },
	{ 1, 0, 0, 2, 5, 40, },
	{ 0, 0, 0, 2, 6, 46, },
	{ 2, 0, 0, 2, 6, 40, },
	{ 1, 0, 0, 2, 6, 40, },
	{ 0, 0, 0, 2, 7, 46, },
	{ 2, 0, 0, 2, 7, 40, },
	{ 1, 0, 0, 2, 7, 40, },
	{ 0, 0, 0, 2, 8, 46, },
	{ 2, 0, 0, 2, 8, 40, },
	{ 1, 0, 0, 2, 8, 40, },
	{ 0, 0, 0, 2, 9, 46, },
	{ 2, 0, 0, 2, 9, 40, },
	{ 1, 0, 0, 2, 9, 40, },
	{ 0, 0, 0, 2, 10, 46, },
	{ 2, 0, 0, 2, 10, 40, },
	{ 1, 0, 0, 2, 10, 40, },
	{ 0, 0, 0, 2, 11, 46, },
	{ 2, 0, 0, 2, 11, 40, },
	{ 1, 0, 0, 2, 11, 40, },
	{ 0, 0, 0, 2, 12, 63, },
	{ 2, 0, 0, 2, 12, 40, },
	{ 1, 0, 0, 2, 12, 40, },
	{ 0, 0, 0, 2, 13, 63, },
	{ 2, 0, 0, 2, 13, 40, },
	{ 1, 0, 0, 2, 13, 40, },
	{ 0, 0, 0, 2, 14, 63, },
	{ 2, 0, 0, 2, 14, 63, },
	{ 1, 0, 0, 2, 14, 63, },
	{ 0, 0, 0, 3, 1, 46, },
	{ 2, 0, 0, 3, 1, 40, },
	{ 1, 0, 0, 3, 1, 40, },
	{ 0, 0, 0, 3, 2, 46, },
	{ 2, 0, 0, 3, 2, 40, },
	{ 1, 0, 0, 3, 2, 40, },
	{ 0, 0, 0, 3, 3, 46, },
	{ 2, 0, 0, 3, 3, 40, },
	{ 1, 0, 0, 3, 3, 40, },
	{ 0, 0, 0, 3, 4, 46, },
	{ 2, 0, 0, 3, 4, 40, },
	{ 1, 0, 0, 3, 4, 40, },
	{ 0, 0, 0, 3, 5, 46, },
	{ 2, 0, 0, 3, 5, 40, },
	{ 1, 0, 0, 3, 5, 40, },
	{ 0, 0, 0, 3, 6, 46, },
	{ 2, 0, 0, 3, 6, 40, },
	{ 1, 0, 0, 3, 6, 40, },
	{ 0, 0, 0, 3, 7, 46, },
	{ 2, 0, 0, 3, 7, 40, },
	{ 1, 0, 0, 3, 7, 40, },
	{ 0, 0, 0, 3, 8, 46, },
	{ 2, 0, 0, 3, 8, 40, },
	{ 1, 0, 0, 3, 8, 40, },
	{ 0, 0, 0, 3, 9, 46, },
	{ 2, 0, 0, 3, 9, 40, },
	{ 1, 0, 0, 3, 9, 40, },
	{ 0, 0, 0, 3, 10, 46, },
	{ 2, 0, 0, 3, 10, 40, },
	{ 1, 0, 0, 3, 10, 40, },
	{ 0, 0, 0, 3, 11, 46, },
	{ 2, 0, 0, 3, 11, 40, },
	{ 1, 0, 0, 3, 11, 40, },
	{ 0, 0, 0, 3, 12, 63, },
	{ 2, 0, 0, 3, 12, 40, },
	{ 1, 0, 0, 3, 12, 40, },
	{ 0, 0, 0, 3, 13, 63, },
	{ 2, 0, 0, 3, 13, 40, },
	{ 1, 0, 0, 3, 13, 40, },
	{ 0, 0, 0, 3, 14, 63, },
	{ 2, 0, 0, 3, 14, 63, },
	{ 1, 0, 0, 3, 14, 63, },
	{ 0, 0, 0, 6, 1, 46, },
	{ 2, 0, 0, 6, 1, 40, },
	{ 1, 0, 0, 6, 1, 40, },
	{ 0, 0, 0, 6, 2, 46, },
	{ 2, 0, 0, 6, 2, 40, },
	{ 1, 0, 0, 6, 2, 40, },
	{ 0, 0, 0, 6, 3, 46, },
	{ 2, 0, 0, 6, 3, 40, },
	{ 1, 0, 0, 6, 3, 40, },
	{ 0, 0, 0, 6, 4, 46, },
	{ 2, 0, 0, 6, 4, 40, },
	{ 1, 0, 0, 6, 4, 40, },
	{ 0, 0, 0, 6, 5, 46, },
	{ 2, 0, 0, 6, 5, 40, },
	{ 1, 0, 0, 6, 5, 40, },
	{ 0, 0, 0, 6, 6, 46, },
	{ 2, 0, 0, 6, 6, 40, },
	{ 1, 0, 0, 6, 6, 40, },
	{ 0, 0, 0, 6, 7, 46, },
	{ 2, 0, 0, 6, 7, 40, },
	{ 1, 0, 0, 6, 7, 40, },
	{ 0, 0, 0, 6, 8, 46, },
	{ 2, 0, 0, 6, 8, 40, },
	{ 1, 0, 0, 6, 8, 40, },
	{ 0, 0, 0, 6, 9, 46, },
	{ 2, 0, 0, 6, 9, 40, },
	{ 1, 0, 0, 6, 9, 40, },
	{ 0, 0, 0, 6, 10, 46, },
	{ 2, 0, 0, 6, 10, 40, },
	{ 1, 0, 0, 6, 10, 40, },
	{ 0, 0, 0, 6, 11, 46, },
	{ 2, 0, 0, 6, 11, 40, },
	{ 1, 0, 0, 6, 11, 40, },
	{ 0, 0, 0, 6, 12, 63, },
	{ 2, 0, 0, 6, 12, 40, },
	{ 1, 0, 0, 6, 12, 40, },
	{ 0, 0, 0, 6, 13, 63, },
	{ 2, 0, 0, 6, 13, 40, },
	{ 1, 0, 0, 6, 13, 40, },
	{ 0, 0, 0, 6, 14, 63, },
	{ 2, 0, 0, 6, 14, 63, },
	{ 1, 0, 0, 6, 14, 63, },
	{ 0, 0, 0, 7, 1, 46, },
	{ 2, 0, 0, 7, 1, 40, },
	{ 1, 0, 0, 7, 1, 40, },
	{ 0, 0, 0, 7, 2, 46, },
	{ 2, 0, 0, 7, 2, 40, },
	{ 1, 0, 0, 7, 2, 40, },
	{ 0, 0, 0, 7, 3, 46, },
	{ 2, 0, 0, 7, 3, 40, },
	{ 1, 0, 0, 7, 3, 40, },
	{ 0, 0, 0, 7, 4, 46, },
	{ 2, 0, 0, 7, 4, 40, },
	{ 1, 0, 0, 7, 4, 40, },
	{ 0, 0, 0, 7, 5, 46, },
	{ 2, 0, 0, 7, 5, 40, },
	{ 1, 0, 0, 7, 5, 40, },
	{ 0, 0, 0, 7, 6, 46, },
	{ 2, 0, 0, 7, 6, 40, },
	{ 1, 0, 0, 7, 6, 40, },
	{ 0, 0, 0, 7, 7, 46, },
	{ 2, 0, 0, 7, 7, 40, },
	{ 1, 0, 0, 7, 7, 40, },
	{ 0, 0, 0, 7, 8, 46, },
	{ 2, 0, 0, 7, 8, 40, },
	{ 1, 0, 0, 7, 8, 40, },
	{ 0, 0, 0, 7, 9, 46, },
	{ 2, 0, 0, 7, 9, 40, },
	{ 1, 0, 0, 7, 9, 40, },
	{ 0, 0, 0, 7, 10, 46, },
	{ 2, 0, 0, 7, 10, 40, },
	{ 1, 0, 0, 7, 10, 40, },
	{ 0, 0, 0, 7, 11, 46, },
	{ 2, 0, 0, 7, 11, 40, },
	{ 1, 0, 0, 7, 11, 40, },
	{ 0, 0, 0, 7, 12, 63, },
	{ 2, 0, 0, 7, 12, 40, },
	{ 1, 0, 0, 7, 12, 40, },
	{ 0, 0, 0, 7, 13, 63, },
	{ 2, 0, 0, 7, 13, 40, },
	{ 1, 0, 0, 7, 13, 40, },
	{ 0, 0, 0, 7, 14, 63, },
	{ 2, 0, 0, 7, 14, 63, },
	{ 1, 0, 0, 7, 14, 63, },
	{ 0, 0, 1, 2, 1, 63, },
	{ 2, 0, 1, 2, 1, 63, },
	{ 1, 0, 1, 2, 1, 63, },
	{ 0, 0, 1, 2, 2, 63, },
	{ 2, 0, 1, 2, 2, 63, },
	{ 1, 0, 1, 2, 2, 63, },
	{ 0, 0, 1, 2, 3, 46, },
	{ 2, 0, 1, 2, 3, 40, },
	{ 1, 0, 1, 2, 3, 40, },
	{ 0, 0, 1, 2, 4, 46, },
	{ 2, 0, 1, 2, 4, 40, },
	{ 1, 0, 1, 2, 4, 40, },
	{ 0, 0, 1, 2, 5, 46, },
	{ 2, 0, 1, 2, 5, 40, },
	{ 1, 0, 1, 2, 5, 40, },
	{ 0, 0, 1, 2, 6, 46, },
	{ 2, 0, 1, 2, 6, 40, },
	{ 1, 0, 1, 2, 6, 40, },
	{ 0, 0, 1, 2, 7, 46, },
	{ 2, 0, 1, 2, 7, 40, },
	{ 1, 0, 1, 2, 7, 40, },
	{ 0, 0, 1, 2, 8, 46, },
	{ 2, 0, 1, 2, 8, 40, },
	{ 1, 0, 1, 2, 8, 40, },
	{ 0, 0, 1, 2, 9, 46, },
	{ 2, 0, 1, 2, 9, 40, },
	{ 1, 0, 1, 2, 9, 40, },
	{ 0, 0, 1, 2, 10, 46, },
	{ 2, 0, 1, 2, 10, 40, },
	{ 1, 0, 1, 2, 10, 40, },
	{ 0, 0, 1, 2, 11, 46, },
	{ 2, 0, 1, 2, 11, 40, },
	{ 1, 0, 1, 2, 11, 40, },
	{ 0, 0, 1, 2, 12, 63, },
	{ 2, 0, 1, 2, 12, 40, },
	{ 1, 0, 1, 2, 12, 40, },
	{ 0, 0, 1, 2, 13, 63, },
	{ 2, 0, 1, 2, 13, 40, },
	{ 1, 0, 1, 2, 13, 40, },
	{ 0, 0, 1, 2, 14, 63, },
	{ 2, 0, 1, 2, 14, 63, },
	{ 1, 0, 1, 2, 14, 63, },
	{ 0, 0, 1, 3, 1, 63, },
	{ 2, 0, 1, 3, 1, 63, },
	{ 1, 0, 1, 3, 1, 63, },
	{ 0, 0, 1, 3, 2, 63, },
	{ 2, 0, 1, 3, 2, 63, },
	{ 1, 0, 1, 3, 2, 63, },
	{ 0, 0, 1, 3, 3, 46, },
	{ 2, 0, 1, 3, 3, 40, },
	{ 1, 0, 1, 3, 3, 40, },
	{ 0, 0, 1, 3, 4, 46, },
	{ 2, 0, 1, 3, 4, 40, },
	{ 1, 0, 1, 3, 4, 40, },
	{ 0, 0, 1, 3, 5, 46, },
	{ 2, 0, 1, 3, 5, 40, },
	{ 1, 0, 1, 3, 5, 40, },
	{ 0, 0, 1, 3, 6, 46, },
	{ 2, 0, 1, 3, 6, 40, },
	{ 1, 0, 1, 3, 6, 40, },
	{ 0, 0, 1, 3, 7, 46, },
	{ 2, 0, 1, 3, 7, 40, },
	{ 1, 0, 1, 3, 7, 40, },
	{ 0, 0, 1, 3, 8, 46, },
	{ 2, 0, 1, 3, 8, 40, },
	{ 1, 0, 1, 3, 8, 40, },
	{ 0, 0, 1, 3, 9, 46, },
	{ 2, 0, 1, 3, 9, 40, },
	{ 1, 0, 1, 3, 9, 40, },
	{ 0, 0, 1, 3, 10, 46, },
	{ 2, 0, 1, 3, 10, 40, },
	{ 1, 0, 1, 3, 10, 40, },
	{ 0, 0, 1, 3, 11, 46, },
	{ 2, 0, 1, 3, 11, 40, },
	{ 1, 0, 1, 3, 11, 40, },
	{ 0, 0, 1, 3, 12, 63, },
	{ 2, 0, 1, 3, 12, 40, },
	{ 1, 0, 1, 3, 12, 40, },
	{ 0, 0, 1, 3, 13, 63, },
	{ 2, 0, 1, 3, 13, 40, },
	{ 1, 0, 1, 3, 13, 40, },
	{ 0, 0, 1, 3, 14, 63, },
	{ 2, 0, 1, 3, 14, 63, },
	{ 1, 0, 1, 3, 14, 63, },
	{ 0, 0, 1, 6, 1, 63, },
	{ 2, 0, 1, 6, 1, 63, },
	{ 1, 0, 1, 6, 1, 63, },
	{ 0, 0, 1, 6, 2, 63, },
	{ 2, 0, 1, 6, 2, 63, },
	{ 1, 0, 1, 6, 2, 63, },
	{ 0, 0, 1, 6, 3, 46, },
	{ 2, 0, 1, 6, 3, 40, },
	{ 1, 0, 1, 6, 3, 40, },
	{ 0, 0, 1, 6, 4, 46, },
	{ 2, 0, 1, 6, 4, 40, },
	{ 1, 0, 1, 6, 4, 40, },
	{ 0, 0, 1, 6, 5, 46, },
	{ 2, 0, 1, 6, 5, 40, },
	{ 1, 0, 1, 6, 5, 40, },
	{ 0, 0, 1, 6, 6, 46, },
	{ 2, 0, 1, 6, 6, 40, },
	{ 1, 0, 1, 6, 6, 40, },
	{ 0, 0, 1, 6, 7, 46, },
	{ 2, 0, 1, 6, 7, 40, },
	{ 1, 0, 1, 6, 7, 40, },
	{ 0, 0, 1, 6, 8, 46, },
	{ 2, 0, 1, 6, 8, 40, },
	{ 1, 0, 1, 6, 8, 40, },
	{ 0, 0, 1, 6, 9, 46, },
	{ 2, 0, 1, 6, 9, 40, },
	{ 1, 0, 1, 6, 9, 40, },
	{ 0, 0, 1, 6, 10, 46, },
	{ 2, 0, 1, 6, 10, 40, },
	{ 1, 0, 1, 6, 10, 40, },
	{ 0, 0, 1, 6, 11, 46, },
	{ 2, 0, 1, 6, 11, 40, },
	{ 1, 0, 1, 6, 11, 40, },
	{ 0, 0, 1, 6, 12, 63, },
	{ 2, 0, 1, 6, 12, 40, },
	{ 1, 0, 1, 6, 12, 40, },
	{ 0, 0, 1, 6, 13, 63, },
	{ 2, 0, 1, 6, 13, 40, },
	{ 1, 0, 1, 6, 13, 40, },
	{ 0, 0, 1, 6, 14, 63, },
	{ 2, 0, 1, 6, 14, 63, },
	{ 1, 0, 1, 6, 14, 63, },
	{ 0, 0, 1, 7, 1, 63, },
	{ 2, 0, 1, 7, 1, 63, },
	{ 1, 0, 1, 7, 1, 63, },
	{ 0, 0, 1, 7, 2, 63, },
	{ 2, 0, 1, 7, 2, 63, },
	{ 1, 0, 1, 7, 2, 63, },
	{ 0, 0, 1, 7, 3, 46, },
	{ 2, 0, 1, 7, 3, 40, },
	{ 1, 0, 1, 7, 3, 40, },
	{ 0, 0, 1, 7, 4, 46, },
	{ 2, 0, 1, 7, 4, 40, },
	{ 1, 0, 1, 7, 4, 40, },
	{ 0, 0, 1, 7, 5, 46, },
	{ 2, 0, 1, 7, 5, 40, },
	{ 1, 0, 1, 7, 5, 40, },
	{ 0, 0, 1, 7, 6, 46, },
	{ 2, 0, 1, 7, 6, 40, },
	{ 1, 0, 1, 7, 6, 40, },
	{ 0, 0, 1, 7, 7, 46, },
	{ 2, 0, 1, 7, 7, 40, },
	{ 1, 0, 1, 7, 7, 40, },
	{ 0, 0, 1, 7, 8, 46, },
	{ 2, 0, 1, 7, 8, 40, },
	{ 1, 0, 1, 7, 8, 40, },
	{ 0, 0, 1, 7, 9, 46, },
	{ 2, 0, 1, 7, 9, 40, },
	{ 1, 0, 1, 7, 9, 40, },
	{ 0, 0, 1, 7, 10, 46, },
	{ 2, 0, 1, 7, 10, 40, },
	{ 1, 0, 1, 7, 10, 40, },
	{ 0, 0, 1, 7, 11, 46, },
	{ 2, 0, 1, 7, 11, 40, },
	{ 1, 0, 1, 7, 11, 40, },
	{ 0, 0, 1, 7, 12, 63, },
	{ 2, 0, 1, 7, 12, 40, },
	{ 1, 0, 1, 7, 12, 40, },
	{ 0, 0, 1, 7, 13, 63, },
	{ 2, 0, 1, 7, 13, 40, },
	{ 1, 0, 1, 7, 13, 40, },
	{ 0, 0, 1, 7, 14, 63, },
	{ 2, 0, 1, 7, 14, 63, },
	{ 1, 0, 1, 7, 14, 63, },
	{ 0, 1, 0, 1, 36, 46, },
	{ 2, 1, 0, 1, 36, 40, },
	{ 1, 1, 0, 1, 36, 40, },
	{ 0, 1, 0, 1, 40, 46, },
	{ 2, 1, 0, 1, 40, 40, },
	{ 1, 1, 0, 1, 40, 40, },
	{ 0, 1, 0, 1, 44, 46, },
	{ 2, 1, 0, 1, 44, 40, },
	{ 1, 1, 0, 1, 44, 40, },
	{ 0, 1, 0, 1, 48, 46, },
	{ 2, 1, 0, 1, 48, 40, },
	{ 1, 1, 0, 1, 48, 40, },
	{ 0, 1, 0, 1, 52, 46, },
	{ 2, 1, 0, 1, 52, 40, },
	{ 1, 1, 0, 1, 52, 40, },
	{ 0, 1, 0, 1, 56, 46, },
	{ 2, 1, 0, 1, 56, 40, },
	{ 1, 1, 0, 1, 56, 40, },
	{ 0, 1, 0, 1, 60, 46, },
	{ 2, 1, 0, 1, 60, 40, },
	{ 1, 1, 0, 1, 60, 40, },
	{ 0, 1, 0, 1, 64, 46, },
	{ 2, 1, 0, 1, 64, 40, },
	{ 1, 1, 0, 1, 64, 40, },
	{ 0, 1, 0, 1, 100, 46, },
	{ 2, 1, 0, 1, 100, 40, },
	{ 1, 1, 0, 1, 100, 40, },
	{ 0, 1, 0, 1, 104, 46, },
	{ 2, 1, 0, 1, 104, 40, },
	{ 1, 1, 0, 1, 104, 40, },
	{ 0, 1, 0, 1, 108, 46, },
	{ 2, 1, 0, 1, 108, 40, },
	{ 1, 1, 0, 1, 108, 40, },
	{ 0, 1, 0, 1, 112, 46, },
	{ 2, 1, 0, 1, 112, 40, },
	{ 1, 1, 0, 1, 112, 40, },
	{ 0, 1, 0, 1, 116, 46, },
	{ 2, 1, 0, 1, 116, 40, },
	{ 1, 1, 0, 1, 116, 40, },
	{ 0, 1, 0, 1, 120, 46, },
	{ 2, 1, 0, 1, 120, 40, },
	{ 1, 1, 0, 1, 120, 40, },
	{ 0, 1, 0, 1, 124, 46, },
	{ 2, 1, 0, 1, 124, 40, },
	{ 1, 1, 0, 1, 124, 40, },
	{ 0, 1, 0, 1, 128, 46, },
	{ 2, 1, 0, 1, 128, 40, },
	{ 1, 1, 0, 1, 128, 40, },
	{ 0, 1, 0, 1, 132, 46, },
	{ 2, 1, 0, 1, 132, 40, },
	{ 1, 1, 0, 1, 132, 40, },
	{ 0, 1, 0, 1, 136, 46, },
	{ 2, 1, 0, 1, 136, 40, },
	{ 1, 1, 0, 1, 136, 40, },
	{ 0, 1, 0, 1, 140, 46, },
	{ 2, 1, 0, 1, 140, 40, },
	{ 1, 1, 0, 1, 140, 40, },
	{ 0, 1, 0, 1, 149, 46, },
	{ 2, 1, 0, 1, 149, 40, },
	{ 1, 1, 0, 1, 149, 63, },
	{ 0, 1, 0, 1, 153, 46, },
	{ 2, 1, 0, 1, 153, 40, },
	{ 1, 1, 0, 1, 153, 63, },
	{ 0, 1, 0, 1, 157, 46, },
	{ 2, 1, 0, 1, 157, 40, },
	{ 1, 1, 0, 1, 157, 63, },
	{ 0, 1, 0, 1, 161, 46, },
	{ 2, 1, 0, 1, 161, 40, },
	{ 1, 1, 0, 1, 161, 63, },
	{ 0, 1, 0, 1, 165, 46, },
	{ 2, 1, 0, 1, 165, 40, },
	{ 1, 1, 0, 1, 165, 63, },
	{ 0, 1, 0, 2, 36, 46, },
	{ 2, 1, 0, 2, 36, 40, },
	{ 1, 1, 0, 2, 36, 40, },
	{ 0, 1, 0, 2, 40, 46, },
	{ 2, 1, 0, 2, 40, 40, },
	{ 1, 1, 0, 2, 40, 40, },
	{ 0, 1, 0, 2, 44, 46, },
	{ 2, 1, 0, 2, 44, 40, },
	{ 1, 1, 0, 2, 44, 40, },
	{ 0, 1, 0, 2, 48, 46, },
	{ 2, 1, 0, 2, 48, 40, },
	{ 1, 1, 0, 2, 48, 40, },
	{ 0, 1, 0, 2, 52, 46, },
	{ 2, 1, 0, 2, 52, 40, },
	{ 1, 1, 0, 2, 52, 40, },
	{ 0, 1, 0, 2, 56, 46, },
	{ 2, 1, 0, 2, 56, 40, },
	{ 1, 1, 0, 2, 56, 40, },
	{ 0, 1, 0, 2, 60, 46, },
	{ 2, 1, 0, 2, 60, 40, },
	{ 1, 1, 0, 2, 60, 40, },
	{ 0, 1, 0, 2, 64, 46, },
	{ 2, 1, 0, 2, 64, 40, },
	{ 1, 1, 0, 2, 64, 40, },
	{ 0, 1, 0, 2, 100, 46, },
	{ 2, 1, 0, 2, 100, 40, },
	{ 1, 1, 0, 2, 100, 40, },
	{ 0, 1, 0, 2, 104, 46, },
	{ 2, 1, 0, 2, 104, 40, },
	{ 1, 1, 0, 2, 104, 40, },
	{ 0, 1, 0, 2, 108, 46, },
	{ 2, 1, 0, 2, 108, 40, },
	{ 1, 1, 0, 2, 108, 40, },
	{ 0, 1, 0, 2, 112, 46, },
	{ 2, 1, 0, 2, 112, 40, },
	{ 1, 1, 0, 2, 112, 40, },
	{ 0, 1, 0, 2, 116, 46, },
	{ 2, 1, 0, 2, 116, 40, },
	{ 1, 1, 0, 2, 116, 40, },
	{ 0, 1, 0, 2, 120, 46, },
	{ 2, 1, 0, 2, 120, 40, },
	{ 1, 1, 0, 2, 120, 40, },
	{ 0, 1, 0, 2, 124, 46, },
	{ 2, 1, 0, 2, 124, 40, },
	{ 1, 1, 0, 2, 124, 40, },
	{ 0, 1, 0, 2, 128, 46, },
	{ 2, 1, 0, 2, 128, 40, },
	{ 1, 1, 0, 2, 128, 40, },
	{ 0, 1, 0, 2, 132, 46, },
	{ 2, 1, 0, 2, 132, 40, },
	{ 1, 1, 0, 2, 132, 40, },
	{ 0, 1, 0, 2, 136, 46, },
	{ 2, 1, 0, 2, 136, 40, },
	{ 1, 1, 0, 2, 136, 40, },
	{ 0, 1, 0, 2, 140, 46, },
	{ 2, 1, 0, 2, 140, 40, },
	{ 1, 1, 0, 2, 140, 40, },
	{ 0, 1, 0, 2, 149, 46, },
	{ 2, 1, 0, 2, 149, 40, },
	{ 1, 1, 0, 2, 149, 63, },
	{ 0, 1, 0, 2, 153, 46, },
	{ 2, 1, 0, 2, 153, 40, },
	{ 1, 1, 0, 2, 153, 63, },
	{ 0, 1, 0, 2, 157, 46, },
	{ 2, 1, 0, 2, 157, 40, },
	{ 1, 1, 0, 2, 157, 63, },
	{ 0, 1, 0, 2, 161, 46, },
	{ 2, 1, 0, 2, 161, 40, },
	{ 1, 1, 0, 2, 161, 63, },
	{ 0, 1, 0, 2, 165, 46, },
	{ 2, 1, 0, 2, 165, 40, },
	{ 1, 1, 0, 2, 165, 63, },
	{ 0, 1, 0, 3, 36, 46, },
	{ 2, 1, 0, 3, 36, 40, },
	{ 1, 1, 0, 3, 36, 40, },
	{ 0, 1, 0, 3, 40, 46, },
	{ 2, 1, 0, 3, 40, 40, },
	{ 1, 1, 0, 3, 40, 40, },
	{ 0, 1, 0, 3, 44, 46, },
	{ 2, 1, 0, 3, 44, 40, },
	{ 1, 1, 0, 3, 44, 40, },
	{ 0, 1, 0, 3, 48, 46, },
	{ 2, 1, 0, 3, 48, 40, },
	{ 1, 1, 0, 3, 48, 40, },
	{ 0, 1, 0, 3, 52, 46, },
	{ 2, 1, 0, 3, 52, 40, },
	{ 1, 1, 0, 3, 52, 40, },
	{ 0, 1, 0, 3, 56, 46, },
	{ 2, 1, 0, 3, 56, 40, },
	{ 1, 1, 0, 3, 56, 40, },
	{ 0, 1, 0, 3, 60, 46, },
	{ 2, 1, 0, 3, 60, 40, },
	{ 1, 1, 0, 3, 60, 40, },
	{ 0, 1, 0, 3, 64, 46, },
	{ 2, 1, 0, 3, 64, 40, },
	{ 1, 1, 0, 3, 64, 40, },
	{ 0, 1, 0, 3, 100, 46, },
	{ 2, 1, 0, 3, 100, 40, },
	{ 1, 1, 0, 3, 100, 40, },
	{ 0, 1, 0, 3, 104, 46, },
	{ 2, 1, 0, 3, 104, 40, },
	{ 1, 1, 0, 3, 104, 40, },
	{ 0, 1, 0, 3, 108, 46, },
	{ 2, 1, 0, 3, 108, 40, },
	{ 1, 1, 0, 3, 108, 40, },
	{ 0, 1, 0, 3, 112, 46, },
	{ 2, 1, 0, 3, 112, 40, },
	{ 1, 1, 0, 3, 112, 40, },
	{ 0, 1, 0, 3, 116, 46, },
	{ 2, 1, 0, 3, 116, 40, },
	{ 1, 1, 0, 3, 116, 40, },
	{ 0, 1, 0, 3, 120, 46, },
	{ 2, 1, 0, 3, 120, 40, },
	{ 1, 1, 0, 3, 120, 40, },
	{ 0, 1, 0, 3, 124, 46, },
	{ 2, 1, 0, 3, 124, 40, },
	{ 1, 1, 0, 3, 124, 40, },
	{ 0, 1, 0, 3, 128, 46, },
	{ 2, 1, 0, 3, 128, 40, },
	{ 1, 1, 0, 3, 128, 40, },
	{ 0, 1, 0, 3, 132, 46, },
	{ 2, 1, 0, 3, 132, 40, },
	{ 1, 1, 0, 3, 132, 40, },
	{ 0, 1, 0, 3, 136, 46, },
	{ 2, 1, 0, 3, 136, 40, },
	{ 1, 1, 0, 3, 136, 40, },
	{ 0, 1, 0, 3, 140, 46, },
	{ 2, 1, 0, 3, 140, 40, },
	{ 1, 1, 0, 3, 140, 40, },
	{ 0, 1, 0, 3, 149, 46, },
	{ 2, 1, 0, 3, 149, 40, },
	{ 1, 1, 0, 3, 149, 63, },
	{ 0, 1, 0, 3, 153, 46, },
	{ 2, 1, 0, 3, 153, 40, },
	{ 1, 1, 0, 3, 153, 63, },
	{ 0, 1, 0, 3, 157, 46, },
	{ 2, 1, 0, 3, 157, 40, },
	{ 1, 1, 0, 3, 157, 63, },
	{ 0, 1, 0, 3, 161, 46, },
	{ 2, 1, 0, 3, 161, 40, },
	{ 1, 1, 0, 3, 161, 63, },
	{ 0, 1, 0, 3, 165, 46, },
	{ 2, 1, 0, 3, 165, 40, },
	{ 1, 1, 0, 3, 165, 63, },
	{ 0, 1, 0, 6, 36, 46, },
	{ 2, 1, 0, 6, 36, 40, },
	{ 1, 1, 0, 6, 36, 40, },
	{ 0, 1, 0, 6, 40, 46, },
	{ 2, 1, 0, 6, 40, 40, },
	{ 1, 1, 0, 6, 40, 40, },
	{ 0, 1, 0, 6, 44, 46, },
	{ 2, 1, 0, 6, 44, 40, },
	{ 1, 1, 0, 6, 44, 40, },
	{ 0, 1, 0, 6, 48, 46, },
	{ 2, 1, 0, 6, 48, 40, },
	{ 1, 1, 0, 6, 48, 40, },
	{ 0, 1, 0, 6, 52, 46, },
	{ 2, 1, 0, 6, 52, 40, },
	{ 1, 1, 0, 6, 52, 40, },
	{ 0, 1, 0, 6, 56, 46, },
	{ 2, 1, 0, 6, 56, 40, },
	{ 1, 1, 0, 6, 56, 40, },
	{ 0, 1, 0, 6, 60, 46, },
	{ 2, 1, 0, 6, 60, 40, },
	{ 1, 1, 0, 6, 60, 40, },
	{ 0, 1, 0, 6, 64, 46, },
	{ 2, 1, 0, 6, 64, 40, },
	{ 1, 1, 0, 6, 64, 40, },
	{ 0, 1, 0, 6, 100, 46, },
	{ 2, 1, 0, 6, 100, 40, },
	{ 1, 1, 0, 6, 100, 40, },
	{ 0, 1, 0, 6, 104, 46, },
	{ 2, 1, 0, 6, 104, 40, },
	{ 1, 1, 0, 6, 104, 40, },
	{ 0, 1, 0, 6, 108, 46, },
	{ 2, 1, 0, 6, 108, 40, },
	{ 1, 1, 0, 6, 108, 40, },
	{ 0, 1, 0, 6, 112, 46, },
	{ 2, 1, 0, 6, 112, 40, },
	{ 1, 1, 0, 6, 112, 40, },
	{ 0, 1, 0, 6, 116, 46, },
	{ 2, 1, 0, 6, 116, 40, },
	{ 1, 1, 0, 6, 116, 40, },
	{ 0, 1, 0, 6, 120, 46, },
	{ 2, 1, 0, 6, 120, 40, },
	{ 1, 1, 0, 6, 120, 40, },
	{ 0, 1, 0, 6, 124, 46, },
	{ 2, 1, 0, 6, 124, 40, },
	{ 1, 1, 0, 6, 124, 40, },
	{ 0, 1, 0, 6, 128, 46, },
	{ 2, 1, 0, 6, 128, 40, },
	{ 1, 1, 0, 6, 128, 40, },
	{ 0, 1, 0, 6, 132, 46, },
	{ 2, 1, 0, 6, 132, 40, },
	{ 1, 1, 0, 6, 132, 40, },
	{ 0, 1, 0, 6, 136, 46, },
	{ 2, 1, 0, 6, 136, 40, },
	{ 1, 1, 0, 6, 136, 40, },
	{ 0, 1, 0, 6, 140, 46, },
	{ 2, 1, 0, 6, 140, 40, },
	{ 1, 1, 0, 6, 140, 40, },
	{ 0, 1, 0, 6, 149, 46, },
	{ 2, 1, 0, 6, 149, 40, },
	{ 1, 1, 0, 6, 149, 63, },
	{ 0, 1, 0, 6, 153, 46, },
	{ 2, 1, 0, 6, 153, 40, },
	{ 1, 1, 0, 6, 153, 63, },
	{ 0, 1, 0, 6, 157, 46, },
	{ 2, 1, 0, 6, 157, 40, },
	{ 1, 1, 0, 6, 157, 63, },
	{ 0, 1, 0, 6, 161, 46, },
	{ 2, 1, 0, 6, 161, 40, },
	{ 1, 1, 0, 6, 161, 63, },
	{ 0, 1, 0, 6, 165, 46, },
	{ 2, 1, 0, 6, 165, 40, },
	{ 1, 1, 0, 6, 165, 63, },
	{ 0, 1, 0, 7, 36, 46, },
	{ 2, 1, 0, 7, 36, 40, },
	{ 1, 1, 0, 7, 36, 40, },
	{ 0, 1, 0, 7, 40, 46, },
	{ 2, 1, 0, 7, 40, 40, },
	{ 1, 1, 0, 7, 40, 40, },
	{ 0, 1, 0, 7, 44, 46, },
	{ 2, 1, 0, 7, 44, 40, },
	{ 1, 1, 0, 7, 44, 40, },
	{ 0, 1, 0, 7, 48, 46, },
	{ 2, 1, 0, 7, 48, 40, },
	{ 1, 1, 0, 7, 48, 40, },
	{ 0, 1, 0, 7, 52, 46, },
	{ 2, 1, 0, 7, 52, 40, },
	{ 1, 1, 0, 7, 52, 40, },
	{ 0, 1, 0, 7, 56, 46, },
	{ 2, 1, 0, 7, 56, 40, },
	{ 1, 1, 0, 7, 56, 40, },
	{ 0, 1, 0, 7, 60, 46, },
	{ 2, 1, 0, 7, 60, 40, },
	{ 1, 1, 0, 7, 60, 40, },
	{ 0, 1, 0, 7, 64, 46, },
	{ 2, 1, 0, 7, 64, 40, },
	{ 1, 1, 0, 7, 64, 40, },
	{ 0, 1, 0, 7, 100, 46, },
	{ 2, 1, 0, 7, 100, 40, },
	{ 1, 1, 0, 7, 100, 40, },
	{ 0, 1, 0, 7, 104, 46, },
	{ 2, 1, 0, 7, 104, 40, },
	{ 1, 1, 0, 7, 104, 40, },
	{ 0, 1, 0, 7, 108, 46, },
	{ 2, 1, 0, 7, 108, 40, },
	{ 1, 1, 0, 7, 108, 40, },
	{ 0, 1, 0, 7, 112, 46, },
	{ 2, 1, 0, 7, 112, 40, },
	{ 1, 1, 0, 7, 112, 40, },
	{ 0, 1, 0, 7, 116, 46, },
	{ 2, 1, 0, 7, 116, 40, },
	{ 1, 1, 0, 7, 116, 40, },
	{ 0, 1, 0, 7, 120, 46, },
	{ 2, 1, 0, 7, 120, 40, },
	{ 1, 1, 0, 7, 120, 40, },
	{ 0, 1, 0, 7, 124, 46, },
	{ 2, 1, 0, 7, 124, 40, },
	{ 1, 1, 0, 7, 124, 40, },
	{ 0, 1, 0, 7, 128, 46, },
	{ 2, 1, 0, 7, 128, 40, },
	{ 1, 1, 0, 7, 128, 40, },
	{ 0, 1, 0, 7, 132, 46, },
	{ 2, 1, 0, 7, 132, 40, },
	{ 1, 1, 0, 7, 132, 40, },
	{ 0, 1, 0, 7, 136, 46, },
	{ 2, 1, 0, 7, 136, 40, },
	{ 1, 1, 0, 7, 136, 40, },
	{ 0, 1, 0, 7, 140, 46, },
	{ 2, 1, 0, 7, 140, 40, },
	{ 1, 1, 0, 7, 140, 40, },
	{ 0, 1, 0, 7, 149, 46, },
	{ 2, 1, 0, 7, 149, 40, },
	{ 1, 1, 0, 7, 149, 63, },
	{ 0, 1, 0, 7, 153, 46, },
	{ 2, 1, 0, 7, 153, 40, },
	{ 1, 1, 0, 7, 153, 63, },
	{ 0, 1, 0, 7, 157, 46, },
	{ 2, 1, 0, 7, 157, 40, },
	{ 1, 1, 0, 7, 157, 63, },
	{ 0, 1, 0, 7, 161, 46, },
	{ 2, 1, 0, 7, 161, 40, },
	{ 1, 1, 0, 7, 161, 63, },
	{ 0, 1, 0, 7, 165, 46, },
	{ 2, 1, 0, 7, 165, 40, },
	{ 1, 1, 0, 7, 165, 63, },
	{ 0, 1, 1, 2, 38, 46, },
	{ 2, 1, 1, 2, 38, 40, },
	{ 1, 1, 1, 2, 38, 40, },
	{ 0, 1, 1, 2, 46, 46, },
	{ 2, 1, 1, 2, 46, 40, },
	{ 1, 1, 1, 2, 46, 40, },
	{ 0, 1, 1, 2, 54, 46, },
	{ 2, 1, 1, 2, 54, 40, },
	{ 1, 1, 1, 2, 54, 40, },
	{ 0, 1, 1, 2, 62, 46, },
	{ 2, 1, 1, 2, 62, 40, },
	{ 1, 1, 1, 2, 62, 40, },
	{ 0, 1, 1, 2, 102, 46, },
	{ 2, 1, 1, 2, 102, 40, },
	{ 1, 1, 1, 2, 102, 40, },
	{ 0, 1, 1, 2, 110, 46, },
	{ 2, 1, 1, 2, 110, 40, },
	{ 1, 1, 1, 2, 110, 40, },
	{ 0, 1, 1, 2, 118, 46, },
	{ 2, 1, 1, 2, 118, 40, },
	{ 1, 1, 1, 2, 118, 40, },
	{ 0, 1, 1, 2, 126, 46, },
	{ 2, 1, 1, 2, 126, 40, },
	{ 1, 1, 1, 2, 126, 40, },
	{ 0, 1, 1, 2, 134, 46, },
	{ 2, 1, 1, 2, 134, 40, },
	{ 1, 1, 1, 2, 134, 40, },
	{ 0, 1, 1, 2, 151, 46, },
	{ 2, 1, 1, 2, 151, 40, },
	{ 1, 1, 1, 2, 151, 63, },
	{ 0, 1, 1, 2, 159, 46, },
	{ 2, 1, 1, 2, 159, 40, },
	{ 1, 1, 1, 2, 159, 63, },
	{ 0, 1, 1, 3, 38, 46, },
	{ 2, 1, 1, 3, 38, 40, },
	{ 1, 1, 1, 3, 38, 40, },
	{ 0, 1, 1, 3, 46, 46, },
	{ 2, 1, 1, 3, 46, 40, },
	{ 1, 1, 1, 3, 46, 40, },
	{ 0, 1, 1, 3, 54, 46, },
	{ 2, 1, 1, 3, 54, 40, },
	{ 1, 1, 1, 3, 54, 40, },
	{ 0, 1, 1, 3, 62, 46, },
	{ 2, 1, 1, 3, 62, 40, },
	{ 1, 1, 1, 3, 62, 40, },
	{ 0, 1, 1, 3, 102, 46, },
	{ 2, 1, 1, 3, 102, 40, },
	{ 1, 1, 1, 3, 102, 40, },
	{ 0, 1, 1, 3, 110, 46, },
	{ 2, 1, 1, 3, 110, 40, },
	{ 1, 1, 1, 3, 110, 40, },
	{ 0, 1, 1, 3, 118, 46, },
	{ 2, 1, 1, 3, 118, 40, },
	{ 1, 1, 1, 3, 118, 40, },
	{ 0, 1, 1, 3, 126, 46, },
	{ 2, 1, 1, 3, 126, 40, },
	{ 1, 1, 1, 3, 126, 40, },
	{ 0, 1, 1, 3, 134, 46, },
	{ 2, 1, 1, 3, 134, 40, },
	{ 1, 1, 1, 3, 134, 40, },
	{ 0, 1, 1, 3, 151, 46, },
	{ 2, 1, 1, 3, 151, 40, },
	{ 1, 1, 1, 3, 151, 63, },
	{ 0, 1, 1, 3, 159, 46, },
	{ 2, 1, 1, 3, 159, 40, },
	{ 1, 1, 1, 3, 159, 63, },
	{ 0, 1, 1, 6, 38, 46, },
	{ 2, 1, 1, 6, 38, 40, },
	{ 1, 1, 1, 6, 38, 40, },
	{ 0, 1, 1, 6, 46, 46, },
	{ 2, 1, 1, 6, 46, 40, },
	{ 1, 1, 1, 6, 46, 40, },
	{ 0, 1, 1, 6, 54, 46, },
	{ 2, 1, 1, 6, 54, 40, },
	{ 1, 1, 1, 6, 54, 40, },
	{ 0, 1, 1, 6, 62, 46, },
	{ 2, 1, 1, 6, 62, 40, },
	{ 1, 1, 1, 6, 62, 40, },
	{ 0, 1, 1, 6, 102, 46, },
	{ 2, 1, 1, 6, 102, 40, },
	{ 1, 1, 1, 6, 102, 40, },
	{ 0, 1, 1, 6, 110, 46, },
	{ 2, 1, 1, 6, 110, 40, },
	{ 1, 1, 1, 6, 110, 40, },
	{ 0, 1, 1, 6, 118, 46, },
	{ 2, 1, 1, 6, 118, 40, },
	{ 1, 1, 1, 6, 118, 40, },
	{ 0, 1, 1, 6, 126, 46, },
	{ 2, 1, 1, 6, 126, 40, },
	{ 1, 1, 1, 6, 126, 40, },
	{ 0, 1, 1, 6, 134, 46, },
	{ 2, 1, 1, 6, 134, 40, },
	{ 1, 1, 1, 6, 134, 40, },
	{ 0, 1, 1, 6, 151, 46, },
	{ 2, 1, 1, 6, 151, 40, },
	{ 1, 1, 1, 6, 151, 63, },
	{ 0, 1, 1, 6, 159, 46, },
	{ 2, 1, 1, 6, 159, 40, },
	{ 1, 1, 1, 6, 159, 63, },
	{ 0, 1, 1, 7, 38, 46, },
	{ 2, 1, 1, 7, 38, 40, },
	{ 1, 1, 1, 7, 38, 40, },
	{ 0, 1, 1, 7, 46, 46, },
	{ 2, 1, 1, 7, 46, 40, },
	{ 1, 1, 1, 7, 46, 40, },
	{ 0, 1, 1, 7, 54, 46, },
	{ 2, 1, 1, 7, 54, 40, },
	{ 1, 1, 1, 7, 54, 40, },
	{ 0, 1, 1, 7, 62, 46, },
	{ 2, 1, 1, 7, 62, 40, },
	{ 1, 1, 1, 7, 62, 40, },
	{ 0, 1, 1, 7, 102, 46, },
	{ 2, 1, 1, 7, 102, 40, },
	{ 1, 1, 1, 7, 102, 40, },
	{ 0, 1, 1, 7, 110, 46, },
	{ 2, 1, 1, 7, 110, 40, },
	{ 1, 1, 1, 7, 110, 40, },
	{ 0, 1, 1, 7, 118, 46, },
	{ 2, 1, 1, 7, 118, 40, },
	{ 1, 1, 1, 7, 118, 40, },
	{ 0, 1, 1, 7, 126, 46, },
	{ 2, 1, 1, 7, 126, 40, },
	{ 1, 1, 1, 7, 126, 40, },
	{ 0, 1, 1, 7, 134, 46, },
	{ 2, 1, 1, 7, 134, 40, },
	{ 1, 1, 1, 7, 134, 40, },
	{ 0, 1, 1, 7, 151, 46, },
	{ 2, 1, 1, 7, 151, 40, },
	{ 1, 1, 1, 7, 151, 63, },
	{ 0, 1, 1, 7, 159, 46, },
	{ 2, 1, 1, 7, 159, 40, },
	{ 1, 1, 1, 7, 159, 63, },
	{ 0, 1, 2, 4, 42, 46, },
	{ 2, 1, 2, 4, 42, 40, },
	{ 1, 1, 2, 4, 42, 40, },
	{ 0, 1, 2, 4, 58, 46, },
	{ 2, 1, 2, 4, 58, 40, },
	{ 1, 1, 2, 4, 58, 40, },
	{ 0, 1, 2, 4, 106, 46, },
	{ 2, 1, 2, 4, 106, 40, },
	{ 1, 1, 2, 4, 106, 40, },
	{ 0, 1, 2, 4, 122, 46, },
	{ 2, 1, 2, 4, 122, 40, },
	{ 1, 1, 2, 4, 122, 40, },
	{ 0, 1, 2, 4, 155, 46, },
	{ 2, 1, 2, 4, 155, 40, },
	{ 1, 1, 2, 4, 155, 63, },
	{ 0, 1, 2, 5, 42, 46, },
	{ 2, 1, 2, 5, 42, 40, },
	{ 1, 1, 2, 5, 42, 40, },
	{ 0, 1, 2, 5, 58, 46, },
	{ 2, 1, 2, 5, 58, 40, },
	{ 1, 1, 2, 5, 58, 40, },
	{ 0, 1, 2, 5, 106, 46, },
	{ 2, 1, 2, 5, 106, 40, },
	{ 1, 1, 2, 5, 106, 40, },
	{ 0, 1, 2, 5, 122, 46, },
	{ 2, 1, 2, 5, 122, 40, },
	{ 1, 1, 2, 5, 122, 40, },
	{ 0, 1, 2, 5, 155, 46, },
	{ 2, 1, 2, 5, 155, 40, },
	{ 1, 1, 2, 5, 155, 63, },
	{ 0, 1, 2, 8, 42, 46, },
	{ 2, 1, 2, 8, 42, 40, },
	{ 1, 1, 2, 8, 42, 40, },
	{ 0, 1, 2, 8, 58, 46, },
	{ 2, 1, 2, 8, 58, 40, },
	{ 1, 1, 2, 8, 58, 40, },
	{ 0, 1, 2, 8, 106, 46, },
	{ 2, 1, 2, 8, 106, 40, },
	{ 1, 1, 2, 8, 106, 40, },
	{ 0, 1, 2, 8, 122, 46, },
	{ 2, 1, 2, 8, 122, 40, },
	{ 1, 1, 2, 8, 122, 40, },
	{ 0, 1, 2, 8, 155, 46, },
	{ 2, 1, 2, 8, 155, 40, },
	{ 1, 1, 2, 8, 155, 63, },
	{ 0, 1, 2, 9, 42, 46, },
	{ 2, 1, 2, 9, 42, 40, },
	{ 1, 1, 2, 9, 42, 40, },
	{ 0, 1, 2, 9, 58, 46, },
	{ 2, 1, 2, 9, 58, 40, },
	{ 1, 1, 2, 9, 58, 40, },
	{ 0, 1, 2, 9, 106, 46, },
	{ 2, 1, 2, 9, 106, 40, },
	{ 1, 1, 2, 9, 106, 40, },
	{ 0, 1, 2, 9, 122, 46, },
	{ 2, 1, 2, 9, 122, 40, },
	{ 1, 1, 2, 9, 122, 40, },
	{ 0, 1, 2, 9, 155, 46, },
	{ 2, 1, 2, 9, 155, 40, },
	{ 1, 1, 2, 9, 155, 63, },
};

RTW_DECL_TABLE_TXPWR_LMT(rtw8814a_txpwr_lmt_type3);

static const struct rtw_txpwr_lmt_cfg_pair rtw8814a_txpwr_lmt_type5[] = {
	{ 0, 0, 0, 0, 1, 46, },
	{ 2, 0, 0, 0, 1, 40, },
	{ 1, 0, 0, 0, 1, 40, },
	{ 0, 0, 0, 0, 2, 46, },
	{ 2, 0, 0, 0, 2, 40, },
	{ 1, 0, 0, 0, 2, 40, },
	{ 0, 0, 0, 0, 3, 46, },
	{ 2, 0, 0, 0, 3, 40, },
	{ 1, 0, 0, 0, 3, 40, },
	{ 0, 0, 0, 0, 4, 46, },
	{ 2, 0, 0, 0, 4, 40, },
	{ 1, 0, 0, 0, 4, 40, },
	{ 0, 0, 0, 0, 5, 46, },
	{ 2, 0, 0, 0, 5, 40, },
	{ 1, 0, 0, 0, 5, 40, },
	{ 0, 0, 0, 0, 6, 46, },
	{ 2, 0, 0, 0, 6, 40, },
	{ 1, 0, 0, 0, 6, 40, },
	{ 0, 0, 0, 0, 7, 46, },
	{ 2, 0, 0, 0, 7, 40, },
	{ 1, 0, 0, 0, 7, 40, },
	{ 0, 0, 0, 0, 8, 46, },
	{ 2, 0, 0, 0, 8, 40, },
	{ 1, 0, 0, 0, 8, 40, },
	{ 0, 0, 0, 0, 9, 46, },
	{ 2, 0, 0, 0, 9, 40, },
	{ 1, 0, 0, 0, 9, 40, },
	{ 0, 0, 0, 0, 10, 46, },
	{ 2, 0, 0, 0, 10, 40, },
	{ 1, 0, 0, 0, 10, 40, },
	{ 0, 0, 0, 0, 11, 46, },
	{ 2, 0, 0, 0, 11, 40, },
	{ 1, 0, 0, 0, 11, 40, },
	{ 0, 0, 0, 0, 12, 63, },
	{ 2, 0, 0, 0, 12, 40, },
	{ 1, 0, 0, 0, 12, 40, },
	{ 0, 0, 0, 0, 13, 63, },
	{ 2, 0, 0, 0, 13, 40, },
	{ 1, 0, 0, 0, 13, 40, },
	{ 0, 0, 0, 0, 14, 63, },
	{ 2, 0, 0, 0, 14, 63, },
	{ 1, 0, 0, 0, 14, 40, },
	{ 0, 0, 0, 1, 1, 46, },
	{ 2, 0, 0, 1, 1, 40, },
	{ 1, 0, 0, 1, 1, 40, },
	{ 0, 0, 0, 1, 2, 46, },
	{ 2, 0, 0, 1, 2, 40, },
	{ 1, 0, 0, 1, 2, 40, },
	{ 0, 0, 0, 1, 3, 46, },
	{ 2, 0, 0, 1, 3, 40, },
	{ 1, 0, 0, 1, 3, 40, },
	{ 0, 0, 0, 1, 4, 46, },
	{ 2, 0, 0, 1, 4, 40, },
	{ 1, 0, 0, 1, 4, 40, },
	{ 0, 0, 0, 1, 5, 46, },
	{ 2, 0, 0, 1, 5, 40, },
	{ 1, 0, 0, 1, 5, 40, },
	{ 0, 0, 0, 1, 6, 46, },
	{ 2, 0, 0, 1, 6, 40, },
	{ 1, 0, 0, 1, 6, 40, },
	{ 0, 0, 0, 1, 7, 46, },
	{ 2, 0, 0, 1, 7, 40, },
	{ 1, 0, 0, 1, 7, 40, },
	{ 0, 0, 0, 1, 8, 46, },
	{ 2, 0, 0, 1, 8, 40, },
	{ 1, 0, 0, 1, 8, 40, },
	{ 0, 0, 0, 1, 9, 46, },
	{ 2, 0, 0, 1, 9, 40, },
	{ 1, 0, 0, 1, 9, 40, },
	{ 0, 0, 0, 1, 10, 46, },
	{ 2, 0, 0, 1, 10, 40, },
	{ 1, 0, 0, 1, 10, 40, },
	{ 0, 0, 0, 1, 11, 46, },
	{ 2, 0, 0, 1, 11, 40, },
	{ 1, 0, 0, 1, 11, 40, },
	{ 0, 0, 0, 1, 12, 63, },
	{ 2, 0, 0, 1, 12, 40, },
	{ 1, 0, 0, 1, 12, 40, },
	{ 0, 0, 0, 1, 13, 63, },
	{ 2, 0, 0, 1, 13, 40, },
	{ 1, 0, 0, 1, 13, 40, },
	{ 0, 0, 0, 1, 14, 63, },
	{ 2, 0, 0, 1, 14, 63, },
	{ 1, 0, 0, 1, 14, 63, },
	{ 0, 0, 0, 2, 1, 46, },
	{ 2, 0, 0, 2, 1, 40, },
	{ 1, 0, 0, 2, 1, 40, },
	{ 0, 0, 0, 2, 2, 46, },
	{ 2, 0, 0, 2, 2, 40, },
	{ 1, 0, 0, 2, 2, 40, },
	{ 0, 0, 0, 2, 3, 46, },
	{ 2, 0, 0, 2, 3, 40, },
	{ 1, 0, 0, 2, 3, 40, },
	{ 0, 0, 0, 2, 4, 46, },
	{ 2, 0, 0, 2, 4, 40, },
	{ 1, 0, 0, 2, 4, 40, },
	{ 0, 0, 0, 2, 5, 46, },
	{ 2, 0, 0, 2, 5, 40, },
	{ 1, 0, 0, 2, 5, 40, },
	{ 0, 0, 0, 2, 6, 46, },
	{ 2, 0, 0, 2, 6, 40, },
	{ 1, 0, 0, 2, 6, 40, },
	{ 0, 0, 0, 2, 7, 46, },
	{ 2, 0, 0, 2, 7, 40, },
	{ 1, 0, 0, 2, 7, 40, },
	{ 0, 0, 0, 2, 8, 46, },
	{ 2, 0, 0, 2, 8, 40, },
	{ 1, 0, 0, 2, 8, 40, },
	{ 0, 0, 0, 2, 9, 46, },
	{ 2, 0, 0, 2, 9, 40, },
	{ 1, 0, 0, 2, 9, 40, },
	{ 0, 0, 0, 2, 10, 46, },
	{ 2, 0, 0, 2, 10, 40, },
	{ 1, 0, 0, 2, 10, 40, },
	{ 0, 0, 0, 2, 11, 46, },
	{ 2, 0, 0, 2, 11, 40, },
	{ 1, 0, 0, 2, 11, 40, },
	{ 0, 0, 0, 2, 12, 63, },
	{ 2, 0, 0, 2, 12, 40, },
	{ 1, 0, 0, 2, 12, 40, },
	{ 0, 0, 0, 2, 13, 63, },
	{ 2, 0, 0, 2, 13, 40, },
	{ 1, 0, 0, 2, 13, 40, },
	{ 0, 0, 0, 2, 14, 63, },
	{ 2, 0, 0, 2, 14, 63, },
	{ 1, 0, 0, 2, 14, 63, },
	{ 0, 0, 0, 3, 1, 46, },
	{ 2, 0, 0, 3, 1, 40, },
	{ 1, 0, 0, 3, 1, 40, },
	{ 0, 0, 0, 3, 2, 46, },
	{ 2, 0, 0, 3, 2, 40, },
	{ 1, 0, 0, 3, 2, 40, },
	{ 0, 0, 0, 3, 3, 46, },
	{ 2, 0, 0, 3, 3, 40, },
	{ 1, 0, 0, 3, 3, 40, },
	{ 0, 0, 0, 3, 4, 46, },
	{ 2, 0, 0, 3, 4, 40, },
	{ 1, 0, 0, 3, 4, 40, },
	{ 0, 0, 0, 3, 5, 46, },
	{ 2, 0, 0, 3, 5, 40, },
	{ 1, 0, 0, 3, 5, 40, },
	{ 0, 0, 0, 3, 6, 46, },
	{ 2, 0, 0, 3, 6, 40, },
	{ 1, 0, 0, 3, 6, 40, },
	{ 0, 0, 0, 3, 7, 46, },
	{ 2, 0, 0, 3, 7, 40, },
	{ 1, 0, 0, 3, 7, 40, },
	{ 0, 0, 0, 3, 8, 46, },
	{ 2, 0, 0, 3, 8, 40, },
	{ 1, 0, 0, 3, 8, 40, },
	{ 0, 0, 0, 3, 9, 46, },
	{ 2, 0, 0, 3, 9, 40, },
	{ 1, 0, 0, 3, 9, 40, },
	{ 0, 0, 0, 3, 10, 46, },
	{ 2, 0, 0, 3, 10, 40, },
	{ 1, 0, 0, 3, 10, 40, },
	{ 0, 0, 0, 3, 11, 46, },
	{ 2, 0, 0, 3, 11, 40, },
	{ 1, 0, 0, 3, 11, 40, },
	{ 0, 0, 0, 3, 12, 63, },
	{ 2, 0, 0, 3, 12, 40, },
	{ 1, 0, 0, 3, 12, 40, },
	{ 0, 0, 0, 3, 13, 63, },
	{ 2, 0, 0, 3, 13, 40, },
	{ 1, 0, 0, 3, 13, 40, },
	{ 0, 0, 0, 3, 14, 63, },
	{ 2, 0, 0, 3, 14, 63, },
	{ 1, 0, 0, 3, 14, 63, },
	{ 0, 0, 0, 6, 1, 46, },
	{ 2, 0, 0, 6, 1, 40, },
	{ 1, 0, 0, 6, 1, 40, },
	{ 0, 0, 0, 6, 2, 46, },
	{ 2, 0, 0, 6, 2, 40, },
	{ 1, 0, 0, 6, 2, 40, },
	{ 0, 0, 0, 6, 3, 46, },
	{ 2, 0, 0, 6, 3, 40, },
	{ 1, 0, 0, 6, 3, 40, },
	{ 0, 0, 0, 6, 4, 46, },
	{ 2, 0, 0, 6, 4, 40, },
	{ 1, 0, 0, 6, 4, 40, },
	{ 0, 0, 0, 6, 5, 46, },
	{ 2, 0, 0, 6, 5, 40, },
	{ 1, 0, 0, 6, 5, 40, },
	{ 0, 0, 0, 6, 6, 46, },
	{ 2, 0, 0, 6, 6, 40, },
	{ 1, 0, 0, 6, 6, 40, },
	{ 0, 0, 0, 6, 7, 46, },
	{ 2, 0, 0, 6, 7, 40, },
	{ 1, 0, 0, 6, 7, 40, },
	{ 0, 0, 0, 6, 8, 46, },
	{ 2, 0, 0, 6, 8, 40, },
	{ 1, 0, 0, 6, 8, 40, },
	{ 0, 0, 0, 6, 9, 46, },
	{ 2, 0, 0, 6, 9, 40, },
	{ 1, 0, 0, 6, 9, 40, },
	{ 0, 0, 0, 6, 10, 46, },
	{ 2, 0, 0, 6, 10, 40, },
	{ 1, 0, 0, 6, 10, 40, },
	{ 0, 0, 0, 6, 11, 46, },
	{ 2, 0, 0, 6, 11, 40, },
	{ 1, 0, 0, 6, 11, 40, },
	{ 0, 0, 0, 6, 12, 63, },
	{ 2, 0, 0, 6, 12, 40, },
	{ 1, 0, 0, 6, 12, 40, },
	{ 0, 0, 0, 6, 13, 63, },
	{ 2, 0, 0, 6, 13, 40, },
	{ 1, 0, 0, 6, 13, 40, },
	{ 0, 0, 0, 6, 14, 63, },
	{ 2, 0, 0, 6, 14, 63, },
	{ 1, 0, 0, 6, 14, 63, },
	{ 0, 0, 0, 7, 1, 46, },
	{ 2, 0, 0, 7, 1, 40, },
	{ 1, 0, 0, 7, 1, 40, },
	{ 0, 0, 0, 7, 2, 46, },
	{ 2, 0, 0, 7, 2, 40, },
	{ 1, 0, 0, 7, 2, 40, },
	{ 0, 0, 0, 7, 3, 46, },
	{ 2, 0, 0, 7, 3, 40, },
	{ 1, 0, 0, 7, 3, 40, },
	{ 0, 0, 0, 7, 4, 46, },
	{ 2, 0, 0, 7, 4, 40, },
	{ 1, 0, 0, 7, 4, 40, },
	{ 0, 0, 0, 7, 5, 46, },
	{ 2, 0, 0, 7, 5, 40, },
	{ 1, 0, 0, 7, 5, 40, },
	{ 0, 0, 0, 7, 6, 46, },
	{ 2, 0, 0, 7, 6, 40, },
	{ 1, 0, 0, 7, 6, 40, },
	{ 0, 0, 0, 7, 7, 46, },
	{ 2, 0, 0, 7, 7, 40, },
	{ 1, 0, 0, 7, 7, 40, },
	{ 0, 0, 0, 7, 8, 46, },
	{ 2, 0, 0, 7, 8, 40, },
	{ 1, 0, 0, 7, 8, 40, },
	{ 0, 0, 0, 7, 9, 46, },
	{ 2, 0, 0, 7, 9, 40, },
	{ 1, 0, 0, 7, 9, 40, },
	{ 0, 0, 0, 7, 10, 46, },
	{ 2, 0, 0, 7, 10, 40, },
	{ 1, 0, 0, 7, 10, 40, },
	{ 0, 0, 0, 7, 11, 46, },
	{ 2, 0, 0, 7, 11, 40, },
	{ 1, 0, 0, 7, 11, 40, },
	{ 0, 0, 0, 7, 12, 63, },
	{ 2, 0, 0, 7, 12, 40, },
	{ 1, 0, 0, 7, 12, 40, },
	{ 0, 0, 0, 7, 13, 63, },
	{ 2, 0, 0, 7, 13, 40, },
	{ 1, 0, 0, 7, 13, 40, },
	{ 0, 0, 0, 7, 14, 63, },
	{ 2, 0, 0, 7, 14, 63, },
	{ 1, 0, 0, 7, 14, 63, },
	{ 0, 0, 1, 2, 1, 63, },
	{ 2, 0, 1, 2, 1, 63, },
	{ 1, 0, 1, 2, 1, 63, },
	{ 0, 0, 1, 2, 2, 63, },
	{ 2, 0, 1, 2, 2, 63, },
	{ 1, 0, 1, 2, 2, 63, },
	{ 0, 0, 1, 2, 3, 46, },
	{ 2, 0, 1, 2, 3, 40, },
	{ 1, 0, 1, 2, 3, 40, },
	{ 0, 0, 1, 2, 4, 46, },
	{ 2, 0, 1, 2, 4, 40, },
	{ 1, 0, 1, 2, 4, 40, },
	{ 0, 0, 1, 2, 5, 46, },
	{ 2, 0, 1, 2, 5, 40, },
	{ 1, 0, 1, 2, 5, 40, },
	{ 0, 0, 1, 2, 6, 46, },
	{ 2, 0, 1, 2, 6, 40, },
	{ 1, 0, 1, 2, 6, 40, },
	{ 0, 0, 1, 2, 7, 46, },
	{ 2, 0, 1, 2, 7, 40, },
	{ 1, 0, 1, 2, 7, 40, },
	{ 0, 0, 1, 2, 8, 46, },
	{ 2, 0, 1, 2, 8, 40, },
	{ 1, 0, 1, 2, 8, 40, },
	{ 0, 0, 1, 2, 9, 46, },
	{ 2, 0, 1, 2, 9, 40, },
	{ 1, 0, 1, 2, 9, 40, },
	{ 0, 0, 1, 2, 10, 46, },
	{ 2, 0, 1, 2, 10, 40, },
	{ 1, 0, 1, 2, 10, 40, },
	{ 0, 0, 1, 2, 11, 46, },
	{ 2, 0, 1, 2, 11, 40, },
	{ 1, 0, 1, 2, 11, 40, },
	{ 0, 0, 1, 2, 12, 63, },
	{ 2, 0, 1, 2, 12, 40, },
	{ 1, 0, 1, 2, 12, 40, },
	{ 0, 0, 1, 2, 13, 63, },
	{ 2, 0, 1, 2, 13, 40, },
	{ 1, 0, 1, 2, 13, 40, },
	{ 0, 0, 1, 2, 14, 63, },
	{ 2, 0, 1, 2, 14, 63, },
	{ 1, 0, 1, 2, 14, 63, },
	{ 0, 0, 1, 3, 1, 63, },
	{ 2, 0, 1, 3, 1, 63, },
	{ 1, 0, 1, 3, 1, 63, },
	{ 0, 0, 1, 3, 2, 63, },
	{ 2, 0, 1, 3, 2, 63, },
	{ 1, 0, 1, 3, 2, 63, },
	{ 0, 0, 1, 3, 3, 46, },
	{ 2, 0, 1, 3, 3, 40, },
	{ 1, 0, 1, 3, 3, 40, },
	{ 0, 0, 1, 3, 4, 46, },
	{ 2, 0, 1, 3, 4, 40, },
	{ 1, 0, 1, 3, 4, 40, },
	{ 0, 0, 1, 3, 5, 46, },
	{ 2, 0, 1, 3, 5, 40, },
	{ 1, 0, 1, 3, 5, 40, },
	{ 0, 0, 1, 3, 6, 46, },
	{ 2, 0, 1, 3, 6, 40, },
	{ 1, 0, 1, 3, 6, 40, },
	{ 0, 0, 1, 3, 7, 46, },
	{ 2, 0, 1, 3, 7, 40, },
	{ 1, 0, 1, 3, 7, 40, },
	{ 0, 0, 1, 3, 8, 46, },
	{ 2, 0, 1, 3, 8, 40, },
	{ 1, 0, 1, 3, 8, 40, },
	{ 0, 0, 1, 3, 9, 46, },
	{ 2, 0, 1, 3, 9, 40, },
	{ 1, 0, 1, 3, 9, 40, },
	{ 0, 0, 1, 3, 10, 46, },
	{ 2, 0, 1, 3, 10, 40, },
	{ 1, 0, 1, 3, 10, 40, },
	{ 0, 0, 1, 3, 11, 46, },
	{ 2, 0, 1, 3, 11, 40, },
	{ 1, 0, 1, 3, 11, 40, },
	{ 0, 0, 1, 3, 12, 63, },
	{ 2, 0, 1, 3, 12, 40, },
	{ 1, 0, 1, 3, 12, 40, },
	{ 0, 0, 1, 3, 13, 63, },
	{ 2, 0, 1, 3, 13, 40, },
	{ 1, 0, 1, 3, 13, 40, },
	{ 0, 0, 1, 3, 14, 63, },
	{ 2, 0, 1, 3, 14, 63, },
	{ 1, 0, 1, 3, 14, 63, },
	{ 0, 0, 1, 6, 1, 63, },
	{ 2, 0, 1, 6, 1, 63, },
	{ 1, 0, 1, 6, 1, 63, },
	{ 0, 0, 1, 6, 2, 63, },
	{ 2, 0, 1, 6, 2, 63, },
	{ 1, 0, 1, 6, 2, 63, },
	{ 0, 0, 1, 6, 3, 46, },
	{ 2, 0, 1, 6, 3, 40, },
	{ 1, 0, 1, 6, 3, 40, },
	{ 0, 0, 1, 6, 4, 46, },
	{ 2, 0, 1, 6, 4, 40, },
	{ 1, 0, 1, 6, 4, 40, },
	{ 0, 0, 1, 6, 5, 46, },
	{ 2, 0, 1, 6, 5, 40, },
	{ 1, 0, 1, 6, 5, 40, },
	{ 0, 0, 1, 6, 6, 46, },
	{ 2, 0, 1, 6, 6, 40, },
	{ 1, 0, 1, 6, 6, 40, },
	{ 0, 0, 1, 6, 7, 46, },
	{ 2, 0, 1, 6, 7, 40, },
	{ 1, 0, 1, 6, 7, 40, },
	{ 0, 0, 1, 6, 8, 46, },
	{ 2, 0, 1, 6, 8, 40, },
	{ 1, 0, 1, 6, 8, 40, },
	{ 0, 0, 1, 6, 9, 46, },
	{ 2, 0, 1, 6, 9, 40, },
	{ 1, 0, 1, 6, 9, 40, },
	{ 0, 0, 1, 6, 10, 46, },
	{ 2, 0, 1, 6, 10, 40, },
	{ 1, 0, 1, 6, 10, 40, },
	{ 0, 0, 1, 6, 11, 46, },
	{ 2, 0, 1, 6, 11, 40, },
	{ 1, 0, 1, 6, 11, 40, },
	{ 0, 0, 1, 6, 12, 63, },
	{ 2, 0, 1, 6, 12, 40, },
	{ 1, 0, 1, 6, 12, 40, },
	{ 0, 0, 1, 6, 13, 63, },
	{ 2, 0, 1, 6, 13, 40, },
	{ 1, 0, 1, 6, 13, 40, },
	{ 0, 0, 1, 6, 14, 63, },
	{ 2, 0, 1, 6, 14, 63, },
	{ 1, 0, 1, 6, 14, 63, },
	{ 0, 0, 1, 7, 1, 63, },
	{ 2, 0, 1, 7, 1, 63, },
	{ 1, 0, 1, 7, 1, 63, },
	{ 0, 0, 1, 7, 2, 63, },
	{ 2, 0, 1, 7, 2, 63, },
	{ 1, 0, 1, 7, 2, 63, },
	{ 0, 0, 1, 7, 3, 46, },
	{ 2, 0, 1, 7, 3, 40, },
	{ 1, 0, 1, 7, 3, 40, },
	{ 0, 0, 1, 7, 4, 46, },
	{ 2, 0, 1, 7, 4, 40, },
	{ 1, 0, 1, 7, 4, 40, },
	{ 0, 0, 1, 7, 5, 46, },
	{ 2, 0, 1, 7, 5, 40, },
	{ 1, 0, 1, 7, 5, 40, },
	{ 0, 0, 1, 7, 6, 46, },
	{ 2, 0, 1, 7, 6, 40, },
	{ 1, 0, 1, 7, 6, 40, },
	{ 0, 0, 1, 7, 7, 46, },
	{ 2, 0, 1, 7, 7, 40, },
	{ 1, 0, 1, 7, 7, 40, },
	{ 0, 0, 1, 7, 8, 46, },
	{ 2, 0, 1, 7, 8, 40, },
	{ 1, 0, 1, 7, 8, 40, },
	{ 0, 0, 1, 7, 9, 46, },
	{ 2, 0, 1, 7, 9, 40, },
	{ 1, 0, 1, 7, 9, 40, },
	{ 0, 0, 1, 7, 10, 46, },
	{ 2, 0, 1, 7, 10, 40, },
	{ 1, 0, 1, 7, 10, 40, },
	{ 0, 0, 1, 7, 11, 46, },
	{ 2, 0, 1, 7, 11, 40, },
	{ 1, 0, 1, 7, 11, 40, },
	{ 0, 0, 1, 7, 12, 63, },
	{ 2, 0, 1, 7, 12, 40, },
	{ 1, 0, 1, 7, 12, 40, },
	{ 0, 0, 1, 7, 13, 63, },
	{ 2, 0, 1, 7, 13, 40, },
	{ 1, 0, 1, 7, 13, 40, },
	{ 0, 0, 1, 7, 14, 63, },
	{ 2, 0, 1, 7, 14, 63, },
	{ 1, 0, 1, 7, 14, 63, },
	{ 0, 1, 0, 1, 36, 46, },
	{ 2, 1, 0, 1, 36, 40, },
	{ 1, 1, 0, 1, 36, 40, },
	{ 0, 1, 0, 1, 40, 46, },
	{ 2, 1, 0, 1, 40, 40, },
	{ 1, 1, 0, 1, 40, 40, },
	{ 0, 1, 0, 1, 44, 46, },
	{ 2, 1, 0, 1, 44, 40, },
	{ 1, 1, 0, 1, 44, 40, },
	{ 0, 1, 0, 1, 48, 46, },
	{ 2, 1, 0, 1, 48, 40, },
	{ 1, 1, 0, 1, 48, 40, },
	{ 0, 1, 0, 1, 52, 46, },
	{ 2, 1, 0, 1, 52, 40, },
	{ 1, 1, 0, 1, 52, 40, },
	{ 0, 1, 0, 1, 56, 46, },
	{ 2, 1, 0, 1, 56, 40, },
	{ 1, 1, 0, 1, 56, 40, },
	{ 0, 1, 0, 1, 60, 46, },
	{ 2, 1, 0, 1, 60, 40, },
	{ 1, 1, 0, 1, 60, 40, },
	{ 0, 1, 0, 1, 64, 46, },
	{ 2, 1, 0, 1, 64, 40, },
	{ 1, 1, 0, 1, 64, 40, },
	{ 0, 1, 0, 1, 100, 46, },
	{ 2, 1, 0, 1, 100, 40, },
	{ 1, 1, 0, 1, 100, 40, },
	{ 0, 1, 0, 1, 104, 46, },
	{ 2, 1, 0, 1, 104, 40, },
	{ 1, 1, 0, 1, 104, 40, },
	{ 0, 1, 0, 1, 108, 46, },
	{ 2, 1, 0, 1, 108, 40, },
	{ 1, 1, 0, 1, 108, 40, },
	{ 0, 1, 0, 1, 112, 46, },
	{ 2, 1, 0, 1, 112, 40, },
	{ 1, 1, 0, 1, 112, 40, },
	{ 0, 1, 0, 1, 116, 46, },
	{ 2, 1, 0, 1, 116, 40, },
	{ 1, 1, 0, 1, 116, 40, },
	{ 0, 1, 0, 1, 120, 46, },
	{ 2, 1, 0, 1, 120, 40, },
	{ 1, 1, 0, 1, 120, 40, },
	{ 0, 1, 0, 1, 124, 46, },
	{ 2, 1, 0, 1, 124, 40, },
	{ 1, 1, 0, 1, 124, 40, },
	{ 0, 1, 0, 1, 128, 46, },
	{ 2, 1, 0, 1, 128, 40, },
	{ 1, 1, 0, 1, 128, 40, },
	{ 0, 1, 0, 1, 132, 46, },
	{ 2, 1, 0, 1, 132, 40, },
	{ 1, 1, 0, 1, 132, 40, },
	{ 0, 1, 0, 1, 136, 46, },
	{ 2, 1, 0, 1, 136, 40, },
	{ 1, 1, 0, 1, 136, 40, },
	{ 0, 1, 0, 1, 140, 46, },
	{ 2, 1, 0, 1, 140, 40, },
	{ 1, 1, 0, 1, 140, 40, },
	{ 0, 1, 0, 1, 149, 46, },
	{ 2, 1, 0, 1, 149, 40, },
	{ 1, 1, 0, 1, 149, 63, },
	{ 0, 1, 0, 1, 153, 46, },
	{ 2, 1, 0, 1, 153, 40, },
	{ 1, 1, 0, 1, 153, 63, },
	{ 0, 1, 0, 1, 157, 46, },
	{ 2, 1, 0, 1, 157, 40, },
	{ 1, 1, 0, 1, 157, 63, },
	{ 0, 1, 0, 1, 161, 46, },
	{ 2, 1, 0, 1, 161, 40, },
	{ 1, 1, 0, 1, 161, 63, },
	{ 0, 1, 0, 1, 165, 46, },
	{ 2, 1, 0, 1, 165, 40, },
	{ 1, 1, 0, 1, 165, 63, },
	{ 0, 1, 0, 2, 36, 46, },
	{ 2, 1, 0, 2, 36, 40, },
	{ 1, 1, 0, 2, 36, 40, },
	{ 0, 1, 0, 2, 40, 46, },
	{ 2, 1, 0, 2, 40, 40, },
	{ 1, 1, 0, 2, 40, 40, },
	{ 0, 1, 0, 2, 44, 46, },
	{ 2, 1, 0, 2, 44, 40, },
	{ 1, 1, 0, 2, 44, 40, },
	{ 0, 1, 0, 2, 48, 46, },
	{ 2, 1, 0, 2, 48, 40, },
	{ 1, 1, 0, 2, 48, 40, },
	{ 0, 1, 0, 2, 52, 46, },
	{ 2, 1, 0, 2, 52, 40, },
	{ 1, 1, 0, 2, 52, 40, },
	{ 0, 1, 0, 2, 56, 46, },
	{ 2, 1, 0, 2, 56, 40, },
	{ 1, 1, 0, 2, 56, 40, },
	{ 0, 1, 0, 2, 60, 46, },
	{ 2, 1, 0, 2, 60, 40, },
	{ 1, 1, 0, 2, 60, 40, },
	{ 0, 1, 0, 2, 64, 46, },
	{ 2, 1, 0, 2, 64, 40, },
	{ 1, 1, 0, 2, 64, 40, },
	{ 0, 1, 0, 2, 100, 46, },
	{ 2, 1, 0, 2, 100, 40, },
	{ 1, 1, 0, 2, 100, 40, },
	{ 0, 1, 0, 2, 104, 46, },
	{ 2, 1, 0, 2, 104, 40, },
	{ 1, 1, 0, 2, 104, 40, },
	{ 0, 1, 0, 2, 108, 46, },
	{ 2, 1, 0, 2, 108, 40, },
	{ 1, 1, 0, 2, 108, 40, },
	{ 0, 1, 0, 2, 112, 46, },
	{ 2, 1, 0, 2, 112, 40, },
	{ 1, 1, 0, 2, 112, 40, },
	{ 0, 1, 0, 2, 116, 46, },
	{ 2, 1, 0, 2, 116, 40, },
	{ 1, 1, 0, 2, 116, 40, },
	{ 0, 1, 0, 2, 120, 46, },
	{ 2, 1, 0, 2, 120, 40, },
	{ 1, 1, 0, 2, 120, 40, },
	{ 0, 1, 0, 2, 124, 46, },
	{ 2, 1, 0, 2, 124, 40, },
	{ 1, 1, 0, 2, 124, 40, },
	{ 0, 1, 0, 2, 128, 46, },
	{ 2, 1, 0, 2, 128, 40, },
	{ 1, 1, 0, 2, 128, 40, },
	{ 0, 1, 0, 2, 132, 46, },
	{ 2, 1, 0, 2, 132, 40, },
	{ 1, 1, 0, 2, 132, 40, },
	{ 0, 1, 0, 2, 136, 46, },
	{ 2, 1, 0, 2, 136, 40, },
	{ 1, 1, 0, 2, 136, 40, },
	{ 0, 1, 0, 2, 140, 46, },
	{ 2, 1, 0, 2, 140, 40, },
	{ 1, 1, 0, 2, 140, 40, },
	{ 0, 1, 0, 2, 149, 46, },
	{ 2, 1, 0, 2, 149, 40, },
	{ 1, 1, 0, 2, 149, 63, },
	{ 0, 1, 0, 2, 153, 46, },
	{ 2, 1, 0, 2, 153, 40, },
	{ 1, 1, 0, 2, 153, 63, },
	{ 0, 1, 0, 2, 157, 46, },
	{ 2, 1, 0, 2, 157, 40, },
	{ 1, 1, 0, 2, 157, 63, },
	{ 0, 1, 0, 2, 161, 46, },
	{ 2, 1, 0, 2, 161, 40, },
	{ 1, 1, 0, 2, 161, 63, },
	{ 0, 1, 0, 2, 165, 46, },
	{ 2, 1, 0, 2, 165, 40, },
	{ 1, 1, 0, 2, 165, 63, },
	{ 0, 1, 0, 3, 36, 46, },
	{ 2, 1, 0, 3, 36, 40, },
	{ 1, 1, 0, 3, 36, 40, },
	{ 0, 1, 0, 3, 40, 46, },
	{ 2, 1, 0, 3, 40, 40, },
	{ 1, 1, 0, 3, 40, 40, },
	{ 0, 1, 0, 3, 44, 46, },
	{ 2, 1, 0, 3, 44, 40, },
	{ 1, 1, 0, 3, 44, 40, },
	{ 0, 1, 0, 3, 48, 46, },
	{ 2, 1, 0, 3, 48, 40, },
	{ 1, 1, 0, 3, 48, 40, },
	{ 0, 1, 0, 3, 52, 46, },
	{ 2, 1, 0, 3, 52, 40, },
	{ 1, 1, 0, 3, 52, 40, },
	{ 0, 1, 0, 3, 56, 46, },
	{ 2, 1, 0, 3, 56, 40, },
	{ 1, 1, 0, 3, 56, 40, },
	{ 0, 1, 0, 3, 60, 46, },
	{ 2, 1, 0, 3, 60, 40, },
	{ 1, 1, 0, 3, 60, 40, },
	{ 0, 1, 0, 3, 64, 46, },
	{ 2, 1, 0, 3, 64, 40, },
	{ 1, 1, 0, 3, 64, 40, },
	{ 0, 1, 0, 3, 100, 46, },
	{ 2, 1, 0, 3, 100, 40, },
	{ 1, 1, 0, 3, 100, 40, },
	{ 0, 1, 0, 3, 104, 46, },
	{ 2, 1, 0, 3, 104, 40, },
	{ 1, 1, 0, 3, 104, 40, },
	{ 0, 1, 0, 3, 108, 46, },
	{ 2, 1, 0, 3, 108, 40, },
	{ 1, 1, 0, 3, 108, 40, },
	{ 0, 1, 0, 3, 112, 46, },
	{ 2, 1, 0, 3, 112, 40, },
	{ 1, 1, 0, 3, 112, 40, },
	{ 0, 1, 0, 3, 116, 46, },
	{ 2, 1, 0, 3, 116, 40, },
	{ 1, 1, 0, 3, 116, 40, },
	{ 0, 1, 0, 3, 120, 46, },
	{ 2, 1, 0, 3, 120, 40, },
	{ 1, 1, 0, 3, 120, 40, },
	{ 0, 1, 0, 3, 124, 46, },
	{ 2, 1, 0, 3, 124, 40, },
	{ 1, 1, 0, 3, 124, 40, },
	{ 0, 1, 0, 3, 128, 46, },
	{ 2, 1, 0, 3, 128, 40, },
	{ 1, 1, 0, 3, 128, 40, },
	{ 0, 1, 0, 3, 132, 46, },
	{ 2, 1, 0, 3, 132, 40, },
	{ 1, 1, 0, 3, 132, 40, },
	{ 0, 1, 0, 3, 136, 46, },
	{ 2, 1, 0, 3, 136, 40, },
	{ 1, 1, 0, 3, 136, 40, },
	{ 0, 1, 0, 3, 140, 46, },
	{ 2, 1, 0, 3, 140, 40, },
	{ 1, 1, 0, 3, 140, 40, },
	{ 0, 1, 0, 3, 149, 46, },
	{ 2, 1, 0, 3, 149, 40, },
	{ 1, 1, 0, 3, 149, 63, },
	{ 0, 1, 0, 3, 153, 46, },
	{ 2, 1, 0, 3, 153, 40, },
	{ 1, 1, 0, 3, 153, 63, },
	{ 0, 1, 0, 3, 157, 46, },
	{ 2, 1, 0, 3, 157, 40, },
	{ 1, 1, 0, 3, 157, 63, },
	{ 0, 1, 0, 3, 161, 46, },
	{ 2, 1, 0, 3, 161, 40, },
	{ 1, 1, 0, 3, 161, 63, },
	{ 0, 1, 0, 3, 165, 46, },
	{ 2, 1, 0, 3, 165, 40, },
	{ 1, 1, 0, 3, 165, 63, },
	{ 0, 1, 0, 6, 36, 46, },
	{ 2, 1, 0, 6, 36, 40, },
	{ 1, 1, 0, 6, 36, 40, },
	{ 0, 1, 0, 6, 40, 46, },
	{ 2, 1, 0, 6, 40, 40, },
	{ 1, 1, 0, 6, 40, 40, },
	{ 0, 1, 0, 6, 44, 46, },
	{ 2, 1, 0, 6, 44, 40, },
	{ 1, 1, 0, 6, 44, 40, },
	{ 0, 1, 0, 6, 48, 46, },
	{ 2, 1, 0, 6, 48, 40, },
	{ 1, 1, 0, 6, 48, 40, },
	{ 0, 1, 0, 6, 52, 46, },
	{ 2, 1, 0, 6, 52, 40, },
	{ 1, 1, 0, 6, 52, 40, },
	{ 0, 1, 0, 6, 56, 46, },
	{ 2, 1, 0, 6, 56, 40, },
	{ 1, 1, 0, 6, 56, 40, },
	{ 0, 1, 0, 6, 60, 46, },
	{ 2, 1, 0, 6, 60, 40, },
	{ 1, 1, 0, 6, 60, 40, },
	{ 0, 1, 0, 6, 64, 46, },
	{ 2, 1, 0, 6, 64, 40, },
	{ 1, 1, 0, 6, 64, 40, },
	{ 0, 1, 0, 6, 100, 46, },
	{ 2, 1, 0, 6, 100, 40, },
	{ 1, 1, 0, 6, 100, 40, },
	{ 0, 1, 0, 6, 104, 46, },
	{ 2, 1, 0, 6, 104, 40, },
	{ 1, 1, 0, 6, 104, 40, },
	{ 0, 1, 0, 6, 108, 46, },
	{ 2, 1, 0, 6, 108, 40, },
	{ 1, 1, 0, 6, 108, 40, },
	{ 0, 1, 0, 6, 112, 46, },
	{ 2, 1, 0, 6, 112, 40, },
	{ 1, 1, 0, 6, 112, 40, },
	{ 0, 1, 0, 6, 116, 46, },
	{ 2, 1, 0, 6, 116, 40, },
	{ 1, 1, 0, 6, 116, 40, },
	{ 0, 1, 0, 6, 120, 46, },
	{ 2, 1, 0, 6, 120, 40, },
	{ 1, 1, 0, 6, 120, 40, },
	{ 0, 1, 0, 6, 124, 46, },
	{ 2, 1, 0, 6, 124, 40, },
	{ 1, 1, 0, 6, 124, 40, },
	{ 0, 1, 0, 6, 128, 46, },
	{ 2, 1, 0, 6, 128, 40, },
	{ 1, 1, 0, 6, 128, 40, },
	{ 0, 1, 0, 6, 132, 46, },
	{ 2, 1, 0, 6, 132, 40, },
	{ 1, 1, 0, 6, 132, 40, },
	{ 0, 1, 0, 6, 136, 46, },
	{ 2, 1, 0, 6, 136, 40, },
	{ 1, 1, 0, 6, 136, 40, },
	{ 0, 1, 0, 6, 140, 46, },
	{ 2, 1, 0, 6, 140, 40, },
	{ 1, 1, 0, 6, 140, 40, },
	{ 0, 1, 0, 6, 149, 46, },
	{ 2, 1, 0, 6, 149, 40, },
	{ 1, 1, 0, 6, 149, 63, },
	{ 0, 1, 0, 6, 153, 46, },
	{ 2, 1, 0, 6, 153, 40, },
	{ 1, 1, 0, 6, 153, 63, },
	{ 0, 1, 0, 6, 157, 46, },
	{ 2, 1, 0, 6, 157, 40, },
	{ 1, 1, 0, 6, 157, 63, },
	{ 0, 1, 0, 6, 161, 46, },
	{ 2, 1, 0, 6, 161, 40, },
	{ 1, 1, 0, 6, 161, 63, },
	{ 0, 1, 0, 6, 165, 46, },
	{ 2, 1, 0, 6, 165, 40, },
	{ 1, 1, 0, 6, 165, 63, },
	{ 0, 1, 0, 7, 36, 46, },
	{ 2, 1, 0, 7, 36, 40, },
	{ 1, 1, 0, 7, 36, 40, },
	{ 0, 1, 0, 7, 40, 46, },
	{ 2, 1, 0, 7, 40, 40, },
	{ 1, 1, 0, 7, 40, 40, },
	{ 0, 1, 0, 7, 44, 46, },
	{ 2, 1, 0, 7, 44, 40, },
	{ 1, 1, 0, 7, 44, 40, },
	{ 0, 1, 0, 7, 48, 46, },
	{ 2, 1, 0, 7, 48, 40, },
	{ 1, 1, 0, 7, 48, 40, },
	{ 0, 1, 0, 7, 52, 46, },
	{ 2, 1, 0, 7, 52, 40, },
	{ 1, 1, 0, 7, 52, 40, },
	{ 0, 1, 0, 7, 56, 46, },
	{ 2, 1, 0, 7, 56, 40, },
	{ 1, 1, 0, 7, 56, 40, },
	{ 0, 1, 0, 7, 60, 46, },
	{ 2, 1, 0, 7, 60, 40, },
	{ 1, 1, 0, 7, 60, 40, },
	{ 0, 1, 0, 7, 64, 46, },
	{ 2, 1, 0, 7, 64, 40, },
	{ 1, 1, 0, 7, 64, 40, },
	{ 0, 1, 0, 7, 100, 46, },
	{ 2, 1, 0, 7, 100, 40, },
	{ 1, 1, 0, 7, 100, 40, },
	{ 0, 1, 0, 7, 104, 46, },
	{ 2, 1, 0, 7, 104, 40, },
	{ 1, 1, 0, 7, 104, 40, },
	{ 0, 1, 0, 7, 108, 46, },
	{ 2, 1, 0, 7, 108, 40, },
	{ 1, 1, 0, 7, 108, 40, },
	{ 0, 1, 0, 7, 112, 46, },
	{ 2, 1, 0, 7, 112, 40, },
	{ 1, 1, 0, 7, 112, 40, },
	{ 0, 1, 0, 7, 116, 46, },
	{ 2, 1, 0, 7, 116, 40, },
	{ 1, 1, 0, 7, 116, 40, },
	{ 0, 1, 0, 7, 120, 46, },
	{ 2, 1, 0, 7, 120, 40, },
	{ 1, 1, 0, 7, 120, 40, },
	{ 0, 1, 0, 7, 124, 46, },
	{ 2, 1, 0, 7, 124, 40, },
	{ 1, 1, 0, 7, 124, 40, },
	{ 0, 1, 0, 7, 128, 46, },
	{ 2, 1, 0, 7, 128, 40, },
	{ 1, 1, 0, 7, 128, 40, },
	{ 0, 1, 0, 7, 132, 46, },
	{ 2, 1, 0, 7, 132, 40, },
	{ 1, 1, 0, 7, 132, 40, },
	{ 0, 1, 0, 7, 136, 46, },
	{ 2, 1, 0, 7, 136, 40, },
	{ 1, 1, 0, 7, 136, 40, },
	{ 0, 1, 0, 7, 140, 46, },
	{ 2, 1, 0, 7, 140, 40, },
	{ 1, 1, 0, 7, 140, 40, },
	{ 0, 1, 0, 7, 149, 46, },
	{ 2, 1, 0, 7, 149, 40, },
	{ 1, 1, 0, 7, 149, 63, },
	{ 0, 1, 0, 7, 153, 46, },
	{ 2, 1, 0, 7, 153, 40, },
	{ 1, 1, 0, 7, 153, 63, },
	{ 0, 1, 0, 7, 157, 46, },
	{ 2, 1, 0, 7, 157, 40, },
	{ 1, 1, 0, 7, 157, 63, },
	{ 0, 1, 0, 7, 161, 46, },
	{ 2, 1, 0, 7, 161, 40, },
	{ 1, 1, 0, 7, 161, 63, },
	{ 0, 1, 0, 7, 165, 46, },
	{ 2, 1, 0, 7, 165, 40, },
	{ 1, 1, 0, 7, 165, 63, },
	{ 0, 1, 1, 2, 38, 46, },
	{ 2, 1, 1, 2, 38, 40, },
	{ 1, 1, 1, 2, 38, 40, },
	{ 0, 1, 1, 2, 46, 46, },
	{ 2, 1, 1, 2, 46, 40, },
	{ 1, 1, 1, 2, 46, 40, },
	{ 0, 1, 1, 2, 54, 46, },
	{ 2, 1, 1, 2, 54, 40, },
	{ 1, 1, 1, 2, 54, 40, },
	{ 0, 1, 1, 2, 62, 46, },
	{ 2, 1, 1, 2, 62, 40, },
	{ 1, 1, 1, 2, 62, 40, },
	{ 0, 1, 1, 2, 102, 46, },
	{ 2, 1, 1, 2, 102, 40, },
	{ 1, 1, 1, 2, 102, 40, },
	{ 0, 1, 1, 2, 110, 46, },
	{ 2, 1, 1, 2, 110, 40, },
	{ 1, 1, 1, 2, 110, 40, },
	{ 0, 1, 1, 2, 118, 46, },
	{ 2, 1, 1, 2, 118, 40, },
	{ 1, 1, 1, 2, 118, 40, },
	{ 0, 1, 1, 2, 126, 46, },
	{ 2, 1, 1, 2, 126, 40, },
	{ 1, 1, 1, 2, 126, 40, },
	{ 0, 1, 1, 2, 134, 46, },
	{ 2, 1, 1, 2, 134, 40, },
	{ 1, 1, 1, 2, 134, 40, },
	{ 0, 1, 1, 2, 151, 46, },
	{ 2, 1, 1, 2, 151, 40, },
	{ 1, 1, 1, 2, 151, 63, },
	{ 0, 1, 1, 2, 159, 46, },
	{ 2, 1, 1, 2, 159, 40, },
	{ 1, 1, 1, 2, 159, 63, },
	{ 0, 1, 1, 3, 38, 46, },
	{ 2, 1, 1, 3, 38, 40, },
	{ 1, 1, 1, 3, 38, 40, },
	{ 0, 1, 1, 3, 46, 46, },
	{ 2, 1, 1, 3, 46, 40, },
	{ 1, 1, 1, 3, 46, 40, },
	{ 0, 1, 1, 3, 54, 46, },
	{ 2, 1, 1, 3, 54, 40, },
	{ 1, 1, 1, 3, 54, 40, },
	{ 0, 1, 1, 3, 62, 46, },
	{ 2, 1, 1, 3, 62, 40, },
	{ 1, 1, 1, 3, 62, 40, },
	{ 0, 1, 1, 3, 102, 46, },
	{ 2, 1, 1, 3, 102, 40, },
	{ 1, 1, 1, 3, 102, 40, },
	{ 0, 1, 1, 3, 110, 46, },
	{ 2, 1, 1, 3, 110, 40, },
	{ 1, 1, 1, 3, 110, 40, },
	{ 0, 1, 1, 3, 118, 46, },
	{ 2, 1, 1, 3, 118, 40, },
	{ 1, 1, 1, 3, 118, 40, },
	{ 0, 1, 1, 3, 126, 46, },
	{ 2, 1, 1, 3, 126, 40, },
	{ 1, 1, 1, 3, 126, 40, },
	{ 0, 1, 1, 3, 134, 46, },
	{ 2, 1, 1, 3, 134, 40, },
	{ 1, 1, 1, 3, 134, 40, },
	{ 0, 1, 1, 3, 151, 46, },
	{ 2, 1, 1, 3, 151, 40, },
	{ 1, 1, 1, 3, 151, 63, },
	{ 0, 1, 1, 3, 159, 46, },
	{ 2, 1, 1, 3, 159, 40, },
	{ 1, 1, 1, 3, 159, 63, },
	{ 0, 1, 1, 6, 38, 46, },
	{ 2, 1, 1, 6, 38, 40, },
	{ 1, 1, 1, 6, 38, 40, },
	{ 0, 1, 1, 6, 46, 46, },
	{ 2, 1, 1, 6, 46, 40, },
	{ 1, 1, 1, 6, 46, 40, },
	{ 0, 1, 1, 6, 54, 46, },
	{ 2, 1, 1, 6, 54, 40, },
	{ 1, 1, 1, 6, 54, 40, },
	{ 0, 1, 1, 6, 62, 46, },
	{ 2, 1, 1, 6, 62, 40, },
	{ 1, 1, 1, 6, 62, 40, },
	{ 0, 1, 1, 6, 102, 46, },
	{ 2, 1, 1, 6, 102, 40, },
	{ 1, 1, 1, 6, 102, 40, },
	{ 0, 1, 1, 6, 110, 46, },
	{ 2, 1, 1, 6, 110, 40, },
	{ 1, 1, 1, 6, 110, 40, },
	{ 0, 1, 1, 6, 118, 46, },
	{ 2, 1, 1, 6, 118, 40, },
	{ 1, 1, 1, 6, 118, 40, },
	{ 0, 1, 1, 6, 126, 46, },
	{ 2, 1, 1, 6, 126, 40, },
	{ 1, 1, 1, 6, 126, 40, },
	{ 0, 1, 1, 6, 134, 46, },
	{ 2, 1, 1, 6, 134, 40, },
	{ 1, 1, 1, 6, 134, 40, },
	{ 0, 1, 1, 6, 151, 46, },
	{ 2, 1, 1, 6, 151, 40, },
	{ 1, 1, 1, 6, 151, 63, },
	{ 0, 1, 1, 6, 159, 46, },
	{ 2, 1, 1, 6, 159, 40, },
	{ 1, 1, 1, 6, 159, 63, },
	{ 0, 1, 1, 7, 38, 46, },
	{ 2, 1, 1, 7, 38, 40, },
	{ 1, 1, 1, 7, 38, 40, },
	{ 0, 1, 1, 7, 46, 46, },
	{ 2, 1, 1, 7, 46, 40, },
	{ 1, 1, 1, 7, 46, 40, },
	{ 0, 1, 1, 7, 54, 46, },
	{ 2, 1, 1, 7, 54, 40, },
	{ 1, 1, 1, 7, 54, 40, },
	{ 0, 1, 1, 7, 62, 46, },
	{ 2, 1, 1, 7, 62, 40, },
	{ 1, 1, 1, 7, 62, 40, },
	{ 0, 1, 1, 7, 102, 46, },
	{ 2, 1, 1, 7, 102, 40, },
	{ 1, 1, 1, 7, 102, 40, },
	{ 0, 1, 1, 7, 110, 46, },
	{ 2, 1, 1, 7, 110, 40, },
	{ 1, 1, 1, 7, 110, 40, },
	{ 0, 1, 1, 7, 118, 46, },
	{ 2, 1, 1, 7, 118, 40, },
	{ 1, 1, 1, 7, 118, 40, },
	{ 0, 1, 1, 7, 126, 46, },
	{ 2, 1, 1, 7, 126, 40, },
	{ 1, 1, 1, 7, 126, 40, },
	{ 0, 1, 1, 7, 134, 46, },
	{ 2, 1, 1, 7, 134, 40, },
	{ 1, 1, 1, 7, 134, 40, },
	{ 0, 1, 1, 7, 151, 46, },
	{ 2, 1, 1, 7, 151, 40, },
	{ 1, 1, 1, 7, 151, 63, },
	{ 0, 1, 1, 7, 159, 46, },
	{ 2, 1, 1, 7, 159, 40, },
	{ 1, 1, 1, 7, 159, 63, },
	{ 0, 1, 2, 4, 42, 46, },
	{ 2, 1, 2, 4, 42, 40, },
	{ 1, 1, 2, 4, 42, 40, },
	{ 0, 1, 2, 4, 58, 46, },
	{ 2, 1, 2, 4, 58, 40, },
	{ 1, 1, 2, 4, 58, 40, },
	{ 0, 1, 2, 4, 106, 46, },
	{ 2, 1, 2, 4, 106, 40, },
	{ 1, 1, 2, 4, 106, 40, },
	{ 0, 1, 2, 4, 122, 46, },
	{ 2, 1, 2, 4, 122, 40, },
	{ 1, 1, 2, 4, 122, 40, },
	{ 0, 1, 2, 4, 155, 46, },
	{ 2, 1, 2, 4, 155, 40, },
	{ 1, 1, 2, 4, 155, 63, },
	{ 0, 1, 2, 5, 42, 46, },
	{ 2, 1, 2, 5, 42, 40, },
	{ 1, 1, 2, 5, 42, 40, },
	{ 0, 1, 2, 5, 58, 46, },
	{ 2, 1, 2, 5, 58, 40, },
	{ 1, 1, 2, 5, 58, 40, },
	{ 0, 1, 2, 5, 106, 46, },
	{ 2, 1, 2, 5, 106, 40, },
	{ 1, 1, 2, 5, 106, 40, },
	{ 0, 1, 2, 5, 122, 46, },
	{ 2, 1, 2, 5, 122, 40, },
	{ 1, 1, 2, 5, 122, 40, },
	{ 0, 1, 2, 5, 155, 46, },
	{ 2, 1, 2, 5, 155, 40, },
	{ 1, 1, 2, 5, 155, 63, },
	{ 0, 1, 2, 8, 42, 46, },
	{ 2, 1, 2, 8, 42, 40, },
	{ 1, 1, 2, 8, 42, 40, },
	{ 0, 1, 2, 8, 58, 46, },
	{ 2, 1, 2, 8, 58, 40, },
	{ 1, 1, 2, 8, 58, 40, },
	{ 0, 1, 2, 8, 106, 46, },
	{ 2, 1, 2, 8, 106, 40, },
	{ 1, 1, 2, 8, 106, 40, },
	{ 0, 1, 2, 8, 122, 46, },
	{ 2, 1, 2, 8, 122, 40, },
	{ 1, 1, 2, 8, 122, 40, },
	{ 0, 1, 2, 8, 155, 46, },
	{ 2, 1, 2, 8, 155, 40, },
	{ 1, 1, 2, 8, 155, 63, },
	{ 0, 1, 2, 9, 42, 46, },
	{ 2, 1, 2, 9, 42, 40, },
	{ 1, 1, 2, 9, 42, 40, },
	{ 0, 1, 2, 9, 58, 46, },
	{ 2, 1, 2, 9, 58, 40, },
	{ 1, 1, 2, 9, 58, 40, },
	{ 0, 1, 2, 9, 106, 46, },
	{ 2, 1, 2, 9, 106, 40, },
	{ 1, 1, 2, 9, 106, 40, },
	{ 0, 1, 2, 9, 122, 46, },
	{ 2, 1, 2, 9, 122, 40, },
	{ 1, 1, 2, 9, 122, 40, },
	{ 0, 1, 2, 9, 155, 46, },
	{ 2, 1, 2, 9, 155, 40, },
	{ 1, 1, 2, 9, 155, 63, },
};

RTW_DECL_TABLE_TXPWR_LMT(rtw8814a_txpwr_lmt_type5);

static const struct rtw_txpwr_lmt_cfg_pair rtw8814a_txpwr_lmt_type7[] = {
	{ 0, 0, 0, 0, 1, 44, },
	{ 2, 0, 0, 0, 1, 32, },
	{ 1, 0, 0, 0, 1, 32, },
	{ 0, 0, 0, 0, 2, 52, },
	{ 2, 0, 0, 0, 2, 32, },
	{ 1, 0, 0, 0, 2, 32, },
	{ 0, 0, 0, 0, 3, 52, },
	{ 2, 0, 0, 0, 3, 32, },
	{ 1, 0, 0, 0, 3, 32, },
	{ 0, 0, 0, 0, 4, 52, },
	{ 2, 0, 0, 0, 4, 32, },
	{ 1, 0, 0, 0, 4, 32, },
	{ 0, 0, 0, 0, 5, 52, },
	{ 2, 0, 0, 0, 5, 32, },
	{ 1, 0, 0, 0, 5, 32, },
	{ 0, 0, 0, 0, 6, 52, },
	{ 2, 0, 0, 0, 6, 32, },
	{ 1, 0, 0, 0, 6, 32, },
	{ 0, 0, 0, 0, 7, 52, },
	{ 2, 0, 0, 0, 7, 32, },
	{ 1, 0, 0, 0, 7, 32, },
	{ 0, 0, 0, 0, 8, 52, },
	{ 2, 0, 0, 0, 8, 32, },
	{ 1, 0, 0, 0, 8, 32, },
	{ 0, 0, 0, 0, 9, 52, },
	{ 2, 0, 0, 0, 9, 32, },
	{ 1, 0, 0, 0, 9, 32, },
	{ 0, 0, 0, 0, 10, 52, },
	{ 2, 0, 0, 0, 10, 32, },
	{ 1, 0, 0, 0, 10, 32, },
	{ 0, 0, 0, 0, 11, 44, },
	{ 2, 0, 0, 0, 11, 32, },
	{ 1, 0, 0, 0, 11, 32, },
	{ 0, 0, 0, 0, 12, 63, },
	{ 2, 0, 0, 0, 12, 32, },
	{ 1, 0, 0, 0, 12, 32, },
	{ 0, 0, 0, 0, 13, 63, },
	{ 2, 0, 0, 0, 13, 32, },
	{ 1, 0, 0, 0, 13, 32, },
	{ 0, 0, 0, 0, 14, 63, },
	{ 2, 0, 0, 0, 14, 63, },
	{ 1, 0, 0, 0, 14, 32, },
	{ 0, 0, 0, 1, 1, 38, },
	{ 2, 0, 0, 1, 1, 32, },
	{ 1, 0, 0, 1, 1, 32, },
	{ 0, 0, 0, 1, 2, 46, },
	{ 2, 0, 0, 1, 2, 32, },
	{ 1, 0, 0, 1, 2, 32, },
	{ 0, 0, 0, 1, 3, 46, },
	{ 2, 0, 0, 1, 3, 32, },
	{ 1, 0, 0, 1, 3, 32, },
	{ 0, 0, 0, 1, 4, 46, },
	{ 2, 0, 0, 1, 4, 32, },
	{ 1, 0, 0, 1, 4, 32, },
	{ 0, 0, 0, 1, 5, 46, },
	{ 2, 0, 0, 1, 5, 32, },
	{ 1, 0, 0, 1, 5, 32, },
	{ 0, 0, 0, 1, 6, 46, },
	{ 2, 0, 0, 1, 6, 32, },
	{ 1, 0, 0, 1, 6, 32, },
	{ 0, 0, 0, 1, 7, 46, },
	{ 2, 0, 0, 1, 7, 32, },
	{ 1, 0, 0, 1, 7, 32, },
	{ 0, 0, 0, 1, 8, 46, },
	{ 2, 0, 0, 1, 8, 32, },
	{ 1, 0, 0, 1, 8, 32, },
	{ 0, 0, 0, 1, 9, 46, },
	{ 2, 0, 0, 1, 9, 32, },
	{ 1, 0, 0, 1, 9, 32, },
	{ 0, 0, 0, 1, 10, 46, },
	{ 2, 0, 0, 1, 10, 32, },
	{ 1, 0, 0, 1, 10, 32, },
	{ 0, 0, 0, 1, 11, 38, },
	{ 2, 0, 0, 1, 11, 32, },
	{ 1, 0, 0, 1, 11, 32, },
	{ 0, 0, 0, 1, 12, 63, },
	{ 2, 0, 0, 1, 12, 32, },
	{ 1, 0, 0, 1, 12, 32, },
	{ 0, 0, 0, 1, 13, 63, },
	{ 2, 0, 0, 1, 13, 32, },
	{ 1, 0, 0, 1, 13, 32, },
	{ 0, 0, 0, 1, 14, 63, },
	{ 2, 0, 0, 1, 14, 63, },
	{ 1, 0, 0, 1, 14, 63, },
	{ 0, 0, 0, 2, 1, 34, },
	{ 2, 0, 0, 2, 1, 32, },
	{ 1, 0, 0, 2, 1, 32, },
	{ 0, 0, 0, 2, 2, 46, },
	{ 2, 0, 0, 2, 2, 32, },
	{ 1, 0, 0, 2, 2, 32, },
	{ 0, 0, 0, 2, 3, 46, },
	{ 2, 0, 0, 2, 3, 32, },
	{ 1, 0, 0, 2, 3, 32, },
	{ 0, 0, 0, 2, 4, 46, },
	{ 2, 0, 0, 2, 4, 32, },
	{ 1, 0, 0, 2, 4, 32, },
	{ 0, 0, 0, 2, 5, 46, },
	{ 2, 0, 0, 2, 5, 32, },
	{ 1, 0, 0, 2, 5, 32, },
	{ 0, 0, 0, 2, 6, 46, },
	{ 2, 0, 0, 2, 6, 32, },
	{ 1, 0, 0, 2, 6, 32, },
	{ 0, 0, 0, 2, 7, 46, },
	{ 2, 0, 0, 2, 7, 32, },
	{ 1, 0, 0, 2, 7, 32, },
	{ 0, 0, 0, 2, 8, 46, },
	{ 2, 0, 0, 2, 8, 32, },
	{ 1, 0, 0, 2, 8, 32, },
	{ 0, 0, 0, 2, 9, 46, },
	{ 2, 0, 0, 2, 9, 32, },
	{ 1, 0, 0, 2, 9, 32, },
	{ 0, 0, 0, 2, 10, 46, },
	{ 2, 0, 0, 2, 10, 32, },
	{ 1, 0, 0, 2, 10, 32, },
	{ 0, 0, 0, 2, 11, 34, },
	{ 2, 0, 0, 2, 11, 32, },
	{ 1, 0, 0, 2, 11, 32, },
	{ 0, 0, 0, 2, 12, 63, },
	{ 2, 0, 0, 2, 12, 32, },
	{ 1, 0, 0, 2, 12, 32, },
	{ 0, 0, 0, 2, 13, 63, },
	{ 2, 0, 0, 2, 13, 32, },
	{ 1, 0, 0, 2, 13, 32, },
	{ 0, 0, 0, 2, 14, 63, },
	{ 2, 0, 0, 2, 14, 63, },
	{ 1, 0, 0, 2, 14, 63, },
	{ 0, 0, 0, 3, 1, 32, },
	{ 2, 0, 0, 3, 1, 30, },
	{ 1, 0, 0, 3, 1, 30, },
	{ 0, 0, 0, 3, 2, 44, },
	{ 2, 0, 0, 3, 2, 30, },
	{ 1, 0, 0, 3, 2, 30, },
	{ 0, 0, 0, 3, 3, 44, },
	{ 2, 0, 0, 3, 3, 30, },
	{ 1, 0, 0, 3, 3, 30, },
	{ 0, 0, 0, 3, 4, 44, },
	{ 2, 0, 0, 3, 4, 30, },
	{ 1, 0, 0, 3, 4, 30, },
	{ 0, 0, 0, 3, 5, 44, },
	{ 2, 0, 0, 3, 5, 30, },
	{ 1, 0, 0, 3, 5, 30, },
	{ 0, 0, 0, 3, 6, 44, },
	{ 2, 0, 0, 3, 6, 30, },
	{ 1, 0, 0, 3, 6, 30, },
	{ 0, 0, 0, 3, 7, 44, },
	{ 2, 0, 0, 3, 7, 30, },
	{ 1, 0, 0, 3, 7, 30, },
	{ 0, 0, 0, 3, 8, 44, },
	{ 2, 0, 0, 3, 8, 30, },
	{ 1, 0, 0, 3, 8, 30, },
	{ 0, 0, 0, 3, 9, 44, },
	{ 2, 0, 0, 3, 9, 30, },
	{ 1, 0, 0, 3, 9, 30, },
	{ 0, 0, 0, 3, 10, 44, },
	{ 2, 0, 0, 3, 10, 30, },
	{ 1, 0, 0, 3, 10, 30, },
	{ 0, 0, 0, 3, 11, 32, },
	{ 2, 0, 0, 3, 11, 30, },
	{ 1, 0, 0, 3, 11, 30, },
	{ 0, 0, 0, 3, 12, 63, },
	{ 2, 0, 0, 3, 12, 30, },
	{ 1, 0, 0, 3, 12, 30, },
	{ 0, 0, 0, 3, 13, 63, },
	{ 2, 0, 0, 3, 13, 30, },
	{ 1, 0, 0, 3, 13, 30, },
	{ 0, 0, 0, 3, 14, 63, },
	{ 2, 0, 0, 3, 14, 63, },
	{ 1, 0, 0, 3, 14, 63, },
	{ 0, 0, 0, 6, 1, 30, },
	{ 2, 0, 0, 6, 1, 28, },
	{ 1, 0, 0, 6, 1, 28, },
	{ 0, 0, 0, 6, 2, 42, },
	{ 2, 0, 0, 6, 2, 28, },
	{ 1, 0, 0, 6, 2, 28, },
	{ 0, 0, 0, 6, 3, 42, },
	{ 2, 0, 0, 6, 3, 28, },
	{ 1, 0, 0, 6, 3, 28, },
	{ 0, 0, 0, 6, 4, 42, },
	{ 2, 0, 0, 6, 4, 28, },
	{ 1, 0, 0, 6, 4, 28, },
	{ 0, 0, 0, 6, 5, 42, },
	{ 2, 0, 0, 6, 5, 28, },
	{ 1, 0, 0, 6, 5, 28, },
	{ 0, 0, 0, 6, 6, 42, },
	{ 2, 0, 0, 6, 6, 28, },
	{ 1, 0, 0, 6, 6, 28, },
	{ 0, 0, 0, 6, 7, 42, },
	{ 2, 0, 0, 6, 7, 28, },
	{ 1, 0, 0, 6, 7, 28, },
	{ 0, 0, 0, 6, 8, 42, },
	{ 2, 0, 0, 6, 8, 28, },
	{ 1, 0, 0, 6, 8, 28, },
	{ 0, 0, 0, 6, 9, 42, },
	{ 2, 0, 0, 6, 9, 28, },
	{ 1, 0, 0, 6, 9, 28, },
	{ 0, 0, 0, 6, 10, 42, },
	{ 2, 0, 0, 6, 10, 28, },
	{ 1, 0, 0, 6, 10, 28, },
	{ 0, 0, 0, 6, 11, 30, },
	{ 2, 0, 0, 6, 11, 28, },
	{ 1, 0, 0, 6, 11, 28, },
	{ 0, 0, 0, 6, 12, 63, },
	{ 2, 0, 0, 6, 12, 28, },
	{ 1, 0, 0, 6, 12, 28, },
	{ 0, 0, 0, 6, 13, 63, },
	{ 2, 0, 0, 6, 13, 28, },
	{ 1, 0, 0, 6, 13, 28, },
	{ 0, 0, 0, 6, 14, 63, },
	{ 2, 0, 0, 6, 14, 63, },
	{ 1, 0, 0, 6, 14, 63, },
	{ 0, 0, 0, 7, 1, 28, },
	{ 2, 0, 0, 7, 1, 26, },
	{ 1, 0, 0, 7, 1, 26, },
	{ 0, 0, 0, 7, 2, 40, },
	{ 2, 0, 0, 7, 2, 26, },
	{ 1, 0, 0, 7, 2, 26, },
	{ 0, 0, 0, 7, 3, 40, },
	{ 2, 0, 0, 7, 3, 26, },
	{ 1, 0, 0, 7, 3, 26, },
	{ 0, 0, 0, 7, 4, 40, },
	{ 2, 0, 0, 7, 4, 26, },
	{ 1, 0, 0, 7, 4, 26, },
	{ 0, 0, 0, 7, 5, 40, },
	{ 2, 0, 0, 7, 5, 26, },
	{ 1, 0, 0, 7, 5, 26, },
	{ 0, 0, 0, 7, 6, 40, },
	{ 2, 0, 0, 7, 6, 26, },
	{ 1, 0, 0, 7, 6, 26, },
	{ 0, 0, 0, 7, 7, 40, },
	{ 2, 0, 0, 7, 7, 26, },
	{ 1, 0, 0, 7, 7, 26, },
	{ 0, 0, 0, 7, 8, 40, },
	{ 2, 0, 0, 7, 8, 26, },
	{ 1, 0, 0, 7, 8, 26, },
	{ 0, 0, 0, 7, 9, 40, },
	{ 2, 0, 0, 7, 9, 26, },
	{ 1, 0, 0, 7, 9, 26, },
	{ 0, 0, 0, 7, 10, 40, },
	{ 2, 0, 0, 7, 10, 26, },
	{ 1, 0, 0, 7, 10, 26, },
	{ 0, 0, 0, 7, 11, 28, },
	{ 2, 0, 0, 7, 11, 26, },
	{ 1, 0, 0, 7, 11, 26, },
	{ 0, 0, 0, 7, 12, 63, },
	{ 2, 0, 0, 7, 12, 26, },
	{ 1, 0, 0, 7, 12, 26, },
	{ 0, 0, 0, 7, 13, 63, },
	{ 2, 0, 0, 7, 13, 26, },
	{ 1, 0, 0, 7, 13, 26, },
	{ 0, 0, 0, 7, 14, 63, },
	{ 2, 0, 0, 7, 14, 63, },
	{ 1, 0, 0, 7, 14, 63, },
	{ 0, 0, 1, 2, 1, 63, },
	{ 2, 0, 1, 2, 1, 63, },
	{ 1, 0, 1, 2, 1, 63, },
	{ 0, 0, 1, 2, 2, 63, },
	{ 2, 0, 1, 2, 2, 63, },
	{ 1, 0, 1, 2, 2, 63, },
	{ 0, 0, 1, 2, 3, 36, },
	{ 2, 0, 1, 2, 3, 32, },
	{ 1, 0, 1, 2, 3, 32, },
	{ 0, 0, 1, 2, 4, 40, },
	{ 2, 0, 1, 2, 4, 32, },
	{ 1, 0, 1, 2, 4, 32, },
	{ 0, 0, 1, 2, 5, 40, },
	{ 2, 0, 1, 2, 5, 32, },
	{ 1, 0, 1, 2, 5, 32, },
	{ 0, 0, 1, 2, 6, 40, },
	{ 2, 0, 1, 2, 6, 32, },
	{ 1, 0, 1, 2, 6, 32, },
	{ 0, 0, 1, 2, 7, 40, },
	{ 2, 0, 1, 2, 7, 32, },
	{ 1, 0, 1, 2, 7, 32, },
	{ 0, 0, 1, 2, 8, 40, },
	{ 2, 0, 1, 2, 8, 32, },
	{ 1, 0, 1, 2, 8, 32, },
	{ 0, 0, 1, 2, 9, 40, },
	{ 2, 0, 1, 2, 9, 32, },
	{ 1, 0, 1, 2, 9, 32, },
	{ 0, 0, 1, 2, 10, 40, },
	{ 2, 0, 1, 2, 10, 32, },
	{ 1, 0, 1, 2, 10, 32, },
	{ 0, 0, 1, 2, 11, 34, },
	{ 2, 0, 1, 2, 11, 32, },
	{ 1, 0, 1, 2, 11, 32, },
	{ 0, 0, 1, 2, 12, 63, },
	{ 2, 0, 1, 2, 12, 32, },
	{ 1, 0, 1, 2, 12, 32, },
	{ 0, 0, 1, 2, 13, 63, },
	{ 2, 0, 1, 2, 13, 32, },
	{ 1, 0, 1, 2, 13, 32, },
	{ 0, 0, 1, 2, 14, 63, },
	{ 2, 0, 1, 2, 14, 63, },
	{ 1, 0, 1, 2, 14, 63, },
	{ 0, 0, 1, 3, 1, 63, },
	{ 2, 0, 1, 3, 1, 63, },
	{ 1, 0, 1, 3, 1, 63, },
	{ 0, 0, 1, 3, 2, 63, },
	{ 2, 0, 1, 3, 2, 63, },
	{ 1, 0, 1, 3, 2, 63, },
	{ 0, 0, 1, 3, 3, 34, },
	{ 2, 0, 1, 3, 3, 30, },
	{ 1, 0, 1, 3, 3, 30, },
	{ 0, 0, 1, 3, 4, 38, },
	{ 2, 0, 1, 3, 4, 30, },
	{ 1, 0, 1, 3, 4, 30, },
	{ 0, 0, 1, 3, 5, 38, },
	{ 2, 0, 1, 3, 5, 30, },
	{ 1, 0, 1, 3, 5, 30, },
	{ 0, 0, 1, 3, 6, 38, },
	{ 2, 0, 1, 3, 6, 30, },
	{ 1, 0, 1, 3, 6, 30, },
	{ 0, 0, 1, 3, 7, 38, },
	{ 2, 0, 1, 3, 7, 30, },
	{ 1, 0, 1, 3, 7, 30, },
	{ 0, 0, 1, 3, 8, 38, },
	{ 2, 0, 1, 3, 8, 30, },
	{ 1, 0, 1, 3, 8, 30, },
	{ 0, 0, 1, 3, 9, 38, },
	{ 2, 0, 1, 3, 9, 30, },
	{ 1, 0, 1, 3, 9, 30, },
	{ 0, 0, 1, 3, 10, 38, },
	{ 2, 0, 1, 3, 10, 30, },
	{ 1, 0, 1, 3, 10, 30, },
	{ 0, 0, 1, 3, 11, 32, },
	{ 2, 0, 1, 3, 11, 30, },
	{ 1, 0, 1, 3, 11, 30, },
	{ 0, 0, 1, 3, 12, 63, },
	{ 2, 0, 1, 3, 12, 30, },
	{ 1, 0, 1, 3, 12, 30, },
	{ 0, 0, 1, 3, 13, 63, },
	{ 2, 0, 1, 3, 13, 30, },
	{ 1, 0, 1, 3, 13, 30, },
	{ 0, 0, 1, 3, 14, 63, },
	{ 2, 0, 1, 3, 14, 63, },
	{ 1, 0, 1, 3, 14, 63, },
	{ 0, 0, 1, 6, 1, 63, },
	{ 2, 0, 1, 6, 1, 63, },
	{ 1, 0, 1, 6, 1, 63, },
	{ 0, 0, 1, 6, 2, 63, },
	{ 2, 0, 1, 6, 2, 63, },
	{ 1, 0, 1, 6, 2, 63, },
	{ 0, 0, 1, 6, 3, 32, },
	{ 2, 0, 1, 6, 3, 28, },
	{ 1, 0, 1, 6, 3, 28, },
	{ 0, 0, 1, 6, 4, 36, },
	{ 2, 0, 1, 6, 4, 28, },
	{ 1, 0, 1, 6, 4, 28, },
	{ 0, 0, 1, 6, 5, 36, },
	{ 2, 0, 1, 6, 5, 28, },
	{ 1, 0, 1, 6, 5, 28, },
	{ 0, 0, 1, 6, 6, 36, },
	{ 2, 0, 1, 6, 6, 28, },
	{ 1, 0, 1, 6, 6, 28, },
	{ 0, 0, 1, 6, 7, 36, },
	{ 2, 0, 1, 6, 7, 28, },
	{ 1, 0, 1, 6, 7, 28, },
	{ 0, 0, 1, 6, 8, 36, },
	{ 2, 0, 1, 6, 8, 28, },
	{ 1, 0, 1, 6, 8, 28, },
	{ 0, 0, 1, 6, 9, 36, },
	{ 2, 0, 1, 6, 9, 28, },
	{ 1, 0, 1, 6, 9, 28, },
	{ 0, 0, 1, 6, 10, 36, },
	{ 2, 0, 1, 6, 10, 28, },
	{ 1, 0, 1, 6, 10, 28, },
	{ 0, 0, 1, 6, 11, 30, },
	{ 2, 0, 1, 6, 11, 28, },
	{ 1, 0, 1, 6, 11, 28, },
	{ 0, 0, 1, 6, 12, 63, },
	{ 2, 0, 1, 6, 12, 28, },
	{ 1, 0, 1, 6, 12, 28, },
	{ 0, 0, 1, 6, 13, 63, },
	{ 2, 0, 1, 6, 13, 28, },
	{ 1, 0, 1, 6, 13, 28, },
	{ 0, 0, 1, 6, 14, 63, },
	{ 2, 0, 1, 6, 14, 63, },
	{ 1, 0, 1, 6, 14, 63, },
	{ 0, 0, 1, 7, 1, 63, },
	{ 2, 0, 1, 7, 1, 63, },
	{ 1, 0, 1, 7, 1, 63, },
	{ 0, 0, 1, 7, 2, 63, },
	{ 2, 0, 1, 7, 2, 63, },
	{ 1, 0, 1, 7, 2, 63, },
	{ 0, 0, 1, 7, 3, 32, },
	{ 2, 0, 1, 7, 3, 26, },
	{ 1, 0, 1, 7, 3, 26, },
	{ 0, 0, 1, 7, 4, 36, },
	{ 2, 0, 1, 7, 4, 26, },
	{ 1, 0, 1, 7, 4, 26, },
	{ 0, 0, 1, 7, 5, 36, },
	{ 2, 0, 1, 7, 5, 26, },
	{ 1, 0, 1, 7, 5, 26, },
	{ 0, 0, 1, 7, 6, 36, },
	{ 2, 0, 1, 7, 6, 26, },
	{ 1, 0, 1, 7, 6, 26, },
	{ 0, 0, 1, 7, 7, 36, },
	{ 2, 0, 1, 7, 7, 26, },
	{ 1, 0, 1, 7, 7, 26, },
	{ 0, 0, 1, 7, 8, 36, },
	{ 2, 0, 1, 7, 8, 26, },
	{ 1, 0, 1, 7, 8, 26, },
	{ 0, 0, 1, 7, 9, 36, },
	{ 2, 0, 1, 7, 9, 26, },
	{ 1, 0, 1, 7, 9, 26, },
	{ 0, 0, 1, 7, 10, 36, },
	{ 2, 0, 1, 7, 10, 26, },
	{ 1, 0, 1, 7, 10, 26, },
	{ 0, 0, 1, 7, 11, 30, },
	{ 2, 0, 1, 7, 11, 26, },
	{ 1, 0, 1, 7, 11, 26, },
	{ 0, 0, 1, 7, 12, 63, },
	{ 2, 0, 1, 7, 12, 26, },
	{ 1, 0, 1, 7, 12, 26, },
	{ 0, 0, 1, 7, 13, 63, },
	{ 2, 0, 1, 7, 13, 26, },
	{ 1, 0, 1, 7, 13, 26, },
	{ 0, 0, 1, 7, 14, 63, },
	{ 2, 0, 1, 7, 14, 63, },
	{ 1, 0, 1, 7, 14, 63, },
	{ 0, 1, 0, 1, 36, 38, },
	{ 2, 1, 0, 1, 36, 32, },
	{ 1, 1, 0, 1, 36, 32, },
	{ 0, 1, 0, 1, 40, 38, },
	{ 2, 1, 0, 1, 40, 32, },
	{ 1, 1, 0, 1, 40, 32, },
	{ 0, 1, 0, 1, 44, 38, },
	{ 2, 1, 0, 1, 44, 32, },
	{ 1, 1, 0, 1, 44, 32, },
	{ 0, 1, 0, 1, 48, 38, },
	{ 2, 1, 0, 1, 48, 32, },
	{ 1, 1, 0, 1, 48, 32, },
	{ 0, 1, 0, 1, 52, 38, },
	{ 2, 1, 0, 1, 52, 32, },
	{ 1, 1, 0, 1, 52, 32, },
	{ 0, 1, 0, 1, 56, 38, },
	{ 2, 1, 0, 1, 56, 32, },
	{ 1, 1, 0, 1, 56, 32, },
	{ 0, 1, 0, 1, 60, 38, },
	{ 2, 1, 0, 1, 60, 32, },
	{ 1, 1, 0, 1, 60, 32, },
	{ 0, 1, 0, 1, 64, 38, },
	{ 2, 1, 0, 1, 64, 32, },
	{ 1, 1, 0, 1, 64, 32, },
	{ 0, 1, 0, 1, 100, 36, },
	{ 2, 1, 0, 1, 100, 32, },
	{ 1, 1, 0, 1, 100, 32, },
	{ 0, 1, 0, 1, 104, 36, },
	{ 2, 1, 0, 1, 104, 32, },
	{ 1, 1, 0, 1, 104, 32, },
	{ 0, 1, 0, 1, 108, 36, },
	{ 2, 1, 0, 1, 108, 32, },
	{ 1, 1, 0, 1, 108, 32, },
	{ 0, 1, 0, 1, 112, 36, },
	{ 2, 1, 0, 1, 112, 32, },
	{ 1, 1, 0, 1, 112, 32, },
	{ 0, 1, 0, 1, 116, 36, },
	{ 2, 1, 0, 1, 116, 32, },
	{ 1, 1, 0, 1, 116, 32, },
	{ 0, 1, 0, 1, 120, 36, },
	{ 2, 1, 0, 1, 120, 32, },
	{ 1, 1, 0, 1, 120, 32, },
	{ 0, 1, 0, 1, 124, 36, },
	{ 2, 1, 0, 1, 124, 32, },
	{ 1, 1, 0, 1, 124, 32, },
	{ 0, 1, 0, 1, 128, 36, },
	{ 2, 1, 0, 1, 128, 32, },
	{ 1, 1, 0, 1, 128, 32, },
	{ 0, 1, 0, 1, 132, 36, },
	{ 2, 1, 0, 1, 132, 32, },
	{ 1, 1, 0, 1, 132, 32, },
	{ 0, 1, 0, 1, 136, 36, },
	{ 2, 1, 0, 1, 136, 32, },
	{ 1, 1, 0, 1, 136, 32, },
	{ 0, 1, 0, 1, 140, 36, },
	{ 2, 1, 0, 1, 140, 32, },
	{ 1, 1, 0, 1, 140, 32, },
	{ 0, 1, 0, 1, 149, 36, },
	{ 2, 1, 0, 1, 149, 32, },
	{ 1, 1, 0, 1, 149, 63, },
	{ 0, 1, 0, 1, 153, 36, },
	{ 2, 1, 0, 1, 153, 32, },
	{ 1, 1, 0, 1, 153, 63, },
	{ 0, 1, 0, 1, 157, 36, },
	{ 2, 1, 0, 1, 157, 32, },
	{ 1, 1, 0, 1, 157, 63, },
	{ 0, 1, 0, 1, 161, 36, },
	{ 2, 1, 0, 1, 161, 32, },
	{ 1, 1, 0, 1, 161, 63, },
	{ 0, 1, 0, 1, 165, 36, },
	{ 2, 1, 0, 1, 165, 32, },
	{ 1, 1, 0, 1, 165, 63, },
	{ 0, 1, 0, 2, 36, 36, },
	{ 2, 1, 0, 2, 36, 32, },
	{ 1, 1, 0, 2, 36, 32, },
	{ 0, 1, 0, 2, 40, 36, },
	{ 2, 1, 0, 2, 40, 32, },
	{ 1, 1, 0, 2, 40, 32, },
	{ 0, 1, 0, 2, 44, 36, },
	{ 2, 1, 0, 2, 44, 32, },
	{ 1, 1, 0, 2, 44, 32, },
	{ 0, 1, 0, 2, 48, 36, },
	{ 2, 1, 0, 2, 48, 32, },
	{ 1, 1, 0, 2, 48, 32, },
	{ 0, 1, 0, 2, 52, 36, },
	{ 2, 1, 0, 2, 52, 32, },
	{ 1, 1, 0, 2, 52, 32, },
	{ 0, 1, 0, 2, 56, 36, },
	{ 2, 1, 0, 2, 56, 32, },
	{ 1, 1, 0, 2, 56, 32, },
	{ 0, 1, 0, 2, 60, 36, },
	{ 2, 1, 0, 2, 60, 32, },
	{ 1, 1, 0, 2, 60, 32, },
	{ 0, 1, 0, 2, 64, 36, },
	{ 2, 1, 0, 2, 64, 32, },
	{ 1, 1, 0, 2, 64, 32, },
	{ 0, 1, 0, 2, 100, 36, },
	{ 2, 1, 0, 2, 100, 32, },
	{ 1, 1, 0, 2, 100, 32, },
	{ 0, 1, 0, 2, 104, 36, },
	{ 2, 1, 0, 2, 104, 32, },
	{ 1, 1, 0, 2, 104, 32, },
	{ 0, 1, 0, 2, 108, 36, },
	{ 2, 1, 0, 2, 108, 32, },
	{ 1, 1, 0, 2, 108, 32, },
	{ 0, 1, 0, 2, 112, 36, },
	{ 2, 1, 0, 2, 112, 32, },
	{ 1, 1, 0, 2, 112, 32, },
	{ 0, 1, 0, 2, 116, 36, },
	{ 2, 1, 0, 2, 116, 32, },
	{ 1, 1, 0, 2, 116, 32, },
	{ 0, 1, 0, 2, 120, 36, },
	{ 2, 1, 0, 2, 120, 32, },
	{ 1, 1, 0, 2, 120, 32, },
	{ 0, 1, 0, 2, 124, 36, },
	{ 2, 1, 0, 2, 124, 32, },
	{ 1, 1, 0, 2, 124, 32, },
	{ 0, 1, 0, 2, 128, 36, },
	{ 2, 1, 0, 2, 128, 32, },
	{ 1, 1, 0, 2, 128, 32, },
	{ 0, 1, 0, 2, 132, 36, },
	{ 2, 1, 0, 2, 132, 32, },
	{ 1, 1, 0, 2, 132, 32, },
	{ 0, 1, 0, 2, 136, 36, },
	{ 2, 1, 0, 2, 136, 32, },
	{ 1, 1, 0, 2, 136, 32, },
	{ 0, 1, 0, 2, 140, 34, },
	{ 2, 1, 0, 2, 140, 32, },
	{ 1, 1, 0, 2, 140, 32, },
	{ 0, 1, 0, 2, 149, 32, },
	{ 2, 1, 0, 2, 149, 32, },
	{ 1, 1, 0, 2, 149, 63, },
	{ 0, 1, 0, 2, 153, 38, },
	{ 2, 1, 0, 2, 153, 32, },
	{ 1, 1, 0, 2, 153, 63, },
	{ 0, 1, 0, 2, 157, 38, },
	{ 2, 1, 0, 2, 157, 32, },
	{ 1, 1, 0, 2, 157, 63, },
	{ 0, 1, 0, 2, 161, 38, },
	{ 2, 1, 0, 2, 161, 32, },
	{ 1, 1, 0, 2, 161, 63, },
	{ 0, 1, 0, 2, 165, 38, },
	{ 2, 1, 0, 2, 165, 32, },
	{ 1, 1, 0, 2, 165, 63, },
	{ 0, 1, 0, 3, 36, 34, },
	{ 2, 1, 0, 3, 36, 30, },
	{ 1, 1, 0, 3, 36, 30, },
	{ 0, 1, 0, 3, 40, 34, },
	{ 2, 1, 0, 3, 40, 30, },
	{ 1, 1, 0, 3, 40, 30, },
	{ 0, 1, 0, 3, 44, 34, },
	{ 2, 1, 0, 3, 44, 30, },
	{ 1, 1, 0, 3, 44, 30, },
	{ 0, 1, 0, 3, 48, 34, },
	{ 2, 1, 0, 3, 48, 30, },
	{ 1, 1, 0, 3, 48, 30, },
	{ 0, 1, 0, 3, 52, 34, },
	{ 2, 1, 0, 3, 52, 30, },
	{ 1, 1, 0, 3, 52, 30, },
	{ 0, 1, 0, 3, 56, 34, },
	{ 2, 1, 0, 3, 56, 30, },
	{ 1, 1, 0, 3, 56, 30, },
	{ 0, 1, 0, 3, 60, 34, },
	{ 2, 1, 0, 3, 60, 30, },
	{ 1, 1, 0, 3, 60, 30, },
	{ 0, 1, 0, 3, 64, 34, },
	{ 2, 1, 0, 3, 64, 30, },
	{ 1, 1, 0, 3, 64, 30, },
	{ 0, 1, 0, 3, 100, 34, },
	{ 2, 1, 0, 3, 100, 30, },
	{ 1, 1, 0, 3, 100, 30, },
	{ 0, 1, 0, 3, 104, 34, },
	{ 2, 1, 0, 3, 104, 30, },
	{ 1, 1, 0, 3, 104, 30, },
	{ 0, 1, 0, 3, 108, 34, },
	{ 2, 1, 0, 3, 108, 30, },
	{ 1, 1, 0, 3, 108, 30, },
	{ 0, 1, 0, 3, 112, 34, },
	{ 2, 1, 0, 3, 112, 30, },
	{ 1, 1, 0, 3, 112, 30, },
	{ 0, 1, 0, 3, 116, 34, },
	{ 2, 1, 0, 3, 116, 30, },
	{ 1, 1, 0, 3, 116, 30, },
	{ 0, 1, 0, 3, 120, 34, },
	{ 2, 1, 0, 3, 120, 30, },
	{ 1, 1, 0, 3, 120, 30, },
	{ 0, 1, 0, 3, 124, 34, },
	{ 2, 1, 0, 3, 124, 30, },
	{ 1, 1, 0, 3, 124, 30, },
	{ 0, 1, 0, 3, 128, 34, },
	{ 2, 1, 0, 3, 128, 30, },
	{ 1, 1, 0, 3, 128, 30, },
	{ 0, 1, 0, 3, 132, 34, },
	{ 2, 1, 0, 3, 132, 30, },
	{ 1, 1, 0, 3, 132, 30, },
	{ 0, 1, 0, 3, 136, 34, },
	{ 2, 1, 0, 3, 136, 30, },
	{ 1, 1, 0, 3, 136, 30, },
	{ 0, 1, 0, 3, 140, 32, },
	{ 2, 1, 0, 3, 140, 30, },
	{ 1, 1, 0, 3, 140, 30, },
	{ 0, 1, 0, 3, 149, 30, },
	{ 2, 1, 0, 3, 149, 30, },
	{ 1, 1, 0, 3, 149, 63, },
	{ 0, 1, 0, 3, 153, 36, },
	{ 2, 1, 0, 3, 153, 30, },
	{ 1, 1, 0, 3, 153, 63, },
	{ 0, 1, 0, 3, 157, 36, },
	{ 2, 1, 0, 3, 157, 30, },
	{ 1, 1, 0, 3, 157, 63, },
	{ 0, 1, 0, 3, 161, 36, },
	{ 2, 1, 0, 3, 161, 30, },
	{ 1, 1, 0, 3, 161, 63, },
	{ 0, 1, 0, 3, 165, 36, },
	{ 2, 1, 0, 3, 165, 30, },
	{ 1, 1, 0, 3, 165, 63, },
	{ 0, 1, 0, 6, 36, 32, },
	{ 2, 1, 0, 6, 36, 28, },
	{ 1, 1, 0, 6, 36, 28, },
	{ 0, 1, 0, 6, 40, 32, },
	{ 2, 1, 0, 6, 40, 28, },
	{ 1, 1, 0, 6, 40, 28, },
	{ 0, 1, 0, 6, 44, 32, },
	{ 2, 1, 0, 6, 44, 28, },
	{ 1, 1, 0, 6, 44, 28, },
	{ 0, 1, 0, 6, 48, 32, },
	{ 2, 1, 0, 6, 48, 28, },
	{ 1, 1, 0, 6, 48, 28, },
	{ 0, 1, 0, 6, 52, 32, },
	{ 2, 1, 0, 6, 52, 28, },
	{ 1, 1, 0, 6, 52, 28, },
	{ 0, 1, 0, 6, 56, 32, },
	{ 2, 1, 0, 6, 56, 28, },
	{ 1, 1, 0, 6, 56, 28, },
	{ 0, 1, 0, 6, 60, 32, },
	{ 2, 1, 0, 6, 60, 28, },
	{ 1, 1, 0, 6, 60, 28, },
	{ 0, 1, 0, 6, 64, 32, },
	{ 2, 1, 0, 6, 64, 28, },
	{ 1, 1, 0, 6, 64, 28, },
	{ 0, 1, 0, 6, 100, 32, },
	{ 2, 1, 0, 6, 100, 28, },
	{ 1, 1, 0, 6, 100, 28, },
	{ 0, 1, 0, 6, 104, 32, },
	{ 2, 1, 0, 6, 104, 28, },
	{ 1, 1, 0, 6, 104, 28, },
	{ 0, 1, 0, 6, 108, 32, },
	{ 2, 1, 0, 6, 108, 28, },
	{ 1, 1, 0, 6, 108, 28, },
	{ 0, 1, 0, 6, 112, 32, },
	{ 2, 1, 0, 6, 112, 28, },
	{ 1, 1, 0, 6, 112, 28, },
	{ 0, 1, 0, 6, 116, 32, },
	{ 2, 1, 0, 6, 116, 28, },
	{ 1, 1, 0, 6, 116, 28, },
	{ 0, 1, 0, 6, 120, 32, },
	{ 2, 1, 0, 6, 120, 28, },
	{ 1, 1, 0, 6, 120, 28, },
	{ 0, 1, 0, 6, 124, 32, },
	{ 2, 1, 0, 6, 124, 28, },
	{ 1, 1, 0, 6, 124, 28, },
	{ 0, 1, 0, 6, 128, 32, },
	{ 2, 1, 0, 6, 128, 28, },
	{ 1, 1, 0, 6, 128, 28, },
	{ 0, 1, 0, 6, 132, 32, },
	{ 2, 1, 0, 6, 132, 28, },
	{ 1, 1, 0, 6, 132, 28, },
	{ 0, 1, 0, 6, 136, 32, },
	{ 2, 1, 0, 6, 136, 28, },
	{ 1, 1, 0, 6, 136, 28, },
	{ 0, 1, 0, 6, 140, 30, },
	{ 2, 1, 0, 6, 140, 28, },
	{ 1, 1, 0, 6, 140, 28, },
	{ 0, 1, 0, 6, 149, 28, },
	{ 2, 1, 0, 6, 149, 28, },
	{ 1, 1, 0, 6, 149, 63, },
	{ 0, 1, 0, 6, 153, 34, },
	{ 2, 1, 0, 6, 153, 28, },
	{ 1, 1, 0, 6, 153, 63, },
	{ 0, 1, 0, 6, 157, 34, },
	{ 2, 1, 0, 6, 157, 28, },
	{ 1, 1, 0, 6, 157, 63, },
	{ 0, 1, 0, 6, 161, 34, },
	{ 2, 1, 0, 6, 161, 28, },
	{ 1, 1, 0, 6, 161, 63, },
	{ 0, 1, 0, 6, 165, 34, },
	{ 2, 1, 0, 6, 165, 28, },
	{ 1, 1, 0, 6, 165, 63, },
	{ 0, 1, 0, 7, 36, 30, },
	{ 2, 1, 0, 7, 36, 26, },
	{ 1, 1, 0, 7, 36, 26, },
	{ 0, 1, 0, 7, 40, 30, },
	{ 2, 1, 0, 7, 40, 26, },
	{ 1, 1, 0, 7, 40, 26, },
	{ 0, 1, 0, 7, 44, 30, },
	{ 2, 1, 0, 7, 44, 26, },
	{ 1, 1, 0, 7, 44, 26, },
	{ 0, 1, 0, 7, 48, 30, },
	{ 2, 1, 0, 7, 48, 26, },
	{ 1, 1, 0, 7, 48, 26, },
	{ 0, 1, 0, 7, 52, 30, },
	{ 2, 1, 0, 7, 52, 26, },
	{ 1, 1, 0, 7, 52, 26, },
	{ 0, 1, 0, 7, 56, 30, },
	{ 2, 1, 0, 7, 56, 26, },
	{ 1, 1, 0, 7, 56, 26, },
	{ 0, 1, 0, 7, 60, 30, },
	{ 2, 1, 0, 7, 60, 26, },
	{ 1, 1, 0, 7, 60, 26, },
	{ 0, 1, 0, 7, 64, 30, },
	{ 2, 1, 0, 7, 64, 26, },
	{ 1, 1, 0, 7, 64, 26, },
	{ 0, 1, 0, 7, 100, 30, },
	{ 2, 1, 0, 7, 100, 26, },
	{ 1, 1, 0, 7, 100, 26, },
	{ 0, 1, 0, 7, 104, 30, },
	{ 2, 1, 0, 7, 104, 26, },
	{ 1, 1, 0, 7, 104, 26, },
	{ 0, 1, 0, 7, 108, 30, },
	{ 2, 1, 0, 7, 108, 26, },
	{ 1, 1, 0, 7, 108, 26, },
	{ 0, 1, 0, 7, 112, 30, },
	{ 2, 1, 0, 7, 112, 26, },
	{ 1, 1, 0, 7, 112, 26, },
	{ 0, 1, 0, 7, 116, 30, },
	{ 2, 1, 0, 7, 116, 26, },
	{ 1, 1, 0, 7, 116, 26, },
	{ 0, 1, 0, 7, 120, 30, },
	{ 2, 1, 0, 7, 120, 26, },
	{ 1, 1, 0, 7, 120, 26, },
	{ 0, 1, 0, 7, 124, 30, },
	{ 2, 1, 0, 7, 124, 26, },
	{ 1, 1, 0, 7, 124, 26, },
	{ 0, 1, 0, 7, 128, 30, },
	{ 2, 1, 0, 7, 128, 26, },
	{ 1, 1, 0, 7, 128, 26, },
	{ 0, 1, 0, 7, 132, 30, },
	{ 2, 1, 0, 7, 132, 26, },
	{ 1, 1, 0, 7, 132, 26, },
	{ 0, 1, 0, 7, 136, 30, },
	{ 2, 1, 0, 7, 136, 26, },
	{ 1, 1, 0, 7, 136, 26, },
	{ 0, 1, 0, 7, 140, 28, },
	{ 2, 1, 0, 7, 140, 26, },
	{ 1, 1, 0, 7, 140, 26, },
	{ 0, 1, 0, 7, 149, 26, },
	{ 2, 1, 0, 7, 149, 26, },
	{ 1, 1, 0, 7, 149, 63, },
	{ 0, 1, 0, 7, 153, 32, },
	{ 2, 1, 0, 7, 153, 26, },
	{ 1, 1, 0, 7, 153, 63, },
	{ 0, 1, 0, 7, 157, 32, },
	{ 2, 1, 0, 7, 157, 26, },
	{ 1, 1, 0, 7, 157, 63, },
	{ 0, 1, 0, 7, 161, 32, },
	{ 2, 1, 0, 7, 161, 26, },
	{ 1, 1, 0, 7, 161, 63, },
	{ 0, 1, 0, 7, 165, 32, },
	{ 2, 1, 0, 7, 165, 26, },
	{ 1, 1, 0, 7, 165, 63, },
	{ 0, 1, 1, 2, 38, 32, },
	{ 2, 1, 1, 2, 38, 32, },
	{ 1, 1, 1, 2, 38, 32, },
	{ 0, 1, 1, 2, 46, 32, },
	{ 2, 1, 1, 2, 46, 32, },
	{ 1, 1, 1, 2, 46, 32, },
	{ 0, 1, 1, 2, 54, 32, },
	{ 2, 1, 1, 2, 54, 32, },
	{ 1, 1, 1, 2, 54, 32, },
	{ 0, 1, 1, 2, 62, 30, },
	{ 2, 1, 1, 2, 62, 32, },
	{ 1, 1, 1, 2, 62, 32, },
	{ 0, 1, 1, 2, 102, 30, },
	{ 2, 1, 1, 2, 102, 32, },
	{ 1, 1, 1, 2, 102, 32, },
	{ 0, 1, 1, 2, 110, 38, },
	{ 2, 1, 1, 2, 110, 32, },
	{ 1, 1, 1, 2, 110, 32, },
	{ 0, 1, 1, 2, 118, 38, },
	{ 2, 1, 1, 2, 118, 32, },
	{ 1, 1, 1, 2, 118, 32, },
	{ 0, 1, 1, 2, 126, 38, },
	{ 2, 1, 1, 2, 126, 32, },
	{ 1, 1, 1, 2, 126, 32, },
	{ 0, 1, 1, 2, 134, 38, },
	{ 2, 1, 1, 2, 134, 32, },
	{ 1, 1, 1, 2, 134, 32, },
	{ 0, 1, 1, 2, 151, 32, },
	{ 2, 1, 1, 2, 151, 32, },
	{ 1, 1, 1, 2, 151, 63, },
	{ 0, 1, 1, 2, 159, 32, },
	{ 2, 1, 1, 2, 159, 32, },
	{ 1, 1, 1, 2, 159, 63, },
	{ 0, 1, 1, 3, 38, 30, },
	{ 2, 1, 1, 3, 38, 30, },
	{ 1, 1, 1, 3, 38, 30, },
	{ 0, 1, 1, 3, 46, 30, },
	{ 2, 1, 1, 3, 46, 30, },
	{ 1, 1, 1, 3, 46, 30, },
	{ 0, 1, 1, 3, 54, 30, },
	{ 2, 1, 1, 3, 54, 30, },
	{ 1, 1, 1, 3, 54, 30, },
	{ 0, 1, 1, 3, 62, 28, },
	{ 2, 1, 1, 3, 62, 30, },
	{ 1, 1, 1, 3, 62, 30, },
	{ 0, 1, 1, 3, 102, 28, },
	{ 2, 1, 1, 3, 102, 30, },
	{ 1, 1, 1, 3, 102, 30, },
	{ 0, 1, 1, 3, 110, 36, },
	{ 2, 1, 1, 3, 110, 30, },
	{ 1, 1, 1, 3, 110, 30, },
	{ 0, 1, 1, 3, 118, 36, },
	{ 2, 1, 1, 3, 118, 30, },
	{ 1, 1, 1, 3, 118, 30, },
	{ 0, 1, 1, 3, 126, 36, },
	{ 2, 1, 1, 3, 126, 30, },
	{ 1, 1, 1, 3, 126, 30, },
	{ 0, 1, 1, 3, 134, 36, },
	{ 2, 1, 1, 3, 134, 30, },
	{ 1, 1, 1, 3, 134, 30, },
	{ 0, 1, 1, 3, 151, 30, },
	{ 2, 1, 1, 3, 151, 30, },
	{ 1, 1, 1, 3, 151, 63, },
	{ 0, 1, 1, 3, 159, 30, },
	{ 2, 1, 1, 3, 159, 30, },
	{ 1, 1, 1, 3, 159, 63, },
	{ 0, 1, 1, 6, 38, 28, },
	{ 2, 1, 1, 6, 38, 28, },
	{ 1, 1, 1, 6, 38, 28, },
	{ 0, 1, 1, 6, 46, 28, },
	{ 2, 1, 1, 6, 46, 28, },
	{ 1, 1, 1, 6, 46, 28, },
	{ 0, 1, 1, 6, 54, 28, },
	{ 2, 1, 1, 6, 54, 28, },
	{ 1, 1, 1, 6, 54, 28, },
	{ 0, 1, 1, 6, 62, 26, },
	{ 2, 1, 1, 6, 62, 28, },
	{ 1, 1, 1, 6, 62, 28, },
	{ 0, 1, 1, 6, 102, 26, },
	{ 2, 1, 1, 6, 102, 28, },
	{ 1, 1, 1, 6, 102, 28, },
	{ 0, 1, 1, 6, 110, 34, },
	{ 2, 1, 1, 6, 110, 28, },
	{ 1, 1, 1, 6, 110, 28, },
	{ 0, 1, 1, 6, 118, 34, },
	{ 2, 1, 1, 6, 118, 28, },
	{ 1, 1, 1, 6, 118, 28, },
	{ 0, 1, 1, 6, 126, 34, },
	{ 2, 1, 1, 6, 126, 28, },
	{ 1, 1, 1, 6, 126, 28, },
	{ 0, 1, 1, 6, 134, 34, },
	{ 2, 1, 1, 6, 134, 28, },
	{ 1, 1, 1, 6, 134, 28, },
	{ 0, 1, 1, 6, 151, 28, },
	{ 2, 1, 1, 6, 151, 28, },
	{ 1, 1, 1, 6, 151, 63, },
	{ 0, 1, 1, 6, 159, 28, },
	{ 2, 1, 1, 6, 159, 28, },
	{ 1, 1, 1, 6, 159, 63, },
	{ 0, 1, 1, 7, 38, 26, },
	{ 2, 1, 1, 7, 38, 26, },
	{ 1, 1, 1, 7, 38, 26, },
	{ 0, 1, 1, 7, 46, 26, },
	{ 2, 1, 1, 7, 46, 26, },
	{ 1, 1, 1, 7, 46, 26, },
	{ 0, 1, 1, 7, 54, 26, },
	{ 2, 1, 1, 7, 54, 26, },
	{ 1, 1, 1, 7, 54, 26, },
	{ 0, 1, 1, 7, 62, 24, },
	{ 2, 1, 1, 7, 62, 26, },
	{ 1, 1, 1, 7, 62, 26, },
	{ 0, 1, 1, 7, 102, 24, },
	{ 2, 1, 1, 7, 102, 26, },
	{ 1, 1, 1, 7, 102, 26, },
	{ 0, 1, 1, 7, 110, 32, },
	{ 2, 1, 1, 7, 110, 26, },
	{ 1, 1, 1, 7, 110, 26, },
	{ 0, 1, 1, 7, 118, 32, },
	{ 2, 1, 1, 7, 118, 26, },
	{ 1, 1, 1, 7, 118, 26, },
	{ 0, 1, 1, 7, 126, 32, },
	{ 2, 1, 1, 7, 126, 26, },
	{ 1, 1, 1, 7, 126, 26, },
	{ 0, 1, 1, 7, 134, 32, },
	{ 2, 1, 1, 7, 134, 26, },
	{ 1, 1, 1, 7, 134, 26, },
	{ 0, 1, 1, 7, 151, 26, },
	{ 2, 1, 1, 7, 151, 26, },
	{ 1, 1, 1, 7, 151, 63, },
	{ 0, 1, 1, 7, 159, 26, },
	{ 2, 1, 1, 7, 159, 26, },
	{ 1, 1, 1, 7, 159, 63, },
	{ 0, 1, 2, 4, 42, 26, },
	{ 2, 1, 2, 4, 42, 32, },
	{ 1, 1, 2, 4, 42, 32, },
	{ 0, 1, 2, 4, 58, 26, },
	{ 2, 1, 2, 4, 58, 32, },
	{ 1, 1, 2, 4, 58, 32, },
	{ 0, 1, 2, 4, 106, 28, },
	{ 2, 1, 2, 4, 106, 32, },
	{ 1, 1, 2, 4, 106, 32, },
	{ 0, 1, 2, 4, 122, 28, },
	{ 2, 1, 2, 4, 122, 32, },
	{ 1, 1, 2, 4, 122, 32, },
	{ 0, 1, 2, 4, 155, 28, },
	{ 2, 1, 2, 4, 155, 32, },
	{ 1, 1, 2, 4, 155, 63, },
	{ 0, 1, 2, 5, 42, 24, },
	{ 2, 1, 2, 5, 42, 30, },
	{ 1, 1, 2, 5, 42, 30, },
	{ 0, 1, 2, 5, 58, 24, },
	{ 2, 1, 2, 5, 58, 30, },
	{ 1, 1, 2, 5, 58, 30, },
	{ 0, 1, 2, 5, 106, 26, },
	{ 2, 1, 2, 5, 106, 30, },
	{ 1, 1, 2, 5, 106, 30, },
	{ 0, 1, 2, 5, 122, 26, },
	{ 2, 1, 2, 5, 122, 30, },
	{ 1, 1, 2, 5, 122, 30, },
	{ 0, 1, 2, 5, 155, 26, },
	{ 2, 1, 2, 5, 155, 30, },
	{ 1, 1, 2, 5, 155, 63, },
	{ 0, 1, 2, 8, 42, 22, },
	{ 2, 1, 2, 8, 42, 28, },
	{ 1, 1, 2, 8, 42, 28, },
	{ 0, 1, 2, 8, 58, 22, },
	{ 2, 1, 2, 8, 58, 28, },
	{ 1, 1, 2, 8, 58, 28, },
	{ 0, 1, 2, 8, 106, 24, },
	{ 2, 1, 2, 8, 106, 28, },
	{ 1, 1, 2, 8, 106, 28, },
	{ 0, 1, 2, 8, 122, 24, },
	{ 2, 1, 2, 8, 122, 28, },
	{ 1, 1, 2, 8, 122, 28, },
	{ 0, 1, 2, 8, 155, 24, },
	{ 2, 1, 2, 8, 155, 28, },
	{ 1, 1, 2, 8, 155, 63, },
	{ 0, 1, 2, 9, 42, 20, },
	{ 2, 1, 2, 9, 42, 26, },
	{ 1, 1, 2, 9, 42, 26, },
	{ 0, 1, 2, 9, 58, 20, },
	{ 2, 1, 2, 9, 58, 26, },
	{ 1, 1, 2, 9, 58, 26, },
	{ 0, 1, 2, 9, 106, 22, },
	{ 2, 1, 2, 9, 106, 26, },
	{ 1, 1, 2, 9, 106, 26, },
	{ 0, 1, 2, 9, 122, 22, },
	{ 2, 1, 2, 9, 122, 26, },
	{ 1, 1, 2, 9, 122, 26, },
	{ 0, 1, 2, 9, 155, 22, },
	{ 2, 1, 2, 9, 155, 26, },
	{ 1, 1, 2, 9, 155, 63, },
};

RTW_DECL_TABLE_TXPWR_LMT(rtw8814a_txpwr_lmt_type7);

static const struct rtw_txpwr_lmt_cfg_pair rtw8814a_txpwr_lmt_type8[] = {
	{ 0, 0, 0, 0, 1, 46, },
	{ 2, 0, 0, 0, 1, 46, },
	{ 1, 0, 0, 0, 1, 46, },
	{ 0, 0, 0, 0, 2, 46, },
	{ 2, 0, 0, 0, 2, 46, },
	{ 1, 0, 0, 0, 2, 46, },
	{ 0, 0, 0, 0, 3, 46, },
	{ 2, 0, 0, 0, 3, 46, },
	{ 1, 0, 0, 0, 3, 46, },
	{ 0, 0, 0, 0, 4, 46, },
	{ 2, 0, 0, 0, 4, 46, },
	{ 1, 0, 0, 0, 4, 46, },
	{ 0, 0, 0, 0, 5, 46, },
	{ 2, 0, 0, 0, 5, 46, },
	{ 1, 0, 0, 0, 5, 46, },
	{ 0, 0, 0, 0, 6, 46, },
	{ 2, 0, 0, 0, 6, 46, },
	{ 1, 0, 0, 0, 6, 46, },
	{ 0, 0, 0, 0, 7, 46, },
	{ 2, 0, 0, 0, 7, 46, },
	{ 1, 0, 0, 0, 7, 46, },
	{ 0, 0, 0, 0, 8, 46, },
	{ 2, 0, 0, 0, 8, 46, },
	{ 1, 0, 0, 0, 8, 46, },
	{ 0, 0, 0, 0, 9, 46, },
	{ 2, 0, 0, 0, 9, 46, },
	{ 1, 0, 0, 0, 9, 46, },
	{ 0, 0, 0, 0, 10, 46, },
	{ 2, 0, 0, 0, 10, 46, },
	{ 1, 0, 0, 0, 10, 46, },
	{ 0, 0, 0, 0, 11, 46, },
	{ 2, 0, 0, 0, 11, 46, },
	{ 1, 0, 0, 0, 11, 46, },
	{ 0, 0, 0, 0, 12, 63, },
	{ 2, 0, 0, 0, 12, 46, },
	{ 1, 0, 0, 0, 12, 46, },
	{ 0, 0, 0, 0, 13, 63, },
	{ 2, 0, 0, 0, 13, 46, },
	{ 1, 0, 0, 0, 13, 46, },
	{ 0, 0, 0, 0, 14, 63, },
	{ 2, 0, 0, 0, 14, 63, },
	{ 1, 0, 0, 0, 14, 46, },
	{ 0, 0, 0, 1, 1, 46, },
	{ 2, 0, 0, 1, 1, 46, },
	{ 1, 0, 0, 1, 1, 46, },
	{ 0, 0, 0, 1, 2, 46, },
	{ 2, 0, 0, 1, 2, 46, },
	{ 1, 0, 0, 1, 2, 46, },
	{ 0, 0, 0, 1, 3, 46, },
	{ 2, 0, 0, 1, 3, 46, },
	{ 1, 0, 0, 1, 3, 46, },
	{ 0, 0, 0, 1, 4, 46, },
	{ 2, 0, 0, 1, 4, 46, },
	{ 1, 0, 0, 1, 4, 46, },
	{ 0, 0, 0, 1, 5, 46, },
	{ 2, 0, 0, 1, 5, 46, },
	{ 1, 0, 0, 1, 5, 46, },
	{ 0, 0, 0, 1, 6, 46, },
	{ 2, 0, 0, 1, 6, 46, },
	{ 1, 0, 0, 1, 6, 46, },
	{ 0, 0, 0, 1, 7, 46, },
	{ 2, 0, 0, 1, 7, 46, },
	{ 1, 0, 0, 1, 7, 46, },
	{ 0, 0, 0, 1, 8, 46, },
	{ 2, 0, 0, 1, 8, 46, },
	{ 1, 0, 0, 1, 8, 46, },
	{ 0, 0, 0, 1, 9, 46, },
	{ 2, 0, 0, 1, 9, 46, },
	{ 1, 0, 0, 1, 9, 46, },
	{ 0, 0, 0, 1, 10, 46, },
	{ 2, 0, 0, 1, 10, 46, },
	{ 1, 0, 0, 1, 10, 46, },
	{ 0, 0, 0, 1, 11, 46, },
	{ 2, 0, 0, 1, 11, 46, },
	{ 1, 0, 0, 1, 11, 46, },
	{ 0, 0, 0, 1, 12, 63, },
	{ 2, 0, 0, 1, 12, 46, },
	{ 1, 0, 0, 1, 12, 46, },
	{ 0, 0, 0, 1, 13, 63, },
	{ 2, 0, 0, 1, 13, 46, },
	{ 1, 0, 0, 1, 13, 46, },
	{ 0, 0, 0, 1, 14, 63, },
	{ 2, 0, 0, 1, 14, 63, },
	{ 1, 0, 0, 1, 14, 46, },
	{ 0, 0, 0, 2, 1, 46, },
	{ 2, 0, 0, 2, 1, 46, },
	{ 1, 0, 0, 2, 1, 46, },
	{ 0, 0, 0, 2, 2, 46, },
	{ 2, 0, 0, 2, 2, 46, },
	{ 1, 0, 0, 2, 2, 46, },
	{ 0, 0, 0, 2, 3, 46, },
	{ 2, 0, 0, 2, 3, 46, },
	{ 1, 0, 0, 2, 3, 46, },
	{ 0, 0, 0, 2, 4, 46, },
	{ 2, 0, 0, 2, 4, 46, },
	{ 1, 0, 0, 2, 4, 46, },
	{ 0, 0, 0, 2, 5, 46, },
	{ 2, 0, 0, 2, 5, 46, },
	{ 1, 0, 0, 2, 5, 46, },
	{ 0, 0, 0, 2, 6, 46, },
	{ 2, 0, 0, 2, 6, 46, },
	{ 1, 0, 0, 2, 6, 46, },
	{ 0, 0, 0, 2, 7, 46, },
	{ 2, 0, 0, 2, 7, 46, },
	{ 1, 0, 0, 2, 7, 46, },
	{ 0, 0, 0, 2, 8, 46, },
	{ 2, 0, 0, 2, 8, 46, },
	{ 1, 0, 0, 2, 8, 46, },
	{ 0, 0, 0, 2, 9, 46, },
	{ 2, 0, 0, 2, 9, 46, },
	{ 1, 0, 0, 2, 9, 46, },
	{ 0, 0, 0, 2, 10, 46, },
	{ 2, 0, 0, 2, 10, 46, },
	{ 1, 0, 0, 2, 10, 46, },
	{ 0, 0, 0, 2, 11, 46, },
	{ 2, 0, 0, 2, 11, 46, },
	{ 1, 0, 0, 2, 11, 46, },
	{ 0, 0, 0, 2, 12, 63, },
	{ 2, 0, 0, 2, 12, 46, },
	{ 1, 0, 0, 2, 12, 46, },
	{ 0, 0, 0, 2, 13, 63, },
	{ 2, 0, 0, 2, 13, 46, },
	{ 1, 0, 0, 2, 13, 46, },
	{ 0, 0, 0, 2, 14, 63, },
	{ 2, 0, 0, 2, 14, 63, },
	{ 1, 0, 0, 2, 14, 46, },
	{ 0, 0, 0, 3, 1, 46, },
	{ 2, 0, 0, 3, 1, 46, },
	{ 1, 0, 0, 3, 1, 46, },
	{ 0, 0, 0, 3, 2, 46, },
	{ 2, 0, 0, 3, 2, 46, },
	{ 1, 0, 0, 3, 2, 46, },
	{ 0, 0, 0, 3, 3, 46, },
	{ 2, 0, 0, 3, 3, 46, },
	{ 1, 0, 0, 3, 3, 46, },
	{ 0, 0, 0, 3, 4, 46, },
	{ 2, 0, 0, 3, 4, 46, },
	{ 1, 0, 0, 3, 4, 46, },
	{ 0, 0, 0, 3, 5, 46, },
	{ 2, 0, 0, 3, 5, 46, },
	{ 1, 0, 0, 3, 5, 46, },
	{ 0, 0, 0, 3, 6, 46, },
	{ 2, 0, 0, 3, 6, 46, },
	{ 1, 0, 0, 3, 6, 46, },
	{ 0, 0, 0, 3, 7, 46, },
	{ 2, 0, 0, 3, 7, 46, },
	{ 1, 0, 0, 3, 7, 46, },
	{ 0, 0, 0, 3, 8, 46, },
	{ 2, 0, 0, 3, 8, 46, },
	{ 1, 0, 0, 3, 8, 46, },
	{ 0, 0, 0, 3, 9, 46, },
	{ 2, 0, 0, 3, 9, 46, },
	{ 1, 0, 0, 3, 9, 46, },
	{ 0, 0, 0, 3, 10, 46, },
	{ 2, 0, 0, 3, 10, 46, },
	{ 1, 0, 0, 3, 10, 46, },
	{ 0, 0, 0, 3, 11, 46, },
	{ 2, 0, 0, 3, 11, 46, },
	{ 1, 0, 0, 3, 11, 46, },
	{ 0, 0, 0, 3, 12, 63, },
	{ 2, 0, 0, 3, 12, 46, },
	{ 1, 0, 0, 3, 12, 46, },
	{ 0, 0, 0, 3, 13, 63, },
	{ 2, 0, 0, 3, 13, 46, },
	{ 1, 0, 0, 3, 13, 46, },
	{ 0, 0, 0, 3, 14, 63, },
	{ 2, 0, 0, 3, 14, 63, },
	{ 1, 0, 0, 3, 14, 46, },
	{ 0, 0, 0, 6, 1, 46, },
	{ 2, 0, 0, 6, 1, 46, },
	{ 1, 0, 0, 6, 1, 46, },
	{ 0, 0, 0, 6, 2, 46, },
	{ 2, 0, 0, 6, 2, 46, },
	{ 1, 0, 0, 6, 2, 46, },
	{ 0, 0, 0, 6, 3, 46, },
	{ 2, 0, 0, 6, 3, 46, },
	{ 1, 0, 0, 6, 3, 46, },
	{ 0, 0, 0, 6, 4, 46, },
	{ 2, 0, 0, 6, 4, 46, },
	{ 1, 0, 0, 6, 4, 46, },
	{ 0, 0, 0, 6, 5, 46, },
	{ 2, 0, 0, 6, 5, 46, },
	{ 1, 0, 0, 6, 5, 46, },
	{ 0, 0, 0, 6, 6, 46, },
	{ 2, 0, 0, 6, 6, 46, },
	{ 1, 0, 0, 6, 6, 46, },
	{ 0, 0, 0, 6, 7, 46, },
	{ 2, 0, 0, 6, 7, 46, },
	{ 1, 0, 0, 6, 7, 46, },
	{ 0, 0, 0, 6, 8, 46, },
	{ 2, 0, 0, 6, 8, 46, },
	{ 1, 0, 0, 6, 8, 46, },
	{ 0, 0, 0, 6, 9, 46, },
	{ 2, 0, 0, 6, 9, 46, },
	{ 1, 0, 0, 6, 9, 46, },
	{ 0, 0, 0, 6, 10, 46, },
	{ 2, 0, 0, 6, 10, 46, },
	{ 1, 0, 0, 6, 10, 46, },
	{ 0, 0, 0, 6, 11, 46, },
	{ 2, 0, 0, 6, 11, 46, },
	{ 1, 0, 0, 6, 11, 46, },
	{ 0, 0, 0, 6, 12, 63, },
	{ 2, 0, 0, 6, 12, 46, },
	{ 1, 0, 0, 6, 12, 46, },
	{ 0, 0, 0, 6, 13, 63, },
	{ 2, 0, 0, 6, 13, 46, },
	{ 1, 0, 0, 6, 13, 46, },
	{ 0, 0, 0, 6, 14, 63, },
	{ 2, 0, 0, 6, 14, 63, },
	{ 1, 0, 0, 6, 14, 46, },
	{ 0, 0, 0, 7, 1, 46, },
	{ 2, 0, 0, 7, 1, 46, },
	{ 1, 0, 0, 7, 1, 46, },
	{ 0, 0, 0, 7, 2, 46, },
	{ 2, 0, 0, 7, 2, 46, },
	{ 1, 0, 0, 7, 2, 46, },
	{ 0, 0, 0, 7, 3, 46, },
	{ 2, 0, 0, 7, 3, 46, },
	{ 1, 0, 0, 7, 3, 46, },
	{ 0, 0, 0, 7, 4, 46, },
	{ 2, 0, 0, 7, 4, 46, },
	{ 1, 0, 0, 7, 4, 46, },
	{ 0, 0, 0, 7, 5, 46, },
	{ 2, 0, 0, 7, 5, 46, },
	{ 1, 0, 0, 7, 5, 46, },
	{ 0, 0, 0, 7, 6, 46, },
	{ 2, 0, 0, 7, 6, 46, },
	{ 1, 0, 0, 7, 6, 46, },
	{ 0, 0, 0, 7, 7, 46, },
	{ 2, 0, 0, 7, 7, 46, },
	{ 1, 0, 0, 7, 7, 46, },
	{ 0, 0, 0, 7, 8, 46, },
	{ 2, 0, 0, 7, 8, 46, },
	{ 1, 0, 0, 7, 8, 46, },
	{ 0, 0, 0, 7, 9, 46, },
	{ 2, 0, 0, 7, 9, 46, },
	{ 1, 0, 0, 7, 9, 46, },
	{ 0, 0, 0, 7, 10, 46, },
	{ 2, 0, 0, 7, 10, 46, },
	{ 1, 0, 0, 7, 10, 46, },
	{ 0, 0, 0, 7, 11, 46, },
	{ 2, 0, 0, 7, 11, 46, },
	{ 1, 0, 0, 7, 11, 46, },
	{ 0, 0, 0, 7, 12, 63, },
	{ 2, 0, 0, 7, 12, 46, },
	{ 1, 0, 0, 7, 12, 46, },
	{ 0, 0, 0, 7, 13, 63, },
	{ 2, 0, 0, 7, 13, 46, },
	{ 1, 0, 0, 7, 13, 46, },
	{ 0, 0, 0, 7, 14, 63, },
	{ 2, 0, 0, 7, 14, 63, },
	{ 1, 0, 0, 7, 14, 46, },
	{ 0, 0, 1, 2, 1, 63, },
	{ 2, 0, 1, 2, 1, 63, },
	{ 1, 0, 1, 2, 1, 63, },
	{ 0, 0, 1, 2, 2, 63, },
	{ 2, 0, 1, 2, 2, 63, },
	{ 1, 0, 1, 2, 2, 63, },
	{ 0, 0, 1, 2, 3, 30, },
	{ 2, 0, 1, 2, 3, 34, },
	{ 1, 0, 1, 2, 3, 34, },
	{ 0, 0, 1, 2, 4, 34, },
	{ 2, 0, 1, 2, 4, 34, },
	{ 1, 0, 1, 2, 4, 34, },
	{ 0, 0, 1, 2, 5, 34, },
	{ 2, 0, 1, 2, 5, 34, },
	{ 1, 0, 1, 2, 5, 34, },
	{ 0, 0, 1, 2, 6, 34, },
	{ 2, 0, 1, 2, 6, 34, },
	{ 1, 0, 1, 2, 6, 34, },
	{ 0, 0, 1, 2, 7, 34, },
	{ 2, 0, 1, 2, 7, 34, },
	{ 1, 0, 1, 2, 7, 34, },
	{ 0, 0, 1, 2, 8, 34, },
	{ 2, 0, 1, 2, 8, 34, },
	{ 1, 0, 1, 2, 8, 34, },
	{ 0, 0, 1, 2, 9, 34, },
	{ 2, 0, 1, 2, 9, 34, },
	{ 1, 0, 1, 2, 9, 34, },
	{ 0, 0, 1, 2, 10, 34, },
	{ 2, 0, 1, 2, 10, 34, },
	{ 1, 0, 1, 2, 10, 34, },
	{ 0, 0, 1, 2, 11, 28, },
	{ 2, 0, 1, 2, 11, 34, },
	{ 1, 0, 1, 2, 11, 34, },
	{ 0, 0, 1, 2, 12, 63, },
	{ 2, 0, 1, 2, 12, 34, },
	{ 1, 0, 1, 2, 12, 34, },
	{ 0, 0, 1, 2, 13, 63, },
	{ 2, 0, 1, 2, 13, 34, },
	{ 1, 0, 1, 2, 13, 34, },
	{ 0, 0, 1, 2, 14, 63, },
	{ 2, 0, 1, 2, 14, 63, },
	{ 1, 0, 1, 2, 14, 63, },
	{ 0, 0, 1, 3, 1, 63, },
	{ 2, 0, 1, 3, 1, 63, },
	{ 1, 0, 1, 3, 1, 63, },
	{ 0, 0, 1, 3, 2, 63, },
	{ 2, 0, 1, 3, 2, 63, },
	{ 1, 0, 1, 3, 2, 63, },
	{ 0, 0, 1, 3, 3, 30, },
	{ 2, 0, 1, 3, 3, 34, },
	{ 1, 0, 1, 3, 3, 34, },
	{ 0, 0, 1, 3, 4, 34, },
	{ 2, 0, 1, 3, 4, 34, },
	{ 1, 0, 1, 3, 4, 34, },
	{ 0, 0, 1, 3, 5, 34, },
	{ 2, 0, 1, 3, 5, 34, },
	{ 1, 0, 1, 3, 5, 34, },
	{ 0, 0, 1, 3, 6, 34, },
	{ 2, 0, 1, 3, 6, 34, },
	{ 1, 0, 1, 3, 6, 34, },
	{ 0, 0, 1, 3, 7, 34, },
	{ 2, 0, 1, 3, 7, 34, },
	{ 1, 0, 1, 3, 7, 34, },
	{ 0, 0, 1, 3, 8, 34, },
	{ 2, 0, 1, 3, 8, 34, },
	{ 1, 0, 1, 3, 8, 34, },
	{ 0, 0, 1, 3, 9, 34, },
	{ 2, 0, 1, 3, 9, 34, },
	{ 1, 0, 1, 3, 9, 34, },
	{ 0, 0, 1, 3, 10, 34, },
	{ 2, 0, 1, 3, 10, 34, },
	{ 1, 0, 1, 3, 10, 34, },
	{ 0, 0, 1, 3, 11, 28, },
	{ 2, 0, 1, 3, 11, 34, },
	{ 1, 0, 1, 3, 11, 34, },
	{ 0, 0, 1, 3, 12, 63, },
	{ 2, 0, 1, 3, 12, 34, },
	{ 1, 0, 1, 3, 12, 34, },
	{ 0, 0, 1, 3, 13, 63, },
	{ 2, 0, 1, 3, 13, 34, },
	{ 1, 0, 1, 3, 13, 34, },
	{ 0, 0, 1, 3, 14, 63, },
	{ 2, 0, 1, 3, 14, 63, },
	{ 1, 0, 1, 3, 14, 63, },
	{ 0, 0, 1, 6, 1, 63, },
	{ 2, 0, 1, 6, 1, 63, },
	{ 1, 0, 1, 6, 1, 63, },
	{ 0, 0, 1, 6, 2, 63, },
	{ 2, 0, 1, 6, 2, 63, },
	{ 1, 0, 1, 6, 2, 63, },
	{ 0, 0, 1, 6, 3, 30, },
	{ 2, 0, 1, 6, 3, 34, },
	{ 1, 0, 1, 6, 3, 34, },
	{ 0, 0, 1, 6, 4, 34, },
	{ 2, 0, 1, 6, 4, 34, },
	{ 1, 0, 1, 6, 4, 34, },
	{ 0, 0, 1, 6, 5, 34, },
	{ 2, 0, 1, 6, 5, 34, },
	{ 1, 0, 1, 6, 5, 34, },
	{ 0, 0, 1, 6, 6, 34, },
	{ 2, 0, 1, 6, 6, 34, },
	{ 1, 0, 1, 6, 6, 34, },
	{ 0, 0, 1, 6, 7, 34, },
	{ 2, 0, 1, 6, 7, 34, },
	{ 1, 0, 1, 6, 7, 34, },
	{ 0, 0, 1, 6, 8, 34, },
	{ 2, 0, 1, 6, 8, 34, },
	{ 1, 0, 1, 6, 8, 34, },
	{ 0, 0, 1, 6, 9, 34, },
	{ 2, 0, 1, 6, 9, 34, },
	{ 1, 0, 1, 6, 9, 34, },
	{ 0, 0, 1, 6, 10, 34, },
	{ 2, 0, 1, 6, 10, 34, },
	{ 1, 0, 1, 6, 10, 34, },
	{ 0, 0, 1, 6, 11, 28, },
	{ 2, 0, 1, 6, 11, 34, },
	{ 1, 0, 1, 6, 11, 34, },
	{ 0, 0, 1, 6, 12, 63, },
	{ 2, 0, 1, 6, 12, 34, },
	{ 1, 0, 1, 6, 12, 34, },
	{ 0, 0, 1, 6, 13, 63, },
	{ 2, 0, 1, 6, 13, 34, },
	{ 1, 0, 1, 6, 13, 34, },
	{ 0, 0, 1, 6, 14, 63, },
	{ 2, 0, 1, 6, 14, 63, },
	{ 1, 0, 1, 6, 14, 63, },
	{ 0, 0, 1, 7, 1, 63, },
	{ 2, 0, 1, 7, 1, 63, },
	{ 1, 0, 1, 7, 1, 63, },
	{ 0, 0, 1, 7, 2, 63, },
	{ 2, 0, 1, 7, 2, 63, },
	{ 1, 0, 1, 7, 2, 63, },
	{ 0, 0, 1, 7, 3, 30, },
	{ 2, 0, 1, 7, 3, 34, },
	{ 1, 0, 1, 7, 3, 34, },
	{ 0, 0, 1, 7, 4, 34, },
	{ 2, 0, 1, 7, 4, 34, },
	{ 1, 0, 1, 7, 4, 34, },
	{ 0, 0, 1, 7, 5, 34, },
	{ 2, 0, 1, 7, 5, 34, },
	{ 1, 0, 1, 7, 5, 34, },
	{ 0, 0, 1, 7, 6, 34, },
	{ 2, 0, 1, 7, 6, 34, },
	{ 1, 0, 1, 7, 6, 34, },
	{ 0, 0, 1, 7, 7, 34, },
	{ 2, 0, 1, 7, 7, 34, },
	{ 1, 0, 1, 7, 7, 34, },
	{ 0, 0, 1, 7, 8, 34, },
	{ 2, 0, 1, 7, 8, 34, },
	{ 1, 0, 1, 7, 8, 34, },
	{ 0, 0, 1, 7, 9, 34, },
	{ 2, 0, 1, 7, 9, 34, },
	{ 1, 0, 1, 7, 9, 34, },
	{ 0, 0, 1, 7, 10, 34, },
	{ 2, 0, 1, 7, 10, 34, },
	{ 1, 0, 1, 7, 10, 34, },
	{ 0, 0, 1, 7, 11, 28, },
	{ 2, 0, 1, 7, 11, 34, },
	{ 1, 0, 1, 7, 11, 34, },
	{ 0, 0, 1, 7, 12, 63, },
	{ 2, 0, 1, 7, 12, 34, },
	{ 1, 0, 1, 7, 12, 34, },
	{ 0, 0, 1, 7, 13, 63, },
	{ 2, 0, 1, 7, 13, 34, },
	{ 1, 0, 1, 7, 13, 34, },
	{ 0, 0, 1, 7, 14, 63, },
	{ 2, 0, 1, 7, 14, 63, },
	{ 1, 0, 1, 7, 14, 63, },
	{ 0, 1, 0, 1, 36, 46, },
	{ 2, 1, 0, 1, 36, 46, },
	{ 1, 1, 0, 1, 36, 46, },
	{ 0, 1, 0, 1, 40, 46, },
	{ 2, 1, 0, 1, 40, 46, },
	{ 1, 1, 0, 1, 40, 46, },
	{ 0, 1, 0, 1, 44, 46, },
	{ 2, 1, 0, 1, 44, 46, },
	{ 1, 1, 0, 1, 44, 46, },
	{ 0, 1, 0, 1, 48, 46, },
	{ 2, 1, 0, 1, 48, 46, },
	{ 1, 1, 0, 1, 48, 46, },
	{ 0, 1, 0, 1, 52, 46, },
	{ 2, 1, 0, 1, 52, 46, },
	{ 1, 1, 0, 1, 52, 46, },
	{ 0, 1, 0, 1, 56, 46, },
	{ 2, 1, 0, 1, 56, 46, },
	{ 1, 1, 0, 1, 56, 46, },
	{ 0, 1, 0, 1, 60, 46, },
	{ 2, 1, 0, 1, 60, 46, },
	{ 1, 1, 0, 1, 60, 46, },
	{ 0, 1, 0, 1, 64, 46, },
	{ 2, 1, 0, 1, 64, 46, },
	{ 1, 1, 0, 1, 64, 46, },
	{ 0, 1, 0, 1, 100, 46, },
	{ 2, 1, 0, 1, 100, 46, },
	{ 1, 1, 0, 1, 100, 46, },
	{ 0, 1, 0, 1, 104, 46, },
	{ 2, 1, 0, 1, 104, 46, },
	{ 1, 1, 0, 1, 104, 46, },
	{ 0, 1, 0, 1, 108, 46, },
	{ 2, 1, 0, 1, 108, 46, },
	{ 1, 1, 0, 1, 108, 46, },
	{ 0, 1, 0, 1, 112, 46, },
	{ 2, 1, 0, 1, 112, 46, },
	{ 1, 1, 0, 1, 112, 46, },
	{ 0, 1, 0, 1, 116, 46, },
	{ 2, 1, 0, 1, 116, 46, },
	{ 1, 1, 0, 1, 116, 46, },
	{ 0, 1, 0, 1, 120, 46, },
	{ 2, 1, 0, 1, 120, 46, },
	{ 1, 1, 0, 1, 120, 46, },
	{ 0, 1, 0, 1, 124, 46, },
	{ 2, 1, 0, 1, 124, 46, },
	{ 1, 1, 0, 1, 124, 46, },
	{ 0, 1, 0, 1, 128, 46, },
	{ 2, 1, 0, 1, 128, 46, },
	{ 1, 1, 0, 1, 128, 46, },
	{ 0, 1, 0, 1, 132, 46, },
	{ 2, 1, 0, 1, 132, 46, },
	{ 1, 1, 0, 1, 132, 46, },
	{ 0, 1, 0, 1, 136, 46, },
	{ 2, 1, 0, 1, 136, 46, },
	{ 1, 1, 0, 1, 136, 46, },
	{ 0, 1, 0, 1, 140, 46, },
	{ 2, 1, 0, 1, 140, 46, },
	{ 1, 1, 0, 1, 140, 46, },
	{ 0, 1, 0, 1, 149, 46, },
	{ 2, 1, 0, 1, 149, 46, },
	{ 1, 1, 0, 1, 149, 63, },
	{ 0, 1, 0, 1, 153, 46, },
	{ 2, 1, 0, 1, 153, 46, },
	{ 1, 1, 0, 1, 153, 63, },
	{ 0, 1, 0, 1, 157, 46, },
	{ 2, 1, 0, 1, 157, 46, },
	{ 1, 1, 0, 1, 157, 63, },
	{ 0, 1, 0, 1, 161, 46, },
	{ 2, 1, 0, 1, 161, 46, },
	{ 1, 1, 0, 1, 161, 63, },
	{ 0, 1, 0, 1, 165, 46, },
	{ 2, 1, 0, 1, 165, 46, },
	{ 1, 1, 0, 1, 165, 63, },
	{ 0, 1, 0, 2, 36, 46, },
	{ 2, 1, 0, 2, 36, 46, },
	{ 1, 1, 0, 2, 36, 46, },
	{ 0, 1, 0, 2, 40, 46, },
	{ 2, 1, 0, 2, 40, 46, },
	{ 1, 1, 0, 2, 40, 46, },
	{ 0, 1, 0, 2, 44, 46, },
	{ 2, 1, 0, 2, 44, 46, },
	{ 1, 1, 0, 2, 44, 46, },
	{ 0, 1, 0, 2, 48, 46, },
	{ 2, 1, 0, 2, 48, 46, },
	{ 1, 1, 0, 2, 48, 46, },
	{ 0, 1, 0, 2, 52, 46, },
	{ 2, 1, 0, 2, 52, 46, },
	{ 1, 1, 0, 2, 52, 46, },
	{ 0, 1, 0, 2, 56, 46, },
	{ 2, 1, 0, 2, 56, 46, },
	{ 1, 1, 0, 2, 56, 46, },
	{ 0, 1, 0, 2, 60, 46, },
	{ 2, 1, 0, 2, 60, 46, },
	{ 1, 1, 0, 2, 60, 46, },
	{ 0, 1, 0, 2, 64, 46, },
	{ 2, 1, 0, 2, 64, 46, },
	{ 1, 1, 0, 2, 64, 46, },
	{ 0, 1, 0, 2, 100, 46, },
	{ 2, 1, 0, 2, 100, 46, },
	{ 1, 1, 0, 2, 100, 46, },
	{ 0, 1, 0, 2, 104, 46, },
	{ 2, 1, 0, 2, 104, 46, },
	{ 1, 1, 0, 2, 104, 46, },
	{ 0, 1, 0, 2, 108, 46, },
	{ 2, 1, 0, 2, 108, 46, },
	{ 1, 1, 0, 2, 108, 46, },
	{ 0, 1, 0, 2, 112, 46, },
	{ 2, 1, 0, 2, 112, 46, },
	{ 1, 1, 0, 2, 112, 46, },
	{ 0, 1, 0, 2, 116, 46, },
	{ 2, 1, 0, 2, 116, 46, },
	{ 1, 1, 0, 2, 116, 46, },
	{ 0, 1, 0, 2, 120, 46, },
	{ 2, 1, 0, 2, 120, 46, },
	{ 1, 1, 0, 2, 120, 46, },
	{ 0, 1, 0, 2, 124, 46, },
	{ 2, 1, 0, 2, 124, 46, },
	{ 1, 1, 0, 2, 124, 46, },
	{ 0, 1, 0, 2, 128, 46, },
	{ 2, 1, 0, 2, 128, 46, },
	{ 1, 1, 0, 2, 128, 46, },
	{ 0, 1, 0, 2, 132, 46, },
	{ 2, 1, 0, 2, 132, 46, },
	{ 1, 1, 0, 2, 132, 46, },
	{ 0, 1, 0, 2, 136, 46, },
	{ 2, 1, 0, 2, 136, 46, },
	{ 1, 1, 0, 2, 136, 46, },
	{ 0, 1, 0, 2, 140, 46, },
	{ 2, 1, 0, 2, 140, 46, },
	{ 1, 1, 0, 2, 140, 46, },
	{ 0, 1, 0, 2, 149, 46, },
	{ 2, 1, 0, 2, 149, 46, },
	{ 1, 1, 0, 2, 149, 63, },
	{ 0, 1, 0, 2, 153, 46, },
	{ 2, 1, 0, 2, 153, 46, },
	{ 1, 1, 0, 2, 153, 63, },
	{ 0, 1, 0, 2, 157, 46, },
	{ 2, 1, 0, 2, 157, 46, },
	{ 1, 1, 0, 2, 157, 63, },
	{ 0, 1, 0, 2, 161, 46, },
	{ 2, 1, 0, 2, 161, 46, },
	{ 1, 1, 0, 2, 161, 63, },
	{ 0, 1, 0, 2, 165, 46, },
	{ 2, 1, 0, 2, 165, 46, },
	{ 1, 1, 0, 2, 165, 63, },
	{ 0, 1, 0, 3, 36, 46, },
	{ 2, 1, 0, 3, 36, 46, },
	{ 1, 1, 0, 3, 36, 46, },
	{ 0, 1, 0, 3, 40, 46, },
	{ 2, 1, 0, 3, 40, 46, },
	{ 1, 1, 0, 3, 40, 46, },
	{ 0, 1, 0, 3, 44, 46, },
	{ 2, 1, 0, 3, 44, 46, },
	{ 1, 1, 0, 3, 44, 46, },
	{ 0, 1, 0, 3, 48, 46, },
	{ 2, 1, 0, 3, 48, 46, },
	{ 1, 1, 0, 3, 48, 46, },
	{ 0, 1, 0, 3, 52, 46, },
	{ 2, 1, 0, 3, 52, 46, },
	{ 1, 1, 0, 3, 52, 46, },
	{ 0, 1, 0, 3, 56, 46, },
	{ 2, 1, 0, 3, 56, 46, },
	{ 1, 1, 0, 3, 56, 46, },
	{ 0, 1, 0, 3, 60, 46, },
	{ 2, 1, 0, 3, 60, 46, },
	{ 1, 1, 0, 3, 60, 46, },
	{ 0, 1, 0, 3, 64, 46, },
	{ 2, 1, 0, 3, 64, 46, },
	{ 1, 1, 0, 3, 64, 46, },
	{ 0, 1, 0, 3, 100, 46, },
	{ 2, 1, 0, 3, 100, 46, },
	{ 1, 1, 0, 3, 100, 46, },
	{ 0, 1, 0, 3, 104, 46, },
	{ 2, 1, 0, 3, 104, 46, },
	{ 1, 1, 0, 3, 104, 46, },
	{ 0, 1, 0, 3, 108, 46, },
	{ 2, 1, 0, 3, 108, 46, },
	{ 1, 1, 0, 3, 108, 46, },
	{ 0, 1, 0, 3, 112, 46, },
	{ 2, 1, 0, 3, 112, 46, },
	{ 1, 1, 0, 3, 112, 46, },
	{ 0, 1, 0, 3, 116, 46, },
	{ 2, 1, 0, 3, 116, 46, },
	{ 1, 1, 0, 3, 116, 46, },
	{ 0, 1, 0, 3, 120, 46, },
	{ 2, 1, 0, 3, 120, 46, },
	{ 1, 1, 0, 3, 120, 46, },
	{ 0, 1, 0, 3, 124, 46, },
	{ 2, 1, 0, 3, 124, 46, },
	{ 1, 1, 0, 3, 124, 46, },
	{ 0, 1, 0, 3, 128, 46, },
	{ 2, 1, 0, 3, 128, 46, },
	{ 1, 1, 0, 3, 128, 46, },
	{ 0, 1, 0, 3, 132, 46, },
	{ 2, 1, 0, 3, 132, 46, },
	{ 1, 1, 0, 3, 132, 46, },
	{ 0, 1, 0, 3, 136, 46, },
	{ 2, 1, 0, 3, 136, 46, },
	{ 1, 1, 0, 3, 136, 46, },
	{ 0, 1, 0, 3, 140, 46, },
	{ 2, 1, 0, 3, 140, 46, },
	{ 1, 1, 0, 3, 140, 46, },
	{ 0, 1, 0, 3, 149, 46, },
	{ 2, 1, 0, 3, 149, 46, },
	{ 1, 1, 0, 3, 149, 63, },
	{ 0, 1, 0, 3, 153, 46, },
	{ 2, 1, 0, 3, 153, 46, },
	{ 1, 1, 0, 3, 153, 63, },
	{ 0, 1, 0, 3, 157, 46, },
	{ 2, 1, 0, 3, 157, 46, },
	{ 1, 1, 0, 3, 157, 63, },
	{ 0, 1, 0, 3, 161, 46, },
	{ 2, 1, 0, 3, 161, 46, },
	{ 1, 1, 0, 3, 161, 63, },
	{ 0, 1, 0, 3, 165, 46, },
	{ 2, 1, 0, 3, 165, 46, },
	{ 1, 1, 0, 3, 165, 63, },
	{ 0, 1, 0, 6, 36, 46, },
	{ 2, 1, 0, 6, 36, 46, },
	{ 1, 1, 0, 6, 36, 46, },
	{ 0, 1, 0, 6, 40, 46, },
	{ 2, 1, 0, 6, 40, 46, },
	{ 1, 1, 0, 6, 40, 46, },
	{ 0, 1, 0, 6, 44, 46, },
	{ 2, 1, 0, 6, 44, 46, },
	{ 1, 1, 0, 6, 44, 46, },
	{ 0, 1, 0, 6, 48, 46, },
	{ 2, 1, 0, 6, 48, 46, },
	{ 1, 1, 0, 6, 48, 46, },
	{ 0, 1, 0, 6, 52, 46, },
	{ 2, 1, 0, 6, 52, 46, },
	{ 1, 1, 0, 6, 52, 46, },
	{ 0, 1, 0, 6, 56, 46, },
	{ 2, 1, 0, 6, 56, 46, },
	{ 1, 1, 0, 6, 56, 46, },
	{ 0, 1, 0, 6, 60, 46, },
	{ 2, 1, 0, 6, 60, 46, },
	{ 1, 1, 0, 6, 60, 46, },
	{ 0, 1, 0, 6, 64, 46, },
	{ 2, 1, 0, 6, 64, 46, },
	{ 1, 1, 0, 6, 64, 46, },
	{ 0, 1, 0, 6, 100, 46, },
	{ 2, 1, 0, 6, 100, 46, },
	{ 1, 1, 0, 6, 100, 46, },
	{ 0, 1, 0, 6, 104, 46, },
	{ 2, 1, 0, 6, 104, 46, },
	{ 1, 1, 0, 6, 104, 46, },
	{ 0, 1, 0, 6, 108, 46, },
	{ 2, 1, 0, 6, 108, 46, },
	{ 1, 1, 0, 6, 108, 46, },
	{ 0, 1, 0, 6, 112, 46, },
	{ 2, 1, 0, 6, 112, 46, },
	{ 1, 1, 0, 6, 112, 46, },
	{ 0, 1, 0, 6, 116, 46, },
	{ 2, 1, 0, 6, 116, 46, },
	{ 1, 1, 0, 6, 116, 46, },
	{ 0, 1, 0, 6, 120, 46, },
	{ 2, 1, 0, 6, 120, 46, },
	{ 1, 1, 0, 6, 120, 46, },
	{ 0, 1, 0, 6, 124, 46, },
	{ 2, 1, 0, 6, 124, 46, },
	{ 1, 1, 0, 6, 124, 46, },
	{ 0, 1, 0, 6, 128, 46, },
	{ 2, 1, 0, 6, 128, 46, },
	{ 1, 1, 0, 6, 128, 46, },
	{ 0, 1, 0, 6, 132, 46, },
	{ 2, 1, 0, 6, 132, 46, },
	{ 1, 1, 0, 6, 132, 46, },
	{ 0, 1, 0, 6, 136, 46, },
	{ 2, 1, 0, 6, 136, 46, },
	{ 1, 1, 0, 6, 136, 46, },
	{ 0, 1, 0, 6, 140, 46, },
	{ 2, 1, 0, 6, 140, 46, },
	{ 1, 1, 0, 6, 140, 46, },
	{ 0, 1, 0, 6, 149, 46, },
	{ 2, 1, 0, 6, 149, 46, },
	{ 1, 1, 0, 6, 149, 63, },
	{ 0, 1, 0, 6, 153, 46, },
	{ 2, 1, 0, 6, 153, 46, },
	{ 1, 1, 0, 6, 153, 63, },
	{ 0, 1, 0, 6, 157, 46, },
	{ 2, 1, 0, 6, 157, 46, },
	{ 1, 1, 0, 6, 157, 63, },
	{ 0, 1, 0, 6, 161, 46, },
	{ 2, 1, 0, 6, 161, 46, },
	{ 1, 1, 0, 6, 161, 63, },
	{ 0, 1, 0, 6, 165, 46, },
	{ 2, 1, 0, 6, 165, 46, },
	{ 1, 1, 0, 6, 165, 63, },
	{ 0, 1, 0, 7, 36, 46, },
	{ 2, 1, 0, 7, 36, 46, },
	{ 1, 1, 0, 7, 36, 46, },
	{ 0, 1, 0, 7, 40, 46, },
	{ 2, 1, 0, 7, 40, 46, },
	{ 1, 1, 0, 7, 40, 46, },
	{ 0, 1, 0, 7, 44, 46, },
	{ 2, 1, 0, 7, 44, 46, },
	{ 1, 1, 0, 7, 44, 46, },
	{ 0, 1, 0, 7, 48, 46, },
	{ 2, 1, 0, 7, 48, 46, },
	{ 1, 1, 0, 7, 48, 46, },
	{ 0, 1, 0, 7, 52, 46, },
	{ 2, 1, 0, 7, 52, 46, },
	{ 1, 1, 0, 7, 52, 46, },
	{ 0, 1, 0, 7, 56, 46, },
	{ 2, 1, 0, 7, 56, 46, },
	{ 1, 1, 0, 7, 56, 46, },
	{ 0, 1, 0, 7, 60, 46, },
	{ 2, 1, 0, 7, 60, 46, },
	{ 1, 1, 0, 7, 60, 46, },
	{ 0, 1, 0, 7, 64, 46, },
	{ 2, 1, 0, 7, 64, 46, },
	{ 1, 1, 0, 7, 64, 46, },
	{ 0, 1, 0, 7, 100, 46, },
	{ 2, 1, 0, 7, 100, 46, },
	{ 1, 1, 0, 7, 100, 46, },
	{ 0, 1, 0, 7, 104, 46, },
	{ 2, 1, 0, 7, 104, 46, },
	{ 1, 1, 0, 7, 104, 46, },
	{ 0, 1, 0, 7, 108, 46, },
	{ 2, 1, 0, 7, 108, 46, },
	{ 1, 1, 0, 7, 108, 46, },
	{ 0, 1, 0, 7, 112, 46, },
	{ 2, 1, 0, 7, 112, 46, },
	{ 1, 1, 0, 7, 112, 46, },
	{ 0, 1, 0, 7, 116, 46, },
	{ 2, 1, 0, 7, 116, 46, },
	{ 1, 1, 0, 7, 116, 46, },
	{ 0, 1, 0, 7, 120, 46, },
	{ 2, 1, 0, 7, 120, 46, },
	{ 1, 1, 0, 7, 120, 46, },
	{ 0, 1, 0, 7, 124, 46, },
	{ 2, 1, 0, 7, 124, 46, },
	{ 1, 1, 0, 7, 124, 46, },
	{ 0, 1, 0, 7, 128, 46, },
	{ 2, 1, 0, 7, 128, 46, },
	{ 1, 1, 0, 7, 128, 46, },
	{ 0, 1, 0, 7, 132, 46, },
	{ 2, 1, 0, 7, 132, 46, },
	{ 1, 1, 0, 7, 132, 46, },
	{ 0, 1, 0, 7, 136, 46, },
	{ 2, 1, 0, 7, 136, 46, },
	{ 1, 1, 0, 7, 136, 46, },
	{ 0, 1, 0, 7, 140, 46, },
	{ 2, 1, 0, 7, 140, 46, },
	{ 1, 1, 0, 7, 140, 46, },
	{ 0, 1, 0, 7, 149, 46, },
	{ 2, 1, 0, 7, 149, 46, },
	{ 1, 1, 0, 7, 149, 63, },
	{ 0, 1, 0, 7, 153, 46, },
	{ 2, 1, 0, 7, 153, 46, },
	{ 1, 1, 0, 7, 153, 63, },
	{ 0, 1, 0, 7, 157, 46, },
	{ 2, 1, 0, 7, 157, 46, },
	{ 1, 1, 0, 7, 157, 63, },
	{ 0, 1, 0, 7, 161, 46, },
	{ 2, 1, 0, 7, 161, 46, },
	{ 1, 1, 0, 7, 161, 63, },
	{ 0, 1, 0, 7, 165, 46, },
	{ 2, 1, 0, 7, 165, 46, },
	{ 1, 1, 0, 7, 165, 63, },
	{ 0, 1, 1, 2, 38, 46, },
	{ 2, 1, 1, 2, 38, 46, },
	{ 1, 1, 1, 2, 38, 46, },
	{ 0, 1, 1, 2, 46, 46, },
	{ 2, 1, 1, 2, 46, 46, },
	{ 1, 1, 1, 2, 46, 46, },
	{ 0, 1, 1, 2, 54, 46, },
	{ 2, 1, 1, 2, 54, 46, },
	{ 1, 1, 1, 2, 54, 46, },
	{ 0, 1, 1, 2, 62, 46, },
	{ 2, 1, 1, 2, 62, 46, },
	{ 1, 1, 1, 2, 62, 46, },
	{ 0, 1, 1, 2, 102, 46, },
	{ 2, 1, 1, 2, 102, 46, },
	{ 1, 1, 1, 2, 102, 46, },
	{ 0, 1, 1, 2, 110, 46, },
	{ 2, 1, 1, 2, 110, 46, },
	{ 1, 1, 1, 2, 110, 46, },
	{ 0, 1, 1, 2, 118, 46, },
	{ 2, 1, 1, 2, 118, 46, },
	{ 1, 1, 1, 2, 118, 46, },
	{ 0, 1, 1, 2, 126, 46, },
	{ 2, 1, 1, 2, 126, 46, },
	{ 1, 1, 1, 2, 126, 46, },
	{ 0, 1, 1, 2, 134, 46, },
	{ 2, 1, 1, 2, 134, 46, },
	{ 1, 1, 1, 2, 134, 46, },
	{ 0, 1, 1, 2, 151, 46, },
	{ 2, 1, 1, 2, 151, 46, },
	{ 1, 1, 1, 2, 151, 63, },
	{ 0, 1, 1, 2, 159, 46, },
	{ 2, 1, 1, 2, 159, 46, },
	{ 1, 1, 1, 2, 159, 63, },
	{ 0, 1, 1, 3, 38, 46, },
	{ 2, 1, 1, 3, 38, 46, },
	{ 1, 1, 1, 3, 38, 46, },
	{ 0, 1, 1, 3, 46, 46, },
	{ 2, 1, 1, 3, 46, 46, },
	{ 1, 1, 1, 3, 46, 46, },
	{ 0, 1, 1, 3, 54, 46, },
	{ 2, 1, 1, 3, 54, 46, },
	{ 1, 1, 1, 3, 54, 46, },
	{ 0, 1, 1, 3, 62, 46, },
	{ 2, 1, 1, 3, 62, 46, },
	{ 1, 1, 1, 3, 62, 46, },
	{ 0, 1, 1, 3, 102, 46, },
	{ 2, 1, 1, 3, 102, 46, },
	{ 1, 1, 1, 3, 102, 46, },
	{ 0, 1, 1, 3, 110, 46, },
	{ 2, 1, 1, 3, 110, 46, },
	{ 1, 1, 1, 3, 110, 46, },
	{ 0, 1, 1, 3, 118, 46, },
	{ 2, 1, 1, 3, 118, 46, },
	{ 1, 1, 1, 3, 118, 46, },
	{ 0, 1, 1, 3, 126, 46, },
	{ 2, 1, 1, 3, 126, 46, },
	{ 1, 1, 1, 3, 126, 46, },
	{ 0, 1, 1, 3, 134, 46, },
	{ 2, 1, 1, 3, 134, 46, },
	{ 1, 1, 1, 3, 134, 46, },
	{ 0, 1, 1, 3, 151, 46, },
	{ 2, 1, 1, 3, 151, 46, },
	{ 1, 1, 1, 3, 151, 63, },
	{ 0, 1, 1, 3, 159, 46, },
	{ 2, 1, 1, 3, 159, 46, },
	{ 1, 1, 1, 3, 159, 63, },
	{ 0, 1, 1, 6, 38, 46, },
	{ 2, 1, 1, 6, 38, 46, },
	{ 1, 1, 1, 6, 38, 46, },
	{ 0, 1, 1, 6, 46, 46, },
	{ 2, 1, 1, 6, 46, 46, },
	{ 1, 1, 1, 6, 46, 46, },
	{ 0, 1, 1, 6, 54, 46, },
	{ 2, 1, 1, 6, 54, 46, },
	{ 1, 1, 1, 6, 54, 46, },
	{ 0, 1, 1, 6, 62, 46, },
	{ 2, 1, 1, 6, 62, 46, },
	{ 1, 1, 1, 6, 62, 46, },
	{ 0, 1, 1, 6, 102, 46, },
	{ 2, 1, 1, 6, 102, 46, },
	{ 1, 1, 1, 6, 102, 46, },
	{ 0, 1, 1, 6, 110, 46, },
	{ 2, 1, 1, 6, 110, 46, },
	{ 1, 1, 1, 6, 110, 46, },
	{ 0, 1, 1, 6, 118, 46, },
	{ 2, 1, 1, 6, 118, 46, },
	{ 1, 1, 1, 6, 118, 46, },
	{ 0, 1, 1, 6, 126, 46, },
	{ 2, 1, 1, 6, 126, 46, },
	{ 1, 1, 1, 6, 126, 46, },
	{ 0, 1, 1, 6, 134, 46, },
	{ 2, 1, 1, 6, 134, 46, },
	{ 1, 1, 1, 6, 134, 46, },
	{ 0, 1, 1, 6, 151, 46, },
	{ 2, 1, 1, 6, 151, 46, },
	{ 1, 1, 1, 6, 151, 63, },
	{ 0, 1, 1, 6, 159, 46, },
	{ 2, 1, 1, 6, 159, 46, },
	{ 1, 1, 1, 6, 159, 63, },
	{ 0, 1, 1, 7, 38, 46, },
	{ 2, 1, 1, 7, 38, 46, },
	{ 1, 1, 1, 7, 38, 46, },
	{ 0, 1, 1, 7, 46, 46, },
	{ 2, 1, 1, 7, 46, 46, },
	{ 1, 1, 1, 7, 46, 46, },
	{ 0, 1, 1, 7, 54, 46, },
	{ 2, 1, 1, 7, 54, 46, },
	{ 1, 1, 1, 7, 54, 46, },
	{ 0, 1, 1, 7, 62, 46, },
	{ 2, 1, 1, 7, 62, 46, },
	{ 1, 1, 1, 7, 62, 46, },
	{ 0, 1, 1, 7, 102, 46, },
	{ 2, 1, 1, 7, 102, 46, },
	{ 1, 1, 1, 7, 102, 46, },
	{ 0, 1, 1, 7, 110, 46, },
	{ 2, 1, 1, 7, 110, 46, },
	{ 1, 1, 1, 7, 110, 46, },
	{ 0, 1, 1, 7, 118, 46, },
	{ 2, 1, 1, 7, 118, 46, },
	{ 1, 1, 1, 7, 118, 46, },
	{ 0, 1, 1, 7, 126, 46, },
	{ 2, 1, 1, 7, 126, 46, },
	{ 1, 1, 1, 7, 126, 46, },
	{ 0, 1, 1, 7, 134, 46, },
	{ 2, 1, 1, 7, 134, 46, },
	{ 1, 1, 1, 7, 134, 46, },
	{ 0, 1, 1, 7, 151, 46, },
	{ 2, 1, 1, 7, 151, 46, },
	{ 1, 1, 1, 7, 151, 63, },
	{ 0, 1, 1, 7, 159, 46, },
	{ 2, 1, 1, 7, 159, 46, },
	{ 1, 1, 1, 7, 159, 63, },
	{ 0, 1, 2, 4, 42, 46, },
	{ 2, 1, 2, 4, 42, 46, },
	{ 1, 1, 2, 4, 42, 46, },
	{ 0, 1, 2, 4, 58, 46, },
	{ 2, 1, 2, 4, 58, 46, },
	{ 1, 1, 2, 4, 58, 46, },
	{ 0, 1, 2, 4, 106, 46, },
	{ 2, 1, 2, 4, 106, 46, },
	{ 1, 1, 2, 4, 106, 46, },
	{ 0, 1, 2, 4, 122, 46, },
	{ 2, 1, 2, 4, 122, 46, },
	{ 1, 1, 2, 4, 122, 46, },
	{ 0, 1, 2, 4, 155, 46, },
	{ 2, 1, 2, 4, 155, 46, },
	{ 1, 1, 2, 4, 155, 63, },
	{ 0, 1, 2, 5, 42, 46, },
	{ 2, 1, 2, 5, 42, 46, },
	{ 1, 1, 2, 5, 42, 46, },
	{ 0, 1, 2, 5, 58, 46, },
	{ 2, 1, 2, 5, 58, 46, },
	{ 1, 1, 2, 5, 58, 46, },
	{ 0, 1, 2, 5, 106, 46, },
	{ 2, 1, 2, 5, 106, 46, },
	{ 1, 1, 2, 5, 106, 46, },
	{ 0, 1, 2, 5, 122, 46, },
	{ 2, 1, 2, 5, 122, 46, },
	{ 1, 1, 2, 5, 122, 46, },
	{ 0, 1, 2, 5, 155, 46, },
	{ 2, 1, 2, 5, 155, 46, },
	{ 1, 1, 2, 5, 155, 63, },
	{ 0, 1, 2, 8, 42, 46, },
	{ 2, 1, 2, 8, 42, 46, },
	{ 1, 1, 2, 8, 42, 46, },
	{ 0, 1, 2, 8, 58, 46, },
	{ 2, 1, 2, 8, 58, 46, },
	{ 1, 1, 2, 8, 58, 46, },
	{ 0, 1, 2, 8, 106, 46, },
	{ 2, 1, 2, 8, 106, 46, },
	{ 1, 1, 2, 8, 106, 46, },
	{ 0, 1, 2, 8, 122, 46, },
	{ 2, 1, 2, 8, 122, 46, },
	{ 1, 1, 2, 8, 122, 46, },
	{ 0, 1, 2, 8, 155, 46, },
	{ 2, 1, 2, 8, 155, 46, },
	{ 1, 1, 2, 8, 155, 63, },
	{ 0, 1, 2, 9, 42, 46, },
	{ 2, 1, 2, 9, 42, 46, },
	{ 1, 1, 2, 9, 42, 46, },
	{ 0, 1, 2, 9, 58, 46, },
	{ 2, 1, 2, 9, 58, 46, },
	{ 1, 1, 2, 9, 58, 46, },
	{ 0, 1, 2, 9, 106, 46, },
	{ 2, 1, 2, 9, 106, 46, },
	{ 1, 1, 2, 9, 106, 46, },
	{ 0, 1, 2, 9, 122, 46, },
	{ 2, 1, 2, 9, 122, 46, },
	{ 1, 1, 2, 9, 122, 46, },
	{ 0, 1, 2, 9, 155, 46, },
	{ 2, 1, 2, 9, 155, 46, },
	{ 1, 1, 2, 9, 155, 63, },
};

RTW_DECL_TABLE_TXPWR_LMT(rtw8814a_txpwr_lmt_type8);

static const u8
rtw8814a_pwrtrk_5gd_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19},
	{0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10,
	 11, 12, 12, 13, 13, 14, 15, 15, 16, 17, 17, 18},
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 17, 18, 19},
};

static const u8
rtw8814a_pwrtrk_5gd_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
};

static const u8
rtw8814a_pwrtrk_5gc_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10,
	 11, 12, 13, 14, 15, 15, 15, 15, 16, 16, 17, 18},
	{0, 1, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11,
	 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19, 20},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11,
	 12, 13, 13, 14, 14, 15, 16, 17, 18, 18, 19, 20, 20},
};

static const u8
rtw8814a_pwrtrk_5gc_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	 16, 16, 17, 18, 19, 20, 21, 21, 22, 23, 24, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 17, 18, 19, 20, 21, 22, 23, 24, 24, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	 16, 16, 17, 18, 19, 20, 21, 22, 23, 23, 24, 25, 25},
};

static const u8
rtw8814a_pwrtrk_5gb_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17, 17},
	{0, 1, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11,
	 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19, 20},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11,
	 12, 13, 13, 14, 14, 15, 16, 17, 18, 18, 19, 20, 20},
};

static const u8
rtw8814a_pwrtrk_5gb_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14,
	 15, 15, 16, 17, 18, 18, 19, 20, 21, 22, 23, 23, 24},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	 16, 16, 17, 18, 19, 20, 20, 21, 22, 23, 24, 25, 25},
};

static const u8
rtw8814a_pwrtrk_5ga_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8,
	 8, 9, 9, 10, 11, 11, 11, 11, 12, 12, 13, 13, 14},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 11,
	 12, 13, 14, 14, 15, 16, 16, 17, 18, 19, 19, 20, 21},
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 17, 18, 19},
};

static const u8
rtw8814a_pwrtrk_5ga_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13,
	 14, 15, 16, 16, 17, 18, 19, 20, 21, 21, 22, 23, 24},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 19, 20, 21, 22, 23, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
};

static const u8 rtw8814a_pwrtrk_2gd_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7,
	 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12
};

static const u8 rtw8814a_pwrtrk_2gd_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13
};

static const u8 rtw8814a_pwrtrk_2gc_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12
};

static const u8 rtw8814a_pwrtrk_2gc_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13
};

static const u8 rtw8814a_pwrtrk_2gb_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 8, 8, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12
};

static const u8 rtw8814a_pwrtrk_2gb_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13
};

static const u8 rtw8814a_pwrtrk_2ga_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7,
	 7, 8, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12, 13
};

static const u8 rtw8814a_pwrtrk_2ga_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8,
	 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14
};

static const u8 rtw8814a_pwrtrk_2g_cck_d_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12
};

static const u8 rtw8814a_pwrtrk_2g_cck_d_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13
};

static const u8 rtw8814a_pwrtrk_2g_cck_c_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6,
	 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12
};

static const u8 rtw8814a_pwrtrk_2g_cck_c_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7,
	 7, 8, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12, 13
};

static const u8 rtw8814a_pwrtrk_2g_cck_b_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6,
	 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11
};

static const u8 rtw8814a_pwrtrk_2g_cck_b_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7,
	 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12
};

static const u8 rtw8814a_pwrtrk_2g_cck_a_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 8, 8, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12
};

static const u8 rtw8814a_pwrtrk_2g_cck_a_p[RTW_PWR_TRK_TBL_SZ] = {
	 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14
};

const struct rtw_pwr_track_tbl rtw8814a_rtw_pwrtrk_tbl = {
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_5gd_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_5gd_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_5gd_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_5gd_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_5gd_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_5gd_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_5gc_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_5gc_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_5gc_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_5gc_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_5gc_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_5gc_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_5gb_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_5gb_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_5gb_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_5gb_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_5gb_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_5gb_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_5ga_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_5ga_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_5ga_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_5ga_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_5ga_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_5ga_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_2gd_n = rtw8814a_pwrtrk_2gd_n,
	.pwrtrk_2gd_p = rtw8814a_pwrtrk_2gd_p,
	.pwrtrk_2gc_n = rtw8814a_pwrtrk_2gc_n,
	.pwrtrk_2gc_p = rtw8814a_pwrtrk_2gc_p,
	.pwrtrk_2gb_n = rtw8814a_pwrtrk_2gb_n,
	.pwrtrk_2gb_p = rtw8814a_pwrtrk_2gb_p,
	.pwrtrk_2ga_n = rtw8814a_pwrtrk_2ga_n,
	.pwrtrk_2ga_p = rtw8814a_pwrtrk_2ga_p,
	.pwrtrk_2g_cckd_n = rtw8814a_pwrtrk_2g_cck_d_n,
	.pwrtrk_2g_cckd_p = rtw8814a_pwrtrk_2g_cck_d_p,
	.pwrtrk_2g_cckc_n = rtw8814a_pwrtrk_2g_cck_c_n,
	.pwrtrk_2g_cckc_p = rtw8814a_pwrtrk_2g_cck_c_p,
	.pwrtrk_2g_cckb_n = rtw8814a_pwrtrk_2g_cck_b_n,
	.pwrtrk_2g_cckb_p = rtw8814a_pwrtrk_2g_cck_b_p,
	.pwrtrk_2g_ccka_n = rtw8814a_pwrtrk_2g_cck_a_n,
	.pwrtrk_2g_ccka_p = rtw8814a_pwrtrk_2g_cck_a_p,
};

static const u8
rtw8814a_pwrtrk_type0_5gd_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

static const u8
rtw8814a_pwrtrk_type0_5gd_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

static const u8
rtw8814a_pwrtrk_type0_5gc_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

static const u8
rtw8814a_pwrtrk_type0_5gc_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

static const u8
rtw8814a_pwrtrk_type0_5gb_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

static const u8
rtw8814a_pwrtrk_type0_5gb_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

static const u8
rtw8814a_pwrtrk_type0_5ga_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

static const u8
rtw8814a_pwrtrk_type0_5ga_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

static const u8 rtw8814a_pwrtrk_type0_2gd_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2gd_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2gc_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2gc_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2gb_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2gb_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2ga_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2ga_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2g_cck_d_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2g_cck_d_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2g_cck_c_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2g_cck_c_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2g_cck_b_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2g_cck_b_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2g_cck_a_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type0_2g_cck_a_p[RTW_PWR_TRK_TBL_SZ] = {
	 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

const struct rtw_pwr_track_tbl rtw8814a_rtw_pwrtrk_type0_tbl = {
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type0_5gd_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type0_5gd_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type0_5gd_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type0_5gd_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type0_5gd_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type0_5gd_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type0_5gc_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type0_5gc_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type0_5gc_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type0_5gc_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type0_5gc_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type0_5gc_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type0_5gb_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type0_5gb_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type0_5gb_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type0_5gb_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type0_5gb_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type0_5gb_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type0_5ga_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type0_5ga_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type0_5ga_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type0_5ga_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type0_5ga_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type0_5ga_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_2gd_n = rtw8814a_pwrtrk_type0_2gd_n,
	.pwrtrk_2gd_p = rtw8814a_pwrtrk_type0_2gd_p,
	.pwrtrk_2gc_n = rtw8814a_pwrtrk_type0_2gc_n,
	.pwrtrk_2gc_p = rtw8814a_pwrtrk_type0_2gc_p,
	.pwrtrk_2gb_n = rtw8814a_pwrtrk_type0_2gb_n,
	.pwrtrk_2gb_p = rtw8814a_pwrtrk_type0_2gb_p,
	.pwrtrk_2ga_n = rtw8814a_pwrtrk_type0_2ga_n,
	.pwrtrk_2ga_p = rtw8814a_pwrtrk_type0_2ga_p,
	.pwrtrk_2g_cckd_n = rtw8814a_pwrtrk_type0_2g_cck_d_n,
	.pwrtrk_2g_cckd_p = rtw8814a_pwrtrk_type0_2g_cck_d_p,
	.pwrtrk_2g_cckc_n = rtw8814a_pwrtrk_type0_2g_cck_c_n,
	.pwrtrk_2g_cckc_p = rtw8814a_pwrtrk_type0_2g_cck_c_p,
	.pwrtrk_2g_cckb_n = rtw8814a_pwrtrk_type0_2g_cck_b_n,
	.pwrtrk_2g_cckb_p = rtw8814a_pwrtrk_type0_2g_cck_b_p,
	.pwrtrk_2g_ccka_n = rtw8814a_pwrtrk_type0_2g_cck_a_n,
	.pwrtrk_2g_ccka_p = rtw8814a_pwrtrk_type0_2g_cck_a_p,
};

static const u8
rtw8814a_pwrtrk_type2_5gd_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 10, 10, 11, 11, 12, 12,
	 12, 13, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 4, 5, 5, 6, 6, 7, 8, 9, 9, 10, 10, 10, 10,
	 11, 11, 12, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 9, 10, 10, 11, 11, 11, 12,
	 12, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15},
};

static const u8
rtw8814a_pwrtrk_type2_5gd_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14,
	 15, 16, 17, 18, 19, 20, 21, 22, 22, 22, 22, 22, 22},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 13, 14,
	 15, 16, 17, 18, 19, 20, 21, 22, 22, 22, 22, 22, 22},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 19, 20, 21, 22, 23, 23, 23, 23, 23, 23, 23},
};

static const u8
rtw8814a_pwrtrk_type2_5gc_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 7, 7, 8, 9, 10, 10, 11, 11, 12,
	 12, 13, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 10, 11, 11, 12,
	 13, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11, 11,
	 12, 12, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14},
};

static const u8
rtw8814a_pwrtrk_type2_5gc_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14,
	 15, 16, 17, 18, 19, 20, 21, 21, 21, 21, 21, 21, 21},
	{0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14,
	 15, 16, 17, 18, 19, 20, 20, 20, 21, 21, 21, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 13, 14,
	 15, 16, 17, 18, 19, 20, 21, 21, 21, 21, 21, 21, 21},
};

static const u8
rtw8814a_pwrtrk_type2_5gb_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 10, 11, 12, 13,
	 13, 13, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 10, 11, 11, 12,
	 13, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11, 11,
	 12, 12, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14},
};

static const u8
rtw8814a_pwrtrk_type2_5gb_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 15,
	 16, 17, 18, 19, 20, 21, 21, 21, 21, 21, 21, 21, 21},
	{0, 0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 14, 15, 16, 17, 18, 19, 20, 20, 20, 20, 20, 20, 20},
	{0, 1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14,
	 15, 16, 17, 18, 19, 20, 21, 21, 21, 21, 21, 21, 21},
};

static const u8
rtw8814a_pwrtrk_type2_5ga_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 10, 10, 11, 11, 11,
	 12, 13, 13, 13, 13, 14, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 10, 11, 12, 12,
	 12, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 11, 11, 12,
	 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13},
};

static const u8
rtw8814a_pwrtrk_type2_5ga_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14,
	 15, 15, 16, 17, 18, 18, 19, 19, 20, 20, 20, 20, 20},
	{0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14,
	 15, 16, 16, 17, 18, 19, 20, 20, 20, 20, 20, 20, 20},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 15,
	 15, 16, 17, 18, 19, 19, 20, 20, 20, 20, 20, 20, 20},
};

static const u8 rtw8814a_pwrtrk_type2_2gd_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 7, 8, 9, 10, 11, 11, 11, 11, 11, 11, 11
};

static const u8 rtw8814a_pwrtrk_type2_2gd_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 12, 12, 13, 14, 14, 14, 14, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type2_2gc_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10,
	 10, 11, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type2_2gc_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 3, 3, 4, 4, 4, 5, 5, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type2_2gb_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type2_2gb_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10,
	 10, 11, 12, 12, 13, 13, 13, 13, 13, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type2_2ga_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 2, 2, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 9,
	 10, 11, 11, 12, 12, 13, 13, 13, 13, 13, 13, 13
};

static const u8 rtw8814a_pwrtrk_type2_2ga_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 3, 3, 4, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type2_2g_cck_d_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 8,
	 9, 9, 9, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12
};

static const u8 rtw8814a_pwrtrk_type2_2g_cck_d_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 1, 2, 3, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 10, 11, 12, 12, 13, 14, 14, 14, 14, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type2_2g_cck_c_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 6, 6, 7, 8, 9, 9, 10,
	 10, 11, 11, 11, 12, 13, 13, 13, 13, 13, 13, 13
};

static const u8 rtw8814a_pwrtrk_type2_2g_cck_c_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13
};

static const u8 rtw8814a_pwrtrk_type2_2g_cck_b_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10,
	 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12
};

static const u8 rtw8814a_pwrtrk_type2_2g_cck_b_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 9, 9, 10,
	 10, 11, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13
};

static const u8 rtw8814a_pwrtrk_type2_2g_cck_a_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 2, 2, 3, 4, 4, 4, 5, 5, 6, 6, 7, 8, 9, 9, 9, 9,
	 10, 10, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12
};

static const u8 rtw8814a_pwrtrk_type2_2g_cck_a_p[RTW_PWR_TRK_TBL_SZ] = {
	 0, 0, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13
};

const struct rtw_pwr_track_tbl rtw8814a_rtw_pwrtrk_type2_tbl = {
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type2_5gd_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type2_5gd_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type2_5gd_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type2_5gd_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type2_5gd_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type2_5gd_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type2_5gc_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type2_5gc_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type2_5gc_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type2_5gc_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type2_5gc_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type2_5gc_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type2_5gb_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type2_5gb_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type2_5gb_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type2_5gb_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type2_5gb_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type2_5gb_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type2_5ga_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type2_5ga_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type2_5ga_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type2_5ga_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type2_5ga_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type2_5ga_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_2gd_n = rtw8814a_pwrtrk_type2_2gd_n,
	.pwrtrk_2gd_p = rtw8814a_pwrtrk_type2_2gd_p,
	.pwrtrk_2gc_n = rtw8814a_pwrtrk_type2_2gc_n,
	.pwrtrk_2gc_p = rtw8814a_pwrtrk_type2_2gc_p,
	.pwrtrk_2gb_n = rtw8814a_pwrtrk_type2_2gb_n,
	.pwrtrk_2gb_p = rtw8814a_pwrtrk_type2_2gb_p,
	.pwrtrk_2ga_n = rtw8814a_pwrtrk_type2_2ga_n,
	.pwrtrk_2ga_p = rtw8814a_pwrtrk_type2_2ga_p,
	.pwrtrk_2g_cckd_n = rtw8814a_pwrtrk_type2_2g_cck_d_n,
	.pwrtrk_2g_cckd_p = rtw8814a_pwrtrk_type2_2g_cck_d_p,
	.pwrtrk_2g_cckc_n = rtw8814a_pwrtrk_type2_2g_cck_c_n,
	.pwrtrk_2g_cckc_p = rtw8814a_pwrtrk_type2_2g_cck_c_p,
	.pwrtrk_2g_cckb_n = rtw8814a_pwrtrk_type2_2g_cck_b_n,
	.pwrtrk_2g_cckb_p = rtw8814a_pwrtrk_type2_2g_cck_b_p,
	.pwrtrk_2g_ccka_n = rtw8814a_pwrtrk_type2_2g_cck_a_n,
	.pwrtrk_2g_ccka_p = rtw8814a_pwrtrk_type2_2g_cck_a_p,
};

static const u8
rtw8814a_pwrtrk_type5_5gd_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 3, 3, 3, 4, 6, 6, 7, 7, 8, 9, 10, 11, 12, 13, 13, 14,
	 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 4, 5, 6, 7, 7, 8, 7, 8, 10, 11, 12, 12, 13, 13, 14, 14,
	 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 13, 14, 15, 15, 16,
	 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16},
};

static const u8
rtw8814a_pwrtrk_type5_5gd_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 9, 10, 10, 11, 12,
	 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13},
	{0, 0, 0, 1, 1, 1, 2, 3, 4, 5, 6, 7, 8, 8, 9, 11, 12,
	 12, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 0, 0, 1, 1, 2, 2, 3, 5, 7, 8, 9, 10, 11, 12, 13, 13,
	 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14},
};

static const u8
rtw8814a_pwrtrk_type5_5gc_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 3, 3, 4, 6, 7, 7, 8, 9, 9, 9, 10, 10, 10,
	 10, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 3, 3, 7, 7, 8, 8, 9, 11, 12, 12, 13, 14, 14, 15,
	 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 0, 1, 2, 3, 4, 5, 7, 8, 8, 10, 11, 12, 12, 13, 13, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
};

static const u8
rtw8814a_pwrtrk_type5_5gc_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 0, 1, 1, 2, 2, 3, 4, 5, 6, 6, 7, 8, 9, 11, 11,
	 11, 11, 11, 11, 12, 12, 12, 12, 12, 13, 13, 13, 13},
	{0, 0, 1, 2, 3, 3, 5, 5, 6, 8, 8, 9, 10, 11, 13, 13, 13,
	 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14},
	{0, 0, 1, 2, 3, 4, 4, 5, 7, 8, 9, 9, 10, 11, 12, 12, 12,
	 12, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14},
};

static const u8
rtw8814a_pwrtrk_type5_5gb_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 2, 2, 3, 4, 5, 6, 7, 9, 10, 10, 10, 10, 10,
	 10, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 3, 3, 7, 7, 8, 8, 9, 11, 12, 12, 13, 14, 14, 15,
	 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 0, 1, 2, 3, 4, 5, 7, 8, 8, 10, 11, 12, 12, 13, 13, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
};

static const u8
rtw8814a_pwrtrk_type5_5gb_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 1, 2, 2, 4, 5, 6, 6, 7, 8, 9, 10, 11, 11, 11,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 0, 2, 3, 4, 5, 6, 8, 8, 9, 9, 11, 12, 13, 13, 13,
	 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
	{0, 0, 0, 1, 2, 3, 3, 4, 6, 7, 8, 9, 10, 11, 12, 12, 12,
	 12, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14},
};

static const u8
rtw8814a_pwrtrk_type5_5ga_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 0, 1, 2, 3, 3, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 10, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12},
	{0, 2, 3, 4, 5, 7, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 17,
	 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18},
	{0, 1, 2, 3, 3, 4, 6, 7, 8, 8, 10, 11, 11, 12, 13, 13, 13,
	 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14},
};

static const u8
rtw8814a_pwrtrk_type5_5ga_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 3, 3, 3, 5, 5, 6, 6, 8, 8, 9, 10, 11, 11, 11,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 8, 9, 11, 12, 13, 14, 15,
	 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 0, 1, 3, 3, 4, 5, 5, 6, 7, 7, 8, 10, 10, 11, 11, 11,
	 11, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13},
};

static const u8 rtw8814a_pwrtrk_type5_2gd_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 7, 8, 9, 9, 9,
	 9, 9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11
};

static const u8 rtw8814a_pwrtrk_type5_2gd_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10
};

static const u8 rtw8814a_pwrtrk_type5_2gc_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 10,
	 10, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12
};

static const u8 rtw8814a_pwrtrk_type5_2gc_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 8, 8, 9, 9, 9,
	 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11
};

static const u8 rtw8814a_pwrtrk_type5_2gb_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 10, 10, 10,
	 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12
};

static const u8 rtw8814a_pwrtrk_type5_2gb_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 8, 9, 9, 9, 9,
	 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11
};

static const u8 rtw8814a_pwrtrk_type5_2ga_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 10,
	 10, 11, 11, 11, 11, 111, 12, 12, 12, 12, 12, 12, 12
};

static const u8 rtw8814a_pwrtrk_type5_2ga_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 7, 8, 8, 9, 9, 9,
	 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11
};

static const u8 rtw8814a_pwrtrk_type5_2g_cck_d_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 7, 8, 8, 8, 9, 9, 9, 9,
	 10, 10, 10, 10, 10, 11, 11, 10, 11, 11, 11, 11
};

static const u8 rtw8814a_pwrtrk_type5_2g_cck_d_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 8,
	 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10
};

static const u8 rtw8814a_pwrtrk_type5_2g_cck_c_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 8, 8, 9, 10, 10, 10,
	 10, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12
};

static const u8 rtw8814a_pwrtrk_type5_2g_cck_c_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 8,
	 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10
};

static const u8 rtw8814a_pwrtrk_type5_2g_cck_b_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 2, 3, 4, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10, 10, 10,
	 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11
};

static const u8 rtw8814a_pwrtrk_type5_2g_cck_b_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 8,
	 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10
};

static const u8 rtw8814a_pwrtrk_type5_2g_cck_a_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 9, 9, 10,
	 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10
};

static const u8 rtw8814a_pwrtrk_type5_2g_cck_a_p[RTW_PWR_TRK_TBL_SZ] = {
	 0, 1, 1, 2, 2, 2, 3, 4, 4, 5, 6, 7, 8, 8, 9, 9, 9,
	 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10
};

const struct rtw_pwr_track_tbl rtw8814a_rtw_pwrtrk_type5_tbl = {
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type5_5gd_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type5_5gd_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type5_5gd_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type5_5gd_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type5_5gd_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type5_5gd_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type5_5gc_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type5_5gc_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type5_5gc_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type5_5gc_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type5_5gc_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type5_5gc_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type5_5gb_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type5_5gb_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type5_5gb_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type5_5gb_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type5_5gb_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type5_5gb_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type5_5ga_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type5_5ga_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type5_5ga_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type5_5ga_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type5_5ga_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type5_5ga_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_2gd_n = rtw8814a_pwrtrk_type5_2gd_n,
	.pwrtrk_2gd_p = rtw8814a_pwrtrk_type5_2gd_p,
	.pwrtrk_2gc_n = rtw8814a_pwrtrk_type5_2gc_n,
	.pwrtrk_2gc_p = rtw8814a_pwrtrk_type5_2gc_p,
	.pwrtrk_2gb_n = rtw8814a_pwrtrk_type5_2gb_n,
	.pwrtrk_2gb_p = rtw8814a_pwrtrk_type5_2gb_p,
	.pwrtrk_2ga_n = rtw8814a_pwrtrk_type5_2ga_n,
	.pwrtrk_2ga_p = rtw8814a_pwrtrk_type5_2ga_p,
	.pwrtrk_2g_cckd_n = rtw8814a_pwrtrk_type5_2g_cck_d_n,
	.pwrtrk_2g_cckd_p = rtw8814a_pwrtrk_type5_2g_cck_d_p,
	.pwrtrk_2g_cckc_n = rtw8814a_pwrtrk_type5_2g_cck_c_n,
	.pwrtrk_2g_cckc_p = rtw8814a_pwrtrk_type5_2g_cck_c_p,
	.pwrtrk_2g_cckb_n = rtw8814a_pwrtrk_type5_2g_cck_b_n,
	.pwrtrk_2g_cckb_p = rtw8814a_pwrtrk_type5_2g_cck_b_p,
	.pwrtrk_2g_ccka_n = rtw8814a_pwrtrk_type5_2g_cck_a_n,
	.pwrtrk_2g_ccka_p = rtw8814a_pwrtrk_type5_2g_cck_a_p,
};

static const u8
rtw8814a_pwrtrk_type7_5gd_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

static const u8
rtw8814a_pwrtrk_type7_5gd_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

static const u8
rtw8814a_pwrtrk_type7_5gc_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

static const u8
rtw8814a_pwrtrk_type7_5gc_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

static const u8
rtw8814a_pwrtrk_type7_5gb_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

static const u8
rtw8814a_pwrtrk_type7_5gb_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

static const u8
rtw8814a_pwrtrk_type7_5ga_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

static const u8
rtw8814a_pwrtrk_type7_5ga_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

static const u8 rtw8814a_pwrtrk_type7_2gd_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2gd_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2gc_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2gc_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2gb_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2gb_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2ga_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2ga_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2g_cck_d_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2g_cck_d_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2g_cck_c_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2g_cck_c_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2g_cck_b_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2g_cck_b_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2g_cck_a_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7,
	 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

static const u8 rtw8814a_pwrtrk_type7_2g_cck_a_p[RTW_PWR_TRK_TBL_SZ] = {
	 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
};

const struct rtw_pwr_track_tbl rtw8814a_rtw_pwrtrk_type7_tbl = {
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type7_5gd_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type7_5gd_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type7_5gd_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type7_5gd_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type7_5gd_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type7_5gd_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type7_5gc_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type7_5gc_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type7_5gc_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type7_5gc_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type7_5gc_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type7_5gc_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type7_5gb_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type7_5gb_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type7_5gb_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type7_5gb_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type7_5gb_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type7_5gb_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type7_5ga_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type7_5ga_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type7_5ga_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type7_5ga_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type7_5ga_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type7_5ga_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_2gd_n = rtw8814a_pwrtrk_type7_2gd_n,
	.pwrtrk_2gd_p = rtw8814a_pwrtrk_type7_2gd_p,
	.pwrtrk_2gc_n = rtw8814a_pwrtrk_type7_2gc_n,
	.pwrtrk_2gc_p = rtw8814a_pwrtrk_type7_2gc_p,
	.pwrtrk_2gb_n = rtw8814a_pwrtrk_type7_2gb_n,
	.pwrtrk_2gb_p = rtw8814a_pwrtrk_type7_2gb_p,
	.pwrtrk_2ga_n = rtw8814a_pwrtrk_type7_2ga_n,
	.pwrtrk_2ga_p = rtw8814a_pwrtrk_type7_2ga_p,
	.pwrtrk_2g_cckd_n = rtw8814a_pwrtrk_type7_2g_cck_d_n,
	.pwrtrk_2g_cckd_p = rtw8814a_pwrtrk_type7_2g_cck_d_p,
	.pwrtrk_2g_cckc_n = rtw8814a_pwrtrk_type7_2g_cck_c_n,
	.pwrtrk_2g_cckc_p = rtw8814a_pwrtrk_type7_2g_cck_c_p,
	.pwrtrk_2g_cckb_n = rtw8814a_pwrtrk_type7_2g_cck_b_n,
	.pwrtrk_2g_cckb_p = rtw8814a_pwrtrk_type7_2g_cck_b_p,
	.pwrtrk_2g_ccka_n = rtw8814a_pwrtrk_type7_2g_cck_a_n,
	.pwrtrk_2g_ccka_p = rtw8814a_pwrtrk_type7_2g_cck_a_p,
};

static const u8
rtw8814a_pwrtrk_type8_5gd_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 3, 4, 4, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13},
	{0, 1, 2, 3, 4, 4, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12,
	 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13},
	{0, 1, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8, 8, 9, 10, 10,
	 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11},
};

static const u8
rtw8814a_pwrtrk_type8_5gd_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 14,
	 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 0, 1, 2, 3, 5, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
	{0, 0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
};

static const u8
rtw8814a_pwrtrk_type8_5gc_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 4, 4, 5, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12,
	 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13},
	{0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 10, 10, 11, 11,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11,
	 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

static const u8
rtw8814a_pwrtrk_type8_5gc_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 13, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
	{0, 0, 1, 3, 4, 4, 5, 6, 7, 7, 8, 10, 11, 12, 13, 14,
	 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 0, 1, 2, 4, 5, 5, 6, 6, 7, 7, 9, 10, 11, 12, 13, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
};

static const u8
rtw8814a_pwrtrk_type8_5gb_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 10, 10, 11, 11,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11,
	 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

static const u8
rtw8814a_pwrtrk_type8_5gb_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
	{0, 0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 10, 11, 11, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
	{0, 0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 10, 10, 11, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
};

static const u8
rtw8814a_pwrtrk_type8_5ga_n[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11, 11,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 10, 10, 11, 11,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 10, 10, 11, 12,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13},
};

static const u8
rtw8814a_pwrtrk_type8_5ga_p[RTW_PWR_TRK_5G_NUM][RTW_PWR_TRK_TBL_SZ] = {
	{0, 0, 1, 2, 3, 3, 4, 5, 6, 7, 7, 9, 10, 11, 12, 13, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
	{0, 0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
	{0, 0, 1, 2, 3, 3, 4, 4, 6, 7, 7, 9, 10, 11, 12, 13, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
};

static const u8 rtw8814a_pwrtrk_type8_2gd_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 7, 8, 9, 10, 11, 11, 11, 11, 11, 11, 11
};

static const u8 rtw8814a_pwrtrk_type8_2gd_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 12, 12, 13, 14, 14, 14, 14, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type8_2gc_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10,
	 10, 11, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type8_2gc_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 3, 3, 4, 4, 4, 5, 5, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type8_2gb_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type8_2gb_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10,
	 10, 11, 12, 12, 13, 13, 13, 13, 13, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type8_2ga_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 2, 2, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 9,
	 10, 11, 11, 12, 12, 13, 13, 13, 13, 13, 13, 13
};

static const u8 rtw8814a_pwrtrk_type8_2ga_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 3, 3, 4, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type8_2g_cck_d_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 8,
	 9, 9, 9, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12
};

static const u8 rtw8814a_pwrtrk_type8_2g_cck_d_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 1, 2, 3, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 10, 11, 12, 12, 13, 14, 14, 14, 14, 14, 14, 14
};

static const u8 rtw8814a_pwrtrk_type8_2g_cck_c_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 6, 6, 7, 8, 9, 9, 10,
	 10, 11, 11, 11, 12, 13, 13, 13, 13, 13, 13, 13
};

static const u8 rtw8814a_pwrtrk_type8_2g_cck_c_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13
};

static const u8 rtw8814a_pwrtrk_type8_2g_cck_b_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 2, 2, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10,
	 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12
};

static const u8 rtw8814a_pwrtrk_type8_2g_cck_b_p[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 9, 9, 10,
	 10, 11, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13
};

static const u8 rtw8814a_pwrtrk_type8_2g_cck_a_n[RTW_PWR_TRK_TBL_SZ] = {
	0, 1, 2, 2, 3, 4, 4, 4, 5, 5, 6, 6, 7, 8, 9, 9, 9, 9,
	 10, 10, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12
};

static const u8 rtw8814a_pwrtrk_type8_2g_cck_a_p[RTW_PWR_TRK_TBL_SZ] = {
	 0, 0, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13
};

const struct rtw_pwr_track_tbl rtw8814a_rtw_pwrtrk_type8_tbl = {
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type8_5gd_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type8_5gd_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gd_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type8_5gd_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type8_5gd_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type8_5gd_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gd_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type8_5gd_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type8_5gc_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type8_5gc_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gc_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type8_5gc_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type8_5gc_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type8_5gc_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gc_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type8_5gc_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type8_5gb_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type8_5gb_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gb_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type8_5gb_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type8_5gb_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type8_5gb_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5gb_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type8_5gb_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type8_5ga_n[RTW_PWR_TRK_5G_1],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type8_5ga_n[RTW_PWR_TRK_5G_2],
	.pwrtrk_5ga_n[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type8_5ga_n[RTW_PWR_TRK_5G_3],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_1] = rtw8814a_pwrtrk_type8_5ga_p[RTW_PWR_TRK_5G_1],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_2] = rtw8814a_pwrtrk_type8_5ga_p[RTW_PWR_TRK_5G_2],
	.pwrtrk_5ga_p[RTW_PWR_TRK_5G_3] = rtw8814a_pwrtrk_type8_5ga_p[RTW_PWR_TRK_5G_3],
	.pwrtrk_2gd_n = rtw8814a_pwrtrk_type8_2gd_n,
	.pwrtrk_2gd_p = rtw8814a_pwrtrk_type8_2gd_p,
	.pwrtrk_2gc_n = rtw8814a_pwrtrk_type8_2gc_n,
	.pwrtrk_2gc_p = rtw8814a_pwrtrk_type8_2gc_p,
	.pwrtrk_2gb_n = rtw8814a_pwrtrk_type8_2gb_n,
	.pwrtrk_2gb_p = rtw8814a_pwrtrk_type8_2gb_p,
	.pwrtrk_2ga_n = rtw8814a_pwrtrk_type8_2ga_n,
	.pwrtrk_2ga_p = rtw8814a_pwrtrk_type8_2ga_p,
	.pwrtrk_2g_cckd_n = rtw8814a_pwrtrk_type8_2g_cck_d_n,
	.pwrtrk_2g_cckd_p = rtw8814a_pwrtrk_type8_2g_cck_d_p,
	.pwrtrk_2g_cckc_n = rtw8814a_pwrtrk_type8_2g_cck_c_n,
	.pwrtrk_2g_cckc_p = rtw8814a_pwrtrk_type8_2g_cck_c_p,
	.pwrtrk_2g_cckb_n = rtw8814a_pwrtrk_type8_2g_cck_b_n,
	.pwrtrk_2g_cckb_p = rtw8814a_pwrtrk_type8_2g_cck_b_p,
	.pwrtrk_2g_ccka_n = rtw8814a_pwrtrk_type8_2g_cck_a_n,
	.pwrtrk_2g_ccka_p = rtw8814a_pwrtrk_type8_2g_cck_a_p,
};

static const struct rtw_pwr_seq_cmd init_power_on_8814a[] = {
	{0x10c2,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

static const struct rtw_pwr_seq_cmd trans_carddis_to_cardemu_8814a[] = {
	{0x0012,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(6), BIT(6)},
	{0x0015,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(5), 0},
	{0x0015,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(6), 0},
	{0x0023,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(4), 0},
	{0x0046,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x00},
	{0x0062,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x00},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(2), 0},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(3), 0},
	{0x0301,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0},
	{0x0071,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(2), 0},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

static const struct rtw_pwr_seq_cmd trans_cardemu_to_act_8814a[] = {
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(2), 0},
	{0x0006,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, BIT(1), BIT(1)},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(3), 0},
	{0x00F0,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(7), 0},
	{0x0081,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0x30, 0x20},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, BIT(0), 0},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

static const struct rtw_pwr_seq_cmd trans_act_to_cardemu_8814a[] = {
	{0x0c00,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x04},
	{0x0e00,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x04},
	{0x1002,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), 0},
	{0x0002,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_DELAY, 1, RTW_PWR_DELAY_US},
	{0x1002,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x001F,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0},
	{0x0007,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x28},
	{0x0008,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0x02, 0},
	{0x0066,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(7), 0},
	{0x0041,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(4), 0},
	{0x0042,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x004e,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(5), BIT(5)},
	{0x0041,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), 0},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, BIT(1), 0},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

static const struct rtw_pwr_seq_cmd trans_cardemu_to_carddis_8814a[] = {
	{0x0003,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(2), 0},
	{0x0080,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x01},
	{0x0081,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x30},
	{0x0045,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x00},
	{0x0046,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0xff},
	{0x0047,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0},
	{0x0015,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(6), BIT(6)},
	{0x0015,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(5), BIT(5)},
	{0x0012,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(6), 0},
	{0x0023,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(4), BIT(4)},
	{0x0008,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0007,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x001f,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0020,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0021,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0076,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0091,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xA0, 0xA0},
	{0x0070,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(3), BIT(3)},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(3), BIT(3)},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

const struct rtw_pwr_seq_cmd * const card_enable_flow_8814a[] = {
	init_power_on_8814a,
	trans_carddis_to_cardemu_8814a,
	trans_cardemu_to_act_8814a,
	NULL
};

const struct rtw_pwr_seq_cmd * const card_disable_flow_8814a[] = {
	trans_act_to_cardemu_8814a,
	trans_cardemu_to_carddis_8814a,
	NULL
};
