/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bookmarks.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DynamicListWizard;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bookmarks.Bookmark;
import com.arsdigita.bookmarks.BookmarkApplication;
import com.arsdigita.bookmarks.BookmarkCollection;
import com.arsdigita.bookmarks.util.GlobalizationUtil;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import java.util.TooManyListenersException;
import javax.servlet.http.HttpServletRequest;

public class BookmarkEditPane
extends DynamicListWizard {
    final ModalContainer m_editContainer = new ModalContainer();
    SimpleContainer m_mainDisplay;
    EditBookmarkForm m_editBmrkForm;
    DeleteForm m_deleteForm;
    RequestLocal m_prtlRL;

    public BookmarkEditPane() {
        super("Current Bookmarks", new ListModelBuilder(){

            public ListModel makeModel(List l, PageState ps) {
                return new BmrkListModel(ps);
            }

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }
        }, "Add a new Bookmark", (Component)new Label(GlobalizationUtil.globalize("bookmarks.ui.select_a_bookmark_for_editing")));
        final BookmarkEditPane dlw = this;
        this.m_prtlRL = new RequestLocal(){

            protected Object initialValue(PageState ps) {
                return (BookmarkApplication)Application.getCurrentApplication((HttpServletRequest)ps.getRequest());
            }
        };
        Form addForm = new Form("addBookmark", (Container)new GridPanel(2));
        addForm.add((Component)new Label(GlobalizationUtil.globalize("bookmarks.ui.name_of_new_bookmark")));
        final TextField newBmrkName = new TextField("name");
        newBmrkName.getParameterModel().addParameterListener((ParameterListener)new NotNullValidationListener("Choose a name for the new Bookmark"));
        addForm.add((Component)newBmrkName);
        addForm.add((Component)new Label(GlobalizationUtil.globalize("bookmarks.ui.new_bookmark_url")));
        final TextField newBmrkURL = new TextField("url");
        newBmrkURL.getParameterModel().addParameterListener((ParameterListener)new NotEmptyValidationListener("White space is not allowed in URLs"));
        addForm.add((Component)newBmrkURL);
        addForm.add((Component)new Label(GlobalizationUtil.globalize("bookmarks.ui.bookmark_description")));
        final TextArea bmrkDesc = new TextArea("BmrkDesc");
        bmrkDesc.getParameterModel().addParameterListener((ParameterListener)new NotNullValidationListener("Enter a description for the new Bookmark"));
        addForm.add((Component)bmrkDesc);
        addForm.add((Component)new Submit("Create Bookmark"));
        addForm.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                BookmarkApplication ba = (BookmarkApplication)((Object)BookmarkEditPane.this.m_prtlRL.get(ps));
                Bookmark newBmrk = new Bookmark(newBmrkName.getValue(ps).toString(), newBmrkURL.getValue(ps).toString());
                newBmrk.setDescription(bmrkDesc.getValue(ps).toString());
                newBmrk.setBookmarkApplication(ba);
                newBmrk.save();
                dlw.getList().getSelectionModel().setSelectedKey(ps, (Object)newBmrk.getID().toString());
            }
        });
        this.setAddPane((Component)addForm);
        this.m_mainDisplay = new BoxPanel(2);
        this.m_editBmrkForm = new EditBookmarkForm(new GridPanel(2));
        this.m_mainDisplay.add((Component)this.m_editBmrkForm);
        ActionLink deleteLink = new ActionLink((String)GlobalizationUtil.globalize("bookmarks.ui.delete_this_bookmark").localize());
        deleteLink.setClassAttr("actionLink");
        deleteLink.addActionListener((ActionListener)new DeleteLinkListener());
        this.m_mainDisplay.add((Component)deleteLink);
        this.m_deleteForm = new DeleteForm();
        this.m_editContainer.add((Component)this.m_mainDisplay);
        this.m_editContainer.add((Component)this.m_deleteForm);
        this.setEditPane((Component)this.m_editContainer);
        this.getList().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                ev.getPageState().reset((Component)BookmarkEditPane.this.m_editContainer);
            }
        });
    }

    private class DeleteLinkListener
    implements ActionListener {
        private DeleteLinkListener() {
        }

        public void actionPerformed(ActionEvent event) {
            PageState ps = event.getPageState();
            BookmarkEditPane.this.m_editContainer.setVisibleComponent(ps, (Component)BookmarkEditPane.this.m_deleteForm);
        }
    }

    public class DeleteForm
    extends Form
    implements FormProcessListener {
        private TextField currenttabName;
        private Label instruction = new Label(GlobalizationUtil.globalize("bookmarks.ui.are_you_sure_you_want_to_delete_this_bookmark"));
        private Submit button;
        private Submit cancelbutton;

        public DeleteForm() {
            super("deletetabform");
            this.instruction.addPrintListener(new PrintListener(this){
                private final /* synthetic */ DeleteForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    String prefixstr = "Are you sure you want to delete the ";
                    BigDecimal bmrkID = new BigDecimal((String)DeleteForm.access$200(this.this$1).getSelectionModel().getSelectedKey(s));
                    Bookmark bmrk = Bookmark.retrieveBookmark(bmrkID);
                    Label t = (Label)e.getTarget();
                    t.setLabel(prefixstr + bmrk.getName() + " Bookmark?");
                }
            });
            this.button = new Submit("Delete this Bookmark");
            this.button.setButtonLabel("Delete this Bookmark");
            this.cancelbutton = new Submit("Cancel");
            this.cancelbutton.setButtonLabel("Cancel");
            Label spacer = new Label(" ");
            this.add((Component)this.instruction);
            this.add((Component)spacer);
            this.add((Component)this.button);
            this.add((Component)this.cancelbutton);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            if (this.button.isSelected(s)) {
                BigDecimal bmrkID = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
                Bookmark bmrk = Bookmark.retrieveBookmark(bmrkID);
                BookmarkApplication bmrkapp = (BookmarkApplication)Application.getCurrentApplication((HttpServletRequest)s.getRequest());
                KernelExcursion ex = new KernelExcursion(this, bmrkapp, bmrk){
                    private final /* synthetic */ BookmarkApplication val$bmrkapp;
                    private final /* synthetic */ Bookmark val$bmrk;
                    private final /* synthetic */ DeleteForm this$1;
                    {
                        this.this$1 = this$1;
                        this.val$bmrkapp = val$bmrkapp;
                        this.val$bmrk = val$bmrk;
                    }

                    protected void excurse() {
                        this.setEffectiveParty(Kernel.getSystemParty());
                        this.val$bmrkapp.removeBookmark(this.val$bmrk);
                    }
                };
                ex.run();
                BookmarkEditPane.this.getSelectionModel().clearSelection(s);
                BookmarkEditPane.this.reset(s);
            }
            s.reset((Component)BookmarkEditPane.this.m_editContainer);
        }

        static /* synthetic */ BookmarkEditPane access$200(DeleteForm x0) {
            return x0.BookmarkEditPane.this;
        }
    }

    public class EditBookmarkForm
    extends Form
    implements FormProcessListener,
    FormInitListener {
        private TextField bookmarkName;
        private TextField bookmarkURL;
        private TextArea bookmarkDescription;
        private Label instruction = new Label(GlobalizationUtil.globalize("bookmarks.ui.edit_fields_and_click_save_button"));
        private Label blank = new Label(" ");
        private Label instruction1 = new Label(GlobalizationUtil.globalize("bookmarks.ui.bookmark_name"));
        private Label instruction2 = new Label(GlobalizationUtil.globalize("bookmarks.ui.bookmark_url"));
        private Label instruction3 = new Label(GlobalizationUtil.globalize("bookmarks.ui.bookmark_description"));
        private Label creationDateLabel;
        private Label creationDate;
        private Label modDateLabel;
        private Label modDate;
        private Label authorLabel;
        private Label author;
        private Label visitsLabel;
        private Label visits;
        private Label blank1 = new Label("");
        private Label blank2 = new Label("");
        private Label blank3 = new Label("");
        private Label blank4 = new Label("");
        private Submit button;

        public EditBookmarkForm(GridPanel gp) {
            super("editbookmarkform", (Container)gp);
            this.creationDateLabel = new Label(GlobalizationUtil.globalize("bookmarks.ui.creation_date"));
            this.modDateLabel = new Label(GlobalizationUtil.globalize("bookmarks.ui.last_modified_date"));
            this.authorLabel = new Label(GlobalizationUtil.globalize("bookmarks.ui.created_by"));
            this.visitsLabel = new Label(GlobalizationUtil.globalize("bookmarks.ui.number_of_visits"));
            this.bookmarkName = new TextField("BookmarkName");
            this.bookmarkName.setDefaultValue((Object)"");
            this.bookmarkName.addValidationListener((ParameterListener)new NotNullValidationListener("Every Bookmark must have a name!"));
            try {
                this.bookmarkName.addPrintListener(new PrintListener(this){
                    private final /* synthetic */ EditBookmarkForm this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void prepare(PrintEvent e) {
                        PageState s = e.getPageState();
                        if (EditBookmarkForm.access$100(this.this$1).getSelectionModel().isSelected(s)) {
                            BigDecimal bd = new BigDecimal((String)EditBookmarkForm.access$100(this.this$1).getSelectionModel().getSelectedKey(s));
                            Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                            TextField tf = (TextField)e.getTarget();
                            tf.setValue(s, (Object)bmrk.getName());
                        }
                    }
                });
            }
            catch (TooManyListenersException e) {
                // empty catch block
            }
            this.bookmarkURL = new TextField("BookmarkURL");
            this.bookmarkURL.setDefaultValue((Object)"");
            this.bookmarkURL.addValidationListener((ParameterListener)new NotEmptyValidationListener("White space is not allowed in URLs!"));
            try {
                this.bookmarkURL.addPrintListener(new PrintListener(this){
                    private final /* synthetic */ EditBookmarkForm this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void prepare(PrintEvent e) {
                        PageState s = e.getPageState();
                        if (EditBookmarkForm.access$100(this.this$1).getSelectionModel().isSelected(s)) {
                            BigDecimal bd = new BigDecimal((String)EditBookmarkForm.access$100(this.this$1).getSelectionModel().getSelectedKey(s));
                            Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                            TextField tf = (TextField)e.getTarget();
                            tf.setValue(s, (Object)bmrk.getURL());
                        }
                    }
                });
            }
            catch (TooManyListenersException e) {
                // empty catch block
            }
            this.bookmarkDescription = new TextArea("Description");
            this.bookmarkDescription.setDefaultValue((Object)"");
            try {
                this.bookmarkDescription.addPrintListener(new PrintListener(this){
                    private final /* synthetic */ EditBookmarkForm this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void prepare(PrintEvent e) {
                        PageState s = e.getPageState();
                        if (EditBookmarkForm.access$100(this.this$1).getSelectionModel().isSelected(s)) {
                            BigDecimal bd = new BigDecimal((String)EditBookmarkForm.access$100(this.this$1).getSelectionModel().getSelectedKey(s));
                            Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                            TextArea ta = (TextArea)e.getTarget();
                            ta.setValue(s, (Object)bmrk.getDescription());
                        }
                    }
                });
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
            this.creationDate = new Label(GlobalizationUtil.globalize("bookmarks.ui.creation_date"));
            this.creationDate.addPrintListener(new PrintListener(this){
                private final /* synthetic */ EditBookmarkForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    BigDecimal bd = new BigDecimal((String)EditBookmarkForm.access$100(this.this$1).getSelectionModel().getSelectedKey(s));
                    Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                    Label t = (Label)e.getTarget();
                    t.setLabel(bmrk.getCreateDate());
                }
            });
            this.modDate = new Label(GlobalizationUtil.globalize("bookmarks.ui.modification_date"));
            this.modDate.addPrintListener(new PrintListener(this){
                private final /* synthetic */ EditBookmarkForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    BigDecimal bd = new BigDecimal((String)EditBookmarkForm.access$100(this.this$1).getSelectionModel().getSelectedKey(s));
                    Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                    Label t = (Label)e.getTarget();
                    t.setLabel(bmrk.getModDate());
                }
            });
            this.author = new Label(GlobalizationUtil.globalize("bookmarks.ui.creator"));
            this.author.addPrintListener(new PrintListener(this){
                private final /* synthetic */ EditBookmarkForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    BigDecimal bd = new BigDecimal((String)EditBookmarkForm.access$100(this.this$1).getSelectionModel().getSelectedKey(s));
                    Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                    Label t = (Label)e.getTarget();
                    t.setLabel(bmrk.getAuthor());
                }
            });
            this.visits = new Label(GlobalizationUtil.globalize("bookmarks.ui.number_of_visits"));
            this.visits.addPrintListener(new PrintListener(this){
                private final /* synthetic */ EditBookmarkForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    BigDecimal bd = new BigDecimal((String)EditBookmarkForm.access$100(this.this$1).getSelectionModel().getSelectedKey(s));
                    Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                    Label t = (Label)e.getTarget();
                    t.setLabel(bmrk.getNumVisits());
                }
            });
            this.button = new Submit("Save");
            this.button.setButtonLabel("Update Properties");
            this.add((Component)this.instruction);
            this.add((Component)this.blank);
            this.add((Component)this.instruction1);
            this.add((Component)this.bookmarkName);
            this.add((Component)this.instruction2);
            this.add((Component)this.bookmarkURL);
            this.add((Component)this.instruction3);
            this.add((Component)this.bookmarkDescription);
            this.add((Component)this.blank1);
            this.add((Component)this.blank2);
            this.add((Component)this.creationDateLabel);
            this.add((Component)this.creationDate);
            this.add((Component)this.authorLabel);
            this.add((Component)this.author);
            this.add((Component)this.modDateLabel);
            this.add((Component)this.modDate);
            this.add((Component)this.blank3);
            this.add((Component)this.blank4);
            this.add((Component)this.button);
            this.addProcessListener(this);
            this.addInitListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            BigDecimal bd = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
            Bookmark bmrk = Bookmark.retrieveBookmark(bd);
            BookmarkApplication ba = (BookmarkApplication)Application.getCurrentApplication((HttpServletRequest)s.getRequest());
            bmrk.setName(this.bookmarkName.getValue(s).toString());
            bmrk.setURL(this.bookmarkURL.getValue(s).toString());
            bmrk.setDescription(this.bookmarkDescription.getValue(s).toString());
            bmrk.setModDate();
            bmrk.setBookmarkApplication(ba);
            bmrk.save();
        }

        public void init(FormSectionEvent e) {
            PageState s = e.getPageState();
            BigDecimal bd = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
            Bookmark bmrk = Bookmark.retrieveBookmark(bd);
            bmrk.assertPrivilege(PrivilegeDescriptor.READ);
        }

        static /* synthetic */ BookmarkEditPane access$100(EditBookmarkForm x0) {
            return x0.BookmarkEditPane.this;
        }
    }

    static class BmrkListModel
    implements ListModel {
        BookmarkCollection m_bmrks;
        Bookmark m_bmrk;

        public BmrkListModel(PageState s) {
            BookmarkApplication bmrkapp = (BookmarkApplication)Application.getCurrentApplication((HttpServletRequest)s.getRequest());
            this.m_bmrks = bmrkapp.getBookmarks();
        }

        public boolean next() {
            if (!this.m_bmrks.next()) {
                return false;
            }
            this.m_bmrk = this.m_bmrks.getBookmark();
            return true;
        }

        public Object getElement() {
            return this.m_bmrk.getName();
        }

        public String getKey() {
            return this.m_bmrk.getID().toString();
        }
    }
}

