/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui;


import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.LegalNotice;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.util.GlobalizationUtil;

/**
 * Form to edit the basic properties of a legal notice. These are name, title,
 * item date and reference code. This form can be extended to create forms for
 * LegalNotice subclasses.
 **/
public class LegalNoticePropertyForm extends BasicPageForm
    implements FormProcessListener, FormInitListener, FormSubmissionListener {

    private LegalNoticePropertiesStep m_step;

    /**  government UID parameter name */
    public static final String GOVERNMENT_UID = "governmentUID";
    /** Name of this form */
    public static final String ID = "legal_notice_edit";

    /**
     * Creates a new form to edit the LegalNotice object specified
     * by the item selection model passed in.
     * @param itemModel The ItemSelectionModel to use to obtain the
     *    LegalNotice to work on
     */
    public LegalNoticePropertyForm( ItemSelectionModel itemModel ) {
        this( itemModel, null );
    }

    /**
     * Creates a new form to edit the LegalNotice object specified
     * by the item selection model passed in.
     * @param itemModel The ItemSelectionModel to use to obtain the
     *    LegalNotice to work on
     * @param step The LegalNoticePropertiesStep which controls this form.
     */
    public LegalNoticePropertyForm( ItemSelectionModel itemModel, LegalNoticePropertiesStep step ) {
        super( ID, itemModel );
        m_step = step;
        addSubmissionListener(this);
    }

    /**
     * Adds widgets to the form.
     */
    protected void addWidgets() {
        super.addWidgets();

        add(new Label(GlobalizationUtil.globalize("cms.contenttypes.ui.government_uid")));
        ParameterModel governmentUIDParam = new StringParameter(GOVERNMENT_UID);
        TextField governmentUID = new TextField(governmentUIDParam);
        governmentUID.setSize(30);
        add(governmentUID);

    }

    /** Form initialisation hook. Fills widgets with data. */
    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        LegalNotice notice = (LegalNotice) super.initBasicWidgets(fse);

        data.put(GOVERNMENT_UID, notice.getGovernmentUID());
    }

    /** Cancels streamlined editing. */
    public void submitted( FormSectionEvent fse ) {
        if (m_step != null &&
            getSaveCancelSection().getCancelButton()
            .isSelected( fse.getPageState())) {
            m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    /** Form processing hook. Saves LegalNotice object. */
    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();

        LegalNotice notice
            = (LegalNotice) super.processBasicWidgets(fse);

        // save only if save button was pressed
        if (notice != null
            && getSaveCancelSection()
            .getSaveButton().isSelected(fse.getPageState())) {

            notice.setGovernmentUID((String) data.get(GOVERNMENT_UID));
            notice.save();
        }
        if (m_step != null) {
            m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}
