/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;


import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.TextPage;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

import java.math.BigDecimal;

/**
 * This content type represents a minutes.
 *
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/
public class Minutes extends TextPage {

    private static Logger s_log =
        Logger.getLogger(Minutes.class);

    /** PDL property name for attendees */
    public static final String ATTENDEES = "attendees";
    /** PDL property name for description */
    public static final String DESCRIPTION = "description";
    /** PDL property name for action item */
    public static final String ACTION_ITEM = "actionItem";
    /** PDL property name for minute number */
    public static final String MINUTE_NUMBER = "minuteNumber";
    /** PDL property name for description */
    public static final String DESCRIPTION_OF_MINUTES = "descriptionOfMinutes";

    /** Data object type for this domain object */
    public static final String BASE_DATA_OBJECT_TYPE
        = "com.arsdigita.cms.contenttypes.Minutes";

    public Minutes() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Minutes(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public Minutes(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public Minutes(DataObject obj) {
        super(obj);
    }

    public Minutes(String type) {
        super(type);
    }


    public void beforeSave() {
        super.beforeSave();
        
        Assert.exists(getContentType(), ContentType.class);
    }

    /* accessors *****************************************************/
    public String getAttendees() {
        return (String) get(ATTENDEES);
    }

    public void setAttendees(String attendees) {
        set(ATTENDEES, attendees);
    }

    public String getActionItem() {
        return (String) get(ACTION_ITEM);
    }

    public void setActionItem(String actionItem) {
        set(ACTION_ITEM, actionItem);
    }

    public String getDescription() {
        return (String) get(DESCRIPTION);
    }

    public void setDescription(String Description) {
        set(DESCRIPTION, Description);
    }

    public String getDescriptionOfMinutes() {
        return (String) get(DESCRIPTION_OF_MINUTES);
    }

    public void setDescriptionOfMinutes(String descriptionOfMinutes) {
        set(DESCRIPTION_OF_MINUTES, descriptionOfMinutes);
    }

    public String getMinuteNumber() {
        return (String) get(MINUTE_NUMBER);
    }

    public void setMinuteNumber(String minuteNumber) {
        set(MINUTE_NUMBER, minuteNumber);
    }

    public static final int SUMMARY_LENGTH = 200;
    public String getSearchSummary() {
        return com.arsdigita.util.StringUtils.truncateString(getDescription(),
                                                             SUMMARY_LENGTH,
                                                             true);
    }

}
