/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

import java.math.BigDecimal;
import java.util.Iterator;

/**
 * Represents a section within a MultiPartArticle
 *
 * @author <a href="mailto:dturner@arsdigita.com">Dave Turner</a>
 * @version $Id: //cms/content-types/mparticle/dev/src/com/arsdigita/cms/contenttypes/ArticleSection.java#6 $
 */
public class ArticleSection extends ContentPage {
    private static final Logger log =
        Logger.getLogger(ArticleSection.class.getName());

    /** attributes names */
    public static final String TEXT     = "text";
    public static final String IMAGE    = "image";
    public static final String RANK     = "rank";
    public static final String PAGE_BREAK = "pageBreak";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.cms.contenttypes.ArticleSection";

    /** Default constructor. */
    public ArticleSection() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    /**
     * Constructor.  Retrieves an object instance with the given id.
     *
     * @param id the id of the object to retrieve
     */
    public ArticleSection(BigDecimal id) 
        throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    /**
     * Constructor.  Retrieves an object instance with the given OID.
     *
     * @param id the id of the object to retrieve
     */
    public ArticleSection(OID id) 
        throws DataObjectNotFoundException {
        super(id);
    }

    /**
     * Constructor.  Creates an ArticleSection domain object using the
     * object data given.
     *
     * @param obj the object data to use
     */
    public ArticleSection(DataObject obj) {
        super(obj);
    }


    /** Constructor.  Construct an object with the given type. */
    public ArticleSection(String type) {
        super(type);
    }


    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    /** Accessor. Get this item's rank in the set of ArticleSections */
        
    public Integer getRank() {
        return (Integer)get(RANK);
    }

    /** Mutator. Set this item's rank.*/

    public void setRank(Integer rank) {
        set(RANK, rank);
    } 


    /** Accessor. Get the text associated with this item. */
    public TextAsset getText() {
        if ( get(TEXT) == null ) {
            return null;
        }
        return new TextAsset((DataObject)get(TEXT));
    }

    /** Mutator.. Set the text associated with this item. */
    public void setText(TextAsset text) {
        setAssociation(TEXT, text);
    }

    /** Accessor. Get the image associated with this item. */
    public ImageAsset getImage() {
        if ( get(IMAGE) == null ) {
            return null;
        }
        return new ImageAsset((DataObject)get(IMAGE));
    }

    /** Mutator. Set the image associated with this item. */
    public void setImage(ImageAsset image) {
        setAssociation(IMAGE, image);
    }

    public void initialize() {
        super.initialize();
                                                                                
        if (isNew()) {
            set(PAGE_BREAK, Boolean.FALSE);
        }
    }

    public boolean isPageBreak() {
        return (Boolean.TRUE.equals(get(PAGE_BREAK)));
    }

    public void setPageBreak(boolean val) {
        set(PAGE_BREAK, new Boolean(val));
    }
}
