/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.*;
import com.arsdigita.cms.lifecycle.*;
import com.arsdigita.initializer.Initializer;
import com.arsdigita.persistence.*;
import com.arsdigita.persistence.metadata.*;
import com.arsdigita.runtime.*;
import com.arsdigita.util.*;
import java.io.*;
import java.net.*;
import java.util.*;
import org.apache.log4j.Logger;

/**
 * Subject to change.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/content-types/mparticle/dev/src/com/arsdigita/cms/contenttypes/MultiPartArticleTroikaRickshawUpgrade.java#3 $
 */
public class MultiPartArticleTroikaRickshawUpgrade {
    private static final Logger s_log = Logger.getLogger
        (MultiPartArticleTroikaRickshawUpgrade.class);

    public static final void main(final String[] args) throws IOException {
        new Startup().run();

        final Session session = SessionManager.getSession();

        final TransactionContext tc = session.getTransactionContext();
        tc.beginTxn();

        final ContentType type = ContentType.findByAssociatedObjectType
            (MultiPartArticle.BASE_DATA_OBJECT_TYPE);
        final URL templateURL = new URL
            (null, "resource:///WEB-INF/content-types/com/arsdigita/cms" +
             "/contenttypes/mparticle-item.jsp");

        final ContentSectionCollection coll = ContentSection.getAllSections();

        while (coll.next()) {
            final ContentSection section = coll.getContentSection();

            final Template template = new Template();
            template.setName("MultiPartArticle-mparticle-item");
            template.setLabel("mparticle-item");
            template.setContentSection(section);
            template.setParent(section.getTemplatesFolder());

            final InputStream stream;
            try {
                stream = templateURL.openStream();
            } catch (IOException ex) {
                throw new UncheckedWrapperException("Cannot read stream", ex);
            }

            Assert.truth(stream != null, "Template not found");

            final BufferedReader input = new BufferedReader
                (new InputStreamReader(stream));

            final StringBuffer body = new StringBuffer();

            try {
                String line;

                while ((line = input.readLine()) != null) {
                    body.append(line);
                    body.append("\n");
                }
            } catch (IOException ioe) {
                throw new UncheckedWrapperException
                    ("Template cannot be read", ioe);
            }

            template.setText(body.toString());

            TemplateManagerFactory.getInstance().addTemplate
                (section, type, template, TemplateManager.PUBLIC_CONTEXT);

            final LifecycleDefinitionCollection ldc =
                section.getLifecycleDefinitions();
            LifecycleDefinition ld = null;
            if (ldc.next()) {
                ld = ldc.getLifecycleDefinition();
                ldc.close();
            }

            template.publish(ld, new Date());
        }

        tc.commitTxn();
    }
}
