/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui.mparticle;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.MultiPartArticle;
import com.arsdigita.cms.ui.authoring.CreationComponent;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.cms.ui.authoring.LanguageWidget;
import com.arsdigita.cms.ui.authoring.ApplyWorkflowFormSection;
import com.arsdigita.cms.contenttypes.util.MPArticleGlobalizationUtil;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;

import java.util.Date;

/**
 * A form which will create a MultiPartArticle or one of its
 * subclasses.
 *
 * @author <a href="mailto:dturner@arsidigita.com">Dave Turner</a>
 * @version $Id: //cms/content-types/mparticle/dev/src/com/arsdigita/cms/contenttypes/ui/mparticle/MultiPartArticleCreate.java#6 $
 */
public class MultiPartArticleCreate extends MultiPartArticleForm
        implements FormInitListener, FormProcessListener,
                   FormSubmissionListener, 
                   FormValidationListener, 
                   CreationComponent {
    private CreationSelector m_parent;
    private ApplyWorkflowFormSection m_workflowSection;

    public MultiPartArticleCreate(ItemSelectionModel itemModel,
                                  CreationSelector parent) {
        super("MultiPartArticleCreate", itemModel);
        m_parent = parent;
        m_workflowSection.setCreationSelector(m_parent);
        m_workflowSection.setContentType(m_itemModel.getContentType());
        addSubmissionListener(this);
        getSaveCancelSection().getSaveButton().setButtonLabel("Create");
    }

    protected void addWidgets() {
        m_workflowSection = new ApplyWorkflowFormSection();
        add(m_workflowSection, ColumnPanel.INSERT);
        add(new Label(
                MPArticleGlobalizationUtil
                .globalize("cms.ui.language.field")));
        add(new LanguageWidget(LANGUAGE));
        super.addWidgets();
    }

    /**
     * Return the ApplyWorkflowFormSection associated with this CreationComponent.
     *
     * @return the ApplyWorkflowFormSection associated with this CreationComponent.
     */
    public ApplyWorkflowFormSection getWorkflowSection() {
        return m_workflowSection;
    }

    public void init(FormSectionEvent event) throws FormProcessException {
        // this is currently a no-op
    }

    public void submitted(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();

        if (getSaveCancelSection().getCancelButton().isSelected(state)) {
            m_parent.redirectBack(state);
            throw new FormProcessException(
                (String)MPArticleGlobalizationUtil
                .globalize("cms.contenttypes.ui.mparticle.submission_cancelled")
                .localize());
        }
    }

    public void validate(FormSectionEvent event) throws FormProcessException {
        Folder f = m_parent.getFolder(event.getPageState());
        Assert.exists(f, Folder.class);
        if (!validateNameUniqueness(f, event)) {
            throw new FormProcessException(
                (String)MPArticleGlobalizationUtil
                .globalize("cms.contenttypes.ui.mparticle." + 
                           "an_item_with_this_name_already_exists")
                .localize());
        }
    }

    public void process(final FormSectionEvent e) throws FormProcessException {
        final FormData data = e.getFormData();
        final PageState state = e.getPageState();
        final ContentSection section = m_parent.getContentSection(state);

        final MultiPartArticle article = createArticle(state);
        article.setLanguage((String) data.get(LANGUAGE));
        article.setName((String) data.get(NAME));
        article.setTitle((String) data.get(TITLE));
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            article.setLaunchDate((Date) data.get(LAUNCH_DATE));
        }
        article.setSummary((String) data.get(SUMMARY));

        final ContentBundle bundle = new ContentBundle(article);
        bundle.setParent(m_parent.getFolder(state));
        bundle.setContentSection(section);

        m_workflowSection.applyWorkflow(state, article);

        m_parent.editItem(state, article);
    }

}
