/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui.mparticle;


import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.MultiPartArticle;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.contenttypes.util.MPArticleGlobalizationUtil;
import com.arsdigita.util.Assert;

import java.text.DateFormat;


/**
 * A MultiPartArticle editing component.
 *
 * @author <a href="mailto:dturner@arsdigita.com">Dave Turner</a>
 * @version $Id: //cms/content-types/mparticle/dev/src/com/arsdigita/cms/contenttypes/ui/mparticle/MultiPartArticleEdit.java#8 $
 */
public class MultiPartArticleEdit extends SimpleEditStep {

    /**
     * Constructor.
     *
     * @param itemModel the ItemSelectionModel which holds the current
     *   MutliPartArticle
     * @param parent the parent wizard which contains the form
     */
    public MultiPartArticleEdit(ItemSelectionModel itemModel,
                                AuthoringKitWizard parent) {
        super(itemModel, parent);

        setDefaultEditKey("edit");
        MultiPartArticleForm form = getForm(itemModel);
        add("edit",
            "Edit",
            new WorkflowLockedComponentAccess(form, itemModel),
            form.getSaveCancelSection().getCancelButton()
           );
        
        setDisplayComponent(getMultiPartArticlePropertiesSheet(itemModel));
    }

    protected MultiPartArticleForm getForm(ItemSelectionModel model) {
        return new MultiPartArticleEditForm(model, this);
    }


    public Component getMultiPartArticlePropertiesSheet(
        ItemSelectionModel itemModel
    ) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet(itemModel);

        sheet.add( MPArticleGlobalizationUtil
                   .globalize("cms.contenttypes.ui.mparticle.name"), 
                   MultiPartArticle.NAME    );
        sheet.add( MPArticleGlobalizationUtil
                   .globalize("cms.contenttypes.ui.mparticle.title"),
                   MultiPartArticle.TITLE   );
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add(MPArticleGlobalizationUtil
                      .globalize("cms.contenttypes.ui.launch_date"),
                      ContentPage.LAUNCH_DATE,
                      new DomainObjectPropertySheet.AttributeFormatter() {
                          public String format(DomainObject item,
                                               String attribute,
                                               PageState state) {
                              ContentPage page = (ContentPage) item;
                              if (page.getLaunchDate() != null) {
                                  return DateFormat.getDateInstance(DateFormat.LONG)
                                      .format(page.getLaunchDate());
                              } else {
                                  return "<i>unknown</i>";
                              }
                          }
                      });
        }
        sheet.add( MPArticleGlobalizationUtil
                   .globalize("cms.contenttypes.ui.mparticle.summary"),  
                   MultiPartArticle.SUMMARY );

        return sheet;
    }
}
