/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui.mparticle;


import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.MultiPartArticle;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.contenttypes.util.MPArticleGlobalizationUtil;
import com.arsdigita.util.Assert;

import java.text.DateFormat;


public class MultiPartArticleEditForm extends MultiPartArticleForm 
    implements FormSubmissionListener {
        
    private SimpleEditStep m_step;

    public MultiPartArticleEditForm(ItemSelectionModel itemModel, 
                                    SimpleEditStep step) {
        super("MutliPartArticleEditForm", itemModel);
        addSubmissionListener(this);
        m_step = step;
    }
        
    public void init(FormSectionEvent e) throws FormProcessException {
        super.initBasicWidgets(e);
    }

    /** Cancels streamlined editing. */
    public void submitted( FormSectionEvent fse ) {
        if (getSaveCancelSection().getCancelButton()
            .isSelected( fse.getPageState())) {
            m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        MultiPartArticle article = (MultiPartArticle)processBasicWidgets(e);
        m_step.maybeForwardToNextStep(e.getPageState());
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData  data  = e.getFormData();

        MultiPartArticle article =
            (MultiPartArticle)m_itemModel.getSelectedObject(state);
        Assert.exists(article, MultiPartArticle.class);

        String newName = (String)data.get(MultiPartArticleForm.NAME);
        String oldName = article.getName();

        boolean valid = true;
        if ( !newName.equalsIgnoreCase(oldName) ) {
            Folder parent = getParentFolder(article);
            valid = validateNameUniqueness(parent, e);
        }

        if ( !valid ) {
            throw new FormProcessException
                ((String)MPArticleGlobalizationUtil
                 .globalize("cms.contenttypes.ui.mparticle." + 
                            "an_item_with_name_already_exists").localize());
        }
    }

    private Folder getParentFolder(MultiPartArticle article) {
        ContentItem parent = (ContentItem) article.getParent();
        while (parent != null && !(parent instanceof Folder)) {
            parent = (ContentItem) parent.getParent();
        }

        return (Folder) parent;
    }

}
