/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui.mparticle;


import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.ArticleSection;
import com.arsdigita.cms.contenttypes.MultiPartArticle;
import com.arsdigita.cms.contenttypes.util.MPArticleGlobalizationUtil;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

/**
 * A form to confirm deletion of a single section of a MultiPartArticle.
 *
 * @author <a href="mailto:dturner@arsdigita.com">Dave Turner</a>
 * @version $Id: //cms/content-types/mparticle/dev/src/com/arsdigita/cms/contenttypes/ui/mparticle/SectionDeleteForm.java#5 $
 */
public class SectionDeleteForm extends Form
    implements FormInitListener, FormSubmissionListener, FormProcessListener
{
    private final static Logger log = Logger.getLogger(SectionDeleteForm.class.getName());

    protected ItemSelectionModel m_selArticle;
    protected ItemSelectionModel m_selSection;
    protected SaveCancelSection m_saveCancelSection;
    private Label m_sectionNameLabel;


    public SectionDeleteForm 
        ( ItemSelectionModel selArticle,
          ItemSelectionModel selSection) {
        super("SectionDeleteForm", new ColumnPanel(2));
        m_selArticle = selArticle;
        m_selSection = selSection;

        ColumnPanel panel = (ColumnPanel)getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("100%");

        m_sectionNameLabel = new Label ("Section Name");
        add(m_sectionNameLabel, ColumnPanel.FULL_WIDTH | ColumnPanel.LEFT);
        addSaveCancelSection();

        addInitListener(this);
        addSubmissionListener(this);
        addProcessListener(this);
    }

    protected SaveCancelSection addSaveCancelSection () {
        m_saveCancelSection = new SaveCancelSection();
        m_saveCancelSection.getSaveButton().setButtonLabel("Delete");
        add(m_saveCancelSection, ColumnPanel.FULL_WIDTH | ColumnPanel.LEFT);
        return m_saveCancelSection;
    }

    public void init ( FormSectionEvent event ) throws FormProcessException {
        PageState state = event.getPageState();

        ArticleSection section = (ArticleSection)m_selSection.getSelectedObject(state);

        if ( section == null ) {
            log.error("No section selected");
        } else {
            m_sectionNameLabel.setLabel(section.getTitle(),state);
        }
    }

    public void submitted ( FormSectionEvent event ) throws FormProcessException {
        PageState state = event.getPageState();

        if ( m_saveCancelSection.getCancelButton().isSelected(state) ) {
            throw new FormProcessException( (String) MPArticleGlobalizationUtil.globalize("cms.contenttypes.ui.mparticle.submission_cancelled").localize());
        }
    }

    public void process ( FormSectionEvent event ) throws FormProcessException {
        PageState state = event.getPageState();

        MultiPartArticle article = (MultiPartArticle)m_selArticle.getSelectedObject(state);
        ArticleSection section = (ArticleSection)m_selSection.getSelectedObject(state);

        Assert.exists(article, MultiPartArticle.class);
        Assert.exists(section, ArticleSection.class);

        article.removeSection(section);

        log.info("section " + m_selSection.getSelectedKey(state) + " delete");
    }
}
