/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.util;

import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Enumeration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import com.arsdigita.globalization.ChainedResourceBundle;
import com.arsdigita.cms.CMSGlobalized;

/**
 * Form to edit the basic properties of an event. This form can be extended to
 * create forms for Event subclasses.
 **/
public class MultiPartArticleResourceBundle extends ChainedResourceBundle implements CMSGlobalized {
    
    public final static String MPARTICLE_BUNDLE_NAME = 
        "com.arsdigita.cms.contenttypes.MultiPartArticleResources";

    public MultiPartArticleResourceBundle() {
        super();
        addBundle((PropertyResourceBundle)getBundle(MPARTICLE_BUNDLE_NAME));
        addBundle((PropertyResourceBundle)getBundle(BUNDLE_NAME));
    }
}
