/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.FunctionCall;
import org.apache.xalan.xsltc.compiler.LiteralExpr;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.runtime.TransletLoader;

final class FunctionAvailableCall
extends FunctionCall {
    private boolean _isFunctionAvailable = false;
    private Expression _arg;
    private String _namespaceOfFunct = null;
    private String _nameOfFunct = null;

    public FunctionAvailableCall(QName fname, Vector arguments) {
        super(fname, arguments);
        this._arg = (Expression)arguments.elementAt(0);
        this._type = null;
        if (this._arg instanceof LiteralExpr) {
            LiteralExpr arg = (LiteralExpr)this._arg;
            this._namespaceOfFunct = arg.getNamespace();
            this._nameOfFunct = arg.getValue();
            if (this._namespaceOfFunct != null && !this._namespaceOfFunct.equals("")) {
                this._isFunctionAvailable = this.hasMethods();
            }
        }
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (this._type != null) {
            return this._type;
        }
        if (this._arg instanceof LiteralExpr) {
            this._type = Type.Boolean;
            return Type.Boolean;
        }
        ErrorMsg err = new ErrorMsg(14, (Object)"function-available", this);
        throw new TypeCheckError(err);
    }

    private String getClassName(String argValue) {
        int lastDot;
        int colonSep = argValue.indexOf(":");
        if (colonSep != -1) {
            argValue = argValue.substring(colonSep + 1);
        }
        if ((lastDot = argValue.lastIndexOf(".")) != -1) {
            argValue = argValue.substring(0, lastDot);
        }
        return argValue;
    }

    private String getMethodName(String argValue) {
        int lastDot = argValue.lastIndexOf(".");
        if (lastDot != -1) {
            argValue = argValue.substring(lastDot + 1);
        }
        return argValue;
    }

    private String getExternalFunctionName() {
        int colonIndex = this._nameOfFunct.indexOf(":");
        String uri = this._namespaceOfFunct + "." + this._nameOfFunct.substring(colonIndex + 1);
        try {
            return this.getClassNameFromUri(uri);
        }
        catch (TypeCheckError e) {
            return null;
        }
    }

    private boolean hasMethods() {
        LiteralExpr arg = (LiteralExpr)this._arg;
        String externalFunctName = this.getExternalFunctionName();
        if (externalFunctName == null) {
            return false;
        }
        String className = this.getClassName(externalFunctName);
        if (this._namespaceOfFunct.startsWith("http://xml.apache.org/xalan/xsltc/java") || this._namespaceOfFunct.startsWith("http://xml.apache.org/xslt/java")) {
            try {
                TransletLoader loader = new TransletLoader();
                Class clazz = loader.loadClass(className);
                if (clazz == null) {
                    ErrorMsg msg = new ErrorMsg(5, className);
                    this.getParser().reportError(3, msg);
                } else {
                    String methodName = this.getMethodName(externalFunctName);
                    Method[] methods = clazz.getDeclaredMethods();
                    int i = 0;
                    while (i < methods.length) {
                        int mods = methods[i].getModifiers();
                        if (Modifier.isPublic(mods) && Modifier.isStatic(mods) && methods[i].getName().equals(methodName)) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                ErrorMsg msg = new ErrorMsg(5, className);
                this.getParser().reportError(3, msg);
            }
        }
        return false;
    }

    public boolean getResult() {
        if (this._namespaceOfFunct == null || this._namespaceOfFunct.equals("")) {
            Parser parser2 = this.getParser();
            this._isFunctionAvailable = parser2.functionSupported(this._nameOfFunct);
        }
        return this._isFunctionAvailable;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        methodGen.getInstructionList().append(new PUSH(cpg, this.getResult()));
    }
}

