/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import org.apache.xalan.xsltc.runtime.output.OutputBase;

abstract class StreamOutput
extends OutputBase {
    protected static final String AMP = "&amp;";
    protected static final String LT = "&lt;";
    protected static final String GT = "&gt;";
    protected static final String CRLF = "&#xA;";
    protected static final String QUOTE = "&quot;";
    protected static final String NBSP = "&nbsp;";
    protected static final String CHAR_ESC_START = "&#";
    protected static final char[] INDENT = "                    ".toCharArray();
    protected static final int MAX_INDENT_LEVEL = INDENT.length >> 1;
    protected static final int MAX_INDENT = INDENT.length;
    protected static final int BUFFER_SIZE = 65536;
    protected static final int OUTPUT_BUFFER_SIZE = 4096;
    protected Writer _writer;
    protected StringBuffer _buffer;
    protected boolean _is8859Encoded = false;
    protected boolean _indent = false;
    protected boolean _omitHeader = false;
    protected String _standalone = null;
    protected String _version = "1.0";
    protected boolean _lineFeedNextStartTag = false;
    protected boolean _linefeedNextEndTag = false;
    protected boolean _indentNextEndTag = false;
    protected int _indentLevel = 0;
    protected boolean _escaping = true;
    protected String _encoding = "UTF-8";
    protected Vector _attributes = new Vector();

    protected StreamOutput(StreamOutput output) {
        this._writer = output._writer;
        this._encoding = output._encoding;
        this._is8859Encoded = output._is8859Encoded;
        this._buffer = output._buffer;
    }

    protected StreamOutput(Writer writer, String encoding) {
        this._writer = writer;
        this._encoding = encoding;
        this._is8859Encoded = encoding.equalsIgnoreCase("iso-8859-1");
        this._buffer = new StringBuffer(65536);
    }

    protected StreamOutput(OutputStream out, String encoding) throws IOException {
        try {
            this._encoding = encoding;
            this._writer = new OutputStreamWriter(out, this._encoding);
            this._is8859Encoded = encoding.equalsIgnoreCase("iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            this._encoding = "utf-8";
            this._writer = new OutputStreamWriter(out, "utf-8");
        }
        this._buffer = new StringBuffer(65536);
    }

    public void setDoctype(String system, String pub) {
        this._doctypeSystem = system;
        this._doctypePublic = pub;
    }

    public void setIndent(boolean indent) {
        this._indent = indent;
    }

    public void omitHeader(boolean value) {
        this._omitHeader = value;
    }

    public void setStandalone(String standalone) {
        this._standalone = standalone;
    }

    protected void outputBuffer() {
        try {
            int n = 0;
            int length = this._buffer.length();
            String output = this._buffer.toString();
            if (length > 4096) {
                do {
                    this._writer.write(output, n, 4096);
                } while ((n += 4096) + 4096 < length);
            }
            this._writer.write(output, n, length - n);
            this._writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void appendDTD(String name) {
        this._buffer.append("<!DOCTYPE ").append(name);
        if (this._doctypePublic == null) {
            this._buffer.append(" SYSTEM");
        } else {
            this._buffer.append(" PUBLIC \"").append(this._doctypePublic).append("\"");
        }
        if (this._doctypeSystem != null) {
            this._buffer.append(" \"").append(this._doctypeSystem).append("\">\n");
        } else {
            this._buffer.append(">\n");
        }
    }

    protected void indent(boolean linefeed) {
        if (linefeed) {
            this._buffer.append('\n');
        }
        this._buffer.append(INDENT, 0, this._indentLevel < MAX_INDENT_LEVEL ? this._indentLevel + this._indentLevel : MAX_INDENT);
    }

    protected void escapeCharacters(char[] ch, int off, int len) {
        int limit = off + len;
        int offset = off;
        if (limit > ch.length) {
            limit = ch.length;
        }
        int i = off;
        while (i < limit) {
            char current = ch[i];
            switch (current) {
                case '&': {
                    this._buffer.append(ch, offset, i - offset);
                    this._buffer.append(AMP);
                    offset = i + 1;
                    break;
                }
                case '<': {
                    this._buffer.append(ch, offset, i - offset);
                    this._buffer.append(LT);
                    offset = i + 1;
                    break;
                }
                case '>': {
                    this._buffer.append(ch, offset, i - offset);
                    this._buffer.append(GT);
                    offset = i + 1;
                    break;
                }
                case '\u00a0': {
                    this._buffer.append(ch, offset, i - offset);
                    this._buffer.append(NBSP);
                    offset = i + 1;
                    break;
                }
                default: {
                    if ((current < '\u007f' || current >= '\u00a0') && (!this._is8859Encoded || current <= '\u00ff')) break;
                    this._buffer.append(ch, offset, i - offset);
                    this._buffer.append(CHAR_ESC_START);
                    this._buffer.append(Integer.toString(ch[i]));
                    this._buffer.append(';');
                    offset = i + 1;
                }
            }
            ++i;
        }
        if (offset < limit) {
            this._buffer.append(ch, offset, limit - offset);
        }
    }

    protected void appendAttributes() {
        if (!this._attributes.isEmpty()) {
            int i = 0;
            int length = this._attributes.size();
            do {
                Attribute attr = (Attribute)this._attributes.elementAt(i);
                this._buffer.append(' ').append(attr.name).append("=\"").append(attr.value).append('\"');
            } while (++i < length);
            this._attributes.clear();
        }
    }

    protected void closeStartTag() {
        this.appendAttributes();
        this._buffer.append('>');
        this._startTagOpen = false;
    }

    static class Attribute {
        public String name;
        public String value;

        Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            try {
                return this.name.equalsIgnoreCase(((Attribute)obj).name);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }
}

