/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.runtime.DefaultSAXOutputHandler;
import org.apache.xalan.xsltc.runtime.TextOutput;
import org.apache.xalan.xsltc.runtime.output.SAXHTMLOutput;
import org.apache.xalan.xsltc.runtime.output.SAXTextOutput;
import org.apache.xalan.xsltc.runtime.output.SAXXMLOutput;
import org.apache.xalan.xsltc.runtime.output.StreamHTMLOutput;
import org.apache.xalan.xsltc.runtime.output.StreamTextOutput;
import org.apache.xalan.xsltc.runtime.output.StreamUnknownOutput;
import org.apache.xalan.xsltc.runtime.output.StreamXMLOutput;
import org.apache.xalan.xsltc.trax.SAX2DOM;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;

public class TransletOutputHandlerFactory {
    public static final int STREAM = 0;
    public static final int SAX = 1;
    public static final int DOM = 2;
    private String _encoding = "utf-8";
    private String _method = null;
    private int _outputType = 0;
    private OutputStream _ostream = System.out;
    private Writer _writer = null;
    private Node _node = null;
    private ContentHandler _handler = null;
    private LexicalHandler _lexHandler = null;

    public static TransletOutputHandlerFactory newInstance() {
        return new TransletOutputHandlerFactory();
    }

    public void setOutputType(int outputType) {
        this._outputType = outputType;
    }

    public void setEncoding(String encoding) {
        if (encoding != null) {
            this._encoding = encoding;
        }
    }

    public void setOutputMethod(String method) {
        this._method = method;
    }

    public void setOutputStream(OutputStream ostream) {
        this._ostream = ostream;
    }

    public void setWriter(Writer writer) {
        this._writer = writer;
    }

    public void setHandler(ContentHandler handler) {
        this._handler = handler;
    }

    public void setLexicalHandler(LexicalHandler lex) {
        this._lexHandler = lex;
    }

    public void setNode(Node node) {
        this._node = node;
    }

    public Node getNode() {
        return this._handler instanceof SAX2DOM ? ((SAX2DOM)this._handler).getDOM() : null;
    }

    public TransletOutputHandler getTransletOutputHandler() throws IOException, ParserConfigurationException {
        switch (this._outputType) {
            case 0: {
                if (this._method == null) {
                    return this._writer == null ? new StreamUnknownOutput(this._ostream, this._encoding) : new StreamUnknownOutput(this._writer, this._encoding);
                }
                if (this._method.equalsIgnoreCase("xml")) {
                    return this._writer == null ? new StreamXMLOutput(this._ostream, this._encoding) : new StreamXMLOutput(this._writer, this._encoding);
                }
                if (this._method.equalsIgnoreCase("html")) {
                    return this._writer == null ? new StreamHTMLOutput(this._ostream, this._encoding) : new StreamHTMLOutput(this._writer, this._encoding);
                }
                if (!this._method.equalsIgnoreCase("text")) break;
                return this._writer == null ? new StreamTextOutput(this._ostream, this._encoding) : new StreamTextOutput(this._writer, this._encoding);
            }
            case 2: {
                this._handler = this._node != null ? new SAX2DOM(this._node) : new SAX2DOM();
                this._lexHandler = (LexicalHandler)((Object)this._handler);
            }
            case 1: {
                if (this._method == null) {
                    this._method = "xml";
                }
                if (this._method.equalsIgnoreCase("xml")) {
                    return this._lexHandler == null ? new SAXXMLOutput(this._handler, this._encoding) : new SAXXMLOutput(this._handler, this._lexHandler, this._encoding);
                }
                if (this._method.equalsIgnoreCase("html")) {
                    return this._lexHandler == null ? new SAXHTMLOutput(this._handler, this._encoding) : new SAXHTMLOutput(this._handler, this._lexHandler, this._encoding);
                }
                if (!this._method.equalsIgnoreCase("text")) break;
                return this._lexHandler == null ? new SAXTextOutput(this._handler, this._encoding) : new SAXTextOutput(this._handler, this._lexHandler, this._encoding);
            }
        }
        return null;
    }

    public TransletOutputHandler getOldTransletOutputHandler() throws IOException {
        DefaultSAXOutputHandler saxHandler = new DefaultSAXOutputHandler(this._ostream, this._encoding);
        return new TextOutput(saxHandler, saxHandler, this._encoding);
    }
}

