/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.DOMCache;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.dom.DOMBuilder;
import org.apache.xalan.xsltc.dom.DOMImpl;
import org.apache.xalan.xsltc.dom.DTDMonitor;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xalan.xsltc.runtime.DefaultSAXOutputHandler;
import org.apache.xalan.xsltc.runtime.Hashtable;
import org.apache.xalan.xsltc.runtime.TextOutput;
import org.apache.xalan.xsltc.runtime.output.TransletOutputHandlerFactory;
import org.apache.xalan.xsltc.trax.DOM2SAX;
import org.apache.xalan.xsltc.trax.SAX2DOM;
import org.apache.xalan.xsltc.trax.XSLTCSource;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public final class TransformerImpl
extends Transformer
implements DOMCache,
ErrorListener {
    private AbstractTranslet _translet = null;
    private String _encoding = null;
    private ContentHandler _handler = null;
    private ErrorListener _errorListener = this;
    private URIResolver _uriResolver = null;
    private Properties _properties = null;
    private static final String EMPTY_STRING = "";
    private static final String NO_STRING = "no";
    private static final String YES_STRING = "yes";
    private static final String XML_STRING = "xml";
    private DOMImpl _dom = null;
    private DTDMonitor _dtdMonitor = null;
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private TransletOutputHandlerFactory _tohFactory = null;
    private boolean _oldOutputSystem;

    protected TransformerImpl(Translet translet, boolean oldOutputSystem) {
        this._translet = (AbstractTranslet)translet;
        this._properties = this.createOutputProperties();
        this._oldOutputSystem = oldOutputSystem;
    }

    protected AbstractTranslet getTranslet() {
        return this._translet;
    }

    public void transform(Source source, Result result) throws TransformerException {
        if (this._translet == null) {
            ErrorMsg err = new ErrorMsg(65);
            throw new TransformerException(err.toString());
        }
        this.setOutputProperties(this._translet, this._properties);
        if (!this._oldOutputSystem) {
            TransletOutputHandler toHandler = this.getOutputHandler(result);
            if (toHandler == null) {
                ErrorMsg err = new ErrorMsg(66);
                throw new TransformerException(err.toString());
            }
            if (this._uriResolver != null) {
                this._translet.setDOMCache(this);
            }
            this.transform(source, toHandler, this._encoding);
            if (result instanceof DOMResult) {
                ((DOMResult)result).setNode(this._tohFactory.getNode());
            }
        } else {
            this._handler = this.getOldOutputHandler(result);
            if (this._handler == null) {
                ErrorMsg err = new ErrorMsg(66);
                throw new TransformerException(err.toString());
            }
            if (this._uriResolver != null) {
                this._translet.setDOMCache(this);
            }
            this.transform(source, this._handler, this._encoding);
            if (result instanceof DOMResult) {
                ((DOMResult)result).setNode(((SAX2DOM)this._handler).getDOM());
            }
        }
    }

    private TransletOutputHandler getOutputHandler(Result result) throws TransformerException {
        this._encoding = this._translet._encoding != null ? this._translet._encoding : "UTF-8";
        this._tohFactory = TransletOutputHandlerFactory.newInstance();
        this._tohFactory.setEncoding(this._properties.getProperty("encoding"));
        this._tohFactory.setOutputMethod(this._properties.getProperty("method"));
        try {
            if (result instanceof SAXResult) {
                SAXResult target = (SAXResult)result;
                ContentHandler handler = target.getHandler();
                this._tohFactory.setHandler(handler);
                if (handler instanceof LexicalHandler) {
                    this._tohFactory.setLexicalHandler((LexicalHandler)((Object)handler));
                }
                this._tohFactory.setOutputType(1);
                return this._tohFactory.getTransletOutputHandler();
            }
            if (result instanceof DOMResult) {
                this._tohFactory.setNode(((DOMResult)result).getNode());
                this._tohFactory.setOutputType(2);
                return this._tohFactory.getTransletOutputHandler();
            }
            if (result instanceof StreamResult) {
                StreamResult target = (StreamResult)result;
                this._tohFactory.setOutputType(0);
                Writer writer = target.getWriter();
                if (writer != null) {
                    this._tohFactory.setWriter(writer);
                    return this._tohFactory.getTransletOutputHandler();
                }
                OutputStream ostream = target.getOutputStream();
                if (ostream != null) {
                    this._tohFactory.setOutputStream(ostream);
                    return this._tohFactory.getTransletOutputHandler();
                }
                String systemId = result.getSystemId();
                if (systemId == null) {
                    ErrorMsg err = new ErrorMsg(67);
                    throw new TransformerException(err.toString());
                }
                URL url = null;
                if (systemId.startsWith("file:")) {
                    url = new URL(systemId);
                    this._tohFactory.setOutputStream(new FileOutputStream(url.getFile()));
                    return this._tohFactory.getTransletOutputHandler();
                }
                if (systemId.startsWith("http:")) {
                    url = new URL(systemId);
                    URLConnection connection = url.openConnection();
                    this._tohFactory.setOutputStream(connection.getOutputStream());
                    return this._tohFactory.getTransletOutputHandler();
                }
                url = new File(systemId).toURL();
                this._tohFactory.setOutputStream(new FileOutputStream(url.getFile()));
                return this._tohFactory.getTransletOutputHandler();
            }
        }
        catch (UnknownServiceException e) {
            throw new TransformerException(e);
        }
        catch (ParserConfigurationException e) {
            throw new TransformerException(e);
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
        return null;
    }

    private ContentHandler getOldOutputHandler(Result result) throws TransformerException {
        this._encoding = this._translet._encoding != null ? this._translet._encoding : "UTF-8";
        try {
            if (result instanceof SAXResult) {
                SAXResult target = (SAXResult)result;
                ContentHandler handler = target.getHandler();
                if (handler != null) {
                    return handler;
                }
            } else {
                if (result instanceof DOMResult) {
                    return new SAX2DOM(((DOMResult)result).getNode());
                }
                if (result instanceof StreamResult) {
                    StreamResult target = (StreamResult)result;
                    Writer writer = target.getWriter();
                    if (writer != null) {
                        return new DefaultSAXOutputHandler(writer, this._encoding);
                    }
                    OutputStream ostream = target.getOutputStream();
                    if (ostream != null) {
                        return new DefaultSAXOutputHandler(ostream, this._encoding);
                    }
                    String systemId = result.getSystemId();
                    if (systemId == null) {
                        ErrorMsg err = new ErrorMsg(67);
                        throw new TransformerException(err.toString());
                    }
                    OutputStream os = null;
                    URL url = null;
                    if (systemId.startsWith("file:")) {
                        url = new URL(systemId);
                        os = new FileOutputStream(url.getFile());
                        return new DefaultSAXOutputHandler(os, this._encoding);
                    }
                    if (systemId.startsWith("http:")) {
                        url = new URL(systemId);
                        URLConnection connection = url.openConnection();
                        os = connection.getOutputStream();
                        return new DefaultSAXOutputHandler(os, this._encoding);
                    }
                    File tmp = new File(systemId);
                    url = tmp.toURL();
                    os = new FileOutputStream(url.getFile());
                    return new DefaultSAXOutputHandler(os, this._encoding);
                }
            }
        }
        catch (UnknownServiceException e) {
            throw new TransformerException(e);
        }
        catch (ParserConfigurationException e) {
            ErrorMsg err = new ErrorMsg(69);
            throw new TransformerException(err.toString());
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
        return null;
    }

    protected void setDOM(DOMImpl dom) {
        this._dom = dom;
    }

    protected void setDTDMonitor(DTDMonitor dtdMonitor) {
        this._dtdMonitor = dtdMonitor;
    }

    private DOMImpl getDOM(Source source, int mask) throws TransformerException {
        try {
            DOMImpl dom = null;
            DTDMonitor dtd = null;
            if (source instanceof SAXSource) {
                SAXSource sax = (SAXSource)source;
                XMLReader reader = sax.getXMLReader();
                InputSource input = sax.getInputSource();
                String systemId = sax.getSystemId();
                if (reader == null) {
                    SAXParserFactory pfactory = SAXParserFactory.newInstance();
                    pfactory.setNamespaceAware(true);
                    reader = pfactory.newSAXParser().getXMLReader();
                }
                dtd = new DTDMonitor();
                dtd.handleDTD(reader);
                dom = new DOMImpl();
                DOMBuilder builder = dom.getBuilder();
                try {
                    reader.setProperty(LEXICAL_HANDLER_PROPERTY, builder);
                }
                catch (SAXException e) {
                    // empty catch block
                }
                reader.setContentHandler(builder);
                reader.parse(input);
                dom.setDocumentURI(systemId);
            } else if (source instanceof DOMSource) {
                DOMSource domsrc = (DOMSource)source;
                Node node = domsrc.getNode();
                boolean isComplete = true;
                if (node.getNodeType() != 9) {
                    isComplete = false;
                }
                DOM2SAX dom2sax = new DOM2SAX(node);
                InputSource input = null;
                String systemId = domsrc.getSystemId();
                dtd = new DTDMonitor();
                dtd.handleDTD(dom2sax);
                dom = new DOMImpl();
                DOMBuilder builder = dom.getBuilder();
                dom2sax.setContentHandler(builder);
                if (!isComplete) {
                    builder.startDocument();
                }
                dom2sax.parse(input);
                if (!isComplete) {
                    builder.endDocument();
                }
                dom.setDocumentURI(systemId);
            } else if (source instanceof StreamSource) {
                InputSource input;
                StreamSource stream = (StreamSource)source;
                InputStream streamInput = stream.getInputStream();
                Reader streamReader = stream.getReader();
                String systemId = stream.getSystemId();
                SAXParserFactory factory = SAXParserFactory.newInstance();
                try {
                    factory.setFeature(NAMESPACE_FEATURE, true);
                }
                catch (Exception e) {
                    factory.setNamespaceAware(true);
                }
                SAXParser parser2 = factory.newSAXParser();
                XMLReader reader = parser2.getXMLReader();
                dtd = new DTDMonitor();
                dtd.handleDTD(reader);
                dom = new DOMImpl();
                DOMBuilder builder = dom.getBuilder();
                try {
                    reader.setProperty(LEXICAL_HANDLER_PROPERTY, builder);
                }
                catch (SAXException e) {
                    // empty catch block
                }
                reader.setContentHandler(builder);
                if (streamInput != null) {
                    input = new InputSource(streamInput);
                } else if (streamReader != null) {
                    input = new InputSource(streamReader);
                } else if (systemId != null) {
                    input = new InputSource(systemId);
                } else {
                    ErrorMsg err = new ErrorMsg(61);
                    throw new TransformerException(err.toString());
                }
                reader.parse(input);
                dom.setDocumentURI(systemId);
            } else if (source instanceof XSLTCSource) {
                XSLTCSource xsltcsrc = (XSLTCSource)source;
                dtd = xsltcsrc.getDTD();
                dom = xsltcsrc.getDOM();
            } else if (this._dom != null) {
                dtd = this._dtdMonitor;
                dom = this._dom;
                this._dom = null;
            } else {
                return null;
            }
            this._translet.setIndexSize(dom.getSize());
            dtd.buildIdIndex(dom, mask, this._translet);
            this._translet.setDTDMonitor(dtd);
            return dom;
        }
        catch (FileNotFoundException e) {
            if (this._errorListener != null) {
                this.postErrorToListener(e.getMessage());
            }
            throw new TransformerException(e);
        }
        catch (MalformedURLException e) {
            if (this._errorListener != null) {
                this.postErrorToListener(e.getMessage());
            }
            throw new TransformerException(e);
        }
        catch (UnknownHostException e) {
            if (this._errorListener != null) {
                this.postErrorToListener(e.getMessage());
            }
            throw new TransformerException(e);
        }
        catch (Exception e) {
            if (this._errorListener != null) {
                this.postErrorToListener(e.getMessage());
            }
            throw new TransformerException(e);
        }
    }

    private void transform(Source src, TransletOutputHandler handler, String encoding) throws TransformerException {
        try {
            this._translet.transform((DOM)this.getDOM(src, 0), handler);
        }
        catch (TransletException e) {
            if (this._errorListener != null) {
                this.postErrorToListener(e.getMessage());
            }
            throw new TransformerException(e);
        }
        catch (RuntimeException e) {
            if (this._errorListener != null) {
                this.postErrorToListener(e.getMessage());
            }
            throw new TransformerException(e);
        }
        catch (Exception e) {
            if (this._errorListener != null) {
                this.postErrorToListener(e.getMessage());
            }
            throw new TransformerException(e);
        }
    }

    private void transform(Source src, ContentHandler sax, String encoding) throws TransformerException {
        try {
            DOMImpl dom = this.getDOM(src, 0);
            TextOutput handler = sax instanceof LexicalHandler ? new TextOutput(sax, (LexicalHandler)((Object)sax), encoding) : new TextOutput(sax, encoding);
            this._translet.transform((DOM)dom, handler);
        }
        catch (TransletException e) {
            if (this._errorListener != null) {
                this.postErrorToListener(e.getMessage());
            }
            throw new TransformerException(e);
        }
        catch (RuntimeException e) {
            if (this._errorListener != null) {
                this.postErrorToListener(e.getMessage());
            }
            throw new TransformerException(e);
        }
        catch (Exception e) {
            if (this._errorListener != null) {
                this.postErrorToListener(e.getMessage());
            }
            throw new TransformerException(e);
        }
    }

    public ErrorListener getErrorListener() {
        return this._errorListener;
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            ErrorMsg err = new ErrorMsg(59, "Transformer");
            throw new IllegalArgumentException(err.toString());
        }
        this._errorListener = listener;
    }

    private void postErrorToListener(String message) {
        try {
            this._errorListener.error(new TransformerException(message));
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    private void postWarningToListener(String message) {
        try {
            this._errorListener.warning(new TransformerException(message));
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    private String makeCDATAString(Hashtable cdata) {
        if (cdata == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        Enumeration elements = cdata.keys();
        if (elements.hasMoreElements()) {
            result.append((String)elements.nextElement());
            while (elements.hasMoreElements()) {
                String element = (String)elements.nextElement();
                result.append(' ');
                result.append(element);
            }
        }
        return result.toString();
    }

    public Properties getOutputProperties() {
        return this._properties;
    }

    public String getOutputProperty(String name) throws IllegalArgumentException {
        if (!this.validOutputProperty(name)) {
            ErrorMsg err = new ErrorMsg(68, name);
            throw new IllegalArgumentException(err.toString());
        }
        return this._properties.getProperty(name);
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String prop = (String)propertyNames.nextElement();
            this._properties.setProperty(prop, properties.getProperty(prop));
        }
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        if (!this.validOutputProperty(name)) {
            ErrorMsg err = new ErrorMsg(68, name);
            throw new IllegalArgumentException(err.toString());
        }
        this._properties.setProperty(name, value);
    }

    private void setOutputProperties(AbstractTranslet translet, Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            if (name.equals("encoding")) {
                translet._encoding = value;
                continue;
            }
            if (name.equals("method")) {
                translet._method = value;
                continue;
            }
            if (name.equals("doctype-public")) {
                translet._doctypePublic = value;
                continue;
            }
            if (name.equals("doctype-system")) {
                translet._doctypeSystem = value;
                continue;
            }
            if (name.equals("media-type")) {
                translet._mediaType = value;
                continue;
            }
            if (name.equals("standalone")) {
                translet._standalone = value;
                continue;
            }
            if (name.equals("version")) {
                translet._version = value;
                continue;
            }
            if (name.equals("omit-xml-declaration")) {
                if (value != null && value.toLowerCase().equals(YES_STRING)) {
                    translet._omitHeader = true;
                    continue;
                }
                translet._omitHeader = false;
                continue;
            }
            if (name.equals("indent")) {
                if (value != null && value.toLowerCase().equals(YES_STRING)) {
                    translet._indent = true;
                    continue;
                }
                translet._indent = false;
                continue;
            }
            if (!name.equals("cdata-section-elements") || value == null) continue;
            translet._cdata = null;
            StringTokenizer e = new StringTokenizer(value);
            while (e.hasMoreTokens()) {
                translet.addCdataElement(e.nextToken());
            }
        }
    }

    private Properties createOutputProperties() {
        Properties third = new Properties();
        third.setProperty("encoding", "UTF-8");
        third.setProperty("method", XML_STRING);
        third.setProperty("indent", NO_STRING);
        third.setProperty("media-type", "text/xml");
        third.setProperty("omit-xml-declaration", NO_STRING);
        third.setProperty("version", "1.0");
        Properties second = new Properties(third);
        if (this._translet != null) {
            String value = this._translet._encoding;
            if (value != null) {
                second.setProperty("encoding", value);
            }
            if ((value = this._translet._method) != null) {
                second.setProperty("method", value);
            }
            if (this._translet._indent) {
                second.setProperty("indent", YES_STRING);
            } else {
                second.setProperty("indent", NO_STRING);
            }
            value = this._translet._doctypePublic;
            if (value != null) {
                second.setProperty("doctype-public", value);
            }
            if ((value = this._translet._doctypeSystem) != null) {
                second.setProperty("doctype-system", value);
            }
            if ((value = this.makeCDATAString(this._translet._cdata)) != null) {
                second.setProperty("cdata-section-elements", value);
            }
            if ((value = this._translet._mediaType) != null) {
                second.setProperty("media-type", value);
            }
            if (this._translet._omitHeader) {
                second.setProperty("omit-xml-declaration", YES_STRING);
            } else {
                second.setProperty("omit-xml-declaration", NO_STRING);
            }
            value = this._translet._standalone;
            if (value != null) {
                second.setProperty("standalone", value);
            }
            if ((value = this._translet._version) != null) {
                second.setProperty("version", value);
            }
        }
        return new Properties(second);
    }

    private boolean validOutputProperty(String name) {
        if (name.equals("encoding")) {
            return true;
        }
        if (name.equals("method")) {
            return true;
        }
        if (name.equals("indent")) {
            return true;
        }
        if (name.equals("doctype-public")) {
            return true;
        }
        if (name.equals("doctype-system")) {
            return true;
        }
        if (name.equals("cdata-section-elements")) {
            return true;
        }
        if (name.equals("media-type")) {
            return true;
        }
        if (name.equals("omit-xml-declaration")) {
            return true;
        }
        if (name.equals("standalone")) {
            return true;
        }
        if (name.equals("version")) {
            return true;
        }
        return name.charAt(0) == '{';
    }

    public void setParameter(String name, Object value) {
        this._translet.addParameter(name, value, false);
    }

    public void clearParameters() {
        this._translet.clearParameters();
    }

    public final Object getParameter(String name) {
        return this._translet.getParameter(name);
    }

    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this._uriResolver = resolver;
    }

    public DOMImpl retrieveDocument(String uri, int mask, Translet translet) {
        try {
            return this.getDOM(this._uriResolver.resolve(uri, EMPTY_STRING), mask);
        }
        catch (TransformerException e) {
            if (this._errorListener != null) {
                this.postErrorToListener("File not found: " + e.getMessage());
            }
            return null;
        }
    }

    public void error(TransformerException e) throws TransformerException {
        System.err.println("ERROR: " + e.getMessageAndLocation());
        throw e;
    }

    public void fatalError(TransformerException e) throws TransformerException {
        System.err.println("FATAL: " + e.getMessageAndLocation());
        Throwable wrapped = e.getException();
        if (wrapped != null) {
            System.err.println("     : " + wrapped.getMessage());
        }
        throw e;
    }

    public void warning(TransformerException e) throws TransformerException {
        System.err.println("WARNING: " + e.getMessageAndLocation());
        Throwable wrapped = e.getException();
        if (wrapped != null) {
            System.err.println("       : " + wrapped.getMessage());
        }
    }
}

