/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

public final class FuzzyTermEnum
extends FilteredTermEnum {
    double distance;
    boolean fieldMatch = false;
    boolean endEnum = false;
    Term searchTerm = null;
    String field = "";
    String text = "";
    int textlen;
    public static final double FUZZY_THRESHOLD = 0.5;
    public static final double SCALE_FACTOR = 2.0;
    private int[][] e = new int[0][0];

    public FuzzyTermEnum(IndexReader indexReader, Term term) throws IOException {
        super(indexReader, term);
        this.searchTerm = term;
        this.field = this.searchTerm.field();
        this.text = this.searchTerm.text();
        this.textlen = this.text.length();
        this.setEnum(indexReader.terms(new Term(this.searchTerm.field(), "")));
    }

    protected final boolean termCompare(Term term) {
        if (this.field == term.field()) {
            String string = term.text();
            int n = string.length();
            int n2 = this.editDistance(this.text, string, this.textlen, n);
            this.distance = 1.0 - (double)n2 / (double)Math.min(this.textlen, n);
            return this.distance > 0.5;
        }
        this.endEnum = true;
        return false;
    }

    protected final float difference() {
        return (float)((this.distance - 0.5) * 2.0);
    }

    public final boolean endEnum() {
        return this.endEnum;
    }

    private static final int min(int n, int n2, int n3) {
        int n4 = n < n2 ? n : n2;
        return n4 < n3 ? n4 : n3;
    }

    private final int editDistance(String string, String string2, int n, int n2) {
        if (this.e.length <= n || this.e[0].length <= n2) {
            this.e = new int[Math.max(this.e.length, n + 1)][Math.max(this.e.length, n2 + 1)];
        }
        int[][] nArray = this.e;
        if (n == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        int n3 = 0;
        while (n3 <= n) {
            nArray[n3][0] = n3;
            ++n3;
        }
        int n4 = 0;
        while (n4 <= n2) {
            nArray[0][n4] = n4;
            ++n4;
        }
        n3 = 1;
        while (n3 <= n) {
            char c = string.charAt(n3 - 1);
            n4 = 1;
            while (n4 <= n2) {
                nArray[n3][n4] = c != string2.charAt(n4 - 1) ? FuzzyTermEnum.min(nArray[n3 - 1][n4], nArray[n3][n4 - 1], nArray[n3 - 1][n4 - 1]) + 1 : FuzzyTermEnum.min(nArray[n3 - 1][n4] + 1, nArray[n3][n4 - 1] + 1, nArray[n3 - 1][n4 - 1]);
                ++n4;
            }
            ++n3;
        }
        return nArray[n][n2];
    }

    public void close() throws IOException {
        super.close();
        this.searchTerm = null;
        this.field = null;
        this.text = null;
    }
}

