/*
 * Decompiled with CFR 0.152.
 */
package com.datapower.xsltmark;

import com.datapower.xsltmark.XSLTDriver;
import com.datapower.xsltmark.XSLTDriverException;
import java.io.File;
import java.io.IOException;
import jd.xml.util.SaxUtil;
import jd.xml.util.XmlSource;
import jd.xml.xpath.model.ModelReader;
import jd.xml.xpath.model.XPathRootNode;
import jd.xml.xslt.Stylesheet;
import jd.xml.xslt.XsltResult;
import org.xml.sax.XMLReader;

public class JdXsltDriver
extends XSLTDriver {
    private Stylesheet stylesheet_;
    private XmlSource input_;
    private File dir_;
    private XMLReader xmlReader_;

    public void init(String[] stringArray) throws XSLTDriverException {
        try {
            this.xmlReader_ = SaxUtil.createXmlReader();
        }
        catch (Exception exception) {
            throw new XSLTDriverException(exception);
        }
    }

    public String getName() {
        return "jd.xslt XsltMarkDriver";
    }

    public boolean chdir(String string) {
        this.dir_ = new File(string);
        return true;
    }

    public boolean loadStylesheet(String string) {
        try {
            long l = System.currentTimeMillis();
            XmlSource xmlSource = this.getSource(string);
            xmlSource.setParser(this.xmlReader_);
            this.stylesheet_ = new Stylesheet();
            this.stylesheet_.setup(xmlSource);
            this.mPrepMillis = System.currentTimeMillis() - l;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            this.mPrepMillis = -1L;
            return false;
        }
    }

    public boolean loadInput(String string) {
        try {
            XmlSource xmlSource = this.getSource(string);
            ModelReader modelReader = new ModelReader(this.xmlReader_);
            XPathRootNode xPathRootNode = modelReader.read(xmlSource, this.stylesheet_.getNodeNamePool());
            this.input_ = new XmlSource(xmlSource.getUri(), xPathRootNode);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public boolean runTransform(String string, int n) {
        try {
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < n) {
                XsltResult xsltResult = new XsltResult(string);
                this.stylesheet_.transform(this.input_, xsltResult);
                ++n2;
            }
            this.mTransformMillis = System.currentTimeMillis() - l;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mTransformMillis = -1L;
            return false;
        }
    }

    public boolean shutdown() {
        return true;
    }

    private XmlSource getSource(String string) throws IOException {
        return new XmlSource(new File(this.dir_, string));
    }
}

