/*
 * Decompiled with CFR 0.152.
 */
package jd.util;

import java.io.FileInputStream;
import java.io.InputStream;
import jd.io.FileUtil;
import jd.util.BadArgException;

public class Arguments {
    private String[] args_;
    private int length_;
    private int pos_;

    public Arguments(String[] stringArray) throws BadArgException {
        this.args_ = stringArray != null ? stringArray : new String[]{};
        this.length_ = this.args_.length;
        int n = 0;
        while (n < this.length_) {
            if (this.args_[n] == null) {
                throw new IllegalArgumentException("argument " + n + " is null");
            }
            if (this.args_[n].length() == 0) {
                throw new IllegalArgumentException("argument " + n + " has zero length");
            }
            if (this.args_[n].charAt(0) == '@' && this.args_[n].length() > 1) {
                this.insertArgumentFile(n);
                --n;
            }
            ++n;
        }
    }

    private void insertArgumentFile(int n) throws BadArgException {
        String string = this.args_[n].substring(1);
        InputStream inputStream = null;
        try {
            try {
                inputStream = ClassLoader.getSystemResourceAsStream(string);
                if (inputStream == null) {
                    inputStream = new FileInputStream(string);
                }
                String[] stringArray = FileUtil.readLines(inputStream, true);
                String[] stringArray2 = new String[this.length_ + stringArray.length - 1];
                System.arraycopy(this.args_, 0, stringArray2, 0, n);
                System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
                System.arraycopy(this.args_, n + 1, stringArray2, n + stringArray.length, this.length_ - n - 1);
                this.length_ = stringArray2.length;
                this.args_ = stringArray2;
            }
            catch (Exception exception) {
                throw new BadArgException("Cannot read argument file " + string, exception);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            FileUtil.close(inputStream);
            throw throwable;
        }
        FileUtil.close(inputStream);
    }

    public String next() {
        return this.hasMore() ? this.args_[this.pos_++] : null;
    }

    public String next(String string) throws BadArgException {
        String string2 = this.next();
        if (string2 == null) {
            throw new BadArgException(string);
        }
        return string2;
    }

    public boolean match(String string) {
        if (this.hasMore() && this.args_[this.pos_].equals(string)) {
            ++this.pos_;
            return true;
        }
        return false;
    }

    public boolean startsWith(String string) {
        return this.hasMore() && this.args_[this.pos_].startsWith(string);
    }

    public boolean hasMore() {
        return this.pos_ < this.length_;
    }

    public boolean hasMore(int n) {
        return this.pos_ + n <= this.length_;
    }
}

