/*
 * Decompiled with CFR 0.152.
 */
package jd.util;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Locale;
import jd.util.Date;
import jd.util.StringUtil;

public class DateFormat {
    public static final char SYMBOL_MONTH = 'M';
    public static final char SYMBOL_DAY = 'd';
    public static final char SYMBOL_YEAR = 'y';
    private int dayPosition_;
    private int monthPosition_;
    private int yearPosition_;
    private char separatorSymbol_;
    private DateFormatSymbols symbols_;
    private static Hashtable instances_ = new Hashtable(1);

    public static DateFormat getDefaultFormat() {
        return DateFormat.getFormat(Locale.getDefault());
    }

    public static DateFormat getFormat(String string) {
        return DateFormat.getFormat(string, "");
    }

    public static DateFormat getFormat(String string, String string2) {
        Locale locale = new Locale(string, string2);
        return DateFormat.getFormat(locale);
    }

    public static DateFormat getFormat(Locale locale) {
        DateFormat dateFormat = (DateFormat)instances_.get(locale);
        if (dateFormat == null) {
            dateFormat = new DateFormat(locale);
            instances_.put(locale, dateFormat);
        }
        return dateFormat;
    }

    private DateFormat(Locale locale) {
        SimpleDateFormat simpleDateFormat = this.getSimpleDateFormat(locale);
        this.symbols_ = simpleDateFormat.getDateFormatSymbols();
        String string = simpleDateFormat.toPattern();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (Character.isLetter(c)) {
                switch (c) {
                    case 'd': {
                        this.dayPosition_ = n2;
                        break;
                    }
                    case 'M': {
                        this.monthPosition_ = n2;
                        break;
                    }
                    case 'y': {
                        this.yearPosition_ = n2;
                    }
                }
            } else {
                this.separatorSymbol_ = c;
                ++n2;
            }
            ++n3;
        }
    }

    private SimpleDateFormat getSimpleDateFormat(Locale locale) {
        try {
            return (SimpleDateFormat)java.text.DateFormat.getDateInstance(3, locale);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("cannot create a SimpleDateFormat for locale " + locale);
        }
    }

    public char getSeparatorSymbol() {
        return this.separatorSymbol_;
    }

    public int getDayPosition() {
        return this.dayPosition_;
    }

    public int getMonthPosition() {
        return this.monthPosition_;
    }

    public int getYearPosition() {
        return this.yearPosition_;
    }

    public String getMonthName(int n) {
        return this.getName(this.symbols_.getMonths(), n - 1);
    }

    public String getShortMonthName(int n) {
        return this.getName(this.symbols_.getShortMonths(), n - 1);
    }

    public String getWeekdayName(int n) {
        return this.getName(this.symbols_.getWeekdays(), n);
    }

    public String getShortWeekdayName(int n) {
        return this.getName(this.symbols_.getShortWeekdays(), n);
    }

    private String getName(String[] stringArray, int n) {
        try {
            return stringArray[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid index " + n);
        }
    }

    public Date parse(String string) throws ParseException {
        int[] nArray = new int[3];
        int n = this.parseValues(string, nArray);
        if (n >= 0) {
            throw new ParseException("'" + string + "' has an invalid date format", n);
        }
        int n2 = nArray[this.dayPosition_];
        int n3 = nArray[this.monthPosition_];
        int n4 = nArray[this.yearPosition_];
        try {
            return new Date(n4, n3, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("'" + string + "' is an invalid date", 0);
        }
    }

    private int parseValues(String string, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < 3) {
            if (n >= n2) {
                return n;
            }
            int n4 = n;
            stringBuffer.setLength(0);
            while (n4 < n2) {
                char c;
                if ((c = string.charAt(n4++)) == this.separatorSymbol_) break;
                if (c == ' ') continue;
                stringBuffer.append(c);
            }
            try {
                nArray[n3] = Integer.parseInt(stringBuffer.toString());
            }
            catch (Exception exception) {
                return n;
            }
            n = n4;
            ++n3;
        }
        return -1;
    }

    public String format(Date date) {
        return this.format(date.getYear(), date.getMonth(), date.getDay());
    }

    public void format(Date date, StringBuffer stringBuffer) {
        this.format(date.getYear(), date.getMonth(), date.getDay(), stringBuffer);
    }

    public void format(Date date, StringBuffer stringBuffer, char c) {
        this.format(date.getYear(), date.getMonth(), date.getDay(), stringBuffer, c);
    }

    public String format(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(10);
        this.format(n, n2, n3, stringBuffer, '@');
        return stringBuffer.toString();
    }

    public void format(int n, int n2, int n3, StringBuffer stringBuffer) {
        this.format(n, n2, n3, stringBuffer, '@');
    }

    public void format(int n, int n2, int n3, StringBuffer stringBuffer, char n4) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException("StringBuffer is null");
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < 3) {
            int n7 = -1;
            int n8 = 2;
            int n9 = 64;
            if (this.dayPosition_ == n6) {
                n7 = n3;
                n9 = 100;
            } else if (this.monthPosition_ == n6) {
                n7 = n2;
                n9 = 77;
            } else if (this.yearPosition_ == n6) {
                n7 = n;
                n9 = 121;
                n8 = 4;
            }
            if (n4 != n9) {
                if (n5 > 0 && n5 <= 2) {
                    stringBuffer.append(this.separatorSymbol_);
                }
                stringBuffer.append(StringUtil.fillupLeft(String.valueOf(n7), n8, '0'));
                ++n5;
            }
            ++n6;
        }
    }
}

