/*
 * Decompiled with CFR 0.152.
 */
package jd.util;

public final class IntValHashtable
implements Cloneable {
    private transient Entry[] table_;
    private transient int count_;
    private int threshold_;
    private float loadFactor_;

    public IntValHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor_ = f;
        this.table_ = new Entry[n];
        this.threshold_ = (int)((float)n * this.loadFactor_);
    }

    public IntValHashtable(int n) {
        this(n, 0.75f);
    }

    public IntValHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count_;
    }

    public boolean containsKey(Object object) {
        Entry[] entryArray = this.table_;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int get(Object object) {
        Entry[] entryArray = this.table_;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return Integer.MIN_VALUE;
    }

    protected void rehash() {
        int n = this.table_.length;
        Entry[] entryArray = this.table_;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold_ = (int)((float)n2 * this.loadFactor_);
        this.table_ = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public int put(Object object, int n) {
        if (n == Integer.MIN_VALUE) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table_;
        int n2 = object.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(object)) {
                int n4 = entry.value;
                entry.value = n;
                return n4;
            }
            entry = entry.next;
        }
        if (this.count_ >= this.threshold_) {
            this.rehash();
            return this.put(object, n);
        }
        Entry entry2 = new Entry();
        entry2.hash = n2;
        entry2.key = object;
        entry2.value = n;
        entry2.next = entryArray[n3];
        entryArray[n3] = entry2;
        ++this.count_;
        return Integer.MIN_VALUE;
    }

    public int remove(Object object) {
        Entry[] entryArray = this.table_;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count_;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return Integer.MIN_VALUE;
    }

    public void clear() {
        Entry[] entryArray = this.table_;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count_ = 0;
    }

    public Object clone() {
        try {
            IntValHashtable intValHashtable = (IntValHashtable)super.clone();
            intValHashtable.table_ = new Entry[this.table_.length];
            int n = this.table_.length;
            while (n-- > 0) {
                Entry entry = intValHashtable.table_[n] = this.table_[n] != null ? (Entry)this.table_[n].clone() : null;
            }
            return intValHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private static class Entry {
        int hash;
        Object key;
        int value;
        Entry next;

        private Entry() {
        }

        protected Object clone() {
            Entry entry = new Entry();
            entry.hash = this.hash;
            entry.key = this.key;
            entry.value = this.value;
            entry.next = this.next != null ? (Entry)this.next.clone() : null;
            return entry;
        }
    }
}

