/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model;

import java.io.IOException;
import jd.xml.util.XmlSource;
import jd.xml.xpath.XPathException;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xpath.model.XPathRootNode;
import jd.xml.xpath.model.build.ModelBuilder;
import jd.xml.xpath.model.build.ModelBuilderFactory;
import jd.xml.xpath.model.parse.ParseHandler;
import jd.xml.xpath.model.parse.ParseHandlerFactory;
import org.xml.sax.SAXException;

public class ModelReader {
    private int nextDocumentId_;
    private boolean collectLineNumbers_;
    private ParseHandler parseHandler_;
    private ModelBuilder modelBuilder_;
    private boolean isExternalModelBuilder_;

    public ModelReader() throws SAXException {
        this(null);
    }

    public ModelReader(Object object) throws SAXException {
        this.parseHandler_ = ParseHandlerFactory.createHandler(object);
    }

    public synchronized void setParser(Object object) throws SAXException {
        if (object == null) {
            throw new IllegalArgumentException("parser is null");
        }
        if (this.parseHandler_.getParser() != object) {
            ParseHandler parseHandler = this.parseHandler_;
            this.parseHandler_ = ParseHandlerFactory.createHandler(object);
            this.parseHandler_.setValidating(parseHandler.isValidating());
            this.parseHandler_.setEntityResolver(parseHandler.getEntityResolver());
        }
    }

    public ParseHandler getParseHandler() {
        return this.parseHandler_;
    }

    public void setModelBuilder(ModelBuilder modelBuilder) {
        this.modelBuilder_ = modelBuilder;
        this.isExternalModelBuilder_ = modelBuilder != null;
    }

    public void setNextDocumentId(int n) {
        this.nextDocumentId_ = n;
    }

    public void collectLineNumbers(boolean bl) {
        this.collectLineNumbers_ = bl;
    }

    public XPathRootNode read(String string) throws IOException, SAXException {
        return this.read(new XmlSource(string), null);
    }

    public XPathRootNode read(XmlSource xmlSource) throws IOException, SAXException {
        return this.read(xmlSource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XPathRootNode read(XmlSource xmlSource, NodeNamePool nodeNamePool) throws IOException, SAXException, XPathException {
        if (xmlSource == null) {
            throw new XPathException("source is null");
        }
        try {
            Object object;
            XPathRootNode xPathRootNode = this.readInternal(xmlSource, nodeNamePool);
            String string = xmlSource.getUri();
            int n = string.indexOf(35);
            if (n != -1 && (xPathRootNode = xPathRootNode.getFragment((String)(object = string.substring(n + 1)))) == null) {
                throw new SAXException("cannot resolve fragment id '" + (String)object + "' in '" + string + "'");
            }
            object = xPathRootNode;
            Object var8_7 = null;
            xmlSource.cleanup();
            return object;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            xmlSource.cleanup();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized XPathRootNode readInternal(XmlSource xmlSource, NodeNamePool nodeNamePool) throws IOException, SAXException, XPathException {
        if (nodeNamePool == null) {
            nodeNamePool = new NodeNamePool();
        }
        if (!this.isExternalModelBuilder_) {
            this.modelBuilder_ = ModelBuilderFactory.getModelBuilder(xmlSource, this.modelBuilder_);
        }
        try {
            XPathRootNode xPathRootNode;
            try {
                xPathRootNode = this.parseHandler_.parse(xmlSource, nodeNamePool, this.modelBuilder_, this.nextDocumentId_++, this.collectLineNumbers_);
                Object var8_5 = null;
            }
            catch (SAXException sAXException) {
                throw sAXException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (XPathException xPathException) {
                throw xPathException;
            }
            catch (Exception exception) {
                throw new XPathException("cannot read the model", exception);
            }
            this.modelBuilder_.cleanup();
            return xPathRootNode;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.modelBuilder_.cleanup();
            throw throwable;
        }
    }

    public XPathRootNode getTextNodeFragment(String string, NodeNamePool nodeNamePool) {
        return ModelBuilderFactory.getInstance().createTextNodeFragment(string, nodeNamePool, this.nextDocumentId_++);
    }
}

