/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model.parse;

import jd.xml.util.XmlSource;
import jd.xml.xpath.model.NodeName;
import jd.xml.xpath.model.parse.ParseHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PullParseHandler
extends ParseHandler {
    private String baseUri_;
    private XmlPullParser parser_;
    private EntityResolver entityResolver_;

    public PullParseHandler(Object object) {
        this((XmlPullParser)object);
    }

    public PullParseHandler(XmlPullParser xmlPullParser) {
        this.parser_ = xmlPullParser;
        this.setFeature("http://xmlpull.org/v1/doc/features.html#process-docdecl", true);
        this.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
    }

    public void setValidating(boolean bl) {
        this.setFeature("http://xmlpull.org/v1/doc/features.html#validation", bl);
    }

    public boolean isValidating() {
        return this.parser_.getFeature("http://xmlpull.org/v1/doc/features.html#validation");
    }

    private void setFeature(String string, boolean bl) {
        try {
            this.parser_.setFeature(string, bl);
        }
        catch (XmlPullParserException xmlPullParserException) {
            // empty catch block
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver_ = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver_;
    }

    public Object getParser() {
        return this.parser_;
    }

    protected void parse(XmlSource xmlSource) throws Exception {
        this.baseUri_ = xmlSource.getUri();
        InputSource inputSource = xmlSource.getInputSource();
        if (inputSource.getCharacterStream() != null) {
            this.parser_.setInput(inputSource.getCharacterStream());
        } else if (inputSource.getByteStream() != null) {
            this.parser_.setInput(inputSource.getByteStream(), inputSource.getEncoding());
        } else {
            throw new IllegalStateException("no InputStream available for " + this.baseUri_);
        }
        XmlPullParser xmlPullParser = this.parser_;
        int n = xmlPullParser.getEventType();
        while (n != 1) {
            switch (n) {
                case 2: {
                    this.startElement();
                    break;
                }
                case 3: {
                    this.flushTextNode();
                    this.popPreserveWhitespace();
                    this.modelBuilder_.endElement();
                    break;
                }
                case 4: {
                    this.text_.appendTested(xmlPullParser.getText());
                    break;
                }
                case 7: {
                    this.text_.append(xmlPullParser.getText());
                    break;
                }
                case 9: {
                    this.flushTextNode();
                    this.modelBuilder_.addComment(xmlPullParser.getText());
                    break;
                }
                case 8: {
                    this.addProcessingInstruction();
                }
            }
            n = xmlPullParser.next();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void startElement() throws SAXException {
        block8: {
            var1_1 = this.parser_;
            this.flushTextNode();
            var2_2 = var1_1.getAttributeCount();
            var3_3 = 0;
            if (var2_2 <= 0) break block8;
            this.elementInfo_.ensureAttrCapacity(var2_2);
            var4_4 = 0;
            while (var4_4 < var2_2) {
                this.elementInfo_.attrValues[var4_4] = null;
                var5_5 = var1_1.getAttributeName(var4_4);
                if (!var5_5.startsWith("xmlns")) ** GOTO lbl-1000
                var6_6 = var1_1.getAttributeValue(var4_4);
                if (var5_5.length() == 5) {
                    this.modelBuilder_.addNamespaceMapping("", var6_6);
                    this.elementInfo_.attrValues[var4_4] = var6_6;
                } else if (var5_5.charAt(5) == ':') {
                    this.modelBuilder_.addNamespaceMapping(var5_5.substring(6), var6_6);
                    this.elementInfo_.attrValues[var4_4] = var6_6;
                } else lbl-1000:
                // 2 sources

                {
                    ++var3_3;
                }
                ++var4_4;
            }
        }
        this.elementInfo_.setName(this.getNodeName(var1_1.getName(), true));
        if (var3_3 > 0) {
            var4_4 = 0;
            while (this.elementInfo_.attrCount < var3_3) {
                if (this.elementInfo_.attrValues[var4_4] == null) {
                    var5_5 = this.getNodeName(var1_1.getAttributeName(var4_4), false);
                    this.elementInfo_.addAttribute((NodeName)var5_5, var1_1.getAttributeValue(var4_4), var1_1.getAttributeType(var4_4));
                }
                ++var4_4;
            }
        }
        this.modelBuilder_.startElement(this.elementInfo_);
        this.pushPreserveWhitespace(this.elementInfo_.preserveSpace);
    }

    private void addProcessingInstruction() {
        this.flushTextNode();
        String string = this.parser_.getText();
        int n = string.length();
        int n2 = 1;
        while (n2 < n) {
            if (Character.isWhitespace(string.charAt(n2))) {
                this.modelBuilder_.addProcessingInstruction(string.substring(0, n2), string.substring(n2 + 1).trim());
                return;
            }
            ++n2;
        }
        this.modelBuilder_.addProcessingInstruction(string, "");
    }

    public int getLineNumber() {
        return this.parser_.getLineNumber();
    }
}

