/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt;

import java.io.IOException;
import java.util.Vector;
import jd.util.BadArgException;
import jd.xml.util.UriResolver;
import jd.xml.util.XmlSource;
import jd.xml.xpath.XPathException;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.object.XObject;
import jd.xml.xpath.parser.ExpressionParser;
import jd.xml.xpath.parser.XPathParseException;
import jd.xml.xslt.AbstractStylesheet;
import jd.xml.xslt.CommandLine;
import jd.xml.xslt.IdentityTransformation;
import jd.xml.xslt.Transformation;
import jd.xml.xslt.TransformationChain;
import jd.xml.xslt.XsltContext;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.extension.ExtensionHandler;
import jd.xml.xslt.parser.StylesheetData;
import jd.xml.xslt.parser.StylesheetParser;
import jd.xml.xslt.parser.XsltParseException;
import jd.xml.xslt.result.ResultBuilder;
import jd.xml.xslt.template.OutputFormatTemplate;
import jd.xml.xslt.template.TemplateRule;
import jd.xml.xslt.template.TemplateRuleList;
import jd.xml.xslt.template.Variable;
import jd.xml.xslt.trace.TraceParseListener;
import jd.xml.xslt.trace.Tracer;
import jd.xml.xslt.util.ModelCache;
import jd.xml.xslt.util.VerboseLog;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class Stylesheet
extends AbstractStylesheet {
    public static final String VERSION = "1.5.5";
    private boolean validate_;
    private UriResolver uriResolver_;
    private EntityResolver entityResolver_;
    private TemplateRuleList defaultTemplateRules_;
    private Variable[] globalVariables_;
    private XObject[] globalParamValues_;
    private OutputFormatTemplate outputFormatTemplate_;
    private ExtensionHandler[] extensionHandlers_;
    private int globalVariableCount_;
    private int maxLocalVariableCount_;
    private int firstUnclassifiedGlobalVar_;
    private ModelCache modelCache_;
    private Tracer tracer_;
    static /* synthetic */ Class class$jd$xml$xslt$Stylesheet;

    public void setup(XmlSource xmlSource) throws IOException, SAXException, XsltParseException {
        StylesheetParser stylesheetParser = new StylesheetParser(this.securityManager_);
        stylesheetParser.setUriResolver(this.uriResolver_);
        stylesheetParser.setEntityResolver(this.entityResolver_);
        stylesheetParser.setVerboseLog(this.verboseLog_);
        if (this.tracer_ != null) {
            stylesheetParser.setParseListener(new TraceParseListener(this.tracer_));
        }
        this.setup(stylesheetParser.parseStylesheet(xmlSource));
    }

    public void setup(StylesheetData stylesheetData) {
        this.decimalFormatSymbols_ = stylesheetData.getDecimalFormatSymbols();
        this.globalVariables_ = stylesheetData.getGlobalVariables();
        this.firstUnclassifiedGlobalVar_ = stylesheetData.firstUnClassifiedGlobalVar();
        this.globalVariableCount_ = this.globalVariables_.length;
        this.maxLocalVariableCount_ = stylesheetData.getMaxLocalVariableCount();
        this.keys_ = stylesheetData.getKeys();
        this.outputFormatTemplate_ = stylesheetData.getOutputFormatTemplate();
        this.extensionHandlers_ = stylesheetData.getExtensionHandlers();
        this.defaultTemplateRules_ = stylesheetData.getDefaultTemplateRuleList();
        this.nodeNamePool_ = stylesheetData.getNodeNamePool();
        this.outputFormatTemplate_.initOutputFormat(null, this.outputFormat_);
    }

    protected boolean isSetup() {
        return this.defaultTemplateRules_ != null;
    }

    protected boolean setParameterInternal(String string, XObject xObject) {
        int n = 0;
        while (n < this.globalVariables_.length) {
            Variable variable = this.globalVariables_[n];
            if (variable.isParameter() && string.equals(variable.getVariableName().getName())) {
                int n2 = variable.getVariableName().getIndex();
                this.getGlobalParamValues()[n2] = xObject;
                return true;
            }
            ++n;
        }
        return false;
    }

    private XObject[] getGlobalParamValues() {
        if (this.globalParamValues_ == null) {
            this.globalParamValues_ = new XObject[this.globalVariableCount_];
        }
        return this.globalParamValues_;
    }

    public void clearParameters() {
        this.globalParamValues_ = null;
    }

    public void setUriResolver(UriResolver uriResolver) {
        this.uriResolver_ = uriResolver;
        if (this.modelCache_ != null) {
            this.modelCache_.setUriResolver(uriResolver);
        }
    }

    public void setValidate(boolean bl) {
        this.validate_ = bl;
        if (this.modelCache_ != null) {
            this.modelCache_.getParseHandler().setValidating(bl);
        }
    }

    public void setTrace(boolean bl) {
        this.tracer_ = bl ? new Tracer() : null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver_ = entityResolver;
        if (this.modelCache_ != null) {
            this.modelCache_.getParseHandler().setEntityResolver(entityResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transformInternal(XmlSource xmlSource, XsltResult xsltResult, int n) throws Exception {
        int n2 = Math.max(1, n);
        int n3 = Math.max(1, -n);
        ModelCache modelCache = null;
        XsltContext xsltContext = null;
        int n4 = 0;
        while (n4 < n2) {
            Object var11_11;
            try {
                if (n4 > 0) {
                    xmlSource.reset();
                }
                modelCache = this.createModelCache(xmlSource);
                xsltContext = this.createContext(modelCache);
                int n5 = 0;
                while (n5 < n3) {
                    if (this.verboseLog_ != null) {
                        this.verboseLog_.transformTiming.startTimer();
                    }
                    if (n4 > 0 || n5 > 0) {
                        xsltResult.reset();
                    }
                    this.transformInternal(xsltContext, xsltResult);
                    if (this.verboseLog_ != null) {
                        this.verboseLog_.transformTiming.stopTimer();
                    }
                    ++n5;
                }
                var11_11 = null;
                xmlSource.cleanup();
                if (modelCache != null) {
                    modelCache.cleanup();
                }
            }
            catch (Throwable throwable) {
                var11_11 = null;
                xmlSource.cleanup();
                if (modelCache != null) {
                    modelCache.cleanup();
                }
                throw throwable;
            }
            ++n4;
        }
        if (modelCache != null) {
            Stylesheet stylesheet = this;
            synchronized (stylesheet) {
                this.modelCache_ = modelCache;
            }
        }
        if (this.verboseLog_ != null) {
            this.verboseLog_.printTiming();
            this.verboseLog_.printMemory(xsltContext.getMaxMemory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformInternal(XsltContext xsltContext, XsltResult xsltResult) throws Exception {
        ResultBuilder resultBuilder = null;
        try {
            TemplateRule templateRule;
            resultBuilder = xsltResult.getResultBuilder(this.outputFormat_);
            resultBuilder.startDocument(this.outputFormat_);
            if (this.tracer_ != null) {
                this.tracer_.start();
            }
            if ((templateRule = this.defaultTemplateRules_.getMatchingRule(xsltContext, Integer.MAX_VALUE, resultBuilder)) != null) {
                templateRule.applyTemplate(xsltContext, resultBuilder, null, null);
            }
            if (this.tracer_ != null) {
                this.tracer_.end();
            }
            resultBuilder.endDocument();
            Object var6_5 = null;
            if (resultBuilder != null) {
                resultBuilder.cleanup();
                resultBuilder = null;
            } else {
                xsltResult.cleanup();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (resultBuilder != null) {
                resultBuilder.cleanup();
                resultBuilder = null;
            } else {
                xsltResult.cleanup();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelCache createModelCache(XmlSource xmlSource) throws IOException, SAXException, XsltException {
        if (this.verboseLog_ != null) {
            this.verboseLog_.modelTiming.startTimer();
        }
        ModelCache modelCache = null;
        Stylesheet stylesheet = this;
        synchronized (stylesheet) {
            if (this.modelCache_ != null) {
                modelCache = this.modelCache_;
                this.modelCache_ = null;
            }
        }
        if (modelCache == null) {
            modelCache = new ModelCache(this.nodeNamePool_, xmlSource.getParser());
            modelCache.setUriResolver(this.uriResolver_);
            if (this.entityResolver_ != null) {
                modelCache.getParseHandler().setEntityResolver(this.entityResolver_);
            }
            if (this.validate_) {
                modelCache.getParseHandler().setValidating(true);
            }
        } else if (xmlSource.getParser() != null) {
            modelCache.getModelReader().setParser(xmlSource.getParser());
        }
        modelCache.initMainModel(xmlSource);
        if (this.verboseLog_ != null) {
            this.verboseLog_.modelTiming.stopTimer();
            this.verboseLog_.setModelName(modelCache.getMainModel().getModelName());
        }
        return modelCache;
    }

    private XsltContext createContext(ModelCache modelCache) throws IOException, SAXException, XsltException {
        XsltContext xsltContext = new XsltContext(modelCache, this.messageListener_, this.securityManager_, this.decimalFormatSymbols_, this.extensionHandlers_, this.keys_, this.warningLevel_, this.maxLocalVariableCount_, this.getGlobalParamValues(), this.outputFormat_, this.verboseLog_ != null);
        this.initClassifiedGlobalVariables(xsltContext);
        this.initUnclassifiedGlobalVariables(xsltContext);
        this.outputFormatTemplate_.initOutputFormat(xsltContext, this.outputFormat_);
        return xsltContext;
    }

    private void initClassifiedGlobalVariables(XsltContext xsltContext) {
        int n = 0;
        while (n < this.firstUnclassifiedGlobalVar_) {
            Variable variable = this.globalVariables_[n];
            XObject xObject = variable.getValue(xsltContext);
            if (xsltContext.getVariable(variable.getVariableName()) == null) {
                xsltContext.setGlobalVariable(variable.getVariableName().getIndex(), xObject);
            }
            ++n;
        }
    }

    private void initUnclassifiedGlobalVariables(XsltContext xsltContext) {
        int n = this.globalVariables_.length - this.firstUnclassifiedGlobalVar_;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            int n3 = 0;
            int n4 = this.firstUnclassifiedGlobalVar_;
            while (n4 < this.globalVariables_.length) {
                Variable variable = this.globalVariables_[n4];
                if (xsltContext.getVariable(variable.getVariableName()) != null) {
                    ++n3;
                } else {
                    try {
                        object = variable.getValue(xsltContext);
                        xsltContext.setGlobalVariable(variable.getVariableName().getIndex(), (XObject)object);
                        ++n3;
                    }
                    catch (XPathException xPathException) {
                        // empty catch block
                    }
                }
                ++n4;
            }
            if (n2 == n3) {
                int n5 = this.firstUnclassifiedGlobalVar_;
                while (n5 < this.globalVariables_.length) {
                    object = this.globalVariables_[n5];
                    if (xsltContext.getVariable(((Variable)object).getVariableName()) == null) {
                        throw new XsltException("global variable '" + ((Variable)object).getVariableName().getName() + "' has a cyclic dependency to other variables.");
                    }
                    ++n5;
                }
            }
            n2 = n3;
        }
    }

    public static void main(String[] stringArray) {
        new CmdLine().evaluateAndExit(stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class CmdLine
    extends CommandLine {
        protected XObject getParamExpressionValue(String string) {
            try {
                ExpressionParser expressionParser = new ExpressionParser();
                Expression expression = expressionParser.parseExpression(string);
                if (expression.getContextDependencies() != 0) {
                    throw new BadArgException("parameter expression '" + expression + "' has context dependencies and cannot be evaluated");
                }
                return expression.toXObject(null);
            }
            catch (XPathParseException xPathParseException) {
                throw new BadArgException("invalid parameter expression '" + string + "': " + xPathParseException);
            }
        }

        protected Transformation getTransformation(Vector vector) throws Exception {
            switch (vector.size()) {
                case 0: {
                    XmlSource xmlSource = this.getAssocStylesheetSource();
                    return this.createTransformation(xmlSource);
                }
                case 1: {
                    return this.createTransformation((String)vector.elementAt(0));
                }
            }
            TransformationChain transformationChain = new TransformationChain();
            this.setTransformationOptions(transformationChain);
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                transformationChain.addTransformation(this.createTransformation(string));
                ++n;
            }
            return transformationChain;
        }

        private Transformation createTransformation(String string) throws Exception {
            if (string.equals("urn:jdxslt:identity")) {
                IdentityTransformation identityTransformation = new IdentityTransformation();
                this.setTransformationOptions(identityTransformation);
                return identityTransformation;
            }
            return this.createTransformation(this.getSource(string));
        }

        private Transformation createTransformation(XmlSource xmlSource) throws Exception {
            Stylesheet stylesheet = new Stylesheet();
            this.setTransformationOptions(stylesheet);
            stylesheet.setup(xmlSource);
            return stylesheet;
        }

        protected void printTransformationInfo(VerboseLog verboseLog) {
            verboseLog.println("jd.xslt processor version 1.5.5");
        }

        protected void printHelp() {
            System.out.println();
            System.out.println("jd.xslt processor version 1.5.5");
            System.out.println();
            System.out.println("Usage: java " + (class$jd$xml$xslt$Stylesheet == null ? (class$jd$xml$xslt$Stylesheet = Stylesheet.class$("jd.xml.xslt.Stylesheet")) : class$jd$xml$xslt$Stylesheet).getName() + " [options] xml [xsl...]");
            System.out.println();
            this.printHelpLine("xml", "the uri of an input xml document, \"-\" for STDIN");
            this.printHelpLine("xsl...", "zero or more uris of stylesheets - if their number is");
            this.printHelpLine(null, "= 0: use the associated stylesheets of the xml document");
            this.printHelpLine(null, "= 1: transform the input with that stylesheet");
            this.printHelpLine(null, "> 1: chain the transformations");
            this.printHelpLine(null, "the uri \"urn:jdxslt:identity\" denotes the identity");
            this.printHelpLine(null, "transformation");
            this.printOptionsHelp(true, true);
        }
    }
}

