/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.format;

import java.util.Hashtable;
import java.util.Vector;
import jd.io.Encoding;
import jd.xml.xslt.XsltException;

public class OutputFormat {
    private static final String[] OPTION_NAMES = new String[]{"method", "indent", "encoding", "omit-xml-declaration", "standalone", "doctype-public", "doctype-system", "media-type", "version"};
    public static final int OPTION_METHOD = 0;
    public static final int OPTION_INDENT = 1;
    public static final int OPTION_ENCODING = 2;
    public static final int OPTION_OMIT_XML_DECL = 3;
    public static final int OPTION_STANDALONE = 4;
    public static final int OPTION_DOCTYPE_PUBLIC = 5;
    public static final int OPTION_DOCTYPE_SYSTEM = 6;
    public static final int OPTION_MEDIA_TYPE = 7;
    public static final int OPTION_VERSION = 8;
    public static final int OPTIONS = 9;
    public static final String METHOD_XML = "xml";
    public static final String METHOD_HTML = "html";
    public static final String METHOD_TEXT = "text";
    public static final String METHOD_CANONICAL_XML = "canonical-xml";
    public static final String METHOD_EMPTY = "empty";
    public static final String METHOD_DEFAULT = null;
    private static final String[] METHOD_NAMES = new String[]{"xml", "html", "text", "canonical-xml", "empty"};
    private Hashtable cdataSectionElements_;
    private String[] optionStrings_ = new String[9];
    private Object[] optionValues_ = new Object[9];

    public static String getOptionName(int n) {
        return OPTION_NAMES[n];
    }

    public static int getOptionIndex(String string) {
        return OutputFormat.getIndex(OPTION_NAMES, string);
    }

    private static int getValidOptionIndex(String string) {
        int n = OutputFormat.getOptionIndex(string);
        if (n == -1) {
            throw new XsltException("invalid output option '" + string + "'");
        }
        return n;
    }

    public void setOption(int n, String string) {
        Object object;
        switch (n) {
            case 0: {
                object = this.getMethodValue(string);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                object = this.getBooleanValue(n, string);
                break;
            }
            case 2: {
                object = Encoding.forName(string);
                break;
            }
            default: {
                object = string;
            }
        }
        this.optionStrings_[n] = string;
        this.optionValues_[n] = object;
    }

    public void setOption(String string, String string2) {
        int n = OutputFormat.getOptionIndex(string);
        if (n != -1) {
            this.setOption(n, string2);
        } else {
            if (string.equals("cdata-section-elements")) {
                throw new XsltException("dynamic cdata-section-elements not supported");
            }
            if (string.charAt(0) != '{') {
                throw new XsltException("unrecognized output property '" + string + "'");
            }
        }
    }

    public String getOption(int n) {
        return this.optionStrings_[n];
    }

    private Object getOptionValue(int n) {
        return this.optionValues_[n];
    }

    private Object getOptionValue(int n, Object object) {
        Object object2 = this.optionValues_[n];
        return object2 != null ? object2 : object;
    }

    private boolean getOptionValue(int n, boolean bl) {
        Boolean bl2 = (Boolean)this.optionValues_[n];
        return bl2 != null ? bl2 : bl;
    }

    public static boolean isStandardMethod(String string) {
        return string.equals(METHOD_XML) || string.equals(METHOD_HTML) || string.equals(METHOD_TEXT);
    }

    public String getMethod() {
        return (String)this.getOptionValue(0);
    }

    public String getVersion(String string) {
        return (String)this.getOptionValue(8, string);
    }

    public boolean getIndent(boolean bl) {
        return this.getOptionValue(1, bl);
    }

    public Encoding getEncoding(Encoding encoding) {
        return (Encoding)this.getOptionValue(2, encoding);
    }

    public String getMediaType(String string) {
        return (String)this.getOptionValue(7, string);
    }

    public String getDocTypeSystem() {
        return this.getOption(6);
    }

    public String getDocTypePublic() {
        return this.getOption(5);
    }

    public boolean getOmitXmlDeclaration(boolean bl) {
        return this.getOptionValue(3, bl);
    }

    public Boolean getStandalone() {
        return (Boolean)this.getOptionValue(4);
    }

    public void setCDataSectionElements(Hashtable hashtable) {
        this.cdataSectionElements_ = hashtable;
    }

    public boolean isCDataSectionElement(String string, String string2) {
        if (this.cdataSectionElements_ == null) {
            return false;
        }
        Vector vector = (Vector)this.cdataSectionElements_.get(string2);
        return vector != null && vector.contains(string);
    }

    public void copyFrom(OutputFormat outputFormat) {
        int n = 0;
        while (n < 9) {
            if (outputFormat.optionStrings_[n] != null) {
                this.optionStrings_[n] = outputFormat.optionStrings_[n];
                this.optionValues_[n] = outputFormat.optionValues_[n];
            }
            ++n;
        }
        if (outputFormat.cdataSectionElements_ != null) {
            this.cdataSectionElements_ = (Hashtable)outputFormat.cdataSectionElements_.clone();
        }
    }

    private Boolean getBooleanValue(int n, String string) {
        if (string == null) {
            return null;
        }
        if ("yes".equals(string)) {
            return Boolean.TRUE;
        }
        if ("no".equals(string)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("value for output option '" + OPTION_NAMES[n] + "' must be 'yes' or 'no', but is '" + string + "'");
    }

    private String getMethodValue(String string) {
        if (string == null) {
            return METHOD_DEFAULT;
        }
        int n = OutputFormat.getIndex(METHOD_NAMES, string);
        if (n != -1) {
            return METHOD_NAMES[n];
        }
        throw new XsltException("unsupported output method '" + string + "'");
    }

    private static int getIndex(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

